      SUBROUTINE M_VTIM(CTIMIN,IDATE,ITIME)
C
C-----------------------------------------------------------------------
C
C     Converts a CHAR*23 Vax time to DATE (YYMMDD) and TIME (HHMMSS)
C
C     Called by MN_CDF
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      CHARACTER*(*) CTIMIN
      INTEGER IDATE,ITIME
C
#if ( defined(VMS) )
      INTEGER LIB$CONVERT_DATE_STRING
     + ,LIB$SYS_GETMSG
     + ,LIB$FORMAT_DATE_TIME
C
      INTEGER*2 ITIMVAX(4)
      INTEGER*2 LEN
      INTEGER ISTAT,LENT
      CHARACTER*80 MESSAGE
#endif
#if ( !defined(VMS) )
      INTEGER LENT, LENOCC
      INTEGER N1
#endif

C
      CHARACTER*23 CTIME
      INTEGER I,IOERR,NYEAR,NMONTH,NDAY,NHOUR,NMIN,NSEC
      CHARACTER*3 TMONTH(12)
      DATA TMONTH/'JAN','FEB','MAR','APR','MAY','JUN'
     +           ,'JUL','AUG','SEP','OCT','NOV','DEC'/
C
      IDATE = 0
      ITIME = 0
C
C     Make sure the time is really CHAR*23
C
#if ( defined(VMS) )
      ISTAT = LIB$CONVERT_DATE_STRING(CTIMIN,ITIMVAX)
      IF(.NOT.ISTAT) THEN
          ISTAT = LIB$SYS_GETMSG(ISTAT,LEN,MESSAGE)
          CALL M_EMSG('M_VTIM',MESSAGE(1:LEN))
      ENDIF
      ISTAT = LIB$FORMAT_DATE_TIME(CTIME,ITIMVAX,,LENT)
      IF(.NOT.ISTAT) THEN
          ISTAT = LIB$SYS_GETMSG(ISTAT,LEN,MESSAGE)
          CALL M_EMSG('M_VTIM',MESSAGE(1:LEN))
      ENDIF
#endif
#if ( !defined(VMS) )
      N1 = INDEX(CTIMIN,'-')
      IF(N1.LT.1 .OR. N1.GT.4) GOTO 9000
      LENT = LENOCC(CTIMIN)
      CTIME(4-N1:) = CTIMIN(1:LENT)
#endif

C
      DO 1000 I=1,12
          IF(CTIME(4:6).EQ.TMONTH(I)) THEN
              NMONTH = I
              GOTO 1100
          ENDIF
1000  CONTINUE
      GOTO 9000
1100  CONTINUE
C
      READ(CTIME(1:2),'(I2)',IOSTAT=IOERR) NDAY
      READ(CTIME(10:11),'(I2)',IOSTAT=IOERR) NYEAR
C
      READ(CTIME(13:14),'(I2)') NHOUR
      READ(CTIME(16:17),'(I2)') NMIN
      READ(CTIME(19:20),'(I2)') NSEC
C
      IDATE = NYEAR*10000 + NMONTH*100 + NDAY
      ITIME = NHOUR*10000 + NMIN*100   + NSEC
C
9000  CONTINUE
C
      END
