      SUBROUTINE cleo_MESLOG( CRNAME, IMES, CSEVER )
C.......................................................................
C.
C. MESLOG - Log a message
C.
C. Inputs    : CRNAME - Name of calling routine
C.           : IERR   - Message number
C.           : CSEVER - Severity
C. Outputs   : None
C.
C. COMMON    : MESBUF MESREP
C. Calls     : MESINI MESPUT
C. Called    : <USER>
C.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      CHARACTER*(*) CRNAME, CSEVER
      INTEGER IMES
C
C------------------------- EXTERNAL declarations -----------------------
C
      INTEGER  LENOCC
      EXTERNAL LENOCC
C
C------------------------- SEQUENCE declarations -----------------------
C
*
* MSSUCC - Message severity is SUCCESS
* MSINFO - Message severity is INFORMATION
* MSWARN - Message severity is WARNING
* MSERRO - Message severity is ERROR
* MSFATA - Message severity is FATAL
* CHMESS - Text of current message
*
      CHARACTER*(*) MSSUCC,             MSINFO
      PARAMETER(    MSSUCC = 'SUCCESS', MSINFO = 'INFORMATION' )
      CHARACTER*(*) MSWARN,             MSERRO
      PARAMETER(    MSWARN = 'WARNING', MSERRO = 'ERROR'       )
      CHARACTER*(*) MSFATA
      PARAMETER(    MSFATA = 'FATAL'                           )
*
      CHARACTER*132   CHMESS
      COMMON /MESREP/ CHMESS
*
*
* CHMBUF - Text to put to output unit
*
      CHARACTER*132   CHMBUF
      COMMON /MESBUF/ CHMBUF
*
C
C------------------------- Local    declarations -----------------------
C
      INTEGER     CRLEN
      LOGICAL     LFIRST
C
C------------------------- SAVE     declarations -----------------------
C
      SAVE        LFIRST
C
C------------------------- DATA  initializations -----------------------
C
      DATA        LFIRST /.TRUE./
C
C---------------------- Executable code starts here --------------------
C
*
      IF( LFIRST ) THEN
         LFIRST = .FALSE.
         CALL CLEO_MESINI
      ENDIF
*
      CRLEN  = MIN( LENOCC(CRNAME), 8 )
      CHMBUF = ' '//CRNAME(1:CRLEN)//'-'//CSEVER(1:1)//'-'//CHMESS
C
      CALL CLEO_MESPUT(0,0)
C
      RETURN
      END
