<?php
/**
 * $Horde: mnemo/prefs.php,v 1.1.2.6 2005/01/03 11:25:59 jan Exp $
 *
 * Copyright 2002-2005 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}

function handle_category_management($updated)
{
    global $prefs;

    $actionID = Horde::getFormData('managementActionID');
    $categoryID = Horde::getFormData('category_id');
    $categoryName = Horde::getFormData('category_name');
    $newcolors = Horde::getFormData('newColors');

    /* Always save colors. */
    $memo_colors = '';
    foreach ($newcolors as $key => $color) {
        $memo_colors .= (empty($memo_colors)) ? "$key:$color" : "|$key:$color";
    }
    $prefs->setValue('memo_colors', $memo_colors);

    switch ($actionID) {
        case MNEMO_DELETE_CATEGORY:
            Mnemo::deleteCategory($categoryID);
            break;

        case MNEMO_RENAME_CATEGORY:
            Mnemo::renameCategory($categoryID, $categoryName);
            break;

        case MNEMO_ADD_CATEGORY:
            Mnemo::addCategory($categoryName);
            break;

        default:
            /* Must have been the Save button. */
            $update = true;
            return true;
    }

    /* Return false so it stays on this page. */
    return false;
}

function prefs_callback()
{
    global $prefs, $js_onLoad;

    if ($prefs->isDirty('language')) {
        $js_onLoad = 'if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();';
    }
}

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require MNEMO_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

if (PrefsUI::handleForm($group)) {
    $group = null;
    include MNEMO_BASE . '/config/prefs.php';
}

$title = _("User Options");
require MNEMO_TEMPLATES . '/common-header.inc';
require MNEMO_BASE . '/menu.php';
$notification->notify();

PrefsUI::generateUI($group);

$registry->shutdown();
require MNEMO_TEMPLATES . '/common-footer.inc';
