<?php
$memourl = Util::addParameter('memo.php', array('memo' => $memo_id,
                                                'memolist' => $memolist_id));

$share = $GLOBALS['mnemo_shares']->getShare($memolist_id);
?>
<table border="0" cellpadding="2" cellspacing="0" width="100%">
<tr>
  <td align="left" class="header"><b><?php echo _("Note Details") ?></b></td>
</tr>
</table>

<table border="0" cellpadding="2" cellspacing="0" width="100%" class="item">
<tr>
  <td class="control" nowrap="nowrap" align="right"><b><?php echo _("Category") ?></b>&nbsp;</td>
  <td class="control" nowrap="nowrap"><?php echo htmlspecialchars($memo['category'] ? $memo['category'] : _("Unfiled")) ?></td>
  <td class="control" width="100%">&nbsp;</td>
  <td class="control" nowrap="nobr" align="right">
    <?php if (!$print_view) : ?>
    <?php if ($share->hasPermission(Auth::getAuth(), PERMS_EDIT)): ?>
      <?php echo Horde::widget(Horde::applicationUrl(Util::addParameter($memourl, 'actionID', 'modify_memo')), _("Edit"), 'widget', '', '', _("_Edit")) ?>
      |
    <?php endif; ?>
    <?php if ($share->hasPermission(Auth::getAuth(), PERMS_DELETE)): ?>
      <?php echo Horde::widget(Horde::applicationUrl(Util::addParameter($memourl, 'actionID', 'delete_memos')), _("Delete"), 'widget', '', '', _("_Delete")) ?>
      |
    <?php endif; ?>
    <?php echo Horde::widget(Horde::applicationUrl('list.php'), _("Back to Notepad"), 'widget', '', '', _("_Back to Notepad")) ?>&nbsp;&nbsp;
    <?php endif; ?>
  </td>
</tr>

<?php if (isset($created)): ?>
<tr>
  <td nowrap="nowrap" align="right"><b><?php echo _("Created") ?></b>&nbsp;</td>
  <td nowrap="nowrap"><?php echo strftime($prefs->getValue('date_format'), $created) . ' ' . date($prefs->getValue('twentyFour') ? 'G:i' : 'g:i a', $created) ?></td>
  <td colspan="2">&nbsp;</td>
</tr>
<?php endif; ?>

<?php if (isset($modified)): ?>
<tr>
  <td nowrap="nowrap" align="right"><b><?php echo _("Last Modified") ?></b>&nbsp;</td>
  <td nowrap="nowrap"><?php echo strftime($prefs->getValue('date_format'), $modified) . ' ' . date($prefs->getValue('twentyFour') ? 'G:i' : 'g:i a', $modified) ?></td>
  <td colspan="2">&nbsp;</td>
</tr>
<?php endif; ?>

</table>

<table width="100%" cellspacing="0" class="text"><tr><td>
<p class="fixed"><?php echo Text_Filter::filter($memo['body'], 'text2html', array('parselevel' => TEXT_HTML_MICRO)) ?></p>
</td></tr></table>

<?php if (!$print_view) : ?>
<table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr>
  <td class="control" nowrap="nobr" align="right">
    <?php if ($share->hasPermission(Auth::getAuth(), PERMS_EDIT)): ?>
      <?php echo Horde::widget(Horde::applicationUrl(Util::addParameter($memourl, 'actionID', 'modify_memo')), _("Edit"), 'widget', '', '', _("_Edit"), true) ?>
      |
    <?php endif; ?>
    <?php if ($share->hasPermission(Auth::getAuth(), PERMS_DELETE)): ?>
      <?php echo Horde::widget(Horde::applicationUrl(Util::addParameter($memourl, 'actionID', 'delete_memos')), _("Delete"), 'widget', '', '', _("_Delete"), true) ?>
      |
    <?php endif; ?>
    <?php echo Horde::widget(Horde::applicationUrl('list.php'), _("Back to Notepad"), 'widget', '', '', _("_Back to Notepad"), true) ?>&nbsp;&nbsp;
  </td>
</tr>
</table>
<br />
<?php endif; ?>
