<?

// -----------------------------------------------
// exit_local()
// -----------------------------------------------
function exit_local($print_err = 1) {
    drop_temp_table($print_err);
    exit;
}

// -----------------------------------------------
// print_error_local($str)
// -----------------------------------------------
function print_error_local($str){
    global $error;
    
    $error=$str;

    print_template('error');
    print_template('bottom');
    
    exit_local(0);
}

// -----------------------------------------------
// get_dict_tab(word)
// -----------------------------------------------
function get_dict_tab($word) {
   global $dict_table;

   if (strlen($word)>16) return $dict_table[17];
   return $dict_table[strlen($word)];
}

// -----------------------------------------------
// is_stopword($word)
// -----------------------------------------------
function is_stopword($word) {
    global $DEBUG;
    global $stopword_arr;

    if ($stopword_arr[$word]) return ($stopword_arr[$word]);
    
    $query="SELECT count(*) FROM stopword WHERE word='$word'";
    if($DEBUG) echo "is_stopword(): ",$query,"<BR><HR>";

    if (!($res=db_query($query))) print_error_local('Query error: '.$query."\n<BR>".db_error());
  
    $row=db_fetchrow($res);
    db_freeresult($res);

    $stopword_arr[$word]=$row[0];

    return ($row[0]);
} 

// -----------------------------------------------
// drop_temp_table()
// -----------------------------------------------
function drop_temp_table($print_err) {
    global $temp_table;
    global $DEBUG;
    global $error;
    
    if ($temp_table != "") {
       $drop_temp_query="DROP TABLE $temp_table";
       if($DEBUG) echo "drop_temp_table(): ",$drop_temp_query,"<BR><HR>";

       if (!db_query($drop_temp_query)) {           
           if (! $print_err) {
               print('Query error: '.$drop_temp_query."\n<BR>".db_error());
	   } else {
	       $error='Query error: '.$drop_temp_query."\n<BR>".db_error();
	       print_template('error');
               print_template('bottom');
	   }       
           exit();     
       }
    }
}

// -----------------------------------------------
// track_query($query,$time,$found)
// -----------------------------------------------
function track_query($query,$time,$found) {
	global $trackquery;
        global $DEBUG;

	if ($trackquery != 'yes') return;

	$q="INSERT INTO qtrack VALUES ( '$query', $time, $found)";
        if($DEBUG) echo "track_query(): ",$q,"<BR><HR>";
                         
	if (!db_query($q)) print('Query error: '.$q."\n<BR>".db_error());
}

// -----------------------------------------------
// format_lastmod($lastmod)
// -----------------------------------------------
function format_lastmod($lastmod) {
	global $db_format;

	$temp=$lastmod;
	if ($db_format == '3.1') {
		if (!$temp) $temp = 'undefined';
		else $temp = strftime('%a, %d %b %Y %H:%M:%S %Z',$temp);
	} else {
		if ($temp == '') $temp = 'undefined';
	}

	return $temp;
}

// -----------------------------------------------
// format_dp($dp)
// -----------------------------------------------
function format_dp($dp) {
	$result=0;

	while ($dp != '') {		
		if (preg_match('/^([\-\+]?\d+)([sMhdmy]?)/',$dp,$param)) {			
			switch ($param[2]) {
				case 's':  $multiplier=1; break;
                                case 'M':  $multiplier=60; break;
                                case 'h':  $multiplier=3600; break;
                                case 'd':  $multiplier=3600*24; break;
                                case 'm':  $multiplier=3600*24*31; break;
                                case 'y':  $multiplier=3600*24*365; break;
				default: $multiplier=1;
			}

			$result += $param[1]*$multiplier;
                        $dp=preg_replace("/^[\-\+]?\d+$param[2]/",'',$dp);
		} else {
			return 0;
		}
	}

	return $result;
}

// -----------------------------------------------
// format_userdate($date)
// -----------------------------------------------
function format_userdate($date) {
	$result=0;

	if (preg_match('/^(\d+)\/(\d+)\/(\d+)$/',$date,$param)) {
		$day=$param[1];
		$mon=$param[2];
		$year=$param[3];

		$result=mktime(0,0,0,$mon,$day,$year);
	}

	return $result;
}

// -----------------------------------------------
// load_cs($cat)
// -----------------------------------------------
function load_cs($cat) {
	global $DEBUG;
	global $self;

        $query="SELECT path,link,name
                  FROM categories
                 WHERE path LIKE '$cat"."__'
                 ORDER BY NAME ASC";

        if($DEBUG) echo "load_cs(): ",$query,"<BR><HR>";
                         
	if (!($res=db_query($query))) print('Query error: '.$query."\n<BR>".db_error());

	while($row=db_fetchrow($res)) {
		$path=$row[0];
		$link=$row[1];
		$name=$row[2];

		if (substr($path,strlen($path)-2,2)=='@@') {
			$result .= "<a href=\"$self?cat=$link\">@ $name</a><br>\n";
		} else {
			$result .= "<a href=\"$self?cat=$path\">$name</a><br>\n";
		}
	}
	db_freeresult($res);

	return $result;
}

// -----------------------------------------------
// load_cp($cat)
// -----------------------------------------------
function load_cp($cat) {
	global $DEBUG;
	global $self;
	global $cp_arr;

        if ($cp_arr[$cat]) return ($cp_arr[$cat]);

   	$link_path=$cat;
   	$link_name='';

   	while ($link_path!='') {
   		$query="SELECT name FROM categories WHERE path='$link_path'";
		
		if($DEBUG) echo "load_cp(): ",$query,"<BR><HR>";	

                if (!($res=db_query($query))) {
   			print_error_local('Query error: '.$query."\n<BR>".db_error());
   		}

   		$row=db_fetchrow($res);
   		db_freeresult($res);

   		if (!$row) {
   			$link_path=substr($link_path,0,strlen($link_path)-2);
   			continue;
   		}

   		$row[0]=htmlspecialchars($row[0]);

   		$link_name = " > <a href=\"$self?cat=$link_path\">$row[0]</a>".$link_name;

   		$link_path=substr($link_path,0,strlen($link_path)-2);
   	}

   	$query="SELECT name FROM categories WHERE path='' OR path IS NULL";

	if($DEBUG) echo "load_cp(): ",$query,"<BR><HR>";	

        if (!($res=db_query($query))) {
  		print_error_local('Query error: '.$query."\n<BR>".db_error());
  	}

  	$row=db_fetchrow($res);
  	db_freeresult($res);

  	if ($row) {
  		$row[0]=htmlspecialchars($row[0]);	
  		$link_name = " > <a href=\"$self?cat=\">$row[0]</a>".$link_name;
  	} else {
  		$link_name='';
  	}

        $cp_arr[$cat]=$link_name;

   	return $link_name;
}


// -----------------------------------------------
// get_micro_time()
// -----------------------------------------------
function get_micro_time() {	
	if (function_exists('microtime')) {
		$result=microtime();
		if (ereg('([0-9\.\,]+) +([0-9]+)',$result,$param)) {
			$result=$param[2]+$param[1];
		} 
	} else {
		$result=time();
	}
	return $result;
}

// -----------------------------------------------
// suggest_soundex($word)
// -----------------------------------------------
function suggest_soundex($word) {
	global $DEBUG;
	global $soundex_words;
        global $all_words;

        global $ps,$o,$m,$cat,$dt, $dp, $dx, $dm, $dy, $dd, $db, $de;
   	global $ul_local,$ue_local,$t_local,$db_local,$de_local,$lang_local;
        
        if (preg_match('/\d/',$word)) return '';

        $sdx = soundex($word);
        if($DEBUG) echo "suggest_soundex($word): sdx=$sdx<BR>\n";	

	if ($sdx == '0000') return '';
        
        $query="SELECT word FROM soundex WHERE soundex='$sdx'";
		
	if($DEBUG) echo "suggest_soundex($word): ",$query,"<BR><HR>\n";	

        if (!($res=db_query($query))) {
   		print_error_local('Query error: '.$query."\n<BR>".db_error());
   	}

        if($DEBUG) echo "suggest_soundex($word): words found: ";
   	while ($row=db_fetchrow($res)) {
   		$word=$row[0];

                if ($soundex_words[$word]) continue;

   		$flag=0;
   		for($i=0; $i<count($all_words); $i++) {
   			if ($all_words[$i] == $word) { 
   				$flag=1;
   				break;
   			}
   		}
   		if ($flag) continue;   		

   		$soundex_words[$word] = 1;

                if($DEBUG) echo "$word ";
                $word_local=urlencode($word);
   		$result .= "<a href=\"$PHP_SELF?q=$word_local&m=$m".
                		($ps==20?'':"&ps=$ps").
 		                ($t==''?'':"&t=$t_local").
                		($ul==''?'':"&ul=$ul_local").
		                ($ue==''?'':"&ue=$ue_local").
		                (!$o?'':"&o=$o").
		                ($dt=='back'?'':"&dt=$dt").
		                (!$dp?'':"&dp=$dp").
		                (!$dx?'':"&dx=$dx").
		                ($dd=='01'?'':"&dd=$dd").
		                (!$dm?'':"&dm=$dm").
		                ($dy=='1970'?'':"&dy=$dy").
		                ($db=='01/01/1970'?'':"&db=$db_local").
		                ($de=='31/12/2020'?'':"&de=$de_local").
		                ($cat==''?'':"&cat=$cat").
		                ($lang==''?'':"&lang=$lang_local").
   			   	"\">$word</a> ";
   	}
        if($DEBUG) echo "<br>";

        db_freeresult($res);

        return $result;

}

?>
