/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef   HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "udmsearch.h"
#include "udm_xmalloc.h"

/* This should be last include */
#ifdef DMALLOC
#include "dmalloc.h"
#endif


/******************** Misc functions *********************************/

static void ParseQStringUnescaped(UDM_VARLIST *vars, const char *qstring){
	char *tok, *lt; 
	char *qs = (char*)strdup(qstring);

	if (qs != NULL) {
	  UdmSGMLUnescape(qs);
	  tok = udm_strtok_r(qs, "&", &lt);
	  while(tok){
	        char *arg=strchr(tok,'=');
		if(arg)*arg++='\0';
		UdmVarListAddStr(vars,tok,arg?arg:"");
		tok = udm_strtok_r(NULL, "&", &lt);
	  }
	  free(qs);
	}
}

static char * BuildPageURL(UDM_VARLIST * vars, char **dst) {
	size_t i, nargs = 0, dstlen = 0;
	char * end;

	for(i = 0; i < vars->nvars; i++) {
	  dstlen += 7 + strlen(vars->Var[i].name) + strlen(vars->Var[i].val);
	}
	*dst = (char*)realloc(*dst, dstlen);
	if (*dst == NULL) return NULL;
	end = *dst;

	for(i=0;i<vars->nvars;i++){
		strcpy(end, nargs ? "&amp;" : "?");
		end += nargs ? 5 : 1;
		strcpy(end,vars->Var[i].name);
			
		end=end+strlen(end);
		strcpy(end,"=");end++;
		strcpy(end,vars->Var[i].val);
			
		end=end+strlen(end);
		nargs++;
	}
	return NULL;
}

/*****************************************************************/

static int WordInfo(UDM_ENV *Env, UDM_RESULT *Res){ 
	size_t	len, i, j, wsize;
	char	*wordinfo = NULL;
	size_t	corder = (size_t)-1, ccount = 0;
	
	for(len = i = 0; i < Res->WWList.nwords; i++) 
		len += Res->WWList.Word[i].len;
	
	wsize=(1+len*15)*sizeof(char);
	wordinfo = (char*) malloc(wsize);
	*wordinfo = '\0';
	
	for(i = 0; i < Res->WWList.nwords; i++){
		if ((Res->WWList.Word[i].count > 0) || (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_QUERY)) {
			if(wordinfo[0]) strcat(wordinfo,", ");
			sprintf(UDM_STREND(wordinfo)," %s : %d", Res->WWList.Word[i].word, Res->WWList.Word[i].count);
		} else if (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_STOP) {
			if(wordinfo[0]) strcat(wordinfo,", ");
			sprintf(UDM_STREND(wordinfo)," %s : stopword", Res->WWList.Word[i].word);
		}
	}
	
	UdmVarListAddStr(&Env->Vars, "WE", wordinfo);
	
	*wordinfo = '\0';
	for(i = 0; i < Res->WWList.nwords; i++) {
	  corder = Res->WWList.Word[i].order;
	  ccount = 0;
	  for(j = 0; j < Res->WWList.nwords; j++) {
		if (Res->WWList.Word[j].order == corder) {
			ccount += Res->WWList.Word[j].count;
		}
	  }
	  if (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_STOP) {
		  sprintf(UDM_STREND(wordinfo),"%s%s : stopword", (*wordinfo) ? ", " : "",  Res->WWList.Word[i].word);
	  } else if (Res->WWList.Word[i].origin == UDM_WORD_ORIGIN_QUERY) {
		  sprintf(UDM_STREND(wordinfo),"%s%s : %d", (*wordinfo) ? ", " : "", Res->WWList.Word[i].word, Res->WWList.Word[i].count);
	  } else continue;
	  sprintf(UDM_STREND(wordinfo)," / %d", ccount);
	}
	
	UdmVarListAddStr(&Env->Vars, "W", wordinfo);
	UDM_FREE(wordinfo);
	return UDM_OK;
}
	

/*****************************************************************/

int main(int argc, char ** argv){
	const char	*env, *bcharset, *lcharset;
	char		template_name[1024]="";
	char            *template_filename = NULL;
	char		*query_string = NULL;
	char		self[1024]="";
	char		*nav = NULL;
	char		*url = NULL;
	char		search_time[100]="";
	char		*searchwords=NULL;
	char		*storedstr=NULL;
	int		res,httpd=0;
	size_t          catcolumns = 0;
	ssize_t		page1,page2,npages,ppp=10;
	int		page_size,page_number;
	size_t		i, swlen = 0, nav_len, ExcerptSize, storedlen;
	UDM_ENV		*Env;
	UDM_AGENT	*Agent;
	UDM_RESULT	*Res;
	UDM_VARLIST	query_vars;
	UDM_VARLIST	tmpl;
	
	/* Output Content-type if under HTTPD	 */
	/* Some servers do not pass QUERY_STRING */
	/* if the query was empty, so check	 */
	/* REQUEST_METHOD too     to be safe     */
	
	httpd=(getenv("QUERY_STRING")||getenv("REQUEST_METHOD"));
	
	UdmInit();
	Env=UdmEnvInit(NULL);
	UdmVarListInit(&tmpl);
	UdmVarListInit(&query_vars);
	Agent = UdmAgentInit(NULL, Env, 0);
	UdmVarListAddEnviron(&Env->Vars,"ENV");
	
	/* Detect self and template name */
	if((env=getenv("UDMSEARCH_TEMPLATE")))
		strncpy(template_name,env,sizeof(template_name)-1);
	
	if((env=getenv("UDMSEARCH_SELF")))
		strncpy(self,env,sizeof(self)-1);
	
	if((env=getenv("QUERY_STRING"))){
	        query_string = (char*)realloc(query_string, strlen(env) + 2);
		strncpy(query_string, env, strlen(env) + 1);

		/* Hack for Russian Apache from apache.lexa.ru  */
		/* QUERY_STRING is already converted to server  */
		/* character set. We must print original query  */
		/* string instead however. Under usual apache   */ 
		/* we'll use QUERY_STRING. Note that query_vars */
		/* list will contain not unescaped values, so   */
		/* we don't have to escape them when displaying */
		env = getenv("CHARSET_SAVED_QUERY_STRING");
		ParseQStringUnescaped(&query_vars,env?env:query_string);
	
		/* Unescape and save variables from QUERY_STRING */
		/* Env->Vars will have unescaped values however  */
		UdmParseQueryString(Agent,&Env->Vars,query_string);
	
		template_filename = (char*)strdup(UdmVarListFindStr(&Env->Vars, "tmplt", ""));
	
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */
			if(!self[0]){
				strncpy(self,(env=getenv("REDIRECT_URL"))?env:"search.cgi",sizeof(self)-1);
			}
			if(!template_name[0]){
				strncpy(template_name,(env=getenv("PATH_TRANSLATED"))?env:"",sizeof(template_name)-1);
			}
			if (strlen(template_filename) == 0) { template_filename = (char*)strdup("search.htm"); }
		}else{
			/* CGI executed without Apache internal redirect */

			/* Detect $Self variable with OS independant SLASHES */
			if(!self[0]){
				strncpy(self,(env=getenv("SCRIPT_NAME"))?env:"search.cgi",sizeof(self)-1);
			}

			if(!template_name[0]){
				char *s,*e;
				
				/*This is with OS specific SLASHES */
				env=((env=getenv("SCRIPT_FILENAME"))?env:"search.cgi");

				if(strcmp(UDM_CONF_DIR,".")){
					/* Take from the config directory */
					udm_snprintf(template_name, sizeof(template_name)-1, "%s/%s", 
						     UDM_CONF_DIR,(s=strrchr(env,UDMSLASH))?(s+1):(self));
				}else{
					/* Take from the current directory */
					strncpy(template_name,env,sizeof(template_name)-1);
				}

				/* Find right slash if it presents */
				s=((s=strrchr(template_name,UDMSLASH))?s:template_name);

				if (strlen(template_filename) == 0) {

				  /* Find .cgi substring */
				  if ((e = strstr(s, ".cgi")) != NULL) {
					/* Replace ".cgi" with ".htm" */
					e[1]='h';e[2]='t';e[3]='m';
				  } else {
				        strcat(s, ".htm");
				  }
				  e = strrchr(s, '/');
				  template_filename = (char*)strdup(e + 1);
				} else {
				  strncpy(s + 1, template_filename, sizeof(template_name) - (s - template_name) - 2);
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which does not */
		/* pass an empty QUERY_STRING var */
		if(argv[1]) {
		  query_string = (char*)realloc(query_string, strlen(argv[1]) + 10);
		  sprintf(query_string, "q=%s", argv[1]);
		} else {
		  query_string = (char*)realloc(query_string, 1024);
		  sprintf(query_string, "q=");
		}

		/* Hack for Russian Apache from apache.lexa.ru  */
		/* QUERY_STRING is already converted to server  */
		/* character set. We must print original query  */
		/* string instead however. Under usual apache   */ 
		/* we'll use QUERY_STRING. Note that query_vars */
		/* list will contain not unescaped values, so   */
		/* we don't have to escape them when displaying */
		env = getenv("CHARSET_SAVED_QUERY_STRING");
		ParseQStringUnescaped(&query_vars,env?env:query_string);
	
		/* Unescape and save variables from QUERY_STRING */
		/* Env->Vars will have unescaped values however  */
		UdmParseQueryString(Agent,&Env->Vars,query_string);

		template_filename = (char*)strdup(UdmVarListFindStr(&Env->Vars, "tmplt", ""));
		if (strlen(template_filename) == 0) { UDM_FREE(template_filename); template_filename = (char*)strdup("search.htm"); }
	
		if(!template_name[0]) udm_snprintf(template_name,sizeof(template_name),"%s/%s", UDM_CONF_DIR, template_filename);
	}
	
	UdmVarListReplaceStr(&Agent->Conf->Vars, "tmplt", template_filename);
	UDM_FREE(template_filename);
	
	if((res=UdmTemplateLoad(Env,&Env->Vars,template_name,&tmpl))){
		if(httpd)printf("Content-Type: text/plain\r\n\r\n");
		printf("%s\n",Env->errstr);
		UdmVarListFree(&tmpl);
		UdmEnvFree(Env);
		return(0);
	}
	
	/* Call again to load search Limits if need */
	UdmParseQueryString(Agent, &Env->Vars, query_string);
	UdmSetLogLevel(NULL, UdmVarListFindInt(&Env->Vars, "LogLevel", 0));
	UdmOpenLog("search.cgi", Env, !strcasecmp(UdmVarListFindStr(&Env->Vars, "Log2stderr", (!httpd) ? "yes" : "no"), "yes"));
	UdmLog(Agent,UDM_LOG_ERROR,"search.cgi started with '%s'",template_name);
	
	/* This is for query tracking */
	UdmVarListAddStr(&Env->Vars,"QUERY_STRING",query_string);
	UdmVarListAddStr(&Env->Vars,"self",self);
	env = getenv("REMOTE_ADDR");
	UdmVarListAddStr(&Env->Vars, "IP", env?env:"");
	
	bcharset=UdmVarListFindStr(&Env->Vars,"BrowserCharset","iso-8859-1");
	Env->bcs=UdmGetCharSet(bcharset);
	lcharset=UdmVarListFindStr(&Env->Vars,"LocalCharset","iso-8859-1");
	Env->lcs=UdmGetCharSet(lcharset);
	ppp=UdmVarListFindInt(&Env->Vars,"PagesPerScreen",10);
	
	if(httpd){
		if(!Env->bcs){
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		}else if(!Env->lcs){
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}else{
			printf("Content-type: text/html; charset=%s\r\n\r\n",bcharset);
		}
	}else{
		if(!Env->bcs){
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		}
		if(!Env->lcs){
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}
	}
	
	/* These parameters taken from "variable section of template"*/
	
	res=UdmVarListFindInt(&Env->Vars,"np",0)*UdmVarListFindInt(&Env->Vars,"ps",20);
	UdmVarListAddInt(&Env->Vars,"pn",res);
	
	catcolumns = (size_t)atoi(UdmVarListFindStr(&Env->Vars,"CatColumns",""));
	
	if(catcolumns){
		UDM_CATEGORY C;
		
		bzero((void*)&C, sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
		if(UDM_OK == UdmCatAction(Agent, &C, UDM_CAT_ACTION_LIST)){
			size_t n=1, l = 0;
			char *catlist = NULL;
			
			for(i = 0; i < C.ncategories; i++) l += 128 + strlen(C.Category[i].path) + strlen(C.Category[i].name);
			if (l > 0) catlist = (char*)malloc(l);
			if (catlist != NULL) {
			  sprintf(catlist, "<table>\n");
			  for(i = 0; i < C.ncategories; i++){
				if(n==1){
					sprintf(catlist+strlen(catlist),"<tr>\n");
				}
				sprintf(catlist+strlen(catlist),"<td><a href=\"?cat=%s\">%s</A></td><td width=60>&nbsp;</td>\n",
						C.Category[i].path,
						C.Category[i].name);
				if(n==catcolumns){
					sprintf(catlist+strlen(catlist),"</tr>\n");
					n=1;
				}else{
					n++;
				}
			  }
			  sprintf(catlist + strlen(catlist), "</table>\n");
			  UdmVarListAddStr(&Env->Vars, "CS", catlist);
			  UDM_FREE(catlist);
			}
		}else{
			UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
			UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
			UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
			goto end;
		}

		UDM_FREE(C.Category);
		bzero((void*)&C, sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
		if(UDM_OK == UdmCatAction(Agent, &C, UDM_CAT_ACTION_PATH)){
			char *catpath = NULL;
			size_t l = 0;
			
			for(i = 0; i < C.ncategories; i++) l += 32 + strlen(C.Category[i].path) + strlen(C.Category[i].name);
			catpath = (char*)malloc(l);
			if (catpath != NULL) {
			  catpath[0] = '\0';
			  for(i = 0; i < C.ncategories; i++){
				sprintf(catpath+strlen(catpath),"/<a href=\"?cat=%s\">%s</A>",
					(C.Category[i].path) ? C.Category[i].path : "",
					(C.Category[i].name) ? C.Category[i].name : "");
			  }
			  UdmVarListAddStr(&Env->Vars, "CP", catpath);
			  UDM_FREE(catpath);
			}
		}else{
			UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
			UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
			UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
			goto end;
		}
		UDM_FREE(C.Category);
	}
	
	if(NULL==(Res=UdmFind(Agent))){
		UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
		if (Res != NULL) goto freeres;
		goto end;
	}
	
	UdmVarListAddInt(&Env->Vars,"first",(int)Res->first);
	UdmVarListAddInt(&Env->Vars,"last",(int)Res->last);
	UdmVarListAddInt(&Env->Vars,"total",(int)Res->total_found);
	sprintf(search_time,"%.3f",((double)Res->work_time)/1000);
	UdmVarListAddStr(&Env->Vars,"SearchTime",search_time);
	WordInfo(Env,Res);
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
	
	if(!Res->WWList.nwords){
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "noquery");
		goto freeres;
	}
	
	if(!Res->num_rows){
		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "notfound");
		goto freeres;
	}
	
	page_size   = UdmVarListFindInt(&Agent->Conf->Vars,"ps",20);
	page_number = UdmVarListFindInt(&Agent->Conf->Vars,"np",0);
	
	for (i = 0; i < Res->WWList.nwords; i++) {
		swlen += (8 * Res->WWList.Word[i].len) + 2;
	}
	if ((searchwords = UdmXmalloc(swlen)) != NULL) {
		int z=0;
		for (i = 0; i < Res->WWList.nwords; i++) {
			if (Res->WWList.Word[i].count > 0) {
				sprintf(UDM_STREND(searchwords), (z)?"+%s":"%s", Res->WWList.Word[i].word);
				z++;
			}
		}
	}
	storedstr = realloc(storedstr, storedlen = 1024 + 10 * swlen );
	
	npages=(Res->total_found/(page_size?page_size:20)) + ((Res->total_found % (page_size?page_size:20) != 0 ) ?  1 : 0);
	page1=page_number-ppp/2;
	page2=page_number+ppp/2;
	if(page1<0){
		page2-=page1;
		page1=0;
	}else
	if(page2>npages){
		page1-=(page2-npages);
		page2=npages;
	}
	if(page1<0)page1=page1=0;
	if(page2>npages)page2=npages;
	nav = (char *)realloc(nav, nav_len = (size_t)(page2 - page1 + 2) * (1024 + 1024)); 
	                                                    /* !!! 1024 - limit for navbar0/navbar1 template size */ 
	nav[0] = '\0';
	
	/* build NL NB NR */
	for(i = (size_t)page1; i < (size_t)page2; i++){
		UdmVarListReplaceInt(&query_vars,"np",(int)i);
		BuildPageURL(&query_vars, &url);
		UdmVarListReplaceStr(&Env->Vars,"NH",url);
		UdmVarListReplaceInt(&Env->Vars,"NP",(int)(i+1));
		UdmTemplatePrint(Agent, NULL, UDM_STREND(nav), nav_len - (nav - UDM_STREND(nav)), &Env->Vars,&tmpl,
				 (i == (size_t)page_number)?"navbar0":"navbar1");
	}
	UdmVarListAddStr(&Env->Vars,"NB",nav);
	
	UdmVarListReplaceInt(&query_vars,"np",page_number-1);
	BuildPageURL(&query_vars, &url);
	UdmVarListReplaceStr(&Env->Vars,"NH",url);
	
	if(Res->first==1){/* First page */
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft_nop");
		UdmVarListReplaceStr(&Env->Vars,"NL",nav);
	}else{
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft");
		UdmVarListReplaceStr(&Env->Vars,"NL",nav);
	}
	
	UdmVarListReplaceInt(&query_vars,"np",page_number+1);
	BuildPageURL(&query_vars, &url);
	UdmVarListReplaceStr(&Env->Vars,"NH",url);
	
	UdmVarListReplaceInt(&query_vars, "np", 0);
	UdmVarListDel(&query_vars, "s");
	BuildPageURL(&query_vars, &url);
	UdmVarListReplaceStr(&Env->Vars, "FirstPage", url);

	if(Res->last>=Res->total_found){/* Last page */
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright_nop");
		UdmVarListReplaceStr(&Env->Vars,"NR",nav);
	}else{
		UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright");
		UdmVarListReplaceStr(&Env->Vars,"NR",nav);
	}
	
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars,&tmpl, "restop");
	
	ExcerptSize = (size_t)UdmVarListFindInt(&Env->Vars, "ExcerptSize", 256);
	
	for(i=0;i<Res->num_rows;i++){
		UDM_DOCUMENT	*Doc=&Res->Doc[i];
		UDM_CATEGORY	C;
		UDM_MATCH	*Alias;
		char		*aliastr;
		char		*alcopy;
		char		*clist;
		const char	*u, *dm;
		char		*eu, *edm, *Excerpt;
		size_t		cl,sc, clistsize;
		const char	*al;
		urlid_t		dc_url_id = (urlid_t)UdmVarListFindInt(&Doc->Sections, "ID", 0);
		urlid_t		dc_origin_id = (urlid_t)UdmVarListFindInt(&Doc->Sections, "Origin-ID", 0);
		
		/* Create "Alias" variable */
		alcopy=UdmRemoveHiLightDup(UdmVarListFindStr(&Doc->Sections,"URL",""));
		if((Alias=UdmMatchListFind(&Agent->Conf->Aliases,alcopy,0,NULL))){
		        aliastr = (char*)malloc(strlen(Alias->arg) + strlen(alcopy) + 1);
			sprintf(aliastr, "%s%s", Alias->arg, alcopy + strlen(Alias->pattern));
		}else{
			aliastr = (char*)strdup(alcopy);
		}
		UdmVarListReplaceStr(&Doc->Sections,"Alias", aliastr);
		free(aliastr);
		free(alcopy);
		
		/* Skip clones */
		if(dc_origin_id)continue;
		
		clist = (char*)malloc(2048); /* FIXME */
		clist[0] = '\0';
		clistsize = 0;
		for(cl=0;cl<Res->num_rows;cl++){
			UDM_DOCUMENT	*Clone=&Res->Doc[cl];
			urlid_t		cl_origin_id = (urlid_t)UdmVarListFindInt(&Clone->Sections, "Origin-ID", 0);
			
			if ((dc_url_id == cl_origin_id) && cl_origin_id){
				UDM_VARLIST	CloneVars;
				
				UdmVarListInit(&CloneVars);
				UdmVarListAddLst(&CloneVars,&Env->Vars,NULL,"*");
				UdmVarListReplaceLst(&CloneVars,&Clone->Sections,NULL,"*");
				clist = (char*)realloc(clist, (clistsize = strlen(clist)) + 2048);
				UdmTemplatePrint(Agent, NULL, clist + clistsize, 2048, &Env->Vars, &tmpl, "clone");
				UdmVarListFree(&CloneVars);
			}
		}
		clistsize += 2048;
		
		UdmVarListReplaceStr(&Env->Vars,"CL",clist);
		UdmVarListReplaceInt(&Env->Vars, "ID", dc_url_id);
		
		UdmVarListReplaceStr(&Env->Vars, "URL", UdmVarListFindStr(&Doc->Sections, "URL", ""));
		

		UdmVarListReplaceStr(&Env->Vars, "title", "[no title]");

		/* Pass all found user-defined sections */
		for(sc=0;sc<Doc->Sections.nvars;sc++){
			UDM_VAR *S=&Doc->Sections.Var[sc];
			UdmVarListReplaceStr(&Env->Vars,S->name,S->val);
		}
		
		bzero((void*)&C, sizeof(C));
		strcpy(C.addr,UdmVarListFindStr(&Doc->Sections,"Category",""));
		if(catcolumns && !UdmCatAction(Agent, &C, UDM_CAT_ACTION_PATH)){
			char *catpath = NULL;
			size_t c, l = 0;

			for(c = 0; c < C.ncategories; c++) l += 32 + strlen(C.Category[c].path) + strlen(C.Category[c].name);
			catpath = (char*)malloc(l);
			if (catpath != NULL) {
			  *catpath = '\0';
			  for(c = 0; c < C.ncategories; c++){
				sprintf(catpath+strlen(catpath)," &gt; <A HREF=\"?cat=%s\">%s</A> ",
					C.Category[c].path,
					C.Category[c].name);
			  }
			  UdmVarListReplaceStr(&Env->Vars,"DY",catpath);
			  UDM_FREE(catpath);
			}
		}
		UDM_FREE(C.Category);

		al = UdmVarListFindStrTxt(&Doc->Sections, "URL", "");
		UdmVarListReplaceInt(&Doc->Sections, "URL_ID", UdmStrHash32(al));

		u =  UdmVarListFindStr(&Env->Vars, "URL", "");
		eu = (char*)malloc(strlen(u)*10 + 10);
		UdmEscapeURL(eu, u);
		dm = UdmVarListFindStr(&Env->Vars, "Last-Modified", "");
		edm = (char*)malloc(strlen(dm)*10 + 10);
		UdmEscapeURL(edm, dm);

		udm_snprintf(storedstr, storedlen, "%s?rec_id=%s&amp;DM=%s&amp;DS=%d&amp;L=%s&amp;CS=%s&amp;DU=%s&amp;CT=%s&amp;q=%s",
			 UdmVarListFindStr(&Env->Vars, "StoredocURL", "/cgi-bin/storedoc.cgi"),
			 UdmVarListFindStr(&Doc->Sections, "URL_ID", 0),
			 edm,
			 UdmVarListFindInt(&Env->Vars, "Content-Length", 0),
			 UdmVarListFindStr(&Env->Vars,"Content-Language",""),
			 UdmVarListFindStr(&Env->Vars,"Charset",""),
			 eu,
			 UdmVarListFindStr(&Doc->Sections,"Content-Type",""),
			 searchwords
			 );
		free(eu);
		free(edm);

		/* temporary skip large files */
		/* Excerpt = (Doc->size < 200000) ? UdmExcerptDoc(Agent, Res, Doc, 256) : NULL;*/
		
		Excerpt = UdmExcerptDoc(Agent, Res, Doc, ExcerptSize);
		
		if ((Excerpt != NULL) && (strlen(Excerpt) > 6)) {
			  char *HlExcerpt = UdmHlConvert(&Res->WWList, Excerpt, Env->lcs, Env->bcs);
			  UdmVarListReplaceStr(&Env->Vars,"body",HlExcerpt);
			  UDM_FREE(HlExcerpt);
			}
		if (Excerpt != NULL && (UdmVarListFindStr(&Doc->Sections, "Z", NULL) == NULL)) {
			UdmVarListReplaceInt(&Env->Vars,"ST",1);
			UdmVarListReplaceStr(&Env->Vars, "stored_href", storedstr);
		} else {
			UdmVarListReplaceInt(&Env->Vars,"ST",0);
			UdmVarListReplaceStr(&Env->Vars, "stored_href", "");
		}
		UDM_FREE(Excerpt);
		
		if ( (sc = UdmVarListFindInt(&Env->Vars, "site", 0)) == 0) {
		  UdmVarListReplaceInt(&query_vars,"np", 0);
		  UdmVarListReplaceInt(&query_vars, "site", UdmVarListFindInt(&Doc->Sections, "Site_id", 0));
		  BuildPageURL(&query_vars, &url);
		  UdmVarListReplaceStr(&Env->Vars, "sitelimit_href", url);
		}

		if (Res->PerSite) {
		  UdmVarListReplaceUnsigned(&Env->Vars, "PerSite", Res->PerSite[i]);
		}

		UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "res");
		
		/* Revoke all found user-defined sections */
		for(sc = 0; sc < Doc->Sections.nvars; sc++){
			UDM_VAR *S = &Doc->Sections.Var[sc];
			UdmVarListDel(&Env->Vars, S->name);
		}
		
		free(clist);
	}
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "resbot");
	UDM_FREE(searchwords);
	UDM_FREE(storedstr);
	
freeres:
	UdmResultFree(Res);
	
end:
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "bottom");
	
	UdmVarListFree(&tmpl);
	UdmVarListFree(&query_vars);
	UdmEnvFree(Env);
	UdmAgentFree(Agent);
	UDM_FREE(query_string);
	UDM_FREE(url);
	UDM_FREE(nav);
	if (httpd) fflush(NULL); else fclose(stdout);
	
	return UDM_OK;
}
