/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_url.h"
#include "udm_utils.h"

UDM_URL * __UDMCALL UdmURLInit(UDM_URL *url) {
  if (!url) {
    url = (UDM_URL*)malloc(sizeof(UDM_URL));
    bzero((void*)url, sizeof(UDM_URL));
    url->freeme = 1;
  } else {
    int fr = url->freeme;
    bzero((void*)url, sizeof(UDM_URL));
    url->freeme = fr;
  }
  return url;
}

void __UDMCALL UdmURLFree(UDM_URL *url) {
	UDM_FREE(url->schema);
	UDM_FREE(url->specific);
	UDM_FREE(url->hostinfo);
	UDM_FREE(url->auth);
	UDM_FREE(url->hostname);
	UDM_FREE(url->path);
	UDM_FREE(url->filename);
	UDM_FREE(url->anchor);
	if(url->freeme){
		UDM_FREE(url);
	} else {
	  url->port = url->default_port = 0;
	}
}

int UdmURLParse(UDM_URL *url,const char *str){
	char *schema,*anchor,*file,*query;
	char *query_string = NULL, *s;
	size_t len = strlen(str);
	
/*	if(len >= UDM_URLSIZE)return(UDM_URL_LONG);  FIXME: Chage this cheking for cobfigured parameter, not UDM_URLSIZE */
	s = (char*)malloc(len + 1);
	if (s == NULL) return UDM_ERROR;
	strcpy(s,str);
	
	UDM_FREE(url->schema);
	UDM_FREE(url->specific);
	UDM_FREE(url->hostinfo);
	UDM_FREE(url->hostname);
	UDM_FREE(url->anchor);
	UDM_FREE(url->auth);
	url->port=0;
	url->default_port=0;
	UDM_FREE(url->path);
	UDM_FREE(url->filename);

	/* Find possible schema end than   */	
	/* Check that it is really schema  */
	/* It must consist of alphas only  */
	/* We will take in account digits  */
	/* also for oracle8:// for example */
	/* We must check it because        */
	/* It might be anchor also         */
	/* For example:                    */
	/* "mod/index.html#a:1"            */

	if((schema=strchr(s,':'))){
		const char * ch;
		for(ch=s;ch<schema;ch++){
			if(!isalnum(*ch)){
				/* Bad character       */
				/* so it is not schema */
				schema=0;break;
			}
		}
	}

	if(schema){
		/* Have scheme - absolute path */
		*schema=0;
		url->schema = (char*)strdup(s);
		url->specific = (char*)strdup(schema + 1);
		*schema=':';
		if(!strcasecmp(url->schema,"http"))url->default_port=80;
		else
		if(!strcasecmp(url->schema,"https"))url->default_port=443;
		else
		if(!strcasecmp(url->schema,"nntp"))url->default_port=119;
		else
		if(!strcasecmp(url->schema,"news"))url->default_port=119;
		else
		if(!strcasecmp(url->schema,"ftp"))url->default_port=21;

		if(!strncmp(url->specific,"//",2)){
			char	*ss,*hostname;
			
			/* Have hostinfo */
			if((ss=strchr(url->specific+2,'/'))){
				/* Have hostname with path */
				*ss=0;
				url->hostinfo = (char*)strdup(url->specific + 2);
				*ss='/';
				url->path = (char*)strdup(ss);
			}else{
				/* Hostname without path */
				url->hostinfo = (char*)strdup(url->specific + 2);
				url->path = (char*)strdup("/");
			}
			if((hostname=strchr(url->hostinfo,'@'))){
				/* Username and password is given  */
				/* Store auth string user:password */
				*hostname=0;
				url->auth = (char*)strdup(url->hostinfo);
				*hostname='@';
				hostname++;
			}else{
				hostname = url->hostinfo;
			}
			/*
			FIXME:
			for(h=hostname;*h;h++){
				if( *h>='A' && *h<='Z')
				*h=(*h)-'A'+'a';
			}
			*/
	
			if((ss=strchr(hostname,':'))){
				*ss=0;
				url->hostname = (char*)strdup(hostname);
				*ss=':';
				url->port=atoi(ss+1);
			}else{
				url->hostname = (char*)strdup(hostname);
				url->port=0;
			}
		}else{
			/* Have not host but have schema                   */
			/* This is possible for:                           */
			/* file:  mailto:  htdb: news:                     */
			/* As far as we do not need mailto: just ignore it */
			
		        if(!strcasecmp(url->schema,"mailto") || !strcasecmp(url->schema,"javascript")) {
			        UDM_FREE(s);
				return(UDM_URL_BAD);
			} else
			if(!strcasecmp(url->schema,"file"))
				url->path = (char*)strdup(url->specific);
			else
			if(!strcasecmp(url->schema,"exec"))
				url->path = (char*)strdup(url->specific);
			else
			if(!strcasecmp(url->schema,"cgi"))
				url->path = (char*)strdup(url->specific);
			else
			if(!strcasecmp(url->schema,"htdb"))
				url->path = (char*)strdup(url->specific);
			else
			if(!strcasecmp(url->schema,"news")){
				/* Now we will use localhost as NNTP    */
				/* server as it is not indicated in URL */
				url->hostname = (char*)strdup("localhost");
				url->path = (char*)malloc(strlen(url->specific) + 2);
				sprintf(url->path,"/%s",url->specific);
				url->default_port=119;
			}else{
				/* Unknown strange schema */
			        UDM_FREE(s);
				return(UDM_URL_BAD);
			}
		}
	}else{
		url->path = (char*)strdup(s);
	}

	/* Cat an anchor if exist */
	if((anchor=strstr(url->path,"#")))*anchor=0;


	/* If path is not full just copy it to filename    */
	/* i.e. neither  /usr/local/ nor  c:/windows/temp/ */

	if((url->path != NULL) && (url->path[0]!='/') && (url->path[1]!=':')) { 
		/* Relative path */
		if(!strncmp(url->path,"./",2))
			url->filename = (char*)strdup(url->path + 2);
		else
			url->filename = (char*)strdup(url->path);
		url->path[0] = 0;
	}

	/* truncate path to query_string */
	/* and store query_string        */

	if((query=strrchr(url->path,'?'))){
		query_string = (char*)strdup(query);
		*(query) = 0;
	}
	
	UdmURLNormalizePath(url->path);
	
	/* Now find right '/' sign and copy the rest to filename */

	if((file=strrchr(url->path,'/'))&&(strcmp(file,"/"))){
		url->filename = (char*)strdup(file + 1);
		*(file+1)=0;
	}

	/* Restore query_string to filename*/
	if (query_string != NULL) {
	  if (url->filename) {
	    url->filename = (char*)realloc(url->filename, (url->filename ? strlen(url->filename) : 0) + strlen(query_string) + 1);
	    if (url->filename == NULL) { UDM_FREE(query_string); UDM_FREE(s); return UDM_ERROR; }
	    if (query) strcat(url->filename,query_string);
	  } else {
	    url->filename = (char*)strdup(query_string);
	  }
	}
	
	UDM_FREE(query_string); UDM_FREE(s);
	if (url->hostname != NULL) for (s = url->hostname; *s; s++) *s = tolower(*s);
	return UDM_OK;
}



char * UdmURLNormalizePath(char * str){
	char * s=str;
	char * q;
	char * d;

	/* Hide query string */

	if((q=strchr(s,'?'))){
		*q++='\0';
		if(!*q)q=NULL;
	}

	/* Remove all "/../" entries */

	while((d=strstr(str,"/../"))){
		char * p;
		
		if(d>str){
			/* Skip non-slashes */
			for(p=d-1;(*p!='/')&&(p>str);p--);
			
			/* Skip slashes */
			while((p>(str+1))&&(*(p-1)=='/'))p--;
		}else{
			/* We are at the top level and have ../  */
			/* Remove it too to avoid loops          */
			p=str;
		}
		memmove(p,d+3,strlen(d)-2);
	}

	/* Remove remove trailig "/.." */

	d=str+strlen(str);
	if((d-str>2)&&(!strcmp(d-3,"/.."))){
		d-=4;
		while((d>str)&&(*d!='/'))d--;
		if(*d=='/')d[1]='\0';
		else	strcpy(str,"/");
	}

	/* Remove all "/./" entries */
	
	while((d=strstr(str,"/./"))){
		memmove(d,d+2,strlen(d)-1);
	}

	/* Remove the trailing "/."  */
	
	if((d=str+strlen(str))>(str+2))
		if(!strcmp(d-2,"/."))
			*(d-1)='\0';

	/* Remove all "//" entries */
	while((d=strstr(str,"//"))){
		memmove(d,d+1,strlen(d));
	}

	
	/* Replace "%7E" with "~"         */
	/* Actually it is to be done      */
	/* for all valid characters       */
	/* which do not require escaping  */
	/* However I'm lazy, do it for 7E */
	/* as the most often "abused"     */

	while((d=strstr(str,"%7E"))){
		*d='~';
		memmove(d+1,d+3,strlen(d+3)+1);
	}

	/* Restore query string */

	if(q){
		char * e=str+strlen(str);
		*e='?';
		memmove(e+1,q,strlen(q)+1);
	}

	return str;
}

