/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include "udm_common.h"
#include "udm_word.h"
#include "udm_hash.h"
#include "udm_utils.h"
#include "udm_vars.h"

__C_LINK int __UDMCALL UdmResCollectWords(UDM_RESULT *Ind, UDM_URLCRDLISTLIST *L){
	size_t		i;
	size_t		total=0;
	size_t		nbytes;
	
	for(i=0;i<Ind->num_rows;i++){
		total+=Ind->Doc[i].Words.nwords;
	}
	
	L->nlists=total*1.2;
	nbytes=sizeof(UDM_URLCRDLIST)*L->nlists;
	
	L->List=(UDM_URLCRDLIST*)malloc(nbytes);
	bzero((void*)L->List, nbytes);
	
	for(i=0;i<Ind->num_rows;i++){
		size_t	w;
		urlid_t	url_id = UdmVarListFindInt(&Ind->Doc[i].Sections, "ID", 0);
		
		for(w=0;w<Ind->Doc[i].Words.nwords;w++){
			UDM_WORD	*Wrd=&Ind->Doc[i].Words.Word[w];
			unsigned	pos=(unsigned)UdmStrHash32(Wrd->word) % L->nlists;
			size_t		confcount=0;
		
			if(!Wrd->coord)continue;
			
			while(1){
				UDM_URLCRDLIST	*CrdLst;
				CrdLst=&L->List[pos];
				
			
				if(!CrdLst->word){
					/* Free cell */
					CrdLst->word = (char*)strdup(Wrd->word);
					CrdLst->ncoords=1;
					CrdLst->Coords=(UDM_URL_CRD*)malloc(sizeof(UDM_URL_CRD));
					CrdLst->Coords[0].url_id=url_id;
					CrdLst->Coords[0].coord=Wrd->coord;
					break;
				}
				if(!strcmp(CrdLst->word,Wrd->word)){
					/* Same word */
					CrdLst->Coords=(UDM_URL_CRD*)realloc(CrdLst->Coords,sizeof(UDM_URL_CRD)*(CrdLst->ncoords+1));
					CrdLst->Coords[CrdLst->ncoords].url_id=url_id;
					CrdLst->Coords[CrdLst->ncoords].coord=Wrd->coord;
					CrdLst->ncoords++;
					break;
				}
				/* Conflict: buzy cell, another word */
				/* Lets move to the next cell        */
				pos = (pos+1) % L->nlists;
				confcount++;
				if(confcount>=L->nlists)
					break;
			}
		}
	}
	
	return UDM_OK;
}
