/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_utils.h"
#include "udm_unicode.h"
#include "udm_word.h"


#define WSIZE		1024
#define BSIZE		10

static int AddOneWord(UDM_DOCUMENT *Doc,char *word,int weight)
{
#ifdef TRIAL_VER
	if (Doc->Words.nwords >= 256)
		return UDM_OK;
#else
	/* Realloc memory when required  */
	if(Doc->Words.nwords>=Doc->Words.mwords){
		Doc->Words.mwords+=WSIZE;
		Doc->Words.Word=(UDM_WORD *)UdmRealloc(Doc->Words.Word,Doc->Words.mwords*sizeof(UDM_WORD));
	}
#endif
	/* Add new word */
	Doc->Words.Word[Doc->Words.nwords].word = (char*)UdmStrdup(word);
	Doc->Words.Word[Doc->Words.nwords].coord=UDM_WRDCOORD(Doc->CrossWords.wordpos,weight);
	Doc->Words.nwords++;
	
	return(UDM_OK);
}

/* This function adds a normalized word form(s) into list using Ispell */
int UdmWordListAdd(UDM_DOCUMENT * Doc,char *word,int weight){

	Doc->CrossWords.wordpos++;
	return AddOneWord(Doc,word,weight);
}

int UdmWordListFree(UDM_WORDLIST * List){
	size_t i;
	for(i=0;i<List->nwords;i++)
		UDM_FREE(List->Word[i].word);
	List->nwords=0;
	List->swords=0;
#ifndef TRIAL_VER
	UDM_FREE(List->Word);
#endif
	return(0);
}

UDM_WORDLIST * UdmWordListInit(UDM_WORDLIST * List){
	bzero((void*)List, sizeof(*List));
	return(List);
}


UDM_WIDEWORDLIST * UdmWideWordListInit(UDM_WIDEWORDLIST * List){
	bzero((void*)List, sizeof(*List));
	return(List);
}

size_t UdmWideWordListAdd(UDM_WIDEWORDLIST * List,UDM_WIDEWORD * Word){
        size_t i;

	for (i = 0; i < List->nwords; i++) {
	  if (List->Word[i].len == Word->len && (UdmUniStrCmp(List->Word[i].uword, Word->uword) == 0)) {
	    List->Word[i].count += Word->count;
	    switch (Word->origin) {
	    case UDM_WORD_ORIGIN_QUERY:
	      if (List->Word[i].origin == UDM_WORD_ORIGIN_STOP) break;
	    case UDM_WORD_ORIGIN_STOP:
	      List->Word[i].origin = Word->origin;
	    default:
	      break;
	    }
	    List->Word[i].order = Word->order;
	    return(List->nwords); 
	  }
	}
	
	/* Realloc memory */
	List->Word=(UDM_WIDEWORD*)UdmRealloc(List->Word,sizeof(*(List->Word))*(List->nwords+1));
	bzero((void*)&List->Word[List->nwords], sizeof(*(List->Word)));
	
	/* Copy data */
	List->Word[List->nwords].len=Word->len;
	List->Word[List->nwords].order=Word->order;
	List->Word[List->nwords].count=Word->count;
	List->Word[List->nwords].crcword=Word->crcword;
	List->Word[List->nwords].word = Word->word ? (char*)UdmStrdup(Word->word) : NULL;
	List->Word[List->nwords].uword=Word->uword?UdmUniDup(Word->uword):NULL;
	List->Word[List->nwords].ulen = Word->uword ? UdmUniLen(Word->uword) : 0;
	List->Word[List->nwords].origin = Word->origin;
	List->nwords++;
	return(List->nwords);
}

void UdmWideWordListFree(UDM_WIDEWORDLIST * List){
	size_t i;
	for(i=0;i<List->nwords;i++){
		UDM_FREE(List->Word[i].word);
		UDM_FREE(List->Word[i].uword);
	}
	UDM_FREE(List->Word);
	UdmWideWordListInit(List);
}
