/* Copyright (C) 2000-2006 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"
#include <stdio.h>
#include <string.h>
#include "udm_uniconv.h"
#include "udm_unidata.h"


typedef struct
{
  unsigned short ctype;
  unsigned short tolower;
  unsigned short noaccent;
  unsigned short noaccent_tolower;
} UDM_UNICODE;

struct udm_unidata_st
{
  int ctype;
  UDM_UNICODE * table;
};


static UDM_UNICODE plane00[257]={
 {0,0x0000,0x0000,0x0000}, {0,0x0001,0x0001,0x0001}, {0,0x0002,0x0002,0x0002}, {0,0x0003,0x0003,0x0003},
 {0,0x0004,0x0004,0x0004}, {0,0x0005,0x0005,0x0005}, {0,0x0006,0x0006,0x0006}, {0,0x0007,0x0007,0x0007},
 {0,0x0008,0x0008,0x0008}, {0,0x0009,0x0009,0x0009}, {0,0x000A,0x000A,0x000A}, {0,0x000B,0x000B,0x000B},
 {0,0x000C,0x000C,0x000C}, {0,0x000D,0x000D,0x000D}, {0,0x000E,0x000E,0x000E}, {0,0x000F,0x000F,0x000F},
 {0,0x0010,0x0010,0x0010}, {0,0x0011,0x0011,0x0011}, {0,0x0012,0x0012,0x0012}, {0,0x0013,0x0013,0x0013},
 {0,0x0014,0x0014,0x0014}, {0,0x0015,0x0015,0x0015}, {0,0x0016,0x0016,0x0016}, {0,0x0017,0x0017,0x0017},
 {0,0x0018,0x0018,0x0018}, {0,0x0019,0x0019,0x0019}, {0,0x001A,0x001A,0x001A}, {0,0x001B,0x001B,0x001B},
 {0,0x001C,0x001C,0x001C}, {0,0x001D,0x001D,0x001D}, {0,0x001E,0x001E,0x001E}, {0,0x001F,0x001F,0x001F},
 {0,0x0020,0x0020,0x0020}, {0,0x0021,0x0021,0x0021}, {0,0x0022,0x0022,0x0022}, {0,0x0023,0x0023,0x0023},
 {0,0x0024,0x0024,0x0024}, {0,0x0025,0x0025,0x0025}, {0,0x0026,0x0026,0x0026}, {0,0x0027,0x0027,0x0027},
 {0,0x0028,0x0028,0x0028}, {0,0x0029,0x0029,0x0029}, {0,0x002A,0x002A,0x002A}, {0,0x002B,0x002B,0x002B},
 {0,0x002C,0x002C,0x002C}, {0,0x002D,0x002D,0x002D}, {0,0x002E,0x002E,0x002E}, {0,0x002F,0x002F,0x002F},
 {2,0x0030,0x0030,0x0030}, {2,0x0031,0x0031,0x0031}, {2,0x0032,0x0032,0x0032}, {2,0x0033,0x0033,0x0033},
 {2,0x0034,0x0034,0x0034}, {2,0x0035,0x0035,0x0035}, {2,0x0036,0x0036,0x0036}, {2,0x0037,0x0037,0x0037},
 {2,0x0038,0x0038,0x0038}, {2,0x0039,0x0039,0x0039}, {0,0x003A,0x003A,0x003A}, {0,0x003B,0x003B,0x003B},
 {0,0x003C,0x003C,0x003C}, {0,0x003D,0x003D,0x003D}, {0,0x003E,0x003E,0x003E}, {0,0x003F,0x003F,0x003F},
 {0,0x0040,0x0040,0x0040}, {1,0x0061,0x0041,0x0061}, {1,0x0062,0x0042,0x0062}, {1,0x0063,0x0043,0x0063},
 {1,0x0064,0x0044,0x0064}, {1,0x0065,0x0045,0x0065}, {1,0x0066,0x0046,0x0066}, {1,0x0067,0x0047,0x0067},
 {1,0x0068,0x0048,0x0068}, {1,0x0069,0x0049,0x0069}, {1,0x006A,0x004A,0x006A}, {1,0x006B,0x004B,0x006B},
 {1,0x006C,0x004C,0x006C}, {1,0x006D,0x004D,0x006D}, {1,0x006E,0x004E,0x006E}, {1,0x006F,0x004F,0x006F},
 {1,0x0070,0x0050,0x0070}, {1,0x0071,0x0051,0x0071}, {1,0x0072,0x0052,0x0072}, {1,0x0073,0x0053,0x0073},
 {1,0x0074,0x0054,0x0074}, {1,0x0075,0x0055,0x0075}, {1,0x0076,0x0056,0x0076}, {1,0x0077,0x0057,0x0077},
 {1,0x0078,0x0058,0x0078}, {1,0x0079,0x0059,0x0079}, {1,0x007A,0x005A,0x007A}, {0,0x005B,0x005B,0x005B},
 {0,0x005C,0x005C,0x005C}, {0,0x005D,0x005D,0x005D}, {0,0x005E,0x005E,0x005E}, {0,0x005F,0x005F,0x005F},
 {0,0x0060,0x0060,0x0060}, {1,0x0061,0x0061,0x0061}, {1,0x0062,0x0062,0x0062}, {1,0x0063,0x0063,0x0063},
 {1,0x0064,0x0064,0x0064}, {1,0x0065,0x0065,0x0065}, {1,0x0066,0x0066,0x0066}, {1,0x0067,0x0067,0x0067},
 {1,0x0068,0x0068,0x0068}, {1,0x0069,0x0069,0x0069}, {1,0x006A,0x006A,0x006A}, {1,0x006B,0x006B,0x006B},
 {1,0x006C,0x006C,0x006C}, {1,0x006D,0x006D,0x006D}, {1,0x006E,0x006E,0x006E}, {1,0x006F,0x006F,0x006F},
 {1,0x0070,0x0070,0x0070}, {1,0x0071,0x0071,0x0071}, {1,0x0072,0x0072,0x0072}, {1,0x0073,0x0073,0x0073},
 {1,0x0074,0x0074,0x0074}, {1,0x0075,0x0075,0x0075}, {1,0x0076,0x0076,0x0076}, {1,0x0077,0x0077,0x0077},
 {1,0x0078,0x0078,0x0078}, {1,0x0079,0x0079,0x0079}, {1,0x007A,0x007A,0x007A}, {0,0x007B,0x007B,0x007B},
 {0,0x007C,0x007C,0x007C}, {0,0x007D,0x007D,0x007D}, {0,0x007E,0x007E,0x007E}, {0,0x007F,0x007F,0x007F},
 {0,0x0080,0x0080,0x0080}, {0,0x0081,0x0081,0x0081}, {0,0x0082,0x0082,0x0082}, {0,0x0083,0x0083,0x0083},
 {0,0x0084,0x0084,0x0084}, {0,0x0085,0x0085,0x0085}, {0,0x0086,0x0086,0x0086}, {0,0x0087,0x0087,0x0087},
 {0,0x0088,0x0088,0x0088}, {0,0x0089,0x0089,0x0089}, {0,0x008A,0x008A,0x008A}, {0,0x008B,0x008B,0x008B},
 {0,0x008C,0x008C,0x008C}, {0,0x008D,0x008D,0x008D}, {0,0x008E,0x008E,0x008E}, {0,0x008F,0x008F,0x008F},
 {0,0x0090,0x0090,0x0090}, {0,0x0091,0x0091,0x0091}, {0,0x0092,0x0092,0x0092}, {0,0x0093,0x0093,0x0093},
 {0,0x0094,0x0094,0x0094}, {0,0x0095,0x0095,0x0095}, {0,0x0096,0x0096,0x0096}, {0,0x0097,0x0097,0x0097},
 {0,0x0098,0x0098,0x0098}, {0,0x0099,0x0099,0x0099}, {0,0x009A,0x009A,0x009A}, {0,0x009B,0x009B,0x009B},
 {0,0x009C,0x009C,0x009C}, {0,0x009D,0x009D,0x009D}, {0,0x009E,0x009E,0x009E}, {0,0x009F,0x009F,0x009F},
 {0,0x00A0,0x00A0,0x00A0}, {0,0x00A1,0x00A1,0x00A1}, {0,0x00A2,0x00A2,0x00A2}, {0,0x00A3,0x00A3,0x00A3},
 {0,0x00A4,0x00A4,0x00A4}, {0,0x00A5,0x00A5,0x00A5}, {0,0x00A6,0x00A6,0x00A6}, {0,0x00A7,0x00A7,0x00A7},
 {0,0x00A8,0x00A8,0x00A8}, {0,0x00A9,0x00A9,0x00A9}, {1,0x00AA,0x00AA,0x00AA}, {0,0x00AB,0x00AB,0x00AB},
 {0,0x00AC,0x00AC,0x00AC}, {0,0x00AD,0x00AD,0x00AD}, {0,0x00AE,0x00AE,0x00AE}, {0,0x00AF,0x00AF,0x00AF},
 {0,0x00B0,0x00B0,0x00B0}, {0,0x00B1,0x00B1,0x00B1}, {0,0x00B2,0x00B2,0x00B2}, {0,0x00B3,0x00B3,0x00B3},
 {0,0x00B4,0x00B4,0x00B4}, {1,0x00B5,0x00B5,0x00B5}, {0,0x00B6,0x00B6,0x00B6}, {0,0x00B7,0x00B7,0x00B7},
 {0,0x00B8,0x00B8,0x00B8}, {0,0x00B9,0x00B9,0x00B9}, {1,0x00BA,0x00BA,0x00BA}, {0,0x00BB,0x00BB,0x00BB},
 {0,0x00BC,0x00BC,0x00BC}, {0,0x00BD,0x00BD,0x00BD}, {0,0x00BE,0x00BE,0x00BE}, {0,0x00BF,0x00BF,0x00BF},
 {1,0x00E0,0x0041,0x0061}, {1,0x00E1,0x0041,0x0061}, {1,0x00E2,0x0041,0x0061}, {1,0x00E3,0x0041,0x0061},
 {1,0x00E4,0x0041,0x0061}, {1,0x00E5,0x0041,0x0061}, {1,0x00E6,0x00C6,0x00E6}, {1,0x00E7,0x0043,0x0063},
 {1,0x00E8,0x0045,0x0065}, {1,0x00E9,0x0045,0x0065}, {1,0x00EA,0x0045,0x0065}, {1,0x00EB,0x0045,0x0065},
 {1,0x00EC,0x0049,0x0069}, {1,0x00ED,0x0049,0x0069}, {1,0x00EE,0x0049,0x0069}, {1,0x00EF,0x0049,0x0069},
 {1,0x00F0,0x00D0,0x00F0}, {1,0x00F1,0x004E,0x006E}, {1,0x00F2,0x004F,0x006F}, {1,0x00F3,0x004F,0x006F},
 {1,0x00F4,0x004F,0x006F}, {1,0x00F5,0x004F,0x006F}, {1,0x00F6,0x004F,0x006F}, {0,0x00D7,0x00D7,0x00D7},
 {1,0x00F8,0x00D8,0x00F8}, {1,0x00F9,0x0055,0x0075}, {1,0x00FA,0x0055,0x0075}, {1,0x00FB,0x0055,0x0075},
 {1,0x00FC,0x0055,0x0075}, {1,0x00FD,0x0059,0x0079}, {1,0x00FE,0x00DE,0x00FE}, {1,0x00DF,0x00DF,0x00DF},
 {1,0x00E0,0x0061,0x0061}, {1,0x00E1,0x0061,0x0061}, {1,0x00E2,0x0061,0x0061}, {1,0x00E3,0x0061,0x0061},
 {1,0x00E4,0x0061,0x0061}, {1,0x00E5,0x0061,0x0061}, {1,0x00E6,0x00E6,0x00E6}, {1,0x00E7,0x0063,0x0063},
 {1,0x00E8,0x0065,0x0065}, {1,0x00E9,0x0065,0x0065}, {1,0x00EA,0x0065,0x0065}, {1,0x00EB,0x0065,0x0065},
 {1,0x00EC,0x0069,0x0069}, {1,0x00ED,0x0069,0x0069}, {1,0x00EE,0x0069,0x0069}, {1,0x00EF,0x0069,0x0069},
 {1,0x00F0,0x00F0,0x00F0}, {1,0x00F1,0x006E,0x006E}, {1,0x00F2,0x006F,0x006F}, {1,0x00F3,0x006F,0x006F},
 {1,0x00F4,0x006F,0x006F}, {1,0x00F5,0x006F,0x006F}, {1,0x00F6,0x006F,0x006F}, {0,0x00F7,0x00F7,0x00F7},
 {1,0x00F8,0x00F8,0x00F8}, {1,0x00F9,0x0075,0x0075}, {1,0x00FA,0x0075,0x0075}, {1,0x00FB,0x0075,0x0075},
 {1,0x00FC,0x0075,0x0075}, {1,0x00FD,0x0079,0x0079}, {1,0x00FE,0x00FE,0x00FE}, {1,0x00FF,0x0079,0x0079},
{0,0}};

static UDM_UNICODE plane01[257]={
 {1,0x0101,0x0041,0x0061}, {1,0x0101,0x0061,0x0061}, {1,0x0103,0x0041,0x0061}, {1,0x0103,0x0061,0x0061},
 {1,0x0105,0x0041,0x0061}, {1,0x0105,0x0061,0x0061}, {1,0x0107,0x0043,0x0063}, {1,0x0107,0x0063,0x0063},
 {1,0x0109,0x0043,0x0063}, {1,0x0109,0x0063,0x0063}, {1,0x010B,0x0043,0x0063}, {1,0x010B,0x0063,0x0063},
 {1,0x010D,0x0043,0x0063}, {1,0x010D,0x0063,0x0063}, {1,0x010F,0x0044,0x0064}, {1,0x010F,0x0064,0x0064},
 {1,0x0111,0x0110,0x0111}, {1,0x0111,0x0111,0x0111}, {1,0x0113,0x0045,0x0065}, {1,0x0113,0x0065,0x0065},
 {1,0x0115,0x0045,0x0065}, {1,0x0115,0x0065,0x0065}, {1,0x0117,0x0045,0x0065}, {1,0x0117,0x0065,0x0065},
 {1,0x0119,0x0045,0x0065}, {1,0x0119,0x0065,0x0065}, {1,0x011B,0x0045,0x0065}, {1,0x011B,0x0065,0x0065},
 {1,0x011D,0x0047,0x0067}, {1,0x011D,0x0067,0x0067}, {1,0x011F,0x0047,0x0067}, {1,0x011F,0x0067,0x0067},
 {1,0x0121,0x0047,0x0067}, {1,0x0121,0x0067,0x0067}, {1,0x0123,0x0047,0x0067}, {1,0x0123,0x0067,0x0067},
 {1,0x0125,0x0048,0x0068}, {1,0x0125,0x0068,0x0068}, {1,0x0127,0x0126,0x0127}, {1,0x0127,0x0127,0x0127},
 {1,0x0129,0x0049,0x0069}, {1,0x0129,0x0069,0x0069}, {1,0x012B,0x0049,0x0069}, {1,0x012B,0x0069,0x0069},
 {1,0x012D,0x0049,0x0069}, {1,0x012D,0x0069,0x0069}, {1,0x012F,0x0049,0x0069}, {1,0x012F,0x0069,0x0069},
 {1,0x0069,0x0049,0x0069}, {1,0x0131,0x0131,0x0131}, {1,0x0133,0x0132,0x0133}, {1,0x0133,0x0133,0x0133},
 {1,0x0135,0x004A,0x006A}, {1,0x0135,0x006A,0x006A}, {1,0x0137,0x004B,0x006B}, {1,0x0137,0x006B,0x006B},
 {1,0x0138,0x0138,0x0138}, {1,0x013A,0x004C,0x006C}, {1,0x013A,0x006C,0x006C}, {1,0x013C,0x004C,0x006C},
 {1,0x013C,0x006C,0x006C}, {1,0x013E,0x004C,0x006C}, {1,0x013E,0x006C,0x006C}, {1,0x0140,0x013F,0x0140},
 {1,0x0140,0x0140,0x0140}, {1,0x0142,0x0141,0x0142}, {1,0x0142,0x0142,0x0142}, {1,0x0144,0x004E,0x006E},
 {1,0x0144,0x006E,0x006E}, {1,0x0146,0x004E,0x006E}, {1,0x0146,0x006E,0x006E}, {1,0x0148,0x004E,0x006E},
 {1,0x0148,0x006E,0x006E}, {1,0x0149,0x0149,0x0149}, {1,0x014B,0x014A,0x014B}, {1,0x014B,0x014B,0x014B},
 {1,0x014D,0x004F,0x006F}, {1,0x014D,0x006F,0x006F}, {1,0x014F,0x004F,0x006F}, {1,0x014F,0x006F,0x006F},
 {1,0x0151,0x004F,0x006F}, {1,0x0151,0x006F,0x006F}, {1,0x0153,0x0152,0x0153}, {1,0x0153,0x0153,0x0153},
 {1,0x0155,0x0052,0x0072}, {1,0x0155,0x0072,0x0072}, {1,0x0157,0x0052,0x0072}, {1,0x0157,0x0072,0x0072},
 {1,0x0159,0x0052,0x0072}, {1,0x0159,0x0072,0x0072}, {1,0x015B,0x0053,0x0073}, {1,0x015B,0x0073,0x0073},
 {1,0x015D,0x0053,0x0073}, {1,0x015D,0x0073,0x0073}, {1,0x015F,0x0053,0x0073}, {1,0x015F,0x0073,0x0073},
 {1,0x0161,0x0053,0x0073}, {1,0x0161,0x0073,0x0073}, {1,0x0163,0x0054,0x0074}, {1,0x0163,0x0074,0x0074},
 {1,0x0165,0x0054,0x0074}, {1,0x0165,0x0074,0x0074}, {1,0x0167,0x0166,0x0167}, {1,0x0167,0x0167,0x0167},
 {1,0x0169,0x0055,0x0075}, {1,0x0169,0x0075,0x0075}, {1,0x016B,0x0055,0x0075}, {1,0x016B,0x0075,0x0075},
 {1,0x016D,0x0055,0x0075}, {1,0x016D,0x0075,0x0075}, {1,0x016F,0x0055,0x0075}, {1,0x016F,0x0075,0x0075},
 {1,0x0171,0x0055,0x0075}, {1,0x0171,0x0075,0x0075}, {1,0x0173,0x0055,0x0075}, {1,0x0173,0x0075,0x0075},
 {1,0x0175,0x0057,0x0077}, {1,0x0175,0x0077,0x0077}, {1,0x0177,0x0059,0x0079}, {1,0x0177,0x0079,0x0079},
 {1,0x00FF,0x0059,0x0079}, {1,0x017A,0x005A,0x007A}, {1,0x017A,0x007A,0x007A}, {1,0x017C,0x005A,0x007A},
 {1,0x017C,0x007A,0x007A}, {1,0x017E,0x005A,0x007A}, {1,0x017E,0x007A,0x007A}, {1,0x017F,0x017F,0x017F},
 {1,0x0180,0x0180,0x0180}, {1,0x0253,0x0181,0x0253}, {1,0x0183,0x0182,0x0183}, {1,0x0183,0x0183,0x0183},
 {1,0x0185,0x0184,0x0185}, {1,0x0185,0x0185,0x0185}, {1,0x0254,0x0186,0x0254}, {1,0x0188,0x0187,0x0188},
 {1,0x0188,0x0188,0x0188}, {1,0x0256,0x0189,0x0256}, {1,0x0257,0x018A,0x0257}, {1,0x018C,0x018B,0x018C},
 {1,0x018C,0x018C,0x018C}, {1,0x018D,0x018D,0x018D}, {1,0x01DD,0x018E,0x01DD}, {1,0x0259,0x018F,0x0259},
 {1,0x025B,0x0190,0x025B}, {1,0x0192,0x0191,0x0192}, {1,0x0192,0x0192,0x0192}, {1,0x0260,0x0193,0x0260},
 {1,0x0263,0x0194,0x0263}, {1,0x0195,0x0195,0x0195}, {1,0x0269,0x0196,0x0269}, {1,0x0268,0x0197,0x0268},
 {1,0x0199,0x0198,0x0199}, {1,0x0199,0x0199,0x0199}, {1,0x019A,0x019A,0x019A}, {1,0x019B,0x019B,0x019B},
 {1,0x026F,0x019C,0x026F}, {1,0x0272,0x019D,0x0272}, {1,0x019E,0x019E,0x019E}, {1,0x0275,0x019F,0x0275},
 {1,0x01A1,0x004F,0x006F}, {1,0x01A1,0x006F,0x006F}, {1,0x01A3,0x01A2,0x01A3}, {1,0x01A3,0x01A3,0x01A3},
 {1,0x01A5,0x01A4,0x01A5}, {1,0x01A5,0x01A5,0x01A5}, {1,0x0280,0x01A6,0x0280}, {1,0x01A8,0x01A7,0x01A8},
 {1,0x01A8,0x01A8,0x01A8}, {1,0x0283,0x01A9,0x0283}, {1,0x01AA,0x01AA,0x01AA}, {1,0x01AB,0x01AB,0x01AB},
 {1,0x01AD,0x01AC,0x01AD}, {1,0x01AD,0x01AD,0x01AD}, {1,0x0288,0x01AE,0x0288}, {1,0x01B0,0x0055,0x0075},
 {1,0x01B0,0x0075,0x0075}, {1,0x028A,0x01B1,0x028A}, {1,0x028B,0x01B2,0x028B}, {1,0x01B4,0x01B3,0x01B4},
 {1,0x01B4,0x01B4,0x01B4}, {1,0x01B6,0x01B5,0x01B6}, {1,0x01B6,0x01B6,0x01B6}, {1,0x0292,0x01B7,0x0292},
 {1,0x01B9,0x01B8,0x01B9}, {1,0x01B9,0x01B9,0x01B9}, {1,0x01BA,0x01BA,0x01BA}, {1,0x01BB,0x01BB,0x01BB},
 {1,0x01BD,0x01BC,0x01BD}, {1,0x01BD,0x01BD,0x01BD}, {1,0x01BE,0x01BE,0x01BE}, {1,0x01BF,0x01BF,0x01BF},
 {1,0x01C0,0x01C0,0x01C0}, {1,0x01C1,0x01C1,0x01C1}, {1,0x01C2,0x01C2,0x01C2}, {1,0x01C3,0x01C3,0x01C3},
 {1,0x01C6,0x01C4,0x01C6}, {1,0x01C6,0x01C5,0x01C6}, {1,0x01C6,0x01C6,0x01C6}, {1,0x01C9,0x01C7,0x01C9},
 {1,0x01C9,0x01C8,0x01C9}, {1,0x01C9,0x01C9,0x01C9}, {1,0x01CC,0x01CA,0x01CC}, {1,0x01CC,0x01CB,0x01CC},
 {1,0x01CC,0x01CC,0x01CC}, {1,0x01CE,0x0041,0x0061}, {1,0x01CE,0x0061,0x0061}, {1,0x01D0,0x0049,0x0069},
 {1,0x01D0,0x0069,0x0069}, {1,0x01D2,0x004F,0x006F}, {1,0x01D2,0x006F,0x006F}, {1,0x01D4,0x0055,0x0075},
 {1,0x01D4,0x0075,0x0075}, {1,0x01D6,0x0055,0x0075}, {1,0x01D6,0x0075,0x0075}, {1,0x01D8,0x0055,0x0075},
 {1,0x01D8,0x0075,0x0075}, {1,0x01DA,0x0055,0x0075}, {1,0x01DA,0x0075,0x0075}, {1,0x01DC,0x0055,0x0075},
 {1,0x01DC,0x0075,0x0075}, {1,0x01DD,0x01DD,0x01DD}, {1,0x01DF,0x0041,0x0061}, {1,0x01DF,0x0061,0x0061},
 {1,0x01E1,0x0041,0x0061}, {1,0x01E1,0x0061,0x0061}, {1,0x01E3,0x00C6,0x00E6}, {1,0x01E3,0x00E6,0x00E6},
 {1,0x01E5,0x01E4,0x01E5}, {1,0x01E5,0x01E5,0x01E5}, {1,0x01E7,0x0047,0x0067}, {1,0x01E7,0x0067,0x0067},
 {1,0x01E9,0x004B,0x006B}, {1,0x01E9,0x006B,0x006B}, {1,0x01EB,0x004F,0x006F}, {1,0x01EB,0x006F,0x006F},
 {1,0x01ED,0x004F,0x006F}, {1,0x01ED,0x006F,0x006F}, {1,0x01EF,0x01B7,0x0292}, {1,0x01EF,0x0292,0x0292},
 {1,0x01F0,0x006A,0x006A}, {1,0x01F3,0x01F1,0x01F3}, {1,0x01F3,0x01F2,0x01F3}, {1,0x01F3,0x01F3,0x01F3},
 {1,0x01F5,0x0047,0x0067}, {1,0x01F5,0x0067,0x0067}, {1,0x0195,0x01F6,0x0195}, {1,0x01BF,0x01F7,0x01BF},
 {1,0x01F9,0x004E,0x006E}, {1,0x01F9,0x006E,0x006E}, {1,0x01FB,0x0041,0x0061}, {1,0x01FB,0x0061,0x0061},
 {1,0x01FD,0x00C6,0x00E6}, {1,0x01FD,0x00E6,0x00E6}, {1,0x01FF,0x00D8,0x00F8}, {1,0x01FF,0x00F8,0x00F8},
{0,0}};

static UDM_UNICODE plane02[257]={
 {1,0x0201,0x0041,0x0061}, {1,0x0201,0x0061,0x0061}, {1,0x0203,0x0041,0x0061}, {1,0x0203,0x0061,0x0061},
 {1,0x0205,0x0045,0x0065}, {1,0x0205,0x0065,0x0065}, {1,0x0207,0x0045,0x0065}, {1,0x0207,0x0065,0x0065},
 {1,0x0209,0x0049,0x0069}, {1,0x0209,0x0069,0x0069}, {1,0x020B,0x0049,0x0069}, {1,0x020B,0x0069,0x0069},
 {1,0x020D,0x004F,0x006F}, {1,0x020D,0x006F,0x006F}, {1,0x020F,0x004F,0x006F}, {1,0x020F,0x006F,0x006F},
 {1,0x0211,0x0052,0x0072}, {1,0x0211,0x0072,0x0072}, {1,0x0213,0x0052,0x0072}, {1,0x0213,0x0072,0x0072},
 {1,0x0215,0x0055,0x0075}, {1,0x0215,0x0075,0x0075}, {1,0x0217,0x0055,0x0075}, {1,0x0217,0x0075,0x0075},
 {1,0x0219,0x0053,0x0073}, {1,0x0219,0x0073,0x0073}, {1,0x021B,0x0054,0x0074}, {1,0x021B,0x0074,0x0074},
 {1,0x021D,0x021C,0x021D}, {1,0x021D,0x021D,0x021D}, {1,0x021F,0x0048,0x0068}, {1,0x021F,0x0068,0x0068},
 {0,0x0220,0x0220,0x0220}, {0,0x0221,0x0221,0x0221}, {1,0x0223,0x0222,0x0223}, {1,0x0223,0x0223,0x0223},
 {1,0x0225,0x0224,0x0225}, {1,0x0225,0x0225,0x0225}, {1,0x0227,0x0041,0x0061}, {1,0x0227,0x0061,0x0061},
 {1,0x0229,0x0045,0x0065}, {1,0x0229,0x0065,0x0065}, {1,0x022B,0x004F,0x006F}, {1,0x022B,0x006F,0x006F},
 {1,0x022D,0x004F,0x006F}, {1,0x022D,0x006F,0x006F}, {1,0x022F,0x004F,0x006F}, {1,0x022F,0x006F,0x006F},
 {1,0x0231,0x004F,0x006F}, {1,0x0231,0x006F,0x006F}, {1,0x0233,0x0059,0x0079}, {1,0x0233,0x0079,0x0079},
 {0,0x0234,0x0234,0x0234}, {0,0x0235,0x0235,0x0235}, {0,0x0236,0x0236,0x0236}, {0,0x0237,0x0237,0x0237},
 {0,0x0238,0x0238,0x0238}, {0,0x0239,0x0239,0x0239}, {0,0x023A,0x023A,0x023A}, {0,0x023B,0x023B,0x023B},
 {0,0x023C,0x023C,0x023C}, {0,0x023D,0x023D,0x023D}, {0,0x023E,0x023E,0x023E}, {0,0x023F,0x023F,0x023F},
 {0,0x0240,0x0240,0x0240}, {0,0x0241,0x0241,0x0241}, {0,0x0242,0x0242,0x0242}, {0,0x0243,0x0243,0x0243},
 {0,0x0244,0x0244,0x0244}, {0,0x0245,0x0245,0x0245}, {0,0x0246,0x0246,0x0246}, {0,0x0247,0x0247,0x0247},
 {0,0x0248,0x0248,0x0248}, {0,0x0249,0x0249,0x0249}, {0,0x024A,0x024A,0x024A}, {0,0x024B,0x024B,0x024B},
 {0,0x024C,0x024C,0x024C}, {0,0x024D,0x024D,0x024D}, {0,0x024E,0x024E,0x024E}, {0,0x024F,0x024F,0x024F},
 {1,0x0250,0x0250,0x0250}, {1,0x0251,0x0251,0x0251}, {1,0x0252,0x0252,0x0252}, {1,0x0253,0x0253,0x0253},
 {1,0x0254,0x0254,0x0254}, {1,0x0255,0x0255,0x0255}, {1,0x0256,0x0256,0x0256}, {1,0x0257,0x0257,0x0257},
 {1,0x0258,0x0258,0x0258}, {1,0x0259,0x0259,0x0259}, {1,0x025A,0x025A,0x025A}, {1,0x025B,0x025B,0x025B},
 {1,0x025C,0x025C,0x025C}, {1,0x025D,0x025D,0x025D}, {1,0x025E,0x025E,0x025E}, {1,0x025F,0x025F,0x025F},
 {1,0x0260,0x0260,0x0260}, {1,0x0261,0x0261,0x0261}, {1,0x0262,0x0262,0x0262}, {1,0x0263,0x0263,0x0263},
 {1,0x0264,0x0264,0x0264}, {1,0x0265,0x0265,0x0265}, {1,0x0266,0x0266,0x0266}, {1,0x0267,0x0267,0x0267},
 {1,0x0268,0x0268,0x0268}, {1,0x0269,0x0269,0x0269}, {1,0x026A,0x026A,0x026A}, {1,0x026B,0x026B,0x026B},
 {1,0x026C,0x026C,0x026C}, {1,0x026D,0x026D,0x026D}, {1,0x026E,0x026E,0x026E}, {1,0x026F,0x026F,0x026F},
 {1,0x0270,0x0270,0x0270}, {1,0x0271,0x0271,0x0271}, {1,0x0272,0x0272,0x0272}, {1,0x0273,0x0273,0x0273},
 {1,0x0274,0x0274,0x0274}, {1,0x0275,0x0275,0x0275}, {1,0x0276,0x0276,0x0276}, {1,0x0277,0x0277,0x0277},
 {1,0x0278,0x0278,0x0278}, {1,0x0279,0x0279,0x0279}, {1,0x027A,0x027A,0x027A}, {1,0x027B,0x027B,0x027B},
 {1,0x027C,0x027C,0x027C}, {1,0x027D,0x027D,0x027D}, {1,0x027E,0x027E,0x027E}, {1,0x027F,0x027F,0x027F},
 {1,0x0280,0x0280,0x0280}, {1,0x0281,0x0281,0x0281}, {1,0x0282,0x0282,0x0282}, {1,0x0283,0x0283,0x0283},
 {1,0x0284,0x0284,0x0284}, {1,0x0285,0x0285,0x0285}, {1,0x0286,0x0286,0x0286}, {1,0x0287,0x0287,0x0287},
 {1,0x0288,0x0288,0x0288}, {1,0x0289,0x0289,0x0289}, {1,0x028A,0x028A,0x028A}, {1,0x028B,0x028B,0x028B},
 {1,0x028C,0x028C,0x028C}, {1,0x028D,0x028D,0x028D}, {1,0x028E,0x028E,0x028E}, {1,0x028F,0x028F,0x028F},
 {1,0x0290,0x0290,0x0290}, {1,0x0291,0x0291,0x0291}, {1,0x0292,0x0292,0x0292}, {1,0x0293,0x0293,0x0293},
 {1,0x0294,0x0294,0x0294}, {1,0x0295,0x0295,0x0295}, {1,0x0296,0x0296,0x0296}, {1,0x0297,0x0297,0x0297},
 {1,0x0298,0x0298,0x0298}, {1,0x0299,0x0299,0x0299}, {1,0x029A,0x029A,0x029A}, {1,0x029B,0x029B,0x029B},
 {1,0x029C,0x029C,0x029C}, {1,0x029D,0x029D,0x029D}, {1,0x029E,0x029E,0x029E}, {1,0x029F,0x029F,0x029F},
 {1,0x02A0,0x02A0,0x02A0}, {1,0x02A1,0x02A1,0x02A1}, {1,0x02A2,0x02A2,0x02A2}, {1,0x02A3,0x02A3,0x02A3},
 {1,0x02A4,0x02A4,0x02A4}, {1,0x02A5,0x02A5,0x02A5}, {1,0x02A6,0x02A6,0x02A6}, {1,0x02A7,0x02A7,0x02A7},
 {1,0x02A8,0x02A8,0x02A8}, {1,0x02A9,0x02A9,0x02A9}, {1,0x02AA,0x02AA,0x02AA}, {1,0x02AB,0x02AB,0x02AB},
 {1,0x02AC,0x02AC,0x02AC}, {1,0x02AD,0x02AD,0x02AD}, {0,0x02AE,0x02AE,0x02AE}, {0,0x02AF,0x02AF,0x02AF},
 {1,0x02B0,0x02B0,0x02B0}, {1,0x02B1,0x02B1,0x02B1}, {1,0x02B2,0x02B2,0x02B2}, {1,0x02B3,0x02B3,0x02B3},
 {1,0x02B4,0x02B4,0x02B4}, {1,0x02B5,0x02B5,0x02B5}, {1,0x02B6,0x02B6,0x02B6}, {1,0x02B7,0x02B7,0x02B7},
 {1,0x02B8,0x02B8,0x02B8}, {0,0x02B9,0x02B9,0x02B9}, {0,0x02BA,0x02BA,0x02BA}, {1,0x02BB,0x02BB,0x02BB},
 {1,0x02BC,0x02BC,0x02BC}, {1,0x02BD,0x02BD,0x02BD}, {1,0x02BE,0x02BE,0x02BE}, {1,0x02BF,0x02BF,0x02BF},
 {1,0x02C0,0x02C0,0x02C0}, {1,0x02C1,0x02C1,0x02C1}, {0,0x02C2,0x02C2,0x02C2}, {0,0x02C3,0x02C3,0x02C3},
 {0,0x02C4,0x02C4,0x02C4}, {0,0x02C5,0x02C5,0x02C5}, {0,0x02C6,0x02C6,0x02C6}, {0,0x02C7,0x02C7,0x02C7},
 {0,0x02C8,0x02C8,0x02C8}, {0,0x02C9,0x02C9,0x02C9}, {0,0x02CA,0x02CA,0x02CA}, {0,0x02CB,0x02CB,0x02CB},
 {0,0x02CC,0x02CC,0x02CC}, {0,0x02CD,0x02CD,0x02CD}, {0,0x02CE,0x02CE,0x02CE}, {0,0x02CF,0x02CF,0x02CF},
 {1,0x02D0,0x02D0,0x02D0}, {1,0x02D1,0x02D1,0x02D1}, {0,0x02D2,0x02D2,0x02D2}, {0,0x02D3,0x02D3,0x02D3},
 {0,0x02D4,0x02D4,0x02D4}, {0,0x02D5,0x02D5,0x02D5}, {0,0x02D6,0x02D6,0x02D6}, {0,0x02D7,0x02D7,0x02D7},
 {0,0x02D8,0x02D8,0x02D8}, {0,0x02D9,0x02D9,0x02D9}, {0,0x02DA,0x02DA,0x02DA}, {0,0x02DB,0x02DB,0x02DB},
 {0,0x02DC,0x02DC,0x02DC}, {0,0x02DD,0x02DD,0x02DD}, {0,0x02DE,0x02DE,0x02DE}, {0,0x02DF,0x02DF,0x02DF},
 {1,0x02E0,0x02E0,0x02E0}, {1,0x02E1,0x02E1,0x02E1}, {1,0x02E2,0x02E2,0x02E2}, {1,0x02E3,0x02E3,0x02E3},
 {1,0x02E4,0x02E4,0x02E4}, {0,0x02E5,0x02E5,0x02E5}, {0,0x02E6,0x02E6,0x02E6}, {0,0x02E7,0x02E7,0x02E7},
 {0,0x02E8,0x02E8,0x02E8}, {0,0x02E9,0x02E9,0x02E9}, {0,0x02EA,0x02EA,0x02EA}, {0,0x02EB,0x02EB,0x02EB},
 {0,0x02EC,0x02EC,0x02EC}, {0,0x02ED,0x02ED,0x02ED}, {1,0x02EE,0x02EE,0x02EE}, {0,0x02EF,0x02EF,0x02EF},
 {0,0x02F0,0x02F0,0x02F0}, {0,0x02F1,0x02F1,0x02F1}, {0,0x02F2,0x02F2,0x02F2}, {0,0x02F3,0x02F3,0x02F3},
 {0,0x02F4,0x02F4,0x02F4}, {0,0x02F5,0x02F5,0x02F5}, {0,0x02F6,0x02F6,0x02F6}, {0,0x02F7,0x02F7,0x02F7},
 {0,0x02F8,0x02F8,0x02F8}, {0,0x02F9,0x02F9,0x02F9}, {0,0x02FA,0x02FA,0x02FA}, {0,0x02FB,0x02FB,0x02FB},
 {0,0x02FC,0x02FC,0x02FC}, {0,0x02FD,0x02FD,0x02FD}, {0,0x02FE,0x02FE,0x02FE}, {0,0x02FF,0x02FF,0x02FF},
{0,0}};

static UDM_UNICODE plane03[257]={
 {1,0x0300,0x0300,0x0300}, {1,0x0301,0x0301,0x0301}, {1,0x0302,0x0302,0x0302}, {1,0x0303,0x0303,0x0303},
 {1,0x0304,0x0304,0x0304}, {1,0x0305,0x0305,0x0305}, {1,0x0306,0x0306,0x0306}, {1,0x0307,0x0307,0x0307},
 {1,0x0308,0x0308,0x0308}, {1,0x0309,0x0309,0x0309}, {1,0x030A,0x030A,0x030A}, {1,0x030B,0x030B,0x030B},
 {1,0x030C,0x030C,0x030C}, {1,0x030D,0x030D,0x030D}, {1,0x030E,0x030E,0x030E}, {1,0x030F,0x030F,0x030F},
 {1,0x0310,0x0310,0x0310}, {1,0x0311,0x0311,0x0311}, {1,0x0312,0x0312,0x0312}, {1,0x0313,0x0313,0x0313},
 {1,0x0314,0x0314,0x0314}, {1,0x0315,0x0315,0x0315}, {1,0x0316,0x0316,0x0316}, {1,0x0317,0x0317,0x0317},
 {1,0x0318,0x0318,0x0318}, {1,0x0319,0x0319,0x0319}, {1,0x031A,0x031A,0x031A}, {1,0x031B,0x031B,0x031B},
 {1,0x031C,0x031C,0x031C}, {1,0x031D,0x031D,0x031D}, {1,0x031E,0x031E,0x031E}, {1,0x031F,0x031F,0x031F},
 {1,0x0320,0x0320,0x0320}, {1,0x0321,0x0321,0x0321}, {1,0x0322,0x0322,0x0322}, {1,0x0323,0x0323,0x0323},
 {1,0x0324,0x0324,0x0324}, {1,0x0325,0x0325,0x0325}, {1,0x0326,0x0326,0x0326}, {1,0x0327,0x0327,0x0327},
 {1,0x0328,0x0328,0x0328}, {1,0x0329,0x0329,0x0329}, {1,0x032A,0x032A,0x032A}, {1,0x032B,0x032B,0x032B},
 {1,0x032C,0x032C,0x032C}, {1,0x032D,0x032D,0x032D}, {1,0x032E,0x032E,0x032E}, {1,0x032F,0x032F,0x032F},
 {1,0x0330,0x0330,0x0330}, {1,0x0331,0x0331,0x0331}, {1,0x0332,0x0332,0x0332}, {1,0x0333,0x0333,0x0333},
 {1,0x0334,0x0334,0x0334}, {1,0x0335,0x0335,0x0335}, {1,0x0336,0x0336,0x0336}, {1,0x0337,0x0337,0x0337},
 {1,0x0338,0x0338,0x0338}, {1,0x0339,0x0339,0x0339}, {1,0x033A,0x033A,0x033A}, {1,0x033B,0x033B,0x033B},
 {1,0x033C,0x033C,0x033C}, {1,0x033D,0x033D,0x033D}, {1,0x033E,0x033E,0x033E}, {1,0x033F,0x033F,0x033F},
 {1,0x0340,0x0340,0x0340}, {1,0x0341,0x0341,0x0341}, {1,0x0342,0x0342,0x0342}, {1,0x0343,0x0343,0x0343},
 {1,0x0344,0x0308,0x0308}, {1,0x0345,0x0345,0x0345}, {1,0x0346,0x0346,0x0346}, {1,0x0347,0x0347,0x0347},
 {1,0x0348,0x0348,0x0348}, {1,0x0349,0x0349,0x0349}, {1,0x034A,0x034A,0x034A}, {1,0x034B,0x034B,0x034B},
 {1,0x034C,0x034C,0x034C}, {1,0x034D,0x034D,0x034D}, {1,0x034E,0x034E,0x034E}, {0,0x034F,0x034F,0x034F},
 {0,0x0350,0x0350,0x0350}, {0,0x0351,0x0351,0x0351}, {0,0x0352,0x0352,0x0352}, {0,0x0353,0x0353,0x0353},
 {0,0x0354,0x0354,0x0354}, {0,0x0355,0x0355,0x0355}, {0,0x0356,0x0356,0x0356}, {0,0x0357,0x0357,0x0357},
 {0,0x0358,0x0358,0x0358}, {0,0x0359,0x0359,0x0359}, {0,0x035A,0x035A,0x035A}, {0,0x035B,0x035B,0x035B},
 {0,0x035C,0x035C,0x035C}, {0,0x035D,0x035D,0x035D}, {0,0x035E,0x035E,0x035E}, {0,0x035F,0x035F,0x035F},
 {1,0x0360,0x0360,0x0360}, {1,0x0361,0x0361,0x0361}, {1,0x0362,0x0362,0x0362}, {0,0x0363,0x0363,0x0363},
 {0,0x0364,0x0364,0x0364}, {0,0x0365,0x0365,0x0365}, {0,0x0366,0x0366,0x0366}, {0,0x0367,0x0367,0x0367},
 {0,0x0368,0x0368,0x0368}, {0,0x0369,0x0369,0x0369}, {0,0x036A,0x036A,0x036A}, {0,0x036B,0x036B,0x036B},
 {0,0x036C,0x036C,0x036C}, {0,0x036D,0x036D,0x036D}, {0,0x036E,0x036E,0x036E}, {0,0x036F,0x036F,0x036F},
 {0,0x0370,0x0370,0x0370}, {0,0x0371,0x0371,0x0371}, {0,0x0372,0x0372,0x0372}, {0,0x0373,0x0373,0x0373},
 {0,0x0374,0x0374,0x0374}, {0,0x0375,0x0375,0x0375}, {0,0x0376,0x0376,0x0376}, {0,0x0377,0x0377,0x0377},
 {0,0x0378,0x0378,0x0378}, {0,0x0379,0x0379,0x0379}, {1,0x037A,0x0020,0x0020}, {0,0x037B,0x037B,0x037B},
 {0,0x037C,0x037C,0x037C}, {0,0x037D,0x037D,0x037D}, {0,0x037E,0x037E,0x037E}, {0,0x037F,0x037F,0x037F},
 {0,0x0380,0x0380,0x0380}, {0,0x0381,0x0381,0x0381}, {0,0x0382,0x0382,0x0382}, {0,0x0383,0x0383,0x0383},
 {0,0x0384,0x0384,0x0384}, {0,0x0385,0x0385,0x0385}, {1,0x03AC,0x0391,0x03B1}, {0,0x0387,0x0387,0x0387},
 {1,0x03AD,0x0395,0x03B5}, {1,0x03AE,0x0397,0x03B7}, {1,0x03AF,0x0399,0x03B9}, {0,0x038B,0x038B,0x038B},
 {1,0x03CC,0x039F,0x03BF}, {0,0x038D,0x038D,0x038D}, {1,0x03CD,0x03A5,0x03C5}, {1,0x03CE,0x03A9,0x03C9},
 {1,0x0390,0x03B9,0x03B9}, {1,0x03B1,0x0391,0x03B1}, {1,0x03B2,0x0392,0x03B2}, {1,0x03B3,0x0393,0x03B3},
 {1,0x03B4,0x0394,0x03B4}, {1,0x03B5,0x0395,0x03B5}, {1,0x03B6,0x0396,0x03B6}, {1,0x03B7,0x0397,0x03B7},
 {1,0x03B8,0x0398,0x03B8}, {1,0x03B9,0x0399,0x03B9}, {1,0x03BA,0x039A,0x03BA}, {1,0x03BB,0x039B,0x03BB},
 {1,0x03BC,0x039C,0x03BC}, {1,0x03BD,0x039D,0x03BD}, {1,0x03BE,0x039E,0x03BE}, {1,0x03BF,0x039F,0x03BF},
 {1,0x03C0,0x03A0,0x03C0}, {1,0x03C1,0x03A1,0x03C1}, {0,0x03A2,0x03A2,0x03A2}, {1,0x03C3,0x03A3,0x03C3},
 {1,0x03C4,0x03A4,0x03C4}, {1,0x03C5,0x03A5,0x03C5}, {1,0x03C6,0x03A6,0x03C6}, {1,0x03C7,0x03A7,0x03C7},
 {1,0x03C8,0x03A8,0x03C8}, {1,0x03C9,0x03A9,0x03C9}, {1,0x03CA,0x0399,0x03B9}, {1,0x03CB,0x03A5,0x03C5},
 {1,0x03AC,0x03B1,0x03B1}, {1,0x03AD,0x03B5,0x03B5}, {1,0x03AE,0x03B7,0x03B7}, {1,0x03AF,0x03B9,0x03B9},
 {1,0x03B0,0x03C5,0x03C5}, {1,0x03B1,0x03B1,0x03B1}, {1,0x03B2,0x03B2,0x03B2}, {1,0x03B3,0x03B3,0x03B3},
 {1,0x03B4,0x03B4,0x03B4}, {1,0x03B5,0x03B5,0x03B5}, {1,0x03B6,0x03B6,0x03B6}, {1,0x03B7,0x03B7,0x03B7},
 {1,0x03B8,0x03B8,0x03B8}, {1,0x03B9,0x03B9,0x03B9}, {1,0x03BA,0x03BA,0x03BA}, {1,0x03BB,0x03BB,0x03BB},
 {1,0x03BC,0x03BC,0x03BC}, {1,0x03BD,0x03BD,0x03BD}, {1,0x03BE,0x03BE,0x03BE}, {1,0x03BF,0x03BF,0x03BF},
 {1,0x03C0,0x03C0,0x03C0}, {1,0x03C1,0x03C1,0x03C1}, {1,0x03C2,0x03C2,0x03C2}, {1,0x03C3,0x03C3,0x03C3},
 {1,0x03C4,0x03C4,0x03C4}, {1,0x03C5,0x03C5,0x03C5}, {1,0x03C6,0x03C6,0x03C6}, {1,0x03C7,0x03C7,0x03C7},
 {1,0x03C8,0x03C8,0x03C8}, {1,0x03C9,0x03C9,0x03C9}, {1,0x03CA,0x03B9,0x03B9}, {1,0x03CB,0x03C5,0x03C5},
 {1,0x03CC,0x03BF,0x03BF}, {1,0x03CD,0x03C5,0x03C5}, {1,0x03CE,0x03C9,0x03C9}, {0,0x03CF,0x03CF,0x03CF},
 {1,0x03D0,0x03D0,0x03D0}, {1,0x03D1,0x03D1,0x03D1}, {1,0x03D2,0x03D2,0x03D2}, {1,0x03D3,0x03D2,0x03D2},
 {1,0x03D4,0x03D2,0x03D2}, {1,0x03D5,0x03D5,0x03D5}, {1,0x03D6,0x03D6,0x03D6}, {1,0x03D7,0x03D7,0x03D7},
 {0,0x03D8,0x03D8,0x03D8}, {0,0x03D9,0x03D9,0x03D9}, {1,0x03DB,0x03DA,0x03DB}, {1,0x03DB,0x03DB,0x03DB},
 {1,0x03DD,0x03DC,0x03DD}, {1,0x03DD,0x03DD,0x03DD}, {1,0x03DF,0x03DE,0x03DF}, {1,0x03DF,0x03DF,0x03DF},
 {1,0x03E1,0x03E0,0x03E1}, {1,0x03E1,0x03E1,0x03E1}, {1,0x03E3,0x03E2,0x03E3}, {1,0x03E3,0x03E3,0x03E3},
 {1,0x03E5,0x03E4,0x03E5}, {1,0x03E5,0x03E5,0x03E5}, {1,0x03E7,0x03E6,0x03E7}, {1,0x03E7,0x03E7,0x03E7},
 {1,0x03E9,0x03E8,0x03E9}, {1,0x03E9,0x03E9,0x03E9}, {1,0x03EB,0x03EA,0x03EB}, {1,0x03EB,0x03EB,0x03EB},
 {1,0x03ED,0x03EC,0x03ED}, {1,0x03ED,0x03ED,0x03ED}, {1,0x03EF,0x03EE,0x03EF}, {1,0x03EF,0x03EF,0x03EF},
 {1,0x03F0,0x03F0,0x03F0}, {1,0x03F1,0x03F1,0x03F1}, {1,0x03F2,0x03F2,0x03F2}, {1,0x03F3,0x03F3,0x03F3},
 {0,0x03F4,0x03F4,0x03F4}, {0,0x03F5,0x03F5,0x03F5}, {0,0x03F6,0x03F6,0x03F6}, {0,0x03F7,0x03F7,0x03F7},
 {0,0x03F8,0x03F8,0x03F8}, {0,0x03F9,0x03F9,0x03F9}, {0,0x03FA,0x03FA,0x03FA}, {0,0x03FB,0x03FB,0x03FB},
 {0,0x03FC,0x03FC,0x03FC}, {0,0x03FD,0x03FD,0x03FD}, {0,0x03FE,0x03FE,0x03FE}, {0,0x03FF,0x03FF,0x03FF},
{0,0}};

static UDM_UNICODE plane04[257]={
 {1,0x0450,0x0415,0x0435}, {1,0x0451,0x0415,0x0435}, {1,0x0452,0x0402,0x0452}, {1,0x0453,0x0413,0x0433},
 {1,0x0454,0x0404,0x0454}, {1,0x0455,0x0405,0x0455}, {1,0x0456,0x0406,0x0456}, {1,0x0457,0x0406,0x0456},
 {1,0x0458,0x0408,0x0458}, {1,0x0459,0x0409,0x0459}, {1,0x045A,0x040A,0x045A}, {1,0x045B,0x040B,0x045B},
 {1,0x045C,0x041A,0x043A}, {1,0x045D,0x0418,0x0438}, {1,0x045E,0x0423,0x0443}, {1,0x045F,0x040F,0x045F},
 {1,0x0430,0x0410,0x0430}, {1,0x0431,0x0411,0x0431}, {1,0x0432,0x0412,0x0432}, {1,0x0433,0x0413,0x0433},
 {1,0x0434,0x0414,0x0434}, {1,0x0435,0x0415,0x0435}, {1,0x0436,0x0416,0x0436}, {1,0x0437,0x0417,0x0437},
 {1,0x0438,0x0418,0x0438}, {1,0x0439,0x0418,0x0438}, {1,0x043A,0x041A,0x043A}, {1,0x043B,0x041B,0x043B},
 {1,0x043C,0x041C,0x043C}, {1,0x043D,0x041D,0x043D}, {1,0x043E,0x041E,0x043E}, {1,0x043F,0x041F,0x043F},
 {1,0x0440,0x0420,0x0440}, {1,0x0441,0x0421,0x0441}, {1,0x0442,0x0422,0x0442}, {1,0x0443,0x0423,0x0443},
 {1,0x0444,0x0424,0x0444}, {1,0x0445,0x0425,0x0445}, {1,0x0446,0x0426,0x0446}, {1,0x0447,0x0427,0x0447},
 {1,0x0448,0x0428,0x0448}, {1,0x0449,0x0429,0x0449}, {1,0x044A,0x042A,0x044A}, {1,0x044B,0x042B,0x044B},
 {1,0x044C,0x042C,0x044C}, {1,0x044D,0x042D,0x044D}, {1,0x044E,0x042E,0x044E}, {1,0x044F,0x042F,0x044F},
 {1,0x0430,0x0430,0x0430}, {1,0x0431,0x0431,0x0431}, {1,0x0432,0x0432,0x0432}, {1,0x0433,0x0433,0x0433},
 {1,0x0434,0x0434,0x0434}, {1,0x0435,0x0435,0x0435}, {1,0x0436,0x0436,0x0436}, {1,0x0437,0x0437,0x0437},
 {1,0x0438,0x0438,0x0438}, {1,0x0439,0x0438,0x0438}, {1,0x043A,0x043A,0x043A}, {1,0x043B,0x043B,0x043B},
 {1,0x043C,0x043C,0x043C}, {1,0x043D,0x043D,0x043D}, {1,0x043E,0x043E,0x043E}, {1,0x043F,0x043F,0x043F},
 {1,0x0440,0x0440,0x0440}, {1,0x0441,0x0441,0x0441}, {1,0x0442,0x0442,0x0442}, {1,0x0443,0x0443,0x0443},
 {1,0x0444,0x0444,0x0444}, {1,0x0445,0x0445,0x0445}, {1,0x0446,0x0446,0x0446}, {1,0x0447,0x0447,0x0447},
 {1,0x0448,0x0448,0x0448}, {1,0x0449,0x0449,0x0449}, {1,0x044A,0x044A,0x044A}, {1,0x044B,0x044B,0x044B},
 {1,0x044C,0x044C,0x044C}, {1,0x044D,0x044D,0x044D}, {1,0x044E,0x044E,0x044E}, {1,0x044F,0x044F,0x044F},
 {1,0x0450,0x0435,0x0435}, {1,0x0451,0x0435,0x0435}, {1,0x0452,0x0452,0x0452}, {1,0x0453,0x0433,0x0433},
 {1,0x0454,0x0454,0x0454}, {1,0x0455,0x0455,0x0455}, {1,0x0456,0x0456,0x0456}, {1,0x0457,0x0456,0x0456},
 {1,0x0458,0x0458,0x0458}, {1,0x0459,0x0459,0x0459}, {1,0x045A,0x045A,0x045A}, {1,0x045B,0x045B,0x045B},
 {1,0x045C,0x043A,0x043A}, {1,0x045D,0x0438,0x0438}, {1,0x045E,0x0443,0x0443}, {1,0x045F,0x045F,0x045F},
 {1,0x0461,0x0460,0x0461}, {1,0x0461,0x0461,0x0461}, {1,0x0463,0x0462,0x0463}, {1,0x0463,0x0463,0x0463},
 {1,0x0465,0x0464,0x0465}, {1,0x0465,0x0465,0x0465}, {1,0x0467,0x0466,0x0467}, {1,0x0467,0x0467,0x0467},
 {1,0x0469,0x0468,0x0469}, {1,0x0469,0x0469,0x0469}, {1,0x046B,0x046A,0x046B}, {1,0x046B,0x046B,0x046B},
 {1,0x046D,0x046C,0x046D}, {1,0x046D,0x046D,0x046D}, {1,0x046F,0x046E,0x046F}, {1,0x046F,0x046F,0x046F},
 {1,0x0471,0x0470,0x0471}, {1,0x0471,0x0471,0x0471}, {1,0x0473,0x0472,0x0473}, {1,0x0473,0x0473,0x0473},
 {1,0x0475,0x0474,0x0475}, {1,0x0475,0x0475,0x0475}, {1,0x0477,0x0474,0x0475}, {1,0x0477,0x0475,0x0475},
 {1,0x0479,0x0478,0x0479}, {1,0x0479,0x0479,0x0479}, {1,0x047B,0x047A,0x047B}, {1,0x047B,0x047B,0x047B},
 {1,0x047D,0x047C,0x047D}, {1,0x047D,0x047D,0x047D}, {1,0x047F,0x047E,0x047F}, {1,0x047F,0x047F,0x047F},
 {1,0x0481,0x0480,0x0481}, {1,0x0481,0x0481,0x0481}, {0,0x0482,0x0482,0x0482}, {1,0x0483,0x0483,0x0483},
 {1,0x0484,0x0484,0x0484}, {1,0x0485,0x0485,0x0485}, {1,0x0486,0x0486,0x0486}, {0,0x0487,0x0487,0x0487},
 {0,0x0488,0x0488,0x0488}, {0,0x0489,0x0489,0x0489}, {0,0x048A,0x048A,0x048A}, {0,0x048B,0x048B,0x048B},
 {1,0x048D,0x048C,0x048D}, {1,0x048D,0x048D,0x048D}, {1,0x048F,0x048E,0x048F}, {1,0x048F,0x048F,0x048F},
 {1,0x0491,0x0490,0x0491}, {1,0x0491,0x0491,0x0491}, {1,0x0493,0x0492,0x0493}, {1,0x0493,0x0493,0x0493},
 {1,0x0495,0x0494,0x0495}, {1,0x0495,0x0495,0x0495}, {1,0x0497,0x0496,0x0497}, {1,0x0497,0x0497,0x0497},
 {1,0x0499,0x0498,0x0499}, {1,0x0499,0x0499,0x0499}, {1,0x049B,0x049A,0x049B}, {1,0x049B,0x049B,0x049B},
 {1,0x049D,0x049C,0x049D}, {1,0x049D,0x049D,0x049D}, {1,0x049F,0x049E,0x049F}, {1,0x049F,0x049F,0x049F},
 {1,0x04A1,0x04A0,0x04A1}, {1,0x04A1,0x04A1,0x04A1}, {1,0x04A3,0x04A2,0x04A3}, {1,0x04A3,0x04A3,0x04A3},
 {1,0x04A5,0x04A4,0x04A5}, {1,0x04A5,0x04A5,0x04A5}, {1,0x04A7,0x04A6,0x04A7}, {1,0x04A7,0x04A7,0x04A7},
 {1,0x04A9,0x04A8,0x04A9}, {1,0x04A9,0x04A9,0x04A9}, {1,0x04AB,0x04AA,0x04AB}, {1,0x04AB,0x04AB,0x04AB},
 {1,0x04AD,0x04AC,0x04AD}, {1,0x04AD,0x04AD,0x04AD}, {1,0x04AF,0x04AE,0x04AF}, {1,0x04AF,0x04AF,0x04AF},
 {1,0x04B1,0x04B0,0x04B1}, {1,0x04B1,0x04B1,0x04B1}, {1,0x04B3,0x04B2,0x04B3}, {1,0x04B3,0x04B3,0x04B3},
 {1,0x04B5,0x04B4,0x04B5}, {1,0x04B5,0x04B5,0x04B5}, {1,0x04B7,0x04B6,0x04B7}, {1,0x04B7,0x04B7,0x04B7},
 {1,0x04B9,0x04B8,0x04B9}, {1,0x04B9,0x04B9,0x04B9}, {1,0x04BB,0x04BA,0x04BB}, {1,0x04BB,0x04BB,0x04BB},
 {1,0x04BD,0x04BC,0x04BD}, {1,0x04BD,0x04BD,0x04BD}, {1,0x04BF,0x04BE,0x04BF}, {1,0x04BF,0x04BF,0x04BF},
 {1,0x04C0,0x04C0,0x04C0}, {1,0x04C2,0x0416,0x0436}, {1,0x04C2,0x0436,0x0436}, {1,0x04C4,0x04C3,0x04C4},
 {1,0x04C4,0x04C4,0x04C4}, {0,0x04C5,0x04C5,0x04C5}, {0,0x04C6,0x04C6,0x04C6}, {1,0x04C8,0x04C7,0x04C8},
 {1,0x04C8,0x04C8,0x04C8}, {0,0x04C9,0x04C9,0x04C9}, {0,0x04CA,0x04CA,0x04CA}, {1,0x04CC,0x04CB,0x04CC},
 {1,0x04CC,0x04CC,0x04CC}, {0,0x04CD,0x04CD,0x04CD}, {0,0x04CE,0x04CE,0x04CE}, {0,0x04CF,0x04CF,0x04CF},
 {1,0x04D1,0x0410,0x0430}, {1,0x04D1,0x0430,0x0430}, {1,0x04D3,0x0410,0x0430}, {1,0x04D3,0x0430,0x0430},
 {1,0x04D5,0x04D4,0x04D5}, {1,0x04D5,0x04D5,0x04D5}, {1,0x04D7,0x0415,0x0435}, {1,0x04D7,0x0435,0x0435},
 {1,0x04D9,0x04D8,0x04D9}, {1,0x04D9,0x04D9,0x04D9}, {1,0x04DB,0x04D8,0x04D9}, {1,0x04DB,0x04D9,0x04D9},
 {1,0x04DD,0x0416,0x0436}, {1,0x04DD,0x0436,0x0436}, {1,0x04DF,0x0417,0x0437}, {1,0x04DF,0x0437,0x0437},
 {1,0x04E1,0x04E0,0x04E1}, {1,0x04E1,0x04E1,0x04E1}, {1,0x04E3,0x0418,0x0438}, {1,0x04E3,0x0438,0x0438},
 {1,0x04E5,0x0418,0x0438}, {1,0x04E5,0x0438,0x0438}, {1,0x04E7,0x041E,0x043E}, {1,0x04E7,0x043E,0x043E},
 {1,0x04E9,0x04E8,0x04E9}, {1,0x04E9,0x04E9,0x04E9}, {1,0x04EB,0x04E8,0x04E9}, {1,0x04EB,0x04E9,0x04E9},
 {1,0x04ED,0x042D,0x044D}, {1,0x04ED,0x044D,0x044D}, {1,0x04EF,0x0423,0x0443}, {1,0x04EF,0x0443,0x0443},
 {1,0x04F1,0x0423,0x0443}, {1,0x04F1,0x0443,0x0443}, {1,0x04F3,0x0423,0x0443}, {1,0x04F3,0x0443,0x0443},
 {1,0x04F5,0x0427,0x0447}, {1,0x04F5,0x0447,0x0447}, {0,0x04F6,0x04F6,0x04F6}, {0,0x04F7,0x04F7,0x04F7},
 {1,0x04F9,0x042B,0x044B}, {1,0x04F9,0x044B,0x044B}, {0,0x04FA,0x04FA,0x04FA}, {0,0x04FB,0x04FB,0x04FB},
 {0,0x04FC,0x04FC,0x04FC}, {0,0x04FD,0x04FD,0x04FD}, {0,0x04FE,0x04FE,0x04FE}, {0,0x04FF,0x04FF,0x04FF},
{0,0}};

static UDM_UNICODE plane05[257]={
 {0,0x0500,0x0500,0x0500}, {0,0x0501,0x0501,0x0501}, {0,0x0502,0x0502,0x0502}, {0,0x0503,0x0503,0x0503},
 {0,0x0504,0x0504,0x0504}, {0,0x0505,0x0505,0x0505}, {0,0x0506,0x0506,0x0506}, {0,0x0507,0x0507,0x0507},
 {0,0x0508,0x0508,0x0508}, {0,0x0509,0x0509,0x0509}, {0,0x050A,0x050A,0x050A}, {0,0x050B,0x050B,0x050B},
 {0,0x050C,0x050C,0x050C}, {0,0x050D,0x050D,0x050D}, {0,0x050E,0x050E,0x050E}, {0,0x050F,0x050F,0x050F},
 {0,0x0510,0x0510,0x0510}, {0,0x0511,0x0511,0x0511}, {0,0x0512,0x0512,0x0512}, {0,0x0513,0x0513,0x0513},
 {0,0x0514,0x0514,0x0514}, {0,0x0515,0x0515,0x0515}, {0,0x0516,0x0516,0x0516}, {0,0x0517,0x0517,0x0517},
 {0,0x0518,0x0518,0x0518}, {0,0x0519,0x0519,0x0519}, {0,0x051A,0x051A,0x051A}, {0,0x051B,0x051B,0x051B},
 {0,0x051C,0x051C,0x051C}, {0,0x051D,0x051D,0x051D}, {0,0x051E,0x051E,0x051E}, {0,0x051F,0x051F,0x051F},
 {0,0x0520,0x0520,0x0520}, {0,0x0521,0x0521,0x0521}, {0,0x0522,0x0522,0x0522}, {0,0x0523,0x0523,0x0523},
 {0,0x0524,0x0524,0x0524}, {0,0x0525,0x0525,0x0525}, {0,0x0526,0x0526,0x0526}, {0,0x0527,0x0527,0x0527},
 {0,0x0528,0x0528,0x0528}, {0,0x0529,0x0529,0x0529}, {0,0x052A,0x052A,0x052A}, {0,0x052B,0x052B,0x052B},
 {0,0x052C,0x052C,0x052C}, {0,0x052D,0x052D,0x052D}, {0,0x052E,0x052E,0x052E}, {0,0x052F,0x052F,0x052F},
 {0,0x0530,0x0530,0x0530}, {1,0x0561,0x0531,0x0561}, {1,0x0562,0x0532,0x0562}, {1,0x0563,0x0533,0x0563},
 {1,0x0564,0x0534,0x0564}, {1,0x0565,0x0535,0x0565}, {1,0x0566,0x0536,0x0566}, {1,0x0567,0x0537,0x0567},
 {1,0x0568,0x0538,0x0568}, {1,0x0569,0x0539,0x0569}, {1,0x056A,0x053A,0x056A}, {1,0x056B,0x053B,0x056B},
 {1,0x056C,0x053C,0x056C}, {1,0x056D,0x053D,0x056D}, {1,0x056E,0x053E,0x056E}, {1,0x056F,0x053F,0x056F},
 {1,0x0570,0x0540,0x0570}, {1,0x0571,0x0541,0x0571}, {1,0x0572,0x0542,0x0572}, {1,0x0573,0x0543,0x0573},
 {1,0x0574,0x0544,0x0574}, {1,0x0575,0x0545,0x0575}, {1,0x0576,0x0546,0x0576}, {1,0x0577,0x0547,0x0577},
 {1,0x0578,0x0548,0x0578}, {1,0x0579,0x0549,0x0579}, {1,0x057A,0x054A,0x057A}, {1,0x057B,0x054B,0x057B},
 {1,0x057C,0x054C,0x057C}, {1,0x057D,0x054D,0x057D}, {1,0x057E,0x054E,0x057E}, {1,0x057F,0x054F,0x057F},
 {1,0x0580,0x0550,0x0580}, {1,0x0581,0x0551,0x0581}, {1,0x0582,0x0552,0x0582}, {1,0x0583,0x0553,0x0583},
 {1,0x0584,0x0554,0x0584}, {1,0x0585,0x0555,0x0585}, {1,0x0586,0x0556,0x0586}, {0,0x0557,0x0557,0x0557},
 {0,0x0558,0x0558,0x0558}, {1,0x0559,0x0559,0x0559}, {0,0x055A,0x055A,0x055A}, {0,0x055B,0x055B,0x055B},
 {0,0x055C,0x055C,0x055C}, {0,0x055D,0x055D,0x055D}, {0,0x055E,0x055E,0x055E}, {0,0x055F,0x055F,0x055F},
 {0,0x0560,0x0560,0x0560}, {1,0x0561,0x0561,0x0561}, {1,0x0562,0x0562,0x0562}, {1,0x0563,0x0563,0x0563},
 {1,0x0564,0x0564,0x0564}, {1,0x0565,0x0565,0x0565}, {1,0x0566,0x0566,0x0566}, {1,0x0567,0x0567,0x0567},
 {1,0x0568,0x0568,0x0568}, {1,0x0569,0x0569,0x0569}, {1,0x056A,0x056A,0x056A}, {1,0x056B,0x056B,0x056B},
 {1,0x056C,0x056C,0x056C}, {1,0x056D,0x056D,0x056D}, {1,0x056E,0x056E,0x056E}, {1,0x056F,0x056F,0x056F},
 {1,0x0570,0x0570,0x0570}, {1,0x0571,0x0571,0x0571}, {1,0x0572,0x0572,0x0572}, {1,0x0573,0x0573,0x0573},
 {1,0x0574,0x0574,0x0574}, {1,0x0575,0x0575,0x0575}, {1,0x0576,0x0576,0x0576}, {1,0x0577,0x0577,0x0577},
 {1,0x0578,0x0578,0x0578}, {1,0x0579,0x0579,0x0579}, {1,0x057A,0x057A,0x057A}, {1,0x057B,0x057B,0x057B},
 {1,0x057C,0x057C,0x057C}, {1,0x057D,0x057D,0x057D}, {1,0x057E,0x057E,0x057E}, {1,0x057F,0x057F,0x057F},
 {1,0x0580,0x0580,0x0580}, {1,0x0581,0x0581,0x0581}, {1,0x0582,0x0582,0x0582}, {1,0x0583,0x0583,0x0583},
 {1,0x0584,0x0584,0x0584}, {1,0x0585,0x0585,0x0585}, {1,0x0586,0x0586,0x0586}, {1,0x0587,0x0587,0x0587},
 {0,0x0588,0x0588,0x0588}, {0,0x0589,0x0589,0x0589}, {0,0x058A,0x058A,0x058A}, {0,0x058B,0x058B,0x058B},
 {0,0x058C,0x058C,0x058C}, {0,0x058D,0x058D,0x058D}, {0,0x058E,0x058E,0x058E}, {0,0x058F,0x058F,0x058F},
 {0,0x0590,0x0590,0x0590}, {1,0x0591,0x0591,0x0591}, {1,0x0592,0x0592,0x0592}, {1,0x0593,0x0593,0x0593},
 {1,0x0594,0x0594,0x0594}, {1,0x0595,0x0595,0x0595}, {1,0x0596,0x0596,0x0596}, {1,0x0597,0x0597,0x0597},
 {1,0x0598,0x0598,0x0598}, {1,0x0599,0x0599,0x0599}, {1,0x059A,0x059A,0x059A}, {1,0x059B,0x059B,0x059B},
 {1,0x059C,0x059C,0x059C}, {1,0x059D,0x059D,0x059D}, {1,0x059E,0x059E,0x059E}, {1,0x059F,0x059F,0x059F},
 {1,0x05A0,0x05A0,0x05A0}, {1,0x05A1,0x05A1,0x05A1}, {0,0x05A2,0x05A2,0x05A2}, {1,0x05A3,0x05A3,0x05A3},
 {1,0x05A4,0x05A4,0x05A4}, {1,0x05A5,0x05A5,0x05A5}, {1,0x05A6,0x05A6,0x05A6}, {1,0x05A7,0x05A7,0x05A7},
 {1,0x05A8,0x05A8,0x05A8}, {1,0x05A9,0x05A9,0x05A9}, {1,0x05AA,0x05AA,0x05AA}, {1,0x05AB,0x05AB,0x05AB},
 {1,0x05AC,0x05AC,0x05AC}, {1,0x05AD,0x05AD,0x05AD}, {1,0x05AE,0x05AE,0x05AE}, {1,0x05AF,0x05AF,0x05AF},
 {1,0x05B0,0x05B0,0x05B0}, {1,0x05B1,0x05B1,0x05B1}, {1,0x05B2,0x05B2,0x05B2}, {1,0x05B3,0x05B3,0x05B3},
 {1,0x05B4,0x05B4,0x05B4}, {1,0x05B5,0x05B5,0x05B5}, {1,0x05B6,0x05B6,0x05B6}, {1,0x05B7,0x05B7,0x05B7},
 {1,0x05B8,0x05B8,0x05B8}, {1,0x05B9,0x05B9,0x05B9}, {0,0x05BA,0x05BA,0x05BA}, {1,0x05BB,0x05BB,0x05BB},
 {1,0x05BC,0x05BC,0x05BC}, {1,0x05BD,0x05BD,0x05BD}, {0,0x05BE,0x05BE,0x05BE}, {1,0x05BF,0x05BF,0x05BF},
 {0,0x05C0,0x05C0,0x05C0}, {1,0x05C1,0x05C1,0x05C1}, {1,0x05C2,0x05C2,0x05C2}, {0,0x05C3,0x05C3,0x05C3},
 {1,0x05C4,0x05C4,0x05C4}, {0,0x05C5,0x05C5,0x05C5}, {0,0x05C6,0x05C6,0x05C6}, {0,0x05C7,0x05C7,0x05C7},
 {0,0x05C8,0x05C8,0x05C8}, {0,0x05C9,0x05C9,0x05C9}, {0,0x05CA,0x05CA,0x05CA}, {0,0x05CB,0x05CB,0x05CB},
 {0,0x05CC,0x05CC,0x05CC}, {0,0x05CD,0x05CD,0x05CD}, {0,0x05CE,0x05CE,0x05CE}, {0,0x05CF,0x05CF,0x05CF},
 {1,0x05D0,0x05D0,0x05D0}, {1,0x05D1,0x05D1,0x05D1}, {1,0x05D2,0x05D2,0x05D2}, {1,0x05D3,0x05D3,0x05D3},
 {1,0x05D4,0x05D4,0x05D4}, {1,0x05D5,0x05D5,0x05D5}, {1,0x05D6,0x05D6,0x05D6}, {1,0x05D7,0x05D7,0x05D7},
 {1,0x05D8,0x05D8,0x05D8}, {1,0x05D9,0x05D9,0x05D9}, {1,0x05DA,0x05DA,0x05DA}, {1,0x05DB,0x05DB,0x05DB},
 {1,0x05DC,0x05DC,0x05DC}, {1,0x05DD,0x05DD,0x05DD}, {1,0x05DE,0x05DE,0x05DE}, {1,0x05DF,0x05DF,0x05DF},
 {1,0x05E0,0x05E0,0x05E0}, {1,0x05E1,0x05E1,0x05E1}, {1,0x05E2,0x05E2,0x05E2}, {1,0x05E3,0x05E3,0x05E3},
 {1,0x05E4,0x05E4,0x05E4}, {1,0x05E5,0x05E5,0x05E5}, {1,0x05E6,0x05E6,0x05E6}, {1,0x05E7,0x05E7,0x05E7},
 {1,0x05E8,0x05E8,0x05E8}, {1,0x05E9,0x05E9,0x05E9}, {1,0x05EA,0x05EA,0x05EA}, {0,0x05EB,0x05EB,0x05EB},
 {0,0x05EC,0x05EC,0x05EC}, {0,0x05ED,0x05ED,0x05ED}, {0,0x05EE,0x05EE,0x05EE}, {0,0x05EF,0x05EF,0x05EF},
 {1,0x05F0,0x05F0,0x05F0}, {1,0x05F1,0x05F1,0x05F1}, {1,0x05F2,0x05F2,0x05F2}, {0,0x05F3,0x05F3,0x05F3},
 {0,0x05F4,0x05F4,0x05F4}, {0,0x05F5,0x05F5,0x05F5}, {0,0x05F6,0x05F6,0x05F6}, {0,0x05F7,0x05F7,0x05F7},
 {0,0x05F8,0x05F8,0x05F8}, {0,0x05F9,0x05F9,0x05F9}, {0,0x05FA,0x05FA,0x05FA}, {0,0x05FB,0x05FB,0x05FB},
 {0,0x05FC,0x05FC,0x05FC}, {0,0x05FD,0x05FD,0x05FD}, {0,0x05FE,0x05FE,0x05FE}, {0,0x05FF,0x05FF,0x05FF},
{0,0}};

static UDM_UNICODE plane06[257]={
 {0,0x0600,0x0600,0x0600}, {0,0x0601,0x0601,0x0601}, {0,0x0602,0x0602,0x0602}, {0,0x0603,0x0603,0x0603},
 {0,0x0604,0x0604,0x0604}, {0,0x0605,0x0605,0x0605}, {0,0x0606,0x0606,0x0606}, {0,0x0607,0x0607,0x0607},
 {0,0x0608,0x0608,0x0608}, {0,0x0609,0x0609,0x0609}, {0,0x060A,0x060A,0x060A}, {0,0x060B,0x060B,0x060B},
 {0,0x060C,0x060C,0x060C}, {0,0x060D,0x060D,0x060D}, {0,0x060E,0x060E,0x060E}, {0,0x060F,0x060F,0x060F},
 {0,0x0610,0x0610,0x0610}, {0,0x0611,0x0611,0x0611}, {0,0x0612,0x0612,0x0612}, {0,0x0613,0x0613,0x0613},
 {0,0x0614,0x0614,0x0614}, {0,0x0615,0x0615,0x0615}, {0,0x0616,0x0616,0x0616}, {0,0x0617,0x0617,0x0617},
 {0,0x0618,0x0618,0x0618}, {0,0x0619,0x0619,0x0619}, {0,0x061A,0x061A,0x061A}, {0,0x061B,0x061B,0x061B},
 {0,0x061C,0x061C,0x061C}, {0,0x061D,0x061D,0x061D}, {0,0x061E,0x061E,0x061E}, {0,0x061F,0x061F,0x061F},
 {0,0x0620,0x0620,0x0620}, {1,0x0621,0x0621,0x0621}, {1,0x0622,0x0622,0x0622}, {1,0x0623,0x0623,0x0623},
 {1,0x0624,0x0624,0x0624}, {1,0x0625,0x0625,0x0625}, {1,0x0626,0x0626,0x0626}, {1,0x0627,0x0627,0x0627},
 {1,0x0628,0x0628,0x0628}, {1,0x0629,0x0629,0x0629}, {1,0x062A,0x062A,0x062A}, {1,0x062B,0x062B,0x062B},
 {1,0x062C,0x062C,0x062C}, {1,0x062D,0x062D,0x062D}, {1,0x062E,0x062E,0x062E}, {1,0x062F,0x062F,0x062F},
 {1,0x0630,0x0630,0x0630}, {1,0x0631,0x0631,0x0631}, {1,0x0632,0x0632,0x0632}, {1,0x0633,0x0633,0x0633},
 {1,0x0634,0x0634,0x0634}, {1,0x0635,0x0635,0x0635}, {1,0x0636,0x0636,0x0636}, {1,0x0637,0x0637,0x0637},
 {1,0x0638,0x0638,0x0638}, {1,0x0639,0x0639,0x0639}, {1,0x063A,0x063A,0x063A}, {0,0x063B,0x063B,0x063B},
 {0,0x063C,0x063C,0x063C}, {0,0x063D,0x063D,0x063D}, {0,0x063E,0x063E,0x063E}, {0,0x063F,0x063F,0x063F},
 {1,0x0640,0x0640,0x0640}, {1,0x0641,0x0641,0x0641}, {1,0x0642,0x0642,0x0642}, {1,0x0643,0x0643,0x0643},
 {1,0x0644,0x0644,0x0644}, {1,0x0645,0x0645,0x0645}, {1,0x0646,0x0646,0x0646}, {1,0x0647,0x0647,0x0647},
 {1,0x0648,0x0648,0x0648}, {1,0x0649,0x0649,0x0649}, {1,0x064A,0x064A,0x064A}, {1,0x064B,0x064B,0x064B},
 {1,0x064C,0x064C,0x064C}, {1,0x064D,0x064D,0x064D}, {1,0x064E,0x064E,0x064E}, {1,0x064F,0x064F,0x064F},
 {1,0x0650,0x0650,0x0650}, {1,0x0651,0x0651,0x0651}, {1,0x0652,0x0652,0x0652}, {1,0x0653,0x0653,0x0653},
 {1,0x0654,0x0654,0x0654}, {1,0x0655,0x0655,0x0655}, {0,0x0656,0x0656,0x0656}, {0,0x0657,0x0657,0x0657},
 {0,0x0658,0x0658,0x0658}, {0,0x0659,0x0659,0x0659}, {0,0x065A,0x065A,0x065A}, {0,0x065B,0x065B,0x065B},
 {0,0x065C,0x065C,0x065C}, {0,0x065D,0x065D,0x065D}, {0,0x065E,0x065E,0x065E}, {0,0x065F,0x065F,0x065F},
 {2,0x0660,0x0660,0x0660}, {2,0x0661,0x0661,0x0661}, {2,0x0662,0x0662,0x0662}, {2,0x0663,0x0663,0x0663},
 {2,0x0664,0x0664,0x0664}, {2,0x0665,0x0665,0x0665}, {2,0x0666,0x0666,0x0666}, {2,0x0667,0x0667,0x0667},
 {2,0x0668,0x0668,0x0668}, {2,0x0669,0x0669,0x0669}, {0,0x066A,0x066A,0x066A}, {0,0x066B,0x066B,0x066B},
 {0,0x066C,0x066C,0x066C}, {0,0x066D,0x066D,0x066D}, {0,0x066E,0x066E,0x066E}, {0,0x066F,0x066F,0x066F},
 {1,0x0670,0x0670,0x0670}, {1,0x0671,0x0671,0x0671}, {1,0x0672,0x0672,0x0672}, {1,0x0673,0x0673,0x0673},
 {1,0x0674,0x0674,0x0674}, {1,0x0675,0x0675,0x0675}, {1,0x0676,0x0676,0x0676}, {1,0x0677,0x0677,0x0677},
 {1,0x0678,0x0678,0x0678}, {1,0x0679,0x0679,0x0679}, {1,0x067A,0x067A,0x067A}, {1,0x067B,0x067B,0x067B},
 {1,0x067C,0x067C,0x067C}, {1,0x067D,0x067D,0x067D}, {1,0x067E,0x067E,0x067E}, {1,0x067F,0x067F,0x067F},
 {1,0x0680,0x0680,0x0680}, {1,0x0681,0x0681,0x0681}, {1,0x0682,0x0682,0x0682}, {1,0x0683,0x0683,0x0683},
 {1,0x0684,0x0684,0x0684}, {1,0x0685,0x0685,0x0685}, {1,0x0686,0x0686,0x0686}, {1,0x0687,0x0687,0x0687},
 {1,0x0688,0x0688,0x0688}, {1,0x0689,0x0689,0x0689}, {1,0x068A,0x068A,0x068A}, {1,0x068B,0x068B,0x068B},
 {1,0x068C,0x068C,0x068C}, {1,0x068D,0x068D,0x068D}, {1,0x068E,0x068E,0x068E}, {1,0x068F,0x068F,0x068F},
 {1,0x0690,0x0690,0x0690}, {1,0x0691,0x0691,0x0691}, {1,0x0692,0x0692,0x0692}, {1,0x0693,0x0693,0x0693},
 {1,0x0694,0x0694,0x0694}, {1,0x0695,0x0695,0x0695}, {1,0x0696,0x0696,0x0696}, {1,0x0697,0x0697,0x0697},
 {1,0x0698,0x0698,0x0698}, {1,0x0699,0x0699,0x0699}, {1,0x069A,0x069A,0x069A}, {1,0x069B,0x069B,0x069B},
 {1,0x069C,0x069C,0x069C}, {1,0x069D,0x069D,0x069D}, {1,0x069E,0x069E,0x069E}, {1,0x069F,0x069F,0x069F},
 {1,0x06A0,0x06A0,0x06A0}, {1,0x06A1,0x06A1,0x06A1}, {1,0x06A2,0x06A2,0x06A2}, {1,0x06A3,0x06A3,0x06A3},
 {1,0x06A4,0x06A4,0x06A4}, {1,0x06A5,0x06A5,0x06A5}, {1,0x06A6,0x06A6,0x06A6}, {1,0x06A7,0x06A7,0x06A7},
 {1,0x06A8,0x06A8,0x06A8}, {1,0x06A9,0x06A9,0x06A9}, {1,0x06AA,0x06AA,0x06AA}, {1,0x06AB,0x06AB,0x06AB},
 {1,0x06AC,0x06AC,0x06AC}, {1,0x06AD,0x06AD,0x06AD}, {1,0x06AE,0x06AE,0x06AE}, {1,0x06AF,0x06AF,0x06AF},
 {1,0x06B0,0x06B0,0x06B0}, {1,0x06B1,0x06B1,0x06B1}, {1,0x06B2,0x06B2,0x06B2}, {1,0x06B3,0x06B3,0x06B3},
 {1,0x06B4,0x06B4,0x06B4}, {1,0x06B5,0x06B5,0x06B5}, {1,0x06B6,0x06B6,0x06B6}, {1,0x06B7,0x06B7,0x06B7},
 {1,0x06B8,0x06B8,0x06B8}, {1,0x06B9,0x06B9,0x06B9}, {1,0x06BA,0x06BA,0x06BA}, {1,0x06BB,0x06BB,0x06BB},
 {1,0x06BC,0x06BC,0x06BC}, {1,0x06BD,0x06BD,0x06BD}, {1,0x06BE,0x06BE,0x06BE}, {1,0x06BF,0x06BF,0x06BF},
 {1,0x06C0,0x06C0,0x06C0}, {1,0x06C1,0x06C1,0x06C1}, {1,0x06C2,0x06C2,0x06C2}, {1,0x06C3,0x06C3,0x06C3},
 {1,0x06C4,0x06C4,0x06C4}, {1,0x06C5,0x06C5,0x06C5}, {1,0x06C6,0x06C6,0x06C6}, {1,0x06C7,0x06C7,0x06C7},
 {1,0x06C8,0x06C8,0x06C8}, {1,0x06C9,0x06C9,0x06C9}, {1,0x06CA,0x06CA,0x06CA}, {1,0x06CB,0x06CB,0x06CB},
 {1,0x06CC,0x06CC,0x06CC}, {1,0x06CD,0x06CD,0x06CD}, {1,0x06CE,0x06CE,0x06CE}, {1,0x06CF,0x06CF,0x06CF},
 {1,0x06D0,0x06D0,0x06D0}, {1,0x06D1,0x06D1,0x06D1}, {1,0x06D2,0x06D2,0x06D2}, {1,0x06D3,0x06D3,0x06D3},
 {0,0x06D4,0x06D4,0x06D4}, {1,0x06D5,0x06D5,0x06D5}, {1,0x06D6,0x06D6,0x06D6}, {1,0x06D7,0x06D7,0x06D7},
 {1,0x06D8,0x06D8,0x06D8}, {1,0x06D9,0x06D9,0x06D9}, {1,0x06DA,0x06DA,0x06DA}, {1,0x06DB,0x06DB,0x06DB},
 {1,0x06DC,0x06DC,0x06DC}, {0,0x06DD,0x06DD,0x06DD}, {0,0x06DE,0x06DE,0x06DE}, {1,0x06DF,0x06DF,0x06DF},
 {1,0x06E0,0x06E0,0x06E0}, {1,0x06E1,0x06E1,0x06E1}, {1,0x06E2,0x06E2,0x06E2}, {1,0x06E3,0x06E3,0x06E3},
 {1,0x06E4,0x06E4,0x06E4}, {1,0x06E5,0x06E5,0x06E5}, {1,0x06E6,0x06E6,0x06E6}, {1,0x06E7,0x06E7,0x06E7},
 {1,0x06E8,0x06E8,0x06E8}, {0,0x06E9,0x06E9,0x06E9}, {1,0x06EA,0x06EA,0x06EA}, {1,0x06EB,0x06EB,0x06EB},
 {1,0x06EC,0x06EC,0x06EC}, {1,0x06ED,0x06ED,0x06ED}, {0,0x06EE,0x06EE,0x06EE}, {0,0x06EF,0x06EF,0x06EF},
 {2,0x06F0,0x06F0,0x06F0}, {2,0x06F1,0x06F1,0x06F1}, {2,0x06F2,0x06F2,0x06F2}, {2,0x06F3,0x06F3,0x06F3},
 {2,0x06F4,0x06F4,0x06F4}, {2,0x06F5,0x06F5,0x06F5}, {2,0x06F6,0x06F6,0x06F6}, {2,0x06F7,0x06F7,0x06F7},
 {2,0x06F8,0x06F8,0x06F8}, {2,0x06F9,0x06F9,0x06F9}, {1,0x06FA,0x06FA,0x06FA}, {1,0x06FB,0x06FB,0x06FB},
 {1,0x06FC,0x06FC,0x06FC}, {0,0x06FD,0x06FD,0x06FD}, {0,0x06FE,0x06FE,0x06FE}, {0,0x06FF,0x06FF,0x06FF},
{0,0}};

static UDM_UNICODE plane07[257]={
 {0,0x0700,0x0700,0x0700}, {0,0x0701,0x0701,0x0701}, {0,0x0702,0x0702,0x0702}, {0,0x0703,0x0703,0x0703},
 {0,0x0704,0x0704,0x0704}, {0,0x0705,0x0705,0x0705}, {0,0x0706,0x0706,0x0706}, {0,0x0707,0x0707,0x0707},
 {0,0x0708,0x0708,0x0708}, {0,0x0709,0x0709,0x0709}, {0,0x070A,0x070A,0x070A}, {0,0x070B,0x070B,0x070B},
 {0,0x070C,0x070C,0x070C}, {0,0x070D,0x070D,0x070D}, {0,0x070E,0x070E,0x070E}, {0,0x070F,0x070F,0x070F},
 {1,0x0710,0x0710,0x0710}, {1,0x0711,0x0711,0x0711}, {1,0x0712,0x0712,0x0712}, {1,0x0713,0x0713,0x0713},
 {1,0x0714,0x0714,0x0714}, {1,0x0715,0x0715,0x0715}, {1,0x0716,0x0716,0x0716}, {1,0x0717,0x0717,0x0717},
 {1,0x0718,0x0718,0x0718}, {1,0x0719,0x0719,0x0719}, {1,0x071A,0x071A,0x071A}, {1,0x071B,0x071B,0x071B},
 {1,0x071C,0x071C,0x071C}, {1,0x071D,0x071D,0x071D}, {1,0x071E,0x071E,0x071E}, {1,0x071F,0x071F,0x071F},
 {1,0x0720,0x0720,0x0720}, {1,0x0721,0x0721,0x0721}, {1,0x0722,0x0722,0x0722}, {1,0x0723,0x0723,0x0723},
 {1,0x0724,0x0724,0x0724}, {1,0x0725,0x0725,0x0725}, {1,0x0726,0x0726,0x0726}, {1,0x0727,0x0727,0x0727},
 {1,0x0728,0x0728,0x0728}, {1,0x0729,0x0729,0x0729}, {1,0x072A,0x072A,0x072A}, {1,0x072B,0x072B,0x072B},
 {1,0x072C,0x072C,0x072C}, {0,0x072D,0x072D,0x072D}, {0,0x072E,0x072E,0x072E}, {0,0x072F,0x072F,0x072F},
 {1,0x0730,0x0730,0x0730}, {1,0x0731,0x0731,0x0731}, {1,0x0732,0x0732,0x0732}, {1,0x0733,0x0733,0x0733},
 {1,0x0734,0x0734,0x0734}, {1,0x0735,0x0735,0x0735}, {1,0x0736,0x0736,0x0736}, {1,0x0737,0x0737,0x0737},
 {1,0x0738,0x0738,0x0738}, {1,0x0739,0x0739,0x0739}, {1,0x073A,0x073A,0x073A}, {1,0x073B,0x073B,0x073B},
 {1,0x073C,0x073C,0x073C}, {1,0x073D,0x073D,0x073D}, {1,0x073E,0x073E,0x073E}, {1,0x073F,0x073F,0x073F},
 {1,0x0740,0x0740,0x0740}, {1,0x0741,0x0741,0x0741}, {1,0x0742,0x0742,0x0742}, {1,0x0743,0x0743,0x0743},
 {1,0x0744,0x0744,0x0744}, {1,0x0745,0x0745,0x0745}, {1,0x0746,0x0746,0x0746}, {1,0x0747,0x0747,0x0747},
 {1,0x0748,0x0748,0x0748}, {1,0x0749,0x0749,0x0749}, {1,0x074A,0x074A,0x074A}, {0,0x074B,0x074B,0x074B},
 {0,0x074C,0x074C,0x074C}, {0,0x074D,0x074D,0x074D}, {0,0x074E,0x074E,0x074E}, {0,0x074F,0x074F,0x074F},
 {0,0x0750,0x0750,0x0750}, {0,0x0751,0x0751,0x0751}, {0,0x0752,0x0752,0x0752}, {0,0x0753,0x0753,0x0753},
 {0,0x0754,0x0754,0x0754}, {0,0x0755,0x0755,0x0755}, {0,0x0756,0x0756,0x0756}, {0,0x0757,0x0757,0x0757},
 {0,0x0758,0x0758,0x0758}, {0,0x0759,0x0759,0x0759}, {0,0x075A,0x075A,0x075A}, {0,0x075B,0x075B,0x075B},
 {0,0x075C,0x075C,0x075C}, {0,0x075D,0x075D,0x075D}, {0,0x075E,0x075E,0x075E}, {0,0x075F,0x075F,0x075F},
 {0,0x0760,0x0760,0x0760}, {0,0x0761,0x0761,0x0761}, {0,0x0762,0x0762,0x0762}, {0,0x0763,0x0763,0x0763},
 {0,0x0764,0x0764,0x0764}, {0,0x0765,0x0765,0x0765}, {0,0x0766,0x0766,0x0766}, {0,0x0767,0x0767,0x0767},
 {0,0x0768,0x0768,0x0768}, {0,0x0769,0x0769,0x0769}, {0,0x076A,0x076A,0x076A}, {0,0x076B,0x076B,0x076B},
 {0,0x076C,0x076C,0x076C}, {0,0x076D,0x076D,0x076D}, {0,0x076E,0x076E,0x076E}, {0,0x076F,0x076F,0x076F},
 {0,0x0770,0x0770,0x0770}, {0,0x0771,0x0771,0x0771}, {0,0x0772,0x0772,0x0772}, {0,0x0773,0x0773,0x0773},
 {0,0x0774,0x0774,0x0774}, {0,0x0775,0x0775,0x0775}, {0,0x0776,0x0776,0x0776}, {0,0x0777,0x0777,0x0777},
 {0,0x0778,0x0778,0x0778}, {0,0x0779,0x0779,0x0779}, {0,0x077A,0x077A,0x077A}, {0,0x077B,0x077B,0x077B},
 {0,0x077C,0x077C,0x077C}, {0,0x077D,0x077D,0x077D}, {0,0x077E,0x077E,0x077E}, {0,0x077F,0x077F,0x077F},
 {1,0x0780,0x0780,0x0780}, {1,0x0781,0x0781,0x0781}, {1,0x0782,0x0782,0x0782}, {1,0x0783,0x0783,0x0783},
 {1,0x0784,0x0784,0x0784}, {1,0x0785,0x0785,0x0785}, {1,0x0786,0x0786,0x0786}, {1,0x0787,0x0787,0x0787},
 {1,0x0788,0x0788,0x0788}, {1,0x0789,0x0789,0x0789}, {1,0x078A,0x078A,0x078A}, {1,0x078B,0x078B,0x078B},
 {1,0x078C,0x078C,0x078C}, {1,0x078D,0x078D,0x078D}, {1,0x078E,0x078E,0x078E}, {1,0x078F,0x078F,0x078F},
 {1,0x0790,0x0790,0x0790}, {1,0x0791,0x0791,0x0791}, {1,0x0792,0x0792,0x0792}, {1,0x0793,0x0793,0x0793},
 {1,0x0794,0x0794,0x0794}, {1,0x0795,0x0795,0x0795}, {1,0x0796,0x0796,0x0796}, {1,0x0797,0x0797,0x0797},
 {1,0x0798,0x0798,0x0798}, {1,0x0799,0x0799,0x0799}, {1,0x079A,0x079A,0x079A}, {1,0x079B,0x079B,0x079B},
 {1,0x079C,0x079C,0x079C}, {1,0x079D,0x079D,0x079D}, {1,0x079E,0x079E,0x079E}, {1,0x079F,0x079F,0x079F},
 {1,0x07A0,0x07A0,0x07A0}, {1,0x07A1,0x07A1,0x07A1}, {1,0x07A2,0x07A2,0x07A2}, {1,0x07A3,0x07A3,0x07A3},
 {1,0x07A4,0x07A4,0x07A4}, {1,0x07A5,0x07A5,0x07A5}, {1,0x07A6,0x07A6,0x07A6}, {1,0x07A7,0x07A7,0x07A7},
 {1,0x07A8,0x07A8,0x07A8}, {1,0x07A9,0x07A9,0x07A9}, {1,0x07AA,0x07AA,0x07AA}, {1,0x07AB,0x07AB,0x07AB},
 {1,0x07AC,0x07AC,0x07AC}, {1,0x07AD,0x07AD,0x07AD}, {1,0x07AE,0x07AE,0x07AE}, {1,0x07AF,0x07AF,0x07AF},
 {1,0x07B0,0x07B0,0x07B0}, {0,0x07B1,0x07B1,0x07B1}, {0,0x07B2,0x07B2,0x07B2}, {0,0x07B3,0x07B3,0x07B3},
 {0,0x07B4,0x07B4,0x07B4}, {0,0x07B5,0x07B5,0x07B5}, {0,0x07B6,0x07B6,0x07B6}, {0,0x07B7,0x07B7,0x07B7},
 {0,0x07B8,0x07B8,0x07B8}, {0,0x07B9,0x07B9,0x07B9}, {0,0x07BA,0x07BA,0x07BA}, {0,0x07BB,0x07BB,0x07BB},
 {0,0x07BC,0x07BC,0x07BC}, {0,0x07BD,0x07BD,0x07BD}, {0,0x07BE,0x07BE,0x07BE}, {0,0x07BF,0x07BF,0x07BF},
 {0,0x07C0,0x07C0,0x07C0}, {0,0x07C1,0x07C1,0x07C1}, {0,0x07C2,0x07C2,0x07C2}, {0,0x07C3,0x07C3,0x07C3},
 {0,0x07C4,0x07C4,0x07C4}, {0,0x07C5,0x07C5,0x07C5}, {0,0x07C6,0x07C6,0x07C6}, {0,0x07C7,0x07C7,0x07C7},
 {0,0x07C8,0x07C8,0x07C8}, {0,0x07C9,0x07C9,0x07C9}, {0,0x07CA,0x07CA,0x07CA}, {0,0x07CB,0x07CB,0x07CB},
 {0,0x07CC,0x07CC,0x07CC}, {0,0x07CD,0x07CD,0x07CD}, {0,0x07CE,0x07CE,0x07CE}, {0,0x07CF,0x07CF,0x07CF},
 {0,0x07D0,0x07D0,0x07D0}, {0,0x07D1,0x07D1,0x07D1}, {0,0x07D2,0x07D2,0x07D2}, {0,0x07D3,0x07D3,0x07D3},
 {0,0x07D4,0x07D4,0x07D4}, {0,0x07D5,0x07D5,0x07D5}, {0,0x07D6,0x07D6,0x07D6}, {0,0x07D7,0x07D7,0x07D7},
 {0,0x07D8,0x07D8,0x07D8}, {0,0x07D9,0x07D9,0x07D9}, {0,0x07DA,0x07DA,0x07DA}, {0,0x07DB,0x07DB,0x07DB},
 {0,0x07DC,0x07DC,0x07DC}, {0,0x07DD,0x07DD,0x07DD}, {0,0x07DE,0x07DE,0x07DE}, {0,0x07DF,0x07DF,0x07DF},
 {0,0x07E0,0x07E0,0x07E0}, {0,0x07E1,0x07E1,0x07E1}, {0,0x07E2,0x07E2,0x07E2}, {0,0x07E3,0x07E3,0x07E3},
 {0,0x07E4,0x07E4,0x07E4}, {0,0x07E5,0x07E5,0x07E5}, {0,0x07E6,0x07E6,0x07E6}, {0,0x07E7,0x07E7,0x07E7},
 {0,0x07E8,0x07E8,0x07E8}, {0,0x07E9,0x07E9,0x07E9}, {0,0x07EA,0x07EA,0x07EA}, {0,0x07EB,0x07EB,0x07EB},
 {0,0x07EC,0x07EC,0x07EC}, {0,0x07ED,0x07ED,0x07ED}, {0,0x07EE,0x07EE,0x07EE}, {0,0x07EF,0x07EF,0x07EF},
 {0,0x07F0,0x07F0,0x07F0}, {0,0x07F1,0x07F1,0x07F1}, {0,0x07F2,0x07F2,0x07F2}, {0,0x07F3,0x07F3,0x07F3},
 {0,0x07F4,0x07F4,0x07F4}, {0,0x07F5,0x07F5,0x07F5}, {0,0x07F6,0x07F6,0x07F6}, {0,0x07F7,0x07F7,0x07F7},
 {0,0x07F8,0x07F8,0x07F8}, {0,0x07F9,0x07F9,0x07F9}, {0,0x07FA,0x07FA,0x07FA}, {0,0x07FB,0x07FB,0x07FB},
 {0,0x07FC,0x07FC,0x07FC}, {0,0x07FD,0x07FD,0x07FD}, {0,0x07FE,0x07FE,0x07FE}, {0,0x07FF,0x07FF,0x07FF},
{0,0}};

static UDM_UNICODE plane09[257]={
 {0,0x0900,0x0900,0x0900}, {1,0x0901,0x0901,0x0901}, {1,0x0902,0x0902,0x0902}, {1,0x0903,0x0903,0x0903},
 {0,0x0904,0x0904,0x0904}, {1,0x0905,0x0905,0x0905}, {1,0x0906,0x0906,0x0906}, {1,0x0907,0x0907,0x0907},
 {1,0x0908,0x0908,0x0908}, {1,0x0909,0x0909,0x0909}, {1,0x090A,0x090A,0x090A}, {1,0x090B,0x090B,0x090B},
 {1,0x090C,0x090C,0x090C}, {1,0x090D,0x090D,0x090D}, {1,0x090E,0x090E,0x090E}, {1,0x090F,0x090F,0x090F},
 {1,0x0910,0x0910,0x0910}, {1,0x0911,0x0911,0x0911}, {1,0x0912,0x0912,0x0912}, {1,0x0913,0x0913,0x0913},
 {1,0x0914,0x0914,0x0914}, {1,0x0915,0x0915,0x0915}, {1,0x0916,0x0916,0x0916}, {1,0x0917,0x0917,0x0917},
 {1,0x0918,0x0918,0x0918}, {1,0x0919,0x0919,0x0919}, {1,0x091A,0x091A,0x091A}, {1,0x091B,0x091B,0x091B},
 {1,0x091C,0x091C,0x091C}, {1,0x091D,0x091D,0x091D}, {1,0x091E,0x091E,0x091E}, {1,0x091F,0x091F,0x091F},
 {1,0x0920,0x0920,0x0920}, {1,0x0921,0x0921,0x0921}, {1,0x0922,0x0922,0x0922}, {1,0x0923,0x0923,0x0923},
 {1,0x0924,0x0924,0x0924}, {1,0x0925,0x0925,0x0925}, {1,0x0926,0x0926,0x0926}, {1,0x0927,0x0927,0x0927},
 {1,0x0928,0x0928,0x0928}, {1,0x0929,0x0929,0x0929}, {1,0x092A,0x092A,0x092A}, {1,0x092B,0x092B,0x092B},
 {1,0x092C,0x092C,0x092C}, {1,0x092D,0x092D,0x092D}, {1,0x092E,0x092E,0x092E}, {1,0x092F,0x092F,0x092F},
 {1,0x0930,0x0930,0x0930}, {1,0x0931,0x0931,0x0931}, {1,0x0932,0x0932,0x0932}, {1,0x0933,0x0933,0x0933},
 {1,0x0934,0x0934,0x0934}, {1,0x0935,0x0935,0x0935}, {1,0x0936,0x0936,0x0936}, {1,0x0937,0x0937,0x0937},
 {1,0x0938,0x0938,0x0938}, {1,0x0939,0x0939,0x0939}, {0,0x093A,0x093A,0x093A}, {0,0x093B,0x093B,0x093B},
 {1,0x093C,0x093C,0x093C}, {1,0x093D,0x093D,0x093D}, {1,0x093E,0x093E,0x093E}, {1,0x093F,0x093F,0x093F},
 {1,0x0940,0x0940,0x0940}, {1,0x0941,0x0941,0x0941}, {1,0x0942,0x0942,0x0942}, {1,0x0943,0x0943,0x0943},
 {1,0x0944,0x0944,0x0944}, {1,0x0945,0x0945,0x0945}, {1,0x0946,0x0946,0x0946}, {1,0x0947,0x0947,0x0947},
 {1,0x0948,0x0948,0x0948}, {1,0x0949,0x0949,0x0949}, {1,0x094A,0x094A,0x094A}, {1,0x094B,0x094B,0x094B},
 {1,0x094C,0x094C,0x094C}, {1,0x094D,0x094D,0x094D}, {0,0x094E,0x094E,0x094E}, {0,0x094F,0x094F,0x094F},
 {1,0x0950,0x0950,0x0950}, {1,0x0951,0x0951,0x0951}, {1,0x0952,0x0952,0x0952}, {1,0x0953,0x0953,0x0953},
 {1,0x0954,0x0954,0x0954}, {0,0x0955,0x0955,0x0955}, {0,0x0956,0x0956,0x0956}, {0,0x0957,0x0957,0x0957},
 {1,0x0958,0x0958,0x0958}, {1,0x0959,0x0959,0x0959}, {1,0x095A,0x095A,0x095A}, {1,0x095B,0x095B,0x095B},
 {1,0x095C,0x095C,0x095C}, {1,0x095D,0x095D,0x095D}, {1,0x095E,0x095E,0x095E}, {1,0x095F,0x095F,0x095F},
 {1,0x0960,0x0960,0x0960}, {1,0x0961,0x0961,0x0961}, {1,0x0962,0x0962,0x0962}, {1,0x0963,0x0963,0x0963},
 {0,0x0964,0x0964,0x0964}, {0,0x0965,0x0965,0x0965}, {2,0x0966,0x0966,0x0966}, {2,0x0967,0x0967,0x0967},
 {2,0x0968,0x0968,0x0968}, {2,0x0969,0x0969,0x0969}, {2,0x096A,0x096A,0x096A}, {2,0x096B,0x096B,0x096B},
 {2,0x096C,0x096C,0x096C}, {2,0x096D,0x096D,0x096D}, {2,0x096E,0x096E,0x096E}, {2,0x096F,0x096F,0x096F},
 {0,0x0970,0x0970,0x0970}, {0,0x0971,0x0971,0x0971}, {0,0x0972,0x0972,0x0972}, {0,0x0973,0x0973,0x0973},
 {0,0x0974,0x0974,0x0974}, {0,0x0975,0x0975,0x0975}, {0,0x0976,0x0976,0x0976}, {0,0x0977,0x0977,0x0977},
 {0,0x0978,0x0978,0x0978}, {0,0x0979,0x0979,0x0979}, {0,0x097A,0x097A,0x097A}, {0,0x097B,0x097B,0x097B},
 {0,0x097C,0x097C,0x097C}, {0,0x097D,0x097D,0x097D}, {0,0x097E,0x097E,0x097E}, {0,0x097F,0x097F,0x097F},
 {0,0x0980,0x0980,0x0980}, {1,0x0981,0x0981,0x0981}, {1,0x0982,0x0982,0x0982}, {1,0x0983,0x0983,0x0983},
 {0,0x0984,0x0984,0x0984}, {1,0x0985,0x0985,0x0985}, {1,0x0986,0x0986,0x0986}, {1,0x0987,0x0987,0x0987},
 {1,0x0988,0x0988,0x0988}, {1,0x0989,0x0989,0x0989}, {1,0x098A,0x098A,0x098A}, {1,0x098B,0x098B,0x098B},
 {1,0x098C,0x098C,0x098C}, {0,0x098D,0x098D,0x098D}, {0,0x098E,0x098E,0x098E}, {1,0x098F,0x098F,0x098F},
 {1,0x0990,0x0990,0x0990}, {0,0x0991,0x0991,0x0991}, {0,0x0992,0x0992,0x0992}, {1,0x0993,0x0993,0x0993},
 {1,0x0994,0x0994,0x0994}, {1,0x0995,0x0995,0x0995}, {1,0x0996,0x0996,0x0996}, {1,0x0997,0x0997,0x0997},
 {1,0x0998,0x0998,0x0998}, {1,0x0999,0x0999,0x0999}, {1,0x099A,0x099A,0x099A}, {1,0x099B,0x099B,0x099B},
 {1,0x099C,0x099C,0x099C}, {1,0x099D,0x099D,0x099D}, {1,0x099E,0x099E,0x099E}, {1,0x099F,0x099F,0x099F},
 {1,0x09A0,0x09A0,0x09A0}, {1,0x09A1,0x09A1,0x09A1}, {1,0x09A2,0x09A2,0x09A2}, {1,0x09A3,0x09A3,0x09A3},
 {1,0x09A4,0x09A4,0x09A4}, {1,0x09A5,0x09A5,0x09A5}, {1,0x09A6,0x09A6,0x09A6}, {1,0x09A7,0x09A7,0x09A7},
 {1,0x09A8,0x09A8,0x09A8}, {0,0x09A9,0x09A9,0x09A9}, {1,0x09AA,0x09AA,0x09AA}, {1,0x09AB,0x09AB,0x09AB},
 {1,0x09AC,0x09AC,0x09AC}, {1,0x09AD,0x09AD,0x09AD}, {1,0x09AE,0x09AE,0x09AE}, {1,0x09AF,0x09AF,0x09AF},
 {1,0x09B0,0x09B0,0x09B0}, {0,0x09B1,0x09B1,0x09B1}, {1,0x09B2,0x09B2,0x09B2}, {0,0x09B3,0x09B3,0x09B3},
 {0,0x09B4,0x09B4,0x09B4}, {0,0x09B5,0x09B5,0x09B5}, {1,0x09B6,0x09B6,0x09B6}, {1,0x09B7,0x09B7,0x09B7},
 {1,0x09B8,0x09B8,0x09B8}, {1,0x09B9,0x09B9,0x09B9}, {0,0x09BA,0x09BA,0x09BA}, {0,0x09BB,0x09BB,0x09BB},
 {1,0x09BC,0x09BC,0x09BC}, {0,0x09BD,0x09BD,0x09BD}, {1,0x09BE,0x09BE,0x09BE}, {1,0x09BF,0x09BF,0x09BF},
 {1,0x09C0,0x09C0,0x09C0}, {1,0x09C1,0x09C1,0x09C1}, {1,0x09C2,0x09C2,0x09C2}, {1,0x09C3,0x09C3,0x09C3},
 {1,0x09C4,0x09C4,0x09C4}, {0,0x09C5,0x09C5,0x09C5}, {0,0x09C6,0x09C6,0x09C6}, {1,0x09C7,0x09C7,0x09C7},
 {1,0x09C8,0x09C8,0x09C8}, {0,0x09C9,0x09C9,0x09C9}, {0,0x09CA,0x09CA,0x09CA}, {1,0x09CB,0x09CB,0x09CB},
 {1,0x09CC,0x09CC,0x09CC}, {1,0x09CD,0x09CD,0x09CD}, {0,0x09CE,0x09CE,0x09CE}, {0,0x09CF,0x09CF,0x09CF},
 {0,0x09D0,0x09D0,0x09D0}, {0,0x09D1,0x09D1,0x09D1}, {0,0x09D2,0x09D2,0x09D2}, {0,0x09D3,0x09D3,0x09D3},
 {0,0x09D4,0x09D4,0x09D4}, {0,0x09D5,0x09D5,0x09D5}, {0,0x09D6,0x09D6,0x09D6}, {1,0x09D7,0x09D7,0x09D7},
 {0,0x09D8,0x09D8,0x09D8}, {0,0x09D9,0x09D9,0x09D9}, {0,0x09DA,0x09DA,0x09DA}, {0,0x09DB,0x09DB,0x09DB},
 {1,0x09DC,0x09DC,0x09DC}, {1,0x09DD,0x09DD,0x09DD}, {0,0x09DE,0x09DE,0x09DE}, {1,0x09DF,0x09DF,0x09DF},
 {1,0x09E0,0x09E0,0x09E0}, {1,0x09E1,0x09E1,0x09E1}, {1,0x09E2,0x09E2,0x09E2}, {1,0x09E3,0x09E3,0x09E3},
 {0,0x09E4,0x09E4,0x09E4}, {0,0x09E5,0x09E5,0x09E5}, {2,0x09E6,0x09E6,0x09E6}, {2,0x09E7,0x09E7,0x09E7},
 {2,0x09E8,0x09E8,0x09E8}, {2,0x09E9,0x09E9,0x09E9}, {2,0x09EA,0x09EA,0x09EA}, {2,0x09EB,0x09EB,0x09EB},
 {2,0x09EC,0x09EC,0x09EC}, {2,0x09ED,0x09ED,0x09ED}, {2,0x09EE,0x09EE,0x09EE}, {2,0x09EF,0x09EF,0x09EF},
 {1,0x09F0,0x09F0,0x09F0}, {1,0x09F1,0x09F1,0x09F1}, {0,0x09F2,0x09F2,0x09F2}, {0,0x09F3,0x09F3,0x09F3},
 {0,0x09F4,0x09F4,0x09F4}, {0,0x09F5,0x09F5,0x09F5}, {0,0x09F6,0x09F6,0x09F6}, {0,0x09F7,0x09F7,0x09F7},
 {0,0x09F8,0x09F8,0x09F8}, {0,0x09F9,0x09F9,0x09F9}, {0,0x09FA,0x09FA,0x09FA}, {0,0x09FB,0x09FB,0x09FB},
 {0,0x09FC,0x09FC,0x09FC}, {0,0x09FD,0x09FD,0x09FD}, {0,0x09FE,0x09FE,0x09FE}, {0,0x09FF,0x09FF,0x09FF},
{0,0}};

static UDM_UNICODE plane0A[257]={
 {0,0x0A00,0x0A00,0x0A00}, {0,0x0A01,0x0A01,0x0A01}, {1,0x0A02,0x0A02,0x0A02}, {0,0x0A03,0x0A03,0x0A03},
 {0,0x0A04,0x0A04,0x0A04}, {1,0x0A05,0x0A05,0x0A05}, {1,0x0A06,0x0A06,0x0A06}, {1,0x0A07,0x0A07,0x0A07},
 {1,0x0A08,0x0A08,0x0A08}, {1,0x0A09,0x0A09,0x0A09}, {1,0x0A0A,0x0A0A,0x0A0A}, {0,0x0A0B,0x0A0B,0x0A0B},
 {0,0x0A0C,0x0A0C,0x0A0C}, {0,0x0A0D,0x0A0D,0x0A0D}, {0,0x0A0E,0x0A0E,0x0A0E}, {1,0x0A0F,0x0A0F,0x0A0F},
 {1,0x0A10,0x0A10,0x0A10}, {0,0x0A11,0x0A11,0x0A11}, {0,0x0A12,0x0A12,0x0A12}, {1,0x0A13,0x0A13,0x0A13},
 {1,0x0A14,0x0A14,0x0A14}, {1,0x0A15,0x0A15,0x0A15}, {1,0x0A16,0x0A16,0x0A16}, {1,0x0A17,0x0A17,0x0A17},
 {1,0x0A18,0x0A18,0x0A18}, {1,0x0A19,0x0A19,0x0A19}, {1,0x0A1A,0x0A1A,0x0A1A}, {1,0x0A1B,0x0A1B,0x0A1B},
 {1,0x0A1C,0x0A1C,0x0A1C}, {1,0x0A1D,0x0A1D,0x0A1D}, {1,0x0A1E,0x0A1E,0x0A1E}, {1,0x0A1F,0x0A1F,0x0A1F},
 {1,0x0A20,0x0A20,0x0A20}, {1,0x0A21,0x0A21,0x0A21}, {1,0x0A22,0x0A22,0x0A22}, {1,0x0A23,0x0A23,0x0A23},
 {1,0x0A24,0x0A24,0x0A24}, {1,0x0A25,0x0A25,0x0A25}, {1,0x0A26,0x0A26,0x0A26}, {1,0x0A27,0x0A27,0x0A27},
 {1,0x0A28,0x0A28,0x0A28}, {0,0x0A29,0x0A29,0x0A29}, {1,0x0A2A,0x0A2A,0x0A2A}, {1,0x0A2B,0x0A2B,0x0A2B},
 {1,0x0A2C,0x0A2C,0x0A2C}, {1,0x0A2D,0x0A2D,0x0A2D}, {1,0x0A2E,0x0A2E,0x0A2E}, {1,0x0A2F,0x0A2F,0x0A2F},
 {1,0x0A30,0x0A30,0x0A30}, {0,0x0A31,0x0A31,0x0A31}, {1,0x0A32,0x0A32,0x0A32}, {1,0x0A33,0x0A33,0x0A33},
 {0,0x0A34,0x0A34,0x0A34}, {1,0x0A35,0x0A35,0x0A35}, {1,0x0A36,0x0A36,0x0A36}, {0,0x0A37,0x0A37,0x0A37},
 {1,0x0A38,0x0A38,0x0A38}, {1,0x0A39,0x0A39,0x0A39}, {0,0x0A3A,0x0A3A,0x0A3A}, {0,0x0A3B,0x0A3B,0x0A3B},
 {1,0x0A3C,0x0A3C,0x0A3C}, {0,0x0A3D,0x0A3D,0x0A3D}, {1,0x0A3E,0x0A3E,0x0A3E}, {1,0x0A3F,0x0A3F,0x0A3F},
 {1,0x0A40,0x0A40,0x0A40}, {1,0x0A41,0x0A41,0x0A41}, {1,0x0A42,0x0A42,0x0A42}, {0,0x0A43,0x0A43,0x0A43},
 {0,0x0A44,0x0A44,0x0A44}, {0,0x0A45,0x0A45,0x0A45}, {0,0x0A46,0x0A46,0x0A46}, {1,0x0A47,0x0A47,0x0A47},
 {1,0x0A48,0x0A48,0x0A48}, {0,0x0A49,0x0A49,0x0A49}, {0,0x0A4A,0x0A4A,0x0A4A}, {1,0x0A4B,0x0A4B,0x0A4B},
 {1,0x0A4C,0x0A4C,0x0A4C}, {1,0x0A4D,0x0A4D,0x0A4D}, {0,0x0A4E,0x0A4E,0x0A4E}, {0,0x0A4F,0x0A4F,0x0A4F},
 {0,0x0A50,0x0A50,0x0A50}, {0,0x0A51,0x0A51,0x0A51}, {0,0x0A52,0x0A52,0x0A52}, {0,0x0A53,0x0A53,0x0A53},
 {0,0x0A54,0x0A54,0x0A54}, {0,0x0A55,0x0A55,0x0A55}, {0,0x0A56,0x0A56,0x0A56}, {0,0x0A57,0x0A57,0x0A57},
 {0,0x0A58,0x0A58,0x0A58}, {1,0x0A59,0x0A59,0x0A59}, {1,0x0A5A,0x0A5A,0x0A5A}, {1,0x0A5B,0x0A5B,0x0A5B},
 {1,0x0A5C,0x0A5C,0x0A5C}, {0,0x0A5D,0x0A5D,0x0A5D}, {1,0x0A5E,0x0A5E,0x0A5E}, {0,0x0A5F,0x0A5F,0x0A5F},
 {0,0x0A60,0x0A60,0x0A60}, {0,0x0A61,0x0A61,0x0A61}, {0,0x0A62,0x0A62,0x0A62}, {0,0x0A63,0x0A63,0x0A63},
 {0,0x0A64,0x0A64,0x0A64}, {0,0x0A65,0x0A65,0x0A65}, {2,0x0A66,0x0A66,0x0A66}, {2,0x0A67,0x0A67,0x0A67},
 {2,0x0A68,0x0A68,0x0A68}, {2,0x0A69,0x0A69,0x0A69}, {2,0x0A6A,0x0A6A,0x0A6A}, {2,0x0A6B,0x0A6B,0x0A6B},
 {2,0x0A6C,0x0A6C,0x0A6C}, {2,0x0A6D,0x0A6D,0x0A6D}, {2,0x0A6E,0x0A6E,0x0A6E}, {2,0x0A6F,0x0A6F,0x0A6F},
 {1,0x0A70,0x0A70,0x0A70}, {1,0x0A71,0x0A71,0x0A71}, {1,0x0A72,0x0A72,0x0A72}, {1,0x0A73,0x0A73,0x0A73},
 {1,0x0A74,0x0A74,0x0A74}, {0,0x0A75,0x0A75,0x0A75}, {0,0x0A76,0x0A76,0x0A76}, {0,0x0A77,0x0A77,0x0A77},
 {0,0x0A78,0x0A78,0x0A78}, {0,0x0A79,0x0A79,0x0A79}, {0,0x0A7A,0x0A7A,0x0A7A}, {0,0x0A7B,0x0A7B,0x0A7B},
 {0,0x0A7C,0x0A7C,0x0A7C}, {0,0x0A7D,0x0A7D,0x0A7D}, {0,0x0A7E,0x0A7E,0x0A7E}, {0,0x0A7F,0x0A7F,0x0A7F},
 {0,0x0A80,0x0A80,0x0A80}, {1,0x0A81,0x0A81,0x0A81}, {1,0x0A82,0x0A82,0x0A82}, {1,0x0A83,0x0A83,0x0A83},
 {0,0x0A84,0x0A84,0x0A84}, {1,0x0A85,0x0A85,0x0A85}, {1,0x0A86,0x0A86,0x0A86}, {1,0x0A87,0x0A87,0x0A87},
 {1,0x0A88,0x0A88,0x0A88}, {1,0x0A89,0x0A89,0x0A89}, {1,0x0A8A,0x0A8A,0x0A8A}, {1,0x0A8B,0x0A8B,0x0A8B},
 {0,0x0A8C,0x0A8C,0x0A8C}, {1,0x0A8D,0x0A8D,0x0A8D}, {0,0x0A8E,0x0A8E,0x0A8E}, {1,0x0A8F,0x0A8F,0x0A8F},
 {1,0x0A90,0x0A90,0x0A90}, {1,0x0A91,0x0A91,0x0A91}, {0,0x0A92,0x0A92,0x0A92}, {1,0x0A93,0x0A93,0x0A93},
 {1,0x0A94,0x0A94,0x0A94}, {1,0x0A95,0x0A95,0x0A95}, {1,0x0A96,0x0A96,0x0A96}, {1,0x0A97,0x0A97,0x0A97},
 {1,0x0A98,0x0A98,0x0A98}, {1,0x0A99,0x0A99,0x0A99}, {1,0x0A9A,0x0A9A,0x0A9A}, {1,0x0A9B,0x0A9B,0x0A9B},
 {1,0x0A9C,0x0A9C,0x0A9C}, {1,0x0A9D,0x0A9D,0x0A9D}, {1,0x0A9E,0x0A9E,0x0A9E}, {1,0x0A9F,0x0A9F,0x0A9F},
 {1,0x0AA0,0x0AA0,0x0AA0}, {1,0x0AA1,0x0AA1,0x0AA1}, {1,0x0AA2,0x0AA2,0x0AA2}, {1,0x0AA3,0x0AA3,0x0AA3},
 {1,0x0AA4,0x0AA4,0x0AA4}, {1,0x0AA5,0x0AA5,0x0AA5}, {1,0x0AA6,0x0AA6,0x0AA6}, {1,0x0AA7,0x0AA7,0x0AA7},
 {1,0x0AA8,0x0AA8,0x0AA8}, {0,0x0AA9,0x0AA9,0x0AA9}, {1,0x0AAA,0x0AAA,0x0AAA}, {1,0x0AAB,0x0AAB,0x0AAB},
 {1,0x0AAC,0x0AAC,0x0AAC}, {1,0x0AAD,0x0AAD,0x0AAD}, {1,0x0AAE,0x0AAE,0x0AAE}, {1,0x0AAF,0x0AAF,0x0AAF},
 {1,0x0AB0,0x0AB0,0x0AB0}, {0,0x0AB1,0x0AB1,0x0AB1}, {1,0x0AB2,0x0AB2,0x0AB2}, {1,0x0AB3,0x0AB3,0x0AB3},
 {0,0x0AB4,0x0AB4,0x0AB4}, {1,0x0AB5,0x0AB5,0x0AB5}, {1,0x0AB6,0x0AB6,0x0AB6}, {1,0x0AB7,0x0AB7,0x0AB7},
 {1,0x0AB8,0x0AB8,0x0AB8}, {1,0x0AB9,0x0AB9,0x0AB9}, {0,0x0ABA,0x0ABA,0x0ABA}, {0,0x0ABB,0x0ABB,0x0ABB},
 {1,0x0ABC,0x0ABC,0x0ABC}, {1,0x0ABD,0x0ABD,0x0ABD}, {1,0x0ABE,0x0ABE,0x0ABE}, {1,0x0ABF,0x0ABF,0x0ABF},
 {1,0x0AC0,0x0AC0,0x0AC0}, {1,0x0AC1,0x0AC1,0x0AC1}, {1,0x0AC2,0x0AC2,0x0AC2}, {1,0x0AC3,0x0AC3,0x0AC3},
 {1,0x0AC4,0x0AC4,0x0AC4}, {1,0x0AC5,0x0AC5,0x0AC5}, {0,0x0AC6,0x0AC6,0x0AC6}, {1,0x0AC7,0x0AC7,0x0AC7},
 {1,0x0AC8,0x0AC8,0x0AC8}, {1,0x0AC9,0x0AC9,0x0AC9}, {0,0x0ACA,0x0ACA,0x0ACA}, {1,0x0ACB,0x0ACB,0x0ACB},
 {1,0x0ACC,0x0ACC,0x0ACC}, {1,0x0ACD,0x0ACD,0x0ACD}, {0,0x0ACE,0x0ACE,0x0ACE}, {0,0x0ACF,0x0ACF,0x0ACF},
 {1,0x0AD0,0x0AD0,0x0AD0}, {0,0x0AD1,0x0AD1,0x0AD1}, {0,0x0AD2,0x0AD2,0x0AD2}, {0,0x0AD3,0x0AD3,0x0AD3},
 {0,0x0AD4,0x0AD4,0x0AD4}, {0,0x0AD5,0x0AD5,0x0AD5}, {0,0x0AD6,0x0AD6,0x0AD6}, {0,0x0AD7,0x0AD7,0x0AD7},
 {0,0x0AD8,0x0AD8,0x0AD8}, {0,0x0AD9,0x0AD9,0x0AD9}, {0,0x0ADA,0x0ADA,0x0ADA}, {0,0x0ADB,0x0ADB,0x0ADB},
 {0,0x0ADC,0x0ADC,0x0ADC}, {0,0x0ADD,0x0ADD,0x0ADD}, {0,0x0ADE,0x0ADE,0x0ADE}, {0,0x0ADF,0x0ADF,0x0ADF},
 {1,0x0AE0,0x0AE0,0x0AE0}, {0,0x0AE1,0x0AE1,0x0AE1}, {0,0x0AE2,0x0AE2,0x0AE2}, {0,0x0AE3,0x0AE3,0x0AE3},
 {0,0x0AE4,0x0AE4,0x0AE4}, {0,0x0AE5,0x0AE5,0x0AE5}, {2,0x0AE6,0x0AE6,0x0AE6}, {2,0x0AE7,0x0AE7,0x0AE7},
 {2,0x0AE8,0x0AE8,0x0AE8}, {2,0x0AE9,0x0AE9,0x0AE9}, {2,0x0AEA,0x0AEA,0x0AEA}, {2,0x0AEB,0x0AEB,0x0AEB},
 {2,0x0AEC,0x0AEC,0x0AEC}, {2,0x0AED,0x0AED,0x0AED}, {2,0x0AEE,0x0AEE,0x0AEE}, {2,0x0AEF,0x0AEF,0x0AEF},
 {0,0x0AF0,0x0AF0,0x0AF0}, {0,0x0AF1,0x0AF1,0x0AF1}, {0,0x0AF2,0x0AF2,0x0AF2}, {0,0x0AF3,0x0AF3,0x0AF3},
 {0,0x0AF4,0x0AF4,0x0AF4}, {0,0x0AF5,0x0AF5,0x0AF5}, {0,0x0AF6,0x0AF6,0x0AF6}, {0,0x0AF7,0x0AF7,0x0AF7},
 {0,0x0AF8,0x0AF8,0x0AF8}, {0,0x0AF9,0x0AF9,0x0AF9}, {0,0x0AFA,0x0AFA,0x0AFA}, {0,0x0AFB,0x0AFB,0x0AFB},
 {0,0x0AFC,0x0AFC,0x0AFC}, {0,0x0AFD,0x0AFD,0x0AFD}, {0,0x0AFE,0x0AFE,0x0AFE}, {0,0x0AFF,0x0AFF,0x0AFF},
{0,0}};

static UDM_UNICODE plane0B[257]={
 {0,0x0B00,0x0B00,0x0B00}, {1,0x0B01,0x0B01,0x0B01}, {1,0x0B02,0x0B02,0x0B02}, {1,0x0B03,0x0B03,0x0B03},
 {0,0x0B04,0x0B04,0x0B04}, {1,0x0B05,0x0B05,0x0B05}, {1,0x0B06,0x0B06,0x0B06}, {1,0x0B07,0x0B07,0x0B07},
 {1,0x0B08,0x0B08,0x0B08}, {1,0x0B09,0x0B09,0x0B09}, {1,0x0B0A,0x0B0A,0x0B0A}, {1,0x0B0B,0x0B0B,0x0B0B},
 {1,0x0B0C,0x0B0C,0x0B0C}, {0,0x0B0D,0x0B0D,0x0B0D}, {0,0x0B0E,0x0B0E,0x0B0E}, {1,0x0B0F,0x0B0F,0x0B0F},
 {1,0x0B10,0x0B10,0x0B10}, {0,0x0B11,0x0B11,0x0B11}, {0,0x0B12,0x0B12,0x0B12}, {1,0x0B13,0x0B13,0x0B13},
 {1,0x0B14,0x0B14,0x0B14}, {1,0x0B15,0x0B15,0x0B15}, {1,0x0B16,0x0B16,0x0B16}, {1,0x0B17,0x0B17,0x0B17},
 {1,0x0B18,0x0B18,0x0B18}, {1,0x0B19,0x0B19,0x0B19}, {1,0x0B1A,0x0B1A,0x0B1A}, {1,0x0B1B,0x0B1B,0x0B1B},
 {1,0x0B1C,0x0B1C,0x0B1C}, {1,0x0B1D,0x0B1D,0x0B1D}, {1,0x0B1E,0x0B1E,0x0B1E}, {1,0x0B1F,0x0B1F,0x0B1F},
 {1,0x0B20,0x0B20,0x0B20}, {1,0x0B21,0x0B21,0x0B21}, {1,0x0B22,0x0B22,0x0B22}, {1,0x0B23,0x0B23,0x0B23},
 {1,0x0B24,0x0B24,0x0B24}, {1,0x0B25,0x0B25,0x0B25}, {1,0x0B26,0x0B26,0x0B26}, {1,0x0B27,0x0B27,0x0B27},
 {1,0x0B28,0x0B28,0x0B28}, {0,0x0B29,0x0B29,0x0B29}, {1,0x0B2A,0x0B2A,0x0B2A}, {1,0x0B2B,0x0B2B,0x0B2B},
 {1,0x0B2C,0x0B2C,0x0B2C}, {1,0x0B2D,0x0B2D,0x0B2D}, {1,0x0B2E,0x0B2E,0x0B2E}, {1,0x0B2F,0x0B2F,0x0B2F},
 {1,0x0B30,0x0B30,0x0B30}, {0,0x0B31,0x0B31,0x0B31}, {1,0x0B32,0x0B32,0x0B32}, {1,0x0B33,0x0B33,0x0B33},
 {0,0x0B34,0x0B34,0x0B34}, {0,0x0B35,0x0B35,0x0B35}, {1,0x0B36,0x0B36,0x0B36}, {1,0x0B37,0x0B37,0x0B37},
 {1,0x0B38,0x0B38,0x0B38}, {1,0x0B39,0x0B39,0x0B39}, {0,0x0B3A,0x0B3A,0x0B3A}, {0,0x0B3B,0x0B3B,0x0B3B},
 {1,0x0B3C,0x0B3C,0x0B3C}, {1,0x0B3D,0x0B3D,0x0B3D}, {1,0x0B3E,0x0B3E,0x0B3E}, {1,0x0B3F,0x0B3F,0x0B3F},
 {1,0x0B40,0x0B40,0x0B40}, {1,0x0B41,0x0B41,0x0B41}, {1,0x0B42,0x0B42,0x0B42}, {1,0x0B43,0x0B43,0x0B43},
 {0,0x0B44,0x0B44,0x0B44}, {0,0x0B45,0x0B45,0x0B45}, {0,0x0B46,0x0B46,0x0B46}, {1,0x0B47,0x0B47,0x0B47},
 {1,0x0B48,0x0B48,0x0B48}, {0,0x0B49,0x0B49,0x0B49}, {0,0x0B4A,0x0B4A,0x0B4A}, {1,0x0B4B,0x0B4B,0x0B4B},
 {1,0x0B4C,0x0B4C,0x0B4C}, {1,0x0B4D,0x0B4D,0x0B4D}, {0,0x0B4E,0x0B4E,0x0B4E}, {0,0x0B4F,0x0B4F,0x0B4F},
 {0,0x0B50,0x0B50,0x0B50}, {0,0x0B51,0x0B51,0x0B51}, {0,0x0B52,0x0B52,0x0B52}, {0,0x0B53,0x0B53,0x0B53},
 {0,0x0B54,0x0B54,0x0B54}, {0,0x0B55,0x0B55,0x0B55}, {1,0x0B56,0x0B56,0x0B56}, {1,0x0B57,0x0B57,0x0B57},
 {0,0x0B58,0x0B58,0x0B58}, {0,0x0B59,0x0B59,0x0B59}, {0,0x0B5A,0x0B5A,0x0B5A}, {0,0x0B5B,0x0B5B,0x0B5B},
 {1,0x0B5C,0x0B5C,0x0B5C}, {1,0x0B5D,0x0B5D,0x0B5D}, {0,0x0B5E,0x0B5E,0x0B5E}, {1,0x0B5F,0x0B5F,0x0B5F},
 {1,0x0B60,0x0B60,0x0B60}, {1,0x0B61,0x0B61,0x0B61}, {0,0x0B62,0x0B62,0x0B62}, {0,0x0B63,0x0B63,0x0B63},
 {0,0x0B64,0x0B64,0x0B64}, {0,0x0B65,0x0B65,0x0B65}, {2,0x0B66,0x0B66,0x0B66}, {2,0x0B67,0x0B67,0x0B67},
 {2,0x0B68,0x0B68,0x0B68}, {2,0x0B69,0x0B69,0x0B69}, {2,0x0B6A,0x0B6A,0x0B6A}, {2,0x0B6B,0x0B6B,0x0B6B},
 {2,0x0B6C,0x0B6C,0x0B6C}, {2,0x0B6D,0x0B6D,0x0B6D}, {2,0x0B6E,0x0B6E,0x0B6E}, {2,0x0B6F,0x0B6F,0x0B6F},
 {0,0x0B70,0x0B70,0x0B70}, {0,0x0B71,0x0B71,0x0B71}, {0,0x0B72,0x0B72,0x0B72}, {0,0x0B73,0x0B73,0x0B73},
 {0,0x0B74,0x0B74,0x0B74}, {0,0x0B75,0x0B75,0x0B75}, {0,0x0B76,0x0B76,0x0B76}, {0,0x0B77,0x0B77,0x0B77},
 {0,0x0B78,0x0B78,0x0B78}, {0,0x0B79,0x0B79,0x0B79}, {0,0x0B7A,0x0B7A,0x0B7A}, {0,0x0B7B,0x0B7B,0x0B7B},
 {0,0x0B7C,0x0B7C,0x0B7C}, {0,0x0B7D,0x0B7D,0x0B7D}, {0,0x0B7E,0x0B7E,0x0B7E}, {0,0x0B7F,0x0B7F,0x0B7F},
 {0,0x0B80,0x0B80,0x0B80}, {0,0x0B81,0x0B81,0x0B81}, {1,0x0B82,0x0B82,0x0B82}, {1,0x0B83,0x0B83,0x0B83},
 {0,0x0B84,0x0B84,0x0B84}, {1,0x0B85,0x0B85,0x0B85}, {1,0x0B86,0x0B86,0x0B86}, {1,0x0B87,0x0B87,0x0B87},
 {1,0x0B88,0x0B88,0x0B88}, {1,0x0B89,0x0B89,0x0B89}, {1,0x0B8A,0x0B8A,0x0B8A}, {0,0x0B8B,0x0B8B,0x0B8B},
 {0,0x0B8C,0x0B8C,0x0B8C}, {0,0x0B8D,0x0B8D,0x0B8D}, {1,0x0B8E,0x0B8E,0x0B8E}, {1,0x0B8F,0x0B8F,0x0B8F},
 {1,0x0B90,0x0B90,0x0B90}, {0,0x0B91,0x0B91,0x0B91}, {1,0x0B92,0x0B92,0x0B92}, {1,0x0B93,0x0B93,0x0B93},
 {1,0x0B94,0x0B94,0x0B94}, {1,0x0B95,0x0B95,0x0B95}, {0,0x0B96,0x0B96,0x0B96}, {0,0x0B97,0x0B97,0x0B97},
 {0,0x0B98,0x0B98,0x0B98}, {1,0x0B99,0x0B99,0x0B99}, {1,0x0B9A,0x0B9A,0x0B9A}, {0,0x0B9B,0x0B9B,0x0B9B},
 {1,0x0B9C,0x0B9C,0x0B9C}, {0,0x0B9D,0x0B9D,0x0B9D}, {1,0x0B9E,0x0B9E,0x0B9E}, {1,0x0B9F,0x0B9F,0x0B9F},
 {0,0x0BA0,0x0BA0,0x0BA0}, {0,0x0BA1,0x0BA1,0x0BA1}, {0,0x0BA2,0x0BA2,0x0BA2}, {1,0x0BA3,0x0BA3,0x0BA3},
 {1,0x0BA4,0x0BA4,0x0BA4}, {0,0x0BA5,0x0BA5,0x0BA5}, {0,0x0BA6,0x0BA6,0x0BA6}, {0,0x0BA7,0x0BA7,0x0BA7},
 {1,0x0BA8,0x0BA8,0x0BA8}, {1,0x0BA9,0x0BA9,0x0BA9}, {1,0x0BAA,0x0BAA,0x0BAA}, {0,0x0BAB,0x0BAB,0x0BAB},
 {0,0x0BAC,0x0BAC,0x0BAC}, {0,0x0BAD,0x0BAD,0x0BAD}, {1,0x0BAE,0x0BAE,0x0BAE}, {1,0x0BAF,0x0BAF,0x0BAF},
 {1,0x0BB0,0x0BB0,0x0BB0}, {1,0x0BB1,0x0BB1,0x0BB1}, {1,0x0BB2,0x0BB2,0x0BB2}, {1,0x0BB3,0x0BB3,0x0BB3},
 {1,0x0BB4,0x0BB4,0x0BB4}, {1,0x0BB5,0x0BB5,0x0BB5}, {0,0x0BB6,0x0BB6,0x0BB6}, {1,0x0BB7,0x0BB7,0x0BB7},
 {1,0x0BB8,0x0BB8,0x0BB8}, {1,0x0BB9,0x0BB9,0x0BB9}, {0,0x0BBA,0x0BBA,0x0BBA}, {0,0x0BBB,0x0BBB,0x0BBB},
 {0,0x0BBC,0x0BBC,0x0BBC}, {0,0x0BBD,0x0BBD,0x0BBD}, {1,0x0BBE,0x0BBE,0x0BBE}, {1,0x0BBF,0x0BBF,0x0BBF},
 {1,0x0BC0,0x0BC0,0x0BC0}, {1,0x0BC1,0x0BC1,0x0BC1}, {1,0x0BC2,0x0BC2,0x0BC2}, {0,0x0BC3,0x0BC3,0x0BC3},
 {0,0x0BC4,0x0BC4,0x0BC4}, {0,0x0BC5,0x0BC5,0x0BC5}, {1,0x0BC6,0x0BC6,0x0BC6}, {1,0x0BC7,0x0BC7,0x0BC7},
 {1,0x0BC8,0x0BC8,0x0BC8}, {0,0x0BC9,0x0BC9,0x0BC9}, {1,0x0BCA,0x0BCA,0x0BCA}, {1,0x0BCB,0x0BCB,0x0BCB},
 {1,0x0BCC,0x0BCC,0x0BCC}, {1,0x0BCD,0x0BCD,0x0BCD}, {0,0x0BCE,0x0BCE,0x0BCE}, {0,0x0BCF,0x0BCF,0x0BCF},
 {0,0x0BD0,0x0BD0,0x0BD0}, {0,0x0BD1,0x0BD1,0x0BD1}, {0,0x0BD2,0x0BD2,0x0BD2}, {0,0x0BD3,0x0BD3,0x0BD3},
 {0,0x0BD4,0x0BD4,0x0BD4}, {0,0x0BD5,0x0BD5,0x0BD5}, {0,0x0BD6,0x0BD6,0x0BD6}, {1,0x0BD7,0x0BD7,0x0BD7},
 {0,0x0BD8,0x0BD8,0x0BD8}, {0,0x0BD9,0x0BD9,0x0BD9}, {0,0x0BDA,0x0BDA,0x0BDA}, {0,0x0BDB,0x0BDB,0x0BDB},
 {0,0x0BDC,0x0BDC,0x0BDC}, {0,0x0BDD,0x0BDD,0x0BDD}, {0,0x0BDE,0x0BDE,0x0BDE}, {0,0x0BDF,0x0BDF,0x0BDF},
 {0,0x0BE0,0x0BE0,0x0BE0}, {0,0x0BE1,0x0BE1,0x0BE1}, {0,0x0BE2,0x0BE2,0x0BE2}, {0,0x0BE3,0x0BE3,0x0BE3},
 {0,0x0BE4,0x0BE4,0x0BE4}, {0,0x0BE5,0x0BE5,0x0BE5}, {0,0x0BE6,0x0BE6,0x0BE6}, {2,0x0BE7,0x0BE7,0x0BE7},
 {2,0x0BE8,0x0BE8,0x0BE8}, {2,0x0BE9,0x0BE9,0x0BE9}, {2,0x0BEA,0x0BEA,0x0BEA}, {2,0x0BEB,0x0BEB,0x0BEB},
 {2,0x0BEC,0x0BEC,0x0BEC}, {2,0x0BED,0x0BED,0x0BED}, {2,0x0BEE,0x0BEE,0x0BEE}, {2,0x0BEF,0x0BEF,0x0BEF},
 {0,0x0BF0,0x0BF0,0x0BF0}, {0,0x0BF1,0x0BF1,0x0BF1}, {0,0x0BF2,0x0BF2,0x0BF2}, {0,0x0BF3,0x0BF3,0x0BF3},
 {0,0x0BF4,0x0BF4,0x0BF4}, {0,0x0BF5,0x0BF5,0x0BF5}, {0,0x0BF6,0x0BF6,0x0BF6}, {0,0x0BF7,0x0BF7,0x0BF7},
 {0,0x0BF8,0x0BF8,0x0BF8}, {0,0x0BF9,0x0BF9,0x0BF9}, {0,0x0BFA,0x0BFA,0x0BFA}, {0,0x0BFB,0x0BFB,0x0BFB},
 {0,0x0BFC,0x0BFC,0x0BFC}, {0,0x0BFD,0x0BFD,0x0BFD}, {0,0x0BFE,0x0BFE,0x0BFE}, {0,0x0BFF,0x0BFF,0x0BFF},
{0,0}};

static UDM_UNICODE plane0C[257]={
 {0,0x0C00,0x0C00,0x0C00}, {1,0x0C01,0x0C01,0x0C01}, {1,0x0C02,0x0C02,0x0C02}, {1,0x0C03,0x0C03,0x0C03},
 {0,0x0C04,0x0C04,0x0C04}, {1,0x0C05,0x0C05,0x0C05}, {1,0x0C06,0x0C06,0x0C06}, {1,0x0C07,0x0C07,0x0C07},
 {1,0x0C08,0x0C08,0x0C08}, {1,0x0C09,0x0C09,0x0C09}, {1,0x0C0A,0x0C0A,0x0C0A}, {1,0x0C0B,0x0C0B,0x0C0B},
 {1,0x0C0C,0x0C0C,0x0C0C}, {0,0x0C0D,0x0C0D,0x0C0D}, {1,0x0C0E,0x0C0E,0x0C0E}, {1,0x0C0F,0x0C0F,0x0C0F},
 {1,0x0C10,0x0C10,0x0C10}, {0,0x0C11,0x0C11,0x0C11}, {1,0x0C12,0x0C12,0x0C12}, {1,0x0C13,0x0C13,0x0C13},
 {1,0x0C14,0x0C14,0x0C14}, {1,0x0C15,0x0C15,0x0C15}, {1,0x0C16,0x0C16,0x0C16}, {1,0x0C17,0x0C17,0x0C17},
 {1,0x0C18,0x0C18,0x0C18}, {1,0x0C19,0x0C19,0x0C19}, {1,0x0C1A,0x0C1A,0x0C1A}, {1,0x0C1B,0x0C1B,0x0C1B},
 {1,0x0C1C,0x0C1C,0x0C1C}, {1,0x0C1D,0x0C1D,0x0C1D}, {1,0x0C1E,0x0C1E,0x0C1E}, {1,0x0C1F,0x0C1F,0x0C1F},
 {1,0x0C20,0x0C20,0x0C20}, {1,0x0C21,0x0C21,0x0C21}, {1,0x0C22,0x0C22,0x0C22}, {1,0x0C23,0x0C23,0x0C23},
 {1,0x0C24,0x0C24,0x0C24}, {1,0x0C25,0x0C25,0x0C25}, {1,0x0C26,0x0C26,0x0C26}, {1,0x0C27,0x0C27,0x0C27},
 {1,0x0C28,0x0C28,0x0C28}, {0,0x0C29,0x0C29,0x0C29}, {1,0x0C2A,0x0C2A,0x0C2A}, {1,0x0C2B,0x0C2B,0x0C2B},
 {1,0x0C2C,0x0C2C,0x0C2C}, {1,0x0C2D,0x0C2D,0x0C2D}, {1,0x0C2E,0x0C2E,0x0C2E}, {1,0x0C2F,0x0C2F,0x0C2F},
 {1,0x0C30,0x0C30,0x0C30}, {1,0x0C31,0x0C31,0x0C31}, {1,0x0C32,0x0C32,0x0C32}, {1,0x0C33,0x0C33,0x0C33},
 {0,0x0C34,0x0C34,0x0C34}, {1,0x0C35,0x0C35,0x0C35}, {1,0x0C36,0x0C36,0x0C36}, {1,0x0C37,0x0C37,0x0C37},
 {1,0x0C38,0x0C38,0x0C38}, {1,0x0C39,0x0C39,0x0C39}, {0,0x0C3A,0x0C3A,0x0C3A}, {0,0x0C3B,0x0C3B,0x0C3B},
 {0,0x0C3C,0x0C3C,0x0C3C}, {0,0x0C3D,0x0C3D,0x0C3D}, {1,0x0C3E,0x0C3E,0x0C3E}, {1,0x0C3F,0x0C3F,0x0C3F},
 {1,0x0C40,0x0C40,0x0C40}, {1,0x0C41,0x0C41,0x0C41}, {1,0x0C42,0x0C42,0x0C42}, {1,0x0C43,0x0C43,0x0C43},
 {1,0x0C44,0x0C44,0x0C44}, {0,0x0C45,0x0C45,0x0C45}, {1,0x0C46,0x0C46,0x0C46}, {1,0x0C47,0x0C47,0x0C47},
 {1,0x0C48,0x0C48,0x0C48}, {0,0x0C49,0x0C49,0x0C49}, {1,0x0C4A,0x0C4A,0x0C4A}, {1,0x0C4B,0x0C4B,0x0C4B},
 {1,0x0C4C,0x0C4C,0x0C4C}, {1,0x0C4D,0x0C4D,0x0C4D}, {0,0x0C4E,0x0C4E,0x0C4E}, {0,0x0C4F,0x0C4F,0x0C4F},
 {0,0x0C50,0x0C50,0x0C50}, {0,0x0C51,0x0C51,0x0C51}, {0,0x0C52,0x0C52,0x0C52}, {0,0x0C53,0x0C53,0x0C53},
 {0,0x0C54,0x0C54,0x0C54}, {1,0x0C55,0x0C55,0x0C55}, {1,0x0C56,0x0C56,0x0C56}, {0,0x0C57,0x0C57,0x0C57},
 {0,0x0C58,0x0C58,0x0C58}, {0,0x0C59,0x0C59,0x0C59}, {0,0x0C5A,0x0C5A,0x0C5A}, {0,0x0C5B,0x0C5B,0x0C5B},
 {0,0x0C5C,0x0C5C,0x0C5C}, {0,0x0C5D,0x0C5D,0x0C5D}, {0,0x0C5E,0x0C5E,0x0C5E}, {0,0x0C5F,0x0C5F,0x0C5F},
 {1,0x0C60,0x0C60,0x0C60}, {1,0x0C61,0x0C61,0x0C61}, {0,0x0C62,0x0C62,0x0C62}, {0,0x0C63,0x0C63,0x0C63},
 {0,0x0C64,0x0C64,0x0C64}, {0,0x0C65,0x0C65,0x0C65}, {2,0x0C66,0x0C66,0x0C66}, {2,0x0C67,0x0C67,0x0C67},
 {2,0x0C68,0x0C68,0x0C68}, {2,0x0C69,0x0C69,0x0C69}, {2,0x0C6A,0x0C6A,0x0C6A}, {2,0x0C6B,0x0C6B,0x0C6B},
 {2,0x0C6C,0x0C6C,0x0C6C}, {2,0x0C6D,0x0C6D,0x0C6D}, {2,0x0C6E,0x0C6E,0x0C6E}, {2,0x0C6F,0x0C6F,0x0C6F},
 {0,0x0C70,0x0C70,0x0C70}, {0,0x0C71,0x0C71,0x0C71}, {0,0x0C72,0x0C72,0x0C72}, {0,0x0C73,0x0C73,0x0C73},
 {0,0x0C74,0x0C74,0x0C74}, {0,0x0C75,0x0C75,0x0C75}, {0,0x0C76,0x0C76,0x0C76}, {0,0x0C77,0x0C77,0x0C77},
 {0,0x0C78,0x0C78,0x0C78}, {0,0x0C79,0x0C79,0x0C79}, {0,0x0C7A,0x0C7A,0x0C7A}, {0,0x0C7B,0x0C7B,0x0C7B},
 {0,0x0C7C,0x0C7C,0x0C7C}, {0,0x0C7D,0x0C7D,0x0C7D}, {0,0x0C7E,0x0C7E,0x0C7E}, {0,0x0C7F,0x0C7F,0x0C7F},
 {0,0x0C80,0x0C80,0x0C80}, {0,0x0C81,0x0C81,0x0C81}, {1,0x0C82,0x0C82,0x0C82}, {1,0x0C83,0x0C83,0x0C83},
 {0,0x0C84,0x0C84,0x0C84}, {1,0x0C85,0x0C85,0x0C85}, {1,0x0C86,0x0C86,0x0C86}, {1,0x0C87,0x0C87,0x0C87},
 {1,0x0C88,0x0C88,0x0C88}, {1,0x0C89,0x0C89,0x0C89}, {1,0x0C8A,0x0C8A,0x0C8A}, {1,0x0C8B,0x0C8B,0x0C8B},
 {1,0x0C8C,0x0C8C,0x0C8C}, {0,0x0C8D,0x0C8D,0x0C8D}, {1,0x0C8E,0x0C8E,0x0C8E}, {1,0x0C8F,0x0C8F,0x0C8F},
 {1,0x0C90,0x0C90,0x0C90}, {0,0x0C91,0x0C91,0x0C91}, {1,0x0C92,0x0C92,0x0C92}, {1,0x0C93,0x0C93,0x0C93},
 {1,0x0C94,0x0C94,0x0C94}, {1,0x0C95,0x0C95,0x0C95}, {1,0x0C96,0x0C96,0x0C96}, {1,0x0C97,0x0C97,0x0C97},
 {1,0x0C98,0x0C98,0x0C98}, {1,0x0C99,0x0C99,0x0C99}, {1,0x0C9A,0x0C9A,0x0C9A}, {1,0x0C9B,0x0C9B,0x0C9B},
 {1,0x0C9C,0x0C9C,0x0C9C}, {1,0x0C9D,0x0C9D,0x0C9D}, {1,0x0C9E,0x0C9E,0x0C9E}, {1,0x0C9F,0x0C9F,0x0C9F},
 {1,0x0CA0,0x0CA0,0x0CA0}, {1,0x0CA1,0x0CA1,0x0CA1}, {1,0x0CA2,0x0CA2,0x0CA2}, {1,0x0CA3,0x0CA3,0x0CA3},
 {1,0x0CA4,0x0CA4,0x0CA4}, {1,0x0CA5,0x0CA5,0x0CA5}, {1,0x0CA6,0x0CA6,0x0CA6}, {1,0x0CA7,0x0CA7,0x0CA7},
 {1,0x0CA8,0x0CA8,0x0CA8}, {0,0x0CA9,0x0CA9,0x0CA9}, {1,0x0CAA,0x0CAA,0x0CAA}, {1,0x0CAB,0x0CAB,0x0CAB},
 {1,0x0CAC,0x0CAC,0x0CAC}, {1,0x0CAD,0x0CAD,0x0CAD}, {1,0x0CAE,0x0CAE,0x0CAE}, {1,0x0CAF,0x0CAF,0x0CAF},
 {1,0x0CB0,0x0CB0,0x0CB0}, {1,0x0CB1,0x0CB1,0x0CB1}, {1,0x0CB2,0x0CB2,0x0CB2}, {1,0x0CB3,0x0CB3,0x0CB3},
 {0,0x0CB4,0x0CB4,0x0CB4}, {1,0x0CB5,0x0CB5,0x0CB5}, {1,0x0CB6,0x0CB6,0x0CB6}, {1,0x0CB7,0x0CB7,0x0CB7},
 {1,0x0CB8,0x0CB8,0x0CB8}, {1,0x0CB9,0x0CB9,0x0CB9}, {0,0x0CBA,0x0CBA,0x0CBA}, {0,0x0CBB,0x0CBB,0x0CBB},
 {0,0x0CBC,0x0CBC,0x0CBC}, {0,0x0CBD,0x0CBD,0x0CBD}, {1,0x0CBE,0x0CBE,0x0CBE}, {1,0x0CBF,0x0CBF,0x0CBF},
 {1,0x0CC0,0x0CC0,0x0CC0}, {1,0x0CC1,0x0CC1,0x0CC1}, {1,0x0CC2,0x0CC2,0x0CC2}, {1,0x0CC3,0x0CC3,0x0CC3},
 {1,0x0CC4,0x0CC4,0x0CC4}, {0,0x0CC5,0x0CC5,0x0CC5}, {1,0x0CC6,0x0CC6,0x0CC6}, {1,0x0CC7,0x0CC7,0x0CC7},
 {1,0x0CC8,0x0CC8,0x0CC8}, {0,0x0CC9,0x0CC9,0x0CC9}, {1,0x0CCA,0x0CCA,0x0CCA}, {1,0x0CCB,0x0CCB,0x0CCB},
 {1,0x0CCC,0x0CCC,0x0CCC}, {1,0x0CCD,0x0CCD,0x0CCD}, {0,0x0CCE,0x0CCE,0x0CCE}, {0,0x0CCF,0x0CCF,0x0CCF},
 {0,0x0CD0,0x0CD0,0x0CD0}, {0,0x0CD1,0x0CD1,0x0CD1}, {0,0x0CD2,0x0CD2,0x0CD2}, {0,0x0CD3,0x0CD3,0x0CD3},
 {0,0x0CD4,0x0CD4,0x0CD4}, {1,0x0CD5,0x0CD5,0x0CD5}, {1,0x0CD6,0x0CD6,0x0CD6}, {0,0x0CD7,0x0CD7,0x0CD7},
 {0,0x0CD8,0x0CD8,0x0CD8}, {0,0x0CD9,0x0CD9,0x0CD9}, {0,0x0CDA,0x0CDA,0x0CDA}, {0,0x0CDB,0x0CDB,0x0CDB},
 {0,0x0CDC,0x0CDC,0x0CDC}, {0,0x0CDD,0x0CDD,0x0CDD}, {1,0x0CDE,0x0CDE,0x0CDE}, {0,0x0CDF,0x0CDF,0x0CDF},
 {1,0x0CE0,0x0CE0,0x0CE0}, {1,0x0CE1,0x0CE1,0x0CE1}, {0,0x0CE2,0x0CE2,0x0CE2}, {0,0x0CE3,0x0CE3,0x0CE3},
 {0,0x0CE4,0x0CE4,0x0CE4}, {0,0x0CE5,0x0CE5,0x0CE5}, {2,0x0CE6,0x0CE6,0x0CE6}, {2,0x0CE7,0x0CE7,0x0CE7},
 {2,0x0CE8,0x0CE8,0x0CE8}, {2,0x0CE9,0x0CE9,0x0CE9}, {2,0x0CEA,0x0CEA,0x0CEA}, {2,0x0CEB,0x0CEB,0x0CEB},
 {2,0x0CEC,0x0CEC,0x0CEC}, {2,0x0CED,0x0CED,0x0CED}, {2,0x0CEE,0x0CEE,0x0CEE}, {2,0x0CEF,0x0CEF,0x0CEF},
 {0,0x0CF0,0x0CF0,0x0CF0}, {0,0x0CF1,0x0CF1,0x0CF1}, {0,0x0CF2,0x0CF2,0x0CF2}, {0,0x0CF3,0x0CF3,0x0CF3},
 {0,0x0CF4,0x0CF4,0x0CF4}, {0,0x0CF5,0x0CF5,0x0CF5}, {0,0x0CF6,0x0CF6,0x0CF6}, {0,0x0CF7,0x0CF7,0x0CF7},
 {0,0x0CF8,0x0CF8,0x0CF8}, {0,0x0CF9,0x0CF9,0x0CF9}, {0,0x0CFA,0x0CFA,0x0CFA}, {0,0x0CFB,0x0CFB,0x0CFB},
 {0,0x0CFC,0x0CFC,0x0CFC}, {0,0x0CFD,0x0CFD,0x0CFD}, {0,0x0CFE,0x0CFE,0x0CFE}, {0,0x0CFF,0x0CFF,0x0CFF},
{0,0}};

static UDM_UNICODE plane0D[257]={
 {0,0x0D00,0x0D00,0x0D00}, {0,0x0D01,0x0D01,0x0D01}, {1,0x0D02,0x0D02,0x0D02}, {1,0x0D03,0x0D03,0x0D03},
 {0,0x0D04,0x0D04,0x0D04}, {1,0x0D05,0x0D05,0x0D05}, {1,0x0D06,0x0D06,0x0D06}, {1,0x0D07,0x0D07,0x0D07},
 {1,0x0D08,0x0D08,0x0D08}, {1,0x0D09,0x0D09,0x0D09}, {1,0x0D0A,0x0D0A,0x0D0A}, {1,0x0D0B,0x0D0B,0x0D0B},
 {1,0x0D0C,0x0D0C,0x0D0C}, {0,0x0D0D,0x0D0D,0x0D0D}, {1,0x0D0E,0x0D0E,0x0D0E}, {1,0x0D0F,0x0D0F,0x0D0F},
 {1,0x0D10,0x0D10,0x0D10}, {0,0x0D11,0x0D11,0x0D11}, {1,0x0D12,0x0D12,0x0D12}, {1,0x0D13,0x0D13,0x0D13},
 {1,0x0D14,0x0D14,0x0D14}, {1,0x0D15,0x0D15,0x0D15}, {1,0x0D16,0x0D16,0x0D16}, {1,0x0D17,0x0D17,0x0D17},
 {1,0x0D18,0x0D18,0x0D18}, {1,0x0D19,0x0D19,0x0D19}, {1,0x0D1A,0x0D1A,0x0D1A}, {1,0x0D1B,0x0D1B,0x0D1B},
 {1,0x0D1C,0x0D1C,0x0D1C}, {1,0x0D1D,0x0D1D,0x0D1D}, {1,0x0D1E,0x0D1E,0x0D1E}, {1,0x0D1F,0x0D1F,0x0D1F},
 {1,0x0D20,0x0D20,0x0D20}, {1,0x0D21,0x0D21,0x0D21}, {1,0x0D22,0x0D22,0x0D22}, {1,0x0D23,0x0D23,0x0D23},
 {1,0x0D24,0x0D24,0x0D24}, {1,0x0D25,0x0D25,0x0D25}, {1,0x0D26,0x0D26,0x0D26}, {1,0x0D27,0x0D27,0x0D27},
 {1,0x0D28,0x0D28,0x0D28}, {0,0x0D29,0x0D29,0x0D29}, {1,0x0D2A,0x0D2A,0x0D2A}, {1,0x0D2B,0x0D2B,0x0D2B},
 {1,0x0D2C,0x0D2C,0x0D2C}, {1,0x0D2D,0x0D2D,0x0D2D}, {1,0x0D2E,0x0D2E,0x0D2E}, {1,0x0D2F,0x0D2F,0x0D2F},
 {1,0x0D30,0x0D30,0x0D30}, {1,0x0D31,0x0D31,0x0D31}, {1,0x0D32,0x0D32,0x0D32}, {1,0x0D33,0x0D33,0x0D33},
 {1,0x0D34,0x0D34,0x0D34}, {1,0x0D35,0x0D35,0x0D35}, {1,0x0D36,0x0D36,0x0D36}, {1,0x0D37,0x0D37,0x0D37},
 {1,0x0D38,0x0D38,0x0D38}, {1,0x0D39,0x0D39,0x0D39}, {0,0x0D3A,0x0D3A,0x0D3A}, {0,0x0D3B,0x0D3B,0x0D3B},
 {0,0x0D3C,0x0D3C,0x0D3C}, {0,0x0D3D,0x0D3D,0x0D3D}, {1,0x0D3E,0x0D3E,0x0D3E}, {1,0x0D3F,0x0D3F,0x0D3F},
 {1,0x0D40,0x0D40,0x0D40}, {1,0x0D41,0x0D41,0x0D41}, {1,0x0D42,0x0D42,0x0D42}, {1,0x0D43,0x0D43,0x0D43},
 {0,0x0D44,0x0D44,0x0D44}, {0,0x0D45,0x0D45,0x0D45}, {1,0x0D46,0x0D46,0x0D46}, {1,0x0D47,0x0D47,0x0D47},
 {1,0x0D48,0x0D48,0x0D48}, {0,0x0D49,0x0D49,0x0D49}, {1,0x0D4A,0x0D4A,0x0D4A}, {1,0x0D4B,0x0D4B,0x0D4B},
 {1,0x0D4C,0x0D4C,0x0D4C}, {1,0x0D4D,0x0D4D,0x0D4D}, {0,0x0D4E,0x0D4E,0x0D4E}, {0,0x0D4F,0x0D4F,0x0D4F},
 {0,0x0D50,0x0D50,0x0D50}, {0,0x0D51,0x0D51,0x0D51}, {0,0x0D52,0x0D52,0x0D52}, {0,0x0D53,0x0D53,0x0D53},
 {0,0x0D54,0x0D54,0x0D54}, {0,0x0D55,0x0D55,0x0D55}, {0,0x0D56,0x0D56,0x0D56}, {1,0x0D57,0x0D57,0x0D57},
 {0,0x0D58,0x0D58,0x0D58}, {0,0x0D59,0x0D59,0x0D59}, {0,0x0D5A,0x0D5A,0x0D5A}, {0,0x0D5B,0x0D5B,0x0D5B},
 {0,0x0D5C,0x0D5C,0x0D5C}, {0,0x0D5D,0x0D5D,0x0D5D}, {0,0x0D5E,0x0D5E,0x0D5E}, {0,0x0D5F,0x0D5F,0x0D5F},
 {1,0x0D60,0x0D60,0x0D60}, {1,0x0D61,0x0D61,0x0D61}, {0,0x0D62,0x0D62,0x0D62}, {0,0x0D63,0x0D63,0x0D63},
 {0,0x0D64,0x0D64,0x0D64}, {0,0x0D65,0x0D65,0x0D65}, {2,0x0D66,0x0D66,0x0D66}, {2,0x0D67,0x0D67,0x0D67},
 {2,0x0D68,0x0D68,0x0D68}, {2,0x0D69,0x0D69,0x0D69}, {2,0x0D6A,0x0D6A,0x0D6A}, {2,0x0D6B,0x0D6B,0x0D6B},
 {2,0x0D6C,0x0D6C,0x0D6C}, {2,0x0D6D,0x0D6D,0x0D6D}, {2,0x0D6E,0x0D6E,0x0D6E}, {2,0x0D6F,0x0D6F,0x0D6F},
 {0,0x0D70,0x0D70,0x0D70}, {0,0x0D71,0x0D71,0x0D71}, {0,0x0D72,0x0D72,0x0D72}, {0,0x0D73,0x0D73,0x0D73},
 {0,0x0D74,0x0D74,0x0D74}, {0,0x0D75,0x0D75,0x0D75}, {0,0x0D76,0x0D76,0x0D76}, {0,0x0D77,0x0D77,0x0D77},
 {0,0x0D78,0x0D78,0x0D78}, {0,0x0D79,0x0D79,0x0D79}, {0,0x0D7A,0x0D7A,0x0D7A}, {0,0x0D7B,0x0D7B,0x0D7B},
 {0,0x0D7C,0x0D7C,0x0D7C}, {0,0x0D7D,0x0D7D,0x0D7D}, {0,0x0D7E,0x0D7E,0x0D7E}, {0,0x0D7F,0x0D7F,0x0D7F},
 {0,0x0D80,0x0D80,0x0D80}, {0,0x0D81,0x0D81,0x0D81}, {1,0x0D82,0x0D82,0x0D82}, {1,0x0D83,0x0D83,0x0D83},
 {0,0x0D84,0x0D84,0x0D84}, {1,0x0D85,0x0D85,0x0D85}, {1,0x0D86,0x0D86,0x0D86}, {1,0x0D87,0x0D87,0x0D87},
 {1,0x0D88,0x0D88,0x0D88}, {1,0x0D89,0x0D89,0x0D89}, {1,0x0D8A,0x0D8A,0x0D8A}, {1,0x0D8B,0x0D8B,0x0D8B},
 {1,0x0D8C,0x0D8C,0x0D8C}, {1,0x0D8D,0x0D8D,0x0D8D}, {1,0x0D8E,0x0D8E,0x0D8E}, {1,0x0D8F,0x0D8F,0x0D8F},
 {1,0x0D90,0x0D90,0x0D90}, {1,0x0D91,0x0D91,0x0D91}, {1,0x0D92,0x0D92,0x0D92}, {1,0x0D93,0x0D93,0x0D93},
 {1,0x0D94,0x0D94,0x0D94}, {1,0x0D95,0x0D95,0x0D95}, {1,0x0D96,0x0D96,0x0D96}, {0,0x0D97,0x0D97,0x0D97},
 {0,0x0D98,0x0D98,0x0D98}, {0,0x0D99,0x0D99,0x0D99}, {1,0x0D9A,0x0D9A,0x0D9A}, {1,0x0D9B,0x0D9B,0x0D9B},
 {1,0x0D9C,0x0D9C,0x0D9C}, {1,0x0D9D,0x0D9D,0x0D9D}, {1,0x0D9E,0x0D9E,0x0D9E}, {1,0x0D9F,0x0D9F,0x0D9F},
 {1,0x0DA0,0x0DA0,0x0DA0}, {1,0x0DA1,0x0DA1,0x0DA1}, {1,0x0DA2,0x0DA2,0x0DA2}, {1,0x0DA3,0x0DA3,0x0DA3},
 {1,0x0DA4,0x0DA4,0x0DA4}, {1,0x0DA5,0x0DA5,0x0DA5}, {1,0x0DA6,0x0DA6,0x0DA6}, {1,0x0DA7,0x0DA7,0x0DA7},
 {1,0x0DA8,0x0DA8,0x0DA8}, {1,0x0DA9,0x0DA9,0x0DA9}, {1,0x0DAA,0x0DAA,0x0DAA}, {1,0x0DAB,0x0DAB,0x0DAB},
 {1,0x0DAC,0x0DAC,0x0DAC}, {1,0x0DAD,0x0DAD,0x0DAD}, {1,0x0DAE,0x0DAE,0x0DAE}, {1,0x0DAF,0x0DAF,0x0DAF},
 {1,0x0DB0,0x0DB0,0x0DB0}, {1,0x0DB1,0x0DB1,0x0DB1}, {0,0x0DB2,0x0DB2,0x0DB2}, {1,0x0DB3,0x0DB3,0x0DB3},
 {1,0x0DB4,0x0DB4,0x0DB4}, {1,0x0DB5,0x0DB5,0x0DB5}, {1,0x0DB6,0x0DB6,0x0DB6}, {1,0x0DB7,0x0DB7,0x0DB7},
 {1,0x0DB8,0x0DB8,0x0DB8}, {1,0x0DB9,0x0DB9,0x0DB9}, {1,0x0DBA,0x0DBA,0x0DBA}, {1,0x0DBB,0x0DBB,0x0DBB},
 {0,0x0DBC,0x0DBC,0x0DBC}, {1,0x0DBD,0x0DBD,0x0DBD}, {0,0x0DBE,0x0DBE,0x0DBE}, {0,0x0DBF,0x0DBF,0x0DBF},
 {1,0x0DC0,0x0DC0,0x0DC0}, {1,0x0DC1,0x0DC1,0x0DC1}, {1,0x0DC2,0x0DC2,0x0DC2}, {1,0x0DC3,0x0DC3,0x0DC3},
 {1,0x0DC4,0x0DC4,0x0DC4}, {1,0x0DC5,0x0DC5,0x0DC5}, {1,0x0DC6,0x0DC6,0x0DC6}, {0,0x0DC7,0x0DC7,0x0DC7},
 {0,0x0DC8,0x0DC8,0x0DC8}, {0,0x0DC9,0x0DC9,0x0DC9}, {1,0x0DCA,0x0DCA,0x0DCA}, {0,0x0DCB,0x0DCB,0x0DCB},
 {0,0x0DCC,0x0DCC,0x0DCC}, {0,0x0DCD,0x0DCD,0x0DCD}, {0,0x0DCE,0x0DCE,0x0DCE}, {1,0x0DCF,0x0DCF,0x0DCF},
 {1,0x0DD0,0x0DD0,0x0DD0}, {1,0x0DD1,0x0DD1,0x0DD1}, {1,0x0DD2,0x0DD2,0x0DD2}, {1,0x0DD3,0x0DD3,0x0DD3},
 {1,0x0DD4,0x0DD4,0x0DD4}, {0,0x0DD5,0x0DD5,0x0DD5}, {1,0x0DD6,0x0DD6,0x0DD6}, {0,0x0DD7,0x0DD7,0x0DD7},
 {1,0x0DD8,0x0DD8,0x0DD8}, {1,0x0DD9,0x0DD9,0x0DD9}, {1,0x0DDA,0x0DDA,0x0DDA}, {1,0x0DDB,0x0DDB,0x0DDB},
 {1,0x0DDC,0x0DDC,0x0DDC}, {1,0x0DDD,0x0DDD,0x0DDD}, {1,0x0DDE,0x0DDE,0x0DDE}, {1,0x0DDF,0x0DDF,0x0DDF},
 {0,0x0DE0,0x0DE0,0x0DE0}, {0,0x0DE1,0x0DE1,0x0DE1}, {0,0x0DE2,0x0DE2,0x0DE2}, {0,0x0DE3,0x0DE3,0x0DE3},
 {0,0x0DE4,0x0DE4,0x0DE4}, {0,0x0DE5,0x0DE5,0x0DE5}, {0,0x0DE6,0x0DE6,0x0DE6}, {0,0x0DE7,0x0DE7,0x0DE7},
 {0,0x0DE8,0x0DE8,0x0DE8}, {0,0x0DE9,0x0DE9,0x0DE9}, {0,0x0DEA,0x0DEA,0x0DEA}, {0,0x0DEB,0x0DEB,0x0DEB},
 {0,0x0DEC,0x0DEC,0x0DEC}, {0,0x0DED,0x0DED,0x0DED}, {0,0x0DEE,0x0DEE,0x0DEE}, {0,0x0DEF,0x0DEF,0x0DEF},
 {0,0x0DF0,0x0DF0,0x0DF0}, {0,0x0DF1,0x0DF1,0x0DF1}, {1,0x0DF2,0x0DF2,0x0DF2}, {1,0x0DF3,0x0DF3,0x0DF3},
 {0,0x0DF4,0x0DF4,0x0DF4}, {0,0x0DF5,0x0DF5,0x0DF5}, {0,0x0DF6,0x0DF6,0x0DF6}, {0,0x0DF7,0x0DF7,0x0DF7},
 {0,0x0DF8,0x0DF8,0x0DF8}, {0,0x0DF9,0x0DF9,0x0DF9}, {0,0x0DFA,0x0DFA,0x0DFA}, {0,0x0DFB,0x0DFB,0x0DFB},
 {0,0x0DFC,0x0DFC,0x0DFC}, {0,0x0DFD,0x0DFD,0x0DFD}, {0,0x0DFE,0x0DFE,0x0DFE}, {0,0x0DFF,0x0DFF,0x0DFF},
{0,0}};

static UDM_UNICODE plane0E[257]={
 {0,0x0E00,0x0E00,0x0E00}, {1,0x0E01,0x0E01,0x0E01}, {1,0x0E02,0x0E02,0x0E02}, {1,0x0E03,0x0E03,0x0E03},
 {1,0x0E04,0x0E04,0x0E04}, {1,0x0E05,0x0E05,0x0E05}, {1,0x0E06,0x0E06,0x0E06}, {1,0x0E07,0x0E07,0x0E07},
 {1,0x0E08,0x0E08,0x0E08}, {1,0x0E09,0x0E09,0x0E09}, {1,0x0E0A,0x0E0A,0x0E0A}, {1,0x0E0B,0x0E0B,0x0E0B},
 {1,0x0E0C,0x0E0C,0x0E0C}, {1,0x0E0D,0x0E0D,0x0E0D}, {1,0x0E0E,0x0E0E,0x0E0E}, {1,0x0E0F,0x0E0F,0x0E0F},
 {1,0x0E10,0x0E10,0x0E10}, {1,0x0E11,0x0E11,0x0E11}, {1,0x0E12,0x0E12,0x0E12}, {1,0x0E13,0x0E13,0x0E13},
 {1,0x0E14,0x0E14,0x0E14}, {1,0x0E15,0x0E15,0x0E15}, {1,0x0E16,0x0E16,0x0E16}, {1,0x0E17,0x0E17,0x0E17},
 {1,0x0E18,0x0E18,0x0E18}, {1,0x0E19,0x0E19,0x0E19}, {1,0x0E1A,0x0E1A,0x0E1A}, {1,0x0E1B,0x0E1B,0x0E1B},
 {1,0x0E1C,0x0E1C,0x0E1C}, {1,0x0E1D,0x0E1D,0x0E1D}, {1,0x0E1E,0x0E1E,0x0E1E}, {1,0x0E1F,0x0E1F,0x0E1F},
 {1,0x0E20,0x0E20,0x0E20}, {1,0x0E21,0x0E21,0x0E21}, {1,0x0E22,0x0E22,0x0E22}, {1,0x0E23,0x0E23,0x0E23},
 {1,0x0E24,0x0E24,0x0E24}, {1,0x0E25,0x0E25,0x0E25}, {1,0x0E26,0x0E26,0x0E26}, {1,0x0E27,0x0E27,0x0E27},
 {1,0x0E28,0x0E28,0x0E28}, {1,0x0E29,0x0E29,0x0E29}, {1,0x0E2A,0x0E2A,0x0E2A}, {1,0x0E2B,0x0E2B,0x0E2B},
 {1,0x0E2C,0x0E2C,0x0E2C}, {1,0x0E2D,0x0E2D,0x0E2D}, {1,0x0E2E,0x0E2E,0x0E2E}, {1,0x0E2F,0x0E2F,0x0E2F},
 {1,0x0E30,0x0E30,0x0E30}, {1,0x0E31,0x0E31,0x0E31}, {1,0x0E32,0x0E32,0x0E32}, {1,0x0E33,0x0E33,0x0E33},
 {1,0x0E34,0x0E34,0x0E34}, {1,0x0E35,0x0E35,0x0E35}, {1,0x0E36,0x0E36,0x0E36}, {1,0x0E37,0x0E37,0x0E37},
 {1,0x0E38,0x0E38,0x0E38}, {1,0x0E39,0x0E39,0x0E39}, {1,0x0E3A,0x0E3A,0x0E3A}, {0,0x0E3B,0x0E3B,0x0E3B},
 {0,0x0E3C,0x0E3C,0x0E3C}, {0,0x0E3D,0x0E3D,0x0E3D}, {0,0x0E3E,0x0E3E,0x0E3E}, {0,0x0E3F,0x0E3F,0x0E3F},
 {1,0x0E40,0x0E40,0x0E40}, {1,0x0E41,0x0E41,0x0E41}, {1,0x0E42,0x0E42,0x0E42}, {1,0x0E43,0x0E43,0x0E43},
 {1,0x0E44,0x0E44,0x0E44}, {1,0x0E45,0x0E45,0x0E45}, {1,0x0E46,0x0E46,0x0E46}, {1,0x0E47,0x0E47,0x0E47},
 {1,0x0E48,0x0E48,0x0E48}, {1,0x0E49,0x0E49,0x0E49}, {1,0x0E4A,0x0E4A,0x0E4A}, {1,0x0E4B,0x0E4B,0x0E4B},
 {1,0x0E4C,0x0E4C,0x0E4C}, {1,0x0E4D,0x0E4D,0x0E4D}, {1,0x0E4E,0x0E4E,0x0E4E}, {0,0x0E4F,0x0E4F,0x0E4F},
 {2,0x0E50,0x0E50,0x0E50}, {2,0x0E51,0x0E51,0x0E51}, {2,0x0E52,0x0E52,0x0E52}, {2,0x0E53,0x0E53,0x0E53},
 {2,0x0E54,0x0E54,0x0E54}, {2,0x0E55,0x0E55,0x0E55}, {2,0x0E56,0x0E56,0x0E56}, {2,0x0E57,0x0E57,0x0E57},
 {2,0x0E58,0x0E58,0x0E58}, {2,0x0E59,0x0E59,0x0E59}, {0,0x0E5A,0x0E5A,0x0E5A}, {0,0x0E5B,0x0E5B,0x0E5B},
 {0,0x0E5C,0x0E5C,0x0E5C}, {0,0x0E5D,0x0E5D,0x0E5D}, {0,0x0E5E,0x0E5E,0x0E5E}, {0,0x0E5F,0x0E5F,0x0E5F},
 {0,0x0E60,0x0E60,0x0E60}, {0,0x0E61,0x0E61,0x0E61}, {0,0x0E62,0x0E62,0x0E62}, {0,0x0E63,0x0E63,0x0E63},
 {0,0x0E64,0x0E64,0x0E64}, {0,0x0E65,0x0E65,0x0E65}, {0,0x0E66,0x0E66,0x0E66}, {0,0x0E67,0x0E67,0x0E67},
 {0,0x0E68,0x0E68,0x0E68}, {0,0x0E69,0x0E69,0x0E69}, {0,0x0E6A,0x0E6A,0x0E6A}, {0,0x0E6B,0x0E6B,0x0E6B},
 {0,0x0E6C,0x0E6C,0x0E6C}, {0,0x0E6D,0x0E6D,0x0E6D}, {0,0x0E6E,0x0E6E,0x0E6E}, {0,0x0E6F,0x0E6F,0x0E6F},
 {0,0x0E70,0x0E70,0x0E70}, {0,0x0E71,0x0E71,0x0E71}, {0,0x0E72,0x0E72,0x0E72}, {0,0x0E73,0x0E73,0x0E73},
 {0,0x0E74,0x0E74,0x0E74}, {0,0x0E75,0x0E75,0x0E75}, {0,0x0E76,0x0E76,0x0E76}, {0,0x0E77,0x0E77,0x0E77},
 {0,0x0E78,0x0E78,0x0E78}, {0,0x0E79,0x0E79,0x0E79}, {0,0x0E7A,0x0E7A,0x0E7A}, {0,0x0E7B,0x0E7B,0x0E7B},
 {0,0x0E7C,0x0E7C,0x0E7C}, {0,0x0E7D,0x0E7D,0x0E7D}, {0,0x0E7E,0x0E7E,0x0E7E}, {0,0x0E7F,0x0E7F,0x0E7F},
 {0,0x0E80,0x0E80,0x0E80}, {1,0x0E81,0x0E81,0x0E81}, {1,0x0E82,0x0E82,0x0E82}, {0,0x0E83,0x0E83,0x0E83},
 {1,0x0E84,0x0E84,0x0E84}, {0,0x0E85,0x0E85,0x0E85}, {0,0x0E86,0x0E86,0x0E86}, {1,0x0E87,0x0E87,0x0E87},
 {1,0x0E88,0x0E88,0x0E88}, {0,0x0E89,0x0E89,0x0E89}, {1,0x0E8A,0x0E8A,0x0E8A}, {0,0x0E8B,0x0E8B,0x0E8B},
 {0,0x0E8C,0x0E8C,0x0E8C}, {1,0x0E8D,0x0E8D,0x0E8D}, {0,0x0E8E,0x0E8E,0x0E8E}, {0,0x0E8F,0x0E8F,0x0E8F},
 {0,0x0E90,0x0E90,0x0E90}, {0,0x0E91,0x0E91,0x0E91}, {0,0x0E92,0x0E92,0x0E92}, {0,0x0E93,0x0E93,0x0E93},
 {1,0x0E94,0x0E94,0x0E94}, {1,0x0E95,0x0E95,0x0E95}, {1,0x0E96,0x0E96,0x0E96}, {1,0x0E97,0x0E97,0x0E97},
 {0,0x0E98,0x0E98,0x0E98}, {1,0x0E99,0x0E99,0x0E99}, {1,0x0E9A,0x0E9A,0x0E9A}, {1,0x0E9B,0x0E9B,0x0E9B},
 {1,0x0E9C,0x0E9C,0x0E9C}, {1,0x0E9D,0x0E9D,0x0E9D}, {1,0x0E9E,0x0E9E,0x0E9E}, {1,0x0E9F,0x0E9F,0x0E9F},
 {0,0x0EA0,0x0EA0,0x0EA0}, {1,0x0EA1,0x0EA1,0x0EA1}, {1,0x0EA2,0x0EA2,0x0EA2}, {1,0x0EA3,0x0EA3,0x0EA3},
 {0,0x0EA4,0x0EA4,0x0EA4}, {1,0x0EA5,0x0EA5,0x0EA5}, {0,0x0EA6,0x0EA6,0x0EA6}, {1,0x0EA7,0x0EA7,0x0EA7},
 {0,0x0EA8,0x0EA8,0x0EA8}, {0,0x0EA9,0x0EA9,0x0EA9}, {1,0x0EAA,0x0EAA,0x0EAA}, {1,0x0EAB,0x0EAB,0x0EAB},
 {0,0x0EAC,0x0EAC,0x0EAC}, {1,0x0EAD,0x0EAD,0x0EAD}, {1,0x0EAE,0x0EAE,0x0EAE}, {1,0x0EAF,0x0EAF,0x0EAF},
 {1,0x0EB0,0x0EB0,0x0EB0}, {1,0x0EB1,0x0EB1,0x0EB1}, {1,0x0EB2,0x0EB2,0x0EB2}, {1,0x0EB3,0x0EB3,0x0EB3},
 {1,0x0EB4,0x0EB4,0x0EB4}, {1,0x0EB5,0x0EB5,0x0EB5}, {1,0x0EB6,0x0EB6,0x0EB6}, {1,0x0EB7,0x0EB7,0x0EB7},
 {1,0x0EB8,0x0EB8,0x0EB8}, {1,0x0EB9,0x0EB9,0x0EB9}, {0,0x0EBA,0x0EBA,0x0EBA}, {1,0x0EBB,0x0EBB,0x0EBB},
 {1,0x0EBC,0x0EBC,0x0EBC}, {1,0x0EBD,0x0EBD,0x0EBD}, {0,0x0EBE,0x0EBE,0x0EBE}, {0,0x0EBF,0x0EBF,0x0EBF},
 {1,0x0EC0,0x0EC0,0x0EC0}, {1,0x0EC1,0x0EC1,0x0EC1}, {1,0x0EC2,0x0EC2,0x0EC2}, {1,0x0EC3,0x0EC3,0x0EC3},
 {1,0x0EC4,0x0EC4,0x0EC4}, {0,0x0EC5,0x0EC5,0x0EC5}, {1,0x0EC6,0x0EC6,0x0EC6}, {0,0x0EC7,0x0EC7,0x0EC7},
 {1,0x0EC8,0x0EC8,0x0EC8}, {1,0x0EC9,0x0EC9,0x0EC9}, {1,0x0ECA,0x0ECA,0x0ECA}, {1,0x0ECB,0x0ECB,0x0ECB},
 {1,0x0ECC,0x0ECC,0x0ECC}, {1,0x0ECD,0x0ECD,0x0ECD}, {0,0x0ECE,0x0ECE,0x0ECE}, {0,0x0ECF,0x0ECF,0x0ECF},
 {2,0x0ED0,0x0ED0,0x0ED0}, {2,0x0ED1,0x0ED1,0x0ED1}, {2,0x0ED2,0x0ED2,0x0ED2}, {2,0x0ED3,0x0ED3,0x0ED3},
 {2,0x0ED4,0x0ED4,0x0ED4}, {2,0x0ED5,0x0ED5,0x0ED5}, {2,0x0ED6,0x0ED6,0x0ED6}, {2,0x0ED7,0x0ED7,0x0ED7},
 {2,0x0ED8,0x0ED8,0x0ED8}, {2,0x0ED9,0x0ED9,0x0ED9}, {0,0x0EDA,0x0EDA,0x0EDA}, {0,0x0EDB,0x0EDB,0x0EDB},
 {1,0x0EDC,0x0EDC,0x0EDC}, {1,0x0EDD,0x0EDD,0x0EDD}, {0,0x0EDE,0x0EDE,0x0EDE}, {0,0x0EDF,0x0EDF,0x0EDF},
 {0,0x0EE0,0x0EE0,0x0EE0}, {0,0x0EE1,0x0EE1,0x0EE1}, {0,0x0EE2,0x0EE2,0x0EE2}, {0,0x0EE3,0x0EE3,0x0EE3},
 {0,0x0EE4,0x0EE4,0x0EE4}, {0,0x0EE5,0x0EE5,0x0EE5}, {0,0x0EE6,0x0EE6,0x0EE6}, {0,0x0EE7,0x0EE7,0x0EE7},
 {0,0x0EE8,0x0EE8,0x0EE8}, {0,0x0EE9,0x0EE9,0x0EE9}, {0,0x0EEA,0x0EEA,0x0EEA}, {0,0x0EEB,0x0EEB,0x0EEB},
 {0,0x0EEC,0x0EEC,0x0EEC}, {0,0x0EED,0x0EED,0x0EED}, {0,0x0EEE,0x0EEE,0x0EEE}, {0,0x0EEF,0x0EEF,0x0EEF},
 {0,0x0EF0,0x0EF0,0x0EF0}, {0,0x0EF1,0x0EF1,0x0EF1}, {0,0x0EF2,0x0EF2,0x0EF2}, {0,0x0EF3,0x0EF3,0x0EF3},
 {0,0x0EF4,0x0EF4,0x0EF4}, {0,0x0EF5,0x0EF5,0x0EF5}, {0,0x0EF6,0x0EF6,0x0EF6}, {0,0x0EF7,0x0EF7,0x0EF7},
 {0,0x0EF8,0x0EF8,0x0EF8}, {0,0x0EF9,0x0EF9,0x0EF9}, {0,0x0EFA,0x0EFA,0x0EFA}, {0,0x0EFB,0x0EFB,0x0EFB},
 {0,0x0EFC,0x0EFC,0x0EFC}, {0,0x0EFD,0x0EFD,0x0EFD}, {0,0x0EFE,0x0EFE,0x0EFE}, {0,0x0EFF,0x0EFF,0x0EFF},
{0,0}};

static UDM_UNICODE plane0F[257]={
 {1,0x0F00,0x0F00,0x0F00}, {0,0x0F01,0x0F01,0x0F01}, {0,0x0F02,0x0F02,0x0F02}, {0,0x0F03,0x0F03,0x0F03},
 {0,0x0F04,0x0F04,0x0F04}, {0,0x0F05,0x0F05,0x0F05}, {0,0x0F06,0x0F06,0x0F06}, {0,0x0F07,0x0F07,0x0F07},
 {0,0x0F08,0x0F08,0x0F08}, {0,0x0F09,0x0F09,0x0F09}, {0,0x0F0A,0x0F0A,0x0F0A}, {0,0x0F0B,0x0F0B,0x0F0B},
 {0,0x0F0C,0x0F0C,0x0F0C}, {0,0x0F0D,0x0F0D,0x0F0D}, {0,0x0F0E,0x0F0E,0x0F0E}, {0,0x0F0F,0x0F0F,0x0F0F},
 {0,0x0F10,0x0F10,0x0F10}, {0,0x0F11,0x0F11,0x0F11}, {0,0x0F12,0x0F12,0x0F12}, {0,0x0F13,0x0F13,0x0F13},
 {0,0x0F14,0x0F14,0x0F14}, {0,0x0F15,0x0F15,0x0F15}, {0,0x0F16,0x0F16,0x0F16}, {0,0x0F17,0x0F17,0x0F17},
 {1,0x0F18,0x0F18,0x0F18}, {1,0x0F19,0x0F19,0x0F19}, {0,0x0F1A,0x0F1A,0x0F1A}, {0,0x0F1B,0x0F1B,0x0F1B},
 {0,0x0F1C,0x0F1C,0x0F1C}, {0,0x0F1D,0x0F1D,0x0F1D}, {0,0x0F1E,0x0F1E,0x0F1E}, {0,0x0F1F,0x0F1F,0x0F1F},
 {2,0x0F20,0x0F20,0x0F20}, {2,0x0F21,0x0F21,0x0F21}, {2,0x0F22,0x0F22,0x0F22}, {2,0x0F23,0x0F23,0x0F23},
 {2,0x0F24,0x0F24,0x0F24}, {2,0x0F25,0x0F25,0x0F25}, {2,0x0F26,0x0F26,0x0F26}, {2,0x0F27,0x0F27,0x0F27},
 {2,0x0F28,0x0F28,0x0F28}, {2,0x0F29,0x0F29,0x0F29}, {0,0x0F2A,0x0F2A,0x0F2A}, {0,0x0F2B,0x0F2B,0x0F2B},
 {0,0x0F2C,0x0F2C,0x0F2C}, {0,0x0F2D,0x0F2D,0x0F2D}, {0,0x0F2E,0x0F2E,0x0F2E}, {0,0x0F2F,0x0F2F,0x0F2F},
 {0,0x0F30,0x0F30,0x0F30}, {0,0x0F31,0x0F31,0x0F31}, {0,0x0F32,0x0F32,0x0F32}, {0,0x0F33,0x0F33,0x0F33},
 {0,0x0F34,0x0F34,0x0F34}, {1,0x0F35,0x0F35,0x0F35}, {0,0x0F36,0x0F36,0x0F36}, {1,0x0F37,0x0F37,0x0F37},
 {0,0x0F38,0x0F38,0x0F38}, {1,0x0F39,0x0F39,0x0F39}, {0,0x0F3A,0x0F3A,0x0F3A}, {0,0x0F3B,0x0F3B,0x0F3B},
 {0,0x0F3C,0x0F3C,0x0F3C}, {0,0x0F3D,0x0F3D,0x0F3D}, {1,0x0F3E,0x0F3E,0x0F3E}, {1,0x0F3F,0x0F3F,0x0F3F},
 {1,0x0F40,0x0F40,0x0F40}, {1,0x0F41,0x0F41,0x0F41}, {1,0x0F42,0x0F42,0x0F42}, {1,0x0F43,0x0F43,0x0F43},
 {1,0x0F44,0x0F44,0x0F44}, {1,0x0F45,0x0F45,0x0F45}, {1,0x0F46,0x0F46,0x0F46}, {1,0x0F47,0x0F47,0x0F47},
 {0,0x0F48,0x0F48,0x0F48}, {1,0x0F49,0x0F49,0x0F49}, {1,0x0F4A,0x0F4A,0x0F4A}, {1,0x0F4B,0x0F4B,0x0F4B},
 {1,0x0F4C,0x0F4C,0x0F4C}, {1,0x0F4D,0x0F4D,0x0F4D}, {1,0x0F4E,0x0F4E,0x0F4E}, {1,0x0F4F,0x0F4F,0x0F4F},
 {1,0x0F50,0x0F50,0x0F50}, {1,0x0F51,0x0F51,0x0F51}, {1,0x0F52,0x0F52,0x0F52}, {1,0x0F53,0x0F53,0x0F53},
 {1,0x0F54,0x0F54,0x0F54}, {1,0x0F55,0x0F55,0x0F55}, {1,0x0F56,0x0F56,0x0F56}, {1,0x0F57,0x0F57,0x0F57},
 {1,0x0F58,0x0F58,0x0F58}, {1,0x0F59,0x0F59,0x0F59}, {1,0x0F5A,0x0F5A,0x0F5A}, {1,0x0F5B,0x0F5B,0x0F5B},
 {1,0x0F5C,0x0F5C,0x0F5C}, {1,0x0F5D,0x0F5D,0x0F5D}, {1,0x0F5E,0x0F5E,0x0F5E}, {1,0x0F5F,0x0F5F,0x0F5F},
 {1,0x0F60,0x0F60,0x0F60}, {1,0x0F61,0x0F61,0x0F61}, {1,0x0F62,0x0F62,0x0F62}, {1,0x0F63,0x0F63,0x0F63},
 {1,0x0F64,0x0F64,0x0F64}, {1,0x0F65,0x0F65,0x0F65}, {1,0x0F66,0x0F66,0x0F66}, {1,0x0F67,0x0F67,0x0F67},
 {1,0x0F68,0x0F68,0x0F68}, {1,0x0F69,0x0F69,0x0F69}, {1,0x0F6A,0x0F6A,0x0F6A}, {0,0x0F6B,0x0F6B,0x0F6B},
 {0,0x0F6C,0x0F6C,0x0F6C}, {0,0x0F6D,0x0F6D,0x0F6D}, {0,0x0F6E,0x0F6E,0x0F6E}, {0,0x0F6F,0x0F6F,0x0F6F},
 {0,0x0F70,0x0F70,0x0F70}, {1,0x0F71,0x0F71,0x0F71}, {1,0x0F72,0x0F72,0x0F72}, {1,0x0F73,0x0F73,0x0F73},
 {1,0x0F74,0x0F74,0x0F74}, {1,0x0F75,0x0F75,0x0F75}, {1,0x0F76,0x0F76,0x0F76}, {1,0x0F77,0x0F77,0x0F77},
 {1,0x0F78,0x0F78,0x0F78}, {1,0x0F79,0x0F79,0x0F79}, {1,0x0F7A,0x0F7A,0x0F7A}, {1,0x0F7B,0x0F7B,0x0F7B},
 {1,0x0F7C,0x0F7C,0x0F7C}, {1,0x0F7D,0x0F7D,0x0F7D}, {1,0x0F7E,0x0F7E,0x0F7E}, {1,0x0F7F,0x0F7F,0x0F7F},
 {1,0x0F80,0x0F80,0x0F80}, {1,0x0F81,0x0F81,0x0F81}, {1,0x0F82,0x0F82,0x0F82}, {1,0x0F83,0x0F83,0x0F83},
 {1,0x0F84,0x0F84,0x0F84}, {0,0x0F85,0x0F85,0x0F85}, {1,0x0F86,0x0F86,0x0F86}, {1,0x0F87,0x0F87,0x0F87},
 {1,0x0F88,0x0F88,0x0F88}, {1,0x0F89,0x0F89,0x0F89}, {1,0x0F8A,0x0F8A,0x0F8A}, {1,0x0F8B,0x0F8B,0x0F8B},
 {0,0x0F8C,0x0F8C,0x0F8C}, {0,0x0F8D,0x0F8D,0x0F8D}, {0,0x0F8E,0x0F8E,0x0F8E}, {0,0x0F8F,0x0F8F,0x0F8F},
 {1,0x0F90,0x0F90,0x0F90}, {1,0x0F91,0x0F91,0x0F91}, {1,0x0F92,0x0F92,0x0F92}, {1,0x0F93,0x0F93,0x0F93},
 {1,0x0F94,0x0F94,0x0F94}, {1,0x0F95,0x0F95,0x0F95}, {1,0x0F96,0x0F96,0x0F96}, {1,0x0F97,0x0F97,0x0F97},
 {0,0x0F98,0x0F98,0x0F98}, {1,0x0F99,0x0F99,0x0F99}, {1,0x0F9A,0x0F9A,0x0F9A}, {1,0x0F9B,0x0F9B,0x0F9B},
 {1,0x0F9C,0x0F9C,0x0F9C}, {1,0x0F9D,0x0F9D,0x0F9D}, {1,0x0F9E,0x0F9E,0x0F9E}, {1,0x0F9F,0x0F9F,0x0F9F},
 {1,0x0FA0,0x0FA0,0x0FA0}, {1,0x0FA1,0x0FA1,0x0FA1}, {1,0x0FA2,0x0FA2,0x0FA2}, {1,0x0FA3,0x0FA3,0x0FA3},
 {1,0x0FA4,0x0FA4,0x0FA4}, {1,0x0FA5,0x0FA5,0x0FA5}, {1,0x0FA6,0x0FA6,0x0FA6}, {1,0x0FA7,0x0FA7,0x0FA7},
 {1,0x0FA8,0x0FA8,0x0FA8}, {1,0x0FA9,0x0FA9,0x0FA9}, {1,0x0FAA,0x0FAA,0x0FAA}, {1,0x0FAB,0x0FAB,0x0FAB},
 {1,0x0FAC,0x0FAC,0x0FAC}, {1,0x0FAD,0x0FAD,0x0FAD}, {1,0x0FAE,0x0FAE,0x0FAE}, {1,0x0FAF,0x0FAF,0x0FAF},
 {1,0x0FB0,0x0FB0,0x0FB0}, {1,0x0FB1,0x0FB1,0x0FB1}, {1,0x0FB2,0x0FB2,0x0FB2}, {1,0x0FB3,0x0FB3,0x0FB3},
 {1,0x0FB4,0x0FB4,0x0FB4}, {1,0x0FB5,0x0FB5,0x0FB5}, {1,0x0FB6,0x0FB6,0x0FB6}, {1,0x0FB7,0x0FB7,0x0FB7},
 {1,0x0FB8,0x0FB8,0x0FB8}, {1,0x0FB9,0x0FB9,0x0FB9}, {1,0x0FBA,0x0FBA,0x0FBA}, {1,0x0FBB,0x0FBB,0x0FBB},
 {1,0x0FBC,0x0FBC,0x0FBC}, {0,0x0FBD,0x0FBD,0x0FBD}, {0,0x0FBE,0x0FBE,0x0FBE}, {0,0x0FBF,0x0FBF,0x0FBF},
 {0,0x0FC0,0x0FC0,0x0FC0}, {0,0x0FC1,0x0FC1,0x0FC1}, {0,0x0FC2,0x0FC2,0x0FC2}, {0,0x0FC3,0x0FC3,0x0FC3},
 {0,0x0FC4,0x0FC4,0x0FC4}, {0,0x0FC5,0x0FC5,0x0FC5}, {1,0x0FC6,0x0FC6,0x0FC6}, {0,0x0FC7,0x0FC7,0x0FC7},
 {0,0x0FC8,0x0FC8,0x0FC8}, {0,0x0FC9,0x0FC9,0x0FC9}, {0,0x0FCA,0x0FCA,0x0FCA}, {0,0x0FCB,0x0FCB,0x0FCB},
 {0,0x0FCC,0x0FCC,0x0FCC}, {0,0x0FCD,0x0FCD,0x0FCD}, {0,0x0FCE,0x0FCE,0x0FCE}, {0,0x0FCF,0x0FCF,0x0FCF},
 {0,0x0FD0,0x0FD0,0x0FD0}, {0,0x0FD1,0x0FD1,0x0FD1}, {0,0x0FD2,0x0FD2,0x0FD2}, {0,0x0FD3,0x0FD3,0x0FD3},
 {0,0x0FD4,0x0FD4,0x0FD4}, {0,0x0FD5,0x0FD5,0x0FD5}, {0,0x0FD6,0x0FD6,0x0FD6}, {0,0x0FD7,0x0FD7,0x0FD7},
 {0,0x0FD8,0x0FD8,0x0FD8}, {0,0x0FD9,0x0FD9,0x0FD9}, {0,0x0FDA,0x0FDA,0x0FDA}, {0,0x0FDB,0x0FDB,0x0FDB},
 {0,0x0FDC,0x0FDC,0x0FDC}, {0,0x0FDD,0x0FDD,0x0FDD}, {0,0x0FDE,0x0FDE,0x0FDE}, {0,0x0FDF,0x0FDF,0x0FDF},
 {0,0x0FE0,0x0FE0,0x0FE0}, {0,0x0FE1,0x0FE1,0x0FE1}, {0,0x0FE2,0x0FE2,0x0FE2}, {0,0x0FE3,0x0FE3,0x0FE3},
 {0,0x0FE4,0x0FE4,0x0FE4}, {0,0x0FE5,0x0FE5,0x0FE5}, {0,0x0FE6,0x0FE6,0x0FE6}, {0,0x0FE7,0x0FE7,0x0FE7},
 {0,0x0FE8,0x0FE8,0x0FE8}, {0,0x0FE9,0x0FE9,0x0FE9}, {0,0x0FEA,0x0FEA,0x0FEA}, {0,0x0FEB,0x0FEB,0x0FEB},
 {0,0x0FEC,0x0FEC,0x0FEC}, {0,0x0FED,0x0FED,0x0FED}, {0,0x0FEE,0x0FEE,0x0FEE}, {0,0x0FEF,0x0FEF,0x0FEF},
 {0,0x0FF0,0x0FF0,0x0FF0}, {0,0x0FF1,0x0FF1,0x0FF1}, {0,0x0FF2,0x0FF2,0x0FF2}, {0,0x0FF3,0x0FF3,0x0FF3},
 {0,0x0FF4,0x0FF4,0x0FF4}, {0,0x0FF5,0x0FF5,0x0FF5}, {0,0x0FF6,0x0FF6,0x0FF6}, {0,0x0FF7,0x0FF7,0x0FF7},
 {0,0x0FF8,0x0FF8,0x0FF8}, {0,0x0FF9,0x0FF9,0x0FF9}, {0,0x0FFA,0x0FFA,0x0FFA}, {0,0x0FFB,0x0FFB,0x0FFB},
 {0,0x0FFC,0x0FFC,0x0FFC}, {0,0x0FFD,0x0FFD,0x0FFD}, {0,0x0FFE,0x0FFE,0x0FFE}, {0,0x0FFF,0x0FFF,0x0FFF},
{0,0}};

static UDM_UNICODE plane10[257]={
 {1,0x1000,0x1000,0x1000}, {1,0x1001,0x1001,0x1001}, {1,0x1002,0x1002,0x1002}, {1,0x1003,0x1003,0x1003},
 {1,0x1004,0x1004,0x1004}, {1,0x1005,0x1005,0x1005}, {1,0x1006,0x1006,0x1006}, {1,0x1007,0x1007,0x1007},
 {1,0x1008,0x1008,0x1008}, {1,0x1009,0x1009,0x1009}, {1,0x100A,0x100A,0x100A}, {1,0x100B,0x100B,0x100B},
 {1,0x100C,0x100C,0x100C}, {1,0x100D,0x100D,0x100D}, {1,0x100E,0x100E,0x100E}, {1,0x100F,0x100F,0x100F},
 {1,0x1010,0x1010,0x1010}, {1,0x1011,0x1011,0x1011}, {1,0x1012,0x1012,0x1012}, {1,0x1013,0x1013,0x1013},
 {1,0x1014,0x1014,0x1014}, {1,0x1015,0x1015,0x1015}, {1,0x1016,0x1016,0x1016}, {1,0x1017,0x1017,0x1017},
 {1,0x1018,0x1018,0x1018}, {1,0x1019,0x1019,0x1019}, {1,0x101A,0x101A,0x101A}, {1,0x101B,0x101B,0x101B},
 {1,0x101C,0x101C,0x101C}, {1,0x101D,0x101D,0x101D}, {1,0x101E,0x101E,0x101E}, {1,0x101F,0x101F,0x101F},
 {1,0x1020,0x1020,0x1020}, {1,0x1021,0x1021,0x1021}, {0,0x1022,0x1022,0x1022}, {1,0x1023,0x1023,0x1023},
 {1,0x1024,0x1024,0x1024}, {1,0x1025,0x1025,0x1025}, {1,0x1026,0x1026,0x1026}, {1,0x1027,0x1027,0x1027},
 {0,0x1028,0x1028,0x1028}, {1,0x1029,0x1029,0x1029}, {1,0x102A,0x102A,0x102A}, {0,0x102B,0x102B,0x102B},
 {1,0x102C,0x102C,0x102C}, {1,0x102D,0x102D,0x102D}, {1,0x102E,0x102E,0x102E}, {1,0x102F,0x102F,0x102F},
 {1,0x1030,0x1030,0x1030}, {1,0x1031,0x1031,0x1031}, {1,0x1032,0x1032,0x1032}, {0,0x1033,0x1033,0x1033},
 {0,0x1034,0x1034,0x1034}, {0,0x1035,0x1035,0x1035}, {1,0x1036,0x1036,0x1036}, {1,0x1037,0x1037,0x1037},
 {1,0x1038,0x1038,0x1038}, {1,0x1039,0x1039,0x1039}, {0,0x103A,0x103A,0x103A}, {0,0x103B,0x103B,0x103B},
 {0,0x103C,0x103C,0x103C}, {0,0x103D,0x103D,0x103D}, {0,0x103E,0x103E,0x103E}, {0,0x103F,0x103F,0x103F},
 {2,0x1040,0x1040,0x1040}, {2,0x1041,0x1041,0x1041}, {2,0x1042,0x1042,0x1042}, {2,0x1043,0x1043,0x1043},
 {2,0x1044,0x1044,0x1044}, {2,0x1045,0x1045,0x1045}, {2,0x1046,0x1046,0x1046}, {2,0x1047,0x1047,0x1047},
 {2,0x1048,0x1048,0x1048}, {2,0x1049,0x1049,0x1049}, {0,0x104A,0x104A,0x104A}, {0,0x104B,0x104B,0x104B},
 {0,0x104C,0x104C,0x104C}, {0,0x104D,0x104D,0x104D}, {0,0x104E,0x104E,0x104E}, {0,0x104F,0x104F,0x104F},
 {1,0x1050,0x1050,0x1050}, {1,0x1051,0x1051,0x1051}, {1,0x1052,0x1052,0x1052}, {1,0x1053,0x1053,0x1053},
 {1,0x1054,0x1054,0x1054}, {1,0x1055,0x1055,0x1055}, {1,0x1056,0x1056,0x1056}, {1,0x1057,0x1057,0x1057},
 {1,0x1058,0x1058,0x1058}, {1,0x1059,0x1059,0x1059}, {0,0x105A,0x105A,0x105A}, {0,0x105B,0x105B,0x105B},
 {0,0x105C,0x105C,0x105C}, {0,0x105D,0x105D,0x105D}, {0,0x105E,0x105E,0x105E}, {0,0x105F,0x105F,0x105F},
 {0,0x1060,0x1060,0x1060}, {0,0x1061,0x1061,0x1061}, {0,0x1062,0x1062,0x1062}, {0,0x1063,0x1063,0x1063},
 {0,0x1064,0x1064,0x1064}, {0,0x1065,0x1065,0x1065}, {0,0x1066,0x1066,0x1066}, {0,0x1067,0x1067,0x1067},
 {0,0x1068,0x1068,0x1068}, {0,0x1069,0x1069,0x1069}, {0,0x106A,0x106A,0x106A}, {0,0x106B,0x106B,0x106B},
 {0,0x106C,0x106C,0x106C}, {0,0x106D,0x106D,0x106D}, {0,0x106E,0x106E,0x106E}, {0,0x106F,0x106F,0x106F},
 {0,0x1070,0x1070,0x1070}, {0,0x1071,0x1071,0x1071}, {0,0x1072,0x1072,0x1072}, {0,0x1073,0x1073,0x1073},
 {0,0x1074,0x1074,0x1074}, {0,0x1075,0x1075,0x1075}, {0,0x1076,0x1076,0x1076}, {0,0x1077,0x1077,0x1077},
 {0,0x1078,0x1078,0x1078}, {0,0x1079,0x1079,0x1079}, {0,0x107A,0x107A,0x107A}, {0,0x107B,0x107B,0x107B},
 {0,0x107C,0x107C,0x107C}, {0,0x107D,0x107D,0x107D}, {0,0x107E,0x107E,0x107E}, {0,0x107F,0x107F,0x107F},
 {0,0x1080,0x1080,0x1080}, {0,0x1081,0x1081,0x1081}, {0,0x1082,0x1082,0x1082}, {0,0x1083,0x1083,0x1083},
 {0,0x1084,0x1084,0x1084}, {0,0x1085,0x1085,0x1085}, {0,0x1086,0x1086,0x1086}, {0,0x1087,0x1087,0x1087},
 {0,0x1088,0x1088,0x1088}, {0,0x1089,0x1089,0x1089}, {0,0x108A,0x108A,0x108A}, {0,0x108B,0x108B,0x108B},
 {0,0x108C,0x108C,0x108C}, {0,0x108D,0x108D,0x108D}, {0,0x108E,0x108E,0x108E}, {0,0x108F,0x108F,0x108F},
 {0,0x1090,0x1090,0x1090}, {0,0x1091,0x1091,0x1091}, {0,0x1092,0x1092,0x1092}, {0,0x1093,0x1093,0x1093},
 {0,0x1094,0x1094,0x1094}, {0,0x1095,0x1095,0x1095}, {0,0x1096,0x1096,0x1096}, {0,0x1097,0x1097,0x1097},
 {0,0x1098,0x1098,0x1098}, {0,0x1099,0x1099,0x1099}, {0,0x109A,0x109A,0x109A}, {0,0x109B,0x109B,0x109B},
 {0,0x109C,0x109C,0x109C}, {0,0x109D,0x109D,0x109D}, {0,0x109E,0x109E,0x109E}, {0,0x109F,0x109F,0x109F},
 {1,0x10A0,0x10A0,0x10A0}, {1,0x10A1,0x10A1,0x10A1}, {1,0x10A2,0x10A2,0x10A2}, {1,0x10A3,0x10A3,0x10A3},
 {1,0x10A4,0x10A4,0x10A4}, {1,0x10A5,0x10A5,0x10A5}, {1,0x10A6,0x10A6,0x10A6}, {1,0x10A7,0x10A7,0x10A7},
 {1,0x10A8,0x10A8,0x10A8}, {1,0x10A9,0x10A9,0x10A9}, {1,0x10AA,0x10AA,0x10AA}, {1,0x10AB,0x10AB,0x10AB},
 {1,0x10AC,0x10AC,0x10AC}, {1,0x10AD,0x10AD,0x10AD}, {1,0x10AE,0x10AE,0x10AE}, {1,0x10AF,0x10AF,0x10AF},
 {1,0x10B0,0x10B0,0x10B0}, {1,0x10B1,0x10B1,0x10B1}, {1,0x10B2,0x10B2,0x10B2}, {1,0x10B3,0x10B3,0x10B3},
 {1,0x10B4,0x10B4,0x10B4}, {1,0x10B5,0x10B5,0x10B5}, {1,0x10B6,0x10B6,0x10B6}, {1,0x10B7,0x10B7,0x10B7},
 {1,0x10B8,0x10B8,0x10B8}, {1,0x10B9,0x10B9,0x10B9}, {1,0x10BA,0x10BA,0x10BA}, {1,0x10BB,0x10BB,0x10BB},
 {1,0x10BC,0x10BC,0x10BC}, {1,0x10BD,0x10BD,0x10BD}, {1,0x10BE,0x10BE,0x10BE}, {1,0x10BF,0x10BF,0x10BF},
 {1,0x10C0,0x10C0,0x10C0}, {1,0x10C1,0x10C1,0x10C1}, {1,0x10C2,0x10C2,0x10C2}, {1,0x10C3,0x10C3,0x10C3},
 {1,0x10C4,0x10C4,0x10C4}, {1,0x10C5,0x10C5,0x10C5}, {0,0x10C6,0x10C6,0x10C6}, {0,0x10C7,0x10C7,0x10C7},
 {0,0x10C8,0x10C8,0x10C8}, {0,0x10C9,0x10C9,0x10C9}, {0,0x10CA,0x10CA,0x10CA}, {0,0x10CB,0x10CB,0x10CB},
 {0,0x10CC,0x10CC,0x10CC}, {0,0x10CD,0x10CD,0x10CD}, {0,0x10CE,0x10CE,0x10CE}, {0,0x10CF,0x10CF,0x10CF},
 {1,0x10D0,0x10D0,0x10D0}, {1,0x10D1,0x10D1,0x10D1}, {1,0x10D2,0x10D2,0x10D2}, {1,0x10D3,0x10D3,0x10D3},
 {1,0x10D4,0x10D4,0x10D4}, {1,0x10D5,0x10D5,0x10D5}, {1,0x10D6,0x10D6,0x10D6}, {1,0x10D7,0x10D7,0x10D7},
 {1,0x10D8,0x10D8,0x10D8}, {1,0x10D9,0x10D9,0x10D9}, {1,0x10DA,0x10DA,0x10DA}, {1,0x10DB,0x10DB,0x10DB},
 {1,0x10DC,0x10DC,0x10DC}, {1,0x10DD,0x10DD,0x10DD}, {1,0x10DE,0x10DE,0x10DE}, {1,0x10DF,0x10DF,0x10DF},
 {1,0x10E0,0x10E0,0x10E0}, {1,0x10E1,0x10E1,0x10E1}, {1,0x10E2,0x10E2,0x10E2}, {1,0x10E3,0x10E3,0x10E3},
 {1,0x10E4,0x10E4,0x10E4}, {1,0x10E5,0x10E5,0x10E5}, {1,0x10E6,0x10E6,0x10E6}, {1,0x10E7,0x10E7,0x10E7},
 {1,0x10E8,0x10E8,0x10E8}, {1,0x10E9,0x10E9,0x10E9}, {1,0x10EA,0x10EA,0x10EA}, {1,0x10EB,0x10EB,0x10EB},
 {1,0x10EC,0x10EC,0x10EC}, {1,0x10ED,0x10ED,0x10ED}, {1,0x10EE,0x10EE,0x10EE}, {1,0x10EF,0x10EF,0x10EF},
 {1,0x10F0,0x10F0,0x10F0}, {1,0x10F1,0x10F1,0x10F1}, {1,0x10F2,0x10F2,0x10F2}, {1,0x10F3,0x10F3,0x10F3},
 {1,0x10F4,0x10F4,0x10F4}, {1,0x10F5,0x10F5,0x10F5}, {1,0x10F6,0x10F6,0x10F6}, {0,0x10F7,0x10F7,0x10F7},
 {0,0x10F8,0x10F8,0x10F8}, {0,0x10F9,0x10F9,0x10F9}, {0,0x10FA,0x10FA,0x10FA}, {0,0x10FB,0x10FB,0x10FB},
 {0,0x10FC,0x10FC,0x10FC}, {0,0x10FD,0x10FD,0x10FD}, {0,0x10FE,0x10FE,0x10FE}, {0,0x10FF,0x10FF,0x10FF},
{0,0}};

static UDM_UNICODE plane11[257]={
 {1,0x1100,0x1100,0x1100}, {1,0x1101,0x1101,0x1101}, {1,0x1102,0x1102,0x1102}, {1,0x1103,0x1103,0x1103},
 {1,0x1104,0x1104,0x1104}, {1,0x1105,0x1105,0x1105}, {1,0x1106,0x1106,0x1106}, {1,0x1107,0x1107,0x1107},
 {1,0x1108,0x1108,0x1108}, {1,0x1109,0x1109,0x1109}, {1,0x110A,0x110A,0x110A}, {1,0x110B,0x110B,0x110B},
 {1,0x110C,0x110C,0x110C}, {1,0x110D,0x110D,0x110D}, {1,0x110E,0x110E,0x110E}, {1,0x110F,0x110F,0x110F},
 {1,0x1110,0x1110,0x1110}, {1,0x1111,0x1111,0x1111}, {1,0x1112,0x1112,0x1112}, {1,0x1113,0x1113,0x1113},
 {1,0x1114,0x1114,0x1114}, {1,0x1115,0x1115,0x1115}, {1,0x1116,0x1116,0x1116}, {1,0x1117,0x1117,0x1117},
 {1,0x1118,0x1118,0x1118}, {1,0x1119,0x1119,0x1119}, {1,0x111A,0x111A,0x111A}, {1,0x111B,0x111B,0x111B},
 {1,0x111C,0x111C,0x111C}, {1,0x111D,0x111D,0x111D}, {1,0x111E,0x111E,0x111E}, {1,0x111F,0x111F,0x111F},
 {1,0x1120,0x1120,0x1120}, {1,0x1121,0x1121,0x1121}, {1,0x1122,0x1122,0x1122}, {1,0x1123,0x1123,0x1123},
 {1,0x1124,0x1124,0x1124}, {1,0x1125,0x1125,0x1125}, {1,0x1126,0x1126,0x1126}, {1,0x1127,0x1127,0x1127},
 {1,0x1128,0x1128,0x1128}, {1,0x1129,0x1129,0x1129}, {1,0x112A,0x112A,0x112A}, {1,0x112B,0x112B,0x112B},
 {1,0x112C,0x112C,0x112C}, {1,0x112D,0x112D,0x112D}, {1,0x112E,0x112E,0x112E}, {1,0x112F,0x112F,0x112F},
 {1,0x1130,0x1130,0x1130}, {1,0x1131,0x1131,0x1131}, {1,0x1132,0x1132,0x1132}, {1,0x1133,0x1133,0x1133},
 {1,0x1134,0x1134,0x1134}, {1,0x1135,0x1135,0x1135}, {1,0x1136,0x1136,0x1136}, {1,0x1137,0x1137,0x1137},
 {1,0x1138,0x1138,0x1138}, {1,0x1139,0x1139,0x1139}, {1,0x113A,0x113A,0x113A}, {1,0x113B,0x113B,0x113B},
 {1,0x113C,0x113C,0x113C}, {1,0x113D,0x113D,0x113D}, {1,0x113E,0x113E,0x113E}, {1,0x113F,0x113F,0x113F},
 {1,0x1140,0x1140,0x1140}, {1,0x1141,0x1141,0x1141}, {1,0x1142,0x1142,0x1142}, {1,0x1143,0x1143,0x1143},
 {1,0x1144,0x1144,0x1144}, {1,0x1145,0x1145,0x1145}, {1,0x1146,0x1146,0x1146}, {1,0x1147,0x1147,0x1147},
 {1,0x1148,0x1148,0x1148}, {1,0x1149,0x1149,0x1149}, {1,0x114A,0x114A,0x114A}, {1,0x114B,0x114B,0x114B},
 {1,0x114C,0x114C,0x114C}, {1,0x114D,0x114D,0x114D}, {1,0x114E,0x114E,0x114E}, {1,0x114F,0x114F,0x114F},
 {1,0x1150,0x1150,0x1150}, {1,0x1151,0x1151,0x1151}, {1,0x1152,0x1152,0x1152}, {1,0x1153,0x1153,0x1153},
 {1,0x1154,0x1154,0x1154}, {1,0x1155,0x1155,0x1155}, {1,0x1156,0x1156,0x1156}, {1,0x1157,0x1157,0x1157},
 {1,0x1158,0x1158,0x1158}, {1,0x1159,0x1159,0x1159}, {0,0x115A,0x115A,0x115A}, {0,0x115B,0x115B,0x115B},
 {0,0x115C,0x115C,0x115C}, {0,0x115D,0x115D,0x115D}, {0,0x115E,0x115E,0x115E}, {1,0x115F,0x115F,0x115F},
 {1,0x1160,0x1160,0x1160}, {1,0x1161,0x1161,0x1161}, {1,0x1162,0x1162,0x1162}, {1,0x1163,0x1163,0x1163},
 {1,0x1164,0x1164,0x1164}, {1,0x1165,0x1165,0x1165}, {1,0x1166,0x1166,0x1166}, {1,0x1167,0x1167,0x1167},
 {1,0x1168,0x1168,0x1168}, {1,0x1169,0x1169,0x1169}, {1,0x116A,0x116A,0x116A}, {1,0x116B,0x116B,0x116B},
 {1,0x116C,0x116C,0x116C}, {1,0x116D,0x116D,0x116D}, {1,0x116E,0x116E,0x116E}, {1,0x116F,0x116F,0x116F},
 {1,0x1170,0x1170,0x1170}, {1,0x1171,0x1171,0x1171}, {1,0x1172,0x1172,0x1172}, {1,0x1173,0x1173,0x1173},
 {1,0x1174,0x1174,0x1174}, {1,0x1175,0x1175,0x1175}, {1,0x1176,0x1176,0x1176}, {1,0x1177,0x1177,0x1177},
 {1,0x1178,0x1178,0x1178}, {1,0x1179,0x1179,0x1179}, {1,0x117A,0x117A,0x117A}, {1,0x117B,0x117B,0x117B},
 {1,0x117C,0x117C,0x117C}, {1,0x117D,0x117D,0x117D}, {1,0x117E,0x117E,0x117E}, {1,0x117F,0x117F,0x117F},
 {1,0x1180,0x1180,0x1180}, {1,0x1181,0x1181,0x1181}, {1,0x1182,0x1182,0x1182}, {1,0x1183,0x1183,0x1183},
 {1,0x1184,0x1184,0x1184}, {1,0x1185,0x1185,0x1185}, {1,0x1186,0x1186,0x1186}, {1,0x1187,0x1187,0x1187},
 {1,0x1188,0x1188,0x1188}, {1,0x1189,0x1189,0x1189}, {1,0x118A,0x118A,0x118A}, {1,0x118B,0x118B,0x118B},
 {1,0x118C,0x118C,0x118C}, {1,0x118D,0x118D,0x118D}, {1,0x118E,0x118E,0x118E}, {1,0x118F,0x118F,0x118F},
 {1,0x1190,0x1190,0x1190}, {1,0x1191,0x1191,0x1191}, {1,0x1192,0x1192,0x1192}, {1,0x1193,0x1193,0x1193},
 {1,0x1194,0x1194,0x1194}, {1,0x1195,0x1195,0x1195}, {1,0x1196,0x1196,0x1196}, {1,0x1197,0x1197,0x1197},
 {1,0x1198,0x1198,0x1198}, {1,0x1199,0x1199,0x1199}, {1,0x119A,0x119A,0x119A}, {1,0x119B,0x119B,0x119B},
 {1,0x119C,0x119C,0x119C}, {1,0x119D,0x119D,0x119D}, {1,0x119E,0x119E,0x119E}, {1,0x119F,0x119F,0x119F},
 {1,0x11A0,0x11A0,0x11A0}, {1,0x11A1,0x11A1,0x11A1}, {1,0x11A2,0x11A2,0x11A2}, {0,0x11A3,0x11A3,0x11A3},
 {0,0x11A4,0x11A4,0x11A4}, {0,0x11A5,0x11A5,0x11A5}, {0,0x11A6,0x11A6,0x11A6}, {0,0x11A7,0x11A7,0x11A7},
 {1,0x11A8,0x11A8,0x11A8}, {1,0x11A9,0x11A9,0x11A9}, {1,0x11AA,0x11AA,0x11AA}, {1,0x11AB,0x11AB,0x11AB},
 {1,0x11AC,0x11AC,0x11AC}, {1,0x11AD,0x11AD,0x11AD}, {1,0x11AE,0x11AE,0x11AE}, {1,0x11AF,0x11AF,0x11AF},
 {1,0x11B0,0x11B0,0x11B0}, {1,0x11B1,0x11B1,0x11B1}, {1,0x11B2,0x11B2,0x11B2}, {1,0x11B3,0x11B3,0x11B3},
 {1,0x11B4,0x11B4,0x11B4}, {1,0x11B5,0x11B5,0x11B5}, {1,0x11B6,0x11B6,0x11B6}, {1,0x11B7,0x11B7,0x11B7},
 {1,0x11B8,0x11B8,0x11B8}, {1,0x11B9,0x11B9,0x11B9}, {1,0x11BA,0x11BA,0x11BA}, {1,0x11BB,0x11BB,0x11BB},
 {1,0x11BC,0x11BC,0x11BC}, {1,0x11BD,0x11BD,0x11BD}, {1,0x11BE,0x11BE,0x11BE}, {1,0x11BF,0x11BF,0x11BF},
 {1,0x11C0,0x11C0,0x11C0}, {1,0x11C1,0x11C1,0x11C1}, {1,0x11C2,0x11C2,0x11C2}, {1,0x11C3,0x11C3,0x11C3},
 {1,0x11C4,0x11C4,0x11C4}, {1,0x11C5,0x11C5,0x11C5}, {1,0x11C6,0x11C6,0x11C6}, {1,0x11C7,0x11C7,0x11C7},
 {1,0x11C8,0x11C8,0x11C8}, {1,0x11C9,0x11C9,0x11C9}, {1,0x11CA,0x11CA,0x11CA}, {1,0x11CB,0x11CB,0x11CB},
 {1,0x11CC,0x11CC,0x11CC}, {1,0x11CD,0x11CD,0x11CD}, {1,0x11CE,0x11CE,0x11CE}, {1,0x11CF,0x11CF,0x11CF},
 {1,0x11D0,0x11D0,0x11D0}, {1,0x11D1,0x11D1,0x11D1}, {1,0x11D2,0x11D2,0x11D2}, {1,0x11D3,0x11D3,0x11D3},
 {1,0x11D4,0x11D4,0x11D4}, {1,0x11D5,0x11D5,0x11D5}, {1,0x11D6,0x11D6,0x11D6}, {1,0x11D7,0x11D7,0x11D7},
 {1,0x11D8,0x11D8,0x11D8}, {1,0x11D9,0x11D9,0x11D9}, {1,0x11DA,0x11DA,0x11DA}, {1,0x11DB,0x11DB,0x11DB},
 {1,0x11DC,0x11DC,0x11DC}, {1,0x11DD,0x11DD,0x11DD}, {1,0x11DE,0x11DE,0x11DE}, {1,0x11DF,0x11DF,0x11DF},
 {1,0x11E0,0x11E0,0x11E0}, {1,0x11E1,0x11E1,0x11E1}, {1,0x11E2,0x11E2,0x11E2}, {1,0x11E3,0x11E3,0x11E3},
 {1,0x11E4,0x11E4,0x11E4}, {1,0x11E5,0x11E5,0x11E5}, {1,0x11E6,0x11E6,0x11E6}, {1,0x11E7,0x11E7,0x11E7},
 {1,0x11E8,0x11E8,0x11E8}, {1,0x11E9,0x11E9,0x11E9}, {1,0x11EA,0x11EA,0x11EA}, {1,0x11EB,0x11EB,0x11EB},
 {1,0x11EC,0x11EC,0x11EC}, {1,0x11ED,0x11ED,0x11ED}, {1,0x11EE,0x11EE,0x11EE}, {1,0x11EF,0x11EF,0x11EF},
 {1,0x11F0,0x11F0,0x11F0}, {1,0x11F1,0x11F1,0x11F1}, {1,0x11F2,0x11F2,0x11F2}, {1,0x11F3,0x11F3,0x11F3},
 {1,0x11F4,0x11F4,0x11F4}, {1,0x11F5,0x11F5,0x11F5}, {1,0x11F6,0x11F6,0x11F6}, {1,0x11F7,0x11F7,0x11F7},
 {1,0x11F8,0x11F8,0x11F8}, {1,0x11F9,0x11F9,0x11F9}, {0,0x11FA,0x11FA,0x11FA}, {0,0x11FB,0x11FB,0x11FB},
 {0,0x11FC,0x11FC,0x11FC}, {0,0x11FD,0x11FD,0x11FD}, {0,0x11FE,0x11FE,0x11FE}, {0,0x11FF,0x11FF,0x11FF},
{0,0}};

static UDM_UNICODE plane12[257]={
 {1,0x1200,0x1200,0x1200}, {1,0x1201,0x1201,0x1201}, {1,0x1202,0x1202,0x1202}, {1,0x1203,0x1203,0x1203},
 {1,0x1204,0x1204,0x1204}, {1,0x1205,0x1205,0x1205}, {1,0x1206,0x1206,0x1206}, {0,0x1207,0x1207,0x1207},
 {1,0x1208,0x1208,0x1208}, {1,0x1209,0x1209,0x1209}, {1,0x120A,0x120A,0x120A}, {1,0x120B,0x120B,0x120B},
 {1,0x120C,0x120C,0x120C}, {1,0x120D,0x120D,0x120D}, {1,0x120E,0x120E,0x120E}, {1,0x120F,0x120F,0x120F},
 {1,0x1210,0x1210,0x1210}, {1,0x1211,0x1211,0x1211}, {1,0x1212,0x1212,0x1212}, {1,0x1213,0x1213,0x1213},
 {1,0x1214,0x1214,0x1214}, {1,0x1215,0x1215,0x1215}, {1,0x1216,0x1216,0x1216}, {1,0x1217,0x1217,0x1217},
 {1,0x1218,0x1218,0x1218}, {1,0x1219,0x1219,0x1219}, {1,0x121A,0x121A,0x121A}, {1,0x121B,0x121B,0x121B},
 {1,0x121C,0x121C,0x121C}, {1,0x121D,0x121D,0x121D}, {1,0x121E,0x121E,0x121E}, {1,0x121F,0x121F,0x121F},
 {1,0x1220,0x1220,0x1220}, {1,0x1221,0x1221,0x1221}, {1,0x1222,0x1222,0x1222}, {1,0x1223,0x1223,0x1223},
 {1,0x1224,0x1224,0x1224}, {1,0x1225,0x1225,0x1225}, {1,0x1226,0x1226,0x1226}, {1,0x1227,0x1227,0x1227},
 {1,0x1228,0x1228,0x1228}, {1,0x1229,0x1229,0x1229}, {1,0x122A,0x122A,0x122A}, {1,0x122B,0x122B,0x122B},
 {1,0x122C,0x122C,0x122C}, {1,0x122D,0x122D,0x122D}, {1,0x122E,0x122E,0x122E}, {1,0x122F,0x122F,0x122F},
 {1,0x1230,0x1230,0x1230}, {1,0x1231,0x1231,0x1231}, {1,0x1232,0x1232,0x1232}, {1,0x1233,0x1233,0x1233},
 {1,0x1234,0x1234,0x1234}, {1,0x1235,0x1235,0x1235}, {1,0x1236,0x1236,0x1236}, {1,0x1237,0x1237,0x1237},
 {1,0x1238,0x1238,0x1238}, {1,0x1239,0x1239,0x1239}, {1,0x123A,0x123A,0x123A}, {1,0x123B,0x123B,0x123B},
 {1,0x123C,0x123C,0x123C}, {1,0x123D,0x123D,0x123D}, {1,0x123E,0x123E,0x123E}, {1,0x123F,0x123F,0x123F},
 {1,0x1240,0x1240,0x1240}, {1,0x1241,0x1241,0x1241}, {1,0x1242,0x1242,0x1242}, {1,0x1243,0x1243,0x1243},
 {1,0x1244,0x1244,0x1244}, {1,0x1245,0x1245,0x1245}, {1,0x1246,0x1246,0x1246}, {0,0x1247,0x1247,0x1247},
 {1,0x1248,0x1248,0x1248}, {0,0x1249,0x1249,0x1249}, {1,0x124A,0x124A,0x124A}, {1,0x124B,0x124B,0x124B},
 {1,0x124C,0x124C,0x124C}, {1,0x124D,0x124D,0x124D}, {0,0x124E,0x124E,0x124E}, {0,0x124F,0x124F,0x124F},
 {1,0x1250,0x1250,0x1250}, {1,0x1251,0x1251,0x1251}, {1,0x1252,0x1252,0x1252}, {1,0x1253,0x1253,0x1253},
 {1,0x1254,0x1254,0x1254}, {1,0x1255,0x1255,0x1255}, {1,0x1256,0x1256,0x1256}, {0,0x1257,0x1257,0x1257},
 {1,0x1258,0x1258,0x1258}, {0,0x1259,0x1259,0x1259}, {1,0x125A,0x125A,0x125A}, {1,0x125B,0x125B,0x125B},
 {1,0x125C,0x125C,0x125C}, {1,0x125D,0x125D,0x125D}, {0,0x125E,0x125E,0x125E}, {0,0x125F,0x125F,0x125F},
 {1,0x1260,0x1260,0x1260}, {1,0x1261,0x1261,0x1261}, {1,0x1262,0x1262,0x1262}, {1,0x1263,0x1263,0x1263},
 {1,0x1264,0x1264,0x1264}, {1,0x1265,0x1265,0x1265}, {1,0x1266,0x1266,0x1266}, {1,0x1267,0x1267,0x1267},
 {1,0x1268,0x1268,0x1268}, {1,0x1269,0x1269,0x1269}, {1,0x126A,0x126A,0x126A}, {1,0x126B,0x126B,0x126B},
 {1,0x126C,0x126C,0x126C}, {1,0x126D,0x126D,0x126D}, {1,0x126E,0x126E,0x126E}, {1,0x126F,0x126F,0x126F},
 {1,0x1270,0x1270,0x1270}, {1,0x1271,0x1271,0x1271}, {1,0x1272,0x1272,0x1272}, {1,0x1273,0x1273,0x1273},
 {1,0x1274,0x1274,0x1274}, {1,0x1275,0x1275,0x1275}, {1,0x1276,0x1276,0x1276}, {1,0x1277,0x1277,0x1277},
 {1,0x1278,0x1278,0x1278}, {1,0x1279,0x1279,0x1279}, {1,0x127A,0x127A,0x127A}, {1,0x127B,0x127B,0x127B},
 {1,0x127C,0x127C,0x127C}, {1,0x127D,0x127D,0x127D}, {1,0x127E,0x127E,0x127E}, {1,0x127F,0x127F,0x127F},
 {1,0x1280,0x1280,0x1280}, {1,0x1281,0x1281,0x1281}, {1,0x1282,0x1282,0x1282}, {1,0x1283,0x1283,0x1283},
 {1,0x1284,0x1284,0x1284}, {1,0x1285,0x1285,0x1285}, {1,0x1286,0x1286,0x1286}, {0,0x1287,0x1287,0x1287},
 {1,0x1288,0x1288,0x1288}, {0,0x1289,0x1289,0x1289}, {1,0x128A,0x128A,0x128A}, {1,0x128B,0x128B,0x128B},
 {1,0x128C,0x128C,0x128C}, {1,0x128D,0x128D,0x128D}, {0,0x128E,0x128E,0x128E}, {0,0x128F,0x128F,0x128F},
 {1,0x1290,0x1290,0x1290}, {1,0x1291,0x1291,0x1291}, {1,0x1292,0x1292,0x1292}, {1,0x1293,0x1293,0x1293},
 {1,0x1294,0x1294,0x1294}, {1,0x1295,0x1295,0x1295}, {1,0x1296,0x1296,0x1296}, {1,0x1297,0x1297,0x1297},
 {1,0x1298,0x1298,0x1298}, {1,0x1299,0x1299,0x1299}, {1,0x129A,0x129A,0x129A}, {1,0x129B,0x129B,0x129B},
 {1,0x129C,0x129C,0x129C}, {1,0x129D,0x129D,0x129D}, {1,0x129E,0x129E,0x129E}, {1,0x129F,0x129F,0x129F},
 {1,0x12A0,0x12A0,0x12A0}, {1,0x12A1,0x12A1,0x12A1}, {1,0x12A2,0x12A2,0x12A2}, {1,0x12A3,0x12A3,0x12A3},
 {1,0x12A4,0x12A4,0x12A4}, {1,0x12A5,0x12A5,0x12A5}, {1,0x12A6,0x12A6,0x12A6}, {1,0x12A7,0x12A7,0x12A7},
 {1,0x12A8,0x12A8,0x12A8}, {1,0x12A9,0x12A9,0x12A9}, {1,0x12AA,0x12AA,0x12AA}, {1,0x12AB,0x12AB,0x12AB},
 {1,0x12AC,0x12AC,0x12AC}, {1,0x12AD,0x12AD,0x12AD}, {1,0x12AE,0x12AE,0x12AE}, {0,0x12AF,0x12AF,0x12AF},
 {1,0x12B0,0x12B0,0x12B0}, {0,0x12B1,0x12B1,0x12B1}, {1,0x12B2,0x12B2,0x12B2}, {1,0x12B3,0x12B3,0x12B3},
 {1,0x12B4,0x12B4,0x12B4}, {1,0x12B5,0x12B5,0x12B5}, {0,0x12B6,0x12B6,0x12B6}, {0,0x12B7,0x12B7,0x12B7},
 {1,0x12B8,0x12B8,0x12B8}, {1,0x12B9,0x12B9,0x12B9}, {1,0x12BA,0x12BA,0x12BA}, {1,0x12BB,0x12BB,0x12BB},
 {1,0x12BC,0x12BC,0x12BC}, {1,0x12BD,0x12BD,0x12BD}, {1,0x12BE,0x12BE,0x12BE}, {0,0x12BF,0x12BF,0x12BF},
 {1,0x12C0,0x12C0,0x12C0}, {0,0x12C1,0x12C1,0x12C1}, {1,0x12C2,0x12C2,0x12C2}, {1,0x12C3,0x12C3,0x12C3},
 {1,0x12C4,0x12C4,0x12C4}, {1,0x12C5,0x12C5,0x12C5}, {0,0x12C6,0x12C6,0x12C6}, {0,0x12C7,0x12C7,0x12C7},
 {1,0x12C8,0x12C8,0x12C8}, {1,0x12C9,0x12C9,0x12C9}, {1,0x12CA,0x12CA,0x12CA}, {1,0x12CB,0x12CB,0x12CB},
 {1,0x12CC,0x12CC,0x12CC}, {1,0x12CD,0x12CD,0x12CD}, {1,0x12CE,0x12CE,0x12CE}, {0,0x12CF,0x12CF,0x12CF},
 {1,0x12D0,0x12D0,0x12D0}, {1,0x12D1,0x12D1,0x12D1}, {1,0x12D2,0x12D2,0x12D2}, {1,0x12D3,0x12D3,0x12D3},
 {1,0x12D4,0x12D4,0x12D4}, {1,0x12D5,0x12D5,0x12D5}, {1,0x12D6,0x12D6,0x12D6}, {0,0x12D7,0x12D7,0x12D7},
 {1,0x12D8,0x12D8,0x12D8}, {1,0x12D9,0x12D9,0x12D9}, {1,0x12DA,0x12DA,0x12DA}, {1,0x12DB,0x12DB,0x12DB},
 {1,0x12DC,0x12DC,0x12DC}, {1,0x12DD,0x12DD,0x12DD}, {1,0x12DE,0x12DE,0x12DE}, {1,0x12DF,0x12DF,0x12DF},
 {1,0x12E0,0x12E0,0x12E0}, {1,0x12E1,0x12E1,0x12E1}, {1,0x12E2,0x12E2,0x12E2}, {1,0x12E3,0x12E3,0x12E3},
 {1,0x12E4,0x12E4,0x12E4}, {1,0x12E5,0x12E5,0x12E5}, {1,0x12E6,0x12E6,0x12E6}, {1,0x12E7,0x12E7,0x12E7},
 {1,0x12E8,0x12E8,0x12E8}, {1,0x12E9,0x12E9,0x12E9}, {1,0x12EA,0x12EA,0x12EA}, {1,0x12EB,0x12EB,0x12EB},
 {1,0x12EC,0x12EC,0x12EC}, {1,0x12ED,0x12ED,0x12ED}, {1,0x12EE,0x12EE,0x12EE}, {0,0x12EF,0x12EF,0x12EF},
 {1,0x12F0,0x12F0,0x12F0}, {1,0x12F1,0x12F1,0x12F1}, {1,0x12F2,0x12F2,0x12F2}, {1,0x12F3,0x12F3,0x12F3},
 {1,0x12F4,0x12F4,0x12F4}, {1,0x12F5,0x12F5,0x12F5}, {1,0x12F6,0x12F6,0x12F6}, {1,0x12F7,0x12F7,0x12F7},
 {1,0x12F8,0x12F8,0x12F8}, {1,0x12F9,0x12F9,0x12F9}, {1,0x12FA,0x12FA,0x12FA}, {1,0x12FB,0x12FB,0x12FB},
 {1,0x12FC,0x12FC,0x12FC}, {1,0x12FD,0x12FD,0x12FD}, {1,0x12FE,0x12FE,0x12FE}, {1,0x12FF,0x12FF,0x12FF},
{0,0}};

static UDM_UNICODE plane13[257]={
 {1,0x1300,0x1300,0x1300}, {1,0x1301,0x1301,0x1301}, {1,0x1302,0x1302,0x1302}, {1,0x1303,0x1303,0x1303},
 {1,0x1304,0x1304,0x1304}, {1,0x1305,0x1305,0x1305}, {1,0x1306,0x1306,0x1306}, {1,0x1307,0x1307,0x1307},
 {1,0x1308,0x1308,0x1308}, {1,0x1309,0x1309,0x1309}, {1,0x130A,0x130A,0x130A}, {1,0x130B,0x130B,0x130B},
 {1,0x130C,0x130C,0x130C}, {1,0x130D,0x130D,0x130D}, {1,0x130E,0x130E,0x130E}, {0,0x130F,0x130F,0x130F},
 {1,0x1310,0x1310,0x1310}, {0,0x1311,0x1311,0x1311}, {1,0x1312,0x1312,0x1312}, {1,0x1313,0x1313,0x1313},
 {1,0x1314,0x1314,0x1314}, {1,0x1315,0x1315,0x1315}, {0,0x1316,0x1316,0x1316}, {0,0x1317,0x1317,0x1317},
 {1,0x1318,0x1318,0x1318}, {1,0x1319,0x1319,0x1319}, {1,0x131A,0x131A,0x131A}, {1,0x131B,0x131B,0x131B},
 {1,0x131C,0x131C,0x131C}, {1,0x131D,0x131D,0x131D}, {1,0x131E,0x131E,0x131E}, {0,0x131F,0x131F,0x131F},
 {1,0x1320,0x1320,0x1320}, {1,0x1321,0x1321,0x1321}, {1,0x1322,0x1322,0x1322}, {1,0x1323,0x1323,0x1323},
 {1,0x1324,0x1324,0x1324}, {1,0x1325,0x1325,0x1325}, {1,0x1326,0x1326,0x1326}, {1,0x1327,0x1327,0x1327},
 {1,0x1328,0x1328,0x1328}, {1,0x1329,0x1329,0x1329}, {1,0x132A,0x132A,0x132A}, {1,0x132B,0x132B,0x132B},
 {1,0x132C,0x132C,0x132C}, {1,0x132D,0x132D,0x132D}, {1,0x132E,0x132E,0x132E}, {1,0x132F,0x132F,0x132F},
 {1,0x1330,0x1330,0x1330}, {1,0x1331,0x1331,0x1331}, {1,0x1332,0x1332,0x1332}, {1,0x1333,0x1333,0x1333},
 {1,0x1334,0x1334,0x1334}, {1,0x1335,0x1335,0x1335}, {1,0x1336,0x1336,0x1336}, {1,0x1337,0x1337,0x1337},
 {1,0x1338,0x1338,0x1338}, {1,0x1339,0x1339,0x1339}, {1,0x133A,0x133A,0x133A}, {1,0x133B,0x133B,0x133B},
 {1,0x133C,0x133C,0x133C}, {1,0x133D,0x133D,0x133D}, {1,0x133E,0x133E,0x133E}, {1,0x133F,0x133F,0x133F},
 {1,0x1340,0x1340,0x1340}, {1,0x1341,0x1341,0x1341}, {1,0x1342,0x1342,0x1342}, {1,0x1343,0x1343,0x1343},
 {1,0x1344,0x1344,0x1344}, {1,0x1345,0x1345,0x1345}, {1,0x1346,0x1346,0x1346}, {0,0x1347,0x1347,0x1347},
 {1,0x1348,0x1348,0x1348}, {1,0x1349,0x1349,0x1349}, {1,0x134A,0x134A,0x134A}, {1,0x134B,0x134B,0x134B},
 {1,0x134C,0x134C,0x134C}, {1,0x134D,0x134D,0x134D}, {1,0x134E,0x134E,0x134E}, {1,0x134F,0x134F,0x134F},
 {1,0x1350,0x1350,0x1350}, {1,0x1351,0x1351,0x1351}, {1,0x1352,0x1352,0x1352}, {1,0x1353,0x1353,0x1353},
 {1,0x1354,0x1354,0x1354}, {1,0x1355,0x1355,0x1355}, {1,0x1356,0x1356,0x1356}, {1,0x1357,0x1357,0x1357},
 {1,0x1358,0x1358,0x1358}, {1,0x1359,0x1359,0x1359}, {1,0x135A,0x135A,0x135A}, {0,0x135B,0x135B,0x135B},
 {0,0x135C,0x135C,0x135C}, {0,0x135D,0x135D,0x135D}, {0,0x135E,0x135E,0x135E}, {0,0x135F,0x135F,0x135F},
 {0,0x1360,0x1360,0x1360}, {0,0x1361,0x1361,0x1361}, {0,0x1362,0x1362,0x1362}, {0,0x1363,0x1363,0x1363},
 {0,0x1364,0x1364,0x1364}, {0,0x1365,0x1365,0x1365}, {0,0x1366,0x1366,0x1366}, {0,0x1367,0x1367,0x1367},
 {0,0x1368,0x1368,0x1368}, {2,0x1369,0x1369,0x1369}, {2,0x136A,0x136A,0x136A}, {2,0x136B,0x136B,0x136B},
 {2,0x136C,0x136C,0x136C}, {2,0x136D,0x136D,0x136D}, {2,0x136E,0x136E,0x136E}, {2,0x136F,0x136F,0x136F},
 {2,0x1370,0x1370,0x1370}, {2,0x1371,0x1371,0x1371}, {0,0x1372,0x1372,0x1372}, {0,0x1373,0x1373,0x1373},
 {0,0x1374,0x1374,0x1374}, {0,0x1375,0x1375,0x1375}, {0,0x1376,0x1376,0x1376}, {0,0x1377,0x1377,0x1377},
 {0,0x1378,0x1378,0x1378}, {0,0x1379,0x1379,0x1379}, {0,0x137A,0x137A,0x137A}, {0,0x137B,0x137B,0x137B},
 {0,0x137C,0x137C,0x137C}, {0,0x137D,0x137D,0x137D}, {0,0x137E,0x137E,0x137E}, {0,0x137F,0x137F,0x137F},
 {0,0x1380,0x1380,0x1380}, {0,0x1381,0x1381,0x1381}, {0,0x1382,0x1382,0x1382}, {0,0x1383,0x1383,0x1383},
 {0,0x1384,0x1384,0x1384}, {0,0x1385,0x1385,0x1385}, {0,0x1386,0x1386,0x1386}, {0,0x1387,0x1387,0x1387},
 {0,0x1388,0x1388,0x1388}, {0,0x1389,0x1389,0x1389}, {0,0x138A,0x138A,0x138A}, {0,0x138B,0x138B,0x138B},
 {0,0x138C,0x138C,0x138C}, {0,0x138D,0x138D,0x138D}, {0,0x138E,0x138E,0x138E}, {0,0x138F,0x138F,0x138F},
 {0,0x1390,0x1390,0x1390}, {0,0x1391,0x1391,0x1391}, {0,0x1392,0x1392,0x1392}, {0,0x1393,0x1393,0x1393},
 {0,0x1394,0x1394,0x1394}, {0,0x1395,0x1395,0x1395}, {0,0x1396,0x1396,0x1396}, {0,0x1397,0x1397,0x1397},
 {0,0x1398,0x1398,0x1398}, {0,0x1399,0x1399,0x1399}, {0,0x139A,0x139A,0x139A}, {0,0x139B,0x139B,0x139B},
 {0,0x139C,0x139C,0x139C}, {0,0x139D,0x139D,0x139D}, {0,0x139E,0x139E,0x139E}, {0,0x139F,0x139F,0x139F},
 {1,0x13A0,0x13A0,0x13A0}, {1,0x13A1,0x13A1,0x13A1}, {1,0x13A2,0x13A2,0x13A2}, {1,0x13A3,0x13A3,0x13A3},
 {1,0x13A4,0x13A4,0x13A4}, {1,0x13A5,0x13A5,0x13A5}, {1,0x13A6,0x13A6,0x13A6}, {1,0x13A7,0x13A7,0x13A7},
 {1,0x13A8,0x13A8,0x13A8}, {1,0x13A9,0x13A9,0x13A9}, {1,0x13AA,0x13AA,0x13AA}, {1,0x13AB,0x13AB,0x13AB},
 {1,0x13AC,0x13AC,0x13AC}, {1,0x13AD,0x13AD,0x13AD}, {1,0x13AE,0x13AE,0x13AE}, {1,0x13AF,0x13AF,0x13AF},
 {1,0x13B0,0x13B0,0x13B0}, {1,0x13B1,0x13B1,0x13B1}, {1,0x13B2,0x13B2,0x13B2}, {1,0x13B3,0x13B3,0x13B3},
 {1,0x13B4,0x13B4,0x13B4}, {1,0x13B5,0x13B5,0x13B5}, {1,0x13B6,0x13B6,0x13B6}, {1,0x13B7,0x13B7,0x13B7},
 {1,0x13B8,0x13B8,0x13B8}, {1,0x13B9,0x13B9,0x13B9}, {1,0x13BA,0x13BA,0x13BA}, {1,0x13BB,0x13BB,0x13BB},
 {1,0x13BC,0x13BC,0x13BC}, {1,0x13BD,0x13BD,0x13BD}, {1,0x13BE,0x13BE,0x13BE}, {1,0x13BF,0x13BF,0x13BF},
 {1,0x13C0,0x13C0,0x13C0}, {1,0x13C1,0x13C1,0x13C1}, {1,0x13C2,0x13C2,0x13C2}, {1,0x13C3,0x13C3,0x13C3},
 {1,0x13C4,0x13C4,0x13C4}, {1,0x13C5,0x13C5,0x13C5}, {1,0x13C6,0x13C6,0x13C6}, {1,0x13C7,0x13C7,0x13C7},
 {1,0x13C8,0x13C8,0x13C8}, {1,0x13C9,0x13C9,0x13C9}, {1,0x13CA,0x13CA,0x13CA}, {1,0x13CB,0x13CB,0x13CB},
 {1,0x13CC,0x13CC,0x13CC}, {1,0x13CD,0x13CD,0x13CD}, {1,0x13CE,0x13CE,0x13CE}, {1,0x13CF,0x13CF,0x13CF},
 {1,0x13D0,0x13D0,0x13D0}, {1,0x13D1,0x13D1,0x13D1}, {1,0x13D2,0x13D2,0x13D2}, {1,0x13D3,0x13D3,0x13D3},
 {1,0x13D4,0x13D4,0x13D4}, {1,0x13D5,0x13D5,0x13D5}, {1,0x13D6,0x13D6,0x13D6}, {1,0x13D7,0x13D7,0x13D7},
 {1,0x13D8,0x13D8,0x13D8}, {1,0x13D9,0x13D9,0x13D9}, {1,0x13DA,0x13DA,0x13DA}, {1,0x13DB,0x13DB,0x13DB},
 {1,0x13DC,0x13DC,0x13DC}, {1,0x13DD,0x13DD,0x13DD}, {1,0x13DE,0x13DE,0x13DE}, {1,0x13DF,0x13DF,0x13DF},
 {1,0x13E0,0x13E0,0x13E0}, {1,0x13E1,0x13E1,0x13E1}, {1,0x13E2,0x13E2,0x13E2}, {1,0x13E3,0x13E3,0x13E3},
 {1,0x13E4,0x13E4,0x13E4}, {1,0x13E5,0x13E5,0x13E5}, {1,0x13E6,0x13E6,0x13E6}, {1,0x13E7,0x13E7,0x13E7},
 {1,0x13E8,0x13E8,0x13E8}, {1,0x13E9,0x13E9,0x13E9}, {1,0x13EA,0x13EA,0x13EA}, {1,0x13EB,0x13EB,0x13EB},
 {1,0x13EC,0x13EC,0x13EC}, {1,0x13ED,0x13ED,0x13ED}, {1,0x13EE,0x13EE,0x13EE}, {1,0x13EF,0x13EF,0x13EF},
 {1,0x13F0,0x13F0,0x13F0}, {1,0x13F1,0x13F1,0x13F1}, {1,0x13F2,0x13F2,0x13F2}, {1,0x13F3,0x13F3,0x13F3},
 {1,0x13F4,0x13F4,0x13F4}, {0,0x13F5,0x13F5,0x13F5}, {0,0x13F6,0x13F6,0x13F6}, {0,0x13F7,0x13F7,0x13F7},
 {0,0x13F8,0x13F8,0x13F8}, {0,0x13F9,0x13F9,0x13F9}, {0,0x13FA,0x13FA,0x13FA}, {0,0x13FB,0x13FB,0x13FB},
 {0,0x13FC,0x13FC,0x13FC}, {0,0x13FD,0x13FD,0x13FD}, {0,0x13FE,0x13FE,0x13FE}, {0,0x13FF,0x13FF,0x13FF},
{0,0}};

static UDM_UNICODE plane14[257]={
 {0,0x1400,0x1400,0x1400}, {1,0x1401,0x1401,0x1401}, {1,0x1402,0x1402,0x1402}, {1,0x1403,0x1403,0x1403},
 {1,0x1404,0x1404,0x1404}, {1,0x1405,0x1405,0x1405}, {1,0x1406,0x1406,0x1406}, {1,0x1407,0x1407,0x1407},
 {1,0x1408,0x1408,0x1408}, {1,0x1409,0x1409,0x1409}, {1,0x140A,0x140A,0x140A}, {1,0x140B,0x140B,0x140B},
 {1,0x140C,0x140C,0x140C}, {1,0x140D,0x140D,0x140D}, {1,0x140E,0x140E,0x140E}, {1,0x140F,0x140F,0x140F},
 {1,0x1410,0x1410,0x1410}, {1,0x1411,0x1411,0x1411}, {1,0x1412,0x1412,0x1412}, {1,0x1413,0x1413,0x1413},
 {1,0x1414,0x1414,0x1414}, {1,0x1415,0x1415,0x1415}, {1,0x1416,0x1416,0x1416}, {1,0x1417,0x1417,0x1417},
 {1,0x1418,0x1418,0x1418}, {1,0x1419,0x1419,0x1419}, {1,0x141A,0x141A,0x141A}, {1,0x141B,0x141B,0x141B},
 {1,0x141C,0x141C,0x141C}, {1,0x141D,0x141D,0x141D}, {1,0x141E,0x141E,0x141E}, {1,0x141F,0x141F,0x141F},
 {1,0x1420,0x1420,0x1420}, {1,0x1421,0x1421,0x1421}, {1,0x1422,0x1422,0x1422}, {1,0x1423,0x1423,0x1423},
 {1,0x1424,0x1424,0x1424}, {1,0x1425,0x1425,0x1425}, {1,0x1426,0x1426,0x1426}, {1,0x1427,0x1427,0x1427},
 {1,0x1428,0x1428,0x1428}, {1,0x1429,0x1429,0x1429}, {1,0x142A,0x142A,0x142A}, {1,0x142B,0x142B,0x142B},
 {1,0x142C,0x142C,0x142C}, {1,0x142D,0x142D,0x142D}, {1,0x142E,0x142E,0x142E}, {1,0x142F,0x142F,0x142F},
 {1,0x1430,0x1430,0x1430}, {1,0x1431,0x1431,0x1431}, {1,0x1432,0x1432,0x1432}, {1,0x1433,0x1433,0x1433},
 {1,0x1434,0x1434,0x1434}, {1,0x1435,0x1435,0x1435}, {1,0x1436,0x1436,0x1436}, {1,0x1437,0x1437,0x1437},
 {1,0x1438,0x1438,0x1438}, {1,0x1439,0x1439,0x1439}, {1,0x143A,0x143A,0x143A}, {1,0x143B,0x143B,0x143B},
 {1,0x143C,0x143C,0x143C}, {1,0x143D,0x143D,0x143D}, {1,0x143E,0x143E,0x143E}, {1,0x143F,0x143F,0x143F},
 {1,0x1440,0x1440,0x1440}, {1,0x1441,0x1441,0x1441}, {1,0x1442,0x1442,0x1442}, {1,0x1443,0x1443,0x1443},
 {1,0x1444,0x1444,0x1444}, {1,0x1445,0x1445,0x1445}, {1,0x1446,0x1446,0x1446}, {1,0x1447,0x1447,0x1447},
 {1,0x1448,0x1448,0x1448}, {1,0x1449,0x1449,0x1449}, {1,0x144A,0x144A,0x144A}, {1,0x144B,0x144B,0x144B},
 {1,0x144C,0x144C,0x144C}, {1,0x144D,0x144D,0x144D}, {1,0x144E,0x144E,0x144E}, {1,0x144F,0x144F,0x144F},
 {1,0x1450,0x1450,0x1450}, {1,0x1451,0x1451,0x1451}, {1,0x1452,0x1452,0x1452}, {1,0x1453,0x1453,0x1453},
 {1,0x1454,0x1454,0x1454}, {1,0x1455,0x1455,0x1455}, {1,0x1456,0x1456,0x1456}, {1,0x1457,0x1457,0x1457},
 {1,0x1458,0x1458,0x1458}, {1,0x1459,0x1459,0x1459}, {1,0x145A,0x145A,0x145A}, {1,0x145B,0x145B,0x145B},
 {1,0x145C,0x145C,0x145C}, {1,0x145D,0x145D,0x145D}, {1,0x145E,0x145E,0x145E}, {1,0x145F,0x145F,0x145F},
 {1,0x1460,0x1460,0x1460}, {1,0x1461,0x1461,0x1461}, {1,0x1462,0x1462,0x1462}, {1,0x1463,0x1463,0x1463},
 {1,0x1464,0x1464,0x1464}, {1,0x1465,0x1465,0x1465}, {1,0x1466,0x1466,0x1466}, {1,0x1467,0x1467,0x1467},
 {1,0x1468,0x1468,0x1468}, {1,0x1469,0x1469,0x1469}, {1,0x146A,0x146A,0x146A}, {1,0x146B,0x146B,0x146B},
 {1,0x146C,0x146C,0x146C}, {1,0x146D,0x146D,0x146D}, {1,0x146E,0x146E,0x146E}, {1,0x146F,0x146F,0x146F},
 {1,0x1470,0x1470,0x1470}, {1,0x1471,0x1471,0x1471}, {1,0x1472,0x1472,0x1472}, {1,0x1473,0x1473,0x1473},
 {1,0x1474,0x1474,0x1474}, {1,0x1475,0x1475,0x1475}, {1,0x1476,0x1476,0x1476}, {1,0x1477,0x1477,0x1477},
 {1,0x1478,0x1478,0x1478}, {1,0x1479,0x1479,0x1479}, {1,0x147A,0x147A,0x147A}, {1,0x147B,0x147B,0x147B},
 {1,0x147C,0x147C,0x147C}, {1,0x147D,0x147D,0x147D}, {1,0x147E,0x147E,0x147E}, {1,0x147F,0x147F,0x147F},
 {1,0x1480,0x1480,0x1480}, {1,0x1481,0x1481,0x1481}, {1,0x1482,0x1482,0x1482}, {1,0x1483,0x1483,0x1483},
 {1,0x1484,0x1484,0x1484}, {1,0x1485,0x1485,0x1485}, {1,0x1486,0x1486,0x1486}, {1,0x1487,0x1487,0x1487},
 {1,0x1488,0x1488,0x1488}, {1,0x1489,0x1489,0x1489}, {1,0x148A,0x148A,0x148A}, {1,0x148B,0x148B,0x148B},
 {1,0x148C,0x148C,0x148C}, {1,0x148D,0x148D,0x148D}, {1,0x148E,0x148E,0x148E}, {1,0x148F,0x148F,0x148F},
 {1,0x1490,0x1490,0x1490}, {1,0x1491,0x1491,0x1491}, {1,0x1492,0x1492,0x1492}, {1,0x1493,0x1493,0x1493},
 {1,0x1494,0x1494,0x1494}, {1,0x1495,0x1495,0x1495}, {1,0x1496,0x1496,0x1496}, {1,0x1497,0x1497,0x1497},
 {1,0x1498,0x1498,0x1498}, {1,0x1499,0x1499,0x1499}, {1,0x149A,0x149A,0x149A}, {1,0x149B,0x149B,0x149B},
 {1,0x149C,0x149C,0x149C}, {1,0x149D,0x149D,0x149D}, {1,0x149E,0x149E,0x149E}, {1,0x149F,0x149F,0x149F},
 {1,0x14A0,0x14A0,0x14A0}, {1,0x14A1,0x14A1,0x14A1}, {1,0x14A2,0x14A2,0x14A2}, {1,0x14A3,0x14A3,0x14A3},
 {1,0x14A4,0x14A4,0x14A4}, {1,0x14A5,0x14A5,0x14A5}, {1,0x14A6,0x14A6,0x14A6}, {1,0x14A7,0x14A7,0x14A7},
 {1,0x14A8,0x14A8,0x14A8}, {1,0x14A9,0x14A9,0x14A9}, {1,0x14AA,0x14AA,0x14AA}, {1,0x14AB,0x14AB,0x14AB},
 {1,0x14AC,0x14AC,0x14AC}, {1,0x14AD,0x14AD,0x14AD}, {1,0x14AE,0x14AE,0x14AE}, {1,0x14AF,0x14AF,0x14AF},
 {1,0x14B0,0x14B0,0x14B0}, {1,0x14B1,0x14B1,0x14B1}, {1,0x14B2,0x14B2,0x14B2}, {1,0x14B3,0x14B3,0x14B3},
 {1,0x14B4,0x14B4,0x14B4}, {1,0x14B5,0x14B5,0x14B5}, {1,0x14B6,0x14B6,0x14B6}, {1,0x14B7,0x14B7,0x14B7},
 {1,0x14B8,0x14B8,0x14B8}, {1,0x14B9,0x14B9,0x14B9}, {1,0x14BA,0x14BA,0x14BA}, {1,0x14BB,0x14BB,0x14BB},
 {1,0x14BC,0x14BC,0x14BC}, {1,0x14BD,0x14BD,0x14BD}, {1,0x14BE,0x14BE,0x14BE}, {1,0x14BF,0x14BF,0x14BF},
 {1,0x14C0,0x14C0,0x14C0}, {1,0x14C1,0x14C1,0x14C1}, {1,0x14C2,0x14C2,0x14C2}, {1,0x14C3,0x14C3,0x14C3},
 {1,0x14C4,0x14C4,0x14C4}, {1,0x14C5,0x14C5,0x14C5}, {1,0x14C6,0x14C6,0x14C6}, {1,0x14C7,0x14C7,0x14C7},
 {1,0x14C8,0x14C8,0x14C8}, {1,0x14C9,0x14C9,0x14C9}, {1,0x14CA,0x14CA,0x14CA}, {1,0x14CB,0x14CB,0x14CB},
 {1,0x14CC,0x14CC,0x14CC}, {1,0x14CD,0x14CD,0x14CD}, {1,0x14CE,0x14CE,0x14CE}, {1,0x14CF,0x14CF,0x14CF},
 {1,0x14D0,0x14D0,0x14D0}, {1,0x14D1,0x14D1,0x14D1}, {1,0x14D2,0x14D2,0x14D2}, {1,0x14D3,0x14D3,0x14D3},
 {1,0x14D4,0x14D4,0x14D4}, {1,0x14D5,0x14D5,0x14D5}, {1,0x14D6,0x14D6,0x14D6}, {1,0x14D7,0x14D7,0x14D7},
 {1,0x14D8,0x14D8,0x14D8}, {1,0x14D9,0x14D9,0x14D9}, {1,0x14DA,0x14DA,0x14DA}, {1,0x14DB,0x14DB,0x14DB},
 {1,0x14DC,0x14DC,0x14DC}, {1,0x14DD,0x14DD,0x14DD}, {1,0x14DE,0x14DE,0x14DE}, {1,0x14DF,0x14DF,0x14DF},
 {1,0x14E0,0x14E0,0x14E0}, {1,0x14E1,0x14E1,0x14E1}, {1,0x14E2,0x14E2,0x14E2}, {1,0x14E3,0x14E3,0x14E3},
 {1,0x14E4,0x14E4,0x14E4}, {1,0x14E5,0x14E5,0x14E5}, {1,0x14E6,0x14E6,0x14E6}, {1,0x14E7,0x14E7,0x14E7},
 {1,0x14E8,0x14E8,0x14E8}, {1,0x14E9,0x14E9,0x14E9}, {1,0x14EA,0x14EA,0x14EA}, {1,0x14EB,0x14EB,0x14EB},
 {1,0x14EC,0x14EC,0x14EC}, {1,0x14ED,0x14ED,0x14ED}, {1,0x14EE,0x14EE,0x14EE}, {1,0x14EF,0x14EF,0x14EF},
 {1,0x14F0,0x14F0,0x14F0}, {1,0x14F1,0x14F1,0x14F1}, {1,0x14F2,0x14F2,0x14F2}, {1,0x14F3,0x14F3,0x14F3},
 {1,0x14F4,0x14F4,0x14F4}, {1,0x14F5,0x14F5,0x14F5}, {1,0x14F6,0x14F6,0x14F6}, {1,0x14F7,0x14F7,0x14F7},
 {1,0x14F8,0x14F8,0x14F8}, {1,0x14F9,0x14F9,0x14F9}, {1,0x14FA,0x14FA,0x14FA}, {1,0x14FB,0x14FB,0x14FB},
 {1,0x14FC,0x14FC,0x14FC}, {1,0x14FD,0x14FD,0x14FD}, {1,0x14FE,0x14FE,0x14FE}, {1,0x14FF,0x14FF,0x14FF},
{0,0}};

static UDM_UNICODE plane16[257]={
 {1,0x1600,0x1600,0x1600}, {1,0x1601,0x1601,0x1601}, {1,0x1602,0x1602,0x1602}, {1,0x1603,0x1603,0x1603},
 {1,0x1604,0x1604,0x1604}, {1,0x1605,0x1605,0x1605}, {1,0x1606,0x1606,0x1606}, {1,0x1607,0x1607,0x1607},
 {1,0x1608,0x1608,0x1608}, {1,0x1609,0x1609,0x1609}, {1,0x160A,0x160A,0x160A}, {1,0x160B,0x160B,0x160B},
 {1,0x160C,0x160C,0x160C}, {1,0x160D,0x160D,0x160D}, {1,0x160E,0x160E,0x160E}, {1,0x160F,0x160F,0x160F},
 {1,0x1610,0x1610,0x1610}, {1,0x1611,0x1611,0x1611}, {1,0x1612,0x1612,0x1612}, {1,0x1613,0x1613,0x1613},
 {1,0x1614,0x1614,0x1614}, {1,0x1615,0x1615,0x1615}, {1,0x1616,0x1616,0x1616}, {1,0x1617,0x1617,0x1617},
 {1,0x1618,0x1618,0x1618}, {1,0x1619,0x1619,0x1619}, {1,0x161A,0x161A,0x161A}, {1,0x161B,0x161B,0x161B},
 {1,0x161C,0x161C,0x161C}, {1,0x161D,0x161D,0x161D}, {1,0x161E,0x161E,0x161E}, {1,0x161F,0x161F,0x161F},
 {1,0x1620,0x1620,0x1620}, {1,0x1621,0x1621,0x1621}, {1,0x1622,0x1622,0x1622}, {1,0x1623,0x1623,0x1623},
 {1,0x1624,0x1624,0x1624}, {1,0x1625,0x1625,0x1625}, {1,0x1626,0x1626,0x1626}, {1,0x1627,0x1627,0x1627},
 {1,0x1628,0x1628,0x1628}, {1,0x1629,0x1629,0x1629}, {1,0x162A,0x162A,0x162A}, {1,0x162B,0x162B,0x162B},
 {1,0x162C,0x162C,0x162C}, {1,0x162D,0x162D,0x162D}, {1,0x162E,0x162E,0x162E}, {1,0x162F,0x162F,0x162F},
 {1,0x1630,0x1630,0x1630}, {1,0x1631,0x1631,0x1631}, {1,0x1632,0x1632,0x1632}, {1,0x1633,0x1633,0x1633},
 {1,0x1634,0x1634,0x1634}, {1,0x1635,0x1635,0x1635}, {1,0x1636,0x1636,0x1636}, {1,0x1637,0x1637,0x1637},
 {1,0x1638,0x1638,0x1638}, {1,0x1639,0x1639,0x1639}, {1,0x163A,0x163A,0x163A}, {1,0x163B,0x163B,0x163B},
 {1,0x163C,0x163C,0x163C}, {1,0x163D,0x163D,0x163D}, {1,0x163E,0x163E,0x163E}, {1,0x163F,0x163F,0x163F},
 {1,0x1640,0x1640,0x1640}, {1,0x1641,0x1641,0x1641}, {1,0x1642,0x1642,0x1642}, {1,0x1643,0x1643,0x1643},
 {1,0x1644,0x1644,0x1644}, {1,0x1645,0x1645,0x1645}, {1,0x1646,0x1646,0x1646}, {1,0x1647,0x1647,0x1647},
 {1,0x1648,0x1648,0x1648}, {1,0x1649,0x1649,0x1649}, {1,0x164A,0x164A,0x164A}, {1,0x164B,0x164B,0x164B},
 {1,0x164C,0x164C,0x164C}, {1,0x164D,0x164D,0x164D}, {1,0x164E,0x164E,0x164E}, {1,0x164F,0x164F,0x164F},
 {1,0x1650,0x1650,0x1650}, {1,0x1651,0x1651,0x1651}, {1,0x1652,0x1652,0x1652}, {1,0x1653,0x1653,0x1653},
 {1,0x1654,0x1654,0x1654}, {1,0x1655,0x1655,0x1655}, {1,0x1656,0x1656,0x1656}, {1,0x1657,0x1657,0x1657},
 {1,0x1658,0x1658,0x1658}, {1,0x1659,0x1659,0x1659}, {1,0x165A,0x165A,0x165A}, {1,0x165B,0x165B,0x165B},
 {1,0x165C,0x165C,0x165C}, {1,0x165D,0x165D,0x165D}, {1,0x165E,0x165E,0x165E}, {1,0x165F,0x165F,0x165F},
 {1,0x1660,0x1660,0x1660}, {1,0x1661,0x1661,0x1661}, {1,0x1662,0x1662,0x1662}, {1,0x1663,0x1663,0x1663},
 {1,0x1664,0x1664,0x1664}, {1,0x1665,0x1665,0x1665}, {1,0x1666,0x1666,0x1666}, {1,0x1667,0x1667,0x1667},
 {1,0x1668,0x1668,0x1668}, {1,0x1669,0x1669,0x1669}, {1,0x166A,0x166A,0x166A}, {1,0x166B,0x166B,0x166B},
 {1,0x166C,0x166C,0x166C}, {0,0x166D,0x166D,0x166D}, {0,0x166E,0x166E,0x166E}, {1,0x166F,0x166F,0x166F},
 {1,0x1670,0x1670,0x1670}, {1,0x1671,0x1671,0x1671}, {1,0x1672,0x1672,0x1672}, {1,0x1673,0x1673,0x1673},
 {1,0x1674,0x1674,0x1674}, {1,0x1675,0x1675,0x1675}, {1,0x1676,0x1676,0x1676}, {0,0x1677,0x1677,0x1677},
 {0,0x1678,0x1678,0x1678}, {0,0x1679,0x1679,0x1679}, {0,0x167A,0x167A,0x167A}, {0,0x167B,0x167B,0x167B},
 {0,0x167C,0x167C,0x167C}, {0,0x167D,0x167D,0x167D}, {0,0x167E,0x167E,0x167E}, {0,0x167F,0x167F,0x167F},
 {0,0x1680,0x1680,0x1680}, {1,0x1681,0x1681,0x1681}, {1,0x1682,0x1682,0x1682}, {1,0x1683,0x1683,0x1683},
 {1,0x1684,0x1684,0x1684}, {1,0x1685,0x1685,0x1685}, {1,0x1686,0x1686,0x1686}, {1,0x1687,0x1687,0x1687},
 {1,0x1688,0x1688,0x1688}, {1,0x1689,0x1689,0x1689}, {1,0x168A,0x168A,0x168A}, {1,0x168B,0x168B,0x168B},
 {1,0x168C,0x168C,0x168C}, {1,0x168D,0x168D,0x168D}, {1,0x168E,0x168E,0x168E}, {1,0x168F,0x168F,0x168F},
 {1,0x1690,0x1690,0x1690}, {1,0x1691,0x1691,0x1691}, {1,0x1692,0x1692,0x1692}, {1,0x1693,0x1693,0x1693},
 {1,0x1694,0x1694,0x1694}, {1,0x1695,0x1695,0x1695}, {1,0x1696,0x1696,0x1696}, {1,0x1697,0x1697,0x1697},
 {1,0x1698,0x1698,0x1698}, {1,0x1699,0x1699,0x1699}, {1,0x169A,0x169A,0x169A}, {0,0x169B,0x169B,0x169B},
 {0,0x169C,0x169C,0x169C}, {0,0x169D,0x169D,0x169D}, {0,0x169E,0x169E,0x169E}, {0,0x169F,0x169F,0x169F},
 {1,0x16A0,0x16A0,0x16A0}, {1,0x16A1,0x16A1,0x16A1}, {1,0x16A2,0x16A2,0x16A2}, {1,0x16A3,0x16A3,0x16A3},
 {1,0x16A4,0x16A4,0x16A4}, {1,0x16A5,0x16A5,0x16A5}, {1,0x16A6,0x16A6,0x16A6}, {1,0x16A7,0x16A7,0x16A7},
 {1,0x16A8,0x16A8,0x16A8}, {1,0x16A9,0x16A9,0x16A9}, {1,0x16AA,0x16AA,0x16AA}, {1,0x16AB,0x16AB,0x16AB},
 {1,0x16AC,0x16AC,0x16AC}, {1,0x16AD,0x16AD,0x16AD}, {1,0x16AE,0x16AE,0x16AE}, {1,0x16AF,0x16AF,0x16AF},
 {1,0x16B0,0x16B0,0x16B0}, {1,0x16B1,0x16B1,0x16B1}, {1,0x16B2,0x16B2,0x16B2}, {1,0x16B3,0x16B3,0x16B3},
 {1,0x16B4,0x16B4,0x16B4}, {1,0x16B5,0x16B5,0x16B5}, {1,0x16B6,0x16B6,0x16B6}, {1,0x16B7,0x16B7,0x16B7},
 {1,0x16B8,0x16B8,0x16B8}, {1,0x16B9,0x16B9,0x16B9}, {1,0x16BA,0x16BA,0x16BA}, {1,0x16BB,0x16BB,0x16BB},
 {1,0x16BC,0x16BC,0x16BC}, {1,0x16BD,0x16BD,0x16BD}, {1,0x16BE,0x16BE,0x16BE}, {1,0x16BF,0x16BF,0x16BF},
 {1,0x16C0,0x16C0,0x16C0}, {1,0x16C1,0x16C1,0x16C1}, {1,0x16C2,0x16C2,0x16C2}, {1,0x16C3,0x16C3,0x16C3},
 {1,0x16C4,0x16C4,0x16C4}, {1,0x16C5,0x16C5,0x16C5}, {1,0x16C6,0x16C6,0x16C6}, {1,0x16C7,0x16C7,0x16C7},
 {1,0x16C8,0x16C8,0x16C8}, {1,0x16C9,0x16C9,0x16C9}, {1,0x16CA,0x16CA,0x16CA}, {1,0x16CB,0x16CB,0x16CB},
 {1,0x16CC,0x16CC,0x16CC}, {1,0x16CD,0x16CD,0x16CD}, {1,0x16CE,0x16CE,0x16CE}, {1,0x16CF,0x16CF,0x16CF},
 {1,0x16D0,0x16D0,0x16D0}, {1,0x16D1,0x16D1,0x16D1}, {1,0x16D2,0x16D2,0x16D2}, {1,0x16D3,0x16D3,0x16D3},
 {1,0x16D4,0x16D4,0x16D4}, {1,0x16D5,0x16D5,0x16D5}, {1,0x16D6,0x16D6,0x16D6}, {1,0x16D7,0x16D7,0x16D7},
 {1,0x16D8,0x16D8,0x16D8}, {1,0x16D9,0x16D9,0x16D9}, {1,0x16DA,0x16DA,0x16DA}, {1,0x16DB,0x16DB,0x16DB},
 {1,0x16DC,0x16DC,0x16DC}, {1,0x16DD,0x16DD,0x16DD}, {1,0x16DE,0x16DE,0x16DE}, {1,0x16DF,0x16DF,0x16DF},
 {1,0x16E0,0x16E0,0x16E0}, {1,0x16E1,0x16E1,0x16E1}, {1,0x16E2,0x16E2,0x16E2}, {1,0x16E3,0x16E3,0x16E3},
 {1,0x16E4,0x16E4,0x16E4}, {1,0x16E5,0x16E5,0x16E5}, {1,0x16E6,0x16E6,0x16E6}, {1,0x16E7,0x16E7,0x16E7},
 {1,0x16E8,0x16E8,0x16E8}, {1,0x16E9,0x16E9,0x16E9}, {1,0x16EA,0x16EA,0x16EA}, {0,0x16EB,0x16EB,0x16EB},
 {0,0x16EC,0x16EC,0x16EC}, {0,0x16ED,0x16ED,0x16ED}, {0,0x16EE,0x16EE,0x16EE}, {0,0x16EF,0x16EF,0x16EF},
 {0,0x16F0,0x16F0,0x16F0}, {0,0x16F1,0x16F1,0x16F1}, {0,0x16F2,0x16F2,0x16F2}, {0,0x16F3,0x16F3,0x16F3},
 {0,0x16F4,0x16F4,0x16F4}, {0,0x16F5,0x16F5,0x16F5}, {0,0x16F6,0x16F6,0x16F6}, {0,0x16F7,0x16F7,0x16F7},
 {0,0x16F8,0x16F8,0x16F8}, {0,0x16F9,0x16F9,0x16F9}, {0,0x16FA,0x16FA,0x16FA}, {0,0x16FB,0x16FB,0x16FB},
 {0,0x16FC,0x16FC,0x16FC}, {0,0x16FD,0x16FD,0x16FD}, {0,0x16FE,0x16FE,0x16FE}, {0,0x16FF,0x16FF,0x16FF},
{0,0}};

static UDM_UNICODE plane17[257]={
 {0,0x1700,0x1700,0x1700}, {0,0x1701,0x1701,0x1701}, {0,0x1702,0x1702,0x1702}, {0,0x1703,0x1703,0x1703},
 {0,0x1704,0x1704,0x1704}, {0,0x1705,0x1705,0x1705}, {0,0x1706,0x1706,0x1706}, {0,0x1707,0x1707,0x1707},
 {0,0x1708,0x1708,0x1708}, {0,0x1709,0x1709,0x1709}, {0,0x170A,0x170A,0x170A}, {0,0x170B,0x170B,0x170B},
 {0,0x170C,0x170C,0x170C}, {0,0x170D,0x170D,0x170D}, {0,0x170E,0x170E,0x170E}, {0,0x170F,0x170F,0x170F},
 {0,0x1710,0x1710,0x1710}, {0,0x1711,0x1711,0x1711}, {0,0x1712,0x1712,0x1712}, {0,0x1713,0x1713,0x1713},
 {0,0x1714,0x1714,0x1714}, {0,0x1715,0x1715,0x1715}, {0,0x1716,0x1716,0x1716}, {0,0x1717,0x1717,0x1717},
 {0,0x1718,0x1718,0x1718}, {0,0x1719,0x1719,0x1719}, {0,0x171A,0x171A,0x171A}, {0,0x171B,0x171B,0x171B},
 {0,0x171C,0x171C,0x171C}, {0,0x171D,0x171D,0x171D}, {0,0x171E,0x171E,0x171E}, {0,0x171F,0x171F,0x171F},
 {0,0x1720,0x1720,0x1720}, {0,0x1721,0x1721,0x1721}, {0,0x1722,0x1722,0x1722}, {0,0x1723,0x1723,0x1723},
 {0,0x1724,0x1724,0x1724}, {0,0x1725,0x1725,0x1725}, {0,0x1726,0x1726,0x1726}, {0,0x1727,0x1727,0x1727},
 {0,0x1728,0x1728,0x1728}, {0,0x1729,0x1729,0x1729}, {0,0x172A,0x172A,0x172A}, {0,0x172B,0x172B,0x172B},
 {0,0x172C,0x172C,0x172C}, {0,0x172D,0x172D,0x172D}, {0,0x172E,0x172E,0x172E}, {0,0x172F,0x172F,0x172F},
 {0,0x1730,0x1730,0x1730}, {0,0x1731,0x1731,0x1731}, {0,0x1732,0x1732,0x1732}, {0,0x1733,0x1733,0x1733},
 {0,0x1734,0x1734,0x1734}, {0,0x1735,0x1735,0x1735}, {0,0x1736,0x1736,0x1736}, {0,0x1737,0x1737,0x1737},
 {0,0x1738,0x1738,0x1738}, {0,0x1739,0x1739,0x1739}, {0,0x173A,0x173A,0x173A}, {0,0x173B,0x173B,0x173B},
 {0,0x173C,0x173C,0x173C}, {0,0x173D,0x173D,0x173D}, {0,0x173E,0x173E,0x173E}, {0,0x173F,0x173F,0x173F},
 {0,0x1740,0x1740,0x1740}, {0,0x1741,0x1741,0x1741}, {0,0x1742,0x1742,0x1742}, {0,0x1743,0x1743,0x1743},
 {0,0x1744,0x1744,0x1744}, {0,0x1745,0x1745,0x1745}, {0,0x1746,0x1746,0x1746}, {0,0x1747,0x1747,0x1747},
 {0,0x1748,0x1748,0x1748}, {0,0x1749,0x1749,0x1749}, {0,0x174A,0x174A,0x174A}, {0,0x174B,0x174B,0x174B},
 {0,0x174C,0x174C,0x174C}, {0,0x174D,0x174D,0x174D}, {0,0x174E,0x174E,0x174E}, {0,0x174F,0x174F,0x174F},
 {0,0x1750,0x1750,0x1750}, {0,0x1751,0x1751,0x1751}, {0,0x1752,0x1752,0x1752}, {0,0x1753,0x1753,0x1753},
 {0,0x1754,0x1754,0x1754}, {0,0x1755,0x1755,0x1755}, {0,0x1756,0x1756,0x1756}, {0,0x1757,0x1757,0x1757},
 {0,0x1758,0x1758,0x1758}, {0,0x1759,0x1759,0x1759}, {0,0x175A,0x175A,0x175A}, {0,0x175B,0x175B,0x175B},
 {0,0x175C,0x175C,0x175C}, {0,0x175D,0x175D,0x175D}, {0,0x175E,0x175E,0x175E}, {0,0x175F,0x175F,0x175F},
 {0,0x1760,0x1760,0x1760}, {0,0x1761,0x1761,0x1761}, {0,0x1762,0x1762,0x1762}, {0,0x1763,0x1763,0x1763},
 {0,0x1764,0x1764,0x1764}, {0,0x1765,0x1765,0x1765}, {0,0x1766,0x1766,0x1766}, {0,0x1767,0x1767,0x1767},
 {0,0x1768,0x1768,0x1768}, {0,0x1769,0x1769,0x1769}, {0,0x176A,0x176A,0x176A}, {0,0x176B,0x176B,0x176B},
 {0,0x176C,0x176C,0x176C}, {0,0x176D,0x176D,0x176D}, {0,0x176E,0x176E,0x176E}, {0,0x176F,0x176F,0x176F},
 {0,0x1770,0x1770,0x1770}, {0,0x1771,0x1771,0x1771}, {0,0x1772,0x1772,0x1772}, {0,0x1773,0x1773,0x1773},
 {0,0x1774,0x1774,0x1774}, {0,0x1775,0x1775,0x1775}, {0,0x1776,0x1776,0x1776}, {0,0x1777,0x1777,0x1777},
 {0,0x1778,0x1778,0x1778}, {0,0x1779,0x1779,0x1779}, {0,0x177A,0x177A,0x177A}, {0,0x177B,0x177B,0x177B},
 {0,0x177C,0x177C,0x177C}, {0,0x177D,0x177D,0x177D}, {0,0x177E,0x177E,0x177E}, {0,0x177F,0x177F,0x177F},
 {1,0x1780,0x1780,0x1780}, {1,0x1781,0x1781,0x1781}, {1,0x1782,0x1782,0x1782}, {1,0x1783,0x1783,0x1783},
 {1,0x1784,0x1784,0x1784}, {1,0x1785,0x1785,0x1785}, {1,0x1786,0x1786,0x1786}, {1,0x1787,0x1787,0x1787},
 {1,0x1788,0x1788,0x1788}, {1,0x1789,0x1789,0x1789}, {1,0x178A,0x178A,0x178A}, {1,0x178B,0x178B,0x178B},
 {1,0x178C,0x178C,0x178C}, {1,0x178D,0x178D,0x178D}, {1,0x178E,0x178E,0x178E}, {1,0x178F,0x178F,0x178F},
 {1,0x1790,0x1790,0x1790}, {1,0x1791,0x1791,0x1791}, {1,0x1792,0x1792,0x1792}, {1,0x1793,0x1793,0x1793},
 {1,0x1794,0x1794,0x1794}, {1,0x1795,0x1795,0x1795}, {1,0x1796,0x1796,0x1796}, {1,0x1797,0x1797,0x1797},
 {1,0x1798,0x1798,0x1798}, {1,0x1799,0x1799,0x1799}, {1,0x179A,0x179A,0x179A}, {1,0x179B,0x179B,0x179B},
 {1,0x179C,0x179C,0x179C}, {1,0x179D,0x179D,0x179D}, {1,0x179E,0x179E,0x179E}, {1,0x179F,0x179F,0x179F},
 {1,0x17A0,0x17A0,0x17A0}, {1,0x17A1,0x17A1,0x17A1}, {1,0x17A2,0x17A2,0x17A2}, {1,0x17A3,0x17A3,0x17A3},
 {1,0x17A4,0x17A4,0x17A4}, {1,0x17A5,0x17A5,0x17A5}, {1,0x17A6,0x17A6,0x17A6}, {1,0x17A7,0x17A7,0x17A7},
 {1,0x17A8,0x17A8,0x17A8}, {1,0x17A9,0x17A9,0x17A9}, {1,0x17AA,0x17AA,0x17AA}, {1,0x17AB,0x17AB,0x17AB},
 {1,0x17AC,0x17AC,0x17AC}, {1,0x17AD,0x17AD,0x17AD}, {1,0x17AE,0x17AE,0x17AE}, {1,0x17AF,0x17AF,0x17AF},
 {1,0x17B0,0x17B0,0x17B0}, {1,0x17B1,0x17B1,0x17B1}, {1,0x17B2,0x17B2,0x17B2}, {1,0x17B3,0x17B3,0x17B3},
 {1,0x17B4,0x17B4,0x17B4}, {1,0x17B5,0x17B5,0x17B5}, {1,0x17B6,0x17B6,0x17B6}, {1,0x17B7,0x17B7,0x17B7},
 {1,0x17B8,0x17B8,0x17B8}, {1,0x17B9,0x17B9,0x17B9}, {1,0x17BA,0x17BA,0x17BA}, {1,0x17BB,0x17BB,0x17BB},
 {1,0x17BC,0x17BC,0x17BC}, {1,0x17BD,0x17BD,0x17BD}, {1,0x17BE,0x17BE,0x17BE}, {1,0x17BF,0x17BF,0x17BF},
 {1,0x17C0,0x17C0,0x17C0}, {1,0x17C1,0x17C1,0x17C1}, {1,0x17C2,0x17C2,0x17C2}, {1,0x17C3,0x17C3,0x17C3},
 {1,0x17C4,0x17C4,0x17C4}, {1,0x17C5,0x17C5,0x17C5}, {1,0x17C6,0x17C6,0x17C6}, {1,0x17C7,0x17C7,0x17C7},
 {1,0x17C8,0x17C8,0x17C8}, {1,0x17C9,0x17C9,0x17C9}, {1,0x17CA,0x17CA,0x17CA}, {1,0x17CB,0x17CB,0x17CB},
 {1,0x17CC,0x17CC,0x17CC}, {1,0x17CD,0x17CD,0x17CD}, {1,0x17CE,0x17CE,0x17CE}, {1,0x17CF,0x17CF,0x17CF},
 {1,0x17D0,0x17D0,0x17D0}, {1,0x17D1,0x17D1,0x17D1}, {1,0x17D2,0x17D2,0x17D2}, {1,0x17D3,0x17D3,0x17D3},
 {0,0x17D4,0x17D4,0x17D4}, {0,0x17D5,0x17D5,0x17D5}, {0,0x17D6,0x17D6,0x17D6}, {0,0x17D7,0x17D7,0x17D7},
 {0,0x17D8,0x17D8,0x17D8}, {0,0x17D9,0x17D9,0x17D9}, {0,0x17DA,0x17DA,0x17DA}, {0,0x17DB,0x17DB,0x17DB},
 {0,0x17DC,0x17DC,0x17DC}, {0,0x17DD,0x17DD,0x17DD}, {0,0x17DE,0x17DE,0x17DE}, {0,0x17DF,0x17DF,0x17DF},
 {2,0x17E0,0x17E0,0x17E0}, {2,0x17E1,0x17E1,0x17E1}, {2,0x17E2,0x17E2,0x17E2}, {2,0x17E3,0x17E3,0x17E3},
 {2,0x17E4,0x17E4,0x17E4}, {2,0x17E5,0x17E5,0x17E5}, {2,0x17E6,0x17E6,0x17E6}, {2,0x17E7,0x17E7,0x17E7},
 {2,0x17E8,0x17E8,0x17E8}, {2,0x17E9,0x17E9,0x17E9}, {0,0x17EA,0x17EA,0x17EA}, {0,0x17EB,0x17EB,0x17EB},
 {0,0x17EC,0x17EC,0x17EC}, {0,0x17ED,0x17ED,0x17ED}, {0,0x17EE,0x17EE,0x17EE}, {0,0x17EF,0x17EF,0x17EF},
 {0,0x17F0,0x17F0,0x17F0}, {0,0x17F1,0x17F1,0x17F1}, {0,0x17F2,0x17F2,0x17F2}, {0,0x17F3,0x17F3,0x17F3},
 {0,0x17F4,0x17F4,0x17F4}, {0,0x17F5,0x17F5,0x17F5}, {0,0x17F6,0x17F6,0x17F6}, {0,0x17F7,0x17F7,0x17F7},
 {0,0x17F8,0x17F8,0x17F8}, {0,0x17F9,0x17F9,0x17F9}, {0,0x17FA,0x17FA,0x17FA}, {0,0x17FB,0x17FB,0x17FB},
 {0,0x17FC,0x17FC,0x17FC}, {0,0x17FD,0x17FD,0x17FD}, {0,0x17FE,0x17FE,0x17FE}, {0,0x17FF,0x17FF,0x17FF},
{0,0}};

static UDM_UNICODE plane18[257]={
 {0,0x1800,0x1800,0x1800}, {0,0x1801,0x1801,0x1801}, {0,0x1802,0x1802,0x1802}, {0,0x1803,0x1803,0x1803},
 {0,0x1804,0x1804,0x1804}, {0,0x1805,0x1805,0x1805}, {0,0x1806,0x1806,0x1806}, {0,0x1807,0x1807,0x1807},
 {0,0x1808,0x1808,0x1808}, {0,0x1809,0x1809,0x1809}, {0,0x180A,0x180A,0x180A}, {0,0x180B,0x180B,0x180B},
 {0,0x180C,0x180C,0x180C}, {0,0x180D,0x180D,0x180D}, {0,0x180E,0x180E,0x180E}, {0,0x180F,0x180F,0x180F},
 {2,0x1810,0x1810,0x1810}, {2,0x1811,0x1811,0x1811}, {2,0x1812,0x1812,0x1812}, {2,0x1813,0x1813,0x1813},
 {2,0x1814,0x1814,0x1814}, {2,0x1815,0x1815,0x1815}, {2,0x1816,0x1816,0x1816}, {2,0x1817,0x1817,0x1817},
 {2,0x1818,0x1818,0x1818}, {2,0x1819,0x1819,0x1819}, {0,0x181A,0x181A,0x181A}, {0,0x181B,0x181B,0x181B},
 {0,0x181C,0x181C,0x181C}, {0,0x181D,0x181D,0x181D}, {0,0x181E,0x181E,0x181E}, {0,0x181F,0x181F,0x181F},
 {1,0x1820,0x1820,0x1820}, {1,0x1821,0x1821,0x1821}, {1,0x1822,0x1822,0x1822}, {1,0x1823,0x1823,0x1823},
 {1,0x1824,0x1824,0x1824}, {1,0x1825,0x1825,0x1825}, {1,0x1826,0x1826,0x1826}, {1,0x1827,0x1827,0x1827},
 {1,0x1828,0x1828,0x1828}, {1,0x1829,0x1829,0x1829}, {1,0x182A,0x182A,0x182A}, {1,0x182B,0x182B,0x182B},
 {1,0x182C,0x182C,0x182C}, {1,0x182D,0x182D,0x182D}, {1,0x182E,0x182E,0x182E}, {1,0x182F,0x182F,0x182F},
 {1,0x1830,0x1830,0x1830}, {1,0x1831,0x1831,0x1831}, {1,0x1832,0x1832,0x1832}, {1,0x1833,0x1833,0x1833},
 {1,0x1834,0x1834,0x1834}, {1,0x1835,0x1835,0x1835}, {1,0x1836,0x1836,0x1836}, {1,0x1837,0x1837,0x1837},
 {1,0x1838,0x1838,0x1838}, {1,0x1839,0x1839,0x1839}, {1,0x183A,0x183A,0x183A}, {1,0x183B,0x183B,0x183B},
 {1,0x183C,0x183C,0x183C}, {1,0x183D,0x183D,0x183D}, {1,0x183E,0x183E,0x183E}, {1,0x183F,0x183F,0x183F},
 {1,0x1840,0x1840,0x1840}, {1,0x1841,0x1841,0x1841}, {1,0x1842,0x1842,0x1842}, {1,0x1843,0x1843,0x1843},
 {1,0x1844,0x1844,0x1844}, {1,0x1845,0x1845,0x1845}, {1,0x1846,0x1846,0x1846}, {1,0x1847,0x1847,0x1847},
 {1,0x1848,0x1848,0x1848}, {1,0x1849,0x1849,0x1849}, {1,0x184A,0x184A,0x184A}, {1,0x184B,0x184B,0x184B},
 {1,0x184C,0x184C,0x184C}, {1,0x184D,0x184D,0x184D}, {1,0x184E,0x184E,0x184E}, {1,0x184F,0x184F,0x184F},
 {1,0x1850,0x1850,0x1850}, {1,0x1851,0x1851,0x1851}, {1,0x1852,0x1852,0x1852}, {1,0x1853,0x1853,0x1853},
 {1,0x1854,0x1854,0x1854}, {1,0x1855,0x1855,0x1855}, {1,0x1856,0x1856,0x1856}, {1,0x1857,0x1857,0x1857},
 {1,0x1858,0x1858,0x1858}, {1,0x1859,0x1859,0x1859}, {1,0x185A,0x185A,0x185A}, {1,0x185B,0x185B,0x185B},
 {1,0x185C,0x185C,0x185C}, {1,0x185D,0x185D,0x185D}, {1,0x185E,0x185E,0x185E}, {1,0x185F,0x185F,0x185F},
 {1,0x1860,0x1860,0x1860}, {1,0x1861,0x1861,0x1861}, {1,0x1862,0x1862,0x1862}, {1,0x1863,0x1863,0x1863},
 {1,0x1864,0x1864,0x1864}, {1,0x1865,0x1865,0x1865}, {1,0x1866,0x1866,0x1866}, {1,0x1867,0x1867,0x1867},
 {1,0x1868,0x1868,0x1868}, {1,0x1869,0x1869,0x1869}, {1,0x186A,0x186A,0x186A}, {1,0x186B,0x186B,0x186B},
 {1,0x186C,0x186C,0x186C}, {1,0x186D,0x186D,0x186D}, {1,0x186E,0x186E,0x186E}, {1,0x186F,0x186F,0x186F},
 {1,0x1870,0x1870,0x1870}, {1,0x1871,0x1871,0x1871}, {1,0x1872,0x1872,0x1872}, {1,0x1873,0x1873,0x1873},
 {1,0x1874,0x1874,0x1874}, {1,0x1875,0x1875,0x1875}, {1,0x1876,0x1876,0x1876}, {1,0x1877,0x1877,0x1877},
 {0,0x1878,0x1878,0x1878}, {0,0x1879,0x1879,0x1879}, {0,0x187A,0x187A,0x187A}, {0,0x187B,0x187B,0x187B},
 {0,0x187C,0x187C,0x187C}, {0,0x187D,0x187D,0x187D}, {0,0x187E,0x187E,0x187E}, {0,0x187F,0x187F,0x187F},
 {1,0x1880,0x1880,0x1880}, {1,0x1881,0x1881,0x1881}, {1,0x1882,0x1882,0x1882}, {1,0x1883,0x1883,0x1883},
 {1,0x1884,0x1884,0x1884}, {1,0x1885,0x1885,0x1885}, {1,0x1886,0x1886,0x1886}, {1,0x1887,0x1887,0x1887},
 {1,0x1888,0x1888,0x1888}, {1,0x1889,0x1889,0x1889}, {1,0x188A,0x188A,0x188A}, {1,0x188B,0x188B,0x188B},
 {1,0x188C,0x188C,0x188C}, {1,0x188D,0x188D,0x188D}, {1,0x188E,0x188E,0x188E}, {1,0x188F,0x188F,0x188F},
 {1,0x1890,0x1890,0x1890}, {1,0x1891,0x1891,0x1891}, {1,0x1892,0x1892,0x1892}, {1,0x1893,0x1893,0x1893},
 {1,0x1894,0x1894,0x1894}, {1,0x1895,0x1895,0x1895}, {1,0x1896,0x1896,0x1896}, {1,0x1897,0x1897,0x1897},
 {1,0x1898,0x1898,0x1898}, {1,0x1899,0x1899,0x1899}, {1,0x189A,0x189A,0x189A}, {1,0x189B,0x189B,0x189B},
 {1,0x189C,0x189C,0x189C}, {1,0x189D,0x189D,0x189D}, {1,0x189E,0x189E,0x189E}, {1,0x189F,0x189F,0x189F},
 {1,0x18A0,0x18A0,0x18A0}, {1,0x18A1,0x18A1,0x18A1}, {1,0x18A2,0x18A2,0x18A2}, {1,0x18A3,0x18A3,0x18A3},
 {1,0x18A4,0x18A4,0x18A4}, {1,0x18A5,0x18A5,0x18A5}, {1,0x18A6,0x18A6,0x18A6}, {1,0x18A7,0x18A7,0x18A7},
 {1,0x18A8,0x18A8,0x18A8}, {1,0x18A9,0x18A9,0x18A9}, {0,0x18AA,0x18AA,0x18AA}, {0,0x18AB,0x18AB,0x18AB},
 {0,0x18AC,0x18AC,0x18AC}, {0,0x18AD,0x18AD,0x18AD}, {0,0x18AE,0x18AE,0x18AE}, {0,0x18AF,0x18AF,0x18AF},
 {0,0x18B0,0x18B0,0x18B0}, {0,0x18B1,0x18B1,0x18B1}, {0,0x18B2,0x18B2,0x18B2}, {0,0x18B3,0x18B3,0x18B3},
 {0,0x18B4,0x18B4,0x18B4}, {0,0x18B5,0x18B5,0x18B5}, {0,0x18B6,0x18B6,0x18B6}, {0,0x18B7,0x18B7,0x18B7},
 {0,0x18B8,0x18B8,0x18B8}, {0,0x18B9,0x18B9,0x18B9}, {0,0x18BA,0x18BA,0x18BA}, {0,0x18BB,0x18BB,0x18BB},
 {0,0x18BC,0x18BC,0x18BC}, {0,0x18BD,0x18BD,0x18BD}, {0,0x18BE,0x18BE,0x18BE}, {0,0x18BF,0x18BF,0x18BF},
 {0,0x18C0,0x18C0,0x18C0}, {0,0x18C1,0x18C1,0x18C1}, {0,0x18C2,0x18C2,0x18C2}, {0,0x18C3,0x18C3,0x18C3},
 {0,0x18C4,0x18C4,0x18C4}, {0,0x18C5,0x18C5,0x18C5}, {0,0x18C6,0x18C6,0x18C6}, {0,0x18C7,0x18C7,0x18C7},
 {0,0x18C8,0x18C8,0x18C8}, {0,0x18C9,0x18C9,0x18C9}, {0,0x18CA,0x18CA,0x18CA}, {0,0x18CB,0x18CB,0x18CB},
 {0,0x18CC,0x18CC,0x18CC}, {0,0x18CD,0x18CD,0x18CD}, {0,0x18CE,0x18CE,0x18CE}, {0,0x18CF,0x18CF,0x18CF},
 {0,0x18D0,0x18D0,0x18D0}, {0,0x18D1,0x18D1,0x18D1}, {0,0x18D2,0x18D2,0x18D2}, {0,0x18D3,0x18D3,0x18D3},
 {0,0x18D4,0x18D4,0x18D4}, {0,0x18D5,0x18D5,0x18D5}, {0,0x18D6,0x18D6,0x18D6}, {0,0x18D7,0x18D7,0x18D7},
 {0,0x18D8,0x18D8,0x18D8}, {0,0x18D9,0x18D9,0x18D9}, {0,0x18DA,0x18DA,0x18DA}, {0,0x18DB,0x18DB,0x18DB},
 {0,0x18DC,0x18DC,0x18DC}, {0,0x18DD,0x18DD,0x18DD}, {0,0x18DE,0x18DE,0x18DE}, {0,0x18DF,0x18DF,0x18DF},
 {0,0x18E0,0x18E0,0x18E0}, {0,0x18E1,0x18E1,0x18E1}, {0,0x18E2,0x18E2,0x18E2}, {0,0x18E3,0x18E3,0x18E3},
 {0,0x18E4,0x18E4,0x18E4}, {0,0x18E5,0x18E5,0x18E5}, {0,0x18E6,0x18E6,0x18E6}, {0,0x18E7,0x18E7,0x18E7},
 {0,0x18E8,0x18E8,0x18E8}, {0,0x18E9,0x18E9,0x18E9}, {0,0x18EA,0x18EA,0x18EA}, {0,0x18EB,0x18EB,0x18EB},
 {0,0x18EC,0x18EC,0x18EC}, {0,0x18ED,0x18ED,0x18ED}, {0,0x18EE,0x18EE,0x18EE}, {0,0x18EF,0x18EF,0x18EF},
 {0,0x18F0,0x18F0,0x18F0}, {0,0x18F1,0x18F1,0x18F1}, {0,0x18F2,0x18F2,0x18F2}, {0,0x18F3,0x18F3,0x18F3},
 {0,0x18F4,0x18F4,0x18F4}, {0,0x18F5,0x18F5,0x18F5}, {0,0x18F6,0x18F6,0x18F6}, {0,0x18F7,0x18F7,0x18F7},
 {0,0x18F8,0x18F8,0x18F8}, {0,0x18F9,0x18F9,0x18F9}, {0,0x18FA,0x18FA,0x18FA}, {0,0x18FB,0x18FB,0x18FB},
 {0,0x18FC,0x18FC,0x18FC}, {0,0x18FD,0x18FD,0x18FD}, {0,0x18FE,0x18FE,0x18FE}, {0,0x18FF,0x18FF,0x18FF},
{0,0}};

static UDM_UNICODE plane1E[257]={
 {1,0x1E01,0x0041,0x0061}, {1,0x1E01,0x0061,0x0061}, {1,0x1E03,0x0042,0x0062}, {1,0x1E03,0x0062,0x0062},
 {1,0x1E05,0x0042,0x0062}, {1,0x1E05,0x0062,0x0062}, {1,0x1E07,0x0042,0x0062}, {1,0x1E07,0x0062,0x0062},
 {1,0x1E09,0x0043,0x0063}, {1,0x1E09,0x0063,0x0063}, {1,0x1E0B,0x0044,0x0064}, {1,0x1E0B,0x0064,0x0064},
 {1,0x1E0D,0x0044,0x0064}, {1,0x1E0D,0x0064,0x0064}, {1,0x1E0F,0x0044,0x0064}, {1,0x1E0F,0x0064,0x0064},
 {1,0x1E11,0x0044,0x0064}, {1,0x1E11,0x0064,0x0064}, {1,0x1E13,0x0044,0x0064}, {1,0x1E13,0x0064,0x0064},
 {1,0x1E15,0x0045,0x0065}, {1,0x1E15,0x0065,0x0065}, {1,0x1E17,0x0045,0x0065}, {1,0x1E17,0x0065,0x0065},
 {1,0x1E19,0x0045,0x0065}, {1,0x1E19,0x0065,0x0065}, {1,0x1E1B,0x0045,0x0065}, {1,0x1E1B,0x0065,0x0065},
 {1,0x1E1D,0x0045,0x0065}, {1,0x1E1D,0x0065,0x0065}, {1,0x1E1F,0x0046,0x0066}, {1,0x1E1F,0x0066,0x0066},
 {1,0x1E21,0x0047,0x0067}, {1,0x1E21,0x0067,0x0067}, {1,0x1E23,0x0048,0x0068}, {1,0x1E23,0x0068,0x0068},
 {1,0x1E25,0x0048,0x0068}, {1,0x1E25,0x0068,0x0068}, {1,0x1E27,0x0048,0x0068}, {1,0x1E27,0x0068,0x0068},
 {1,0x1E29,0x0048,0x0068}, {1,0x1E29,0x0068,0x0068}, {1,0x1E2B,0x0048,0x0068}, {1,0x1E2B,0x0068,0x0068},
 {1,0x1E2D,0x0049,0x0069}, {1,0x1E2D,0x0069,0x0069}, {1,0x1E2F,0x0049,0x0069}, {1,0x1E2F,0x0069,0x0069},
 {1,0x1E31,0x004B,0x006B}, {1,0x1E31,0x006B,0x006B}, {1,0x1E33,0x004B,0x006B}, {1,0x1E33,0x006B,0x006B},
 {1,0x1E35,0x004B,0x006B}, {1,0x1E35,0x006B,0x006B}, {1,0x1E37,0x004C,0x006C}, {1,0x1E37,0x006C,0x006C},
 {1,0x1E39,0x004C,0x006C}, {1,0x1E39,0x006C,0x006C}, {1,0x1E3B,0x004C,0x006C}, {1,0x1E3B,0x006C,0x006C},
 {1,0x1E3D,0x004C,0x006C}, {1,0x1E3D,0x006C,0x006C}, {1,0x1E3F,0x004D,0x006D}, {1,0x1E3F,0x006D,0x006D},
 {1,0x1E41,0x004D,0x006D}, {1,0x1E41,0x006D,0x006D}, {1,0x1E43,0x004D,0x006D}, {1,0x1E43,0x006D,0x006D},
 {1,0x1E45,0x004E,0x006E}, {1,0x1E45,0x006E,0x006E}, {1,0x1E47,0x004E,0x006E}, {1,0x1E47,0x006E,0x006E},
 {1,0x1E49,0x004E,0x006E}, {1,0x1E49,0x006E,0x006E}, {1,0x1E4B,0x004E,0x006E}, {1,0x1E4B,0x006E,0x006E},
 {1,0x1E4D,0x004F,0x006F}, {1,0x1E4D,0x006F,0x006F}, {1,0x1E4F,0x004F,0x006F}, {1,0x1E4F,0x006F,0x006F},
 {1,0x1E51,0x004F,0x006F}, {1,0x1E51,0x006F,0x006F}, {1,0x1E53,0x004F,0x006F}, {1,0x1E53,0x006F,0x006F},
 {1,0x1E55,0x0050,0x0070}, {1,0x1E55,0x0070,0x0070}, {1,0x1E57,0x0050,0x0070}, {1,0x1E57,0x0070,0x0070},
 {1,0x1E59,0x0052,0x0072}, {1,0x1E59,0x0072,0x0072}, {1,0x1E5B,0x0052,0x0072}, {1,0x1E5B,0x0072,0x0072},
 {1,0x1E5D,0x0052,0x0072}, {1,0x1E5D,0x0072,0x0072}, {1,0x1E5F,0x0052,0x0072}, {1,0x1E5F,0x0072,0x0072},
 {1,0x1E61,0x0053,0x0073}, {1,0x1E61,0x0073,0x0073}, {1,0x1E63,0x0053,0x0073}, {1,0x1E63,0x0073,0x0073},
 {1,0x1E65,0x0053,0x0073}, {1,0x1E65,0x0073,0x0073}, {1,0x1E67,0x0053,0x0073}, {1,0x1E67,0x0073,0x0073},
 {1,0x1E69,0x0053,0x0073}, {1,0x1E69,0x0073,0x0073}, {1,0x1E6B,0x0054,0x0074}, {1,0x1E6B,0x0074,0x0074},
 {1,0x1E6D,0x0054,0x0074}, {1,0x1E6D,0x0074,0x0074}, {1,0x1E6F,0x0054,0x0074}, {1,0x1E6F,0x0074,0x0074},
 {1,0x1E71,0x0054,0x0074}, {1,0x1E71,0x0074,0x0074}, {1,0x1E73,0x0055,0x0075}, {1,0x1E73,0x0075,0x0075},
 {1,0x1E75,0x0055,0x0075}, {1,0x1E75,0x0075,0x0075}, {1,0x1E77,0x0055,0x0075}, {1,0x1E77,0x0075,0x0075},
 {1,0x1E79,0x0055,0x0075}, {1,0x1E79,0x0075,0x0075}, {1,0x1E7B,0x0055,0x0075}, {1,0x1E7B,0x0075,0x0075},
 {1,0x1E7D,0x0056,0x0076}, {1,0x1E7D,0x0076,0x0076}, {1,0x1E7F,0x0056,0x0076}, {1,0x1E7F,0x0076,0x0076},
 {1,0x1E81,0x0057,0x0077}, {1,0x1E81,0x0077,0x0077}, {1,0x1E83,0x0057,0x0077}, {1,0x1E83,0x0077,0x0077},
 {1,0x1E85,0x0057,0x0077}, {1,0x1E85,0x0077,0x0077}, {1,0x1E87,0x0057,0x0077}, {1,0x1E87,0x0077,0x0077},
 {1,0x1E89,0x0057,0x0077}, {1,0x1E89,0x0077,0x0077}, {1,0x1E8B,0x0058,0x0078}, {1,0x1E8B,0x0078,0x0078},
 {1,0x1E8D,0x0058,0x0078}, {1,0x1E8D,0x0078,0x0078}, {1,0x1E8F,0x0059,0x0079}, {1,0x1E8F,0x0079,0x0079},
 {1,0x1E91,0x005A,0x007A}, {1,0x1E91,0x007A,0x007A}, {1,0x1E93,0x005A,0x007A}, {1,0x1E93,0x007A,0x007A},
 {1,0x1E95,0x005A,0x007A}, {1,0x1E95,0x007A,0x007A}, {1,0x1E96,0x0068,0x0068}, {1,0x1E97,0x0074,0x0074},
 {1,0x1E98,0x0077,0x0077}, {1,0x1E99,0x0079,0x0079}, {1,0x1E9A,0x1E9A,0x1E9A}, {1,0x1E9B,0x017F,0x017F},
 {0,0x1E9C,0x1E9C,0x1E9C}, {0,0x1E9D,0x1E9D,0x1E9D}, {0,0x1E9E,0x1E9E,0x1E9E}, {0,0x1E9F,0x1E9F,0x1E9F},
 {1,0x1EA1,0x0041,0x0061}, {1,0x1EA1,0x0061,0x0061}, {1,0x1EA3,0x0041,0x0061}, {1,0x1EA3,0x0061,0x0061},
 {1,0x1EA5,0x0041,0x0061}, {1,0x1EA5,0x0061,0x0061}, {1,0x1EA7,0x0041,0x0061}, {1,0x1EA7,0x0061,0x0061},
 {1,0x1EA9,0x0041,0x0061}, {1,0x1EA9,0x0061,0x0061}, {1,0x1EAB,0x0041,0x0061}, {1,0x1EAB,0x0061,0x0061},
 {1,0x1EAD,0x0041,0x0061}, {1,0x1EAD,0x0061,0x0061}, {1,0x1EAF,0x0041,0x0061}, {1,0x1EAF,0x0061,0x0061},
 {1,0x1EB1,0x0041,0x0061}, {1,0x1EB1,0x0061,0x0061}, {1,0x1EB3,0x0041,0x0061}, {1,0x1EB3,0x0061,0x0061},
 {1,0x1EB5,0x0041,0x0061}, {1,0x1EB5,0x0061,0x0061}, {1,0x1EB7,0x0041,0x0061}, {1,0x1EB7,0x0061,0x0061},
 {1,0x1EB9,0x0045,0x0065}, {1,0x1EB9,0x0065,0x0065}, {1,0x1EBB,0x0045,0x0065}, {1,0x1EBB,0x0065,0x0065},
 {1,0x1EBD,0x0045,0x0065}, {1,0x1EBD,0x0065,0x0065}, {1,0x1EBF,0x0045,0x0065}, {1,0x1EBF,0x0065,0x0065},
 {1,0x1EC1,0x0045,0x0065}, {1,0x1EC1,0x0065,0x0065}, {1,0x1EC3,0x0045,0x0065}, {1,0x1EC3,0x0065,0x0065},
 {1,0x1EC5,0x0045,0x0065}, {1,0x1EC5,0x0065,0x0065}, {1,0x1EC7,0x0045,0x0065}, {1,0x1EC7,0x0065,0x0065},
 {1,0x1EC9,0x0049,0x0069}, {1,0x1EC9,0x0069,0x0069}, {1,0x1ECB,0x0049,0x0069}, {1,0x1ECB,0x0069,0x0069},
 {1,0x1ECD,0x004F,0x006F}, {1,0x1ECD,0x006F,0x006F}, {1,0x1ECF,0x004F,0x006F}, {1,0x1ECF,0x006F,0x006F},
 {1,0x1ED1,0x004F,0x006F}, {1,0x1ED1,0x006F,0x006F}, {1,0x1ED3,0x004F,0x006F}, {1,0x1ED3,0x006F,0x006F},
 {1,0x1ED5,0x004F,0x006F}, {1,0x1ED5,0x006F,0x006F}, {1,0x1ED7,0x004F,0x006F}, {1,0x1ED7,0x006F,0x006F},
 {1,0x1ED9,0x004F,0x006F}, {1,0x1ED9,0x006F,0x006F}, {1,0x1EDB,0x004F,0x006F}, {1,0x1EDB,0x006F,0x006F},
 {1,0x1EDD,0x004F,0x006F}, {1,0x1EDD,0x006F,0x006F}, {1,0x1EDF,0x004F,0x006F}, {1,0x1EDF,0x006F,0x006F},
 {1,0x1EE1,0x004F,0x006F}, {1,0x1EE1,0x006F,0x006F}, {1,0x1EE3,0x004F,0x006F}, {1,0x1EE3,0x006F,0x006F},
 {1,0x1EE5,0x0055,0x0075}, {1,0x1EE5,0x0075,0x0075}, {1,0x1EE7,0x0055,0x0075}, {1,0x1EE7,0x0075,0x0075},
 {1,0x1EE9,0x0055,0x0075}, {1,0x1EE9,0x0075,0x0075}, {1,0x1EEB,0x0055,0x0075}, {1,0x1EEB,0x0075,0x0075},
 {1,0x1EED,0x0055,0x0075}, {1,0x1EED,0x0075,0x0075}, {1,0x1EEF,0x0055,0x0075}, {1,0x1EEF,0x0075,0x0075},
 {1,0x1EF1,0x0055,0x0075}, {1,0x1EF1,0x0075,0x0075}, {1,0x1EF3,0x0059,0x0079}, {1,0x1EF3,0x0079,0x0079},
 {1,0x1EF5,0x0059,0x0079}, {1,0x1EF5,0x0079,0x0079}, {1,0x1EF7,0x0059,0x0079}, {1,0x1EF7,0x0079,0x0079},
 {1,0x1EF9,0x0059,0x0079}, {1,0x1EF9,0x0079,0x0079}, {0,0x1EFA,0x1EFA,0x1EFA}, {0,0x1EFB,0x1EFB,0x1EFB},
 {0,0x1EFC,0x1EFC,0x1EFC}, {0,0x1EFD,0x1EFD,0x1EFD}, {0,0x1EFE,0x1EFE,0x1EFE}, {0,0x1EFF,0x1EFF,0x1EFF},
{0,0}};

static UDM_UNICODE plane1F[257]={
 {1,0x1F00,0x03B1,0x03B1}, {1,0x1F01,0x03B1,0x03B1}, {1,0x1F02,0x03B1,0x03B1}, {1,0x1F03,0x03B1,0x03B1},
 {1,0x1F04,0x03B1,0x03B1}, {1,0x1F05,0x03B1,0x03B1}, {1,0x1F06,0x03B1,0x03B1}, {1,0x1F07,0x03B1,0x03B1},
 {1,0x1F00,0x0391,0x03B1}, {1,0x1F01,0x0391,0x03B1}, {1,0x1F02,0x0391,0x03B1}, {1,0x1F03,0x0391,0x03B1},
 {1,0x1F04,0x0391,0x03B1}, {1,0x1F05,0x0391,0x03B1}, {1,0x1F06,0x0391,0x03B1}, {1,0x1F07,0x0391,0x03B1},
 {1,0x1F10,0x03B5,0x03B5}, {1,0x1F11,0x03B5,0x03B5}, {1,0x1F12,0x03B5,0x03B5}, {1,0x1F13,0x03B5,0x03B5},
 {1,0x1F14,0x03B5,0x03B5}, {1,0x1F15,0x03B5,0x03B5}, {0,0x1F16,0x1F16,0x1F16}, {0,0x1F17,0x1F17,0x1F17},
 {1,0x1F10,0x0395,0x03B5}, {1,0x1F11,0x0395,0x03B5}, {1,0x1F12,0x0395,0x03B5}, {1,0x1F13,0x0395,0x03B5},
 {1,0x1F14,0x0395,0x03B5}, {1,0x1F15,0x0395,0x03B5}, {0,0x1F1E,0x1F1E,0x1F1E}, {0,0x1F1F,0x1F1F,0x1F1F},
 {1,0x1F20,0x03B7,0x03B7}, {1,0x1F21,0x03B7,0x03B7}, {1,0x1F22,0x03B7,0x03B7}, {1,0x1F23,0x03B7,0x03B7},
 {1,0x1F24,0x03B7,0x03B7}, {1,0x1F25,0x03B7,0x03B7}, {1,0x1F26,0x03B7,0x03B7}, {1,0x1F27,0x03B7,0x03B7},
 {1,0x1F20,0x0397,0x03B7}, {1,0x1F21,0x0397,0x03B7}, {1,0x1F22,0x0397,0x03B7}, {1,0x1F23,0x0397,0x03B7},
 {1,0x1F24,0x0397,0x03B7}, {1,0x1F25,0x0397,0x03B7}, {1,0x1F26,0x0397,0x03B7}, {1,0x1F27,0x0397,0x03B7},
 {1,0x1F30,0x03B9,0x03B9}, {1,0x1F31,0x03B9,0x03B9}, {1,0x1F32,0x03B9,0x03B9}, {1,0x1F33,0x03B9,0x03B9},
 {1,0x1F34,0x03B9,0x03B9}, {1,0x1F35,0x03B9,0x03B9}, {1,0x1F36,0x03B9,0x03B9}, {1,0x1F37,0x03B9,0x03B9},
 {1,0x1F30,0x0399,0x03B9}, {1,0x1F31,0x0399,0x03B9}, {1,0x1F32,0x0399,0x03B9}, {1,0x1F33,0x0399,0x03B9},
 {1,0x1F34,0x0399,0x03B9}, {1,0x1F35,0x0399,0x03B9}, {1,0x1F36,0x0399,0x03B9}, {1,0x1F37,0x0399,0x03B9},
 {1,0x1F40,0x03BF,0x03BF}, {1,0x1F41,0x03BF,0x03BF}, {1,0x1F42,0x03BF,0x03BF}, {1,0x1F43,0x03BF,0x03BF},
 {1,0x1F44,0x03BF,0x03BF}, {1,0x1F45,0x03BF,0x03BF}, {0,0x1F46,0x1F46,0x1F46}, {0,0x1F47,0x1F47,0x1F47},
 {1,0x1F40,0x039F,0x03BF}, {1,0x1F41,0x039F,0x03BF}, {1,0x1F42,0x039F,0x03BF}, {1,0x1F43,0x039F,0x03BF},
 {1,0x1F44,0x039F,0x03BF}, {1,0x1F45,0x039F,0x03BF}, {0,0x1F4E,0x1F4E,0x1F4E}, {0,0x1F4F,0x1F4F,0x1F4F},
 {1,0x1F50,0x03C5,0x03C5}, {1,0x1F51,0x03C5,0x03C5}, {1,0x1F52,0x03C5,0x03C5}, {1,0x1F53,0x03C5,0x03C5},
 {1,0x1F54,0x03C5,0x03C5}, {1,0x1F55,0x03C5,0x03C5}, {1,0x1F56,0x03C5,0x03C5}, {1,0x1F57,0x03C5,0x03C5},
 {0,0x1F58,0x1F58,0x1F58}, {1,0x1F51,0x03A5,0x03C5}, {0,0x1F5A,0x1F5A,0x1F5A}, {1,0x1F53,0x03A5,0x03C5},
 {0,0x1F5C,0x1F5C,0x1F5C}, {1,0x1F55,0x03A5,0x03C5}, {0,0x1F5E,0x1F5E,0x1F5E}, {1,0x1F57,0x03A5,0x03C5},
 {1,0x1F60,0x03C9,0x03C9}, {1,0x1F61,0x03C9,0x03C9}, {1,0x1F62,0x03C9,0x03C9}, {1,0x1F63,0x03C9,0x03C9},
 {1,0x1F64,0x03C9,0x03C9}, {1,0x1F65,0x03C9,0x03C9}, {1,0x1F66,0x03C9,0x03C9}, {1,0x1F67,0x03C9,0x03C9},
 {1,0x1F60,0x03A9,0x03C9}, {1,0x1F61,0x03A9,0x03C9}, {1,0x1F62,0x03A9,0x03C9}, {1,0x1F63,0x03A9,0x03C9},
 {1,0x1F64,0x03A9,0x03C9}, {1,0x1F65,0x03A9,0x03C9}, {1,0x1F66,0x03A9,0x03C9}, {1,0x1F67,0x03A9,0x03C9},
 {1,0x1F70,0x03B1,0x03B1}, {1,0x1F71,0x1F71,0x1F71}, {1,0x1F72,0x03B5,0x03B5}, {1,0x1F73,0x1F73,0x1F73},
 {1,0x1F74,0x03B7,0x03B7}, {1,0x1F75,0x1F75,0x1F75}, {1,0x1F76,0x03B9,0x03B9}, {1,0x1F77,0x1F77,0x1F77},
 {1,0x1F78,0x03BF,0x03BF}, {1,0x1F79,0x1F79,0x1F79}, {1,0x1F7A,0x03C5,0x03C5}, {1,0x1F7B,0x1F7B,0x1F7B},
 {1,0x1F7C,0x03C9,0x03C9}, {1,0x1F7D,0x1F7D,0x1F7D}, {0,0x1F7E,0x1F7E,0x1F7E}, {0,0x1F7F,0x1F7F,0x1F7F},
 {1,0x1F80,0x03B1,0x03B1}, {1,0x1F81,0x03B1,0x03B1}, {1,0x1F82,0x03B1,0x03B1}, {1,0x1F83,0x03B1,0x03B1},
 {1,0x1F84,0x03B1,0x03B1}, {1,0x1F85,0x03B1,0x03B1}, {1,0x1F86,0x03B1,0x03B1}, {1,0x1F87,0x03B1,0x03B1},
 {1,0x1F80,0x0391,0x03B1}, {1,0x1F81,0x0391,0x03B1}, {1,0x1F82,0x0391,0x03B1}, {1,0x1F83,0x0391,0x03B1},
 {1,0x1F84,0x0391,0x03B1}, {1,0x1F85,0x0391,0x03B1}, {1,0x1F86,0x0391,0x03B1}, {1,0x1F87,0x0391,0x03B1},
 {1,0x1F90,0x03B7,0x03B7}, {1,0x1F91,0x03B7,0x03B7}, {1,0x1F92,0x03B7,0x03B7}, {1,0x1F93,0x03B7,0x03B7},
 {1,0x1F94,0x03B7,0x03B7}, {1,0x1F95,0x03B7,0x03B7}, {1,0x1F96,0x03B7,0x03B7}, {1,0x1F97,0x03B7,0x03B7},
 {1,0x1F90,0x0397,0x03B7}, {1,0x1F91,0x0397,0x03B7}, {1,0x1F92,0x0397,0x03B7}, {1,0x1F93,0x0397,0x03B7},
 {1,0x1F94,0x0397,0x03B7}, {1,0x1F95,0x0397,0x03B7}, {1,0x1F96,0x0397,0x03B7}, {1,0x1F97,0x0397,0x03B7},
 {1,0x1FA0,0x03C9,0x03C9}, {1,0x1FA1,0x03C9,0x03C9}, {1,0x1FA2,0x03C9,0x03C9}, {1,0x1FA3,0x03C9,0x03C9},
 {1,0x1FA4,0x03C9,0x03C9}, {1,0x1FA5,0x03C9,0x03C9}, {1,0x1FA6,0x03C9,0x03C9}, {1,0x1FA7,0x03C9,0x03C9},
 {1,0x1FA0,0x03A9,0x03C9}, {1,0x1FA1,0x03A9,0x03C9}, {1,0x1FA2,0x03A9,0x03C9}, {1,0x1FA3,0x03A9,0x03C9},
 {1,0x1FA4,0x03A9,0x03C9}, {1,0x1FA5,0x03A9,0x03C9}, {1,0x1FA6,0x03A9,0x03C9}, {1,0x1FA7,0x03A9,0x03C9},
 {1,0x1FB0,0x03B1,0x03B1}, {1,0x1FB1,0x03B1,0x03B1}, {1,0x1FB2,0x03B1,0x03B1}, {1,0x1FB3,0x03B1,0x03B1},
 {1,0x1FB4,0x03B1,0x03B1}, {0,0x1FB5,0x1FB5,0x1FB5}, {1,0x1FB6,0x03B1,0x03B1}, {1,0x1FB7,0x03B1,0x03B1},
 {1,0x1FB0,0x0391,0x03B1}, {1,0x1FB1,0x0391,0x03B1}, {1,0x1F70,0x0391,0x03B1}, {1,0x1F71,0x1FBB,0x1F71},
 {1,0x1FB3,0x0391,0x03B1}, {0,0x1FBD,0x1FBD,0x1FBD}, {1,0x1FBE,0x1FBE,0x1FBE}, {0,0x1FBF,0x1FBF,0x1FBF},
 {0,0x1FC0,0x1FC0,0x1FC0}, {0,0x1FC1,0x1FC1,0x1FC1}, {1,0x1FC2,0x03B7,0x03B7}, {1,0x1FC3,0x03B7,0x03B7},
 {1,0x1FC4,0x03B7,0x03B7}, {0,0x1FC5,0x1FC5,0x1FC5}, {1,0x1FC6,0x03B7,0x03B7}, {1,0x1FC7,0x03B7,0x03B7},
 {1,0x1F72,0x0395,0x03B5}, {1,0x1F73,0x1FC9,0x1F73}, {1,0x1F74,0x0397,0x03B7}, {1,0x1F75,0x1FCB,0x1F75},
 {1,0x1FC3,0x0397,0x03B7}, {0,0x1FCD,0x1FCD,0x1FCD}, {0,0x1FCE,0x1FCE,0x1FCE}, {0,0x1FCF,0x1FCF,0x1FCF},
 {1,0x1FD0,0x03B9,0x03B9}, {1,0x1FD1,0x03B9,0x03B9}, {1,0x1FD2,0x03B9,0x03B9}, {1,0x1FD3,0x1FD3,0x1FD3},
 {0,0x1FD4,0x1FD4,0x1FD4}, {0,0x1FD5,0x1FD5,0x1FD5}, {1,0x1FD6,0x03B9,0x03B9}, {1,0x1FD7,0x03B9,0x03B9},
 {1,0x1FD0,0x0399,0x03B9}, {1,0x1FD1,0x0399,0x03B9}, {1,0x1F76,0x0399,0x03B9}, {1,0x1F77,0x1FDB,0x1F77},
 {0,0x1FDC,0x1FDC,0x1FDC}, {0,0x1FDD,0x1FDD,0x1FDD}, {0,0x1FDE,0x1FDE,0x1FDE}, {0,0x1FDF,0x1FDF,0x1FDF},
 {1,0x1FE0,0x03C5,0x03C5}, {1,0x1FE1,0x03C5,0x03C5}, {1,0x1FE2,0x03C5,0x03C5}, {1,0x1FE3,0x1FE3,0x1FE3},
 {1,0x1FE4,0x03C1,0x03C1}, {1,0x1FE5,0x03C1,0x03C1}, {1,0x1FE6,0x03C5,0x03C5}, {1,0x1FE7,0x03C5,0x03C5},
 {1,0x1FE0,0x03A5,0x03C5}, {1,0x1FE1,0x03A5,0x03C5}, {1,0x1F7A,0x03A5,0x03C5}, {1,0x1F7B,0x1FEB,0x1F7B},
 {1,0x1FE5,0x03A1,0x03C1}, {0,0x1FED,0x1FED,0x1FED}, {0,0x1FEE,0x1FEE,0x1FEE}, {0,0x1FEF,0x1FEF,0x1FEF},
 {0,0x1FF0,0x1FF0,0x1FF0}, {0,0x1FF1,0x1FF1,0x1FF1}, {1,0x1FF2,0x03C9,0x03C9}, {1,0x1FF3,0x03C9,0x03C9},
 {1,0x1FF4,0x03C9,0x03C9}, {0,0x1FF5,0x1FF5,0x1FF5}, {1,0x1FF6,0x03C9,0x03C9}, {1,0x1FF7,0x03C9,0x03C9},
 {1,0x1F78,0x039F,0x03BF}, {1,0x1F79,0x1FF9,0x1F79}, {1,0x1F7C,0x03A9,0x03C9}, {1,0x1F7D,0x1FFB,0x1F7D},
 {1,0x1FF3,0x03A9,0x03C9}, {0,0x1FFD,0x1FFD,0x1FFD}, {0,0x1FFE,0x1FFE,0x1FFE}, {0,0x1FFF,0x1FFF,0x1FFF},
{0,0}};

static UDM_UNICODE plane20[257]={
 {0,0x2000,0x2000,0x2000}, {0,0x2001,0x2001,0x2001}, {0,0x2002,0x2002,0x2002}, {0,0x2003,0x2003,0x2003},
 {0,0x2004,0x2004,0x2004}, {0,0x2005,0x2005,0x2005}, {0,0x2006,0x2006,0x2006}, {0,0x2007,0x2007,0x2007},
 {0,0x2008,0x2008,0x2008}, {0,0x2009,0x2009,0x2009}, {0,0x200A,0x200A,0x200A}, {0,0x200B,0x200B,0x200B},
 {0,0x200C,0x200C,0x200C}, {0,0x200D,0x200D,0x200D}, {0,0x200E,0x200E,0x200E}, {0,0x200F,0x200F,0x200F},
 {0,0x2010,0x2010,0x2010}, {0,0x2011,0x2011,0x2011}, {0,0x2012,0x2012,0x2012}, {0,0x2013,0x2013,0x2013},
 {0,0x2014,0x2014,0x2014}, {0,0x2015,0x2015,0x2015}, {0,0x2016,0x2016,0x2016}, {0,0x2017,0x2017,0x2017},
 {0,0x2018,0x2018,0x2018}, {0,0x2019,0x2019,0x2019}, {0,0x201A,0x201A,0x201A}, {0,0x201B,0x201B,0x201B},
 {0,0x201C,0x201C,0x201C}, {0,0x201D,0x201D,0x201D}, {0,0x201E,0x201E,0x201E}, {0,0x201F,0x201F,0x201F},
 {0,0x2020,0x2020,0x2020}, {0,0x2021,0x2021,0x2021}, {0,0x2022,0x2022,0x2022}, {0,0x2023,0x2023,0x2023},
 {0,0x2024,0x2024,0x2024}, {0,0x2025,0x2025,0x2025}, {0,0x2026,0x2026,0x2026}, {0,0x2027,0x2027,0x2027},
 {0,0x2028,0x2028,0x2028}, {0,0x2029,0x2029,0x2029}, {0,0x202A,0x202A,0x202A}, {0,0x202B,0x202B,0x202B},
 {0,0x202C,0x202C,0x202C}, {0,0x202D,0x202D,0x202D}, {0,0x202E,0x202E,0x202E}, {0,0x202F,0x202F,0x202F},
 {0,0x2030,0x2030,0x2030}, {0,0x2031,0x2031,0x2031}, {0,0x2032,0x2032,0x2032}, {0,0x2033,0x2033,0x2033},
 {0,0x2034,0x2034,0x2034}, {0,0x2035,0x2035,0x2035}, {0,0x2036,0x2036,0x2036}, {0,0x2037,0x2037,0x2037},
 {0,0x2038,0x2038,0x2038}, {0,0x2039,0x2039,0x2039}, {0,0x203A,0x203A,0x203A}, {0,0x203B,0x203B,0x203B},
 {0,0x203C,0x203C,0x203C}, {0,0x203D,0x203D,0x203D}, {0,0x203E,0x203E,0x203E}, {0,0x203F,0x203F,0x203F},
 {0,0x2040,0x2040,0x2040}, {0,0x2041,0x2041,0x2041}, {0,0x2042,0x2042,0x2042}, {0,0x2043,0x2043,0x2043},
 {0,0x2044,0x2044,0x2044}, {0,0x2045,0x2045,0x2045}, {0,0x2046,0x2046,0x2046}, {0,0x2047,0x2047,0x2047},
 {0,0x2048,0x2048,0x2048}, {0,0x2049,0x2049,0x2049}, {0,0x204A,0x204A,0x204A}, {0,0x204B,0x204B,0x204B},
 {0,0x204C,0x204C,0x204C}, {0,0x204D,0x204D,0x204D}, {0,0x204E,0x204E,0x204E}, {0,0x204F,0x204F,0x204F},
 {0,0x2050,0x2050,0x2050}, {0,0x2051,0x2051,0x2051}, {0,0x2052,0x2052,0x2052}, {0,0x2053,0x2053,0x2053},
 {0,0x2054,0x2054,0x2054}, {0,0x2055,0x2055,0x2055}, {0,0x2056,0x2056,0x2056}, {0,0x2057,0x2057,0x2057},
 {0,0x2058,0x2058,0x2058}, {0,0x2059,0x2059,0x2059}, {0,0x205A,0x205A,0x205A}, {0,0x205B,0x205B,0x205B},
 {0,0x205C,0x205C,0x205C}, {0,0x205D,0x205D,0x205D}, {0,0x205E,0x205E,0x205E}, {0,0x205F,0x205F,0x205F},
 {0,0x2060,0x2060,0x2060}, {0,0x2061,0x2061,0x2061}, {0,0x2062,0x2062,0x2062}, {0,0x2063,0x2063,0x2063},
 {0,0x2064,0x2064,0x2064}, {0,0x2065,0x2065,0x2065}, {0,0x2066,0x2066,0x2066}, {0,0x2067,0x2067,0x2067},
 {0,0x2068,0x2068,0x2068}, {0,0x2069,0x2069,0x2069}, {0,0x206A,0x206A,0x206A}, {0,0x206B,0x206B,0x206B},
 {0,0x206C,0x206C,0x206C}, {0,0x206D,0x206D,0x206D}, {0,0x206E,0x206E,0x206E}, {0,0x206F,0x206F,0x206F},
 {0,0x2070,0x2070,0x2070}, {0,0x2071,0x2071,0x2071}, {0,0x2072,0x2072,0x2072}, {0,0x2073,0x2073,0x2073},
 {0,0x2074,0x2074,0x2074}, {0,0x2075,0x2075,0x2075}, {0,0x2076,0x2076,0x2076}, {0,0x2077,0x2077,0x2077},
 {0,0x2078,0x2078,0x2078}, {0,0x2079,0x2079,0x2079}, {0,0x207A,0x207A,0x207A}, {0,0x207B,0x207B,0x207B},
 {0,0x207C,0x207C,0x207C}, {0,0x207D,0x207D,0x207D}, {0,0x207E,0x207E,0x207E}, {1,0x207F,0x207F,0x207F},
 {0,0x2080,0x2080,0x2080}, {0,0x2081,0x2081,0x2081}, {0,0x2082,0x2082,0x2082}, {0,0x2083,0x2083,0x2083},
 {0,0x2084,0x2084,0x2084}, {0,0x2085,0x2085,0x2085}, {0,0x2086,0x2086,0x2086}, {0,0x2087,0x2087,0x2087},
 {0,0x2088,0x2088,0x2088}, {0,0x2089,0x2089,0x2089}, {0,0x208A,0x208A,0x208A}, {0,0x208B,0x208B,0x208B},
 {0,0x208C,0x208C,0x208C}, {0,0x208D,0x208D,0x208D}, {0,0x208E,0x208E,0x208E}, {0,0x208F,0x208F,0x208F},
 {0,0x2090,0x2090,0x2090}, {0,0x2091,0x2091,0x2091}, {0,0x2092,0x2092,0x2092}, {0,0x2093,0x2093,0x2093},
 {0,0x2094,0x2094,0x2094}, {0,0x2095,0x2095,0x2095}, {0,0x2096,0x2096,0x2096}, {0,0x2097,0x2097,0x2097},
 {0,0x2098,0x2098,0x2098}, {0,0x2099,0x2099,0x2099}, {0,0x209A,0x209A,0x209A}, {0,0x209B,0x209B,0x209B},
 {0,0x209C,0x209C,0x209C}, {0,0x209D,0x209D,0x209D}, {0,0x209E,0x209E,0x209E}, {0,0x209F,0x209F,0x209F},
 {0,0x20A0,0x20A0,0x20A0}, {0,0x20A1,0x20A1,0x20A1}, {0,0x20A2,0x20A2,0x20A2}, {0,0x20A3,0x20A3,0x20A3},
 {0,0x20A4,0x20A4,0x20A4}, {0,0x20A5,0x20A5,0x20A5}, {0,0x20A6,0x20A6,0x20A6}, {0,0x20A7,0x20A7,0x20A7},
 {0,0x20A8,0x20A8,0x20A8}, {0,0x20A9,0x20A9,0x20A9}, {0,0x20AA,0x20AA,0x20AA}, {0,0x20AB,0x20AB,0x20AB},
 {0,0x20AC,0x20AC,0x20AC}, {0,0x20AD,0x20AD,0x20AD}, {0,0x20AE,0x20AE,0x20AE}, {0,0x20AF,0x20AF,0x20AF},
 {0,0x20B0,0x20B0,0x20B0}, {0,0x20B1,0x20B1,0x20B1}, {0,0x20B2,0x20B2,0x20B2}, {0,0x20B3,0x20B3,0x20B3},
 {0,0x20B4,0x20B4,0x20B4}, {0,0x20B5,0x20B5,0x20B5}, {0,0x20B6,0x20B6,0x20B6}, {0,0x20B7,0x20B7,0x20B7},
 {0,0x20B8,0x20B8,0x20B8}, {0,0x20B9,0x20B9,0x20B9}, {0,0x20BA,0x20BA,0x20BA}, {0,0x20BB,0x20BB,0x20BB},
 {0,0x20BC,0x20BC,0x20BC}, {0,0x20BD,0x20BD,0x20BD}, {0,0x20BE,0x20BE,0x20BE}, {0,0x20BF,0x20BF,0x20BF},
 {0,0x20C0,0x20C0,0x20C0}, {0,0x20C1,0x20C1,0x20C1}, {0,0x20C2,0x20C2,0x20C2}, {0,0x20C3,0x20C3,0x20C3},
 {0,0x20C4,0x20C4,0x20C4}, {0,0x20C5,0x20C5,0x20C5}, {0,0x20C6,0x20C6,0x20C6}, {0,0x20C7,0x20C7,0x20C7},
 {0,0x20C8,0x20C8,0x20C8}, {0,0x20C9,0x20C9,0x20C9}, {0,0x20CA,0x20CA,0x20CA}, {0,0x20CB,0x20CB,0x20CB},
 {0,0x20CC,0x20CC,0x20CC}, {0,0x20CD,0x20CD,0x20CD}, {0,0x20CE,0x20CE,0x20CE}, {0,0x20CF,0x20CF,0x20CF},
 {1,0x20D0,0x20D0,0x20D0}, {1,0x20D1,0x20D1,0x20D1}, {1,0x20D2,0x20D2,0x20D2}, {1,0x20D3,0x20D3,0x20D3},
 {1,0x20D4,0x20D4,0x20D4}, {1,0x20D5,0x20D5,0x20D5}, {1,0x20D6,0x20D6,0x20D6}, {1,0x20D7,0x20D7,0x20D7},
 {1,0x20D8,0x20D8,0x20D8}, {1,0x20D9,0x20D9,0x20D9}, {1,0x20DA,0x20DA,0x20DA}, {1,0x20DB,0x20DB,0x20DB},
 {1,0x20DC,0x20DC,0x20DC}, {0,0x20DD,0x20DD,0x20DD}, {0,0x20DE,0x20DE,0x20DE}, {0,0x20DF,0x20DF,0x20DF},
 {0,0x20E0,0x20E0,0x20E0}, {1,0x20E1,0x20E1,0x20E1}, {0,0x20E2,0x20E2,0x20E2}, {0,0x20E3,0x20E3,0x20E3},
 {0,0x20E4,0x20E4,0x20E4}, {0,0x20E5,0x20E5,0x20E5}, {0,0x20E6,0x20E6,0x20E6}, {0,0x20E7,0x20E7,0x20E7},
 {0,0x20E8,0x20E8,0x20E8}, {0,0x20E9,0x20E9,0x20E9}, {0,0x20EA,0x20EA,0x20EA}, {0,0x20EB,0x20EB,0x20EB},
 {0,0x20EC,0x20EC,0x20EC}, {0,0x20ED,0x20ED,0x20ED}, {0,0x20EE,0x20EE,0x20EE}, {0,0x20EF,0x20EF,0x20EF},
 {0,0x20F0,0x20F0,0x20F0}, {0,0x20F1,0x20F1,0x20F1}, {0,0x20F2,0x20F2,0x20F2}, {0,0x20F3,0x20F3,0x20F3},
 {0,0x20F4,0x20F4,0x20F4}, {0,0x20F5,0x20F5,0x20F5}, {0,0x20F6,0x20F6,0x20F6}, {0,0x20F7,0x20F7,0x20F7},
 {0,0x20F8,0x20F8,0x20F8}, {0,0x20F9,0x20F9,0x20F9}, {0,0x20FA,0x20FA,0x20FA}, {0,0x20FB,0x20FB,0x20FB},
 {0,0x20FC,0x20FC,0x20FC}, {0,0x20FD,0x20FD,0x20FD}, {0,0x20FE,0x20FE,0x20FE}, {0,0x20FF,0x20FF,0x20FF},
{0,0}};

static UDM_UNICODE plane21[257]={
 {0,0x2100,0x2100,0x2100}, {0,0x2101,0x2101,0x2101}, {1,0x2102,0x2102,0x2102}, {0,0x2103,0x2103,0x2103},
 {0,0x2104,0x2104,0x2104}, {0,0x2105,0x2105,0x2105}, {0,0x2106,0x2106,0x2106}, {1,0x2107,0x2107,0x2107},
 {0,0x2108,0x2108,0x2108}, {0,0x2109,0x2109,0x2109}, {1,0x210A,0x210A,0x210A}, {1,0x210B,0x210B,0x210B},
 {1,0x210C,0x210C,0x210C}, {1,0x210D,0x210D,0x210D}, {1,0x210E,0x210E,0x210E}, {1,0x210F,0x210F,0x210F},
 {1,0x2110,0x2110,0x2110}, {1,0x2111,0x2111,0x2111}, {1,0x2112,0x2112,0x2112}, {1,0x2113,0x2113,0x2113},
 {0,0x2114,0x2114,0x2114}, {1,0x2115,0x2115,0x2115}, {0,0x2116,0x2116,0x2116}, {0,0x2117,0x2117,0x2117},
 {0,0x2118,0x2118,0x2118}, {1,0x2119,0x2119,0x2119}, {1,0x211A,0x211A,0x211A}, {1,0x211B,0x211B,0x211B},
 {1,0x211C,0x211C,0x211C}, {1,0x211D,0x211D,0x211D}, {0,0x211E,0x211E,0x211E}, {0,0x211F,0x211F,0x211F},
 {0,0x2120,0x2120,0x2120}, {0,0x2121,0x2121,0x2121}, {0,0x2122,0x2122,0x2122}, {0,0x2123,0x2123,0x2123},
 {1,0x2124,0x2124,0x2124}, {0,0x2125,0x2125,0x2125}, {1,0x03C9,0x2126,0x03C9}, {0,0x2127,0x2127,0x2127},
 {1,0x2128,0x2128,0x2128}, {0,0x2129,0x2129,0x2129}, {1,0x006B,0x212A,0x006B}, {1,0x00E5,0x212B,0x00E5},
 {1,0x212C,0x212C,0x212C}, {1,0x212D,0x212D,0x212D}, {0,0x212E,0x212E,0x212E}, {1,0x212F,0x212F,0x212F},
 {1,0x2130,0x2130,0x2130}, {1,0x2131,0x2131,0x2131}, {0,0x2132,0x2132,0x2132}, {1,0x2133,0x2133,0x2133},
 {1,0x2134,0x2134,0x2134}, {1,0x2135,0x2135,0x2135}, {1,0x2136,0x2136,0x2136}, {1,0x2137,0x2137,0x2137},
 {1,0x2138,0x2138,0x2138}, {1,0x2139,0x2139,0x2139}, {0,0x213A,0x213A,0x213A}, {0,0x213B,0x213B,0x213B},
 {0,0x213C,0x213C,0x213C}, {0,0x213D,0x213D,0x213D}, {0,0x213E,0x213E,0x213E}, {0,0x213F,0x213F,0x213F},
 {0,0x2140,0x2140,0x2140}, {0,0x2141,0x2141,0x2141}, {0,0x2142,0x2142,0x2142}, {0,0x2143,0x2143,0x2143},
 {0,0x2144,0x2144,0x2144}, {0,0x2145,0x2145,0x2145}, {0,0x2146,0x2146,0x2146}, {0,0x2147,0x2147,0x2147},
 {0,0x2148,0x2148,0x2148}, {0,0x2149,0x2149,0x2149}, {0,0x214A,0x214A,0x214A}, {0,0x214B,0x214B,0x214B},
 {0,0x214C,0x214C,0x214C}, {0,0x214D,0x214D,0x214D}, {0,0x214E,0x214E,0x214E}, {0,0x214F,0x214F,0x214F},
 {0,0x2150,0x2150,0x2150}, {0,0x2151,0x2151,0x2151}, {0,0x2152,0x2152,0x2152}, {0,0x2153,0x2153,0x2153},
 {0,0x2154,0x2154,0x2154}, {0,0x2155,0x2155,0x2155}, {0,0x2156,0x2156,0x2156}, {0,0x2157,0x2157,0x2157},
 {0,0x2158,0x2158,0x2158}, {0,0x2159,0x2159,0x2159}, {0,0x215A,0x215A,0x215A}, {0,0x215B,0x215B,0x215B},
 {0,0x215C,0x215C,0x215C}, {0,0x215D,0x215D,0x215D}, {0,0x215E,0x215E,0x215E}, {0,0x215F,0x215F,0x215F},
 {0,0x2170,0x2160,0x2170}, {0,0x2171,0x2161,0x2171}, {0,0x2172,0x2162,0x2172}, {0,0x2173,0x2163,0x2173},
 {0,0x2174,0x2164,0x2174}, {0,0x2175,0x2165,0x2175}, {0,0x2176,0x2166,0x2176}, {0,0x2177,0x2167,0x2177},
 {0,0x2178,0x2168,0x2178}, {0,0x2179,0x2169,0x2179}, {0,0x217A,0x216A,0x217A}, {0,0x217B,0x216B,0x217B},
 {0,0x217C,0x216C,0x217C}, {0,0x217D,0x216D,0x217D}, {0,0x217E,0x216E,0x217E}, {0,0x217F,0x216F,0x217F},
 {0,0x2170,0x2170,0x2170}, {0,0x2171,0x2171,0x2171}, {0,0x2172,0x2172,0x2172}, {0,0x2173,0x2173,0x2173},
 {0,0x2174,0x2174,0x2174}, {0,0x2175,0x2175,0x2175}, {0,0x2176,0x2176,0x2176}, {0,0x2177,0x2177,0x2177},
 {0,0x2178,0x2178,0x2178}, {0,0x2179,0x2179,0x2179}, {0,0x217A,0x217A,0x217A}, {0,0x217B,0x217B,0x217B},
 {0,0x217C,0x217C,0x217C}, {0,0x217D,0x217D,0x217D}, {0,0x217E,0x217E,0x217E}, {0,0x217F,0x217F,0x217F},
 {0,0x2180,0x2180,0x2180}, {0,0x2181,0x2181,0x2181}, {0,0x2182,0x2182,0x2182}, {0,0x2183,0x2183,0x2183},
 {0,0x2184,0x2184,0x2184}, {0,0x2185,0x2185,0x2185}, {0,0x2186,0x2186,0x2186}, {0,0x2187,0x2187,0x2187},
 {0,0x2188,0x2188,0x2188}, {0,0x2189,0x2189,0x2189}, {0,0x218A,0x218A,0x218A}, {0,0x218B,0x218B,0x218B},
 {0,0x218C,0x218C,0x218C}, {0,0x218D,0x218D,0x218D}, {0,0x218E,0x218E,0x218E}, {0,0x218F,0x218F,0x218F},
 {0,0x2190,0x2190,0x2190}, {0,0x2191,0x2191,0x2191}, {0,0x2192,0x2192,0x2192}, {0,0x2193,0x2193,0x2193},
 {0,0x2194,0x2194,0x2194}, {0,0x2195,0x2195,0x2195}, {0,0x2196,0x2196,0x2196}, {0,0x2197,0x2197,0x2197},
 {0,0x2198,0x2198,0x2198}, {0,0x2199,0x2199,0x2199}, {0,0x219A,0x219A,0x219A}, {0,0x219B,0x219B,0x219B},
 {0,0x219C,0x219C,0x219C}, {0,0x219D,0x219D,0x219D}, {0,0x219E,0x219E,0x219E}, {0,0x219F,0x219F,0x219F},
 {0,0x21A0,0x21A0,0x21A0}, {0,0x21A1,0x21A1,0x21A1}, {0,0x21A2,0x21A2,0x21A2}, {0,0x21A3,0x21A3,0x21A3},
 {0,0x21A4,0x21A4,0x21A4}, {0,0x21A5,0x21A5,0x21A5}, {0,0x21A6,0x21A6,0x21A6}, {0,0x21A7,0x21A7,0x21A7},
 {0,0x21A8,0x21A8,0x21A8}, {0,0x21A9,0x21A9,0x21A9}, {0,0x21AA,0x21AA,0x21AA}, {0,0x21AB,0x21AB,0x21AB},
 {0,0x21AC,0x21AC,0x21AC}, {0,0x21AD,0x21AD,0x21AD}, {0,0x21AE,0x21AE,0x21AE}, {0,0x21AF,0x21AF,0x21AF},
 {0,0x21B0,0x21B0,0x21B0}, {0,0x21B1,0x21B1,0x21B1}, {0,0x21B2,0x21B2,0x21B2}, {0,0x21B3,0x21B3,0x21B3},
 {0,0x21B4,0x21B4,0x21B4}, {0,0x21B5,0x21B5,0x21B5}, {0,0x21B6,0x21B6,0x21B6}, {0,0x21B7,0x21B7,0x21B7},
 {0,0x21B8,0x21B8,0x21B8}, {0,0x21B9,0x21B9,0x21B9}, {0,0x21BA,0x21BA,0x21BA}, {0,0x21BB,0x21BB,0x21BB},
 {0,0x21BC,0x21BC,0x21BC}, {0,0x21BD,0x21BD,0x21BD}, {0,0x21BE,0x21BE,0x21BE}, {0,0x21BF,0x21BF,0x21BF},
 {0,0x21C0,0x21C0,0x21C0}, {0,0x21C1,0x21C1,0x21C1}, {0,0x21C2,0x21C2,0x21C2}, {0,0x21C3,0x21C3,0x21C3},
 {0,0x21C4,0x21C4,0x21C4}, {0,0x21C5,0x21C5,0x21C5}, {0,0x21C6,0x21C6,0x21C6}, {0,0x21C7,0x21C7,0x21C7},
 {0,0x21C8,0x21C8,0x21C8}, {0,0x21C9,0x21C9,0x21C9}, {0,0x21CA,0x21CA,0x21CA}, {0,0x21CB,0x21CB,0x21CB},
 {0,0x21CC,0x21CC,0x21CC}, {0,0x21CD,0x21CD,0x21CD}, {0,0x21CE,0x21CE,0x21CE}, {0,0x21CF,0x21CF,0x21CF},
 {0,0x21D0,0x21D0,0x21D0}, {0,0x21D1,0x21D1,0x21D1}, {0,0x21D2,0x21D2,0x21D2}, {0,0x21D3,0x21D3,0x21D3},
 {0,0x21D4,0x21D4,0x21D4}, {0,0x21D5,0x21D5,0x21D5}, {0,0x21D6,0x21D6,0x21D6}, {0,0x21D7,0x21D7,0x21D7},
 {0,0x21D8,0x21D8,0x21D8}, {0,0x21D9,0x21D9,0x21D9}, {0,0x21DA,0x21DA,0x21DA}, {0,0x21DB,0x21DB,0x21DB},
 {0,0x21DC,0x21DC,0x21DC}, {0,0x21DD,0x21DD,0x21DD}, {0,0x21DE,0x21DE,0x21DE}, {0,0x21DF,0x21DF,0x21DF},
 {0,0x21E0,0x21E0,0x21E0}, {0,0x21E1,0x21E1,0x21E1}, {0,0x21E2,0x21E2,0x21E2}, {0,0x21E3,0x21E3,0x21E3},
 {0,0x21E4,0x21E4,0x21E4}, {0,0x21E5,0x21E5,0x21E5}, {0,0x21E6,0x21E6,0x21E6}, {0,0x21E7,0x21E7,0x21E7},
 {0,0x21E8,0x21E8,0x21E8}, {0,0x21E9,0x21E9,0x21E9}, {0,0x21EA,0x21EA,0x21EA}, {0,0x21EB,0x21EB,0x21EB},
 {0,0x21EC,0x21EC,0x21EC}, {0,0x21ED,0x21ED,0x21ED}, {0,0x21EE,0x21EE,0x21EE}, {0,0x21EF,0x21EF,0x21EF},
 {0,0x21F0,0x21F0,0x21F0}, {0,0x21F1,0x21F1,0x21F1}, {0,0x21F2,0x21F2,0x21F2}, {0,0x21F3,0x21F3,0x21F3},
 {0,0x21F4,0x21F4,0x21F4}, {0,0x21F5,0x21F5,0x21F5}, {0,0x21F6,0x21F6,0x21F6}, {0,0x21F7,0x21F7,0x21F7},
 {0,0x21F8,0x21F8,0x21F8}, {0,0x21F9,0x21F9,0x21F9}, {0,0x21FA,0x21FA,0x21FA}, {0,0x21FB,0x21FB,0x21FB},
 {0,0x21FC,0x21FC,0x21FC}, {0,0x21FD,0x21FD,0x21FD}, {0,0x21FE,0x21FE,0x21FE}, {0,0x21FF,0x21FF,0x21FF},
{0,0}};

static UDM_UNICODE plane24[257]={
 {0,0x2400,0x2400,0x2400}, {0,0x2401,0x2401,0x2401}, {0,0x2402,0x2402,0x2402}, {0,0x2403,0x2403,0x2403},
 {0,0x2404,0x2404,0x2404}, {0,0x2405,0x2405,0x2405}, {0,0x2406,0x2406,0x2406}, {0,0x2407,0x2407,0x2407},
 {0,0x2408,0x2408,0x2408}, {0,0x2409,0x2409,0x2409}, {0,0x240A,0x240A,0x240A}, {0,0x240B,0x240B,0x240B},
 {0,0x240C,0x240C,0x240C}, {0,0x240D,0x240D,0x240D}, {0,0x240E,0x240E,0x240E}, {0,0x240F,0x240F,0x240F},
 {0,0x2410,0x2410,0x2410}, {0,0x2411,0x2411,0x2411}, {0,0x2412,0x2412,0x2412}, {0,0x2413,0x2413,0x2413},
 {0,0x2414,0x2414,0x2414}, {0,0x2415,0x2415,0x2415}, {0,0x2416,0x2416,0x2416}, {0,0x2417,0x2417,0x2417},
 {0,0x2418,0x2418,0x2418}, {0,0x2419,0x2419,0x2419}, {0,0x241A,0x241A,0x241A}, {0,0x241B,0x241B,0x241B},
 {0,0x241C,0x241C,0x241C}, {0,0x241D,0x241D,0x241D}, {0,0x241E,0x241E,0x241E}, {0,0x241F,0x241F,0x241F},
 {0,0x2420,0x2420,0x2420}, {0,0x2421,0x2421,0x2421}, {0,0x2422,0x2422,0x2422}, {0,0x2423,0x2423,0x2423},
 {0,0x2424,0x2424,0x2424}, {0,0x2425,0x2425,0x2425}, {0,0x2426,0x2426,0x2426}, {0,0x2427,0x2427,0x2427},
 {0,0x2428,0x2428,0x2428}, {0,0x2429,0x2429,0x2429}, {0,0x242A,0x242A,0x242A}, {0,0x242B,0x242B,0x242B},
 {0,0x242C,0x242C,0x242C}, {0,0x242D,0x242D,0x242D}, {0,0x242E,0x242E,0x242E}, {0,0x242F,0x242F,0x242F},
 {0,0x2430,0x2430,0x2430}, {0,0x2431,0x2431,0x2431}, {0,0x2432,0x2432,0x2432}, {0,0x2433,0x2433,0x2433},
 {0,0x2434,0x2434,0x2434}, {0,0x2435,0x2435,0x2435}, {0,0x2436,0x2436,0x2436}, {0,0x2437,0x2437,0x2437},
 {0,0x2438,0x2438,0x2438}, {0,0x2439,0x2439,0x2439}, {0,0x243A,0x243A,0x243A}, {0,0x243B,0x243B,0x243B},
 {0,0x243C,0x243C,0x243C}, {0,0x243D,0x243D,0x243D}, {0,0x243E,0x243E,0x243E}, {0,0x243F,0x243F,0x243F},
 {0,0x2440,0x2440,0x2440}, {0,0x2441,0x2441,0x2441}, {0,0x2442,0x2442,0x2442}, {0,0x2443,0x2443,0x2443},
 {0,0x2444,0x2444,0x2444}, {0,0x2445,0x2445,0x2445}, {0,0x2446,0x2446,0x2446}, {0,0x2447,0x2447,0x2447},
 {0,0x2448,0x2448,0x2448}, {0,0x2449,0x2449,0x2449}, {0,0x244A,0x244A,0x244A}, {0,0x244B,0x244B,0x244B},
 {0,0x244C,0x244C,0x244C}, {0,0x244D,0x244D,0x244D}, {0,0x244E,0x244E,0x244E}, {0,0x244F,0x244F,0x244F},
 {0,0x2450,0x2450,0x2450}, {0,0x2451,0x2451,0x2451}, {0,0x2452,0x2452,0x2452}, {0,0x2453,0x2453,0x2453},
 {0,0x2454,0x2454,0x2454}, {0,0x2455,0x2455,0x2455}, {0,0x2456,0x2456,0x2456}, {0,0x2457,0x2457,0x2457},
 {0,0x2458,0x2458,0x2458}, {0,0x2459,0x2459,0x2459}, {0,0x245A,0x245A,0x245A}, {0,0x245B,0x245B,0x245B},
 {0,0x245C,0x245C,0x245C}, {0,0x245D,0x245D,0x245D}, {0,0x245E,0x245E,0x245E}, {0,0x245F,0x245F,0x245F},
 {0,0x2460,0x2460,0x2460}, {0,0x2461,0x2461,0x2461}, {0,0x2462,0x2462,0x2462}, {0,0x2463,0x2463,0x2463},
 {0,0x2464,0x2464,0x2464}, {0,0x2465,0x2465,0x2465}, {0,0x2466,0x2466,0x2466}, {0,0x2467,0x2467,0x2467},
 {0,0x2468,0x2468,0x2468}, {0,0x2469,0x2469,0x2469}, {0,0x246A,0x246A,0x246A}, {0,0x246B,0x246B,0x246B},
 {0,0x246C,0x246C,0x246C}, {0,0x246D,0x246D,0x246D}, {0,0x246E,0x246E,0x246E}, {0,0x246F,0x246F,0x246F},
 {0,0x2470,0x2470,0x2470}, {0,0x2471,0x2471,0x2471}, {0,0x2472,0x2472,0x2472}, {0,0x2473,0x2473,0x2473},
 {0,0x2474,0x2474,0x2474}, {0,0x2475,0x2475,0x2475}, {0,0x2476,0x2476,0x2476}, {0,0x2477,0x2477,0x2477},
 {0,0x2478,0x2478,0x2478}, {0,0x2479,0x2479,0x2479}, {0,0x247A,0x247A,0x247A}, {0,0x247B,0x247B,0x247B},
 {0,0x247C,0x247C,0x247C}, {0,0x247D,0x247D,0x247D}, {0,0x247E,0x247E,0x247E}, {0,0x247F,0x247F,0x247F},
 {0,0x2480,0x2480,0x2480}, {0,0x2481,0x2481,0x2481}, {0,0x2482,0x2482,0x2482}, {0,0x2483,0x2483,0x2483},
 {0,0x2484,0x2484,0x2484}, {0,0x2485,0x2485,0x2485}, {0,0x2486,0x2486,0x2486}, {0,0x2487,0x2487,0x2487},
 {0,0x2488,0x2488,0x2488}, {0,0x2489,0x2489,0x2489}, {0,0x248A,0x248A,0x248A}, {0,0x248B,0x248B,0x248B},
 {0,0x248C,0x248C,0x248C}, {0,0x248D,0x248D,0x248D}, {0,0x248E,0x248E,0x248E}, {0,0x248F,0x248F,0x248F},
 {0,0x2490,0x2490,0x2490}, {0,0x2491,0x2491,0x2491}, {0,0x2492,0x2492,0x2492}, {0,0x2493,0x2493,0x2493},
 {0,0x2494,0x2494,0x2494}, {0,0x2495,0x2495,0x2495}, {0,0x2496,0x2496,0x2496}, {0,0x2497,0x2497,0x2497},
 {0,0x2498,0x2498,0x2498}, {0,0x2499,0x2499,0x2499}, {0,0x249A,0x249A,0x249A}, {0,0x249B,0x249B,0x249B},
 {0,0x249C,0x249C,0x249C}, {0,0x249D,0x249D,0x249D}, {0,0x249E,0x249E,0x249E}, {0,0x249F,0x249F,0x249F},
 {0,0x24A0,0x24A0,0x24A0}, {0,0x24A1,0x24A1,0x24A1}, {0,0x24A2,0x24A2,0x24A2}, {0,0x24A3,0x24A3,0x24A3},
 {0,0x24A4,0x24A4,0x24A4}, {0,0x24A5,0x24A5,0x24A5}, {0,0x24A6,0x24A6,0x24A6}, {0,0x24A7,0x24A7,0x24A7},
 {0,0x24A8,0x24A8,0x24A8}, {0,0x24A9,0x24A9,0x24A9}, {0,0x24AA,0x24AA,0x24AA}, {0,0x24AB,0x24AB,0x24AB},
 {0,0x24AC,0x24AC,0x24AC}, {0,0x24AD,0x24AD,0x24AD}, {0,0x24AE,0x24AE,0x24AE}, {0,0x24AF,0x24AF,0x24AF},
 {0,0x24B0,0x24B0,0x24B0}, {0,0x24B1,0x24B1,0x24B1}, {0,0x24B2,0x24B2,0x24B2}, {0,0x24B3,0x24B3,0x24B3},
 {0,0x24B4,0x24B4,0x24B4}, {0,0x24B5,0x24B5,0x24B5}, {0,0x24D0,0x24B6,0x24D0}, {0,0x24D1,0x24B7,0x24D1},
 {0,0x24D2,0x24B8,0x24D2}, {0,0x24D3,0x24B9,0x24D3}, {0,0x24D4,0x24BA,0x24D4}, {0,0x24D5,0x24BB,0x24D5},
 {0,0x24D6,0x24BC,0x24D6}, {0,0x24D7,0x24BD,0x24D7}, {0,0x24D8,0x24BE,0x24D8}, {0,0x24D9,0x24BF,0x24D9},
 {0,0x24DA,0x24C0,0x24DA}, {0,0x24DB,0x24C1,0x24DB}, {0,0x24DC,0x24C2,0x24DC}, {0,0x24DD,0x24C3,0x24DD},
 {0,0x24DE,0x24C4,0x24DE}, {0,0x24DF,0x24C5,0x24DF}, {0,0x24E0,0x24C6,0x24E0}, {0,0x24E1,0x24C7,0x24E1},
 {0,0x24E2,0x24C8,0x24E2}, {0,0x24E3,0x24C9,0x24E3}, {0,0x24E4,0x24CA,0x24E4}, {0,0x24E5,0x24CB,0x24E5},
 {0,0x24E6,0x24CC,0x24E6}, {0,0x24E7,0x24CD,0x24E7}, {0,0x24E8,0x24CE,0x24E8}, {0,0x24E9,0x24CF,0x24E9},
 {0,0x24D0,0x24D0,0x24D0}, {0,0x24D1,0x24D1,0x24D1}, {0,0x24D2,0x24D2,0x24D2}, {0,0x24D3,0x24D3,0x24D3},
 {0,0x24D4,0x24D4,0x24D4}, {0,0x24D5,0x24D5,0x24D5}, {0,0x24D6,0x24D6,0x24D6}, {0,0x24D7,0x24D7,0x24D7},
 {0,0x24D8,0x24D8,0x24D8}, {0,0x24D9,0x24D9,0x24D9}, {0,0x24DA,0x24DA,0x24DA}, {0,0x24DB,0x24DB,0x24DB},
 {0,0x24DC,0x24DC,0x24DC}, {0,0x24DD,0x24DD,0x24DD}, {0,0x24DE,0x24DE,0x24DE}, {0,0x24DF,0x24DF,0x24DF},
 {0,0x24E0,0x24E0,0x24E0}, {0,0x24E1,0x24E1,0x24E1}, {0,0x24E2,0x24E2,0x24E2}, {0,0x24E3,0x24E3,0x24E3},
 {0,0x24E4,0x24E4,0x24E4}, {0,0x24E5,0x24E5,0x24E5}, {0,0x24E6,0x24E6,0x24E6}, {0,0x24E7,0x24E7,0x24E7},
 {0,0x24E8,0x24E8,0x24E8}, {0,0x24E9,0x24E9,0x24E9}, {0,0x24EA,0x24EA,0x24EA}, {0,0x24EB,0x24EB,0x24EB},
 {0,0x24EC,0x24EC,0x24EC}, {0,0x24ED,0x24ED,0x24ED}, {0,0x24EE,0x24EE,0x24EE}, {0,0x24EF,0x24EF,0x24EF},
 {0,0x24F0,0x24F0,0x24F0}, {0,0x24F1,0x24F1,0x24F1}, {0,0x24F2,0x24F2,0x24F2}, {0,0x24F3,0x24F3,0x24F3},
 {0,0x24F4,0x24F4,0x24F4}, {0,0x24F5,0x24F5,0x24F5}, {0,0x24F6,0x24F6,0x24F6}, {0,0x24F7,0x24F7,0x24F7},
 {0,0x24F8,0x24F8,0x24F8}, {0,0x24F9,0x24F9,0x24F9}, {0,0x24FA,0x24FA,0x24FA}, {0,0x24FB,0x24FB,0x24FB},
 {0,0x24FC,0x24FC,0x24FC}, {0,0x24FD,0x24FD,0x24FD}, {0,0x24FE,0x24FE,0x24FE}, {0,0x24FF,0x24FF,0x24FF},
{0,0}};

static UDM_UNICODE plane30[257]={
 {0,0x3000,0x3000,0x3000}, {0,0x3001,0x3001,0x3001}, {0,0x3002,0x3002,0x3002}, {0,0x3003,0x3003,0x3003},
 {0,0x3004,0x3004,0x3004}, {1,0x3005,0x3005,0x3005}, {1,0x3006,0x3006,0x3006}, {0,0x3007,0x3007,0x3007},
 {0,0x3008,0x3008,0x3008}, {0,0x3009,0x3009,0x3009}, {0,0x300A,0x300A,0x300A}, {0,0x300B,0x300B,0x300B},
 {0,0x300C,0x300C,0x300C}, {0,0x300D,0x300D,0x300D}, {0,0x300E,0x300E,0x300E}, {0,0x300F,0x300F,0x300F},
 {0,0x3010,0x3010,0x3010}, {0,0x3011,0x3011,0x3011}, {0,0x3012,0x3012,0x3012}, {0,0x3013,0x3013,0x3013},
 {0,0x3014,0x3014,0x3014}, {0,0x3015,0x3015,0x3015}, {0,0x3016,0x3016,0x3016}, {0,0x3017,0x3017,0x3017},
 {0,0x3018,0x3018,0x3018}, {0,0x3019,0x3019,0x3019}, {0,0x301A,0x301A,0x301A}, {0,0x301B,0x301B,0x301B},
 {0,0x301C,0x301C,0x301C}, {0,0x301D,0x301D,0x301D}, {0,0x301E,0x301E,0x301E}, {0,0x301F,0x301F,0x301F},
 {0,0x3020,0x3020,0x3020}, {0,0x3021,0x3021,0x3021}, {0,0x3022,0x3022,0x3022}, {0,0x3023,0x3023,0x3023},
 {0,0x3024,0x3024,0x3024}, {0,0x3025,0x3025,0x3025}, {0,0x3026,0x3026,0x3026}, {0,0x3027,0x3027,0x3027},
 {0,0x3028,0x3028,0x3028}, {0,0x3029,0x3029,0x3029}, {1,0x302A,0x302A,0x302A}, {1,0x302B,0x302B,0x302B},
 {1,0x302C,0x302C,0x302C}, {1,0x302D,0x302D,0x302D}, {1,0x302E,0x302E,0x302E}, {1,0x302F,0x302F,0x302F},
 {0,0x3030,0x3030,0x3030}, {1,0x3031,0x3031,0x3031}, {1,0x3032,0x3032,0x3032}, {1,0x3033,0x3033,0x3033},
 {1,0x3034,0x3034,0x3034}, {1,0x3035,0x3035,0x3035}, {0,0x3036,0x3036,0x3036}, {0,0x3037,0x3037,0x3037},
 {0,0x3038,0x3038,0x3038}, {0,0x3039,0x3039,0x3039}, {0,0x303A,0x303A,0x303A}, {0,0x303B,0x303B,0x303B},
 {0,0x303C,0x303C,0x303C}, {0,0x303D,0x303D,0x303D}, {0,0x303E,0x303E,0x303E}, {0,0x303F,0x303F,0x303F},
 {0,0x3040,0x3040,0x3040}, {1,0x3041,0x3041,0x3041}, {1,0x3042,0x3042,0x3042}, {1,0x3043,0x3043,0x3043},
 {1,0x3044,0x3044,0x3044}, {1,0x3045,0x3045,0x3045}, {1,0x3046,0x3046,0x3046}, {1,0x3047,0x3047,0x3047},
 {1,0x3048,0x3048,0x3048}, {1,0x3049,0x3049,0x3049}, {1,0x304A,0x304A,0x304A}, {1,0x304B,0x304B,0x304B},
 {1,0x304C,0x304C,0x304C}, {1,0x304D,0x304D,0x304D}, {1,0x304E,0x304E,0x304E}, {1,0x304F,0x304F,0x304F},
 {1,0x3050,0x3050,0x3050}, {1,0x3051,0x3051,0x3051}, {1,0x3052,0x3052,0x3052}, {1,0x3053,0x3053,0x3053},
 {1,0x3054,0x3054,0x3054}, {1,0x3055,0x3055,0x3055}, {1,0x3056,0x3056,0x3056}, {1,0x3057,0x3057,0x3057},
 {1,0x3058,0x3058,0x3058}, {1,0x3059,0x3059,0x3059}, {1,0x305A,0x305A,0x305A}, {1,0x305B,0x305B,0x305B},
 {1,0x305C,0x305C,0x305C}, {1,0x305D,0x305D,0x305D}, {1,0x305E,0x305E,0x305E}, {1,0x305F,0x305F,0x305F},
 {1,0x3060,0x3060,0x3060}, {1,0x3061,0x3061,0x3061}, {1,0x3062,0x3062,0x3062}, {1,0x3063,0x3063,0x3063},
 {1,0x3064,0x3064,0x3064}, {1,0x3065,0x3065,0x3065}, {1,0x3066,0x3066,0x3066}, {1,0x3067,0x3067,0x3067},
 {1,0x3068,0x3068,0x3068}, {1,0x3069,0x3069,0x3069}, {1,0x306A,0x306A,0x306A}, {1,0x306B,0x306B,0x306B},
 {1,0x306C,0x306C,0x306C}, {1,0x306D,0x306D,0x306D}, {1,0x306E,0x306E,0x306E}, {1,0x306F,0x306F,0x306F},
 {1,0x3070,0x3070,0x3070}, {1,0x3071,0x3071,0x3071}, {1,0x3072,0x3072,0x3072}, {1,0x3073,0x3073,0x3073},
 {1,0x3074,0x3074,0x3074}, {1,0x3075,0x3075,0x3075}, {1,0x3076,0x3076,0x3076}, {1,0x3077,0x3077,0x3077},
 {1,0x3078,0x3078,0x3078}, {1,0x3079,0x3079,0x3079}, {1,0x307A,0x307A,0x307A}, {1,0x307B,0x307B,0x307B},
 {1,0x307C,0x307C,0x307C}, {1,0x307D,0x307D,0x307D}, {1,0x307E,0x307E,0x307E}, {1,0x307F,0x307F,0x307F},
 {1,0x3080,0x3080,0x3080}, {1,0x3081,0x3081,0x3081}, {1,0x3082,0x3082,0x3082}, {1,0x3083,0x3083,0x3083},
 {1,0x3084,0x3084,0x3084}, {1,0x3085,0x3085,0x3085}, {1,0x3086,0x3086,0x3086}, {1,0x3087,0x3087,0x3087},
 {1,0x3088,0x3088,0x3088}, {1,0x3089,0x3089,0x3089}, {1,0x308A,0x308A,0x308A}, {1,0x308B,0x308B,0x308B},
 {1,0x308C,0x308C,0x308C}, {1,0x308D,0x308D,0x308D}, {1,0x308E,0x308E,0x308E}, {1,0x308F,0x308F,0x308F},
 {1,0x3090,0x3090,0x3090}, {1,0x3091,0x3091,0x3091}, {1,0x3092,0x3092,0x3092}, {1,0x3093,0x3093,0x3093},
 {1,0x3094,0x3094,0x3094}, {0,0x3095,0x3095,0x3095}, {0,0x3096,0x3096,0x3096}, {0,0x3097,0x3097,0x3097},
 {0,0x3098,0x3098,0x3098}, {1,0x3099,0x3099,0x3099}, {1,0x309A,0x309A,0x309A}, {0,0x309B,0x309B,0x309B},
 {0,0x309C,0x309C,0x309C}, {1,0x309D,0x309D,0x309D}, {1,0x309E,0x309E,0x309E}, {0,0x309F,0x309F,0x309F},
 {0,0x30A0,0x30A0,0x30A0}, {1,0x30A1,0x30A1,0x30A1}, {1,0x30A2,0x30A2,0x30A2}, {1,0x30A3,0x30A3,0x30A3},
 {1,0x30A4,0x30A4,0x30A4}, {1,0x30A5,0x30A5,0x30A5}, {1,0x30A6,0x30A6,0x30A6}, {1,0x30A7,0x30A7,0x30A7},
 {1,0x30A8,0x30A8,0x30A8}, {1,0x30A9,0x30A9,0x30A9}, {1,0x30AA,0x30AA,0x30AA}, {1,0x30AB,0x30AB,0x30AB},
 {1,0x30AC,0x30AC,0x30AC}, {1,0x30AD,0x30AD,0x30AD}, {1,0x30AE,0x30AE,0x30AE}, {1,0x30AF,0x30AF,0x30AF},
 {1,0x30B0,0x30B0,0x30B0}, {1,0x30B1,0x30B1,0x30B1}, {1,0x30B2,0x30B2,0x30B2}, {1,0x30B3,0x30B3,0x30B3},
 {1,0x30B4,0x30B4,0x30B4}, {1,0x30B5,0x30B5,0x30B5}, {1,0x30B6,0x30B6,0x30B6}, {1,0x30B7,0x30B7,0x30B7},
 {1,0x30B8,0x30B8,0x30B8}, {1,0x30B9,0x30B9,0x30B9}, {1,0x30BA,0x30BA,0x30BA}, {1,0x30BB,0x30BB,0x30BB},
 {1,0x30BC,0x30BC,0x30BC}, {1,0x30BD,0x30BD,0x30BD}, {1,0x30BE,0x30BE,0x30BE}, {1,0x30BF,0x30BF,0x30BF},
 {1,0x30C0,0x30C0,0x30C0}, {1,0x30C1,0x30C1,0x30C1}, {1,0x30C2,0x30C2,0x30C2}, {1,0x30C3,0x30C3,0x30C3},
 {1,0x30C4,0x30C4,0x30C4}, {1,0x30C5,0x30C5,0x30C5}, {1,0x30C6,0x30C6,0x30C6}, {1,0x30C7,0x30C7,0x30C7},
 {1,0x30C8,0x30C8,0x30C8}, {1,0x30C9,0x30C9,0x30C9}, {1,0x30CA,0x30CA,0x30CA}, {1,0x30CB,0x30CB,0x30CB},
 {1,0x30CC,0x30CC,0x30CC}, {1,0x30CD,0x30CD,0x30CD}, {1,0x30CE,0x30CE,0x30CE}, {1,0x30CF,0x30CF,0x30CF},
 {1,0x30D0,0x30D0,0x30D0}, {1,0x30D1,0x30D1,0x30D1}, {1,0x30D2,0x30D2,0x30D2}, {1,0x30D3,0x30D3,0x30D3},
 {1,0x30D4,0x30D4,0x30D4}, {1,0x30D5,0x30D5,0x30D5}, {1,0x30D6,0x30D6,0x30D6}, {1,0x30D7,0x30D7,0x30D7},
 {1,0x30D8,0x30D8,0x30D8}, {1,0x30D9,0x30D9,0x30D9}, {1,0x30DA,0x30DA,0x30DA}, {1,0x30DB,0x30DB,0x30DB},
 {1,0x30DC,0x30DC,0x30DC}, {1,0x30DD,0x30DD,0x30DD}, {1,0x30DE,0x30DE,0x30DE}, {1,0x30DF,0x30DF,0x30DF},
 {1,0x30E0,0x30E0,0x30E0}, {1,0x30E1,0x30E1,0x30E1}, {1,0x30E2,0x30E2,0x30E2}, {1,0x30E3,0x30E3,0x30E3},
 {1,0x30E4,0x30E4,0x30E4}, {1,0x30E5,0x30E5,0x30E5}, {1,0x30E6,0x30E6,0x30E6}, {1,0x30E7,0x30E7,0x30E7},
 {1,0x30E8,0x30E8,0x30E8}, {1,0x30E9,0x30E9,0x30E9}, {1,0x30EA,0x30EA,0x30EA}, {1,0x30EB,0x30EB,0x30EB},
 {1,0x30EC,0x30EC,0x30EC}, {1,0x30ED,0x30ED,0x30ED}, {1,0x30EE,0x30EE,0x30EE}, {1,0x30EF,0x30EF,0x30EF},
 {1,0x30F0,0x30F0,0x30F0}, {1,0x30F1,0x30F1,0x30F1}, {1,0x30F2,0x30F2,0x30F2}, {1,0x30F3,0x30F3,0x30F3},
 {1,0x30F4,0x30F4,0x30F4}, {1,0x30F5,0x30F5,0x30F5}, {1,0x30F6,0x30F6,0x30F6}, {1,0x30F7,0x30F7,0x30F7},
 {1,0x30F8,0x30F8,0x30F8}, {1,0x30F9,0x30F9,0x30F9}, {1,0x30FA,0x30FA,0x30FA}, {0,0x30FB,0x30FB,0x30FB},
 {1,0x30FC,0x30FC,0x30FC}, {1,0x30FD,0x30FD,0x30FD}, {1,0x30FE,0x30FE,0x30FE}, {0,0x30FF,0x30FF,0x30FF},
{0,0}};

static UDM_UNICODE plane31[257]={
 {0,0x3100,0x3100,0x3100}, {0,0x3101,0x3101,0x3101}, {0,0x3102,0x3102,0x3102}, {0,0x3103,0x3103,0x3103},
 {0,0x3104,0x3104,0x3104}, {1,0x3105,0x3105,0x3105}, {1,0x3106,0x3106,0x3106}, {1,0x3107,0x3107,0x3107},
 {1,0x3108,0x3108,0x3108}, {1,0x3109,0x3109,0x3109}, {1,0x310A,0x310A,0x310A}, {1,0x310B,0x310B,0x310B},
 {1,0x310C,0x310C,0x310C}, {1,0x310D,0x310D,0x310D}, {1,0x310E,0x310E,0x310E}, {1,0x310F,0x310F,0x310F},
 {1,0x3110,0x3110,0x3110}, {1,0x3111,0x3111,0x3111}, {1,0x3112,0x3112,0x3112}, {1,0x3113,0x3113,0x3113},
 {1,0x3114,0x3114,0x3114}, {1,0x3115,0x3115,0x3115}, {1,0x3116,0x3116,0x3116}, {1,0x3117,0x3117,0x3117},
 {1,0x3118,0x3118,0x3118}, {1,0x3119,0x3119,0x3119}, {1,0x311A,0x311A,0x311A}, {1,0x311B,0x311B,0x311B},
 {1,0x311C,0x311C,0x311C}, {1,0x311D,0x311D,0x311D}, {1,0x311E,0x311E,0x311E}, {1,0x311F,0x311F,0x311F},
 {1,0x3120,0x3120,0x3120}, {1,0x3121,0x3121,0x3121}, {1,0x3122,0x3122,0x3122}, {1,0x3123,0x3123,0x3123},
 {1,0x3124,0x3124,0x3124}, {1,0x3125,0x3125,0x3125}, {1,0x3126,0x3126,0x3126}, {1,0x3127,0x3127,0x3127},
 {1,0x3128,0x3128,0x3128}, {1,0x3129,0x3129,0x3129}, {1,0x312A,0x312A,0x312A}, {1,0x312B,0x312B,0x312B},
 {1,0x312C,0x312C,0x312C}, {0,0x312D,0x312D,0x312D}, {0,0x312E,0x312E,0x312E}, {0,0x312F,0x312F,0x312F},
 {0,0x3130,0x3130,0x3130}, {1,0x3131,0x3131,0x3131}, {1,0x3132,0x3132,0x3132}, {1,0x3133,0x3133,0x3133},
 {1,0x3134,0x3134,0x3134}, {1,0x3135,0x3135,0x3135}, {1,0x3136,0x3136,0x3136}, {1,0x3137,0x3137,0x3137},
 {1,0x3138,0x3138,0x3138}, {1,0x3139,0x3139,0x3139}, {1,0x313A,0x313A,0x313A}, {1,0x313B,0x313B,0x313B},
 {1,0x313C,0x313C,0x313C}, {1,0x313D,0x313D,0x313D}, {1,0x313E,0x313E,0x313E}, {1,0x313F,0x313F,0x313F},
 {1,0x3140,0x3140,0x3140}, {1,0x3141,0x3141,0x3141}, {1,0x3142,0x3142,0x3142}, {1,0x3143,0x3143,0x3143},
 {1,0x3144,0x3144,0x3144}, {1,0x3145,0x3145,0x3145}, {1,0x3146,0x3146,0x3146}, {1,0x3147,0x3147,0x3147},
 {1,0x3148,0x3148,0x3148}, {1,0x3149,0x3149,0x3149}, {1,0x314A,0x314A,0x314A}, {1,0x314B,0x314B,0x314B},
 {1,0x314C,0x314C,0x314C}, {1,0x314D,0x314D,0x314D}, {1,0x314E,0x314E,0x314E}, {1,0x314F,0x314F,0x314F},
 {1,0x3150,0x3150,0x3150}, {1,0x3151,0x3151,0x3151}, {1,0x3152,0x3152,0x3152}, {1,0x3153,0x3153,0x3153},
 {1,0x3154,0x3154,0x3154}, {1,0x3155,0x3155,0x3155}, {1,0x3156,0x3156,0x3156}, {1,0x3157,0x3157,0x3157},
 {1,0x3158,0x3158,0x3158}, {1,0x3159,0x3159,0x3159}, {1,0x315A,0x315A,0x315A}, {1,0x315B,0x315B,0x315B},
 {1,0x315C,0x315C,0x315C}, {1,0x315D,0x315D,0x315D}, {1,0x315E,0x315E,0x315E}, {1,0x315F,0x315F,0x315F},
 {1,0x3160,0x3160,0x3160}, {1,0x3161,0x3161,0x3161}, {1,0x3162,0x3162,0x3162}, {1,0x3163,0x3163,0x3163},
 {1,0x3164,0x3164,0x3164}, {1,0x3165,0x3165,0x3165}, {1,0x3166,0x3166,0x3166}, {1,0x3167,0x3167,0x3167},
 {1,0x3168,0x3168,0x3168}, {1,0x3169,0x3169,0x3169}, {1,0x316A,0x316A,0x316A}, {1,0x316B,0x316B,0x316B},
 {1,0x316C,0x316C,0x316C}, {1,0x316D,0x316D,0x316D}, {1,0x316E,0x316E,0x316E}, {1,0x316F,0x316F,0x316F},
 {1,0x3170,0x3170,0x3170}, {1,0x3171,0x3171,0x3171}, {1,0x3172,0x3172,0x3172}, {1,0x3173,0x3173,0x3173},
 {1,0x3174,0x3174,0x3174}, {1,0x3175,0x3175,0x3175}, {1,0x3176,0x3176,0x3176}, {1,0x3177,0x3177,0x3177},
 {1,0x3178,0x3178,0x3178}, {1,0x3179,0x3179,0x3179}, {1,0x317A,0x317A,0x317A}, {1,0x317B,0x317B,0x317B},
 {1,0x317C,0x317C,0x317C}, {1,0x317D,0x317D,0x317D}, {1,0x317E,0x317E,0x317E}, {1,0x317F,0x317F,0x317F},
 {1,0x3180,0x3180,0x3180}, {1,0x3181,0x3181,0x3181}, {1,0x3182,0x3182,0x3182}, {1,0x3183,0x3183,0x3183},
 {1,0x3184,0x3184,0x3184}, {1,0x3185,0x3185,0x3185}, {1,0x3186,0x3186,0x3186}, {1,0x3187,0x3187,0x3187},
 {1,0x3188,0x3188,0x3188}, {1,0x3189,0x3189,0x3189}, {1,0x318A,0x318A,0x318A}, {1,0x318B,0x318B,0x318B},
 {1,0x318C,0x318C,0x318C}, {1,0x318D,0x318D,0x318D}, {1,0x318E,0x318E,0x318E}, {0,0x318F,0x318F,0x318F},
 {0,0x3190,0x3190,0x3190}, {0,0x3191,0x3191,0x3191}, {0,0x3192,0x3192,0x3192}, {0,0x3193,0x3193,0x3193},
 {0,0x3194,0x3194,0x3194}, {0,0x3195,0x3195,0x3195}, {0,0x3196,0x3196,0x3196}, {0,0x3197,0x3197,0x3197},
 {0,0x3198,0x3198,0x3198}, {0,0x3199,0x3199,0x3199}, {0,0x319A,0x319A,0x319A}, {0,0x319B,0x319B,0x319B},
 {0,0x319C,0x319C,0x319C}, {0,0x319D,0x319D,0x319D}, {0,0x319E,0x319E,0x319E}, {0,0x319F,0x319F,0x319F},
 {1,0x31A0,0x31A0,0x31A0}, {1,0x31A1,0x31A1,0x31A1}, {1,0x31A2,0x31A2,0x31A2}, {1,0x31A3,0x31A3,0x31A3},
 {1,0x31A4,0x31A4,0x31A4}, {1,0x31A5,0x31A5,0x31A5}, {1,0x31A6,0x31A6,0x31A6}, {1,0x31A7,0x31A7,0x31A7},
 {1,0x31A8,0x31A8,0x31A8}, {1,0x31A9,0x31A9,0x31A9}, {1,0x31AA,0x31AA,0x31AA}, {1,0x31AB,0x31AB,0x31AB},
 {1,0x31AC,0x31AC,0x31AC}, {1,0x31AD,0x31AD,0x31AD}, {1,0x31AE,0x31AE,0x31AE}, {1,0x31AF,0x31AF,0x31AF},
 {1,0x31B0,0x31B0,0x31B0}, {1,0x31B1,0x31B1,0x31B1}, {1,0x31B2,0x31B2,0x31B2}, {1,0x31B3,0x31B3,0x31B3},
 {1,0x31B4,0x31B4,0x31B4}, {1,0x31B5,0x31B5,0x31B5}, {1,0x31B6,0x31B6,0x31B6}, {1,0x31B7,0x31B7,0x31B7},
 {0,0x31B8,0x31B8,0x31B8}, {0,0x31B9,0x31B9,0x31B9}, {0,0x31BA,0x31BA,0x31BA}, {0,0x31BB,0x31BB,0x31BB},
 {0,0x31BC,0x31BC,0x31BC}, {0,0x31BD,0x31BD,0x31BD}, {0,0x31BE,0x31BE,0x31BE}, {0,0x31BF,0x31BF,0x31BF},
 {0,0x31C0,0x31C0,0x31C0}, {0,0x31C1,0x31C1,0x31C1}, {0,0x31C2,0x31C2,0x31C2}, {0,0x31C3,0x31C3,0x31C3},
 {0,0x31C4,0x31C4,0x31C4}, {0,0x31C5,0x31C5,0x31C5}, {0,0x31C6,0x31C6,0x31C6}, {0,0x31C7,0x31C7,0x31C7},
 {0,0x31C8,0x31C8,0x31C8}, {0,0x31C9,0x31C9,0x31C9}, {0,0x31CA,0x31CA,0x31CA}, {0,0x31CB,0x31CB,0x31CB},
 {0,0x31CC,0x31CC,0x31CC}, {0,0x31CD,0x31CD,0x31CD}, {0,0x31CE,0x31CE,0x31CE}, {0,0x31CF,0x31CF,0x31CF},
 {0,0x31D0,0x31D0,0x31D0}, {0,0x31D1,0x31D1,0x31D1}, {0,0x31D2,0x31D2,0x31D2}, {0,0x31D3,0x31D3,0x31D3},
 {0,0x31D4,0x31D4,0x31D4}, {0,0x31D5,0x31D5,0x31D5}, {0,0x31D6,0x31D6,0x31D6}, {0,0x31D7,0x31D7,0x31D7},
 {0,0x31D8,0x31D8,0x31D8}, {0,0x31D9,0x31D9,0x31D9}, {0,0x31DA,0x31DA,0x31DA}, {0,0x31DB,0x31DB,0x31DB},
 {0,0x31DC,0x31DC,0x31DC}, {0,0x31DD,0x31DD,0x31DD}, {0,0x31DE,0x31DE,0x31DE}, {0,0x31DF,0x31DF,0x31DF},
 {0,0x31E0,0x31E0,0x31E0}, {0,0x31E1,0x31E1,0x31E1}, {0,0x31E2,0x31E2,0x31E2}, {0,0x31E3,0x31E3,0x31E3},
 {0,0x31E4,0x31E4,0x31E4}, {0,0x31E5,0x31E5,0x31E5}, {0,0x31E6,0x31E6,0x31E6}, {0,0x31E7,0x31E7,0x31E7},
 {0,0x31E8,0x31E8,0x31E8}, {0,0x31E9,0x31E9,0x31E9}, {0,0x31EA,0x31EA,0x31EA}, {0,0x31EB,0x31EB,0x31EB},
 {0,0x31EC,0x31EC,0x31EC}, {0,0x31ED,0x31ED,0x31ED}, {0,0x31EE,0x31EE,0x31EE}, {0,0x31EF,0x31EF,0x31EF},
 {0,0x31F0,0x31F0,0x31F0}, {0,0x31F1,0x31F1,0x31F1}, {0,0x31F2,0x31F2,0x31F2}, {0,0x31F3,0x31F3,0x31F3},
 {0,0x31F4,0x31F4,0x31F4}, {0,0x31F5,0x31F5,0x31F5}, {0,0x31F6,0x31F6,0x31F6}, {0,0x31F7,0x31F7,0x31F7},
 {0,0x31F8,0x31F8,0x31F8}, {0,0x31F9,0x31F9,0x31F9}, {0,0x31FA,0x31FA,0x31FA}, {0,0x31FB,0x31FB,0x31FB},
 {0,0x31FC,0x31FC,0x31FC}, {0,0x31FD,0x31FD,0x31FD}, {0,0x31FE,0x31FE,0x31FE}, {0,0x31FF,0x31FF,0x31FF},
{0,0}};

static UDM_UNICODE plane4D[257]={
 {3,0x4D00,0x4D00,0x4D00}, {3,0x4D01,0x4D01,0x4D01}, {3,0x4D02,0x4D02,0x4D02}, {3,0x4D03,0x4D03,0x4D03},
 {3,0x4D04,0x4D04,0x4D04}, {3,0x4D05,0x4D05,0x4D05}, {3,0x4D06,0x4D06,0x4D06}, {3,0x4D07,0x4D07,0x4D07},
 {3,0x4D08,0x4D08,0x4D08}, {3,0x4D09,0x4D09,0x4D09}, {3,0x4D0A,0x4D0A,0x4D0A}, {3,0x4D0B,0x4D0B,0x4D0B},
 {3,0x4D0C,0x4D0C,0x4D0C}, {3,0x4D0D,0x4D0D,0x4D0D}, {3,0x4D0E,0x4D0E,0x4D0E}, {3,0x4D0F,0x4D0F,0x4D0F},
 {3,0x4D10,0x4D10,0x4D10}, {3,0x4D11,0x4D11,0x4D11}, {3,0x4D12,0x4D12,0x4D12}, {3,0x4D13,0x4D13,0x4D13},
 {3,0x4D14,0x4D14,0x4D14}, {3,0x4D15,0x4D15,0x4D15}, {3,0x4D16,0x4D16,0x4D16}, {3,0x4D17,0x4D17,0x4D17},
 {3,0x4D18,0x4D18,0x4D18}, {3,0x4D19,0x4D19,0x4D19}, {3,0x4D1A,0x4D1A,0x4D1A}, {3,0x4D1B,0x4D1B,0x4D1B},
 {3,0x4D1C,0x4D1C,0x4D1C}, {3,0x4D1D,0x4D1D,0x4D1D}, {3,0x4D1E,0x4D1E,0x4D1E}, {3,0x4D1F,0x4D1F,0x4D1F},
 {3,0x4D20,0x4D20,0x4D20}, {3,0x4D21,0x4D21,0x4D21}, {3,0x4D22,0x4D22,0x4D22}, {3,0x4D23,0x4D23,0x4D23},
 {3,0x4D24,0x4D24,0x4D24}, {3,0x4D25,0x4D25,0x4D25}, {3,0x4D26,0x4D26,0x4D26}, {3,0x4D27,0x4D27,0x4D27},
 {3,0x4D28,0x4D28,0x4D28}, {3,0x4D29,0x4D29,0x4D29}, {3,0x4D2A,0x4D2A,0x4D2A}, {3,0x4D2B,0x4D2B,0x4D2B},
 {3,0x4D2C,0x4D2C,0x4D2C}, {3,0x4D2D,0x4D2D,0x4D2D}, {3,0x4D2E,0x4D2E,0x4D2E}, {3,0x4D2F,0x4D2F,0x4D2F},
 {3,0x4D30,0x4D30,0x4D30}, {3,0x4D31,0x4D31,0x4D31}, {3,0x4D32,0x4D32,0x4D32}, {3,0x4D33,0x4D33,0x4D33},
 {3,0x4D34,0x4D34,0x4D34}, {3,0x4D35,0x4D35,0x4D35}, {3,0x4D36,0x4D36,0x4D36}, {3,0x4D37,0x4D37,0x4D37},
 {3,0x4D38,0x4D38,0x4D38}, {3,0x4D39,0x4D39,0x4D39}, {3,0x4D3A,0x4D3A,0x4D3A}, {3,0x4D3B,0x4D3B,0x4D3B},
 {3,0x4D3C,0x4D3C,0x4D3C}, {3,0x4D3D,0x4D3D,0x4D3D}, {3,0x4D3E,0x4D3E,0x4D3E}, {3,0x4D3F,0x4D3F,0x4D3F},
 {3,0x4D40,0x4D40,0x4D40}, {3,0x4D41,0x4D41,0x4D41}, {3,0x4D42,0x4D42,0x4D42}, {3,0x4D43,0x4D43,0x4D43},
 {3,0x4D44,0x4D44,0x4D44}, {3,0x4D45,0x4D45,0x4D45}, {3,0x4D46,0x4D46,0x4D46}, {3,0x4D47,0x4D47,0x4D47},
 {3,0x4D48,0x4D48,0x4D48}, {3,0x4D49,0x4D49,0x4D49}, {3,0x4D4A,0x4D4A,0x4D4A}, {3,0x4D4B,0x4D4B,0x4D4B},
 {3,0x4D4C,0x4D4C,0x4D4C}, {3,0x4D4D,0x4D4D,0x4D4D}, {3,0x4D4E,0x4D4E,0x4D4E}, {3,0x4D4F,0x4D4F,0x4D4F},
 {3,0x4D50,0x4D50,0x4D50}, {3,0x4D51,0x4D51,0x4D51}, {3,0x4D52,0x4D52,0x4D52}, {3,0x4D53,0x4D53,0x4D53},
 {3,0x4D54,0x4D54,0x4D54}, {3,0x4D55,0x4D55,0x4D55}, {3,0x4D56,0x4D56,0x4D56}, {3,0x4D57,0x4D57,0x4D57},
 {3,0x4D58,0x4D58,0x4D58}, {3,0x4D59,0x4D59,0x4D59}, {3,0x4D5A,0x4D5A,0x4D5A}, {3,0x4D5B,0x4D5B,0x4D5B},
 {3,0x4D5C,0x4D5C,0x4D5C}, {3,0x4D5D,0x4D5D,0x4D5D}, {3,0x4D5E,0x4D5E,0x4D5E}, {3,0x4D5F,0x4D5F,0x4D5F},
 {3,0x4D60,0x4D60,0x4D60}, {3,0x4D61,0x4D61,0x4D61}, {3,0x4D62,0x4D62,0x4D62}, {3,0x4D63,0x4D63,0x4D63},
 {3,0x4D64,0x4D64,0x4D64}, {3,0x4D65,0x4D65,0x4D65}, {3,0x4D66,0x4D66,0x4D66}, {3,0x4D67,0x4D67,0x4D67},
 {3,0x4D68,0x4D68,0x4D68}, {3,0x4D69,0x4D69,0x4D69}, {3,0x4D6A,0x4D6A,0x4D6A}, {3,0x4D6B,0x4D6B,0x4D6B},
 {3,0x4D6C,0x4D6C,0x4D6C}, {3,0x4D6D,0x4D6D,0x4D6D}, {3,0x4D6E,0x4D6E,0x4D6E}, {3,0x4D6F,0x4D6F,0x4D6F},
 {3,0x4D70,0x4D70,0x4D70}, {3,0x4D71,0x4D71,0x4D71}, {3,0x4D72,0x4D72,0x4D72}, {3,0x4D73,0x4D73,0x4D73},
 {3,0x4D74,0x4D74,0x4D74}, {3,0x4D75,0x4D75,0x4D75}, {3,0x4D76,0x4D76,0x4D76}, {3,0x4D77,0x4D77,0x4D77},
 {3,0x4D78,0x4D78,0x4D78}, {3,0x4D79,0x4D79,0x4D79}, {3,0x4D7A,0x4D7A,0x4D7A}, {3,0x4D7B,0x4D7B,0x4D7B},
 {3,0x4D7C,0x4D7C,0x4D7C}, {3,0x4D7D,0x4D7D,0x4D7D}, {3,0x4D7E,0x4D7E,0x4D7E}, {3,0x4D7F,0x4D7F,0x4D7F},
 {3,0x4D80,0x4D80,0x4D80}, {3,0x4D81,0x4D81,0x4D81}, {3,0x4D82,0x4D82,0x4D82}, {3,0x4D83,0x4D83,0x4D83},
 {3,0x4D84,0x4D84,0x4D84}, {3,0x4D85,0x4D85,0x4D85}, {3,0x4D86,0x4D86,0x4D86}, {3,0x4D87,0x4D87,0x4D87},
 {3,0x4D88,0x4D88,0x4D88}, {3,0x4D89,0x4D89,0x4D89}, {3,0x4D8A,0x4D8A,0x4D8A}, {3,0x4D8B,0x4D8B,0x4D8B},
 {3,0x4D8C,0x4D8C,0x4D8C}, {3,0x4D8D,0x4D8D,0x4D8D}, {3,0x4D8E,0x4D8E,0x4D8E}, {3,0x4D8F,0x4D8F,0x4D8F},
 {3,0x4D90,0x4D90,0x4D90}, {3,0x4D91,0x4D91,0x4D91}, {3,0x4D92,0x4D92,0x4D92}, {3,0x4D93,0x4D93,0x4D93},
 {3,0x4D94,0x4D94,0x4D94}, {3,0x4D95,0x4D95,0x4D95}, {3,0x4D96,0x4D96,0x4D96}, {3,0x4D97,0x4D97,0x4D97},
 {3,0x4D98,0x4D98,0x4D98}, {3,0x4D99,0x4D99,0x4D99}, {3,0x4D9A,0x4D9A,0x4D9A}, {3,0x4D9B,0x4D9B,0x4D9B},
 {3,0x4D9C,0x4D9C,0x4D9C}, {3,0x4D9D,0x4D9D,0x4D9D}, {3,0x4D9E,0x4D9E,0x4D9E}, {3,0x4D9F,0x4D9F,0x4D9F},
 {3,0x4DA0,0x4DA0,0x4DA0}, {3,0x4DA1,0x4DA1,0x4DA1}, {3,0x4DA2,0x4DA2,0x4DA2}, {3,0x4DA3,0x4DA3,0x4DA3},
 {3,0x4DA4,0x4DA4,0x4DA4}, {3,0x4DA5,0x4DA5,0x4DA5}, {3,0x4DA6,0x4DA6,0x4DA6}, {3,0x4DA7,0x4DA7,0x4DA7},
 {3,0x4DA8,0x4DA8,0x4DA8}, {3,0x4DA9,0x4DA9,0x4DA9}, {3,0x4DAA,0x4DAA,0x4DAA}, {3,0x4DAB,0x4DAB,0x4DAB},
 {3,0x4DAC,0x4DAC,0x4DAC}, {3,0x4DAD,0x4DAD,0x4DAD}, {3,0x4DAE,0x4DAE,0x4DAE}, {3,0x4DAF,0x4DAF,0x4DAF},
 {3,0x4DB0,0x4DB0,0x4DB0}, {3,0x4DB1,0x4DB1,0x4DB1}, {3,0x4DB2,0x4DB2,0x4DB2}, {3,0x4DB3,0x4DB3,0x4DB3},
 {3,0x4DB4,0x4DB4,0x4DB4}, {3,0x4DB5,0x4DB5,0x4DB5}, {0,0x4DB6,0x4DB6,0x4DB6}, {0,0x4DB7,0x4DB7,0x4DB7},
 {0,0x4DB8,0x4DB8,0x4DB8}, {0,0x4DB9,0x4DB9,0x4DB9}, {0,0x4DBA,0x4DBA,0x4DBA}, {0,0x4DBB,0x4DBB,0x4DBB},
 {0,0x4DBC,0x4DBC,0x4DBC}, {0,0x4DBD,0x4DBD,0x4DBD}, {0,0x4DBE,0x4DBE,0x4DBE}, {0,0x4DBF,0x4DBF,0x4DBF},
 {0,0x4DC0,0x4DC0,0x4DC0}, {0,0x4DC1,0x4DC1,0x4DC1}, {0,0x4DC2,0x4DC2,0x4DC2}, {0,0x4DC3,0x4DC3,0x4DC3},
 {0,0x4DC4,0x4DC4,0x4DC4}, {0,0x4DC5,0x4DC5,0x4DC5}, {0,0x4DC6,0x4DC6,0x4DC6}, {0,0x4DC7,0x4DC7,0x4DC7},
 {0,0x4DC8,0x4DC8,0x4DC8}, {0,0x4DC9,0x4DC9,0x4DC9}, {0,0x4DCA,0x4DCA,0x4DCA}, {0,0x4DCB,0x4DCB,0x4DCB},
 {0,0x4DCC,0x4DCC,0x4DCC}, {0,0x4DCD,0x4DCD,0x4DCD}, {0,0x4DCE,0x4DCE,0x4DCE}, {0,0x4DCF,0x4DCF,0x4DCF},
 {0,0x4DD0,0x4DD0,0x4DD0}, {0,0x4DD1,0x4DD1,0x4DD1}, {0,0x4DD2,0x4DD2,0x4DD2}, {0,0x4DD3,0x4DD3,0x4DD3},
 {0,0x4DD4,0x4DD4,0x4DD4}, {0,0x4DD5,0x4DD5,0x4DD5}, {0,0x4DD6,0x4DD6,0x4DD6}, {0,0x4DD7,0x4DD7,0x4DD7},
 {0,0x4DD8,0x4DD8,0x4DD8}, {0,0x4DD9,0x4DD9,0x4DD9}, {0,0x4DDA,0x4DDA,0x4DDA}, {0,0x4DDB,0x4DDB,0x4DDB},
 {0,0x4DDC,0x4DDC,0x4DDC}, {0,0x4DDD,0x4DDD,0x4DDD}, {0,0x4DDE,0x4DDE,0x4DDE}, {0,0x4DDF,0x4DDF,0x4DDF},
 {0,0x4DE0,0x4DE0,0x4DE0}, {0,0x4DE1,0x4DE1,0x4DE1}, {0,0x4DE2,0x4DE2,0x4DE2}, {0,0x4DE3,0x4DE3,0x4DE3},
 {0,0x4DE4,0x4DE4,0x4DE4}, {0,0x4DE5,0x4DE5,0x4DE5}, {0,0x4DE6,0x4DE6,0x4DE6}, {0,0x4DE7,0x4DE7,0x4DE7},
 {0,0x4DE8,0x4DE8,0x4DE8}, {0,0x4DE9,0x4DE9,0x4DE9}, {0,0x4DEA,0x4DEA,0x4DEA}, {0,0x4DEB,0x4DEB,0x4DEB},
 {0,0x4DEC,0x4DEC,0x4DEC}, {0,0x4DED,0x4DED,0x4DED}, {0,0x4DEE,0x4DEE,0x4DEE}, {0,0x4DEF,0x4DEF,0x4DEF},
 {0,0x4DF0,0x4DF0,0x4DF0}, {0,0x4DF1,0x4DF1,0x4DF1}, {0,0x4DF2,0x4DF2,0x4DF2}, {0,0x4DF3,0x4DF3,0x4DF3},
 {0,0x4DF4,0x4DF4,0x4DF4}, {0,0x4DF5,0x4DF5,0x4DF5}, {0,0x4DF6,0x4DF6,0x4DF6}, {0,0x4DF7,0x4DF7,0x4DF7},
 {0,0x4DF8,0x4DF8,0x4DF8}, {0,0x4DF9,0x4DF9,0x4DF9}, {0,0x4DFA,0x4DFA,0x4DFA}, {0,0x4DFB,0x4DFB,0x4DFB},
 {0,0x4DFC,0x4DFC,0x4DFC}, {0,0x4DFD,0x4DFD,0x4DFD}, {0,0x4DFE,0x4DFE,0x4DFE}, {0,0x4DFF,0x4DFF,0x4DFF},
{0,0}};

static UDM_UNICODE plane9F[257]={
 {3,0x9F00,0x9F00,0x9F00}, {3,0x9F01,0x9F01,0x9F01}, {3,0x9F02,0x9F02,0x9F02}, {3,0x9F03,0x9F03,0x9F03},
 {3,0x9F04,0x9F04,0x9F04}, {3,0x9F05,0x9F05,0x9F05}, {3,0x9F06,0x9F06,0x9F06}, {3,0x9F07,0x9F07,0x9F07},
 {3,0x9F08,0x9F08,0x9F08}, {3,0x9F09,0x9F09,0x9F09}, {3,0x9F0A,0x9F0A,0x9F0A}, {3,0x9F0B,0x9F0B,0x9F0B},
 {3,0x9F0C,0x9F0C,0x9F0C}, {3,0x9F0D,0x9F0D,0x9F0D}, {3,0x9F0E,0x9F0E,0x9F0E}, {3,0x9F0F,0x9F0F,0x9F0F},
 {3,0x9F10,0x9F10,0x9F10}, {3,0x9F11,0x9F11,0x9F11}, {3,0x9F12,0x9F12,0x9F12}, {3,0x9F13,0x9F13,0x9F13},
 {3,0x9F14,0x9F14,0x9F14}, {3,0x9F15,0x9F15,0x9F15}, {3,0x9F16,0x9F16,0x9F16}, {3,0x9F17,0x9F17,0x9F17},
 {3,0x9F18,0x9F18,0x9F18}, {3,0x9F19,0x9F19,0x9F19}, {3,0x9F1A,0x9F1A,0x9F1A}, {3,0x9F1B,0x9F1B,0x9F1B},
 {3,0x9F1C,0x9F1C,0x9F1C}, {3,0x9F1D,0x9F1D,0x9F1D}, {3,0x9F1E,0x9F1E,0x9F1E}, {3,0x9F1F,0x9F1F,0x9F1F},
 {3,0x9F20,0x9F20,0x9F20}, {3,0x9F21,0x9F21,0x9F21}, {3,0x9F22,0x9F22,0x9F22}, {3,0x9F23,0x9F23,0x9F23},
 {3,0x9F24,0x9F24,0x9F24}, {3,0x9F25,0x9F25,0x9F25}, {3,0x9F26,0x9F26,0x9F26}, {3,0x9F27,0x9F27,0x9F27},
 {3,0x9F28,0x9F28,0x9F28}, {3,0x9F29,0x9F29,0x9F29}, {3,0x9F2A,0x9F2A,0x9F2A}, {3,0x9F2B,0x9F2B,0x9F2B},
 {3,0x9F2C,0x9F2C,0x9F2C}, {3,0x9F2D,0x9F2D,0x9F2D}, {3,0x9F2E,0x9F2E,0x9F2E}, {3,0x9F2F,0x9F2F,0x9F2F},
 {3,0x9F30,0x9F30,0x9F30}, {3,0x9F31,0x9F31,0x9F31}, {3,0x9F32,0x9F32,0x9F32}, {3,0x9F33,0x9F33,0x9F33},
 {3,0x9F34,0x9F34,0x9F34}, {3,0x9F35,0x9F35,0x9F35}, {3,0x9F36,0x9F36,0x9F36}, {3,0x9F37,0x9F37,0x9F37},
 {3,0x9F38,0x9F38,0x9F38}, {3,0x9F39,0x9F39,0x9F39}, {3,0x9F3A,0x9F3A,0x9F3A}, {3,0x9F3B,0x9F3B,0x9F3B},
 {3,0x9F3C,0x9F3C,0x9F3C}, {3,0x9F3D,0x9F3D,0x9F3D}, {3,0x9F3E,0x9F3E,0x9F3E}, {3,0x9F3F,0x9F3F,0x9F3F},
 {3,0x9F40,0x9F40,0x9F40}, {3,0x9F41,0x9F41,0x9F41}, {3,0x9F42,0x9F42,0x9F42}, {3,0x9F43,0x9F43,0x9F43},
 {3,0x9F44,0x9F44,0x9F44}, {3,0x9F45,0x9F45,0x9F45}, {3,0x9F46,0x9F46,0x9F46}, {3,0x9F47,0x9F47,0x9F47},
 {3,0x9F48,0x9F48,0x9F48}, {3,0x9F49,0x9F49,0x9F49}, {3,0x9F4A,0x9F4A,0x9F4A}, {3,0x9F4B,0x9F4B,0x9F4B},
 {3,0x9F4C,0x9F4C,0x9F4C}, {3,0x9F4D,0x9F4D,0x9F4D}, {3,0x9F4E,0x9F4E,0x9F4E}, {3,0x9F4F,0x9F4F,0x9F4F},
 {3,0x9F50,0x9F50,0x9F50}, {3,0x9F51,0x9F51,0x9F51}, {3,0x9F52,0x9F52,0x9F52}, {3,0x9F53,0x9F53,0x9F53},
 {3,0x9F54,0x9F54,0x9F54}, {3,0x9F55,0x9F55,0x9F55}, {3,0x9F56,0x9F56,0x9F56}, {3,0x9F57,0x9F57,0x9F57},
 {3,0x9F58,0x9F58,0x9F58}, {3,0x9F59,0x9F59,0x9F59}, {3,0x9F5A,0x9F5A,0x9F5A}, {3,0x9F5B,0x9F5B,0x9F5B},
 {3,0x9F5C,0x9F5C,0x9F5C}, {3,0x9F5D,0x9F5D,0x9F5D}, {3,0x9F5E,0x9F5E,0x9F5E}, {3,0x9F5F,0x9F5F,0x9F5F},
 {3,0x9F60,0x9F60,0x9F60}, {3,0x9F61,0x9F61,0x9F61}, {3,0x9F62,0x9F62,0x9F62}, {3,0x9F63,0x9F63,0x9F63},
 {3,0x9F64,0x9F64,0x9F64}, {3,0x9F65,0x9F65,0x9F65}, {3,0x9F66,0x9F66,0x9F66}, {3,0x9F67,0x9F67,0x9F67},
 {3,0x9F68,0x9F68,0x9F68}, {3,0x9F69,0x9F69,0x9F69}, {3,0x9F6A,0x9F6A,0x9F6A}, {3,0x9F6B,0x9F6B,0x9F6B},
 {3,0x9F6C,0x9F6C,0x9F6C}, {3,0x9F6D,0x9F6D,0x9F6D}, {3,0x9F6E,0x9F6E,0x9F6E}, {3,0x9F6F,0x9F6F,0x9F6F},
 {3,0x9F70,0x9F70,0x9F70}, {3,0x9F71,0x9F71,0x9F71}, {3,0x9F72,0x9F72,0x9F72}, {3,0x9F73,0x9F73,0x9F73},
 {3,0x9F74,0x9F74,0x9F74}, {3,0x9F75,0x9F75,0x9F75}, {3,0x9F76,0x9F76,0x9F76}, {3,0x9F77,0x9F77,0x9F77},
 {3,0x9F78,0x9F78,0x9F78}, {3,0x9F79,0x9F79,0x9F79}, {3,0x9F7A,0x9F7A,0x9F7A}, {3,0x9F7B,0x9F7B,0x9F7B},
 {3,0x9F7C,0x9F7C,0x9F7C}, {3,0x9F7D,0x9F7D,0x9F7D}, {3,0x9F7E,0x9F7E,0x9F7E}, {3,0x9F7F,0x9F7F,0x9F7F},
 {3,0x9F80,0x9F80,0x9F80}, {3,0x9F81,0x9F81,0x9F81}, {3,0x9F82,0x9F82,0x9F82}, {3,0x9F83,0x9F83,0x9F83},
 {3,0x9F84,0x9F84,0x9F84}, {3,0x9F85,0x9F85,0x9F85}, {3,0x9F86,0x9F86,0x9F86}, {3,0x9F87,0x9F87,0x9F87},
 {3,0x9F88,0x9F88,0x9F88}, {3,0x9F89,0x9F89,0x9F89}, {3,0x9F8A,0x9F8A,0x9F8A}, {3,0x9F8B,0x9F8B,0x9F8B},
 {3,0x9F8C,0x9F8C,0x9F8C}, {3,0x9F8D,0x9F8D,0x9F8D}, {3,0x9F8E,0x9F8E,0x9F8E}, {3,0x9F8F,0x9F8F,0x9F8F},
 {3,0x9F90,0x9F90,0x9F90}, {3,0x9F91,0x9F91,0x9F91}, {3,0x9F92,0x9F92,0x9F92}, {3,0x9F93,0x9F93,0x9F93},
 {3,0x9F94,0x9F94,0x9F94}, {3,0x9F95,0x9F95,0x9F95}, {3,0x9F96,0x9F96,0x9F96}, {3,0x9F97,0x9F97,0x9F97},
 {3,0x9F98,0x9F98,0x9F98}, {3,0x9F99,0x9F99,0x9F99}, {3,0x9F9A,0x9F9A,0x9F9A}, {3,0x9F9B,0x9F9B,0x9F9B},
 {3,0x9F9C,0x9F9C,0x9F9C}, {3,0x9F9D,0x9F9D,0x9F9D}, {3,0x9F9E,0x9F9E,0x9F9E}, {3,0x9F9F,0x9F9F,0x9F9F},
 {3,0x9FA0,0x9FA0,0x9FA0}, {3,0x9FA1,0x9FA1,0x9FA1}, {3,0x9FA2,0x9FA2,0x9FA2}, {3,0x9FA3,0x9FA3,0x9FA3},
 {3,0x9FA4,0x9FA4,0x9FA4}, {3,0x9FA5,0x9FA5,0x9FA5}, {0,0x9FA6,0x9FA6,0x9FA6}, {0,0x9FA7,0x9FA7,0x9FA7},
 {0,0x9FA8,0x9FA8,0x9FA8}, {0,0x9FA9,0x9FA9,0x9FA9}, {0,0x9FAA,0x9FAA,0x9FAA}, {0,0x9FAB,0x9FAB,0x9FAB},
 {0,0x9FAC,0x9FAC,0x9FAC}, {0,0x9FAD,0x9FAD,0x9FAD}, {0,0x9FAE,0x9FAE,0x9FAE}, {0,0x9FAF,0x9FAF,0x9FAF},
 {0,0x9FB0,0x9FB0,0x9FB0}, {0,0x9FB1,0x9FB1,0x9FB1}, {0,0x9FB2,0x9FB2,0x9FB2}, {0,0x9FB3,0x9FB3,0x9FB3},
 {0,0x9FB4,0x9FB4,0x9FB4}, {0,0x9FB5,0x9FB5,0x9FB5}, {0,0x9FB6,0x9FB6,0x9FB6}, {0,0x9FB7,0x9FB7,0x9FB7},
 {0,0x9FB8,0x9FB8,0x9FB8}, {0,0x9FB9,0x9FB9,0x9FB9}, {0,0x9FBA,0x9FBA,0x9FBA}, {0,0x9FBB,0x9FBB,0x9FBB},
 {0,0x9FBC,0x9FBC,0x9FBC}, {0,0x9FBD,0x9FBD,0x9FBD}, {0,0x9FBE,0x9FBE,0x9FBE}, {0,0x9FBF,0x9FBF,0x9FBF},
 {0,0x9FC0,0x9FC0,0x9FC0}, {0,0x9FC1,0x9FC1,0x9FC1}, {0,0x9FC2,0x9FC2,0x9FC2}, {0,0x9FC3,0x9FC3,0x9FC3},
 {0,0x9FC4,0x9FC4,0x9FC4}, {0,0x9FC5,0x9FC5,0x9FC5}, {0,0x9FC6,0x9FC6,0x9FC6}, {0,0x9FC7,0x9FC7,0x9FC7},
 {0,0x9FC8,0x9FC8,0x9FC8}, {0,0x9FC9,0x9FC9,0x9FC9}, {0,0x9FCA,0x9FCA,0x9FCA}, {0,0x9FCB,0x9FCB,0x9FCB},
 {0,0x9FCC,0x9FCC,0x9FCC}, {0,0x9FCD,0x9FCD,0x9FCD}, {0,0x9FCE,0x9FCE,0x9FCE}, {0,0x9FCF,0x9FCF,0x9FCF},
 {0,0x9FD0,0x9FD0,0x9FD0}, {0,0x9FD1,0x9FD1,0x9FD1}, {0,0x9FD2,0x9FD2,0x9FD2}, {0,0x9FD3,0x9FD3,0x9FD3},
 {0,0x9FD4,0x9FD4,0x9FD4}, {0,0x9FD5,0x9FD5,0x9FD5}, {0,0x9FD6,0x9FD6,0x9FD6}, {0,0x9FD7,0x9FD7,0x9FD7},
 {0,0x9FD8,0x9FD8,0x9FD8}, {0,0x9FD9,0x9FD9,0x9FD9}, {0,0x9FDA,0x9FDA,0x9FDA}, {0,0x9FDB,0x9FDB,0x9FDB},
 {0,0x9FDC,0x9FDC,0x9FDC}, {0,0x9FDD,0x9FDD,0x9FDD}, {0,0x9FDE,0x9FDE,0x9FDE}, {0,0x9FDF,0x9FDF,0x9FDF},
 {0,0x9FE0,0x9FE0,0x9FE0}, {0,0x9FE1,0x9FE1,0x9FE1}, {0,0x9FE2,0x9FE2,0x9FE2}, {0,0x9FE3,0x9FE3,0x9FE3},
 {0,0x9FE4,0x9FE4,0x9FE4}, {0,0x9FE5,0x9FE5,0x9FE5}, {0,0x9FE6,0x9FE6,0x9FE6}, {0,0x9FE7,0x9FE7,0x9FE7},
 {0,0x9FE8,0x9FE8,0x9FE8}, {0,0x9FE9,0x9FE9,0x9FE9}, {0,0x9FEA,0x9FEA,0x9FEA}, {0,0x9FEB,0x9FEB,0x9FEB},
 {0,0x9FEC,0x9FEC,0x9FEC}, {0,0x9FED,0x9FED,0x9FED}, {0,0x9FEE,0x9FEE,0x9FEE}, {0,0x9FEF,0x9FEF,0x9FEF},
 {0,0x9FF0,0x9FF0,0x9FF0}, {0,0x9FF1,0x9FF1,0x9FF1}, {0,0x9FF2,0x9FF2,0x9FF2}, {0,0x9FF3,0x9FF3,0x9FF3},
 {0,0x9FF4,0x9FF4,0x9FF4}, {0,0x9FF5,0x9FF5,0x9FF5}, {0,0x9FF6,0x9FF6,0x9FF6}, {0,0x9FF7,0x9FF7,0x9FF7},
 {0,0x9FF8,0x9FF8,0x9FF8}, {0,0x9FF9,0x9FF9,0x9FF9}, {0,0x9FFA,0x9FFA,0x9FFA}, {0,0x9FFB,0x9FFB,0x9FFB},
 {0,0x9FFC,0x9FFC,0x9FFC}, {0,0x9FFD,0x9FFD,0x9FFD}, {0,0x9FFE,0x9FFE,0x9FFE}, {0,0x9FFF,0x9FFF,0x9FFF},
{0,0}};

static UDM_UNICODE planeA4[257]={
 {1,0xA400,0xA400,0xA400}, {1,0xA401,0xA401,0xA401}, {1,0xA402,0xA402,0xA402}, {1,0xA403,0xA403,0xA403},
 {1,0xA404,0xA404,0xA404}, {1,0xA405,0xA405,0xA405}, {1,0xA406,0xA406,0xA406}, {1,0xA407,0xA407,0xA407},
 {1,0xA408,0xA408,0xA408}, {1,0xA409,0xA409,0xA409}, {1,0xA40A,0xA40A,0xA40A}, {1,0xA40B,0xA40B,0xA40B},
 {1,0xA40C,0xA40C,0xA40C}, {1,0xA40D,0xA40D,0xA40D}, {1,0xA40E,0xA40E,0xA40E}, {1,0xA40F,0xA40F,0xA40F},
 {1,0xA410,0xA410,0xA410}, {1,0xA411,0xA411,0xA411}, {1,0xA412,0xA412,0xA412}, {1,0xA413,0xA413,0xA413},
 {1,0xA414,0xA414,0xA414}, {1,0xA415,0xA415,0xA415}, {1,0xA416,0xA416,0xA416}, {1,0xA417,0xA417,0xA417},
 {1,0xA418,0xA418,0xA418}, {1,0xA419,0xA419,0xA419}, {1,0xA41A,0xA41A,0xA41A}, {1,0xA41B,0xA41B,0xA41B},
 {1,0xA41C,0xA41C,0xA41C}, {1,0xA41D,0xA41D,0xA41D}, {1,0xA41E,0xA41E,0xA41E}, {1,0xA41F,0xA41F,0xA41F},
 {1,0xA420,0xA420,0xA420}, {1,0xA421,0xA421,0xA421}, {1,0xA422,0xA422,0xA422}, {1,0xA423,0xA423,0xA423},
 {1,0xA424,0xA424,0xA424}, {1,0xA425,0xA425,0xA425}, {1,0xA426,0xA426,0xA426}, {1,0xA427,0xA427,0xA427},
 {1,0xA428,0xA428,0xA428}, {1,0xA429,0xA429,0xA429}, {1,0xA42A,0xA42A,0xA42A}, {1,0xA42B,0xA42B,0xA42B},
 {1,0xA42C,0xA42C,0xA42C}, {1,0xA42D,0xA42D,0xA42D}, {1,0xA42E,0xA42E,0xA42E}, {1,0xA42F,0xA42F,0xA42F},
 {1,0xA430,0xA430,0xA430}, {1,0xA431,0xA431,0xA431}, {1,0xA432,0xA432,0xA432}, {1,0xA433,0xA433,0xA433},
 {1,0xA434,0xA434,0xA434}, {1,0xA435,0xA435,0xA435}, {1,0xA436,0xA436,0xA436}, {1,0xA437,0xA437,0xA437},
 {1,0xA438,0xA438,0xA438}, {1,0xA439,0xA439,0xA439}, {1,0xA43A,0xA43A,0xA43A}, {1,0xA43B,0xA43B,0xA43B},
 {1,0xA43C,0xA43C,0xA43C}, {1,0xA43D,0xA43D,0xA43D}, {1,0xA43E,0xA43E,0xA43E}, {1,0xA43F,0xA43F,0xA43F},
 {1,0xA440,0xA440,0xA440}, {1,0xA441,0xA441,0xA441}, {1,0xA442,0xA442,0xA442}, {1,0xA443,0xA443,0xA443},
 {1,0xA444,0xA444,0xA444}, {1,0xA445,0xA445,0xA445}, {1,0xA446,0xA446,0xA446}, {1,0xA447,0xA447,0xA447},
 {1,0xA448,0xA448,0xA448}, {1,0xA449,0xA449,0xA449}, {1,0xA44A,0xA44A,0xA44A}, {1,0xA44B,0xA44B,0xA44B},
 {1,0xA44C,0xA44C,0xA44C}, {1,0xA44D,0xA44D,0xA44D}, {1,0xA44E,0xA44E,0xA44E}, {1,0xA44F,0xA44F,0xA44F},
 {1,0xA450,0xA450,0xA450}, {1,0xA451,0xA451,0xA451}, {1,0xA452,0xA452,0xA452}, {1,0xA453,0xA453,0xA453},
 {1,0xA454,0xA454,0xA454}, {1,0xA455,0xA455,0xA455}, {1,0xA456,0xA456,0xA456}, {1,0xA457,0xA457,0xA457},
 {1,0xA458,0xA458,0xA458}, {1,0xA459,0xA459,0xA459}, {1,0xA45A,0xA45A,0xA45A}, {1,0xA45B,0xA45B,0xA45B},
 {1,0xA45C,0xA45C,0xA45C}, {1,0xA45D,0xA45D,0xA45D}, {1,0xA45E,0xA45E,0xA45E}, {1,0xA45F,0xA45F,0xA45F},
 {1,0xA460,0xA460,0xA460}, {1,0xA461,0xA461,0xA461}, {1,0xA462,0xA462,0xA462}, {1,0xA463,0xA463,0xA463},
 {1,0xA464,0xA464,0xA464}, {1,0xA465,0xA465,0xA465}, {1,0xA466,0xA466,0xA466}, {1,0xA467,0xA467,0xA467},
 {1,0xA468,0xA468,0xA468}, {1,0xA469,0xA469,0xA469}, {1,0xA46A,0xA46A,0xA46A}, {1,0xA46B,0xA46B,0xA46B},
 {1,0xA46C,0xA46C,0xA46C}, {1,0xA46D,0xA46D,0xA46D}, {1,0xA46E,0xA46E,0xA46E}, {1,0xA46F,0xA46F,0xA46F},
 {1,0xA470,0xA470,0xA470}, {1,0xA471,0xA471,0xA471}, {1,0xA472,0xA472,0xA472}, {1,0xA473,0xA473,0xA473},
 {1,0xA474,0xA474,0xA474}, {1,0xA475,0xA475,0xA475}, {1,0xA476,0xA476,0xA476}, {1,0xA477,0xA477,0xA477},
 {1,0xA478,0xA478,0xA478}, {1,0xA479,0xA479,0xA479}, {1,0xA47A,0xA47A,0xA47A}, {1,0xA47B,0xA47B,0xA47B},
 {1,0xA47C,0xA47C,0xA47C}, {1,0xA47D,0xA47D,0xA47D}, {1,0xA47E,0xA47E,0xA47E}, {1,0xA47F,0xA47F,0xA47F},
 {1,0xA480,0xA480,0xA480}, {1,0xA481,0xA481,0xA481}, {1,0xA482,0xA482,0xA482}, {1,0xA483,0xA483,0xA483},
 {1,0xA484,0xA484,0xA484}, {1,0xA485,0xA485,0xA485}, {1,0xA486,0xA486,0xA486}, {1,0xA487,0xA487,0xA487},
 {1,0xA488,0xA488,0xA488}, {1,0xA489,0xA489,0xA489}, {1,0xA48A,0xA48A,0xA48A}, {1,0xA48B,0xA48B,0xA48B},
 {1,0xA48C,0xA48C,0xA48C}, {0,0xA48D,0xA48D,0xA48D}, {0,0xA48E,0xA48E,0xA48E}, {0,0xA48F,0xA48F,0xA48F},
 {0,0xA490,0xA490,0xA490}, {0,0xA491,0xA491,0xA491}, {0,0xA492,0xA492,0xA492}, {0,0xA493,0xA493,0xA493},
 {0,0xA494,0xA494,0xA494}, {0,0xA495,0xA495,0xA495}, {0,0xA496,0xA496,0xA496}, {0,0xA497,0xA497,0xA497},
 {0,0xA498,0xA498,0xA498}, {0,0xA499,0xA499,0xA499}, {0,0xA49A,0xA49A,0xA49A}, {0,0xA49B,0xA49B,0xA49B},
 {0,0xA49C,0xA49C,0xA49C}, {0,0xA49D,0xA49D,0xA49D}, {0,0xA49E,0xA49E,0xA49E}, {0,0xA49F,0xA49F,0xA49F},
 {0,0xA4A0,0xA4A0,0xA4A0}, {0,0xA4A1,0xA4A1,0xA4A1}, {0,0xA4A2,0xA4A2,0xA4A2}, {0,0xA4A3,0xA4A3,0xA4A3},
 {0,0xA4A4,0xA4A4,0xA4A4}, {0,0xA4A5,0xA4A5,0xA4A5}, {0,0xA4A6,0xA4A6,0xA4A6}, {0,0xA4A7,0xA4A7,0xA4A7},
 {0,0xA4A8,0xA4A8,0xA4A8}, {0,0xA4A9,0xA4A9,0xA4A9}, {0,0xA4AA,0xA4AA,0xA4AA}, {0,0xA4AB,0xA4AB,0xA4AB},
 {0,0xA4AC,0xA4AC,0xA4AC}, {0,0xA4AD,0xA4AD,0xA4AD}, {0,0xA4AE,0xA4AE,0xA4AE}, {0,0xA4AF,0xA4AF,0xA4AF},
 {0,0xA4B0,0xA4B0,0xA4B0}, {0,0xA4B1,0xA4B1,0xA4B1}, {0,0xA4B2,0xA4B2,0xA4B2}, {0,0xA4B3,0xA4B3,0xA4B3},
 {0,0xA4B4,0xA4B4,0xA4B4}, {0,0xA4B5,0xA4B5,0xA4B5}, {0,0xA4B6,0xA4B6,0xA4B6}, {0,0xA4B7,0xA4B7,0xA4B7},
 {0,0xA4B8,0xA4B8,0xA4B8}, {0,0xA4B9,0xA4B9,0xA4B9}, {0,0xA4BA,0xA4BA,0xA4BA}, {0,0xA4BB,0xA4BB,0xA4BB},
 {0,0xA4BC,0xA4BC,0xA4BC}, {0,0xA4BD,0xA4BD,0xA4BD}, {0,0xA4BE,0xA4BE,0xA4BE}, {0,0xA4BF,0xA4BF,0xA4BF},
 {0,0xA4C0,0xA4C0,0xA4C0}, {0,0xA4C1,0xA4C1,0xA4C1}, {0,0xA4C2,0xA4C2,0xA4C2}, {0,0xA4C3,0xA4C3,0xA4C3},
 {0,0xA4C4,0xA4C4,0xA4C4}, {0,0xA4C5,0xA4C5,0xA4C5}, {0,0xA4C6,0xA4C6,0xA4C6}, {0,0xA4C7,0xA4C7,0xA4C7},
 {0,0xA4C8,0xA4C8,0xA4C8}, {0,0xA4C9,0xA4C9,0xA4C9}, {0,0xA4CA,0xA4CA,0xA4CA}, {0,0xA4CB,0xA4CB,0xA4CB},
 {0,0xA4CC,0xA4CC,0xA4CC}, {0,0xA4CD,0xA4CD,0xA4CD}, {0,0xA4CE,0xA4CE,0xA4CE}, {0,0xA4CF,0xA4CF,0xA4CF},
 {0,0xA4D0,0xA4D0,0xA4D0}, {0,0xA4D1,0xA4D1,0xA4D1}, {0,0xA4D2,0xA4D2,0xA4D2}, {0,0xA4D3,0xA4D3,0xA4D3},
 {0,0xA4D4,0xA4D4,0xA4D4}, {0,0xA4D5,0xA4D5,0xA4D5}, {0,0xA4D6,0xA4D6,0xA4D6}, {0,0xA4D7,0xA4D7,0xA4D7},
 {0,0xA4D8,0xA4D8,0xA4D8}, {0,0xA4D9,0xA4D9,0xA4D9}, {0,0xA4DA,0xA4DA,0xA4DA}, {0,0xA4DB,0xA4DB,0xA4DB},
 {0,0xA4DC,0xA4DC,0xA4DC}, {0,0xA4DD,0xA4DD,0xA4DD}, {0,0xA4DE,0xA4DE,0xA4DE}, {0,0xA4DF,0xA4DF,0xA4DF},
 {0,0xA4E0,0xA4E0,0xA4E0}, {0,0xA4E1,0xA4E1,0xA4E1}, {0,0xA4E2,0xA4E2,0xA4E2}, {0,0xA4E3,0xA4E3,0xA4E3},
 {0,0xA4E4,0xA4E4,0xA4E4}, {0,0xA4E5,0xA4E5,0xA4E5}, {0,0xA4E6,0xA4E6,0xA4E6}, {0,0xA4E7,0xA4E7,0xA4E7},
 {0,0xA4E8,0xA4E8,0xA4E8}, {0,0xA4E9,0xA4E9,0xA4E9}, {0,0xA4EA,0xA4EA,0xA4EA}, {0,0xA4EB,0xA4EB,0xA4EB},
 {0,0xA4EC,0xA4EC,0xA4EC}, {0,0xA4ED,0xA4ED,0xA4ED}, {0,0xA4EE,0xA4EE,0xA4EE}, {0,0xA4EF,0xA4EF,0xA4EF},
 {0,0xA4F0,0xA4F0,0xA4F0}, {0,0xA4F1,0xA4F1,0xA4F1}, {0,0xA4F2,0xA4F2,0xA4F2}, {0,0xA4F3,0xA4F3,0xA4F3},
 {0,0xA4F4,0xA4F4,0xA4F4}, {0,0xA4F5,0xA4F5,0xA4F5}, {0,0xA4F6,0xA4F6,0xA4F6}, {0,0xA4F7,0xA4F7,0xA4F7},
 {0,0xA4F8,0xA4F8,0xA4F8}, {0,0xA4F9,0xA4F9,0xA4F9}, {0,0xA4FA,0xA4FA,0xA4FA}, {0,0xA4FB,0xA4FB,0xA4FB},
 {0,0xA4FC,0xA4FC,0xA4FC}, {0,0xA4FD,0xA4FD,0xA4FD}, {0,0xA4FE,0xA4FE,0xA4FE}, {0,0xA4FF,0xA4FF,0xA4FF},
{0,0}};

static UDM_UNICODE planeD7[257]={
 {1,0xD700,0xD700,0xD700}, {1,0xD701,0xD701,0xD701}, {1,0xD702,0xD702,0xD702}, {1,0xD703,0xD703,0xD703},
 {1,0xD704,0xD704,0xD704}, {1,0xD705,0xD705,0xD705}, {1,0xD706,0xD706,0xD706}, {1,0xD707,0xD707,0xD707},
 {1,0xD708,0xD708,0xD708}, {1,0xD709,0xD709,0xD709}, {1,0xD70A,0xD70A,0xD70A}, {1,0xD70B,0xD70B,0xD70B},
 {1,0xD70C,0xD70C,0xD70C}, {1,0xD70D,0xD70D,0xD70D}, {1,0xD70E,0xD70E,0xD70E}, {1,0xD70F,0xD70F,0xD70F},
 {1,0xD710,0xD710,0xD710}, {1,0xD711,0xD711,0xD711}, {1,0xD712,0xD712,0xD712}, {1,0xD713,0xD713,0xD713},
 {1,0xD714,0xD714,0xD714}, {1,0xD715,0xD715,0xD715}, {1,0xD716,0xD716,0xD716}, {1,0xD717,0xD717,0xD717},
 {1,0xD718,0xD718,0xD718}, {1,0xD719,0xD719,0xD719}, {1,0xD71A,0xD71A,0xD71A}, {1,0xD71B,0xD71B,0xD71B},
 {1,0xD71C,0xD71C,0xD71C}, {1,0xD71D,0xD71D,0xD71D}, {1,0xD71E,0xD71E,0xD71E}, {1,0xD71F,0xD71F,0xD71F},
 {1,0xD720,0xD720,0xD720}, {1,0xD721,0xD721,0xD721}, {1,0xD722,0xD722,0xD722}, {1,0xD723,0xD723,0xD723},
 {1,0xD724,0xD724,0xD724}, {1,0xD725,0xD725,0xD725}, {1,0xD726,0xD726,0xD726}, {1,0xD727,0xD727,0xD727},
 {1,0xD728,0xD728,0xD728}, {1,0xD729,0xD729,0xD729}, {1,0xD72A,0xD72A,0xD72A}, {1,0xD72B,0xD72B,0xD72B},
 {1,0xD72C,0xD72C,0xD72C}, {1,0xD72D,0xD72D,0xD72D}, {1,0xD72E,0xD72E,0xD72E}, {1,0xD72F,0xD72F,0xD72F},
 {1,0xD730,0xD730,0xD730}, {1,0xD731,0xD731,0xD731}, {1,0xD732,0xD732,0xD732}, {1,0xD733,0xD733,0xD733},
 {1,0xD734,0xD734,0xD734}, {1,0xD735,0xD735,0xD735}, {1,0xD736,0xD736,0xD736}, {1,0xD737,0xD737,0xD737},
 {1,0xD738,0xD738,0xD738}, {1,0xD739,0xD739,0xD739}, {1,0xD73A,0xD73A,0xD73A}, {1,0xD73B,0xD73B,0xD73B},
 {1,0xD73C,0xD73C,0xD73C}, {1,0xD73D,0xD73D,0xD73D}, {1,0xD73E,0xD73E,0xD73E}, {1,0xD73F,0xD73F,0xD73F},
 {1,0xD740,0xD740,0xD740}, {1,0xD741,0xD741,0xD741}, {1,0xD742,0xD742,0xD742}, {1,0xD743,0xD743,0xD743},
 {1,0xD744,0xD744,0xD744}, {1,0xD745,0xD745,0xD745}, {1,0xD746,0xD746,0xD746}, {1,0xD747,0xD747,0xD747},
 {1,0xD748,0xD748,0xD748}, {1,0xD749,0xD749,0xD749}, {1,0xD74A,0xD74A,0xD74A}, {1,0xD74B,0xD74B,0xD74B},
 {1,0xD74C,0xD74C,0xD74C}, {1,0xD74D,0xD74D,0xD74D}, {1,0xD74E,0xD74E,0xD74E}, {1,0xD74F,0xD74F,0xD74F},
 {1,0xD750,0xD750,0xD750}, {1,0xD751,0xD751,0xD751}, {1,0xD752,0xD752,0xD752}, {1,0xD753,0xD753,0xD753},
 {1,0xD754,0xD754,0xD754}, {1,0xD755,0xD755,0xD755}, {1,0xD756,0xD756,0xD756}, {1,0xD757,0xD757,0xD757},
 {1,0xD758,0xD758,0xD758}, {1,0xD759,0xD759,0xD759}, {1,0xD75A,0xD75A,0xD75A}, {1,0xD75B,0xD75B,0xD75B},
 {1,0xD75C,0xD75C,0xD75C}, {1,0xD75D,0xD75D,0xD75D}, {1,0xD75E,0xD75E,0xD75E}, {1,0xD75F,0xD75F,0xD75F},
 {1,0xD760,0xD760,0xD760}, {1,0xD761,0xD761,0xD761}, {1,0xD762,0xD762,0xD762}, {1,0xD763,0xD763,0xD763},
 {1,0xD764,0xD764,0xD764}, {1,0xD765,0xD765,0xD765}, {1,0xD766,0xD766,0xD766}, {1,0xD767,0xD767,0xD767},
 {1,0xD768,0xD768,0xD768}, {1,0xD769,0xD769,0xD769}, {1,0xD76A,0xD76A,0xD76A}, {1,0xD76B,0xD76B,0xD76B},
 {1,0xD76C,0xD76C,0xD76C}, {1,0xD76D,0xD76D,0xD76D}, {1,0xD76E,0xD76E,0xD76E}, {1,0xD76F,0xD76F,0xD76F},
 {1,0xD770,0xD770,0xD770}, {1,0xD771,0xD771,0xD771}, {1,0xD772,0xD772,0xD772}, {1,0xD773,0xD773,0xD773},
 {1,0xD774,0xD774,0xD774}, {1,0xD775,0xD775,0xD775}, {1,0xD776,0xD776,0xD776}, {1,0xD777,0xD777,0xD777},
 {1,0xD778,0xD778,0xD778}, {1,0xD779,0xD779,0xD779}, {1,0xD77A,0xD77A,0xD77A}, {1,0xD77B,0xD77B,0xD77B},
 {1,0xD77C,0xD77C,0xD77C}, {1,0xD77D,0xD77D,0xD77D}, {1,0xD77E,0xD77E,0xD77E}, {1,0xD77F,0xD77F,0xD77F},
 {1,0xD780,0xD780,0xD780}, {1,0xD781,0xD781,0xD781}, {1,0xD782,0xD782,0xD782}, {1,0xD783,0xD783,0xD783},
 {1,0xD784,0xD784,0xD784}, {1,0xD785,0xD785,0xD785}, {1,0xD786,0xD786,0xD786}, {1,0xD787,0xD787,0xD787},
 {1,0xD788,0xD788,0xD788}, {1,0xD789,0xD789,0xD789}, {1,0xD78A,0xD78A,0xD78A}, {1,0xD78B,0xD78B,0xD78B},
 {1,0xD78C,0xD78C,0xD78C}, {1,0xD78D,0xD78D,0xD78D}, {1,0xD78E,0xD78E,0xD78E}, {1,0xD78F,0xD78F,0xD78F},
 {1,0xD790,0xD790,0xD790}, {1,0xD791,0xD791,0xD791}, {1,0xD792,0xD792,0xD792}, {1,0xD793,0xD793,0xD793},
 {1,0xD794,0xD794,0xD794}, {1,0xD795,0xD795,0xD795}, {1,0xD796,0xD796,0xD796}, {1,0xD797,0xD797,0xD797},
 {1,0xD798,0xD798,0xD798}, {1,0xD799,0xD799,0xD799}, {1,0xD79A,0xD79A,0xD79A}, {1,0xD79B,0xD79B,0xD79B},
 {1,0xD79C,0xD79C,0xD79C}, {1,0xD79D,0xD79D,0xD79D}, {1,0xD79E,0xD79E,0xD79E}, {1,0xD79F,0xD79F,0xD79F},
 {1,0xD7A0,0xD7A0,0xD7A0}, {1,0xD7A1,0xD7A1,0xD7A1}, {1,0xD7A2,0xD7A2,0xD7A2}, {1,0xD7A3,0xD7A3,0xD7A3},
 {0,0xD7A4,0xD7A4,0xD7A4}, {0,0xD7A5,0xD7A5,0xD7A5}, {0,0xD7A6,0xD7A6,0xD7A6}, {0,0xD7A7,0xD7A7,0xD7A7},
 {0,0xD7A8,0xD7A8,0xD7A8}, {0,0xD7A9,0xD7A9,0xD7A9}, {0,0xD7AA,0xD7AA,0xD7AA}, {0,0xD7AB,0xD7AB,0xD7AB},
 {0,0xD7AC,0xD7AC,0xD7AC}, {0,0xD7AD,0xD7AD,0xD7AD}, {0,0xD7AE,0xD7AE,0xD7AE}, {0,0xD7AF,0xD7AF,0xD7AF},
 {0,0xD7B0,0xD7B0,0xD7B0}, {0,0xD7B1,0xD7B1,0xD7B1}, {0,0xD7B2,0xD7B2,0xD7B2}, {0,0xD7B3,0xD7B3,0xD7B3},
 {0,0xD7B4,0xD7B4,0xD7B4}, {0,0xD7B5,0xD7B5,0xD7B5}, {0,0xD7B6,0xD7B6,0xD7B6}, {0,0xD7B7,0xD7B7,0xD7B7},
 {0,0xD7B8,0xD7B8,0xD7B8}, {0,0xD7B9,0xD7B9,0xD7B9}, {0,0xD7BA,0xD7BA,0xD7BA}, {0,0xD7BB,0xD7BB,0xD7BB},
 {0,0xD7BC,0xD7BC,0xD7BC}, {0,0xD7BD,0xD7BD,0xD7BD}, {0,0xD7BE,0xD7BE,0xD7BE}, {0,0xD7BF,0xD7BF,0xD7BF},
 {0,0xD7C0,0xD7C0,0xD7C0}, {0,0xD7C1,0xD7C1,0xD7C1}, {0,0xD7C2,0xD7C2,0xD7C2}, {0,0xD7C3,0xD7C3,0xD7C3},
 {0,0xD7C4,0xD7C4,0xD7C4}, {0,0xD7C5,0xD7C5,0xD7C5}, {0,0xD7C6,0xD7C6,0xD7C6}, {0,0xD7C7,0xD7C7,0xD7C7},
 {0,0xD7C8,0xD7C8,0xD7C8}, {0,0xD7C9,0xD7C9,0xD7C9}, {0,0xD7CA,0xD7CA,0xD7CA}, {0,0xD7CB,0xD7CB,0xD7CB},
 {0,0xD7CC,0xD7CC,0xD7CC}, {0,0xD7CD,0xD7CD,0xD7CD}, {0,0xD7CE,0xD7CE,0xD7CE}, {0,0xD7CF,0xD7CF,0xD7CF},
 {0,0xD7D0,0xD7D0,0xD7D0}, {0,0xD7D1,0xD7D1,0xD7D1}, {0,0xD7D2,0xD7D2,0xD7D2}, {0,0xD7D3,0xD7D3,0xD7D3},
 {0,0xD7D4,0xD7D4,0xD7D4}, {0,0xD7D5,0xD7D5,0xD7D5}, {0,0xD7D6,0xD7D6,0xD7D6}, {0,0xD7D7,0xD7D7,0xD7D7},
 {0,0xD7D8,0xD7D8,0xD7D8}, {0,0xD7D9,0xD7D9,0xD7D9}, {0,0xD7DA,0xD7DA,0xD7DA}, {0,0xD7DB,0xD7DB,0xD7DB},
 {0,0xD7DC,0xD7DC,0xD7DC}, {0,0xD7DD,0xD7DD,0xD7DD}, {0,0xD7DE,0xD7DE,0xD7DE}, {0,0xD7DF,0xD7DF,0xD7DF},
 {0,0xD7E0,0xD7E0,0xD7E0}, {0,0xD7E1,0xD7E1,0xD7E1}, {0,0xD7E2,0xD7E2,0xD7E2}, {0,0xD7E3,0xD7E3,0xD7E3},
 {0,0xD7E4,0xD7E4,0xD7E4}, {0,0xD7E5,0xD7E5,0xD7E5}, {0,0xD7E6,0xD7E6,0xD7E6}, {0,0xD7E7,0xD7E7,0xD7E7},
 {0,0xD7E8,0xD7E8,0xD7E8}, {0,0xD7E9,0xD7E9,0xD7E9}, {0,0xD7EA,0xD7EA,0xD7EA}, {0,0xD7EB,0xD7EB,0xD7EB},
 {0,0xD7EC,0xD7EC,0xD7EC}, {0,0xD7ED,0xD7ED,0xD7ED}, {0,0xD7EE,0xD7EE,0xD7EE}, {0,0xD7EF,0xD7EF,0xD7EF},
 {0,0xD7F0,0xD7F0,0xD7F0}, {0,0xD7F1,0xD7F1,0xD7F1}, {0,0xD7F2,0xD7F2,0xD7F2}, {0,0xD7F3,0xD7F3,0xD7F3},
 {0,0xD7F4,0xD7F4,0xD7F4}, {0,0xD7F5,0xD7F5,0xD7F5}, {0,0xD7F6,0xD7F6,0xD7F6}, {0,0xD7F7,0xD7F7,0xD7F7},
 {0,0xD7F8,0xD7F8,0xD7F8}, {0,0xD7F9,0xD7F9,0xD7F9}, {0,0xD7FA,0xD7FA,0xD7FA}, {0,0xD7FB,0xD7FB,0xD7FB},
 {0,0xD7FC,0xD7FC,0xD7FC}, {0,0xD7FD,0xD7FD,0xD7FD}, {0,0xD7FE,0xD7FE,0xD7FE}, {0,0xD7FF,0xD7FF,0xD7FF},
{0,0}};

static UDM_UNICODE planeFA[257]={
 {1,0xFA00,0xFA00,0xFA00}, {1,0xFA01,0xFA01,0xFA01}, {1,0xFA02,0xFA02,0xFA02}, {1,0xFA03,0xFA03,0xFA03},
 {1,0xFA04,0xFA04,0xFA04}, {1,0xFA05,0xFA05,0xFA05}, {1,0xFA06,0xFA06,0xFA06}, {1,0xFA07,0xFA07,0xFA07},
 {1,0xFA08,0xFA08,0xFA08}, {1,0xFA09,0xFA09,0xFA09}, {1,0xFA0A,0xFA0A,0xFA0A}, {1,0xFA0B,0xFA0B,0xFA0B},
 {1,0xFA0C,0xFA0C,0xFA0C}, {1,0xFA0D,0xFA0D,0xFA0D}, {1,0xFA0E,0xFA0E,0xFA0E}, {1,0xFA0F,0xFA0F,0xFA0F},
 {1,0xFA10,0xFA10,0xFA10}, {1,0xFA11,0xFA11,0xFA11}, {1,0xFA12,0xFA12,0xFA12}, {1,0xFA13,0xFA13,0xFA13},
 {1,0xFA14,0xFA14,0xFA14}, {1,0xFA15,0xFA15,0xFA15}, {1,0xFA16,0xFA16,0xFA16}, {1,0xFA17,0xFA17,0xFA17},
 {1,0xFA18,0xFA18,0xFA18}, {1,0xFA19,0xFA19,0xFA19}, {1,0xFA1A,0xFA1A,0xFA1A}, {1,0xFA1B,0xFA1B,0xFA1B},
 {1,0xFA1C,0xFA1C,0xFA1C}, {1,0xFA1D,0xFA1D,0xFA1D}, {1,0xFA1E,0xFA1E,0xFA1E}, {1,0xFA1F,0xFA1F,0xFA1F},
 {1,0xFA20,0xFA20,0xFA20}, {1,0xFA21,0xFA21,0xFA21}, {1,0xFA22,0xFA22,0xFA22}, {1,0xFA23,0xFA23,0xFA23},
 {1,0xFA24,0xFA24,0xFA24}, {1,0xFA25,0xFA25,0xFA25}, {1,0xFA26,0xFA26,0xFA26}, {1,0xFA27,0xFA27,0xFA27},
 {1,0xFA28,0xFA28,0xFA28}, {1,0xFA29,0xFA29,0xFA29}, {1,0xFA2A,0xFA2A,0xFA2A}, {1,0xFA2B,0xFA2B,0xFA2B},
 {1,0xFA2C,0xFA2C,0xFA2C}, {1,0xFA2D,0xFA2D,0xFA2D}, {0,0xFA2E,0xFA2E,0xFA2E}, {0,0xFA2F,0xFA2F,0xFA2F},
 {0,0xFA30,0xFA30,0xFA30}, {0,0xFA31,0xFA31,0xFA31}, {0,0xFA32,0xFA32,0xFA32}, {0,0xFA33,0xFA33,0xFA33},
 {0,0xFA34,0xFA34,0xFA34}, {0,0xFA35,0xFA35,0xFA35}, {0,0xFA36,0xFA36,0xFA36}, {0,0xFA37,0xFA37,0xFA37},
 {0,0xFA38,0xFA38,0xFA38}, {0,0xFA39,0xFA39,0xFA39}, {0,0xFA3A,0xFA3A,0xFA3A}, {0,0xFA3B,0xFA3B,0xFA3B},
 {0,0xFA3C,0xFA3C,0xFA3C}, {0,0xFA3D,0xFA3D,0xFA3D}, {0,0xFA3E,0xFA3E,0xFA3E}, {0,0xFA3F,0xFA3F,0xFA3F},
 {0,0xFA40,0xFA40,0xFA40}, {0,0xFA41,0xFA41,0xFA41}, {0,0xFA42,0xFA42,0xFA42}, {0,0xFA43,0xFA43,0xFA43},
 {0,0xFA44,0xFA44,0xFA44}, {0,0xFA45,0xFA45,0xFA45}, {0,0xFA46,0xFA46,0xFA46}, {0,0xFA47,0xFA47,0xFA47},
 {0,0xFA48,0xFA48,0xFA48}, {0,0xFA49,0xFA49,0xFA49}, {0,0xFA4A,0xFA4A,0xFA4A}, {0,0xFA4B,0xFA4B,0xFA4B},
 {0,0xFA4C,0xFA4C,0xFA4C}, {0,0xFA4D,0xFA4D,0xFA4D}, {0,0xFA4E,0xFA4E,0xFA4E}, {0,0xFA4F,0xFA4F,0xFA4F},
 {0,0xFA50,0xFA50,0xFA50}, {0,0xFA51,0xFA51,0xFA51}, {0,0xFA52,0xFA52,0xFA52}, {0,0xFA53,0xFA53,0xFA53},
 {0,0xFA54,0xFA54,0xFA54}, {0,0xFA55,0xFA55,0xFA55}, {0,0xFA56,0xFA56,0xFA56}, {0,0xFA57,0xFA57,0xFA57},
 {0,0xFA58,0xFA58,0xFA58}, {0,0xFA59,0xFA59,0xFA59}, {0,0xFA5A,0xFA5A,0xFA5A}, {0,0xFA5B,0xFA5B,0xFA5B},
 {0,0xFA5C,0xFA5C,0xFA5C}, {0,0xFA5D,0xFA5D,0xFA5D}, {0,0xFA5E,0xFA5E,0xFA5E}, {0,0xFA5F,0xFA5F,0xFA5F},
 {0,0xFA60,0xFA60,0xFA60}, {0,0xFA61,0xFA61,0xFA61}, {0,0xFA62,0xFA62,0xFA62}, {0,0xFA63,0xFA63,0xFA63},
 {0,0xFA64,0xFA64,0xFA64}, {0,0xFA65,0xFA65,0xFA65}, {0,0xFA66,0xFA66,0xFA66}, {0,0xFA67,0xFA67,0xFA67},
 {0,0xFA68,0xFA68,0xFA68}, {0,0xFA69,0xFA69,0xFA69}, {0,0xFA6A,0xFA6A,0xFA6A}, {0,0xFA6B,0xFA6B,0xFA6B},
 {0,0xFA6C,0xFA6C,0xFA6C}, {0,0xFA6D,0xFA6D,0xFA6D}, {0,0xFA6E,0xFA6E,0xFA6E}, {0,0xFA6F,0xFA6F,0xFA6F},
 {0,0xFA70,0xFA70,0xFA70}, {0,0xFA71,0xFA71,0xFA71}, {0,0xFA72,0xFA72,0xFA72}, {0,0xFA73,0xFA73,0xFA73},
 {0,0xFA74,0xFA74,0xFA74}, {0,0xFA75,0xFA75,0xFA75}, {0,0xFA76,0xFA76,0xFA76}, {0,0xFA77,0xFA77,0xFA77},
 {0,0xFA78,0xFA78,0xFA78}, {0,0xFA79,0xFA79,0xFA79}, {0,0xFA7A,0xFA7A,0xFA7A}, {0,0xFA7B,0xFA7B,0xFA7B},
 {0,0xFA7C,0xFA7C,0xFA7C}, {0,0xFA7D,0xFA7D,0xFA7D}, {0,0xFA7E,0xFA7E,0xFA7E}, {0,0xFA7F,0xFA7F,0xFA7F},
 {0,0xFA80,0xFA80,0xFA80}, {0,0xFA81,0xFA81,0xFA81}, {0,0xFA82,0xFA82,0xFA82}, {0,0xFA83,0xFA83,0xFA83},
 {0,0xFA84,0xFA84,0xFA84}, {0,0xFA85,0xFA85,0xFA85}, {0,0xFA86,0xFA86,0xFA86}, {0,0xFA87,0xFA87,0xFA87},
 {0,0xFA88,0xFA88,0xFA88}, {0,0xFA89,0xFA89,0xFA89}, {0,0xFA8A,0xFA8A,0xFA8A}, {0,0xFA8B,0xFA8B,0xFA8B},
 {0,0xFA8C,0xFA8C,0xFA8C}, {0,0xFA8D,0xFA8D,0xFA8D}, {0,0xFA8E,0xFA8E,0xFA8E}, {0,0xFA8F,0xFA8F,0xFA8F},
 {0,0xFA90,0xFA90,0xFA90}, {0,0xFA91,0xFA91,0xFA91}, {0,0xFA92,0xFA92,0xFA92}, {0,0xFA93,0xFA93,0xFA93},
 {0,0xFA94,0xFA94,0xFA94}, {0,0xFA95,0xFA95,0xFA95}, {0,0xFA96,0xFA96,0xFA96}, {0,0xFA97,0xFA97,0xFA97},
 {0,0xFA98,0xFA98,0xFA98}, {0,0xFA99,0xFA99,0xFA99}, {0,0xFA9A,0xFA9A,0xFA9A}, {0,0xFA9B,0xFA9B,0xFA9B},
 {0,0xFA9C,0xFA9C,0xFA9C}, {0,0xFA9D,0xFA9D,0xFA9D}, {0,0xFA9E,0xFA9E,0xFA9E}, {0,0xFA9F,0xFA9F,0xFA9F},
 {0,0xFAA0,0xFAA0,0xFAA0}, {0,0xFAA1,0xFAA1,0xFAA1}, {0,0xFAA2,0xFAA2,0xFAA2}, {0,0xFAA3,0xFAA3,0xFAA3},
 {0,0xFAA4,0xFAA4,0xFAA4}, {0,0xFAA5,0xFAA5,0xFAA5}, {0,0xFAA6,0xFAA6,0xFAA6}, {0,0xFAA7,0xFAA7,0xFAA7},
 {0,0xFAA8,0xFAA8,0xFAA8}, {0,0xFAA9,0xFAA9,0xFAA9}, {0,0xFAAA,0xFAAA,0xFAAA}, {0,0xFAAB,0xFAAB,0xFAAB},
 {0,0xFAAC,0xFAAC,0xFAAC}, {0,0xFAAD,0xFAAD,0xFAAD}, {0,0xFAAE,0xFAAE,0xFAAE}, {0,0xFAAF,0xFAAF,0xFAAF},
 {0,0xFAB0,0xFAB0,0xFAB0}, {0,0xFAB1,0xFAB1,0xFAB1}, {0,0xFAB2,0xFAB2,0xFAB2}, {0,0xFAB3,0xFAB3,0xFAB3},
 {0,0xFAB4,0xFAB4,0xFAB4}, {0,0xFAB5,0xFAB5,0xFAB5}, {0,0xFAB6,0xFAB6,0xFAB6}, {0,0xFAB7,0xFAB7,0xFAB7},
 {0,0xFAB8,0xFAB8,0xFAB8}, {0,0xFAB9,0xFAB9,0xFAB9}, {0,0xFABA,0xFABA,0xFABA}, {0,0xFABB,0xFABB,0xFABB},
 {0,0xFABC,0xFABC,0xFABC}, {0,0xFABD,0xFABD,0xFABD}, {0,0xFABE,0xFABE,0xFABE}, {0,0xFABF,0xFABF,0xFABF},
 {0,0xFAC0,0xFAC0,0xFAC0}, {0,0xFAC1,0xFAC1,0xFAC1}, {0,0xFAC2,0xFAC2,0xFAC2}, {0,0xFAC3,0xFAC3,0xFAC3},
 {0,0xFAC4,0xFAC4,0xFAC4}, {0,0xFAC5,0xFAC5,0xFAC5}, {0,0xFAC6,0xFAC6,0xFAC6}, {0,0xFAC7,0xFAC7,0xFAC7},
 {0,0xFAC8,0xFAC8,0xFAC8}, {0,0xFAC9,0xFAC9,0xFAC9}, {0,0xFACA,0xFACA,0xFACA}, {0,0xFACB,0xFACB,0xFACB},
 {0,0xFACC,0xFACC,0xFACC}, {0,0xFACD,0xFACD,0xFACD}, {0,0xFACE,0xFACE,0xFACE}, {0,0xFACF,0xFACF,0xFACF},
 {0,0xFAD0,0xFAD0,0xFAD0}, {0,0xFAD1,0xFAD1,0xFAD1}, {0,0xFAD2,0xFAD2,0xFAD2}, {0,0xFAD3,0xFAD3,0xFAD3},
 {0,0xFAD4,0xFAD4,0xFAD4}, {0,0xFAD5,0xFAD5,0xFAD5}, {0,0xFAD6,0xFAD6,0xFAD6}, {0,0xFAD7,0xFAD7,0xFAD7},
 {0,0xFAD8,0xFAD8,0xFAD8}, {0,0xFAD9,0xFAD9,0xFAD9}, {0,0xFADA,0xFADA,0xFADA}, {0,0xFADB,0xFADB,0xFADB},
 {0,0xFADC,0xFADC,0xFADC}, {0,0xFADD,0xFADD,0xFADD}, {0,0xFADE,0xFADE,0xFADE}, {0,0xFADF,0xFADF,0xFADF},
 {0,0xFAE0,0xFAE0,0xFAE0}, {0,0xFAE1,0xFAE1,0xFAE1}, {0,0xFAE2,0xFAE2,0xFAE2}, {0,0xFAE3,0xFAE3,0xFAE3},
 {0,0xFAE4,0xFAE4,0xFAE4}, {0,0xFAE5,0xFAE5,0xFAE5}, {0,0xFAE6,0xFAE6,0xFAE6}, {0,0xFAE7,0xFAE7,0xFAE7},
 {0,0xFAE8,0xFAE8,0xFAE8}, {0,0xFAE9,0xFAE9,0xFAE9}, {0,0xFAEA,0xFAEA,0xFAEA}, {0,0xFAEB,0xFAEB,0xFAEB},
 {0,0xFAEC,0xFAEC,0xFAEC}, {0,0xFAED,0xFAED,0xFAED}, {0,0xFAEE,0xFAEE,0xFAEE}, {0,0xFAEF,0xFAEF,0xFAEF},
 {0,0xFAF0,0xFAF0,0xFAF0}, {0,0xFAF1,0xFAF1,0xFAF1}, {0,0xFAF2,0xFAF2,0xFAF2}, {0,0xFAF3,0xFAF3,0xFAF3},
 {0,0xFAF4,0xFAF4,0xFAF4}, {0,0xFAF5,0xFAF5,0xFAF5}, {0,0xFAF6,0xFAF6,0xFAF6}, {0,0xFAF7,0xFAF7,0xFAF7},
 {0,0xFAF8,0xFAF8,0xFAF8}, {0,0xFAF9,0xFAF9,0xFAF9}, {0,0xFAFA,0xFAFA,0xFAFA}, {0,0xFAFB,0xFAFB,0xFAFB},
 {0,0xFAFC,0xFAFC,0xFAFC}, {0,0xFAFD,0xFAFD,0xFAFD}, {0,0xFAFE,0xFAFE,0xFAFE}, {0,0xFAFF,0xFAFF,0xFAFF},
{0,0}};

static UDM_UNICODE planeFB[257]={
 {1,0xFB00,0xFB00,0xFB00}, {1,0xFB01,0xFB01,0xFB01}, {1,0xFB02,0xFB02,0xFB02}, {1,0xFB03,0xFB03,0xFB03},
 {1,0xFB04,0xFB04,0xFB04}, {1,0xFB05,0xFB05,0xFB05}, {1,0xFB06,0xFB06,0xFB06}, {0,0xFB07,0xFB07,0xFB07},
 {0,0xFB08,0xFB08,0xFB08}, {0,0xFB09,0xFB09,0xFB09}, {0,0xFB0A,0xFB0A,0xFB0A}, {0,0xFB0B,0xFB0B,0xFB0B},
 {0,0xFB0C,0xFB0C,0xFB0C}, {0,0xFB0D,0xFB0D,0xFB0D}, {0,0xFB0E,0xFB0E,0xFB0E}, {0,0xFB0F,0xFB0F,0xFB0F},
 {0,0xFB10,0xFB10,0xFB10}, {0,0xFB11,0xFB11,0xFB11}, {0,0xFB12,0xFB12,0xFB12}, {1,0xFB13,0xFB13,0xFB13},
 {1,0xFB14,0xFB14,0xFB14}, {1,0xFB15,0xFB15,0xFB15}, {1,0xFB16,0xFB16,0xFB16}, {1,0xFB17,0xFB17,0xFB17},
 {0,0xFB18,0xFB18,0xFB18}, {0,0xFB19,0xFB19,0xFB19}, {0,0xFB1A,0xFB1A,0xFB1A}, {0,0xFB1B,0xFB1B,0xFB1B},
 {0,0xFB1C,0xFB1C,0xFB1C}, {1,0xFB1D,0xFB1D,0xFB1D}, {1,0xFB1E,0xFB1E,0xFB1E}, {1,0xFB1F,0xFB1F,0xFB1F},
 {1,0xFB20,0xFB20,0xFB20}, {1,0xFB21,0xFB21,0xFB21}, {1,0xFB22,0xFB22,0xFB22}, {1,0xFB23,0xFB23,0xFB23},
 {1,0xFB24,0xFB24,0xFB24}, {1,0xFB25,0xFB25,0xFB25}, {1,0xFB26,0xFB26,0xFB26}, {1,0xFB27,0xFB27,0xFB27},
 {1,0xFB28,0xFB28,0xFB28}, {0,0xFB29,0xFB29,0xFB29}, {1,0xFB2A,0xFB2A,0xFB2A}, {1,0xFB2B,0xFB2B,0xFB2B},
 {1,0xFB2C,0xFB2C,0xFB2C}, {1,0xFB2D,0xFB2D,0xFB2D}, {1,0xFB2E,0xFB2E,0xFB2E}, {1,0xFB2F,0xFB2F,0xFB2F},
 {1,0xFB30,0xFB30,0xFB30}, {1,0xFB31,0xFB31,0xFB31}, {1,0xFB32,0xFB32,0xFB32}, {1,0xFB33,0xFB33,0xFB33},
 {1,0xFB34,0xFB34,0xFB34}, {1,0xFB35,0xFB35,0xFB35}, {1,0xFB36,0xFB36,0xFB36}, {0,0xFB37,0xFB37,0xFB37},
 {1,0xFB38,0xFB38,0xFB38}, {1,0xFB39,0xFB39,0xFB39}, {1,0xFB3A,0xFB3A,0xFB3A}, {1,0xFB3B,0xFB3B,0xFB3B},
 {1,0xFB3C,0xFB3C,0xFB3C}, {0,0xFB3D,0xFB3D,0xFB3D}, {1,0xFB3E,0xFB3E,0xFB3E}, {0,0xFB3F,0xFB3F,0xFB3F},
 {1,0xFB40,0xFB40,0xFB40}, {1,0xFB41,0xFB41,0xFB41}, {0,0xFB42,0xFB42,0xFB42}, {1,0xFB43,0xFB43,0xFB43},
 {1,0xFB44,0xFB44,0xFB44}, {0,0xFB45,0xFB45,0xFB45}, {1,0xFB46,0xFB46,0xFB46}, {1,0xFB47,0xFB47,0xFB47},
 {1,0xFB48,0xFB48,0xFB48}, {1,0xFB49,0xFB49,0xFB49}, {1,0xFB4A,0xFB4A,0xFB4A}, {1,0xFB4B,0xFB4B,0xFB4B},
 {1,0xFB4C,0xFB4C,0xFB4C}, {1,0xFB4D,0xFB4D,0xFB4D}, {1,0xFB4E,0xFB4E,0xFB4E}, {1,0xFB4F,0xFB4F,0xFB4F},
 {1,0xFB50,0xFB50,0xFB50}, {1,0xFB51,0xFB51,0xFB51}, {1,0xFB52,0xFB52,0xFB52}, {1,0xFB53,0xFB53,0xFB53},
 {1,0xFB54,0xFB54,0xFB54}, {1,0xFB55,0xFB55,0xFB55}, {1,0xFB56,0xFB56,0xFB56}, {1,0xFB57,0xFB57,0xFB57},
 {1,0xFB58,0xFB58,0xFB58}, {1,0xFB59,0xFB59,0xFB59}, {1,0xFB5A,0xFB5A,0xFB5A}, {1,0xFB5B,0xFB5B,0xFB5B},
 {1,0xFB5C,0xFB5C,0xFB5C}, {1,0xFB5D,0xFB5D,0xFB5D}, {1,0xFB5E,0xFB5E,0xFB5E}, {1,0xFB5F,0xFB5F,0xFB5F},
 {1,0xFB60,0xFB60,0xFB60}, {1,0xFB61,0xFB61,0xFB61}, {1,0xFB62,0xFB62,0xFB62}, {1,0xFB63,0xFB63,0xFB63},
 {1,0xFB64,0xFB64,0xFB64}, {1,0xFB65,0xFB65,0xFB65}, {1,0xFB66,0xFB66,0xFB66}, {1,0xFB67,0xFB67,0xFB67},
 {1,0xFB68,0xFB68,0xFB68}, {1,0xFB69,0xFB69,0xFB69}, {1,0xFB6A,0xFB6A,0xFB6A}, {1,0xFB6B,0xFB6B,0xFB6B},
 {1,0xFB6C,0xFB6C,0xFB6C}, {1,0xFB6D,0xFB6D,0xFB6D}, {1,0xFB6E,0xFB6E,0xFB6E}, {1,0xFB6F,0xFB6F,0xFB6F},
 {1,0xFB70,0xFB70,0xFB70}, {1,0xFB71,0xFB71,0xFB71}, {1,0xFB72,0xFB72,0xFB72}, {1,0xFB73,0xFB73,0xFB73},
 {1,0xFB74,0xFB74,0xFB74}, {1,0xFB75,0xFB75,0xFB75}, {1,0xFB76,0xFB76,0xFB76}, {1,0xFB77,0xFB77,0xFB77},
 {1,0xFB78,0xFB78,0xFB78}, {1,0xFB79,0xFB79,0xFB79}, {1,0xFB7A,0xFB7A,0xFB7A}, {1,0xFB7B,0xFB7B,0xFB7B},
 {1,0xFB7C,0xFB7C,0xFB7C}, {1,0xFB7D,0xFB7D,0xFB7D}, {1,0xFB7E,0xFB7E,0xFB7E}, {1,0xFB7F,0xFB7F,0xFB7F},
 {1,0xFB80,0xFB80,0xFB80}, {1,0xFB81,0xFB81,0xFB81}, {1,0xFB82,0xFB82,0xFB82}, {1,0xFB83,0xFB83,0xFB83},
 {1,0xFB84,0xFB84,0xFB84}, {1,0xFB85,0xFB85,0xFB85}, {1,0xFB86,0xFB86,0xFB86}, {1,0xFB87,0xFB87,0xFB87},
 {1,0xFB88,0xFB88,0xFB88}, {1,0xFB89,0xFB89,0xFB89}, {1,0xFB8A,0xFB8A,0xFB8A}, {1,0xFB8B,0xFB8B,0xFB8B},
 {1,0xFB8C,0xFB8C,0xFB8C}, {1,0xFB8D,0xFB8D,0xFB8D}, {1,0xFB8E,0xFB8E,0xFB8E}, {1,0xFB8F,0xFB8F,0xFB8F},
 {1,0xFB90,0xFB90,0xFB90}, {1,0xFB91,0xFB91,0xFB91}, {1,0xFB92,0xFB92,0xFB92}, {1,0xFB93,0xFB93,0xFB93},
 {1,0xFB94,0xFB94,0xFB94}, {1,0xFB95,0xFB95,0xFB95}, {1,0xFB96,0xFB96,0xFB96}, {1,0xFB97,0xFB97,0xFB97},
 {1,0xFB98,0xFB98,0xFB98}, {1,0xFB99,0xFB99,0xFB99}, {1,0xFB9A,0xFB9A,0xFB9A}, {1,0xFB9B,0xFB9B,0xFB9B},
 {1,0xFB9C,0xFB9C,0xFB9C}, {1,0xFB9D,0xFB9D,0xFB9D}, {1,0xFB9E,0xFB9E,0xFB9E}, {1,0xFB9F,0xFB9F,0xFB9F},
 {1,0xFBA0,0xFBA0,0xFBA0}, {1,0xFBA1,0xFBA1,0xFBA1}, {1,0xFBA2,0xFBA2,0xFBA2}, {1,0xFBA3,0xFBA3,0xFBA3},
 {1,0xFBA4,0xFBA4,0xFBA4}, {1,0xFBA5,0xFBA5,0xFBA5}, {1,0xFBA6,0xFBA6,0xFBA6}, {1,0xFBA7,0xFBA7,0xFBA7},
 {1,0xFBA8,0xFBA8,0xFBA8}, {1,0xFBA9,0xFBA9,0xFBA9}, {1,0xFBAA,0xFBAA,0xFBAA}, {1,0xFBAB,0xFBAB,0xFBAB},
 {1,0xFBAC,0xFBAC,0xFBAC}, {1,0xFBAD,0xFBAD,0xFBAD}, {1,0xFBAE,0xFBAE,0xFBAE}, {1,0xFBAF,0xFBAF,0xFBAF},
 {1,0xFBB0,0xFBB0,0xFBB0}, {1,0xFBB1,0xFBB1,0xFBB1}, {0,0xFBB2,0xFBB2,0xFBB2}, {0,0xFBB3,0xFBB3,0xFBB3},
 {0,0xFBB4,0xFBB4,0xFBB4}, {0,0xFBB5,0xFBB5,0xFBB5}, {0,0xFBB6,0xFBB6,0xFBB6}, {0,0xFBB7,0xFBB7,0xFBB7},
 {0,0xFBB8,0xFBB8,0xFBB8}, {0,0xFBB9,0xFBB9,0xFBB9}, {0,0xFBBA,0xFBBA,0xFBBA}, {0,0xFBBB,0xFBBB,0xFBBB},
 {0,0xFBBC,0xFBBC,0xFBBC}, {0,0xFBBD,0xFBBD,0xFBBD}, {0,0xFBBE,0xFBBE,0xFBBE}, {0,0xFBBF,0xFBBF,0xFBBF},
 {0,0xFBC0,0xFBC0,0xFBC0}, {0,0xFBC1,0xFBC1,0xFBC1}, {0,0xFBC2,0xFBC2,0xFBC2}, {0,0xFBC3,0xFBC3,0xFBC3},
 {0,0xFBC4,0xFBC4,0xFBC4}, {0,0xFBC5,0xFBC5,0xFBC5}, {0,0xFBC6,0xFBC6,0xFBC6}, {0,0xFBC7,0xFBC7,0xFBC7},
 {0,0xFBC8,0xFBC8,0xFBC8}, {0,0xFBC9,0xFBC9,0xFBC9}, {0,0xFBCA,0xFBCA,0xFBCA}, {0,0xFBCB,0xFBCB,0xFBCB},
 {0,0xFBCC,0xFBCC,0xFBCC}, {0,0xFBCD,0xFBCD,0xFBCD}, {0,0xFBCE,0xFBCE,0xFBCE}, {0,0xFBCF,0xFBCF,0xFBCF},
 {0,0xFBD0,0xFBD0,0xFBD0}, {0,0xFBD1,0xFBD1,0xFBD1}, {0,0xFBD2,0xFBD2,0xFBD2}, {1,0xFBD3,0xFBD3,0xFBD3},
 {1,0xFBD4,0xFBD4,0xFBD4}, {1,0xFBD5,0xFBD5,0xFBD5}, {1,0xFBD6,0xFBD6,0xFBD6}, {1,0xFBD7,0xFBD7,0xFBD7},
 {1,0xFBD8,0xFBD8,0xFBD8}, {1,0xFBD9,0xFBD9,0xFBD9}, {1,0xFBDA,0xFBDA,0xFBDA}, {1,0xFBDB,0xFBDB,0xFBDB},
 {1,0xFBDC,0xFBDC,0xFBDC}, {1,0xFBDD,0xFBDD,0xFBDD}, {1,0xFBDE,0xFBDE,0xFBDE}, {1,0xFBDF,0xFBDF,0xFBDF},
 {1,0xFBE0,0xFBE0,0xFBE0}, {1,0xFBE1,0xFBE1,0xFBE1}, {1,0xFBE2,0xFBE2,0xFBE2}, {1,0xFBE3,0xFBE3,0xFBE3},
 {1,0xFBE4,0xFBE4,0xFBE4}, {1,0xFBE5,0xFBE5,0xFBE5}, {1,0xFBE6,0xFBE6,0xFBE6}, {1,0xFBE7,0xFBE7,0xFBE7},
 {1,0xFBE8,0xFBE8,0xFBE8}, {1,0xFBE9,0xFBE9,0xFBE9}, {1,0xFBEA,0xFBEA,0xFBEA}, {1,0xFBEB,0xFBEB,0xFBEB},
 {1,0xFBEC,0xFBEC,0xFBEC}, {1,0xFBED,0xFBED,0xFBED}, {1,0xFBEE,0xFBEE,0xFBEE}, {1,0xFBEF,0xFBEF,0xFBEF},
 {1,0xFBF0,0xFBF0,0xFBF0}, {1,0xFBF1,0xFBF1,0xFBF1}, {1,0xFBF2,0xFBF2,0xFBF2}, {1,0xFBF3,0xFBF3,0xFBF3},
 {1,0xFBF4,0xFBF4,0xFBF4}, {1,0xFBF5,0xFBF5,0xFBF5}, {1,0xFBF6,0xFBF6,0xFBF6}, {1,0xFBF7,0xFBF7,0xFBF7},
 {1,0xFBF8,0xFBF8,0xFBF8}, {1,0xFBF9,0xFBF9,0xFBF9}, {1,0xFBFA,0xFBFA,0xFBFA}, {1,0xFBFB,0xFBFB,0xFBFB},
 {1,0xFBFC,0xFBFC,0xFBFC}, {1,0xFBFD,0xFBFD,0xFBFD}, {1,0xFBFE,0xFBFE,0xFBFE}, {1,0xFBFF,0xFBFF,0xFBFF},
{0,0}};

static UDM_UNICODE planeFD[257]={
 {1,0xFD00,0xFD00,0xFD00}, {1,0xFD01,0xFD01,0xFD01}, {1,0xFD02,0xFD02,0xFD02}, {1,0xFD03,0xFD03,0xFD03},
 {1,0xFD04,0xFD04,0xFD04}, {1,0xFD05,0xFD05,0xFD05}, {1,0xFD06,0xFD06,0xFD06}, {1,0xFD07,0xFD07,0xFD07},
 {1,0xFD08,0xFD08,0xFD08}, {1,0xFD09,0xFD09,0xFD09}, {1,0xFD0A,0xFD0A,0xFD0A}, {1,0xFD0B,0xFD0B,0xFD0B},
 {1,0xFD0C,0xFD0C,0xFD0C}, {1,0xFD0D,0xFD0D,0xFD0D}, {1,0xFD0E,0xFD0E,0xFD0E}, {1,0xFD0F,0xFD0F,0xFD0F},
 {1,0xFD10,0xFD10,0xFD10}, {1,0xFD11,0xFD11,0xFD11}, {1,0xFD12,0xFD12,0xFD12}, {1,0xFD13,0xFD13,0xFD13},
 {1,0xFD14,0xFD14,0xFD14}, {1,0xFD15,0xFD15,0xFD15}, {1,0xFD16,0xFD16,0xFD16}, {1,0xFD17,0xFD17,0xFD17},
 {1,0xFD18,0xFD18,0xFD18}, {1,0xFD19,0xFD19,0xFD19}, {1,0xFD1A,0xFD1A,0xFD1A}, {1,0xFD1B,0xFD1B,0xFD1B},
 {1,0xFD1C,0xFD1C,0xFD1C}, {1,0xFD1D,0xFD1D,0xFD1D}, {1,0xFD1E,0xFD1E,0xFD1E}, {1,0xFD1F,0xFD1F,0xFD1F},
 {1,0xFD20,0xFD20,0xFD20}, {1,0xFD21,0xFD21,0xFD21}, {1,0xFD22,0xFD22,0xFD22}, {1,0xFD23,0xFD23,0xFD23},
 {1,0xFD24,0xFD24,0xFD24}, {1,0xFD25,0xFD25,0xFD25}, {1,0xFD26,0xFD26,0xFD26}, {1,0xFD27,0xFD27,0xFD27},
 {1,0xFD28,0xFD28,0xFD28}, {1,0xFD29,0xFD29,0xFD29}, {1,0xFD2A,0xFD2A,0xFD2A}, {1,0xFD2B,0xFD2B,0xFD2B},
 {1,0xFD2C,0xFD2C,0xFD2C}, {1,0xFD2D,0xFD2D,0xFD2D}, {1,0xFD2E,0xFD2E,0xFD2E}, {1,0xFD2F,0xFD2F,0xFD2F},
 {1,0xFD30,0xFD30,0xFD30}, {1,0xFD31,0xFD31,0xFD31}, {1,0xFD32,0xFD32,0xFD32}, {1,0xFD33,0xFD33,0xFD33},
 {1,0xFD34,0xFD34,0xFD34}, {1,0xFD35,0xFD35,0xFD35}, {1,0xFD36,0xFD36,0xFD36}, {1,0xFD37,0xFD37,0xFD37},
 {1,0xFD38,0xFD38,0xFD38}, {1,0xFD39,0xFD39,0xFD39}, {1,0xFD3A,0xFD3A,0xFD3A}, {1,0xFD3B,0xFD3B,0xFD3B},
 {1,0xFD3C,0xFD3C,0xFD3C}, {1,0xFD3D,0xFD3D,0xFD3D}, {0,0xFD3E,0xFD3E,0xFD3E}, {0,0xFD3F,0xFD3F,0xFD3F},
 {0,0xFD40,0xFD40,0xFD40}, {0,0xFD41,0xFD41,0xFD41}, {0,0xFD42,0xFD42,0xFD42}, {0,0xFD43,0xFD43,0xFD43},
 {0,0xFD44,0xFD44,0xFD44}, {0,0xFD45,0xFD45,0xFD45}, {0,0xFD46,0xFD46,0xFD46}, {0,0xFD47,0xFD47,0xFD47},
 {0,0xFD48,0xFD48,0xFD48}, {0,0xFD49,0xFD49,0xFD49}, {0,0xFD4A,0xFD4A,0xFD4A}, {0,0xFD4B,0xFD4B,0xFD4B},
 {0,0xFD4C,0xFD4C,0xFD4C}, {0,0xFD4D,0xFD4D,0xFD4D}, {0,0xFD4E,0xFD4E,0xFD4E}, {0,0xFD4F,0xFD4F,0xFD4F},
 {1,0xFD50,0xFD50,0xFD50}, {1,0xFD51,0xFD51,0xFD51}, {1,0xFD52,0xFD52,0xFD52}, {1,0xFD53,0xFD53,0xFD53},
 {1,0xFD54,0xFD54,0xFD54}, {1,0xFD55,0xFD55,0xFD55}, {1,0xFD56,0xFD56,0xFD56}, {1,0xFD57,0xFD57,0xFD57},
 {1,0xFD58,0xFD58,0xFD58}, {1,0xFD59,0xFD59,0xFD59}, {1,0xFD5A,0xFD5A,0xFD5A}, {1,0xFD5B,0xFD5B,0xFD5B},
 {1,0xFD5C,0xFD5C,0xFD5C}, {1,0xFD5D,0xFD5D,0xFD5D}, {1,0xFD5E,0xFD5E,0xFD5E}, {1,0xFD5F,0xFD5F,0xFD5F},
 {1,0xFD60,0xFD60,0xFD60}, {1,0xFD61,0xFD61,0xFD61}, {1,0xFD62,0xFD62,0xFD62}, {1,0xFD63,0xFD63,0xFD63},
 {1,0xFD64,0xFD64,0xFD64}, {1,0xFD65,0xFD65,0xFD65}, {1,0xFD66,0xFD66,0xFD66}, {1,0xFD67,0xFD67,0xFD67},
 {1,0xFD68,0xFD68,0xFD68}, {1,0xFD69,0xFD69,0xFD69}, {1,0xFD6A,0xFD6A,0xFD6A}, {1,0xFD6B,0xFD6B,0xFD6B},
 {1,0xFD6C,0xFD6C,0xFD6C}, {1,0xFD6D,0xFD6D,0xFD6D}, {1,0xFD6E,0xFD6E,0xFD6E}, {1,0xFD6F,0xFD6F,0xFD6F},
 {1,0xFD70,0xFD70,0xFD70}, {1,0xFD71,0xFD71,0xFD71}, {1,0xFD72,0xFD72,0xFD72}, {1,0xFD73,0xFD73,0xFD73},
 {1,0xFD74,0xFD74,0xFD74}, {1,0xFD75,0xFD75,0xFD75}, {1,0xFD76,0xFD76,0xFD76}, {1,0xFD77,0xFD77,0xFD77},
 {1,0xFD78,0xFD78,0xFD78}, {1,0xFD79,0xFD79,0xFD79}, {1,0xFD7A,0xFD7A,0xFD7A}, {1,0xFD7B,0xFD7B,0xFD7B},
 {1,0xFD7C,0xFD7C,0xFD7C}, {1,0xFD7D,0xFD7D,0xFD7D}, {1,0xFD7E,0xFD7E,0xFD7E}, {1,0xFD7F,0xFD7F,0xFD7F},
 {1,0xFD80,0xFD80,0xFD80}, {1,0xFD81,0xFD81,0xFD81}, {1,0xFD82,0xFD82,0xFD82}, {1,0xFD83,0xFD83,0xFD83},
 {1,0xFD84,0xFD84,0xFD84}, {1,0xFD85,0xFD85,0xFD85}, {1,0xFD86,0xFD86,0xFD86}, {1,0xFD87,0xFD87,0xFD87},
 {1,0xFD88,0xFD88,0xFD88}, {1,0xFD89,0xFD89,0xFD89}, {1,0xFD8A,0xFD8A,0xFD8A}, {1,0xFD8B,0xFD8B,0xFD8B},
 {1,0xFD8C,0xFD8C,0xFD8C}, {1,0xFD8D,0xFD8D,0xFD8D}, {1,0xFD8E,0xFD8E,0xFD8E}, {1,0xFD8F,0xFD8F,0xFD8F},
 {0,0xFD90,0xFD90,0xFD90}, {0,0xFD91,0xFD91,0xFD91}, {1,0xFD92,0xFD92,0xFD92}, {1,0xFD93,0xFD93,0xFD93},
 {1,0xFD94,0xFD94,0xFD94}, {1,0xFD95,0xFD95,0xFD95}, {1,0xFD96,0xFD96,0xFD96}, {1,0xFD97,0xFD97,0xFD97},
 {1,0xFD98,0xFD98,0xFD98}, {1,0xFD99,0xFD99,0xFD99}, {1,0xFD9A,0xFD9A,0xFD9A}, {1,0xFD9B,0xFD9B,0xFD9B},
 {1,0xFD9C,0xFD9C,0xFD9C}, {1,0xFD9D,0xFD9D,0xFD9D}, {1,0xFD9E,0xFD9E,0xFD9E}, {1,0xFD9F,0xFD9F,0xFD9F},
 {1,0xFDA0,0xFDA0,0xFDA0}, {1,0xFDA1,0xFDA1,0xFDA1}, {1,0xFDA2,0xFDA2,0xFDA2}, {1,0xFDA3,0xFDA3,0xFDA3},
 {1,0xFDA4,0xFDA4,0xFDA4}, {1,0xFDA5,0xFDA5,0xFDA5}, {1,0xFDA6,0xFDA6,0xFDA6}, {1,0xFDA7,0xFDA7,0xFDA7},
 {1,0xFDA8,0xFDA8,0xFDA8}, {1,0xFDA9,0xFDA9,0xFDA9}, {1,0xFDAA,0xFDAA,0xFDAA}, {1,0xFDAB,0xFDAB,0xFDAB},
 {1,0xFDAC,0xFDAC,0xFDAC}, {1,0xFDAD,0xFDAD,0xFDAD}, {1,0xFDAE,0xFDAE,0xFDAE}, {1,0xFDAF,0xFDAF,0xFDAF},
 {1,0xFDB0,0xFDB0,0xFDB0}, {1,0xFDB1,0xFDB1,0xFDB1}, {1,0xFDB2,0xFDB2,0xFDB2}, {1,0xFDB3,0xFDB3,0xFDB3},
 {1,0xFDB4,0xFDB4,0xFDB4}, {1,0xFDB5,0xFDB5,0xFDB5}, {1,0xFDB6,0xFDB6,0xFDB6}, {1,0xFDB7,0xFDB7,0xFDB7},
 {1,0xFDB8,0xFDB8,0xFDB8}, {1,0xFDB9,0xFDB9,0xFDB9}, {1,0xFDBA,0xFDBA,0xFDBA}, {1,0xFDBB,0xFDBB,0xFDBB},
 {1,0xFDBC,0xFDBC,0xFDBC}, {1,0xFDBD,0xFDBD,0xFDBD}, {1,0xFDBE,0xFDBE,0xFDBE}, {1,0xFDBF,0xFDBF,0xFDBF},
 {1,0xFDC0,0xFDC0,0xFDC0}, {1,0xFDC1,0xFDC1,0xFDC1}, {1,0xFDC2,0xFDC2,0xFDC2}, {1,0xFDC3,0xFDC3,0xFDC3},
 {1,0xFDC4,0xFDC4,0xFDC4}, {1,0xFDC5,0xFDC5,0xFDC5}, {1,0xFDC6,0xFDC6,0xFDC6}, {1,0xFDC7,0xFDC7,0xFDC7},
 {0,0xFDC8,0xFDC8,0xFDC8}, {0,0xFDC9,0xFDC9,0xFDC9}, {0,0xFDCA,0xFDCA,0xFDCA}, {0,0xFDCB,0xFDCB,0xFDCB},
 {0,0xFDCC,0xFDCC,0xFDCC}, {0,0xFDCD,0xFDCD,0xFDCD}, {0,0xFDCE,0xFDCE,0xFDCE}, {0,0xFDCF,0xFDCF,0xFDCF},
 {0,0xFDD0,0xFDD0,0xFDD0}, {0,0xFDD1,0xFDD1,0xFDD1}, {0,0xFDD2,0xFDD2,0xFDD2}, {0,0xFDD3,0xFDD3,0xFDD3},
 {0,0xFDD4,0xFDD4,0xFDD4}, {0,0xFDD5,0xFDD5,0xFDD5}, {0,0xFDD6,0xFDD6,0xFDD6}, {0,0xFDD7,0xFDD7,0xFDD7},
 {0,0xFDD8,0xFDD8,0xFDD8}, {0,0xFDD9,0xFDD9,0xFDD9}, {0,0xFDDA,0xFDDA,0xFDDA}, {0,0xFDDB,0xFDDB,0xFDDB},
 {0,0xFDDC,0xFDDC,0xFDDC}, {0,0xFDDD,0xFDDD,0xFDDD}, {0,0xFDDE,0xFDDE,0xFDDE}, {0,0xFDDF,0xFDDF,0xFDDF},
 {0,0xFDE0,0xFDE0,0xFDE0}, {0,0xFDE1,0xFDE1,0xFDE1}, {0,0xFDE2,0xFDE2,0xFDE2}, {0,0xFDE3,0xFDE3,0xFDE3},
 {0,0xFDE4,0xFDE4,0xFDE4}, {0,0xFDE5,0xFDE5,0xFDE5}, {0,0xFDE6,0xFDE6,0xFDE6}, {0,0xFDE7,0xFDE7,0xFDE7},
 {0,0xFDE8,0xFDE8,0xFDE8}, {0,0xFDE9,0xFDE9,0xFDE9}, {0,0xFDEA,0xFDEA,0xFDEA}, {0,0xFDEB,0xFDEB,0xFDEB},
 {0,0xFDEC,0xFDEC,0xFDEC}, {0,0xFDED,0xFDED,0xFDED}, {0,0xFDEE,0xFDEE,0xFDEE}, {0,0xFDEF,0xFDEF,0xFDEF},
 {1,0xFDF0,0xFDF0,0xFDF0}, {1,0xFDF1,0xFDF1,0xFDF1}, {1,0xFDF2,0xFDF2,0xFDF2}, {1,0xFDF3,0xFDF3,0xFDF3},
 {1,0xFDF4,0xFDF4,0xFDF4}, {1,0xFDF5,0xFDF5,0xFDF5}, {1,0xFDF6,0xFDF6,0xFDF6}, {1,0xFDF7,0xFDF7,0xFDF7},
 {1,0xFDF8,0xFDF8,0xFDF8}, {1,0xFDF9,0xFDF9,0xFDF9}, {1,0xFDFA,0xFDFA,0xFDFA}, {1,0xFDFB,0xFDFB,0xFDFB},
 {0,0xFDFC,0xFDFC,0xFDFC}, {0,0xFDFD,0xFDFD,0xFDFD}, {0,0xFDFE,0xFDFE,0xFDFE}, {0,0xFDFF,0xFDFF,0xFDFF},
{0,0}};

static UDM_UNICODE planeFE[257]={
 {0,0xFE00,0xFE00,0xFE00}, {0,0xFE01,0xFE01,0xFE01}, {0,0xFE02,0xFE02,0xFE02}, {0,0xFE03,0xFE03,0xFE03},
 {0,0xFE04,0xFE04,0xFE04}, {0,0xFE05,0xFE05,0xFE05}, {0,0xFE06,0xFE06,0xFE06}, {0,0xFE07,0xFE07,0xFE07},
 {0,0xFE08,0xFE08,0xFE08}, {0,0xFE09,0xFE09,0xFE09}, {0,0xFE0A,0xFE0A,0xFE0A}, {0,0xFE0B,0xFE0B,0xFE0B},
 {0,0xFE0C,0xFE0C,0xFE0C}, {0,0xFE0D,0xFE0D,0xFE0D}, {0,0xFE0E,0xFE0E,0xFE0E}, {0,0xFE0F,0xFE0F,0xFE0F},
 {0,0xFE10,0xFE10,0xFE10}, {0,0xFE11,0xFE11,0xFE11}, {0,0xFE12,0xFE12,0xFE12}, {0,0xFE13,0xFE13,0xFE13},
 {0,0xFE14,0xFE14,0xFE14}, {0,0xFE15,0xFE15,0xFE15}, {0,0xFE16,0xFE16,0xFE16}, {0,0xFE17,0xFE17,0xFE17},
 {0,0xFE18,0xFE18,0xFE18}, {0,0xFE19,0xFE19,0xFE19}, {0,0xFE1A,0xFE1A,0xFE1A}, {0,0xFE1B,0xFE1B,0xFE1B},
 {0,0xFE1C,0xFE1C,0xFE1C}, {0,0xFE1D,0xFE1D,0xFE1D}, {0,0xFE1E,0xFE1E,0xFE1E}, {0,0xFE1F,0xFE1F,0xFE1F},
 {1,0xFE20,0xFE20,0xFE20}, {1,0xFE21,0xFE21,0xFE21}, {1,0xFE22,0xFE22,0xFE22}, {1,0xFE23,0xFE23,0xFE23},
 {0,0xFE24,0xFE24,0xFE24}, {0,0xFE25,0xFE25,0xFE25}, {0,0xFE26,0xFE26,0xFE26}, {0,0xFE27,0xFE27,0xFE27},
 {0,0xFE28,0xFE28,0xFE28}, {0,0xFE29,0xFE29,0xFE29}, {0,0xFE2A,0xFE2A,0xFE2A}, {0,0xFE2B,0xFE2B,0xFE2B},
 {0,0xFE2C,0xFE2C,0xFE2C}, {0,0xFE2D,0xFE2D,0xFE2D}, {0,0xFE2E,0xFE2E,0xFE2E}, {0,0xFE2F,0xFE2F,0xFE2F},
 {0,0xFE30,0xFE30,0xFE30}, {0,0xFE31,0xFE31,0xFE31}, {0,0xFE32,0xFE32,0xFE32}, {0,0xFE33,0xFE33,0xFE33},
 {0,0xFE34,0xFE34,0xFE34}, {0,0xFE35,0xFE35,0xFE35}, {0,0xFE36,0xFE36,0xFE36}, {0,0xFE37,0xFE37,0xFE37},
 {0,0xFE38,0xFE38,0xFE38}, {0,0xFE39,0xFE39,0xFE39}, {0,0xFE3A,0xFE3A,0xFE3A}, {0,0xFE3B,0xFE3B,0xFE3B},
 {0,0xFE3C,0xFE3C,0xFE3C}, {0,0xFE3D,0xFE3D,0xFE3D}, {0,0xFE3E,0xFE3E,0xFE3E}, {0,0xFE3F,0xFE3F,0xFE3F},
 {0,0xFE40,0xFE40,0xFE40}, {0,0xFE41,0xFE41,0xFE41}, {0,0xFE42,0xFE42,0xFE42}, {0,0xFE43,0xFE43,0xFE43},
 {0,0xFE44,0xFE44,0xFE44}, {0,0xFE45,0xFE45,0xFE45}, {0,0xFE46,0xFE46,0xFE46}, {0,0xFE47,0xFE47,0xFE47},
 {0,0xFE48,0xFE48,0xFE48}, {0,0xFE49,0xFE49,0xFE49}, {0,0xFE4A,0xFE4A,0xFE4A}, {0,0xFE4B,0xFE4B,0xFE4B},
 {0,0xFE4C,0xFE4C,0xFE4C}, {0,0xFE4D,0xFE4D,0xFE4D}, {0,0xFE4E,0xFE4E,0xFE4E}, {0,0xFE4F,0xFE4F,0xFE4F},
 {0,0xFE50,0xFE50,0xFE50}, {0,0xFE51,0xFE51,0xFE51}, {0,0xFE52,0xFE52,0xFE52}, {0,0xFE53,0xFE53,0xFE53},
 {0,0xFE54,0xFE54,0xFE54}, {0,0xFE55,0xFE55,0xFE55}, {0,0xFE56,0xFE56,0xFE56}, {0,0xFE57,0xFE57,0xFE57},
 {0,0xFE58,0xFE58,0xFE58}, {0,0xFE59,0xFE59,0xFE59}, {0,0xFE5A,0xFE5A,0xFE5A}, {0,0xFE5B,0xFE5B,0xFE5B},
 {0,0xFE5C,0xFE5C,0xFE5C}, {0,0xFE5D,0xFE5D,0xFE5D}, {0,0xFE5E,0xFE5E,0xFE5E}, {0,0xFE5F,0xFE5F,0xFE5F},
 {0,0xFE60,0xFE60,0xFE60}, {0,0xFE61,0xFE61,0xFE61}, {0,0xFE62,0xFE62,0xFE62}, {0,0xFE63,0xFE63,0xFE63},
 {0,0xFE64,0xFE64,0xFE64}, {0,0xFE65,0xFE65,0xFE65}, {0,0xFE66,0xFE66,0xFE66}, {0,0xFE67,0xFE67,0xFE67},
 {0,0xFE68,0xFE68,0xFE68}, {0,0xFE69,0xFE69,0xFE69}, {0,0xFE6A,0xFE6A,0xFE6A}, {0,0xFE6B,0xFE6B,0xFE6B},
 {0,0xFE6C,0xFE6C,0xFE6C}, {0,0xFE6D,0xFE6D,0xFE6D}, {0,0xFE6E,0xFE6E,0xFE6E}, {0,0xFE6F,0xFE6F,0xFE6F},
 {1,0xFE70,0xFE70,0xFE70}, {1,0xFE71,0xFE71,0xFE71}, {1,0xFE72,0xFE72,0xFE72}, {0,0xFE73,0xFE73,0xFE73},
 {1,0xFE74,0xFE74,0xFE74}, {0,0xFE75,0xFE75,0xFE75}, {1,0xFE76,0xFE76,0xFE76}, {1,0xFE77,0xFE77,0xFE77},
 {1,0xFE78,0xFE78,0xFE78}, {1,0xFE79,0xFE79,0xFE79}, {1,0xFE7A,0xFE7A,0xFE7A}, {1,0xFE7B,0xFE7B,0xFE7B},
 {1,0xFE7C,0xFE7C,0xFE7C}, {1,0xFE7D,0xFE7D,0xFE7D}, {1,0xFE7E,0xFE7E,0xFE7E}, {1,0xFE7F,0xFE7F,0xFE7F},
 {1,0xFE80,0xFE80,0xFE80}, {1,0xFE81,0xFE81,0xFE81}, {1,0xFE82,0xFE82,0xFE82}, {1,0xFE83,0xFE83,0xFE83},
 {1,0xFE84,0xFE84,0xFE84}, {1,0xFE85,0xFE85,0xFE85}, {1,0xFE86,0xFE86,0xFE86}, {1,0xFE87,0xFE87,0xFE87},
 {1,0xFE88,0xFE88,0xFE88}, {1,0xFE89,0xFE89,0xFE89}, {1,0xFE8A,0xFE8A,0xFE8A}, {1,0xFE8B,0xFE8B,0xFE8B},
 {1,0xFE8C,0xFE8C,0xFE8C}, {1,0xFE8D,0xFE8D,0xFE8D}, {1,0xFE8E,0xFE8E,0xFE8E}, {1,0xFE8F,0xFE8F,0xFE8F},
 {1,0xFE90,0xFE90,0xFE90}, {1,0xFE91,0xFE91,0xFE91}, {1,0xFE92,0xFE92,0xFE92}, {1,0xFE93,0xFE93,0xFE93},
 {1,0xFE94,0xFE94,0xFE94}, {1,0xFE95,0xFE95,0xFE95}, {1,0xFE96,0xFE96,0xFE96}, {1,0xFE97,0xFE97,0xFE97},
 {1,0xFE98,0xFE98,0xFE98}, {1,0xFE99,0xFE99,0xFE99}, {1,0xFE9A,0xFE9A,0xFE9A}, {1,0xFE9B,0xFE9B,0xFE9B},
 {1,0xFE9C,0xFE9C,0xFE9C}, {1,0xFE9D,0xFE9D,0xFE9D}, {1,0xFE9E,0xFE9E,0xFE9E}, {1,0xFE9F,0xFE9F,0xFE9F},
 {1,0xFEA0,0xFEA0,0xFEA0}, {1,0xFEA1,0xFEA1,0xFEA1}, {1,0xFEA2,0xFEA2,0xFEA2}, {1,0xFEA3,0xFEA3,0xFEA3},
 {1,0xFEA4,0xFEA4,0xFEA4}, {1,0xFEA5,0xFEA5,0xFEA5}, {1,0xFEA6,0xFEA6,0xFEA6}, {1,0xFEA7,0xFEA7,0xFEA7},
 {1,0xFEA8,0xFEA8,0xFEA8}, {1,0xFEA9,0xFEA9,0xFEA9}, {1,0xFEAA,0xFEAA,0xFEAA}, {1,0xFEAB,0xFEAB,0xFEAB},
 {1,0xFEAC,0xFEAC,0xFEAC}, {1,0xFEAD,0xFEAD,0xFEAD}, {1,0xFEAE,0xFEAE,0xFEAE}, {1,0xFEAF,0xFEAF,0xFEAF},
 {1,0xFEB0,0xFEB0,0xFEB0}, {1,0xFEB1,0xFEB1,0xFEB1}, {1,0xFEB2,0xFEB2,0xFEB2}, {1,0xFEB3,0xFEB3,0xFEB3},
 {1,0xFEB4,0xFEB4,0xFEB4}, {1,0xFEB5,0xFEB5,0xFEB5}, {1,0xFEB6,0xFEB6,0xFEB6}, {1,0xFEB7,0xFEB7,0xFEB7},
 {1,0xFEB8,0xFEB8,0xFEB8}, {1,0xFEB9,0xFEB9,0xFEB9}, {1,0xFEBA,0xFEBA,0xFEBA}, {1,0xFEBB,0xFEBB,0xFEBB},
 {1,0xFEBC,0xFEBC,0xFEBC}, {1,0xFEBD,0xFEBD,0xFEBD}, {1,0xFEBE,0xFEBE,0xFEBE}, {1,0xFEBF,0xFEBF,0xFEBF},
 {1,0xFEC0,0xFEC0,0xFEC0}, {1,0xFEC1,0xFEC1,0xFEC1}, {1,0xFEC2,0xFEC2,0xFEC2}, {1,0xFEC3,0xFEC3,0xFEC3},
 {1,0xFEC4,0xFEC4,0xFEC4}, {1,0xFEC5,0xFEC5,0xFEC5}, {1,0xFEC6,0xFEC6,0xFEC6}, {1,0xFEC7,0xFEC7,0xFEC7},
 {1,0xFEC8,0xFEC8,0xFEC8}, {1,0xFEC9,0xFEC9,0xFEC9}, {1,0xFECA,0xFECA,0xFECA}, {1,0xFECB,0xFECB,0xFECB},
 {1,0xFECC,0xFECC,0xFECC}, {1,0xFECD,0xFECD,0xFECD}, {1,0xFECE,0xFECE,0xFECE}, {1,0xFECF,0xFECF,0xFECF},
 {1,0xFED0,0xFED0,0xFED0}, {1,0xFED1,0xFED1,0xFED1}, {1,0xFED2,0xFED2,0xFED2}, {1,0xFED3,0xFED3,0xFED3},
 {1,0xFED4,0xFED4,0xFED4}, {1,0xFED5,0xFED5,0xFED5}, {1,0xFED6,0xFED6,0xFED6}, {1,0xFED7,0xFED7,0xFED7},
 {1,0xFED8,0xFED8,0xFED8}, {1,0xFED9,0xFED9,0xFED9}, {1,0xFEDA,0xFEDA,0xFEDA}, {1,0xFEDB,0xFEDB,0xFEDB},
 {1,0xFEDC,0xFEDC,0xFEDC}, {1,0xFEDD,0xFEDD,0xFEDD}, {1,0xFEDE,0xFEDE,0xFEDE}, {1,0xFEDF,0xFEDF,0xFEDF},
 {1,0xFEE0,0xFEE0,0xFEE0}, {1,0xFEE1,0xFEE1,0xFEE1}, {1,0xFEE2,0xFEE2,0xFEE2}, {1,0xFEE3,0xFEE3,0xFEE3},
 {1,0xFEE4,0xFEE4,0xFEE4}, {1,0xFEE5,0xFEE5,0xFEE5}, {1,0xFEE6,0xFEE6,0xFEE6}, {1,0xFEE7,0xFEE7,0xFEE7},
 {1,0xFEE8,0xFEE8,0xFEE8}, {1,0xFEE9,0xFEE9,0xFEE9}, {1,0xFEEA,0xFEEA,0xFEEA}, {1,0xFEEB,0xFEEB,0xFEEB},
 {1,0xFEEC,0xFEEC,0xFEEC}, {1,0xFEED,0xFEED,0xFEED}, {1,0xFEEE,0xFEEE,0xFEEE}, {1,0xFEEF,0xFEEF,0xFEEF},
 {1,0xFEF0,0xFEF0,0xFEF0}, {1,0xFEF1,0xFEF1,0xFEF1}, {1,0xFEF2,0xFEF2,0xFEF2}, {1,0xFEF3,0xFEF3,0xFEF3},
 {1,0xFEF4,0xFEF4,0xFEF4}, {1,0xFEF5,0xFEF5,0xFEF5}, {1,0xFEF6,0xFEF6,0xFEF6}, {1,0xFEF7,0xFEF7,0xFEF7},
 {1,0xFEF8,0xFEF8,0xFEF8}, {1,0xFEF9,0xFEF9,0xFEF9}, {1,0xFEFA,0xFEFA,0xFEFA}, {1,0xFEFB,0xFEFB,0xFEFB},
 {1,0xFEFC,0xFEFC,0xFEFC}, {0,0xFEFD,0xFEFD,0xFEFD}, {0,0xFEFE,0xFEFE,0xFEFE}, {0,0xFEFF,0xFEFF,0xFEFF},
{0,0}};

static UDM_UNICODE planeFF[257]={
 {0,0xFF00,0xFF00,0xFF00}, {0,0xFF01,0xFF01,0xFF01}, {0,0xFF02,0xFF02,0xFF02}, {0,0xFF03,0xFF03,0xFF03},
 {0,0xFF04,0xFF04,0xFF04}, {0,0xFF05,0xFF05,0xFF05}, {0,0xFF06,0xFF06,0xFF06}, {0,0xFF07,0xFF07,0xFF07},
 {0,0xFF08,0xFF08,0xFF08}, {0,0xFF09,0xFF09,0xFF09}, {0,0xFF0A,0xFF0A,0xFF0A}, {0,0xFF0B,0xFF0B,0xFF0B},
 {0,0xFF0C,0xFF0C,0xFF0C}, {0,0xFF0D,0xFF0D,0xFF0D}, {0,0xFF0E,0xFF0E,0xFF0E}, {0,0xFF0F,0xFF0F,0xFF0F},
 {2,0xFF10,0xFF10,0xFF10}, {2,0xFF11,0xFF11,0xFF11}, {2,0xFF12,0xFF12,0xFF12}, {2,0xFF13,0xFF13,0xFF13},
 {2,0xFF14,0xFF14,0xFF14}, {2,0xFF15,0xFF15,0xFF15}, {2,0xFF16,0xFF16,0xFF16}, {2,0xFF17,0xFF17,0xFF17},
 {2,0xFF18,0xFF18,0xFF18}, {2,0xFF19,0xFF19,0xFF19}, {0,0xFF1A,0xFF1A,0xFF1A}, {0,0xFF1B,0xFF1B,0xFF1B},
 {0,0xFF1C,0xFF1C,0xFF1C}, {0,0xFF1D,0xFF1D,0xFF1D}, {0,0xFF1E,0xFF1E,0xFF1E}, {0,0xFF1F,0xFF1F,0xFF1F},
 {0,0xFF20,0xFF20,0xFF20}, {1,0xFF41,0xFF21,0xFF41}, {1,0xFF42,0xFF22,0xFF42}, {1,0xFF43,0xFF23,0xFF43},
 {1,0xFF44,0xFF24,0xFF44}, {1,0xFF45,0xFF25,0xFF45}, {1,0xFF46,0xFF26,0xFF46}, {1,0xFF47,0xFF27,0xFF47},
 {1,0xFF48,0xFF28,0xFF48}, {1,0xFF49,0xFF29,0xFF49}, {1,0xFF4A,0xFF2A,0xFF4A}, {1,0xFF4B,0xFF2B,0xFF4B},
 {1,0xFF4C,0xFF2C,0xFF4C}, {1,0xFF4D,0xFF2D,0xFF4D}, {1,0xFF4E,0xFF2E,0xFF4E}, {1,0xFF4F,0xFF2F,0xFF4F},
 {1,0xFF50,0xFF30,0xFF50}, {1,0xFF51,0xFF31,0xFF51}, {1,0xFF52,0xFF32,0xFF52}, {1,0xFF53,0xFF33,0xFF53},
 {1,0xFF54,0xFF34,0xFF54}, {1,0xFF55,0xFF35,0xFF55}, {1,0xFF56,0xFF36,0xFF56}, {1,0xFF57,0xFF37,0xFF57},
 {1,0xFF58,0xFF38,0xFF58}, {1,0xFF59,0xFF39,0xFF59}, {1,0xFF5A,0xFF3A,0xFF5A}, {0,0xFF3B,0xFF3B,0xFF3B},
 {0,0xFF3C,0xFF3C,0xFF3C}, {0,0xFF3D,0xFF3D,0xFF3D}, {0,0xFF3E,0xFF3E,0xFF3E}, {0,0xFF3F,0xFF3F,0xFF3F},
 {0,0xFF40,0xFF40,0xFF40}, {1,0xFF41,0xFF41,0xFF41}, {1,0xFF42,0xFF42,0xFF42}, {1,0xFF43,0xFF43,0xFF43},
 {1,0xFF44,0xFF44,0xFF44}, {1,0xFF45,0xFF45,0xFF45}, {1,0xFF46,0xFF46,0xFF46}, {1,0xFF47,0xFF47,0xFF47},
 {1,0xFF48,0xFF48,0xFF48}, {1,0xFF49,0xFF49,0xFF49}, {1,0xFF4A,0xFF4A,0xFF4A}, {1,0xFF4B,0xFF4B,0xFF4B},
 {1,0xFF4C,0xFF4C,0xFF4C}, {1,0xFF4D,0xFF4D,0xFF4D}, {1,0xFF4E,0xFF4E,0xFF4E}, {1,0xFF4F,0xFF4F,0xFF4F},
 {1,0xFF50,0xFF50,0xFF50}, {1,0xFF51,0xFF51,0xFF51}, {1,0xFF52,0xFF52,0xFF52}, {1,0xFF53,0xFF53,0xFF53},
 {1,0xFF54,0xFF54,0xFF54}, {1,0xFF55,0xFF55,0xFF55}, {1,0xFF56,0xFF56,0xFF56}, {1,0xFF57,0xFF57,0xFF57},
 {1,0xFF58,0xFF58,0xFF58}, {1,0xFF59,0xFF59,0xFF59}, {1,0xFF5A,0xFF5A,0xFF5A}, {0,0xFF5B,0xFF5B,0xFF5B},
 {0,0xFF5C,0xFF5C,0xFF5C}, {0,0xFF5D,0xFF5D,0xFF5D}, {0,0xFF5E,0xFF5E,0xFF5E}, {0,0xFF5F,0xFF5F,0xFF5F},
 {0,0xFF60,0xFF60,0xFF60}, {0,0xFF61,0xFF61,0xFF61}, {0,0xFF62,0xFF62,0xFF62}, {0,0xFF63,0xFF63,0xFF63},
 {0,0xFF64,0xFF64,0xFF64}, {0,0xFF65,0xFF65,0xFF65}, {1,0xFF66,0xFF66,0xFF66}, {1,0xFF67,0xFF67,0xFF67},
 {1,0xFF68,0xFF68,0xFF68}, {1,0xFF69,0xFF69,0xFF69}, {1,0xFF6A,0xFF6A,0xFF6A}, {1,0xFF6B,0xFF6B,0xFF6B},
 {1,0xFF6C,0xFF6C,0xFF6C}, {1,0xFF6D,0xFF6D,0xFF6D}, {1,0xFF6E,0xFF6E,0xFF6E}, {1,0xFF6F,0xFF6F,0xFF6F},
 {1,0xFF70,0xFF70,0xFF70}, {1,0xFF71,0xFF71,0xFF71}, {1,0xFF72,0xFF72,0xFF72}, {1,0xFF73,0xFF73,0xFF73},
 {1,0xFF74,0xFF74,0xFF74}, {1,0xFF75,0xFF75,0xFF75}, {1,0xFF76,0xFF76,0xFF76}, {1,0xFF77,0xFF77,0xFF77},
 {1,0xFF78,0xFF78,0xFF78}, {1,0xFF79,0xFF79,0xFF79}, {1,0xFF7A,0xFF7A,0xFF7A}, {1,0xFF7B,0xFF7B,0xFF7B},
 {1,0xFF7C,0xFF7C,0xFF7C}, {1,0xFF7D,0xFF7D,0xFF7D}, {1,0xFF7E,0xFF7E,0xFF7E}, {1,0xFF7F,0xFF7F,0xFF7F},
 {1,0xFF80,0xFF80,0xFF80}, {1,0xFF81,0xFF81,0xFF81}, {1,0xFF82,0xFF82,0xFF82}, {1,0xFF83,0xFF83,0xFF83},
 {1,0xFF84,0xFF84,0xFF84}, {1,0xFF85,0xFF85,0xFF85}, {1,0xFF86,0xFF86,0xFF86}, {1,0xFF87,0xFF87,0xFF87},
 {1,0xFF88,0xFF88,0xFF88}, {1,0xFF89,0xFF89,0xFF89}, {1,0xFF8A,0xFF8A,0xFF8A}, {1,0xFF8B,0xFF8B,0xFF8B},
 {1,0xFF8C,0xFF8C,0xFF8C}, {1,0xFF8D,0xFF8D,0xFF8D}, {1,0xFF8E,0xFF8E,0xFF8E}, {1,0xFF8F,0xFF8F,0xFF8F},
 {1,0xFF90,0xFF90,0xFF90}, {1,0xFF91,0xFF91,0xFF91}, {1,0xFF92,0xFF92,0xFF92}, {1,0xFF93,0xFF93,0xFF93},
 {1,0xFF94,0xFF94,0xFF94}, {1,0xFF95,0xFF95,0xFF95}, {1,0xFF96,0xFF96,0xFF96}, {1,0xFF97,0xFF97,0xFF97},
 {1,0xFF98,0xFF98,0xFF98}, {1,0xFF99,0xFF99,0xFF99}, {1,0xFF9A,0xFF9A,0xFF9A}, {1,0xFF9B,0xFF9B,0xFF9B},
 {1,0xFF9C,0xFF9C,0xFF9C}, {1,0xFF9D,0xFF9D,0xFF9D}, {1,0xFF9E,0xFF9E,0xFF9E}, {1,0xFF9F,0xFF9F,0xFF9F},
 {1,0xFFA0,0xFFA0,0xFFA0}, {1,0xFFA1,0xFFA1,0xFFA1}, {1,0xFFA2,0xFFA2,0xFFA2}, {1,0xFFA3,0xFFA3,0xFFA3},
 {1,0xFFA4,0xFFA4,0xFFA4}, {1,0xFFA5,0xFFA5,0xFFA5}, {1,0xFFA6,0xFFA6,0xFFA6}, {1,0xFFA7,0xFFA7,0xFFA7},
 {1,0xFFA8,0xFFA8,0xFFA8}, {1,0xFFA9,0xFFA9,0xFFA9}, {1,0xFFAA,0xFFAA,0xFFAA}, {1,0xFFAB,0xFFAB,0xFFAB},
 {1,0xFFAC,0xFFAC,0xFFAC}, {1,0xFFAD,0xFFAD,0xFFAD}, {1,0xFFAE,0xFFAE,0xFFAE}, {1,0xFFAF,0xFFAF,0xFFAF},
 {1,0xFFB0,0xFFB0,0xFFB0}, {1,0xFFB1,0xFFB1,0xFFB1}, {1,0xFFB2,0xFFB2,0xFFB2}, {1,0xFFB3,0xFFB3,0xFFB3},
 {1,0xFFB4,0xFFB4,0xFFB4}, {1,0xFFB5,0xFFB5,0xFFB5}, {1,0xFFB6,0xFFB6,0xFFB6}, {1,0xFFB7,0xFFB7,0xFFB7},
 {1,0xFFB8,0xFFB8,0xFFB8}, {1,0xFFB9,0xFFB9,0xFFB9}, {1,0xFFBA,0xFFBA,0xFFBA}, {1,0xFFBB,0xFFBB,0xFFBB},
 {1,0xFFBC,0xFFBC,0xFFBC}, {1,0xFFBD,0xFFBD,0xFFBD}, {1,0xFFBE,0xFFBE,0xFFBE}, {0,0xFFBF,0xFFBF,0xFFBF},
 {0,0xFFC0,0xFFC0,0xFFC0}, {0,0xFFC1,0xFFC1,0xFFC1}, {1,0xFFC2,0xFFC2,0xFFC2}, {1,0xFFC3,0xFFC3,0xFFC3},
 {1,0xFFC4,0xFFC4,0xFFC4}, {1,0xFFC5,0xFFC5,0xFFC5}, {1,0xFFC6,0xFFC6,0xFFC6}, {1,0xFFC7,0xFFC7,0xFFC7},
 {0,0xFFC8,0xFFC8,0xFFC8}, {0,0xFFC9,0xFFC9,0xFFC9}, {1,0xFFCA,0xFFCA,0xFFCA}, {1,0xFFCB,0xFFCB,0xFFCB},
 {1,0xFFCC,0xFFCC,0xFFCC}, {1,0xFFCD,0xFFCD,0xFFCD}, {1,0xFFCE,0xFFCE,0xFFCE}, {1,0xFFCF,0xFFCF,0xFFCF},
 {0,0xFFD0,0xFFD0,0xFFD0}, {0,0xFFD1,0xFFD1,0xFFD1}, {1,0xFFD2,0xFFD2,0xFFD2}, {1,0xFFD3,0xFFD3,0xFFD3},
 {1,0xFFD4,0xFFD4,0xFFD4}, {1,0xFFD5,0xFFD5,0xFFD5}, {1,0xFFD6,0xFFD6,0xFFD6}, {1,0xFFD7,0xFFD7,0xFFD7},
 {0,0xFFD8,0xFFD8,0xFFD8}, {0,0xFFD9,0xFFD9,0xFFD9}, {1,0xFFDA,0xFFDA,0xFFDA}, {1,0xFFDB,0xFFDB,0xFFDB},
 {1,0xFFDC,0xFFDC,0xFFDC}, {0,0xFFDD,0xFFDD,0xFFDD}, {0,0xFFDE,0xFFDE,0xFFDE}, {0,0xFFDF,0xFFDF,0xFFDF},
 {0,0xFFE0,0xFFE0,0xFFE0}, {0,0xFFE1,0xFFE1,0xFFE1}, {0,0xFFE2,0xFFE2,0xFFE2}, {0,0xFFE3,0xFFE3,0xFFE3},
 {0,0xFFE4,0xFFE4,0xFFE4}, {0,0xFFE5,0xFFE5,0xFFE5}, {0,0xFFE6,0xFFE6,0xFFE6}, {0,0xFFE7,0xFFE7,0xFFE7},
 {0,0xFFE8,0xFFE8,0xFFE8}, {0,0xFFE9,0xFFE9,0xFFE9}, {0,0xFFEA,0xFFEA,0xFFEA}, {0,0xFFEB,0xFFEB,0xFFEB},
 {0,0xFFEC,0xFFEC,0xFFEC}, {0,0xFFED,0xFFED,0xFFED}, {0,0xFFEE,0xFFEE,0xFFEE}, {0,0xFFEF,0xFFEF,0xFFEF},
 {0,0xFFF0,0xFFF0,0xFFF0}, {0,0xFFF1,0xFFF1,0xFFF1}, {0,0xFFF2,0xFFF2,0xFFF2}, {0,0xFFF3,0xFFF3,0xFFF3},
 {0,0xFFF4,0xFFF4,0xFFF4}, {0,0xFFF5,0xFFF5,0xFFF5}, {0,0xFFF6,0xFFF6,0xFFF6}, {0,0xFFF7,0xFFF7,0xFFF7},
 {0,0xFFF8,0xFFF8,0xFFF8}, {0,0xFFF9,0xFFF9,0xFFF9}, {0,0xFFFA,0xFFFA,0xFFFA}, {0,0xFFFB,0xFFFB,0xFFFB},
 {0,0xFFFC,0xFFFC,0xFFFC}, {0,0xFFFD,0xFFFD,0xFFFD}, {0,0xFFFE,0xFFFE,0xFFFE}, {0,0xFFFF,0xFFFF,0xFFFF},
{0,0}};

static UDM_UNIDATA udm_unidata_default_array[]={
	{0,plane00},
	{1,plane01},
	{0,plane02},
	{0,plane03},
	{0,plane04},
	{0,plane05},
	{0,plane06},
	{0,plane07},
	{0,NULL},
	{0,plane09},
	{0,plane0A},
	{0,plane0B},
	{0,plane0C},
	{0,plane0D},
	{0,plane0E},
	{0,plane0F},
	{0,plane10},
	{0,plane11},
	{0,plane12},
	{0,plane13},
	{0,plane14},
	{1,NULL},
	{0,plane16},
	{0,plane17},
	{0,plane18},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,plane1E},
	{0,plane1F},
	{0,plane20},
	{0,plane21},
	{0,NULL},
	{0,NULL},
	{0,plane24},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,plane30},
	{0,plane31},
	{0,NULL},
	{0,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{0,plane4D},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{0,plane9F},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{0,planeA4},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{0,planeD7},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{1,NULL},
	{0,planeFA},
	{0,planeFB},
	{1,NULL},
	{0,planeFD},
	{0,planeFE},
	{0,planeFF},
{0,NULL}};


static UDM_UNIDATA udm_unidata_turkish_array[257];
static UDM_UNIDATA udm_unidata_turkish2_array[257];


UDM_UNIDATA *udm_unidata_default= udm_unidata_default_array;
UDM_UNIDATA *udm_unidata_turkish= udm_unidata_turkish_array;
UDM_UNIDATA *udm_unidata_turkish2= udm_unidata_turkish2_array;

UDM_UNIDATA *UdmUnidataGetByName(const char *name)
{
  if (!strcasecmp(name, "turkish"))
  {
    memcpy(udm_unidata_turkish_array,
           udm_unidata_default_array,
           sizeof(udm_unidata_turkish_array));
    /*
      ftp://ftp.unicode.org/Public/UNIDATA/CaseFolding.txt
      0049; T; 0131; # LATIN CAPITAL LETTER I
      0130; T; 0069; # LATIN CAPITAL LETTER I WITH DOT ABOVE
    */
    udm_unidata_turkish[0].table[0x49].tolower= 0x0131;
    udm_unidata_turkish[1].table[0x30].tolower= 0x0069;
    return udm_unidata_turkish;
  }
  
  if (!strcasecmp(name, "turkish2"))
  {
    memcpy(udm_unidata_turkish2_array,
           udm_unidata_default_array,
           sizeof(udm_unidata_turkish2_array));
    /*
      0049 -> 0069; # LATIN CAPITAL LETTER I
      0130 -> 0069; # LATIN CAPITAL LETTER I WITH DOT ABOVE
      0131 -> 0069; # LATIN SMALL LETTER DOTLESS I
    */
    udm_unidata_turkish2[0].table[0x49].tolower= 0x0069;
    udm_unidata_turkish2[1].table[0x30].tolower= 0x0069;
    udm_unidata_turkish2[1].table[0x31].tolower= 0x0069;
    return udm_unidata_turkish2;
  }
  
  if (!strcasecmp(name, "default"))
    return udm_unidata_default;
  return NULL;
}

/* Returns lower case of argument "uni "*/

int UdmUniToLower(UDM_UNIDATA *uni_plane, int uni)
{
  unsigned int plane;
  unsigned int code;

  plane = ((uni) >> 8) & 0xFF;
  code=(uni)&0xFF;
  if(uni_plane[plane].table)
  {
    return(uni_plane[plane].table[code].tolower);
  }
  return(uni);
}


/* 
  Function converts NULL terminated
  unistr array to lower case        
*/

void __UDMCALL UdmUniStrToLower(UDM_UNIDATA *uni_plane, int * unistr)
{
  register unsigned int plane;
  for( ;*unistr; unistr++ )
  {
    plane = ((*unistr) >> 8) & 0xFF;
    if(uni_plane[plane].table)
      (*unistr)=uni_plane[plane].table[(*unistr)&0xFF].tolower;
  }
}


/*
  Strip accents from a Unicode string
*/
void UdmUniStrStripAccents(UDM_UNIDATA *uni_plane, int *unistr)
{
  for ( ; *unistr; unistr++ )
  {
    int page= (unistr[0] >> 8) & 0xFF;
    if (uni_plane[page].table)
      *unistr= uni_plane[page].table[*unistr & 0xFF].noaccent;
  }
}


void UdmStrToLowerExt(UDM_UNIDATA *uni_plane, UDM_CHARSET *cs,
                      char *src, size_t bytelen, int flags)
{
  UDM_CONV cnv;
  char *dst= src;
  char *end= src + bytelen;
  int wc[16];
  
  UdmConvInit(&cnv, cs, cs, flags);
  while (src < end)
  {
    size_t plane;
    int res_src, res_dst;
    
    res_src= cs->mb_wc(&cnv, cs, wc, (const unsigned char*) src,
                                     (const unsigned char*) end);
    if (res_src <= 0)
      return;
    
    plane= (wc[0] >> 8) & 0xFF;
    if (uni_plane[plane].table)
      wc[0]= uni_plane[plane].table[wc[0] & 0xFF].tolower;

outp:
    res_dst= cs->wc_mb(&cnv, cs, &wc[0], (unsigned char *) dst,
                                         (unsigned char *) end);
    src+= res_src;

    if (res_dst <= 0)
    {
      if (res_dst == UDM_CHARSET_ILUNI && wc[0] != '?')
      {
        if (flags & UDM_RECODE_HTML_NONASCII)
        {
          char tmp[32], *t= tmp;
          res_dst= sprintf(tmp, "%d", wc[0]);
          if (dst + res_dst + 3 <= src)
          {
            *dst++= '&';
            *dst++= '#';
            for ( ; res_dst ; *dst++= *t++, res_dst--); 
            *dst++= ';';
            continue;
          }
          else
            return;
        }
        else
        {
          wc[0]= '?';
          goto outp;
        }
      }
      else
        return;
    }

    if (res_src < res_dst)
      return;
    
    dst+= res_dst;
  }
  if (dst < end)
    *dst= '\0';
}


void UdmStrToLower(UDM_UNIDATA *uni_plane, UDM_CHARSET *cs,
                   char *str, size_t bytelen)
{
  UDM_CONV cnv;
  char *end= str + bytelen;
  int wc[16];
  
  UdmConvInit(&cnv, cs, cs, 0);
  while (str < end)
  {
    size_t plane;
    int res2;
    int res1= cs->mb_wc(&cnv, cs, wc, (const unsigned char*) str,
                                      (const unsigned char*) end);
    if (res1 <= 0)
      return;
    
    plane= (wc[0] >> 8) & 0xFF;
    if (uni_plane[plane].table)
      wc[0]= uni_plane[plane].table[wc[0] & 0xFF].tolower;
    
    res2= cs->wc_mb(&cnv, cs, &wc[0], (unsigned char *) str,
                                      (unsigned char *) end);
    if (res1 != res2)
      return;
    
    str+= res1;
  }
}


void UdmStrToLower8bit(UDM_UNIDATA *uni_plane, UDM_CHARSET *cs,
                       char *str, size_t bytelen)
{
  char *end= str + bytelen;
  for ( ; str < end ; str++)
  {
    int wc0= cs->tab_to_uni[(unsigned char)*str];
    UDM_UNICODE *table= uni_plane[wc0 >> 8].table; 
    if (table)
    {
      int wc1= table[wc0 & 0xFF].tolower;
      
      if (wc0 != wc1)
      {
        UDM_UNI_IDX *idx;
        for (idx= cs->tab_from_uni; idx->tab; idx++)
        {
          if (idx->from <= wc1 && idx->to >= wc1)
          {
            *str= (char) idx->tab[wc1 - idx->from];
          }
        }
      }
    }
  }
}


/* 
  Parses null terminated  UNICODE string
  Returns tokens without separators     
*/

int * UdmUniGetToken(UDM_UNIDATA *uni_plane, int * s, int ** last)
{
  int *beg;

  if(s == NULL && (s= *last) == NULL)
    return NULL;

  /* Skip leading separators */
  for( ; *s ; s++)
  {
    UDM_UNIDATA *page= &uni_plane[((*s) >> 8) & 0xFF];
    int ctype= page->table ? page->table[(*s) & 0xFF].ctype : page->ctype;
    if (ctype != UDM_UNI_SEPAR)
      break;
  }

  if (!*s)
    return NULL;
  beg= s++;

  /* Skip non-separators */
  for ( ; *s ; s++)
  {
    UDM_UNIDATA *page= &uni_plane[((*s) >> 8) & 0xFF];
    int ctype= page->table ? page->table[*s & 0xFF].ctype : page->ctype;
    if (ctype == UDM_UNI_SEPAR)
    {
      *last= s;
      return beg; /* Done, separator found */
    }
  }
  /* Done because of end-of-line */ 
  *last= s;
  return beg;
}


int
UdmAutoPhraseChar(int ch)
{
  return ch == '_' || ch == '-' || ch == '.' || ch == '/';
}

/* 
  Parses UNICODE string
  Returns all tokens including separators
  str    - IN     Unicode string
  strend - IN     string end
  last   - IN/OUT beginning of the next token
  ctype0 - OUT    where to return token CTYPE
*/

int *UdmUniGetSepToken(UDM_UNIDATA *uni_plane,
                       int *str, int *strend,
                       int **last, int *ctype0)
{
  int *beg, wc;

  if (!str)
    str= *last;
    
  if ((beg= str) >= strend)
    return NULL;

  if ((wc= *str) <= 255)
  {
    *ctype0= plane00[wc].ctype;
  }
  else
  {
    UDM_UNIDATA *plane= &uni_plane[(wc >> 8) & 0xFF];
    UDM_UNICODE *table= plane->table;
    *ctype0= table ? table[wc & 0xFF].ctype : plane->ctype;
  }

  if (*ctype0 == UDM_UNI_DIGIT)
    *ctype0= UDM_UNI_LETTER;
  
  for (str++ ; str < strend; str++)
  {
    int ctype;
    if ((wc= *str) <= 255)
    {
      ctype= plane00[wc].ctype;
    }
    else
    {
      UDM_UNIDATA *plane= &uni_plane[(wc >> 8) & 0xFF];
      UDM_UNICODE *table= plane->table;
      ctype= table ? table[wc & 0xFF].ctype : plane->ctype;
    }

    if (ctype == UDM_UNI_DIGIT)
      ctype= UDM_UNI_LETTER;

    if (*ctype0 != ctype)
      break;
  }

  *last= str;
  return beg;
}


/* 
  Parses UNICODE string
  Returns all tokens including separators
  The same as above but also considers AutoPhrase characters
  as word parts.
  
  str    - IN     Unicode string
  strend - IN     string end
  last   - IN/OUT beginning of the next token
  ctype0 - OUT    where to return token CTYPE
*/

int *UdmUniGetSepToken2(UDM_UNIDATA *uni_plane,
                        int *str, int *strend,
                        int **last, int *ctype0)
{
  int *beg, wc;

  if (!str)
    str= *last;
    
  if ((beg= str) >= strend)
    return NULL;

  if ((wc= *str) <= 255)
  {
    *ctype0= plane00[wc].ctype;
  }
  else
  {
    UDM_UNIDATA *plane= &uni_plane[(wc >> 8) & 0xFF];
    UDM_UNICODE *table= plane->table;
    *ctype0= table ? table[wc & 0xFF].ctype : plane->ctype;
  }

  /*
    Don't check auto-phrase for the first character -
    it must be a real digit or letter.
  */
  if (*ctype0 == UDM_UNI_DIGIT)
    *ctype0= UDM_UNI_LETTER;
  
  for (str++ ; str < strend; str++)
  {
    int ctype;
    if ((wc= *str) <= 255)
    {
      ctype= plane00[wc].ctype;
    }
    else
    {
      UDM_UNIDATA *plane= &uni_plane[(wc >> 8) & 0xFF];
      UDM_UNICODE *table= plane->table;
      ctype= table ? table[wc & 0xFF].ctype : plane->ctype;
    }

    /*
      Check auto-phrase only if the first
      character was a real digit or letter.
    */ 
    if (ctype == UDM_UNI_DIGIT ||
        (*ctype0 == UDM_UNI_LETTER && UdmAutoPhraseChar(wc)))
      ctype= UDM_UNI_LETTER;

    if (*ctype0 != ctype)
      break;
  }

  *last= str;
  return beg;
}


char *UdmStrGetSepToken8bit(UDM_UNIDATA *uni_plane, UDM_CHARSET *cs,
                            const char *str, const char *strend,
                            const char **last, int *ctype0)
{
  char *beg;
  int ctype;

  if(str == NULL && (str= *last) == NULL)
    return NULL;

  if ((beg= str) >= strend)
    return NULL;

  *ctype0= cs->ctype[(unsigned char) *str];
  if(*ctype0 == UDM_UNI_DIGIT)
    *ctype0= UDM_UNI_LETTER;

  for ( ; str < strend; str++)
  {
    ctype= cs->ctype[(unsigned char) *str];
    if(ctype == UDM_UNI_DIGIT)
      ctype= UDM_UNI_LETTER;

    if (*ctype0 != ctype)
      break;
  }

  *last= str;
  return beg;
}


int UdmUniCType(UDM_UNIDATA *uni_plane, int uni)
{
  int ctype,plane,code;

  plane = ((uni) >> 8) % 257;
  code=(uni)&0xFF;

  if(uni_plane[plane].table)
  {
    ctype=uni_plane[plane].table[code].ctype;
  }
  else
  {
    ctype=uni_plane[plane].ctype;
  }

  return ctype;
}

/*
  Returns TRUE if a Unicode character is "Zs - Separator, Space".
  ftp://ftp.unicode.org/Public/5.0.0/ucd/UCD.html
*/

int UdmUniIsSpace(int c)
{
  if (c > 0x0020)
  {
    if (c == 0x00A0) return 1;
    if (c < 0x1680)
      return 0;
    if (c == 0x1680) return 1;
    if ((c >= 0x2000) && (c <= 0x200B)) return 1;
    if (c == 0x202F) return 1;
    if (c == 0x3000) return 1;
  }
  else
  {
    if (c == 0x0020) return 1;
    if (c == 0x000D) return 1;
    if (c == 0x000A) return 1;
    if (c == 0x0009) return 1;
  }
  return 0;
}

/*
  Compare strings in two character sets, case insensitively.
  conv - charset pair
  s, slen  - first string
  t, tlen  - second string
*/
int
UdmStrCaseCmp2(UDM_UNIDATA *uni_plane, UDM_CONV *conv,
               const char *s, size_t slen, const char *t, size_t tlen)
{
  const char *se= s + slen;
  const char *te= t + tlen;
  int swc[16], twc[16], diff;

  while (s < se && t < te)
  {
    int sres= conv->from->mb_wc(conv, conv->from, swc,
                                (const unsigned char*) s,
                                (const unsigned char*) se);
    int tres= conv->to->mb_wc(conv, conv->to, twc,
                              (const unsigned char*) t,
                              (const unsigned char*) te);

    if (sres > 0 && tres > 0)
    {
      int sp= (swc[0] >> 8) & 0xFF;
      int tp= (twc[0] >> 8) & 0xFF;
      int sc= uni_plane[sp].table ? uni_plane[sp].table[swc[0] & 0xFF].tolower : swc[0];
              
      int tc= uni_plane[tp].table ? uni_plane[tp].table[twc[0] & 0xFF].tolower : twc[0];
      
      diff= sc - tc;

      if (diff)
        return diff;
      s+= sres;
      t+= tres;
      continue;
    }

    break;
  }
  
  diff= (se - s) - (te - t);
  
  return diff;
}


/*
  Compare strings in two character sets,
  case insensitively, accent insensitively.
  conv - charset pair
  s, slen  - first string
  t, tlen  - second string
*/
int
UdmStrCaseAccentCmp2(UDM_UNIDATA *uni_plane, UDM_CONV *conv,
                     const char *s, size_t slen,
                     const char *t, size_t tlen)
{
  const char *se= s + slen;
  const char *te= t + tlen;
  int swc[16], twc[16], diff;

  while (s < se && t < te)
  {
    int sres= conv->from->mb_wc(conv, conv->from, swc,
                                (const unsigned char*) s,
                                (const unsigned char*) se);
    int tres= conv->to->mb_wc(conv, conv->to, twc,
                              (const unsigned char*) t,
                              (const unsigned char*) te);

    if (sres > 0 && tres > 0)
    {
      int sp= (swc[0] >> 8) & 0xFF;
      int tp= (twc[0] >> 8) & 0xFF;
      int sc= uni_plane[sp].table ? uni_plane[sp].table[swc[0] & 0xFF].noaccent_tolower : swc[0];
              
      int tc= uni_plane[tp].table ? uni_plane[tp].table[twc[0] & 0xFF].noaccent_tolower : twc[0];
      
      diff= sc - tc;

      if (diff)
        return diff;
      s+= sres;
      t+= tres;
      continue;
    }

    break;
  }
  
  diff= (se - s) - (te - t);
  
  return diff;
}


/*
  Compares two unicode strings, ignore case
  Not more than len characters are compared
*/

int
UdmUniStrNCaseCmp(UDM_UNIDATA *unidata,
                  const int *s1,const int *s2, size_t len)
{
  if(len != 0)
  {
    do
    {
      if (UdmUniToLower(unidata, *s1) != UdmUniToLower(unidata, *s2++))
        return UdmUniToLower(unidata, *s1) - UdmUniToLower(unidata, *--s2);
      if (*s1++ == 0)
        break;
    } while (--len !=0 );
  }
  return 0;
}



const char udm_soundex_en[]= "01230120022455012623010202";

static unsigned int
udm_soundex_code(unsigned int ch)
{
  if (ch >= 'a' && ch <= 'z')
    ch= ch - 'a' + 'A';
  if (ch >= 'A' && ch <= 'Z')
    return udm_soundex_en[ch - 'A'];
  return 0;
}


void UdmSoundex(UDM_CHARSET *cs, char *dst, const char *src, size_t srclen)
{
  char *end, *padend;
  const char *srcend= src + srclen;
  unsigned int prev;

  while (!(prev= udm_soundex_code((unsigned char)*src)) && srclen > 0)
  {
    src++;
    srclen--;
  }

  *dst++= (*src >= 'a' && *src <= 'z') ? *src - 'a' + 'A' : *src;
  prev= udm_soundex_code((unsigned char) *src);
  end= dst + 24;
  padend= dst + 3;

  src++;
  for ( ; dst < end && src < srcend; src++)
  {
    unsigned int ch;
    if (!(ch= udm_soundex_code((unsigned char) *src)))
      continue;
    if ((ch != '0') && (ch != prev)) /* if not skipped or double */
    {
      *dst++= ch;
      prev= ch;
    }
  }

  while (dst < padend)
   *dst++ = '0';

  *dst=0;
}
