#ifndef FILE_H
#define FILE_H

#include <stdint.h>

#include "SyscallException.h"


//----------------------------------------------------------------------------
class File
{
  public:
    File(const char *name, const char *mode = "r")
        throw (SyscallException);
    ~File();

    const char *getName() const;

    bool isEOF() const;

    void seek(long offset)
        throw (SyscallException);

    uint8_t readUint8()
        throw (SyscallException);
    void writeUint8(uint8_t value)
        throw (SyscallException);
    uint16_t readUint16()
        throw (SyscallException);
    void writeUint16(uint16_t value)
        throw (SyscallException);

    size_t read(void *buffer, size_t len)
        throw (SyscallException);
    size_t write(const void *buffer, size_t len)
        throw (SyscallException);

    int puts(const char *s)
        throw (SyscallException);
    int puts(const std::string &s)
        throw (SyscallException);

    void readline(char *buffer, size_t len)
        throw (SyscallException);

    //------------------------------------------------------------------------
    static void unlink(const char *name)
        throw (SyscallException);

    static void copy(const char *src, const char *dst)
        throw (SyscallException);

  private:

    //------------------------------------------------------------------------
    class FilePImpl *m_pImpl;
};

#endif //FILE_H
