#include "Crates.h"

#include "ScoreTable.h"

//----------------------------------------------------------------------------
ScoreTable ScoreTable::sm_instance;


//----------------------------------------------------------------------------
unsigned ScoreTable::getCratePickUp(Crate *crate)
{
    unsigned score = crate->getScore();
    if (score > 0)
    {
        return score;
    }

    switch (crate->getType())
    {
    case CrateSurfaces::T_SMALL:
        return 10;
    case CrateSurfaces::T_MEDIUM:
        return 20;
    case CrateSurfaces::T_BIG:
        return 30;
    case CrateSurfaces::T_BONUS:
        return 100;
    default:
        return 0;
    }
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getCrateRescued(Crate *crate)
{
    switch (crate->getType())
    {
    case CrateSurfaces::T_SMALL:
        return 20;
    case CrateSurfaces::T_MEDIUM:
        return 40;
    case CrateSurfaces::T_BIG:
        return 60;
    default:
        return 0;
    }
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getMissileShot()
{
    return 10;
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getSAMBatteryShot()
{
    return 100;
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getTurretShot()
{
    return 50;
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getMortarShot()
{
    return 50;
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getTankShot()
{
    return 50;
}

//----------------------------------------------------------------------------
unsigned ScoreTable::getSpareFuelStep()
{
    return 1;
}
