#ifndef PLAYGROUND_MENU_H
#define PLAYGROUND_MENU_H

#include <pgmessageobject.h>

#include "Ship.h"
#include "GameControlBase.h"
#include "SinglePlayerGame.h"

#include "Menu.h"

 //----------------------------------------------------------------------------
#undef DECLARE_UPDATE_STATE
#define DECLARE_UPDATE_STATE(c) \
  class c; \
  friend class c; \
  class c : public UpdateState \
  { \
      STATE_OBJECT(c); \
    public: \
      c() {} \
      ~c() {} \
      void updateScreen(PlayGroundMenu *driver); \
  }



//----------------------------------------------------------------------------
class PlayGroundMenu : public Menu
{
  MENU_SINGLETON(PlayGround);

  //------------------------------------------------------------------------
  class UpdateState
  {
    protected:
      UpdateState() {}
    public:
      virtual ~UpdateState() {}

      virtual void updateScreen(PlayGroundMenu *driver) = 0;
  };

  DECLARE_UPDATE_STATE(FullFrameRate);

  DECLARE_UPDATE_STATE(RelativeUpdate);
  DECLARE_UPDATE_STATE(FullUpdateDelay);

  public:
    void eventShow();
    void eventHide();

    inline void setMission(const std::string &mission)
    {
        m_mission = mission;
    }

    inline void setLevel(unsigned level)
    {
        m_level = level;
    }

    //------------------------------------------------------------------------
    inline void updateScreen()
    {
      m_state->updateScreen(this);
    }

    //------------------------------------------------------------------------
    inline void setState(UpdateState *state)
    {
      m_state = state;
    }

    /**
     * Redraws the standard background.
     */
    void restoreBackground() throw(Exception);

    const SDL_Surface* getLevelPreview()
      throw(Exception);

  protected:
    bool eventKeyUp(const SDL_KeyboardEvent *key);
    bool eventKeyDown(const SDL_KeyboardEvent *key);
    bool eventMessage (MSG_MESSAGE *msg);
    bool eventQuit(int id, PG_MessageObject *widget, unsigned long data);

    void trigger();
    void initLevel() throw(Exception);

    void updateViewBox();
    bool hasViewBoxChanged() const;
    void do_playGroundRelativeUpdate();
    void do_playGroundFullUpdate();

    SDL_Rect m_viewBox;
    SDL_Rect m_oldViewBox;

    UpdateState *m_state;

    bool m_initialized;
    bool m_quit;
    bool m_ingame;
    bool m_fireDown;
    std::string m_mission;
    unsigned m_level;
    SinglePlayerGame* m_game;
    SDL_Surface *m_backSurface;
};

#endif // PLAYGROUND_MENU_H
