#ifndef PROJECTILE_H
#define PROJECTILE_H

#include "MovingObjectBase.h"

class Ship;
class TurretBarrel;
class TurretBase;
class Tank;
class GrenadeBase;

#define PROJECTILE_VELOCITY 300


//----------------------------------------------------------------------------
class ProjectileSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(ProjectileSurfaces);
};


//----------------------------------------------------------------------------
class ProjectileBase : public MovingObjectBase
{
  public:
    //------------------------------------------------------------------------
    ProjectileBase(const ObjectBase *creator);
    virtual ~ProjectileBase();

    /**
     * Creates some explosion particles on the projectile's position.
     */
    void createExplosionParticles();

    //------------------------------------------------------------------------
    void update();

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();
};


//----------------------------------------------------------------------------
class ShipProjectile : public ProjectileBase
{
  public:
    ShipProjectile(Ship *creator);
    ~ShipProjectile();
};

//----------------------------------------------------------------------------
class TurretProjectile : public ProjectileBase
{
  public:
    TurretProjectile(TurretBase *creator, const TurretBarrel *barrel);
    ~TurretProjectile();
};

//----------------------------------------------------------------------------
class MissileProjectile : public ProjectileBase
{
  public:
    MissileProjectile(Missile *creator, int angle);
    ~MissileProjectile();
};

//----------------------------------------------------------------------------
class TankProjectile : public ProjectileBase
{
  public:
    TankProjectile(Tank *creator);
    ~TankProjectile();
};

//----------------------------------------------------------------------------
class GrenadeProjectile : public ProjectileBase
{
  public:
    GrenadeProjectile(GrenadeBase *creator, int angle);
    ~GrenadeProjectile();
};

#endif //PROJECTILE_H
