#ifndef JUKE_BOX_H
#define JUKE_BOX_H

#include "Tools.h"
#include "SDLMixerCalls.h"

#define INGAME_MUSIC_TRACKS 4
//#define HIGHSCORE_MUSIC_TRACKS 0

//----------------------------------------------------------------------------
class JukeBox
{
    //------------------------------------------------------------------------
    class JukeBoxState
    {
      protected:
        JukeBoxState() {}
      public:
        virtual ~JukeBoxState() {}

        //--------------------------------------------------------------------
        virtual void enable(JukeBox *jukeBox) = 0;
        virtual void disable(JukeBox *jukeBox) = 0;

        virtual void playTitleTrack(JukeBox *jukeBox);
        virtual void playInGameTrack(JukeBox *jukeBox);
        virtual void playHighScore1stEntryTrack(JukeBox *jukeBox);
        virtual void playHighScoreOtherEntryTrack(JukeBox *jukeBox);
        virtual void playHighScoreNoEntryTrack(JukeBox *jukeBox);
        virtual void onStopHook(JukeBox *jukeBox) = 0;

      protected:
        //--------------------------------------------------------------------
        void do_playTitleTrack(JukeBox *jukeBox);
        void do_playInGameTrack(JukeBox *jukeBox);
        void do_playHighScore1stEntryTrack(JukeBox *jukeBox);
        void do_playHighScoreOtherEntryTrack(JukeBox *jukeBox);
        void do_playHighScoreNoEntryTrack(JukeBox *jukeBox);
    };

    //------------------------------------------------------------------------
    class Stop;
    friend class Stop;
    class Stop : public JukeBoxState
    {
        STATE_OBJECT(Stop);
      public:
        Stop() {}
        ~Stop() {}

        //--------------------------------------------------------------------
        void enable(JukeBox *jukeBox);
        void disable(JukeBox *jukeBox);

        void onStopHook(JukeBox *jukeBox);
    };
    
    //------------------------------------------------------------------------
    class Title;
    friend class Title;
    class Title : public JukeBoxState
    {
        STATE_OBJECT(Title);
      public:
        Title() {}
        ~Title() {}

        //--------------------------------------------------------------------
        void enable(JukeBox *jukeBox);
        void disable(JukeBox *jukeBox);

        void playTitleTrack(JukeBox *jukeBox);
        void onStopHook(JukeBox *jukeBox);
    };

    //------------------------------------------------------------------------
    class InGame;
    friend class InGame;
    class InGame : public JukeBoxState
    {
        STATE_OBJECT(InGame);
      public:
        InGame() {}
        ~InGame() {}

        //--------------------------------------------------------------------
        void enable(JukeBox *jukeBox);
        void disable(JukeBox *jukeBox);

        void playInGameTrack(JukeBox *jukeBox);
        void onStopHook(JukeBox *jukeBox);
    };

    //------------------------------------------------------------------------
    class HighScore;
    friend class HighScore;
    class HighScore : public JukeBoxState
    {
        STATE_OBJECT(HighScore);
      public:
        HighScore() {}
        ~HighScore() {}

        //--------------------------------------------------------------------
        void enable(JukeBox *jukeBox);
        void disable(JukeBox *jukeBox);

        void playHighScore1stEntryTrack(JukeBox *jukeBox);
        void playHighScoreOtherEntryTrack(JukeBox *jukeBox);
        void playHighScoreNoEntryTrack(JukeBox *jukeBox);
        void onStopHook(JukeBox *jukeBox);
    };

  public:
    //------------------------------------------------------------------------
    ~JukeBox();

    //------------------------------------------------------------------------
    static void init() throw (Exception);
    static void destroy();

    static inline JukeBox *getInstance()
    {
        return sm_instance;
    }

    //------------------------------------------------------------------------
    inline bool isEnabled() const
    {
        return m_enabled;
    }

    inline void enable()
    {
        m_state->enable(this);
        m_enabled = true;
    }

    inline void disable()
    {
        m_state->disable(this);
        m_enabled = false;
    }

    inline void playTitleTrack()
    {
        m_state->playTitleTrack(this);
    }

    inline void playInGameTrack()
    {
        m_state->playInGameTrack(this);
    }

    inline void playHighScore1stEntryTrack()
    {
        m_state->playHighScore1stEntryTrack(this);
    }

    inline void playHighScoreOtherEntryTrack()
    {
        m_state->playHighScoreOtherEntryTrack(this);
    }

    inline void playHighScoreNoEntryTrack()
    {
        m_state->playHighScoreNoEntryTrack(this);
    }

    inline void onStopHook()
    {
        m_state->onStopHook(this);
    }

  protected:
    //------------------------------------------------------------------------
    JukeBox();

    inline void setState(JukeBoxState *state)
    {
        m_state = state;
    }

    static void stopHook();

  private:
    //------------------------------------------------------------------------
    Mix_Music *m_inGameTracks[INGAME_MUSIC_TRACKS];
    //Mix_Music *m_highScoreTracks[HIGHSCORE_MUSIC_TRACKS];

    bool m_enabled;

    /// The current state of the JukeBox.
    JukeBoxState *m_state;

    static JukeBox *sm_instance;
};

#endif // JUKE_BOX_H
