#include "JukeBox.h"
#include "SoundMixer.h"
#include "Configuration.h"


//----------------------------------------------------------------------------
JukeBox::Stop JukeBox::Stop::sm_instance;
JukeBox::Title JukeBox::Title::sm_instance;
JukeBox::InGame JukeBox::InGame::sm_instance;
JukeBox::HighScore JukeBox::HighScore::sm_instance;


//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::playTitleTrack(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playTitleTrack(jukeBox);
    }

    jukeBox->setState(Title::getInstance());
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::playInGameTrack(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playInGameTrack(jukeBox);
    }

    jukeBox->setState(InGame::getInstance());
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::playHighScore1stEntryTrack(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playHighScore1stEntryTrack(jukeBox);
    }

    jukeBox->setState(HighScore::getInstance());
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::playHighScoreOtherEntryTrack(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playHighScoreOtherEntryTrack(jukeBox);
    }

    jukeBox->setState(HighScore::getInstance());
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::playHighScoreNoEntryTrack(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playHighScoreNoEntryTrack(jukeBox);
    }

    jukeBox->setState(HighScore::getInstance());
}


//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::do_playTitleTrack(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::PlayMusic(jukeBox->m_inGameTracks[0], -1);
    SoundMixer::getInstance()->setCurrentMusicVolume();
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::do_playInGameTrack(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::PlayMusic(
        jukeBox->m_inGameTracks[myRand(INGAME_MUSIC_TRACKS)], 0);
    SoundMixer::getInstance()->setCurrentMusicVolume();
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::do_playHighScore1stEntryTrack(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::do_playHighScoreOtherEntryTrack(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}

//----------------------------------------------------------------------------
void JukeBox::JukeBoxState::do_playHighScoreNoEntryTrack(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}


//----------------------------------------------------------------------------
void JukeBox::Stop::enable(JukeBox *jukeBox)
{
    // No music to play.
}

//----------------------------------------------------------------------------
void JukeBox::Stop::disable(JukeBox *jukeBox)
{
    // No music to stop.
}

//----------------------------------------------------------------------------
void JukeBox::Stop::onStopHook(JukeBox *jukeBox)
{
    // Should never occur.
}


//----------------------------------------------------------------------------
void JukeBox::Title::enable(JukeBox *jukeBox)
{
    if (!jukeBox->isEnabled())
    {
        do_playTitleTrack(jukeBox);
    }
}

//----------------------------------------------------------------------------
void JukeBox::Title::disable(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}

//----------------------------------------------------------------------------
void JukeBox::Title::playTitleTrack(JukeBox *jukeBox)
{
    // Already playing.
}

//----------------------------------------------------------------------------
void JukeBox::Title::onStopHook(JukeBox *jukeBox)
{
    // Should never occur,
    // because the title track will be repeated automatically.
}


//----------------------------------------------------------------------------
void JukeBox::InGame::enable(JukeBox *jukeBox)
{
    if (!jukeBox->isEnabled())
    {
        do_playInGameTrack(jukeBox);
    }
}

//----------------------------------------------------------------------------
void JukeBox::InGame::disable(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}

//----------------------------------------------------------------------------
void JukeBox::InGame::playInGameTrack(JukeBox *jukeBox)
{
    // Already playing an in-game track.
}

//----------------------------------------------------------------------------
void JukeBox::InGame::onStopHook(JukeBox *jukeBox)
{
    if (jukeBox->isEnabled())
    {
        do_playInGameTrack(jukeBox);
    }
}


//----------------------------------------------------------------------------
void JukeBox::HighScore::enable(JukeBox *jukeBox)
{
    // Should never occur.
}

//----------------------------------------------------------------------------
void JukeBox::HighScore::disable(JukeBox *jukeBox)
{
    // Should never occur.
}

//----------------------------------------------------------------------------
void JukeBox::HighScore::playHighScore1stEntryTrack(JukeBox *jukeBox)
{
    // Already playing.
}

//----------------------------------------------------------------------------
void JukeBox::HighScore::playHighScoreOtherEntryTrack(JukeBox *jukeBox)
{
    // Already playing.
}

//----------------------------------------------------------------------------
void JukeBox::HighScore::playHighScoreNoEntryTrack(JukeBox *jukeBox)
{
    // Already playing.
}

//----------------------------------------------------------------------------
void JukeBox::HighScore::onStopHook(JukeBox *jukeBox)
{
    SDL_MIXER_CALLS::HaltMusic();
}


//----------------------------------------------------------------------------
JukeBox* JukeBox::sm_instance = NULL;

//----------------------------------------------------------------------------
JukeBox::JukeBox()
{
    memset(m_inGameTracks, 0, sizeof(m_inGameTracks));
    //memset(m_highScoreTracks, 0, sizeof(m_highScoreTracks));

    m_enabled = false;
    m_state = Stop::getInstance();
}

//----------------------------------------------------------------------------
JukeBox::~JukeBox()
{
    for (unsigned i=0; i<INGAME_MUSIC_TRACKS; i++)
    {
        ZAP_MUSIC(m_inGameTracks[i]);
    }

    //for (unsigned i=0; i<HIGHSCORE_MUSIC_TRACKS; i++)
    //{
    //    ZAP_MUSIC(m_highScoreTracks[i]);
    //}

    m_state = NULL;
}

//----------------------------------------------------------------------------
void JukeBox::init() throw (Exception)
{
    const char *inGameFiles[] = {
        "title.mod", "track01.mod", "track02.mod", "track03.mod"
    };

    std::string dir;
    dir.append(Configuration::getInstance()->getDataDir())
        .append("/sound/music/");

    sm_instance = new JukeBox();
    char file[1024];

    for (unsigned i=0; i<INGAME_MUSIC_TRACKS; i++)
    {
        snprintf(file, 1024, "%s/%s", dir.c_str(), inGameFiles[i]);
        sm_instance->m_inGameTracks[i] = SDL_MIXER_CALLS::LoadMUS(file);
    }

    //for (unsigned i=0; i<HIGHSCORE_MUSIC_TRACKS; i++)
    //{
    //    snprintf(file, 1024, "%s/highscore%02d.mod", dir.c_str(), i+1);
    //    sm_instance->m_highScoreTracks[i] = SDL_MIXER_CALLS::LoadMUS(file);
    //}

    SDL_MIXER_CALLS::HookMusicFinished(JukeBox::stopHook);
}

//----------------------------------------------------------------------------
void JukeBox::destroy()
{
    SDL_MIXER_CALLS::HookMusicFinished(NULL);

    sm_instance->disable();
    ZAP_POINTER(sm_instance);
}

//----------------------------------------------------------------------------
void JukeBox::stopHook()
{
    // @todo: The SDL_mixer docu says, that no SDL_mixer function
    //        shall be called via HookMusicFinished.
    //        This might lead to problems in the state machine.

    sm_instance->onStopHook();
}
