#ifndef DECORATIONBASE_H
#define DECORATIONBASE_H

#include "XMLElements.h"
#include "ObjectBase.h"

//----------------------------------------------------------------------------
/**
 * This is a base class for all decorations.
 */
class DecorationBase : public ObjectBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *node);
        virtual ~InitializationData();

        /// The object id of the decoration.
        unsigned id;

        /// Indicates, if the decoration shall be initially hidden.
        bool hidden;
    };

    //------------------------------------------------------------------------
    virtual ~DecorationBase();

    //------------------------------------------------------------------------
    /**
     * Calls the appropriate decoration's create() method
     * and passes the created decoration to the GameInterface.
     *
     * @return A pointer to the created decoration.
     */
    static DecorationBase *create(const XMLNode *decorationNode);

    /**
     * @return true, if the decoration has clear vision to the player's ship.
     */
    bool canReachPlayerShip() const;

  protected:
    //------------------------------------------------------------------------
    DecorationBase(const InitializationData &init);
};

#endif //DECORATIONBASE_H
