///////////////////////////////////////////////////////////////////////////////
// $Id: tilecache.cpp,v 1.1 2004/09/29 20:08:08 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    tilegroup.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of the tile group/category class
*/

// Qt includes
#include <qpixmap.h>

// local includes
#include "tilecache.h"

///////////////////////////////////////////////////////////////////////////////

TileCache::TileCache()
{
	m_pixmaps.setAutoDelete(true);
}

///////////////////////////////////////////////////////////////////////////////

TileCache::~TileCache()
{
}

///////////////////////////////////////////////////////////////////////////////

QPixmap* TileCache::pixmap(uint index)
{
	QPixmap* p = 0;
	if (!m_pixmaps.isEmpty())
	{
		p = m_pixmaps[index];
	}

	return p;
}

///////////////////////////////////////////////////////////////////////////////

void TileCache::insertPixmap(uint index, QPixmap* pixmap)
{
	m_pixmaps.insert(index, pixmap);
}

///////////////////////////////////////////////////////////////////////////////

void TileCache::copy(const TileCache& other)
{
	m_pixmaps.clear();
	QIntDictIterator<QPixmap> it(other.m_pixmaps);
	for(; it.current() != 0; ++it)
	{
		QPixmap* pix = it.current();
		m_pixmaps.insert(it.currentKey(), new QPixmap(*pix));
	}
}

// End of file

