/*
 * Exception is used to format exceptions thrown
 * 
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */

#ifndef __EXCEPTION_H__
#define __EXCEPTION_H__

#include <string>
using namespace std;

const int TCP_TIMEOUT       =  0;
const int TCP_EXIT_ERROR    = -1;
const int TCP_EXIT_NORMAL   = -2;
const int TCP_POLL_ERROR    = -3;
const int TCP_UNINITIALIZED = -4;
const int TCP_MESSAGE_ERROR = -5;
const int TCP_WRITE_ERROR   = -6;

const int MSG_INVALID_MSG   = -7;

class Exception
{
   int m_errCode;
   string m_errMsg;
   string m_className;
   string m_method;
   
 public:
   Exception (int errCode, string className, string method, string msg) { 
      m_errCode = errCode; m_errMsg = msg; 
      m_className = className; m_method = method;
   }
   int getErrorCode() { return m_errCode; }
   string getClassName() { return m_className; }
   string getMethod() { return m_method; }
   string getString() { return m_errMsg; }

};

#endif //__EXCEPTION_H__
