/*
 * Message is the container for the messages sent to the user interface.
 * 
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */
#ifndef __MESSAGE_H__
#define __MESSAGE_H__

#include "main.h"
#include <string>

#include <libxml/parser.h>
#include <libxml/tree.h>

const int MID_MSG_CONTROL = 0x8080;
// msg types for application communication
const int MSG_CONNECT_TEST      = 0x1;
const int MSG_APP_LAUNCH        = 0x2;
const int MSG_UNKNOWN           = 0xEF;
const int MSG_ERROR             = 0xFF;

class Message
{
   int m_control;  //(unused) flag to validate that this packet is from us
   int m_type;     //msg type. MSG_...

   std::string m_rawXml;

   xmlDocPtr m_xmlDoc;

 public:
   Message();
   ~Message();

   bool load(std::string xmlstr);
   void empty();

   bool isValid();
   //int getControl();
   //bool setControl(int control);
   //int getNumFields();

   int getType();
   bool isType(int type);
   void setType(int type);

   std::string getField(std::string key);
   void setField(std::string key, std::string value);

   std::string getData();
   int getDataSize();

};

#endif //__MESSAGE_H__
