#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <glib.h>
#include <dbus/dbus-glib-bindings.h>
#include "calibrator.h"
#include "moblin-system-dbus.h"
#include "moblin-system-daemon.h"

#ifdef LOGDEBUG
#define LOGFILE "/var/log/moblin-system-daemon"
FILE *logfp = NULL;
#endif

MoblinSystemServer *dbusserver = NULL;

static void
sig_handler(int num)
{
	if(num == SIGTERM)
	    exit(EXIT_SUCCESS);
}

int
main(int argc, char *argv[])
{
GMainLoop *loop = NULL;

	switch(fork()) {
	case -1:
		fprintf(stderr, "%s: fork: %s\n", argv[0], strerror(errno));
		exit(EXIT_FAILURE);
	case 0:
		/* child */
		setsid();
		umask(0);
		break;
	default:
		/* parent */
		exit(EXIT_SUCCESS);
	}

	g_type_init();

	signal(SIGTERM, sig_handler);

	loop = g_main_loop_new(NULL,FALSE);

#ifdef LOGDEBUG
	if((logfp = fopen(LOGFILE, "w")) == NULL)
	{
	    fprintf(stderr, "Failed to open the log file\n");
	    exit(EXIT_FAILURE);
	}
	setbuf(logfp, NULL);
#endif
	dbusserver = (MoblinSystemServer*)g_object_new (moblin_system_server_get_type (), NULL);
	if(dbusserver == NULL)
	{
		PRINTF("Failed to attach to DBUS\n");
		exit(EXIT_FAILURE);
	}

	g_main_loop_run(loop);

	PRINTF("DAEMON EXIT\n");
	return 0;
}
