/*
 *  Moblin Background Management Application
 *  Source: capplets/background/wp-info.h
 *  Author: Todd Brandt <todd.e.brandt@intel.com>
 *  Copyright 2007-2008 Intel Corp (moblin.org)
 *
 *  Based on capplets/background/gnome-wp-info.h from
 *  gnome-control-center-2.18.1: Rodney Dawes <dobey@ximian.com>
 *  Copyright 2003-2006 Novell, Inc. (www.novell.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _MOBLIN_WP_INFO_H_
#define _MOBLIN_WP_INFO_H_

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomeui/gnome-thumbnail.h>

typedef struct _MoblinWPInfo MoblinWPInfo;

struct _MoblinWPInfo {
  gchar * uri;
  gchar * thumburi;
  gchar * name;
  gchar * mime_type;
  GnomeVFSFileSize size;
  time_t mtime;
};

MoblinWPInfo * moblin_wp_info_new (const gchar * uri,
				 GnomeThumbnailFactory * thumbs);
void moblin_wp_info_free (MoblinWPInfo * info);

#endif

