#ifndef __MOBLIN_GCONFKEYS_H__
#define __MOBLIN_GCONFKEYS_H__

#include <glib.h>
#include <gtk/gtk.h>

/**********************************************************
 * Keyboard Shortcuts GCONF keys                          *
 *                                                        *
 * These keys are used to define the set of keyboard      *
 * shortcuts that moblin-applets supports. They are set   *
 * by the keybindings capplet, and are read by            *
 * moblin-settings-daemon. Some of the shortcuts have     *
 * custom actions which are hardcoded in                  *
 * moblin-settings-daemon, and some rely on the data in   *
 * their associated shortcut_cmd_key string. The cmd_keys *
 * define an execution string that is spawns in a shell   *
 * when the shortcut is pressed, these values are defined *
 * in the schemas files and are system-dependant. A       *
 * shortcut with a NULL cmd_key relies on a hard-coded    *
 * action.                                                *
 *                                                        *
 **********************************************************/

#define GCONF_BINDING_DIR "/apps/moblin_settings_daemon/keybindings"
#define BINDKEY(x) (shortcut_keys[(x)])
#define BINDCMDKEY(x) (shortcut_cmd_keys[(x)])

enum {
	MUTE=0,			/* GCONF_VALUE_STRING */
	VOLUME_DOWN,		/* GCONF_VALUE_STRING */
	VOLUME_UP,		/* GCONF_VALUE_STRING */
	PLAY,			/* GCONF_VALUE_STRING */
	PAUSE,			/* GCONF_VALUE_STRING */
	STOP,			/* GCONF_VALUE_STRING */
	PREVIOUS,		/* GCONF_VALUE_STRING */
	NEXT,			/* GCONF_VALUE_STRING */
	HOME,			/* GCONF_VALUE_STRING */
	SEARCH,			/* GCONF_VALUE_STRING */
	EMAIL,			/* GCONF_VALUE_STRING */
	HELP,			/* GCONF_VALUE_STRING */
	WWW,			/* GCONF_VALUE_STRING */
	CALC,			/* GCONF_VALUE_STRING */
	TERM,			/* GCONF_VALUE_STRING */
	CHAT,			/* GCONF_VALUE_STRING */
	MEMO,			/* GCONF_VALUE_STRING */
	DICT,			/* GCONF_VALUE_STRING */
	TASKS,			/* GCONF_VALUE_STRING */
	MEDIA,			/* GCONF_VALUE_STRING */
	CONTACTS,		/* GCONF_VALUE_STRING */
	BRIGHTNESS_UP,		/* GCONF_VALUE_STRING */
	BRIGHTNESS_DOWN,	/* GCONF_VALUE_STRING */
	BRIGHTNESS_MAXMIN,	/* GCONF_VALUE_STRING */
	HANDLED_SHORTCUT_KEYS	/* GCONF_VALUE_STRING */
};

const char *shortcut_keys[HANDLED_SHORTCUT_KEYS];
const char *shortcut_cmd_keys[HANDLED_SHORTCUT_KEYS];

/**********************************************************
 * Sound Settings GCONF keys                              *
 *                                                        *
 * These keys are used to define behavioral elements of   *
 * the sound settings software.                           *
 *                                                        *
 **********************************************************/

#define GCONF_SOUND_DIR "/apps/moblin_settings_daemon/sound"
#define SNDKEY(x) (sound_keys[(x)])

enum {
	VOLUMESHORTCUT_STEP=0,	/* GCONF_VALUE_INT    */
	HANDLED_SOUND_KEYS
};

const char *sound_keys[HANDLED_SOUND_KEYS];

/**********************************************************
 * Proxy Settings GCONF keys                              *
 *                                                        *
 * These keys are used to define all the configurable     *
 * elements associated with the proxy setup               *
 *                                                        *
 **********************************************************/

#define GCONF_PROXY_DIR "/system/proxy"
#define GCONF_HTTP_PROXY_DIR "/system/http_proxy"
#define NETPROXYKEY(x) (networkproxy_keys[(x)])

enum {
	USE_PROXY=0,		/* GCONF_VALUE_BOOL   */
	USE_SAME_PROXY,		/* GCONF_VALUE_BOOL   */
	HTTP_PROXY_HOST,	/* GCONF_VALUE_STRING */
	HTTP_PROXY_PORT,	/* GCONF_VALUE_INT    */
	HTTP_USE_AUTH,		/* GCONF_VALUE_BOOL   */
	HTTP_AUTH_USER,		/* GCONF_VALUE_STRING */
	HTTP_AUTH_PASSWD,	/* GCONF_VALUE_STRING */
	IGNORE_HOSTS,		/* GCONF_VALUE_LIST   */
	PROXY_MODE,		/* GCONF_VALUE_STRING */
	SECURE_PROXY_HOST,	/* GCONF_VALUE_STRING */
	OLD_SECURE_PROXY_HOST,	/* GCONF_VALUE_STRING */
	SECURE_PROXY_PORT,	/* GCONF_VALUE_INT    */
	OLD_SECURE_PROXY_PORT,	/* GCONF_VALUE_INT    */
	FTP_PROXY_HOST,		/* GCONF_VALUE_STRING */
	OLD_FTP_PROXY_HOST,	/* GCONF_VALUE_STRING */
	FTP_PROXY_PORT,		/* GCONF_VALUE_INT    */
	OLD_FTP_PROXY_PORT,	/* GCONF_VALUE_INT    */
	SOCKS_PROXY_HOST,	/* GCONF_VALUE_STRING */
	OLD_SOCKS_PROXY_HOST,	/* GCONF_VALUE_STRING */
	SOCKS_PROXY_PORT,	/* GCONF_VALUE_INT    */
	OLD_SOCKS_PROXY_PORT,	/* GCONF_VALUE_INT    */
	PROXY_AUTOCONFIG_URL,	/* GCONF_VALUE_STRING */
	HANDLED_NETWORKPROXY_KEYS
};

const char *networkproxy_keys[HANDLED_NETWORKPROXY_KEYS];

/**********************************************************
 * Backlight Settings GCONF keys                          *
 *                                                        *
 * These keys are use to define behavioral elements of    *
 * the sound settings software.                           *
 *                                                        *
 **********************************************************/

#define GCONF_BACKLIGHT_DIR "/apps/moblin_settings_daemon/backlight"


/**********************************************************
 * Font Settings GCONF keys                               *
 *                                                        *
 * These keys are use to define the font settings for the *
 * desktop environment                                    *
 *                                                        *
 **********************************************************/

#define GCONF_FONT_DIR "/desktop/moblin/font"
#define FONTKEY(key) (font_keys[(key)])

#define GNOME_GCONF_FONT_DIR "/desktop/gnome/interface"
#define NAUTILUS_GCONF_FONT_DIR "/apps/nautilus/preferences"
#define GNOMEFONTKEY(key) (gnome_font_keys[(key)])

enum {
	APP_FONT,
	DESKTOP_FONT,
	MONOSPACE_FONT,
	DOCUMENT_FONT,
	HANDLED_FONT_KEYS
};

const char *font_keys[HANDLED_FONT_KEYS];
const char *gnome_font_keys[HANDLED_FONT_KEYS];

/**********************************************************
 * Background Settings GCONF keys                         *
 *                                                        *
 * These keys are use to define the background/wallpaper  *
 * settings for the desktop environment                   *
 *                                                        *
 **********************************************************/

#define GCONF_BACKGROUND_DIR "/desktop/moblin/background"
#define BGKEY(key) (background_keys[(key)])

#define GNOME_GCONF_BACKGROUND_DIR "/desktop/gnome/background"
#define GNOMEBGKEY(key) (gnome_background_keys[(key)])

enum {
	WP_FILE=0,		/* GCONF_VALUE_STRING */
	WP_OPTIONS,		/* GCONF_VALUE_STRING */
	BG_SHADING,		/* GCONF_VALUE_STRING */
	BG_PCOLOR,		/* GCONF_VALUE_STRING */
	BG_SCOLOR,		/* GCONF_VALUE_STRING */
	BG_THUMBPATHS,		/* GCONF_VALUE_STRING */
	HANDLED_BACKGROUND_KEYS
};

const char *background_keys[HANDLED_BACKGROUND_KEYS];
const char *gnome_background_keys[HANDLED_BACKGROUND_KEYS];

/**********************************************************
 * Theme Settings GCONF keys                              *
 *                                                        *
 * These keys are use to define the background/wallpaper  *
 * settings for the desktop environment                   *
 *                                                        *
 **********************************************************/

#define GCONF_THEME_DIR "/desktop/moblin/interface"
#define THEMEKEY(key) (theme_keys[(key)])

#define GNOME_GCONF_THEME_DIR "/desktop/gnome/interface"
#define GNOME_GCONF_LOCKDOWN_DIR "/desktop/gnome/lockdown"
#define GNOMETHEMEKEY(key) (gnome_theme_keys[(key)])

enum {
	GTK_THEME,		/* GCONF_VALUE_STRING */
	ICON_THEME,		/* GCONF_VALUE_STRING */
	COLOR_SCHEME,		/* GCONF_VALUE_STRING */
	LOCKDOWN,		/* GCONF_VALUE_STRING */
	HANDLED_THEME_KEYS
};

const char *theme_keys[HANDLED_THEME_KEYS];
const char *gnome_theme_keys[HANDLED_THEME_KEYS];

/**********************************************************
 * Keyboard Settings GCONF keys                           *
 *                                                        *
 * These keys are used to define the soft keyboard        *
 * properties                                             *
 *                                                        *
 **********************************************************/

#define GCONF_KEYBOARD_DIR "/desktop/moblin/keyboard"
#define KBKEY(key) (keyboard_keys[(key)])

enum {
	KB_LAYOUT=0,		/* GCONF_VALUE_STRING */
	KB_MODEL,		/* GCONF_VALUE_STRING */
	KB_OPTIONS,		/* GCONF_VALUE_STRING */
	KB_LAYOUTS,		/* GCONF_VALUE_STRING */
	HANDLED_KEYBOARD_KEYS
};

const char *keyboard_keys[HANDLED_KEYBOARD_KEYS];

/* Functions */

GtkIconTheme* moblin_icon_theme_get_default(void);

#endif /* __MOBLIN_GCONFKEYS_H__ */
