#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    Constant.py: This module contains variable definitions that can be used across the code

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
import pygtk
pygtk.require("2.0")
import gobject, gtk

MediaAppPath = '/usr/share/moblin-media'
MediaStreamPath = os.path.join(os.getenv('HOME'), 'media')
MediaThemePath = '/usr/share/themes/mobilebasic'
MediaSpecImagePath = '/usr/share/moblin-media/images'
MediaImagePath = os.path.join(MediaThemePath, 'images')
MediaGladePath = os.path.join(MediaAppPath, 'MoblinMedia.glade')
MediaPluginsDir = os.path.join(MediaStreamPath, 'plugin')
MediaConfigsDir = '/usr/share/media-services'

MediaState = {'audio':['MS_AUDIO_BR_ALBUM','MS_AUDIO_BR_ART','MS_AUDIO_PLAYBACK','MS_AUDIO_BR_SONG','MS_AUDIO_DEFAULT'],
     'video':['MS_VIDEO_PLAYBACK', 'MS_VIDEO_THUMBNAIL', 'MS_VIDEO_SHARE', 'MS_VIDEO_DEFAULT'],
     'photo':['MS_PHOTO_PLAYBACK', 'MS_PHOTO_THUMBNAIL', 'MS_PHOTO_SHARE', 'MS_PHOTO_DEFAULT'],
     }

MediaPattern = {'audio':['[mM][pP]3', '[wW][aA][vV]', '[wW][mM][aA]', '[aA][aA][cC]', '[rR][mM]'],
     'video':['[mM][pP][gG]', '[mM][pP][eE][gG]', '[mM][pP]4', '3[gG][pP]', '[oO][gG][gG]','[rR][mM][vV][bB]', '[wW][mM][vV]', '[mM][oO][vV]', '[aA][vV][iI]', '[aA][sS][fF]'],
     'photo':['[jJ][pP][gG]', '[bB][mM][pP]', '[wW][bB][mM][pP]', '[jJ][pP][eE][gG]', '[pP][nN][gG]', '[gG][iI][fF]'],
     }

MediaType = {'audio':['mp3', 'wav', 'wma', 'aac', 'rm'],
     'video':['mpg', 'mpeg', 'mp4', '3gp', 'ogg','rmvb', 'wmv', 'mov', 'avi'],
     'photo':['jpg', 'bmp',  'jpeg', 'png', 'gif'],
     }

# for fast forward and fast rewind
PB_NORMAL, PB_FORWARD, PB_REWIND = range(3)
FAST_SPEED = 4

#HildonSupport = False
HildonSupport = True

MediaUrlList = ['http://127.0.0.1/test1.mp3',
                'http://127.0.0.1/test2.mp3']

MediaColor = {'ctrl_ebox_focus': gtk.gdk.Color(40000,40000,40000,0),
      'ctrl_ebox_unfocus': gtk.gdk.Color(20000,20000,20000,0),
      'ctrl_box_bg': gtk.gdk.Color(5000,5000,5000,0),
      'toolbar_bg': gtk.gdk.Color(20000,20000,20000,0),
      'select_window_bg': gtk.gdk.Color(5000,5000,5000,0),
      'toolbar_shadow': gtk.gdk.Color(40000,40000,40000,0),
      'mm_playback_bg': gtk.gdk.Color(30000,30000,30000,0),
      'select_label_fg': gtk.gdk.Color(60000,60000,60000,0),
      'default_label_bg': gtk.gdk.Color(30000,30000,30000,0),}

MediaString = {'open_dlg_title' : 'Choose A File'}


