#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    PhotoView.py: Manage Photo View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string

from PIL import Image
import ThumbnailView
import PhotoPlayback

class PhotoView:
    """
    A class which manage photo view.
    """
    #
    def on_image_size_allocate(self , widget , allocation):
        if self.alloc == None :
            self.alloc = allocation
            GeneralFunc.set_image_fit(self.photo_cur_img, self.last_pic_name)
        else :
            if self.alloc.width != allocation.width or  self.alloc.width != allocation.width :
                GeneralFunc.set_image_fit(self.photo_cur_img, self.last_pic_name)                
                self.alloc = allocation
            else:            
                return
    #
    def __init__(self, app):
        """
        init function
        """
        self.app = app
        self.wTree = gtk.glade.XML(Constant.MediaGladePath,root='mp_photo_nbk')
        dic={"on_mp_photo_nbk_key_press_event": self.DispatchKeyEvent,}
        self.wTree.signal_autoconnect(dic)

        self.view_nbk = self.wTree.get_widget('mp_photo_nbk')
        self.view_nbk.set_show_tabs(False)

        self.state_thumbnail = 0
        self.state_playback = 1
        self.state_share = 2
        self.state_default = 3

        self.state_current = self.state_thumbnail

        # last filename
        self.last_pic_name = None

        # if first launch
        self.is_first_launch = True

        self.photo_cur_img = self.wTree.get_widget("wm_pm_cur_img")
        self.photo_viewport = self.wTree.get_widget('pm_viewport')
        #-->temp
        self.photo_viewport.connect ('size-allocate', self.on_image_size_allocate )
        # for thumbnail
        self.CurrentDir = Constant.MediaStreamPath
        self.CurIndex = 0
        self.ThumbnailView = ThumbnailView.ThumbnailSupport(self.wTree,self.app)
        self.ThumbnailView.SetModel()
        self.photoplayback = PhotoPlayback.PhotoPlayback(self.wTree,self.app)
        
        self.init_ui()
        
        self.alloc = None
   
    def get_photo_playback(self):
        return self.photoplayback
        
    def get_photo_thumbnail(self):
        return self.ThumbnailView
        
    def set_cur_picture(self, filename,increase=0):
        if os.path.isfile(filename):
            GeneralFunc.set_image_fit(self.photo_cur_img, filename,increase)
            self.last_pic_name = filename
        else:
            pass

    def init_ui(self):
        self.view_nbk.set_current_page(self.state_current)
        widget = self.wTree.get_widget('pm_default_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])
        widget = self.wTree.get_widget('pm_default_view_lb')
        widget.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        widget = self.wTree.get_widget('pm_playback_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])
        widget = self.wTree.get_widget('pm_cur_img_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])


    def update_ui(self, is_last_view):
        self.update_status(self.state_current)
        self.ThumbnailView.MakeAllImageThumbnail(self.CurrentDir)
	
    def update_cur_image_dir(self, dir):
        if os.path.isdir(dir):
	    self.CurrentDir = dir
	else:
	    return

    def update_state_thumbnail(self):
        self.state_current = self.state_thumbnail
	self.view_nbk.set_current_page(self.state_current)
	self.hide_photo_op_buttons()
        self.app.view['toolbar'].SetThumbnailResizeBar(True)

    def update_state_playback(self):
        self.state_current = self.state_playback
	self.view_nbk.set_current_page(self.state_current)
	self.show_photo_op_buttons()
        self.app.view['toolbar'].SetThumbnailResizeBar(False)

    def update_state_share(self):
        self.state_current = self.state_share
	self.view_nbk.set_current_page(self.state_current)
	self.hide_photo_op_buttons()
	
    def update_state_default(self):
        self.state_current = self.state_default
	self.view_nbk.set_current_page(self.state_current)
	self.hide_photo_op_buttons()
	
    def hide_photo_op_buttons(self):
	toolbar = self.app.view['toolbar']
	toolbar.hide_photo_op_buttons()

    def show_photo_op_buttons(self):
	toolbar = self.app.view['toolbar']
	toolbar.show_photo_op_buttons()
	
    def is_first_load(self):
        return (self.is_first_launch == True)

    def mark_default_flag(self):
        self.is_first_launch = False
        self.update_ui(True)

    def set_fs_mode(self, on):
        pass
    
    def set_cur_dir(self, filename):
	if os.path.isdir(filename):
	    self.CurrentDir = filename
	    return
	head, tail = os.path.split(filename)
	self.CurrentDir = head
	
    def set_cur_index(self, i):
	self.CurIndex = i
	
    def update_status(self, status):
	if status == self.state_default:
	    self.update_state_default()
	elif status == self.state_playback:
	    self.update_state_playback()
	elif status == self.state_thumbnail:
	    self.update_state_thumbnail()
	elif status == self.state_share:
	    self.update_state_share()
	else:
	    pass
	
    def DispatchKeyEvent(self,widget,event):
	keyval=gtk.gdk.keyval_name(event.keyval)
	# print ' in dispatch key event keyval is :',keyval
	if self.state_current==self.state_playback:
	    self.photoplayback.key_press_event(widget,event)
	elif self.state_current==self.state_thumbnail:
	    self.ThumbnailView.key_press_event(widget,event)
	else :
	    pass
