#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#    PlayList.py: play list class
# 
#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import random
import string
import os
import os.path
import FileIO
import Constant

#for debug
def Play(fileName):
    print fileName
    return

#end for debug
MUSICMANAGDIR = os.path.join(Constant.MediaStreamPath, '.playlist')
class PlayList:
    def __init__(self, listName):
        self.repeated = False
        self.shuffled = False
        self.listName = listName
        self.songsUri = []
        self.queue = []
        self.currentName=''
        self.currentIndex=0
        # fix me
        listFileName1 = os.path.join(MUSICMANAGDIR, '%s.m3u' % listName)
        listFileName2 = os.path.join(MUSICMANAGDIR, '%s.pls' % listName)
        self.listFileName = listFileName1
        self.ext ='.m3u'
        if os.path.isfile(listFileName1):
            # readFromFile(m3uFile,'m3u')
            self.songsUri = FileIO.getUrisFromFile(self.listFileName, ext='.m3u')
            self.listFileName = listFileName1
            self.ext ='.m3u'
	    print "list:, songsUri:\n",listFileName1, self.songsUri
        elif os.path.isfile(listFileName2):
            self.songsUri = FileIO.getUrisFromFile(self.listFileName, ext='.pls')
            self.listFileName = listFileName2
            self.ext='.pls'
        else:
            m3uFile = file(self.listFileName,'w')
            # fix me
            m3uFile.close()
        return

    def __del__(self):
        pass

    def __len__(self):
        return len(self.songsUri)

    def __iter__(self):
        return self.songsUri.__iter__()

    def __getitem__(self, i):
        return self.songsUri[i]

    def getIndex(self, songDir):
        return self.songsUri.index(songDir)
    
    def getCurIndex(self):
        #print 'self.currentName, ', self.currentName
        return self.songsUri.index(self.currentName)

    def setQueue(self):
        self.queue = self.songsUri[:]

    def resetQueue(self):
        self.queue = []

    def appendSong(self, songDir):
        if songDir not in self.songsUri:
            self.songsUri.append(songDir)
            self.queue = self.songsUri[:]
            self.updateListFile()
        else:
            print songDir, ' The file is already in this filelist!'
        return
    
    def setCurrentName(self,currentName):
        currentIndex = self.songsUri.index(currentName)      
        self.currentIndex = currentIndex
        self.currentName = currentName
        self.update_queue()
        return
    
    def update_queue(self):
        currentIndex = self.getCurIndex()
        if currentIndex < 0 or currentIndex >= len(self.songsUri):
            print 'error index!'
            return False
        if (self.repeated):
            if (self.shuffled):
                if self.songsUri[currentIndex] not in self.queue:
                    self.queue= self.songsUri[currentIndex:]
                if len(self.queue) == 1:
		    self.queue = self.songsUri[:]
                self.queue.remove(self.songsUri[currentIndex])
            else:
                if len(self.queue) == 1:
                    self.queue = self.songsUri[:]
                else:
                    self.queue = self.songsUri[currentIndex+1:]
        else:
            if (self.shuffled):
                if self.songsUri[currentIndex] not in self.queue:
		    #for song in self.queue:
			#print 'in queue:', song
                    self.queue = self.songsUri[:]
		if len(self.queue) == 1:
                    self.queue = []
                    print 'end to play'
                    return False
                self.queue.remove(self.songsUri[currentIndex])
            else:
                if self.songsUri[currentIndex] not in self.queue:
                    self.queue= self.songsUri[currentIndex+1:]
                if len(self.queue) == 1:
                    self.queue =[]
                    print 'end to play'
                    return False
                else:
                    self.queue= self.songsUri[currentIndex+1:]
        return True
        
    def removeSong(self, fileName):
	if self.listName == 'allSongList':
		print "can't remove songs in allSongList!\n"		
		return
        self.songsUri.remove(fileName)
        if fileName in self.queue:
            self.queue.remove(fileName)
        self.updateListFile()
        return
    
    #def removeSong(self, index):
        #del self.songsUri[index]
        #if self.songsUri[index] in self.queue:
            #self.queue.remove(self.songsUri[index])
        #self.updateListFile()
        #return

    #insert before    
    def insertSong(self, index, songDir):
        if songDir not in self.songsUri:
            if index <= len(self.songsUri) and index >=0:
                self.songsUri.insert(index, songDir)
            else:
                print 'error index!'
            self.queue = self.songsUri[:]
            self.updateListFile()
        else:
            print 'The file is already in this filelist!'

    def rename(self, newName):
        oldName = self.listName
        self.listName =newName
        #listFile should change to new name!
        str1 = self.listFileName
        str2=str1.replace(oldName,newName)
        os.rename(self.listFileName, str2)
        self.listFileName = str2
        return
    
    def setShuffle(self, shuffle=True):
        self.shuffled = shuffle
        if shuffle:
            self.queue = self.songsUri[:]
	    self.queue.remove(self.songsUri[self.currentIndex])
        else:
            self.queue = self.songsUri[self.currentIndex+1:]
        #self.update_queue()
            
    def setRepeat(self, repeated=True):
        self.repeated = repeated
        #self.update_queue()

    def getNextSong(self, currentIndex):
        
        if currentIndex < 0 or currentIndex >= len(self.songsUri):
            print 'error index!'
            return -1
        
        if (self.repeated):
            if (self.shuffled):
                # repeated and shuffle
                length = len(self.queue)
		if length < 1:
		    return 0
		else:
		    if length == 1:
			newIndex = self.getIndex(self.queue[0])
		    else:
			currentDir = self.queue[random.randint(1,length)-1 ]
			newIndex = self.getIndex(currentDir)
		    return newIndex 
            else:
                # repeated but not shuffle
                newIndex = currentIndex + 1
                if newIndex >= len(self.songsUri):
                    newIndex = 0
                    #currentDir = self.songsUri[newIndex]
                return newIndex 
        else:
            if (self.shuffled):
                # not repeated, but shuffle
                length = len(self.queue)
		if length < 1:
		    return -1
		else:
		    if length == 1:
			newIndex = self.getIndex(self.queue[0])
		    else:
			currentDir = self.queue[random.randint(1,length)-1 ]
			newIndex = self.getIndex(currentDir)
		    return newIndex 
            else:
                # not repeated and not shuffle
		test = rand = random.randint(0,1)
		print test, '*****\n'
                newIndex = currentIndex +1
                if newIndex >= len(self.songsUri):
                    newIndex = -1
                else:
                    currentDir = self.songsUri[newIndex]
		    newIndex = self.getIndex(currentDir)
		return newIndex 
                   
    def getPrevSong(self, currentIndex):
        if currentIndex < 0 or currentIndex >=len(self.songsUri):
            print 'error index!'
            return -1
        
        if (self.repeated):
            if (self.shuffled):
                length = len(self.queue)
		if length < 1:
		    # which one should return
		    return 0
		else:
		    if length == 1:
			newIndex = self.getIndex(self.queue[0])
		    else:
			currentDir = self.queue[random.randint(1,length)-1 ]
			newIndex = self.getIndex(currentDir)
		    return newIndex 
            else:
                newIndex = currentIndex -1
                if newIndex < 0:
                    newIndex = len(self.songsUri)-1
                #currentDir = self.songsUri[newIndex]
                return newIndex
            
        else:
            if (self.shuffled):
                length = len(self.queue)
		if length < 1:
		    return -1
		else:
		    if length == 1:
			newIndex = self.getIndex(self.queue[0])
		    else:
			currentDir = self.queue[random.randint(1,length)-1 ]
			newIndex = self.getIndex(currentDir)
		    return newIndex 
            else:
                newIndex = currentIndex -1
                if newIndex < 0:
                    newIndex = -1
                return newIndex              
                
    def updateListFile(self):
        if os.path.isfile(self.listFileName):
            FileIO.savePlaylist(self.songsUri,self.listFileName,self.ext)
        else:
            print 'no allListFile exist!'         



