#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    ToolBarView.py: Manage Toolbar View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import MediaPlugin

import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string
import pango
class ToolBarView:
    """
    A class which manage toolbar view.
    """

    def __init__(self, app, mode):
        """
        init function
        """
        self.name_list = {'audio':'wm_mm_toolbar_hb', 
                          'video':'wm_vm_toolbar_hb', 
                          'photo':'wm_pm_toolbar_hb',
                          }
        dic = {}
        dic['audio'] = {"on_wm_mm_tb_browse_bn_clicked" : self.return_play_mode,
                     "on_wm_mm_tb_prev_bn_clicked": self.Music_Prev,
                     "on_wm_mm_tb_rewind_bn_clicked": self.Music_Rewind,
                     "on_wm_mm_tb_play_bn_clicked" : self.Music_Play_Pause,
                     "on_wm_mm_tb_stop_bn_clicked" : self.Music_Stop,
                     "on_wm_mm_tb_forward_bn_clicked" : self.Music_Forward,
                     "on_wm_mm_tb_next_bn_clicked" : self.Music_Next,

                     }
        dic['video'] = {"on_wm_vm_tb_browse_bn_clicked" : self.return_play_mode,
                     "on_wm_vm_tb_prev_bn_clicked": self.Video_Prev,
                     "on_wm_vm_tb_rewind_bn_clicked": self.Video_Rewind,
                     "on_wm_vm_tb_play_bn_clicked" : self.Video_Play_Pause,
                     "on_wm_vm_tb_stop_bn_clicked" : self.Video_Stop,
                     "on_wm_vm_tb_forward_bn_clicked" : self.Video_Forward,
                     "on_wm_vm_tb_next_bn_clicked" : self.Video_Next,
                     "on_wm_vm_tb_fs_bn_clicked" : self.Video_FullScreen,
                     }
        dic['photo'] = {"on_wm_pm_tb_browse_bn_clicked" : self.return_play_mode,
                     "on_wm_pm_tb_autoplay_bn_clicked" : self.Photo_Play_Pause,
                     "on_wm_pm_tb_prev_bn_clicked" : self.Photo_Prev,
                     "on_wm_pm_tb_next_bn_clicked" : self.Photo_Next,
                     "on_wm_pm_tb_return_bn_clicked" : self.Photo_Return,
                     "on_wm_pm_tb_rotate_bn_clicked" : self.Photo_Rotate,
                     "on_wm_pm_tb_thumb_size_hs_value_changed": self.Thumbnail_Resize,
                     "on_pm_sort_cb_changed":self.on_pm_sort_cb_changed,
                     "on_pl_to_thumb_bn_clicked" :   self.pl_to_thumb,
                 }

        # init app
        self.app = app  
        
        # plugins
        self.plugins = self.app.plugins
        
        # init three toolbar suites and connect signal and functions
        # init default dir
        self.wTree = {}
        self.last_browse_dir = {}
        self.toolbar = {}
        self.plugin_buttons = {}
        self.is_plugin_loaded = {}
        
        for name in self.name_list.keys():
            self.wTree[name] = gtk.glade.XML(Constant.MediaGladePath,root = self.name_list[name])
            self.wTree[name].signal_autoconnect(dic[name])
            self.toolbar[name] = self.wTree[name].get_widget(self.name_list[name])
            self.last_browse_dir[name] = self.get_default_dir(name)
            self.is_plugin_loaded[name] = False
        
        # buttons
        self.mm_play_pause_button = self.wTree['audio'].get_widget("wm_mm_tb_play_bn")
        self.mm_stop_button = self.wTree['audio'].get_widget("wm_mm_tb_stop_bn")
        self.mm_browse_button = self.wTree['audio'].get_widget("wm_mm_tb_browse_bn")
        self.mm_prev_button = self.wTree['audio'].get_widget("wm_mm_tb_prev_bn")
        self.mm_next_button = self.wTree['audio'].get_widget("wm_mm_tb_next_bn")
	self.mm_rewind_button = self.wTree['audio'].get_widget("wm_mm_tb_rewind_bn")
        self.mm_forward_button = self.wTree['audio'].get_widget("wm_mm_tb_forward_bn")

        self.vm_play_pause_button = self.wTree['video'].get_widget("wm_vm_tb_play_bn")
        self.vm_stop_button = self.wTree['video'].get_widget("wm_vm_tb_stop_bn")
        self.vm_browse_button = self.wTree['video'].get_widget("wm_vm_tb_browse_bn")
        self.vm_prev_button = self.wTree['video'].get_widget("wm_vm_tb_prev_bn")
        self.vm_next_button = self.wTree['video'].get_widget("wm_vm_tb_next_bn")
	self.vm_rewind_button = self.wTree['video'].get_widget("wm_vm_tb_rewind_bn")
        self.vm_forward_button = self.wTree['video'].get_widget("wm_vm_tb_forward_bn")
        self.vm_share_button = self.wTree['video'].get_widget("wm_vm_tb_share_bn")
        self.vm_fullscreen_button = self.wTree['video'].get_widget("wm_vm_tb_fs_bn")

        self.pm_autoplay_button = self.wTree['photo'].get_widget("wm_pm_tb_autoplay_bn")
	self.pm_prev_button = self.wTree['photo'].get_widget("wm_pm_tb_prev_bn")
	self.pm_next_button = self.wTree['photo'].get_widget("wm_pm_tb_next_bn")
	self.pm_return_button = self.wTree['photo'].get_widget("wm_pm_tb_return_bn")
	self.pm_rotate_button = self.wTree['photo'].get_widget("wm_pm_tb_rotate_bn")
        self.pm_share_button = self.wTree['photo'].get_widget("wm_pm_tb_share_bn")
        self.pm_fullscreen_button = self.wTree['photo'].get_widget("wm_pm_tb_fs_bn")
        self.pm_browse_button = self.wTree['photo'].get_widget("wm_pm_tb_browse_bn")
        self.pm_thumb_size_bar = self.wTree['photo'].get_widget("wm_pm_tb_thumb_size_hs")
        self.pm_thumb_size_bar.set_value(7.5)
        self.pm_sort_cb = self.wTree['photo'].get_widget("pm_sort_cb")
        self.pm_pl_to_thumb_bn = self.wTree['photo'].get_widget("pl_to_thumb_bn")
        sort_cm_bg = gtk.gdk.Color(0,0,0,0)
        self.pm_sort_cb.modify_bg(gtk.STATE_NORMAL,sort_cm_bg)
        sort_cm_bg = gtk.gdk.Color(65535,65535,65535,0)
        self.pm_sort_cb.modify_text(gtk.STATE_NORMAL,sort_cm_bg)
        self.pm_sort_cb.modify_fg(gtk.STATE_NORMAL,sort_cm_bg)        
        self.pm_sort_cb.set_active(0)

        #images
	self.music_prev_image = self.wTree['audio'].get_widget("mm_prev_img")
        self.music_prev_image.set_from_file(os.path.join(self.app.image_path,'previous.png'))
        self.music_rewind_image = self.wTree['audio'].get_widget("mm_rewind_img")
        self.music_rewind_image.set_from_file(os.path.join(self.app.image_path,'rewind.png'))
        self.music_play_image = self.wTree['audio'].get_widget("mm_play_img")
        self.music_play_image.set_from_file(os.path.join(self.app.image_path,'mb_media_btn_play.png'))
        self.music_stop_image = self.wTree['audio'].get_widget("mm_stop_img")
        self.music_stop_image.set_from_file(os.path.join(self.app.image_path,'stop.png'))
        self.music_forward_image = self.wTree['audio'].get_widget("mm_forward_img")
        self.music_forward_image.set_from_file(os.path.join(self.app.image_path,'forward.png'))
	self.music_next_image = self.wTree['audio'].get_widget("mm_next_img")
        self.music_next_image.set_from_file(os.path.join(self.app.image_path,'next.png'))
        self.music_browse_image = self.wTree['audio'].get_widget("mm_browse_img")
        self.music_browse_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
	
	self.video_prev_image = self.wTree['video'].get_widget("vm_prev_img")
        self.video_prev_image.set_from_file(os.path.join(self.app.image_path,'previous.png'))
        self.video_rewind_image = self.wTree['video'].get_widget("vm_rewind_img")
        self.video_rewind_image.set_from_file(os.path.join(self.app.image_path,'rewind.png'))
        self.video_play_image = self.wTree['video'].get_widget("vm_play_img")
        self.video_play_image.set_from_file(os.path.join(self.app.image_path,'mb_media_btn_play.png'))
        self.video_stop_image = self.wTree['video'].get_widget("vm_stop_img")
        self.video_stop_image.set_from_file(os.path.join(self.app.image_path,'stop.png'))
        self.video_forward_image = self.wTree['video'].get_widget("vm_forward_img")
        self.video_forward_image.set_from_file(os.path.join(self.app.image_path,'forward.png'))
	self.video_next_image = self.wTree['video'].get_widget("vm_next_img")
        self.video_next_image.set_from_file(os.path.join(self.app.image_path,'next.png'))
        self.video_browse_image = self.wTree['video'].get_widget("vm_browse_img")
        self.video_browse_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
        self.video_fullscreen_image = self.wTree['video'].get_widget("vm_fullscreen_img")
        self.video_fullscreen_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
        self.video_share_image = self.wTree['video'].get_widget("vm_share_img")
        self.video_share_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))

        self.photo_autoplay_image = self.wTree['photo'].get_widget("pm_autoplay_img")
        self.photo_autoplay_image.set_from_file(os.path.join(self.app.image_path,'mb_media_btn_play.png'))
	self.photo_prev_image = self.wTree['photo'].get_widget("pm_prev_img")
        self.photo_prev_image.set_from_file(os.path.join(self.app.image_path,'rewind.png'))
	self.photo_next_image = self.wTree['photo'].get_widget("pm_next_img")
        self.photo_next_image.set_from_file(os.path.join(self.app.image_path,'forward.png'))
	self.photo_return_image = self.wTree['photo'].get_widget("pm_return_img")
	self.photo_return_image.set_from_stock(gtk.STOCK_UNDO, gtk.ICON_SIZE_BUTTON)
	self.photo_rotate_image = self.wTree['photo'].get_widget("pm_rotate_img")
	self.photo_rotate_image.set_from_stock(gtk.STOCK_REFRESH, gtk.ICON_SIZE_BUTTON)
        self.photo_browse_image = self.wTree['photo'].get_widget("pm_browse_img")
        self.photo_browse_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
        self.photo_fullscreen_image = self.wTree['photo'].get_widget("pm_fullscreen_img")
        self.photo_fullscreen_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
        self.photo_share_image = self.wTree['photo'].get_widget("pm_share_img")
        self.photo_share_image.set_from_file(os.path.join(self.app.image_path,'mb_media_browse_btn.png'))
        
        # init current button suites
        self.cur_play_pause_img = self.music_play_image
        
        # for photo playback
        self.photo_playback = self.app.view['photo'].get_photo_playback()
        self.photo_thumbnail = self.app.view['photo'].get_photo_thumbnail()
        self.is_photo_autoplay = False
        
        # filter
        self.file_filter = {}
        self.all_filter = gtk.FileFilter()
        self.all_filter.set_name('All')
        for mode in Constant.MediaPattern.keys():
            self.file_filter[mode] = gtk.FileFilter()
            self.file_filter[mode].set_name(mode)
            for type in Constant.MediaPattern[mode]:
                pattern = '*.' + type
                self.file_filter[mode].add_pattern(pattern)
                self.all_filter.add_pattern(pattern)

        # init mode and toolbar_name    
        self.cur_mode = mode
	
	# init prev and next button state, it's a two element list
	self.prev_next_state = [False, False]
	


        # pack whole toolbar to a VBox
        self.cur_view = gtk.VBox()
        self.cur_toolbar = self.toolbar[mode]
                
        self.init_ui()

    def hide_unused(self):
        #return
        # audio
	self.mm_next_button.hide()
        self.mm_prev_button.hide()
        self.mm_stop_button.hide()	
	    # video
        self.vm_share_button.hide()
        self.vm_fullscreen_button.hide()
	self.vm_prev_button.hide()
        self.vm_next_button.hide()
        self.vm_stop_button.hide()
	    # photo
        self.pm_rotate_button.hide()
        self.pm_share_button.hide()
        self.pm_fullscreen_button.hide()
        self.pm_thumb_size_bar.hide()
        self.pm_sort_cb.hide()

        self.pm_pl_to_thumb_bn.hide()


            

    def init_ui(self):
        self.load_plugins()
        self.cur_view.pack_start(self.cur_toolbar)
        self.update_button(self.cur_mode, None)
            
    def load_plugins(self):
        if self.plugins.get_plugin_count() == 0:
            print 'no plugin found'
            return
        else:
            self.plugin_buttons = self.make_plugin_buttons(self.plugins.get_plugin_list())
        
        self.add_bn_to_toolbar()

    def make_plugin_buttons(self, plugins):
        buttons = {}
        for mode in self.name_list.keys():
            buttons[mode] = []
            for plugin in plugins:
                button = MobilePlugin.PluginButton()
                button.connect_to_plugin(plugin)
                buttons[mode].append(button)
        return buttons

    def add_bn_to_toolbar(self):
        for mode in self.name_list.keys():
            #if mode == 'photo':
            for button in self.plugin_buttons[mode]:
                self.toolbar[mode].pack_end(button, False, False)
        
    def get_plugin_buttons(self):
        return self.plugin_buttons
    

    def add_filter_mode(self, dialog, mode):
        if mode in Constant.MediaType.keys():
            dialog.add_filter(self.file_filter[mode])
        elif mode == 'All':
            dialog.add_filter(self.all_filter)

    def on_file_open(self, button):
        dialog = gtk.FileChooserDialog(action=gtk.FILE_CHOOSER_ACTION_OPEN, parent=self.app.window, title=Constant.MediaString['open_dlg_title'])
        if None != self.last_browse_dir[self.cur_mode] :
            dialog.set_current_folder(self.last_browse_dir[self.cur_mode])

        # filter
        for mode in Constant.MediaType.keys():
            dialog.add_filter(self.file_filter[mode])
        dialog.add_filter(self.all_filter)
        # set default filter
        dialog.set_filter(self.all_filter)

        dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
        dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

        if dialog.run() == gtk.RESPONSE_OK:

            filename = dialog.get_filename()
            print 'open file is :',filename
            if not os.path.isfile(filename):
               GeneralFunc.error_msg('file %s does not exist' % os.path.basename(filename), False)
               dialog.destroy()
               return
               
            if None != GeneralFunc.get_media_type(filename):
                self.last_browse_dir[self.cur_mode] = dialog.get_current_folder()

            filename = 'file://' + filename
            self.open_media_file(filename)

        dialog.destroy()

    def open_uri(self, filename):
        self.open_media_file(filename)

    def return_play_mode(self, button):
        if self.app.cur_playing_mode == "video":
            if self.app.main_notebook.get_current_page() == 1 :
                self.vm_browse_button.set_sensitive(False)
            else:
                self.app.view['video'].update_ui(True)
                self.app.main_notebook.set_current_page(1)
                self.app.view['toolbar'].change_mode('video', self.app.media_type)
                self.app.update_ui()
        elif self.app.cur_playing_mode == "audio":
            self.app.view['audio'].state_current = self.app.view['audio'].state_playback
            self.app.view['audio'].update_ui(True)
            self.app.main_notebook.set_current_page(0)
            self.app.view['toolbar'].change_mode('audio', self.app.media_type)
            self.app.update_ui()
        else:
                pass

    def open_media_file(self, filename):
        root, ext=os.path.splitext(filename)
        self.app.CurrentEng=self.app.EngManag.ChooseEng(ext.replace('.','').lower())
        if not self.app.CurrentEng == 'noneng':
            if not self.app.EngManag.BusyEng == self.app.CurrentEng.GetName():
                self.app.EngManag.BusyEng=self.app.CurrentEng.GetName()
                self.app.service.Stop()
                print 'choosed engine is:',self.app.CurrentEng.GetName()
                self.app.service=self.app.CurrentEng.GetService()
                #if None != GeneralFunc.get_media_type(filename):
                 #   self.last_browse_dir[self.cur_mode] = dialog.get_current_folder()
        else :
            print self.app.CurrentEng
            GeneralFunc.error_msg('file format %s is not supported by any engine' % ext, False)
    
        self.cur_mode = GeneralFunc.get_media_type(filename)
        self.app.cur_playing_mode = self.cur_mode
        # media_type
        if None != self.app.get_mediatype():
            if self.cur_mode != 'photo':
                #self.app.Stop(None)
                pass
            else:
                #stop current service
                pass

        if self.cur_mode != 'photo':
            self.app.set_mediatype(self.cur_mode)

        if self.cur_mode == 'audio':
            if self.app.main_notebook.get_current_page() == 2:
                self.app.view['audio'].update_state_playback()
            elif self.app.main_notebook.get_current_page() == 0:
                self.app.view['audio'].update_state_playlist()
            self.app.setMusicMode(None)
            loadfile = filename
            self.app.Load(self.app.get_mediatype(), loadfile)

        elif self.cur_mode == 'video':
            self.app.view['video'].update_state_playback()
            self.app.setVideoMode(None)
            loadfile = filename
            self.app.Load(self.app.get_mediatype(), loadfile)

        elif self.cur_mode == 'photo':
            filename = filename.replace('file://','')
            print filename
            self.app.view['photo'].update_state_playback()
            self.app.setPhotoMode(None)
            self.app.view['photo'].set_cur_dir(filename)
            self.app.view['photo'].get_photo_playback().DisplayImage(filename)

        # update app ui
        self.app.update_all_ui()

    def get_default_dir(self, mode):
        if mode in Constant.MediaType.keys():
            return os.path.join(Constant.MediaStreamPath, mode)
        else:
            pass

    def get_toolbar_name(self, mode):
        if mode in Constant.MediaType.keys():
            return self.name_list[mode]
        else:
            pass

    def change_mode(self, mode, mediatype):
        self.cur_view.remove(self.cur_toolbar)
        self.cur_mode, self.cur_toolbar = mode, self.toolbar[mode]
        self.cur_view.pack_start(self.cur_toolbar)
        self.cur_view.show_all()
        self.hide_unused()
        self.update_button(mode, mediatype)

    def set_stop_button_state(self, state):
        self.cur_stop_bn.set_sensitive(state)

    def set_play_pause_img(self, image):
        if os.path.isfile(image):
            self.cur_play_pause_img.set_from_file(image)
        else:
            print image, ' not exist'
	    
    def update_button(self, mode, mediatype):
        if mode == mediatype:
            self.set_button_sensitive(mode, True)
        else:
            self.set_button_sensitive(mode, False)
	
        if mode == 'audio':
            self.cur_prev_bn = self.mm_prev_button
	    self.cur_rewind_bn = self.mm_rewind_button
            self.cur_play_bn = self.mm_play_pause_button
            self.cur_stop_bn = self.mm_stop_button
	    self.cur_forward_bn = self.mm_forward_button
            self.cur_next_bn = self.mm_next_button
            self.cur_play_pause_img = self.music_play_image

        elif mode == 'video':
            self.cur_prev_bn = self.vm_prev_button
	    self.cur_rewind_bn = self.vm_rewind_button
            self.cur_play_bn = self.vm_play_pause_button
            self.cur_stop_bn = self.vm_stop_button
	    self.cur_forward_bn = self.vm_forward_button
            self.cur_next_bn = self.vm_next_button
            self.cur_play_pause_img = self.video_play_image
        else:
            pass
	
	pb_mode = self.app.get_pb_mode()
	
	#set button status for playback mode
	if pb_mode == Constant.PB_NORMAL:
	    self.set_forward_image_default(mode)
	    self.set_rewind_image_default(mode)
	
	if pb_mode == Constant.PB_FORWARD:
	    self.set_forward_image_change(mode)
	    self.cur_prev_bn.set_sensitive( False)
	    self.cur_rewind_bn.set_sensitive( False)
	    self.cur_play_bn.set_sensitive( False)
	    self.cur_stop_bn.set_sensitive( False)
	    self.cur_next_bn.set_sensitive( False)
	    self.cur_prev_bn.set_sensitive( False)
	    if self.app.get_mediatype == self.cur_mode:
		self.cur_forward_bn.set_sensitive( True)
	    
	if pb_mode == Constant.PB_REWIND:
	    self.set_rewind_image_change(mode)
	    self.cur_prev_bn.set_sensitive( False)
	    self.cur_play_bn.set_sensitive( False)
	    self.cur_stop_bn.set_sensitive( False)
	    self.cur_forward_bn.set_sensitive( False)
	    self.cur_next_bn.set_sensitive( False)
	    self.cur_prev_bn.set_sensitive( False)
	    if self.app.get_mediatype == self.cur_mode:
		self.cur_rewind_bn.set_sensitive( True )
		
	self.update_prev_next_bn(self.prev_next_state)
            
        self.update_plugin_button(mode)
        
    def set_button_sensitive(self, mode, is_enabled):
	if mode == 'audio':
	    self.mm_prev_button.set_sensitive(is_enabled)
	    self.mm_rewind_button.set_sensitive(is_enabled)
	    self.mm_play_pause_button.set_sensitive(is_enabled)
	    self.mm_stop_button.set_sensitive(is_enabled)
	    self.mm_forward_button.set_sensitive(is_enabled)
	    self.mm_next_button.set_sensitive(is_enabled)
	    self.app.view['audio'].playback_set_seekbar_seekable(is_enabled)
	elif mode == 'video':
	    self.vm_prev_button.set_sensitive(is_enabled)
	    self.vm_rewind_button.set_sensitive(is_enabled)
	    self.vm_play_pause_button.set_sensitive(is_enabled)
	    self.vm_stop_button.set_sensitive(is_enabled)
	    self.vm_forward_button.set_sensitive(is_enabled)
	    self.vm_next_button.set_sensitive(is_enabled)
	    self.app.view['video'].playback_set_seekbar_seekable(is_enabled)
	elif mode == 'photo':
	    pass
	    # self.pm_autoplay_button.set_sensitive(is_enabled)

    def update_plugin_button(self, mode):
        if len(self.plugin_buttons[mode]) != 0:
            for bn in self.plugin_buttons[mode]:
                # None to update plugin buttons with 
                # their current args
                bn.update_args(None)    
		
    def update_prev_next_bn(self, state):
	prev, next = state
	if prev in [True, False] and next in [True, False]:
	    self.mm_prev_button.set_sensitive(prev)
	    self.mm_next_button.set_sensitive(next)
	    
    def set_prev_next_state(self, state):
	if type(state) == type([]):
	    self.prev_next_state = state
	    self.update_button(self.cur_mode, self.app.media_type)
	

                
    # ###################################
    # for both video and audio playback
    # ###################################
    
    def set_media_play_image_change(self):
	self.cur_play_pause_img.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_media_play_image_default(self):
	self.cur_play_pause_img.set_from_file(os.path.join(self.app.image_path,'mb_media_btn_play.png'))
	
    def set_sync_button_sensitive(self, bn, enabled):
	if enabled:
	    self.set_button_sensitive(self.cur_mode, False)
	    bn.set_sensitive(enabled)
	else:
	    self.set_button_sensitive(self.cur_mode, True)
    	pass
    
    def set_rewind_image_default(self, mode):
	if mode == 'video':
	    self.set_video_rewind_image_default()
	elif mode == 'audio':
	    self.set_audio_rewind_image_default()
	    
    def set_rewind_image_change(self, mode):
	if mode == 'video':
	    self.set_video_rewind_image_change()
	elif mode == 'audio':
	    self.set_audio_rewind_image_change()
	    
    def set_forward_image_default(self, mode):
	if mode == 'video':
	    self.set_video_forward_image_default()
	elif mode == 'audio':
	    self.set_audio_forward_image_default()
	    
    def set_forward_image_change(self, mode):
	if mode == 'video':
	    self.set_video_forward_image_change()
	elif mode == 'audio':
	    self.set_audio_forward_image_change()
	
    # ###################################
    # for audio playback
    # ###################################
        
    def Music_Prev(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.view['audio'].play_pl_prev()
            
    def Music_Rewind(self, bn):
	if self.app.get_mediatype() == 'audio':
	    pb_mode = self.app.get_pb_mode()
	    rate = 0
	    if pb_mode == Constant.PB_NORMAL :
		self.app.set_pb_mode(Constant.PB_REWIND)
		rate = Constant.FAST_SPEED
	    else :
		self.app.set_pb_mode(Constant.PB_NORMAL)
		rate = 0
		
	    self.update_button(self.cur_mode, 'audio')
            self.app.Rewind(bn, rate)

    def Music_Play_Pause(self, bn):
        if self.app.get_mediatype() == 'audio':
            cur_pos = self.app.view['audio'].get_sb_value()
            if cur_pos < self.app.media_file_length:
                cur_pos = max(0, int(cur_pos))
                self.app.SetPosition(cur_pos)
            self.app.Play_Pause(bn)

    def Music_Stop(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.Stop(bn) 

    def Music_Forward(self, bn):
	if self.app.get_mediatype() == 'audio':
	    pb_mode = self.app.get_pb_mode()
	    rate = 0
	    if pb_mode == Constant.PB_NORMAL :
		self.app.set_pb_mode(Constant.PB_FORWARD)
		rate = Constant.FAST_SPEED
	    else :
		self.app.set_pb_mode(Constant.PB_NORMAL)
		rate = 0
	    self.update_button(self.cur_mode, 'audio')
            self.app.Forward(bn, rate)
    
    def Music_Next(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.view['audio'].play_pl_next()

    def pl_to_thumb(self, bn):
        if self.app.main_notebook.get_current_page() == 0:
            self.app.setMusicPath(None)
        else:
            self.app.view['audio'].state_current = self.app.view['audio'].state_playlist
            self.app.view['audio'].update_ui(True)
            self.app.main_notebook.set_current_page(0)
            self.change_mode('audio', self.app.media_type)
            self.app.update_ui()

    def set_audio_forward_image_change(self):
	self.music_forward_image.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_audio_forward_image_default(self):
	self.music_forward_image.set_from_file(os.path.join(self.app.image_path,'forward.png'))
  
    def set_audio_rewind_image_change(self):
	self.music_rewind_image.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_audio_rewind_image_default(self):
	self.music_rewind_image.set_from_file(os.path.join(self.app.image_path,'rewind.png'))
	
    # ###################################
    # for video playback and thumbnail
    # ###################################
    def Video_Prev(self, bn):
        if self.app.get_mediatype() == 'video':
    	    pass
            
    def Video_Rewind(self, bn):
	if self.app.get_mediatype() == 'video':
	    pb_mode = self.app.get_pb_mode()
	    rate = 0
	    if pb_mode == Constant.PB_NORMAL :
		self.app.set_pb_mode(Constant.PB_REWIND)
		rate = Constant.FAST_SPEED
	    else :
		self.app.set_pb_mode(Constant.PB_NORMAL)
		rate = 0
		
	    self.update_button(self.cur_mode, 'video')
            self.app.Rewind(bn, rate)

    def Video_Play_Pause(self, bn):
        if self.app.get_mediatype() == 'video':
            cur_pos = self.app.view['video'].get_sb_value()
            if cur_pos < self.app.media_file_length:
                cur_pos = max(0, int(cur_pos))
                self.app.SetPosition(cur_pos)
            self.app.Play_Pause(bn)

    def Video_Stop(self, bn):
        if self.app.get_mediatype() == 'video':
            self.app.Stop(bn)  

    def Video_Forward(self, bn):
        if self.app.get_mediatype() == 'video':
	    pb_mode = self.app.get_pb_mode()
	    rate = 0
	    if pb_mode == Constant.PB_NORMAL :
		self.app.set_pb_mode(Constant.PB_FORWARD)
		rate = Constant.FAST_SPEED
	    else :
		self.app.set_pb_mode(Constant.PB_NORMAL)
		rate = 0
	    self.update_button(self.cur_mode, 'video')
            self.app.Forward(bn, rate)
            
    def Video_Next(self, bn):
        if self.app.get_mediatype() == 'video':
	    pass

    def Video_FullScreen(self, bn):
        pass
        
    def set_video_forward_image_change(self):
	self.video_forward_image.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_video_forward_image_default(self):
	self.video_forward_image.set_from_file(os.path.join(self.app.image_path,'forward.png'))
  
    def set_video_rewind_image_change(self):
	self.video_rewind_image.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_video_rewind_image_default(self):
	self.video_rewind_image.set_from_file(os.path.join(self.app.image_path,'rewind.png'))
  
    # ###################################
    # for photo playback and thumbnail
    # ###################################
    
    def Photo_Play_Pause(self, bn):
        if self.photo_playback.is_autoplay() == False:
            self.photo_playback.autoplay()
        else:
            self.photo_playback.stopAutoplay()
            
    def Photo_Prev(self, bn):
        self.photo_playback.pre()
        pass
    
    def Photo_Next(self, bn):
        self.photo_playback.next()
        pass
       
    def Photo_Return(self, bn):
        self.photo_playback.goThumbnail()
        pass
        
    def Photo_Rotate(self, bn):
        # self.photo_playback.rotate()
        pass
    def Thumbnail_Resize(self,widget):
        
        self.NewThumbnailLevel = widget.get_value()
	if self.NewThumbnailLevel <  3.0:
            print self.NewThumbnailLevel,'*****************'
            self.NewThumbnailLevel = 3.0
        self.photo_thumbnail.SetThumbnailSizeLevel(self.NewThumbnailLevel)
       

    def SetThumbnailResizeBar(self,IsEnbaled):
        if IsEnbaled:
            self.pm_thumb_size_bar.show()
            self.pm_sort_cb.show()
        else:
            self.pm_thumb_size_bar.hide()
            self.pm_sort_cb.hide()   

    def on_pm_sort_cb_changed(self,widget):
        self.photo_thumbnail = self.app.view['photo'].get_photo_thumbnail()
        SortType = widget.get_active()
        print SortType,'ddddddddd'
        self.photo_thumbnail.SetSortType(SortType)
        self.photo_thumbnail.MakeAllImageThumbnail(self.photo_thumbnail.GetCurrentImgDir())

    def set_photo_autoplay_image(self, image):
        if os.path.isfile(image):
            self.photo_autoplay_image.set_from_file(image)
            
    def set_photo_autoplay_image_change(self):
	self.photo_autoplay_image.set_from_file(os.path.join(self.app.image_path,'pause.png'))
	
    def set_photo_autoplay_image_default(self):
	self.photo_autoplay_image.set_from_file(os.path.join(self.app.image_path,'mb_media_btn_play.png'))
	    
    def set_fs_mode(self, on):
        pass
    
    def update_photo_op_buttons(self):
        if self.cur_mode == 'photo':
            self.app.view[self.cur_mode].update_ui(None)
    
    def hide_photo_op_buttons(self):
        for bn in [self.pm_prev_button, self.pm_next_button, self.pm_return_button, self.pm_autoplay_button]:
            bn.hide()
            
    def show_photo_op_buttons(self):
        for bn in [self.pm_prev_button, self.pm_next_button, self.pm_return_button, self.pm_autoplay_button]:
            bn.show()


