/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* other libs */
#include <db.h>
/* local */
#include <libbttracker.h>

#if DB_VERSION_MINOR == 2
#define bdb_stat(x,y,z) stat(x,y,z)
#else
#define bdb_stat(x,y,z) stat(x,NULL,y,z)
#endif

static int btt_tracker_refresh_db_count(btt_tracker* tracker, const char* table, u_int32_t* count, DB* db)
{
 DB_HASH_STAT *hstat = NULL;
 DB_BTREE_STAT *bstat = NULL;
 int ret = 0;
 
 if(tracker->c->flags & BTT_TRACKER_BTREE)
 {
  if((ret = db->bdb_stat(db, &bstat, DB_FAST_STAT)) == 0)
  {
   *count = bstat->bt_nkeys;
   return 1;
  }
  else
  {
   db->err(db, ret, "bt_tracker_refresh_db_count(%s): stat", table);
   return 0;
  }
 }
 else
 {
  if((ret = db->bdb_stat(db, &hstat, 0)) == 0)
  {
   *count = hstat->hash_nkeys;
   return 1;
  }
  else
  {
   db->err(db, ret, "bt_tracker_refresh_db_count(%s): stat", table);
   return 0;
  }
 }
}

int btt_tracker_refresh_stats(btt_tracker* tracker)
{
 if(btt_tracker_refresh_db_count(tracker, "hashes", &(tracker->s->num_hashes), tracker->db.hashes))
  return btt_tracker_refresh_db_count(tracker, "peers", &(tracker->s->num_peers), tracker->db.peers);
 else
  return 0;
}
