#ifndef	BTUTIL_SHA1_H
#define	BTUTIL_SHA1_H

#include <stdint.h>

typedef	unsigned int	bt_sha1_word_t;	/* 32bits unsigned integer */
typedef uint8_t	bt_sha1_byte_t;	/* 8bits unsigned integer */
#define	BITS		8

/* Define the state of SHA-1 algorithm */
typedef struct {
    uint32_t state[5];
    uint32_t count[2];
    unsigned char buffer[64];
} bt_sha1_state;

#define	BT_SHA1_OUTPUT_SIZE	20	/* in bytes */

/* External Functions */

extern void bt_sha1_init(bt_sha1_state* context);
extern void bt_sha1_update(bt_sha1_state* context, uint8_t* data, uint32_t len);
extern void bt_sha1_finish(bt_sha1_byte_t digest[20], bt_sha1_state* context);

static inline void BT_SHA1(const uint8_t* p, uint32_t len, uint8_t* h) {
    bt_sha1_state pms;
    bt_sha1_init( &pms );
    bt_sha1_update( &pms, (bt_sha1_byte_t *) p, len );
    bt_sha1_finish( (bt_sha1_byte_t *) h, &pms);
}

    
#ifdef	__cplusplus
}
#endif

#endif
