#ifndef _SQLPARSE_DATA_H
#define _SQLPARSE_DATA_H
#include "sqlparse.h"

static const char* operators2[] = {
    "!!",
    "!<",
    "!=",
    "!>",
    "!~",
    "%=",
    "&&",
    "&=",
    "*=",
    "+=",
    "-=",
    "/=",
    ":=",
    "<<",
    "<=",
    "<>",
    "<@",
    ">=",
    ">>",
    "@>",
    "^=",
    "|/",
    "|=",
    "||",
    "~*",
};
static const size_t operators2_sz = 25;

static const keyword_t sql_keywords[] = {
    {"ABS", 'f'},
    {"ACCESSIBLE", 'k'},
    {"ACOS", 'f'},
    {"ADD", 'k'},
    {"ADDDATE", 'f'},
    {"ADDTIME", 'f'},
    {"AES_DECRYPT", 'f'},
    {"AES_ENCRYPT", 'f'},
    {"AGAINST", 'k'},
    {"AGE", 'f'},
    {"ALL_USERS", 'k'},
    {"ALTER", 'k'},
    {"ANALYZE", 'k'},
    {"AND", '&'},
    {"APPLOCK_MODE", 'f'},
    {"APPLOCK_TEST", 'f'},
    {"APP_NAME", 'f'},
    {"ARRAY_AGG", 'f'},
    {"ARRAY_CAT", 'f'},
    {"ARRAY_DIM", 'f'},
    {"ARRAY_FILL", 'f'},
    {"ARRAY_LENGTH", 'f'},
    {"ARRAY_LOWER", 'f'},
    {"ARRAY_NDIMS", 'f'},
    {"ARRAY_PREPEND", 'f'},
    {"ARRAY_TO_JSON", 'f'},
    {"ARRAY_TO_STRING", 'f'},
    {"ARRAY_UPPER", 'f'},
    {"AS", 'k'},
    {"ASC", 'k'},
    {"ASCII", 'f'},
    {"ASENSITIVE", 'k'},
    {"ASIN", 'f'},
    {"ASSEMBLYPROPERTY", 'f'},
    {"ASYMKEY_ID", 'f'},
    {"ATAN", 'f'},
    {"ATAN2", 'f'},
    {"AVG", 'f'},
    {"BEFORE", 'k'},
    {"BEGIN", 'k'},
    {"BENCHMARK", 'f'},
    {"BETWEEN", 'k'},
    {"BIGINT", 'k'},
    {"BIN", 'f'},
    {"BINARY", 'k'},
    {"BINARY_DOUBLE_INFINITY", '1'},
    {"BINARY_DOUBLE_NAN", '1'},
    {"BINARY_FLOAT_INFINITY", '1'},
    {"BINARY_FLOAT_NAN", '1'},
    {"BINBINARY", 'f'},
    {"BIT_AND", 'f'},
    {"BIT_COUNT", 'f'},
    {"BIT_LENGTH", 'f'},
    {"BIT_OR", 'f'},
    {"BIT_XOR", 'f'},
    {"BLOB", 'k'},
    {"BOOLEAN", 'k'},
    {"BOOL_AND", 'f'},
    {"BOOL_OR", 'f'},
    {"BOTH", 'k'},
    {"BTRIM", 'f'},
    {"BY", 'n'},
    {"CALL", 'k'},
    {"CASCADE", 'k'},
    {"CASE", 'o'},
    {"CAST", 'f'},
    {"CBOOL", 'f'},
    {"CBRT", 'f'},
    {"CBYTE", 'f'},
    {"CCUR", 'f'},
    {"CDATE", 'f'},
    {"CDBL", 'f'},
    {"CEIL", 'f'},
    {"CEILING", 'f'},
    {"CERTENCODED", 'f'},
    {"CERTPRIVATEKEY", 'f'},
    {"CERT_ID", 'f'},
    {"CERT_PROPERTY", 'f'},
    {"CHANGE", 'k'},
    {"CHAR", 'f'},
    {"CHARACTER", 'k'},
    {"CHARACTER_LENGTH", 'f'},
    {"CHARINDEX", 'f'},
    {"CHARSET", 'f'},
    {"CHAR_LENGTH", 'f'},
    {"CHDIR", 'f'},
    {"CHDRIVE", 'f'},
    {"CHECK", 'k'},
    {"CHECKSUM_AGG", 'f'},
    {"CHOOSE", 'f'},
    {"CHR", 'f'},
    {"CINT", 'f'},
    {"CLNG", 'f'},
    {"CLOCK_TIMESTAMP", 'f'},
    {"COALESCE", 'k'},
    {"COERCIBILITY", 'f'},
    {"COLLATE", 'k'},
    {"COLLATION", 'f'},
    {"COLLATIONPROPERTY", 'f'},
    {"COLUMN", 'k'},
    {"COLUMNPROPERTY", 'f'},
    {"COLUMNS_UPDATED", 'f'},
    {"COL_LENGTH", 'f'},
    {"COL_NAME", 'f'},
    {"COMPRESS", 'f'},
    {"CONCAT", 'f'},
    {"CONCAT_WS", 'f'},
    {"CONDITION", 'k'},
    {"CONNECTION_ID", 'f'},
    {"CONSTRAINT", 'k'},
    {"CONTINUE", 'k'},
    {"CONV", 'f'},
    {"CONVERT", 'f'},
    {"CONVERT_FROM", 'f'},
    {"CONVERT_TO", 'f'},
    {"CONVERT_TZ", 'f'},
    {"COS", 'f'},
    {"COT", 'f'},
    {"COUNT", 'f'},
    {"COUNT_BIG", 'k'},
    {"CRC32", 'f'},
    {"CREATE", 'k'},
    {"CSNG", 'f'},
    {"CTXSYS.DRITHSX.SN", 'f'},
    {"CUME_DIST", 'f'},
    {"CURDATE", 'f'},
    {"CURDIR", 'f'},
    {"CURRENTUSER", 'f'},
    {"CURRENT_DATABASE", 'f'},
    {"CURRENT_DATE", 'k'},
    {"CURRENT_QUERY", 'f'},
    {"CURRENT_SCHEMA", 'f'},
    {"CURRENT_SCHEMAS", 'f'},
    {"CURRENT_SETTING", 'p'},
    {"CURRENT_TIME", 'k'},
    {"CURRENT_TIMESTAMP", 'k'},
    {"CURRENT_USER", 'k'},
    {"CURRVAL", 'f'},
    {"CURSOR", 'k'},
    {"CURSOR_STATUS", 'f'},
    {"CURTIME", 'f'},
    {"CVAR", 'f'},
    {"DATABASE", 'k'},
    {"DATABASEPROPERTYEX", 'f'},
    {"DATABASES", 'k'},
    {"DATABASE_PRINCIPAL_ID", 'f'},
    {"DATALENGTH", 'f'},
    {"DATE", 'f'},
    {"DATEADD", 'f'},
    {"DATEDIFF", 'f'},
    {"DATEFROMPARTS", 'f'},
    {"DATENAME", 'f'},
    {"DATEPART", 'f'},
    {"DATESERIAL", 'f'},
    {"DATETIME2FROMPARTS", 'f'},
    {"DATETIMEFROMPARTS", 'f'},
    {"DATETIMEOFFSETFROMPARTS", 'f'},
    {"DATEVALUE", 'f'},
    {"DATE_ADD", 'f'},
    {"DATE_FORMAT", 'f'},
    {"DATE_PART", 'f'},
    {"DATE_SUB", 'f'},
    {"DATE_TRUNC", 'f'},
    {"DAVG", 'f'},
    {"DAY", 'f'},
    {"DAYNAME", 'f'},
    {"DAYOFMONTH", 'f'},
    {"DAYOFWEEK", 'f'},
    {"DAYOFYEAR", 'f'},
    {"DAY_HOUR", 'k'},
    {"DAY_MICROSECOND", 'k'},
    {"DAY_MINUTE", 'k'},
    {"DAY_SECOND", 'k'},
    {"DBMS_PIPE.RECEIVE_MESSAGE", 'f'},
    {"DB_ID", 'f'},
    {"DB_NAME", 'f'},
    {"DCOUNT", 'f'},
    {"DEC", 'k'},
    {"DECIMAL", 'k'},
    {"DECLARE", 'k'},
    {"DECODE", 'f'},
    {"DECRYPTBYASMKEY", 'f'},
    {"DECRYPTBYCERT", 'f'},
    {"DECRYPTBYKEY", 'f'},
    {"DECRYPTBYKEYAUTOCERT", 'f'},
    {"DECRYPTBYPASSPHRASE", 'f'},
    {"DEFAULT", 'k'},
    {"DEGREES", 'f'},
    {"DELAY", 'k'},
    {"DELAYED", 'k'},
    {"DELETE", 'k'},
    {"DENSE_RANK", 'f'},
    {"DESC", 'k'},
    {"DESCRIBE", 'k'},
    {"DES_DECRYPT", 'f'},
    {"DES_ENCRYPT", 'f'},
    {"DETERMINISTIC", 'k'},
    {"DFIRST", 'f'},
    {"DIFFERENCE", 'f'},
    {"DISTINCROW", 'k'},
    {"DISTINCT", 'k'},
    {"DIV", 'o'},
    {"DLAST", 'f'},
    {"DLOOKUP", 'f'},
    {"DMAX", 'f'},
    {"DMIN", 'f'},
    {"DROP", 'k'},
    {"DSUM", 'f'},
    {"DUAL", 'k'},
    {"EACH", 'k'},
    {"ELSE", 'k'},
    {"ELSEIF", 'k'},
    {"ELT", 'f'},
    {"ENCLOSED", 'k'},
    {"ENCODE", 'f'},
    {"ENCRYPT", 'f'},
    {"ENCRYPTBYASMKEY", 'f'},
    {"ENCRYPTBYCERT", 'f'},
    {"ENCRYPTBYKEY", 'f'},
    {"ENCRYPTBYPASSPHRASE", 'f'},
    {"ENUM_FIRST", 'f'},
    {"ENUM_LAST", 'f'},
    {"ENUM_RANGE", 'f'},
    {"EOMONTH", 'f'},
    {"ESCAPED", 'k'},
    {"EVENTDATA", 'f'},
    {"EXEC", 'k'},
    {"EXECUTE", 'k'},
    {"EXISTS", 'k'},
    {"EXIT", 'k'},
    {"EXP", 'f'},
    {"EXPLAIN", 'k'},
    {"EXPORT_SET", 'f'},
    {"EXTRACT", 'f'},
    {"EXTRACTVALUE", 'f'},
    {"EXTRACT_VALUE", 'f'},
    {"FALSE", '1'},
    {"FETCH", 'k'},
    {"FIELD", 'f'},
    {"FILEDATETIME", 'f'},
    {"FILEGROUPPROPERTY", 'f'},
    {"FILEGROUP_ID", 'f'},
    {"FILEGROUP_NAME", 'f'},
    {"FILELEN", 'f'},
    {"FILEPROPERTY", 'f'},
    {"FILE_ID", 'f'},
    {"FILE_IDEX", 'f'},
    {"FILE_NAME", 'f'},
    {"FIND_IN_SET", 'f'},
    {"FIRST_VALUE", 'f'},
    {"FLOOR", 'f'},
    {"FN_VIRTUALFILESTATS", 'f'},
    {"FOR", 'n'},
    {"FORCE", 'k'},
    {"FOREIGN", 'k'},
    {"FORMAT", 'f'},
    {"FOUND_ROWS", 'f'},
    {"FROM", 'k'},
    {"FROM_DAYS", 'f'},
    {"FROM_UNIXTIME", 'f'},
    {"FULLTEXT", 'k'},
    {"FULLTEXTCATALOGPROPERTY", 'f'},
    {"FULLTEXTSERVICEPROPERTY", 'f'},
    {"GENERATE_SERIES", 'f'},
    {"GENERATE_SUBSCRIPTS", 'f'},
    {"GETATTR", 'f'},
    {"GETDATE", 'f'},
    {"GETUTCDATE", 'f'},
    {"GET_BIT", 'f'},
    {"GET_BYTE", 'f'},
    {"GET_FORMAT", 'f'},
    {"GET_LOCK", 'f'},
    {"GOTO", 'k'},
    {"GRANT", 'k'},
    {"GREATEST", 'f'},
    {"GROUP", 'n'},
    {"GROUPING", 'f'},
    {"GROUPING_ID", 'f'},
    {"GROUP_CONCAT", 'f'},
    {"HASHBYTES", 'f'},
    {"HAS_PERMS_BY_NAME", 'f'},
    {"HAVING", 'k'},
    {"HEX", 'f'},
    {"HIGH_PRIORITY", 'k'},
    {"HOST_NAME", 'f'},
    {"HOUR", 'f'},
    {"HOUR_MICROSECOND", 'k'},
    {"HOUR_MINUTE", 'k'},
    {"HOUR_SECOND", 'k'},
    {"IDENTIFY", 'f'},
    {"IDENT_CURRENT", 'f'},
    {"IDENT_INCR", 'f'},
    {"IDENT_SEED", 'f'},
    {"IF", 'k'},
    {"IFF", 'f'},
    {"IFNULL", 'f'},
    {"IGNORE", 'k'},
    {"IIF", 'f'},
    {"IN", 'n'},
    {"INDEX", 'k'},
    {"INDEXKEY_PROPERTY", 'f'},
    {"INDEXPROPERTY", 'f'},
    {"INDEX_COL", 'f'},
    {"INET_ATON", 'f'},
    {"INET_NTOA", 'f'},
    {"INFILE", 'k'},
    {"INITCAP", 'f'},
    {"INNER", 'k'},
    {"INOUT", 'k'},
    {"INSENSITIVE", 'k'},
    {"INSERT", 'k'},
    {"INSTR", 'f'},
    {"INSTRREV", 'f'},
    {"INT", 'k'},
    {"INT1", 'k'},
    {"INT2", 'k'},
    {"INT3", 'k'},
    {"INT4", 'k'},
    {"INT8", 'k'},
    {"INTEGER", 'k'},
    {"INTERVAL", 'k'},
    {"INTO", 'k'},
    {"IS", 'o'},
    {"ISDATE", 'f'},
    {"ISEMPTY", 'f'},
    {"ISFINITE", 'f'},
    {"ISNULL", 'f'},
    {"ISNUMERIC", 'f'},
    {"IS_FREE_LOCK", 'f'},
    {"IS_MEMBER", 'f'},
    {"IS_OBJECTSIGNED", 'f'},
    {"IS_ROLEMEMBER", 'f'},
    {"IS_SRVROLEMEMBER", 'f'},
    {"IS_USED_LOCK", 'f'},
    {"ITERATE", 'k'},
    {"JOIN", 'k'},
    {"JUSTIFY_DAYS", 'f'},
    {"JUSTIFY_HOURS", 'f'},
    {"JUSTIFY_INTERVAL", 'f'},
    {"KEYS", 'k'},
    {"KEY_GUID", 'f'},
    {"KEY_ID", 'f'},
    {"KILL", 'k'},
    {"LAG", 'f'},
    {"LASTVAL", 'f'},
    {"LAST_INSERT_ID", 'f'},
    {"LAST_VALUE", 'f'},
    {"LCASE", 'f'},
    {"LEAD", 'f'},
    {"LEADING", 'k'},
    {"LEAST", 'f'},
    {"LEAVE", 'k'},
    {"LEFT", 'n'},
    {"LENGTH", 'f'},
    {"LIKE", 'o'},
    {"LIMIT", 'k'},
    {"LINEAR", 'k'},
    {"LINES", 'k'},
    {"LN", 'f'},
    {"LOAD", 'k'},
    {"LOAD_FILE", 'f'},
    {"LOCALTIME", 'k'},
    {"LOCALTIMESTAMP", 'k'},
    {"LOCATE", 'f'},
    {"LOCK", 'n'},
    {"LOG", 'f'},
    {"LOG10", 'f'},
    {"LOG2", 'f'},
    {"LONGBLOB", 'k'},
    {"LONGTEXT", 'k'},
    {"LOOP", 'k'},
    {"LOWER", 'f'},
    {"LOWER_INC", 'f'},
    {"LOWER_INF", 'f'},
    {"LOW_PRIORITY", 'k'},
    {"LPAD", 'f'},
    {"LTRIM", 'f'},
    {"MAKEDATE", 'f'},
    {"MAKE_SET", 'f'},
    {"MASKLEN", 'f'},
    {"MASTER_BIND", 'k'},
    {"MASTER_POS_WAIT", 'f'},
    {"MASTER_SSL_VERIFY_SERVER_CERT", 'k'},
    {"MATCH", 'k'},
    {"MAX", 'f'},
    {"MAXVALUE", 'k'},
    {"MD5", 'f'},
    {"MEDIUMBLOB", 'k'},
    {"MEDIUMINT", 'k'},
    {"MEDIUMTEXT", 'k'},
    {"MERGE", 'k'},
    {"MICROSECOND", 'f'},
    {"MID", 'f'},
    {"MIDDLEINT", 'k'},
    {"MIN", 'f'},
    {"MINUTE", 'f'},
    {"MINUTE_MICROSECOND", 'k'},
    {"MINUTE_SECOND", 'k'},
    {"MKDIR", 'f'},
    {"MOD", 'o'},
    {"MODE", 'n'},
    {"MODIFIES", 'k'},
    {"MONTH", 'f'},
    {"MONTHNAME", 'f'},
    {"NAME_CONST", 'f'},
    {"NETMASK", 'f'},
    {"NEXTVAL", 'f'},
    {"NOT", 'o'},
    {"NOW", 'f'},
    {"NO_WRITE_TO_BINLOG", 'k'},
    {"NTH_VALUE", 'f'},
    {"NTILE", 'f'},
    {"NULL", '1'},
    {"NULLIF", 'f'},
    {"NUMERIC", 'k'},
    {"NZ", 'f'},
    {"OBJECTPROPERTY", 'f'},
    {"OBJECTPROPERTYEX", 'f'},
    {"OBJECT_DEFINITION", 'f'},
    {"OBJECT_ID", 'f'},
    {"OBJECT_NAME", 'f'},
    {"OBJECT_SCHEMA_NAME", 'f'},
    {"OCT", 'f'},
    {"OCTET_LENGTH", 'f'},
    {"OFFSET", 'k'},
    {"OLD_PASSWORD", 'f'},
    {"ONE_SHOT", 'k'},
    {"OPEN", 'k'},
    {"OPENDATASOURCE", 'f'},
    {"OPENQUERY", 'f'},
    {"OPENROWSET", 'f'},
    {"OPENXML", 'f'},
    {"OPTIMIZE", 'k'},
    {"OPTION", 'k'},
    {"OPTIONALLY", 'k'},
    {"OR", '&'},
    {"ORD", 'f'},
    {"ORDER", 'n'},
    {"ORIGINAL_DB_NAME", 'f'},
    {"ORIGINAL_LOGIN", 'f'},
    {"OUT", 'k'},
    {"OUTFILE", 'k'},
    {"OVERLAPS", 'f'},
    {"OVERLAY", 'f'},
    {"OWN3D", 'k'},
    {"PARSENAME", 'f'},
    {"PARTITION", 'k'},
    {"PASSWORD", 'k'},
    {"PATHINDEX", 'f'},
    {"PATINDEX", 'f'},
    {"PERCENTILE_COUNT", 'f'},
    {"PERCENTILE_DISC", 'f'},
    {"PERCENTILE_RANK", 'f'},
    {"PERCENT_RANK", 'f'},
    {"PERIOD_ADD", 'f'},
    {"PERIOD_DIFF", 'f'},
    {"PERMISSIONS", 'f'},
    {"PG_ADVISORY_LOCK", 'f'},
    {"PG_BACKEND_PID", 'f'},
    {"PG_CANCEL_BACKEND", 'f'},
    {"PG_CLIENT_ENCODING", 'f'},
    {"PG_CONF_LOAD_TIME", 'f'},
    {"PG_CREATE_RESTORE_POINT", 'f'},
    {"PG_HAS_ROLE", 'f'},
    {"PG_IS_IN_RECOVERY", 'f'},
    {"PG_IS_OTHER_TEMP_SCHEMA", 'f'},
    {"PG_LISTENING_CHANNELS", 'f'},
    {"PG_LS_DIR", 'f'},
    {"PG_MY_TEMP_SCHEMA", 'f'},
    {"PG_POSTMASTER_START_TIME", 'f'},
    {"PG_READ_BINARY_FILE", 'f'},
    {"PG_READ_FILE", 'f'},
    {"PG_RELOAD_CONF", 'f'},
    {"PG_ROTATE_LOGFILE", 'f'},
    {"PG_SLEEP", 'f'},
    {"PG_START_BACKUP", 'f'},
    {"PG_STAT_FILE", 'f'},
    {"PG_STOP_BACKUP", 'f'},
    {"PG_SWITCH_XLOG", 'f'},
    {"PG_TERMINATE_BACKEND", 'f'},
    {"PG_TRIGGER_DEPTH", 'f'},
    {"PI", 'f'},
    {"POSITION", 'f'},
    {"POW", 'f'},
    {"POWER", 'f'},
    {"PRECISION", 'k'},
    {"PRIMARY", 'k'},
    {"PROCEDURE", 'k'},
    {"PUBLISHINGSERVERNAME", 'f'},
    {"PURGE", 'k'},
    {"PWDCOMPARE", 'f'},
    {"PWDENCRYPT", 'f'},
    {"QUARTER", 'f'},
    {"QUOTE", 'f'},
    {"QUOTENAME", 'f'},
    {"QUOTE_IDENT", 'f'},
    {"QUOTE_LITERAL", 'f'},
    {"QUOTE_NULLABLE", 'f'},
    {"RADIANS", 'f'},
    {"RAND", 'f'},
    {"RANDOM", 'f'},
    {"RANDOMBLOB", 'f'},
    {"RANGE", 'k'},
    {"RANK", 'f'},
    {"READ", 'k'},
    {"READS", 'k'},
    {"READ_WRITE", 'k'},
    {"REAL", 'n'},
    {"REFERENCES", 'k'},
    {"REGEXP", 'o'},
    {"REGEXP_MATCHES", 'f'},
    {"REGEXP_REPLACE", 'f'},
    {"REGEXP_SPLIT_TO_ARRAY", 'f'},
    {"REGEXP_SPLIT_TO_TABLE", 'f'},
    {"RELEASE", 'k'},
    {"RELEASE_LOCK", 'f'},
    {"RENAME", 'k'},
    {"REPEAT", 'k'},
    {"REPLACE", 'k'},
    {"REPLICATE", 'f'},
    {"REQUIRE", 'k'},
    {"RESIGNAL", 'k'},
    {"RESTRICT", 'k'},
    {"RETURN", 'k'},
    {"REVERSE", 'f'},
    {"REVOKE", 'k'},
    {"RIGHT", 'n'},
    {"RLIKE", 'o'},
    {"ROUND", 'f'},
    {"ROW", 'f'},
    {"ROW_COUNT", 'f'},
    {"ROW_NUMBER", 'f'},
    {"ROW_TO_JSON", 'f'},
    {"RPAD", 'f'},
    {"RTRIM", 'f'},
    {"SCHAMA_NAME", 'f'},
    {"SCHEMA", 'k'},
    {"SCHEMAS", 'k'},
    {"SCHEMA_ID", 'f'},
    {"SCOPE_IDENTITY", 'f'},
    {"SECOND_MICROSECOND", 'k'},
    {"SEC_TO_TIME", 'f'},
    {"SELECT", 'k'},
    {"SENSITIVE", 'k'},
    {"SEPARATOR", 'k'},
    {"SESSION_USER", 'f'},
    {"SET", 'k'},
    {"SETATTR", 'f'},
    {"SETSEED", 'f'},
    {"SETVAL", 'f'},
    {"SET_BIT", 'f'},
    {"SET_BYTE", 'f'},
    {"SET_CONFIG", 'f'},
    {"SET_MASKLEN", 'f'},
    {"SHA", 'f'},
    {"SHA1", 'f'},
    {"SHA2", 'f'},
    {"SHOW", 'n'},
    {"SHUTDOWN", 'k'},
    {"SIGN", 'f'},
    {"SIGNAL", 'k'},
    {"SIGNBYASMKEY", 'f'},
    {"SIGNBYCERT", 'f'},
    {"SIMILAR", 'k'},
    {"SIN", 'f'},
    {"SLEEP", 'f'},
    {"SMALLDATETIMEFROMPARTS", 'f'},
    {"SMALLINT", 'k'},
    {"SOUNDEX", 'f'},
    {"SOUNDS", 'o'},
    {"SPACE", 'f'},
    {"SPATIAL", 'k'},
    {"SPECIFIC", 'k'},
    {"SPLIT_PART", 'f'},
    {"SQL", 'k'},
    {"SQLEXCEPTION", 'k'},
    {"SQLSTATE", 'k'},
    {"SQLWARNING", 'k'},
    {"SQL_BIG_RESULT", 'k'},
    {"SQL_CALC_FOUND_ROWS", 'k'},
    {"SQL_SMALL_RESULT", 'k'},
    {"SQL_VARIANT_PROPERTY", 'f'},
    {"SQRT", 'f'},
    {"SSL", 'k'},
    {"STARTING", 'k'},
    {"STATEMENT_TIMESTAMP", 'f'},
    {"STATS_DATE", 'f'},
    {"STDDEV", 'p'},
    {"STDDEV_POP", 'f'},
    {"STDDEV_SAMP", 'f'},
    {"STRAIGHT_JOIN", 'k'},
    {"STRCMP", 'f'},
    {"STRCONV", 'f'},
    {"STRING_AGG", 'f'},
    {"STRING_TO_ARRAY", 'f'},
    {"STRPOS", 'f'},
    {"STR_TO_DATE", 'f'},
    {"STUFF", 'f'},
    {"SUBDATE", 'f'},
    {"SUBSTR", 'f'},
    {"SUBSTRING", 'f'},
    {"SUBSTRING_INDEX", 'f'},
    {"SUBTIME", 'f'},
    {"SUM", 'f'},
    {"SUSER_ID", 'f'},
    {"SUSER_NAME", 'f'},
    {"SUSER_SID", 'f'},
    {"SUSER_SNAME", 'f'},
    {"SWITCHOFFET", 'f'},
    {"SYS.FN_BUILTIN_PERMISSIONS", 'f'},
    {"SYS.FN_GET_AUDIT_FILE", 'f'},
    {"SYS.FN_MY_PERMISSIONS", 'f'},
    {"SYS.STRAGG", 'f'},
    {"SYSCOLUMNS", 'k'},
    {"SYSDATE", 'f'},
    {"SYSDATETIME", 'f'},
    {"SYSDATETIMEOFFSET", 'f'},
    {"SYSOBJECTS", 'k'},
    {"SYSTEM_USER", 'f'},
    {"SYSUSERS", 'k'},
    {"SYSUTCDATETME", 'f'},
    {"TABLE", 'k'},
    {"TAN", 'f'},
    {"TERMINATED", 'k'},
    {"TERTIARY_WEIGHTS", 'f'},
    {"TEXTPTR", 'f'},
    {"TEXTVALID", 'f'},
    {"THEN", 'k'},
    {"TIME", 'k'},
    {"TIMEDIFF", 'f'},
    {"TIMEFROMPARTS", 'f'},
    {"TIMEOFDAY", 'f'},
    {"TIMESERIAL", 'f'},
    {"TIMESTAMP", 'f'},
    {"TIMESTAMPADD", 'f'},
    {"TIMEVALUE", 'f'},
    {"TIME_FORMAT", 'f'},
    {"TIME_TO_SEC", 'f'},
    {"TINYBLOB", 'k'},
    {"TINYINT", 'k'},
    {"TINYTEXT", 'k'},
    {"TODATETIMEOFFSET", 'f'},
    {"TOP", 'k'},
    {"TO_ASCII", 'f'},
    {"TO_CHAR", 'f'},
    {"TO_DATE", 'f'},
    {"TO_DAYS", 'f'},
    {"TO_HEX", 'f'},
    {"TO_NUMBER", 'f'},
    {"TO_SECONDS", 'f'},
    {"TO_TIMESTAMP", 'f'},
    {"TRAILING", 'n'},
    {"TRANSACTION_TIMESTAMP", 'f'},
    {"TRANSLATE", 'f'},
    {"TRIGGER", 'k'},
    {"TRIGGER_NESTLEVEL", 'f'},
    {"TRIM", 'f'},
    {"TRUE", '1'},
    {"TRUNC", 'f'},
    {"TRUNCATE", 'f'},
    {"TRY_CAST", 'f'},
    {"TRY_CONVERT", 'f'},
    {"TRY_PARSE", 'f'},
    {"TYPEPROPERTY", 'f'},
    {"TYPE_ID", 'f'},
    {"TYPE_NAME", 'f'},
    {"UCASE", 'f'},
    {"UNCOMPRESS", 'f'},
    {"UNCOMPRESS_LENGTH", 'f'},
    {"UNDO", 'k'},
    {"UNHEX", 'f'},
    {"UNION", 'U'},
    {"UNIQUE", 'n'},
    {"UNIX_TIMESTAMP", 'f'},
    {"UNI_ON", 'U'},
    {"UNKNOWN", 'k'},
    {"UNLOCK", 'k'},
    {"UNNEST", 'f'},
    {"UNSIGNED", 'k'},
    {"UPDATE", 'k'},
    {"UPDATEXML", 'f'},
    {"UPPER", 'f'},
    {"UPPER_INC", 'f'},
    {"UPPER_INF", 'f'},
    {"USAGE", 'k'},
    {"USE", 'k'},
    {"USER_ID", 'n'},
    {"USER_NAME", 'f'},
    {"USING", 'f'},
    {"UTC_DATE", 'k'},
    {"UTC_TIME", 'k'},
    {"UTC_TIMESTAMP", 'k'},
    {"UTL_INADDR.GET_HOST_ADDRESS", 'f'},
    {"UUID", 'f'},
    {"UUID_SHORT", 'f'},
    {"VALUES", 'k'},
    {"VAR", 'f'},
    {"VARBINARY", 'k'},
    {"VARCHAR", 'k'},
    {"VARCHARACTER", 'k'},
    {"VARIANCE", 'f'},
    {"VARP", 'f'},
    {"VARYING", 'k'},
    {"VAR_POP", 'f'},
    {"VAR_SAMP", 'f'},
    {"VERIFYSIGNEDBYASMKEY", 'f'},
    {"VERIFYSIGNEDBYCERT", 'f'},
    {"VERSION", 'f'},
    {"WAITFOR", 'k'},
    {"WEEK", 'f'},
    {"WEEKDAY", 'f'},
    {"WEEKDAYNAME", 'f'},
    {"WEEKOFYEAR", 'f'},
    {"WHEN", 'k'},
    {"WHERE", 'k'},
    {"WHILE", 'k'},
    {"WIDTH_BUCKET", 'f'},
    {"WITH", 'k'},
    {"XMLAGG", 'f'},
    {"XMLCOMMENT", 'f'},
    {"XMLCONCAT", 'f'},
    {"XMLELEMENT", 'f'},
    {"XMLEXISTS", 'f'},
    {"XMLFOREST", 'f'},
    {"XMLFORMAT", 'f'},
    {"XMLPI", 'f'},
    {"XMLROOT", 'f'},
    {"XMLTYPE", 'f'},
    {"XML_IS_WELL_FORMED", 'f'},
    {"XOR", 'o'},
    {"XPATH", 'f'},
    {"XPATH_EXISTS", 'f'},
    {"XP_EXECRESULTSET", 'k'},
    {"YEAR", 'f'},
    {"YEARWEEK", 'f'},
    {"YEAR_MONTH", 'k'},
    {"ZEROFILL", 'k'},
};
static const size_t sql_keywords_sz = 737;
static const char* multikeywords_start[] = {
    "ALTER",
    "AT",
    "AT TIME",
    "CROSS",
    "FULL",
    "GROUP",
    "IN",
    "IN BOOLEAN",
    "INTERSECT",
    "IS",
    "IS DISTINCT",
    "IS NOT",
    "LEFT",
    "LOCK",
    "NATURAL",
    "NEXT",
    "NEXT VALUE",
    "NOT",
    "NOT SIMILAR",
    "ORDER",
    "OWN3D",
    "READ",
    "RIGHT",
    "SELECT",
    "SIMILAR",
    "SOUNDS",
    "UNION",
};
static const size_t multikeywords_start_sz = 27;
static const keyword_t multikeywords[] = {
    {"ALTER DOMAIN", 'k'},
    {"ALTER TABLE", 'k'},
    {"AT TIME", 'n'},
    {"AT TIME ZONE", 'k'},
    {"CROSS JOIN", 'k'},
    {"FULL OUTER", 'k'},
    {"GROUP BY", 'B'},
    {"IN BOOLEAN", 'n'},
    {"IN BOOLEAN MODE", 'k'},
    {"INTERSECT ALL", 'o'},
    {"IS DISTINCT", 'n'},
    {"IS DISTINCT FROM", 'k'},
    {"IS NOT", 'o'},
    {"IS NOT DISTINCT", 'n'},
    {"IS NOT DISTINCT FROM", 'k'},
    {"LEFT JOIN", 'k'},
    {"LEFT OUTER", 'k'},
    {"LOCK TABLE", 'k'},
    {"LOCK TABLES", 'k'},
    {"NATURAL FULL", 'k'},
    {"NATURAL INNER", 'k'},
    {"NATURAL JOIN", 'k'},
    {"NATURAL LEFT", 'k'},
    {"NATURAL OUTER", 'k'},
    {"NATURAL RIGHT", 'k'},
    {"NEXT VALUE", 'n'},
    {"NEXT VALUE FOR", 'k'},
    {"NOT BETWEEN", 'o'},
    {"NOT IN", 'o'},
    {"NOT LIKE", 'o'},
    {"NOT REGEXP", 'o'},
    {"NOT RLIKE", 'o'},
    {"NOT SIMILAR", 'o'},
    {"NOT SIMILAR TO", 'o'},
    {"ORDER BY", 'B'},
    {"OWN3D BY", 'B'},
    {"READ WRITE", 'k'},
    {"RIGHT JOIN", 'k'},
    {"RIGHT OUTER", 'k'},
    {"SELECT ALL", 'k'},
    {"SIMILAR TO", 'o'},
    {"SOUNDS LIKE", 'o'},
    {"UNION ALL", 'U'},
};
static const size_t multikeywords_sz = 43;

typedef size_t (*pt2Function)(sfilter *sf);
static const pt2Function char_parse_map[] = {
   &parse_white, /* 0 */
   &parse_white, /* 1 */
   &parse_white, /* 2 */
   &parse_white, /* 3 */
   &parse_white, /* 4 */
   &parse_white, /* 5 */
   &parse_white, /* 6 */
   &parse_white, /* 7 */
   &parse_white, /* 8 */
   &parse_white, /* 9 */
   &parse_white, /* 10 */
   &parse_white, /* 11 */
   &parse_white, /* 12 */
   &parse_white, /* 13 */
   &parse_white, /* 14 */
   &parse_white, /* 15 */
   &parse_white, /* 16 */
   &parse_white, /* 17 */
   &parse_white, /* 18 */
   &parse_white, /* 19 */
   &parse_white, /* 20 */
   &parse_white, /* 21 */
   &parse_white, /* 22 */
   &parse_white, /* 23 */
   &parse_white, /* 24 */
   &parse_white, /* 25 */
   &parse_white, /* 26 */
   &parse_white, /* 27 */
   &parse_white, /* 28 */
   &parse_white, /* 29 */
   &parse_white, /* 30 */
   &parse_white, /* 31 */
   &parse_white, /* 32 */
   &parse_operator2, /* 33 */
   &parse_string, /* 34 */
   &parse_eol_comment, /* 35 */
   &parse_money, /* 36 */
   &parse_operator1, /* 37 */
   &parse_operator2, /* 38 */
   &parse_string, /* 39 */
   &parse_char, /* 40 */
   &parse_char, /* 41 */
   &parse_operator2, /* 42 */
   &parse_operator1, /* 43 */
   &parse_char, /* 44 */
   &parse_dash, /* 45 */
   &parse_number, /* 46 */
   &parse_slash, /* 47 */
   &parse_number, /* 48 */
   &parse_number, /* 49 */
   &parse_number, /* 50 */
   &parse_number, /* 51 */
   &parse_number, /* 52 */
   &parse_number, /* 53 */
   &parse_number, /* 54 */
   &parse_number, /* 55 */
   &parse_number, /* 56 */
   &parse_number, /* 57 */
   &parse_char, /* 58 */
   &parse_char, /* 59 */
   &parse_operator2, /* 60 */
   &parse_operator2, /* 61 */
   &parse_operator2, /* 62 */
   &parse_other, /* 63 */
   &parse_var, /* 64 */
   &parse_word, /* 65 */
   &parse_word, /* 66 */
   &parse_word, /* 67 */
   &parse_word, /* 68 */
   &parse_word, /* 69 */
   &parse_word, /* 70 */
   &parse_word, /* 71 */
   &parse_word, /* 72 */
   &parse_word, /* 73 */
   &parse_word, /* 74 */
   &parse_word, /* 75 */
   &parse_word, /* 76 */
   &parse_word, /* 77 */
   &parse_word, /* 78 */
   &parse_word, /* 79 */
   &parse_word, /* 80 */
   &parse_word, /* 81 */
   &parse_word, /* 82 */
   &parse_word, /* 83 */
   &parse_word, /* 84 */
   &parse_word, /* 85 */
   &parse_word, /* 86 */
   &parse_word, /* 87 */
   &parse_word, /* 88 */
   &parse_word, /* 89 */
   &parse_word, /* 90 */
   &parse_other, /* 91 */
   &parse_backslash, /* 92 */
   &parse_other, /* 93 */
   &parse_operator1, /* 94 */
   &parse_word, /* 95 */
   &parse_word, /* 96 */
   &parse_word, /* 97 */
   &parse_word, /* 98 */
   &parse_word, /* 99 */
   &parse_word, /* 100 */
   &parse_word, /* 101 */
   &parse_word, /* 102 */
   &parse_word, /* 103 */
   &parse_word, /* 104 */
   &parse_word, /* 105 */
   &parse_word, /* 106 */
   &parse_word, /* 107 */
   &parse_word, /* 108 */
   &parse_word, /* 109 */
   &parse_word, /* 110 */
   &parse_word, /* 111 */
   &parse_word, /* 112 */
   &parse_word, /* 113 */
   &parse_word, /* 114 */
   &parse_word, /* 115 */
   &parse_word, /* 116 */
   &parse_word, /* 117 */
   &parse_word, /* 118 */
   &parse_word, /* 119 */
   &parse_word, /* 120 */
   &parse_word, /* 121 */
   &parse_word, /* 122 */
   &parse_other, /* 123 */
   &parse_operator2, /* 124 */
   &parse_other, /* 125 */
   &parse_operator1, /* 126 */
   &parse_white, /* 127 */
};

#endif
