"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Moncton"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Moncton", { offset: true, expect: "America/Halifax" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Moncton", { abbr: true, expect: "America/Halifax" }),

	"1902" : helpers.makeTestYear("America/Moncton", [
		["1902-06-15T04:59:59+00:00", "23:59:59", "EST", 300],
		["1902-06-15T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1918" : helpers.makeTestYear("America/Moncton", [
		["1918-04-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["1918-04-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1918-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1918-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1933" : helpers.makeTestYear("America/Moncton", [
		["1933-06-11T04:59:59+00:00", "00:59:59", "AST", 240],
		["1933-06-11T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1933-09-10T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1933-09-10T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1934" : helpers.makeTestYear("America/Moncton", [
		["1934-06-10T04:59:59+00:00", "00:59:59", "AST", 240],
		["1934-06-10T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1934-09-09T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1934-09-09T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1935" : helpers.makeTestYear("America/Moncton", [
		["1935-06-09T04:59:59+00:00", "00:59:59", "AST", 240],
		["1935-06-09T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1935-09-08T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1935-09-08T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1936" : helpers.makeTestYear("America/Moncton", [
		["1936-06-07T04:59:59+00:00", "00:59:59", "AST", 240],
		["1936-06-07T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1936-09-06T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1936-09-06T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1937" : helpers.makeTestYear("America/Moncton", [
		["1937-06-06T04:59:59+00:00", "00:59:59", "AST", 240],
		["1937-06-06T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1937-09-05T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1937-09-05T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1938" : helpers.makeTestYear("America/Moncton", [
		["1938-06-05T04:59:59+00:00", "00:59:59", "AST", 240],
		["1938-06-05T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1938-09-04T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1938-09-04T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1939" : helpers.makeTestYear("America/Moncton", [
		["1939-05-27T04:59:59+00:00", "00:59:59", "AST", 240],
		["1939-05-27T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1939-09-23T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1939-09-23T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1940" : helpers.makeTestYear("America/Moncton", [
		["1940-05-19T04:59:59+00:00", "00:59:59", "AST", 240],
		["1940-05-19T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1940-09-21T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1940-09-21T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1941" : helpers.makeTestYear("America/Moncton", [
		["1941-05-04T04:59:59+00:00", "00:59:59", "AST", 240],
		["1941-05-04T05:00:00+00:00", "02:00:00", "ADT", 180],
		["1941-09-27T03:59:59+00:00", "00:59:59", "ADT", 180],
		["1941-09-27T04:00:00+00:00", "00:00:00", "AST", 240]
	]),

	"1942" : helpers.makeTestYear("America/Moncton", [
		["1942-02-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["1942-02-09T06:00:00+00:00", "03:00:00", "AWT", 180]
	]),

	"1945" : helpers.makeTestYear("America/Moncton", [
		["1945-08-14T22:59:59+00:00", "19:59:59", "AWT", 180],
		["1945-08-14T23:00:00+00:00", "20:00:00", "APT", 180],
		["1945-09-30T04:59:59+00:00", "01:59:59", "APT", 180],
		["1945-09-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1946" : helpers.makeTestYear("America/Moncton", [
		["1946-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1946-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1946-09-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1946-09-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1947" : helpers.makeTestYear("America/Moncton", [
		["1947-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1947-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1947-09-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1947-09-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1948" : helpers.makeTestYear("America/Moncton", [
		["1948-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1948-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1948-09-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1948-09-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1949" : helpers.makeTestYear("America/Moncton", [
		["1949-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1949-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1949-09-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1949-09-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1950" : helpers.makeTestYear("America/Moncton", [
		["1950-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1950-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1950-09-24T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1950-09-24T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1951" : helpers.makeTestYear("America/Moncton", [
		["1951-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1951-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1951-09-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1951-09-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1952" : helpers.makeTestYear("America/Moncton", [
		["1952-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1952-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1952-09-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1952-09-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1953" : helpers.makeTestYear("America/Moncton", [
		["1953-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1953-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1953-09-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1953-09-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1954" : helpers.makeTestYear("America/Moncton", [
		["1954-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1954-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1954-09-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1954-09-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1955" : helpers.makeTestYear("America/Moncton", [
		["1955-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1955-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1955-09-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1955-09-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1956" : helpers.makeTestYear("America/Moncton", [
		["1956-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1956-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1956-09-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1956-09-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1957" : helpers.makeTestYear("America/Moncton", [
		["1957-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1957-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1957-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1957-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1958" : helpers.makeTestYear("America/Moncton", [
		["1958-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1958-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1958-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1958-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1959" : helpers.makeTestYear("America/Moncton", [
		["1959-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1959-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1959-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1959-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1960" : helpers.makeTestYear("America/Moncton", [
		["1960-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1960-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1960-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1960-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1961" : helpers.makeTestYear("America/Moncton", [
		["1961-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1961-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1961-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1961-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1962" : helpers.makeTestYear("America/Moncton", [
		["1962-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1962-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1962-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1962-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1963" : helpers.makeTestYear("America/Moncton", [
		["1963-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1963-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1963-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1963-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1964" : helpers.makeTestYear("America/Moncton", [
		["1964-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1964-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1964-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1964-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1965" : helpers.makeTestYear("America/Moncton", [
		["1965-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1965-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1965-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1965-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1966" : helpers.makeTestYear("America/Moncton", [
		["1966-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1966-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1966-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1966-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1967" : helpers.makeTestYear("America/Moncton", [
		["1967-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1967-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1967-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1967-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1968" : helpers.makeTestYear("America/Moncton", [
		["1968-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1968-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1968-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1968-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1969" : helpers.makeTestYear("America/Moncton", [
		["1969-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1969-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1969-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1969-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1970" : helpers.makeTestYear("America/Moncton", [
		["1970-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1970-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1970-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1970-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1971" : helpers.makeTestYear("America/Moncton", [
		["1971-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1971-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1971-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1971-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1972" : helpers.makeTestYear("America/Moncton", [
		["1972-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1972-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1972-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1972-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1974" : helpers.makeTestYear("America/Moncton", [
		["1974-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1974-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1974-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1974-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1975" : helpers.makeTestYear("America/Moncton", [
		["1975-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1975-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1975-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1975-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1976" : helpers.makeTestYear("America/Moncton", [
		["1976-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1976-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1976-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1976-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1977" : helpers.makeTestYear("America/Moncton", [
		["1977-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1977-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1977-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1977-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1978" : helpers.makeTestYear("America/Moncton", [
		["1978-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1978-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1978-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1978-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1979" : helpers.makeTestYear("America/Moncton", [
		["1979-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1979-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1979-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1979-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("America/Moncton", [
		["1980-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1980-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1980-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1980-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1981" : helpers.makeTestYear("America/Moncton", [
		["1981-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1981-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1981-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1981-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1982" : helpers.makeTestYear("America/Moncton", [
		["1982-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1982-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1982-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1982-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1983" : helpers.makeTestYear("America/Moncton", [
		["1983-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1983-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1983-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1983-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1984" : helpers.makeTestYear("America/Moncton", [
		["1984-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1984-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1984-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1984-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1985" : helpers.makeTestYear("America/Moncton", [
		["1985-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1985-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1985-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1985-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1986" : helpers.makeTestYear("America/Moncton", [
		["1986-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1986-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1986-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1986-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1987" : helpers.makeTestYear("America/Moncton", [
		["1987-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1987-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1987-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1987-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1988" : helpers.makeTestYear("America/Moncton", [
		["1988-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1988-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1988-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1988-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1989" : helpers.makeTestYear("America/Moncton", [
		["1989-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1989-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1989-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1989-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1990" : helpers.makeTestYear("America/Moncton", [
		["1990-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["1990-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1990-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1990-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1991" : helpers.makeTestYear("America/Moncton", [
		["1991-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1991-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1991-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1991-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1992" : helpers.makeTestYear("America/Moncton", [
		["1992-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1992-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1992-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1992-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1993" : helpers.makeTestYear("America/Moncton", [
		["1993-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["1993-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1993-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1993-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1994" : helpers.makeTestYear("America/Moncton", [
		["1994-04-03T04:00:59+00:00", "00:00:59", "AST", 240],
		["1994-04-03T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1994-10-30T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1994-10-30T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1995" : helpers.makeTestYear("America/Moncton", [
		["1995-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["1995-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1995-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1995-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1996" : helpers.makeTestYear("America/Moncton", [
		["1996-04-07T04:00:59+00:00", "00:00:59", "AST", 240],
		["1996-04-07T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1996-10-27T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1996-10-27T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1997" : helpers.makeTestYear("America/Moncton", [
		["1997-04-06T04:00:59+00:00", "00:00:59", "AST", 240],
		["1997-04-06T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1997-10-26T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1997-10-26T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1998" : helpers.makeTestYear("America/Moncton", [
		["1998-04-05T04:00:59+00:00", "00:00:59", "AST", 240],
		["1998-04-05T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1998-10-25T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1998-10-25T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1999" : helpers.makeTestYear("America/Moncton", [
		["1999-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["1999-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1999-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1999-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2000" : helpers.makeTestYear("America/Moncton", [
		["2000-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["2000-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2000-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2000-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2001" : helpers.makeTestYear("America/Moncton", [
		["2001-04-01T04:00:59+00:00", "00:00:59", "AST", 240],
		["2001-04-01T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2001-10-28T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2001-10-28T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2002" : helpers.makeTestYear("America/Moncton", [
		["2002-04-07T04:00:59+00:00", "00:00:59", "AST", 240],
		["2002-04-07T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2002-10-27T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2002-10-27T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2003" : helpers.makeTestYear("America/Moncton", [
		["2003-04-06T04:00:59+00:00", "00:00:59", "AST", 240],
		["2003-04-06T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2003-10-26T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2003-10-26T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2004" : helpers.makeTestYear("America/Moncton", [
		["2004-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["2004-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2004-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2004-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2005" : helpers.makeTestYear("America/Moncton", [
		["2005-04-03T04:00:59+00:00", "00:00:59", "AST", 240],
		["2005-04-03T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2005-10-30T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2005-10-30T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2006" : helpers.makeTestYear("America/Moncton", [
		["2006-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["2006-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2006-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2006-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2007" : helpers.makeTestYear("America/Moncton", [
		["2007-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2007-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2007-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2007-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2008" : helpers.makeTestYear("America/Moncton", [
		["2008-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2008-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2008-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2008-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2009" : helpers.makeTestYear("America/Moncton", [
		["2009-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2009-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2009-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2009-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2010" : helpers.makeTestYear("America/Moncton", [
		["2010-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2010-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2010-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2010-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2011" : helpers.makeTestYear("America/Moncton", [
		["2011-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2011-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2011-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2011-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2012" : helpers.makeTestYear("America/Moncton", [
		["2012-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2012-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2012-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2012-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2013" : helpers.makeTestYear("America/Moncton", [
		["2013-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2013-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2013-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2013-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2014" : helpers.makeTestYear("America/Moncton", [
		["2014-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2014-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2014-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2014-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2015" : helpers.makeTestYear("America/Moncton", [
		["2015-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2015-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2015-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2015-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2016" : helpers.makeTestYear("America/Moncton", [
		["2016-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2016-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2016-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2016-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2017" : helpers.makeTestYear("America/Moncton", [
		["2017-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2017-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2017-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2017-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2018" : helpers.makeTestYear("America/Moncton", [
		["2018-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2018-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2018-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2018-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2019" : helpers.makeTestYear("America/Moncton", [
		["2019-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2019-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2019-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2019-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2020" : helpers.makeTestYear("America/Moncton", [
		["2020-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2020-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2020-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2020-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2021" : helpers.makeTestYear("America/Moncton", [
		["2021-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2021-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2021-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2021-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2022" : helpers.makeTestYear("America/Moncton", [
		["2022-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2022-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2022-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2022-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2023" : helpers.makeTestYear("America/Moncton", [
		["2023-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2023-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2023-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2023-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2024" : helpers.makeTestYear("America/Moncton", [
		["2024-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2024-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2024-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2024-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2025" : helpers.makeTestYear("America/Moncton", [
		["2025-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2025-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2025-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2025-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2026" : helpers.makeTestYear("America/Moncton", [
		["2026-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2026-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2026-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2026-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2027" : helpers.makeTestYear("America/Moncton", [
		["2027-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2027-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2027-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2027-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2028" : helpers.makeTestYear("America/Moncton", [
		["2028-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2028-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2028-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2028-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2029" : helpers.makeTestYear("America/Moncton", [
		["2029-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2029-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2029-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2029-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2030" : helpers.makeTestYear("America/Moncton", [
		["2030-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2030-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2030-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2030-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2031" : helpers.makeTestYear("America/Moncton", [
		["2031-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2031-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2031-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2031-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2032" : helpers.makeTestYear("America/Moncton", [
		["2032-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2032-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2032-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2032-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2033" : helpers.makeTestYear("America/Moncton", [
		["2033-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2033-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2033-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2033-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2034" : helpers.makeTestYear("America/Moncton", [
		["2034-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2034-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2034-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2034-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2035" : helpers.makeTestYear("America/Moncton", [
		["2035-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2035-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2035-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2035-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2036" : helpers.makeTestYear("America/Moncton", [
		["2036-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2036-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2036-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2036-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2037" : helpers.makeTestYear("America/Moncton", [
		["2037-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2037-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2037-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2037-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2038" : helpers.makeTestYear("America/Moncton", [
		["2038-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2038-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2038-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2038-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2039" : helpers.makeTestYear("America/Moncton", [
		["2039-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2039-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2039-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2039-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2040" : helpers.makeTestYear("America/Moncton", [
		["2040-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2040-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2040-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2040-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2041" : helpers.makeTestYear("America/Moncton", [
		["2041-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2041-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2041-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2041-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2042" : helpers.makeTestYear("America/Moncton", [
		["2042-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2042-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2042-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2042-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2043" : helpers.makeTestYear("America/Moncton", [
		["2043-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2043-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2043-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2043-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2044" : helpers.makeTestYear("America/Moncton", [
		["2044-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2044-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2044-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2044-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2045" : helpers.makeTestYear("America/Moncton", [
		["2045-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2045-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2045-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2045-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2046" : helpers.makeTestYear("America/Moncton", [
		["2046-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2046-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2046-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2046-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2047" : helpers.makeTestYear("America/Moncton", [
		["2047-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2047-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2047-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2047-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2048" : helpers.makeTestYear("America/Moncton", [
		["2048-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2048-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2048-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2048-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2049" : helpers.makeTestYear("America/Moncton", [
		["2049-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2049-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2049-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2049-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2050" : helpers.makeTestYear("America/Moncton", [
		["2050-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2050-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2050-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2050-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2051" : helpers.makeTestYear("America/Moncton", [
		["2051-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2051-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2051-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2051-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2052" : helpers.makeTestYear("America/Moncton", [
		["2052-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2052-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2052-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2052-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2053" : helpers.makeTestYear("America/Moncton", [
		["2053-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2053-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2053-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2053-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2054" : helpers.makeTestYear("America/Moncton", [
		["2054-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2054-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2054-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2054-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2055" : helpers.makeTestYear("America/Moncton", [
		["2055-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2055-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2055-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2055-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2056" : helpers.makeTestYear("America/Moncton", [
		["2056-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2056-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2056-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2056-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2057" : helpers.makeTestYear("America/Moncton", [
		["2057-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2057-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2057-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2057-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2058" : helpers.makeTestYear("America/Moncton", [
		["2058-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2058-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2058-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2058-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2059" : helpers.makeTestYear("America/Moncton", [
		["2059-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2059-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2059-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2059-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2060" : helpers.makeTestYear("America/Moncton", [
		["2060-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2060-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2060-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2060-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2061" : helpers.makeTestYear("America/Moncton", [
		["2061-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2061-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2061-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2061-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2062" : helpers.makeTestYear("America/Moncton", [
		["2062-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2062-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2062-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2062-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2063" : helpers.makeTestYear("America/Moncton", [
		["2063-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2063-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2063-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2063-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2064" : helpers.makeTestYear("America/Moncton", [
		["2064-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2064-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2064-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2064-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2065" : helpers.makeTestYear("America/Moncton", [
		["2065-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2065-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2065-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2065-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2066" : helpers.makeTestYear("America/Moncton", [
		["2066-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2066-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2066-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2066-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2067" : helpers.makeTestYear("America/Moncton", [
		["2067-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2067-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2067-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2067-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2068" : helpers.makeTestYear("America/Moncton", [
		["2068-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2068-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2068-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2068-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2069" : helpers.makeTestYear("America/Moncton", [
		["2069-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2069-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2069-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2069-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2070" : helpers.makeTestYear("America/Moncton", [
		["2070-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2070-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2070-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2070-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2071" : helpers.makeTestYear("America/Moncton", [
		["2071-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2071-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2071-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2071-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2072" : helpers.makeTestYear("America/Moncton", [
		["2072-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2072-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2072-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2072-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2073" : helpers.makeTestYear("America/Moncton", [
		["2073-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2073-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2073-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2073-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2074" : helpers.makeTestYear("America/Moncton", [
		["2074-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2074-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2074-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2074-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2075" : helpers.makeTestYear("America/Moncton", [
		["2075-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2075-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2075-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2075-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2076" : helpers.makeTestYear("America/Moncton", [
		["2076-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2076-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2076-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2076-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2077" : helpers.makeTestYear("America/Moncton", [
		["2077-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2077-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2077-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2077-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2078" : helpers.makeTestYear("America/Moncton", [
		["2078-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2078-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2078-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2078-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2079" : helpers.makeTestYear("America/Moncton", [
		["2079-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2079-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2079-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2079-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2080" : helpers.makeTestYear("America/Moncton", [
		["2080-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2080-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2080-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2080-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2081" : helpers.makeTestYear("America/Moncton", [
		["2081-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2081-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2081-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2081-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2082" : helpers.makeTestYear("America/Moncton", [
		["2082-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2082-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2082-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2082-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2083" : helpers.makeTestYear("America/Moncton", [
		["2083-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2083-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2083-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2083-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2084" : helpers.makeTestYear("America/Moncton", [
		["2084-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2084-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2084-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2084-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2085" : helpers.makeTestYear("America/Moncton", [
		["2085-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2085-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2085-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2085-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2086" : helpers.makeTestYear("America/Moncton", [
		["2086-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2086-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2086-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2086-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2087" : helpers.makeTestYear("America/Moncton", [
		["2087-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2087-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2087-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2087-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2088" : helpers.makeTestYear("America/Moncton", [
		["2088-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2088-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2088-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2088-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2089" : helpers.makeTestYear("America/Moncton", [
		["2089-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2089-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2089-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2089-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2090" : helpers.makeTestYear("America/Moncton", [
		["2090-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2090-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2090-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2090-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2091" : helpers.makeTestYear("America/Moncton", [
		["2091-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2091-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2091-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2091-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2092" : helpers.makeTestYear("America/Moncton", [
		["2092-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2092-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2092-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2092-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2093" : helpers.makeTestYear("America/Moncton", [
		["2093-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2093-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2093-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2093-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2094" : helpers.makeTestYear("America/Moncton", [
		["2094-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2094-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2094-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2094-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2095" : helpers.makeTestYear("America/Moncton", [
		["2095-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2095-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2095-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2095-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2096" : helpers.makeTestYear("America/Moncton", [
		["2096-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2096-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2096-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2096-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2097" : helpers.makeTestYear("America/Moncton", [
		["2097-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2097-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2097-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2097-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2098" : helpers.makeTestYear("America/Moncton", [
		["2098-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2098-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2098-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2098-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2099" : helpers.makeTestYear("America/Moncton", [
		["2099-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2099-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2099-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2099-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2100" : helpers.makeTestYear("America/Moncton", [
		["2100-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2100-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2100-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2100-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2101" : helpers.makeTestYear("America/Moncton", [
		["2101-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2101-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2101-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2101-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2102" : helpers.makeTestYear("America/Moncton", [
		["2102-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2102-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2102-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2102-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2103" : helpers.makeTestYear("America/Moncton", [
		["2103-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2103-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2103-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2103-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2104" : helpers.makeTestYear("America/Moncton", [
		["2104-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2104-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2104-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2104-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2105" : helpers.makeTestYear("America/Moncton", [
		["2105-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2105-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2105-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2105-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2106" : helpers.makeTestYear("America/Moncton", [
		["2106-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2106-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2106-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2106-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2107" : helpers.makeTestYear("America/Moncton", [
		["2107-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2107-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2107-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2107-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2108" : helpers.makeTestYear("America/Moncton", [
		["2108-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2108-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2108-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2108-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2109" : helpers.makeTestYear("America/Moncton", [
		["2109-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2109-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2109-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2109-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2110" : helpers.makeTestYear("America/Moncton", [
		["2110-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2110-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2110-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2110-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2111" : helpers.makeTestYear("America/Moncton", [
		["2111-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2111-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2111-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2111-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2112" : helpers.makeTestYear("America/Moncton", [
		["2112-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2112-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2112-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2112-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2113" : helpers.makeTestYear("America/Moncton", [
		["2113-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2113-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2113-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2113-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2114" : helpers.makeTestYear("America/Moncton", [
		["2114-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2114-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2114-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2114-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2115" : helpers.makeTestYear("America/Moncton", [
		["2115-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2115-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2115-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2115-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2116" : helpers.makeTestYear("America/Moncton", [
		["2116-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2116-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2116-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2116-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2117" : helpers.makeTestYear("America/Moncton", [
		["2117-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2117-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2117-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2117-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2118" : helpers.makeTestYear("America/Moncton", [
		["2118-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2118-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2118-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2118-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2119" : helpers.makeTestYear("America/Moncton", [
		["2119-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2119-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2119-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2119-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2120" : helpers.makeTestYear("America/Moncton", [
		["2120-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2120-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2120-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2120-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2121" : helpers.makeTestYear("America/Moncton", [
		["2121-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2121-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2121-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2121-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2122" : helpers.makeTestYear("America/Moncton", [
		["2122-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2122-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2122-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2122-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2123" : helpers.makeTestYear("America/Moncton", [
		["2123-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2123-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2123-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2123-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2124" : helpers.makeTestYear("America/Moncton", [
		["2124-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2124-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2124-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2124-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2125" : helpers.makeTestYear("America/Moncton", [
		["2125-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2125-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2125-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2125-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2126" : helpers.makeTestYear("America/Moncton", [
		["2126-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2126-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2126-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2126-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2127" : helpers.makeTestYear("America/Moncton", [
		["2127-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2127-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2127-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2127-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2128" : helpers.makeTestYear("America/Moncton", [
		["2128-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2128-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2128-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2128-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2129" : helpers.makeTestYear("America/Moncton", [
		["2129-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2129-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2129-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2129-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2130" : helpers.makeTestYear("America/Moncton", [
		["2130-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2130-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2130-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2130-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2131" : helpers.makeTestYear("America/Moncton", [
		["2131-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2131-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2131-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2131-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2132" : helpers.makeTestYear("America/Moncton", [
		["2132-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2132-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2132-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2132-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2133" : helpers.makeTestYear("America/Moncton", [
		["2133-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2133-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2133-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2133-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2134" : helpers.makeTestYear("America/Moncton", [
		["2134-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2134-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2134-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2134-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2135" : helpers.makeTestYear("America/Moncton", [
		["2135-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2135-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2135-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2135-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2136" : helpers.makeTestYear("America/Moncton", [
		["2136-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2136-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2136-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2136-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2137" : helpers.makeTestYear("America/Moncton", [
		["2137-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2137-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2137-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2137-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2138" : helpers.makeTestYear("America/Moncton", [
		["2138-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2138-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2138-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2138-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2139" : helpers.makeTestYear("America/Moncton", [
		["2139-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2139-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2139-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2139-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2140" : helpers.makeTestYear("America/Moncton", [
		["2140-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2140-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2140-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2140-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2141" : helpers.makeTestYear("America/Moncton", [
		["2141-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2141-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2141-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2141-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2142" : helpers.makeTestYear("America/Moncton", [
		["2142-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2142-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2142-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2142-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2143" : helpers.makeTestYear("America/Moncton", [
		["2143-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2143-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2143-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2143-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2144" : helpers.makeTestYear("America/Moncton", [
		["2144-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2144-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2144-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2144-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2145" : helpers.makeTestYear("America/Moncton", [
		["2145-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2145-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2145-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2145-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2146" : helpers.makeTestYear("America/Moncton", [
		["2146-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2146-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2146-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2146-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2147" : helpers.makeTestYear("America/Moncton", [
		["2147-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2147-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2147-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2147-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2148" : helpers.makeTestYear("America/Moncton", [
		["2148-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2148-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2148-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2148-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2149" : helpers.makeTestYear("America/Moncton", [
		["2149-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2149-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2149-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2149-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2150" : helpers.makeTestYear("America/Moncton", [
		["2150-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2150-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2150-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2150-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2151" : helpers.makeTestYear("America/Moncton", [
		["2151-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2151-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2151-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2151-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2152" : helpers.makeTestYear("America/Moncton", [
		["2152-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2152-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2152-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2152-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2153" : helpers.makeTestYear("America/Moncton", [
		["2153-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2153-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2153-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2153-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2154" : helpers.makeTestYear("America/Moncton", [
		["2154-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2154-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2154-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2154-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2155" : helpers.makeTestYear("America/Moncton", [
		["2155-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2155-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2155-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2155-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2156" : helpers.makeTestYear("America/Moncton", [
		["2156-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2156-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2156-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2156-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2157" : helpers.makeTestYear("America/Moncton", [
		["2157-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2157-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2157-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2157-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2158" : helpers.makeTestYear("America/Moncton", [
		["2158-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2158-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2158-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2158-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2159" : helpers.makeTestYear("America/Moncton", [
		["2159-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2159-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2159-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2159-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2160" : helpers.makeTestYear("America/Moncton", [
		["2160-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2160-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2160-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2160-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2161" : helpers.makeTestYear("America/Moncton", [
		["2161-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2161-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2161-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2161-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2162" : helpers.makeTestYear("America/Moncton", [
		["2162-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2162-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2162-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2162-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2163" : helpers.makeTestYear("America/Moncton", [
		["2163-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2163-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2163-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2163-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2164" : helpers.makeTestYear("America/Moncton", [
		["2164-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2164-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2164-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2164-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2165" : helpers.makeTestYear("America/Moncton", [
		["2165-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2165-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2165-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2165-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2166" : helpers.makeTestYear("America/Moncton", [
		["2166-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2166-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2166-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2166-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2167" : helpers.makeTestYear("America/Moncton", [
		["2167-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2167-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2167-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2167-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2168" : helpers.makeTestYear("America/Moncton", [
		["2168-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2168-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2168-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2168-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2169" : helpers.makeTestYear("America/Moncton", [
		["2169-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2169-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2169-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2169-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2170" : helpers.makeTestYear("America/Moncton", [
		["2170-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2170-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2170-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2170-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2171" : helpers.makeTestYear("America/Moncton", [
		["2171-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2171-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2171-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2171-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2172" : helpers.makeTestYear("America/Moncton", [
		["2172-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2172-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2172-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2172-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2173" : helpers.makeTestYear("America/Moncton", [
		["2173-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2173-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2173-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2173-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2174" : helpers.makeTestYear("America/Moncton", [
		["2174-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2174-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2174-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2174-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2175" : helpers.makeTestYear("America/Moncton", [
		["2175-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2175-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2175-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2175-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2176" : helpers.makeTestYear("America/Moncton", [
		["2176-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2176-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2176-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2176-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2177" : helpers.makeTestYear("America/Moncton", [
		["2177-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2177-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2177-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2177-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2178" : helpers.makeTestYear("America/Moncton", [
		["2178-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2178-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2178-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2178-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2179" : helpers.makeTestYear("America/Moncton", [
		["2179-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2179-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2179-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2179-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2180" : helpers.makeTestYear("America/Moncton", [
		["2180-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2180-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2180-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2180-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2181" : helpers.makeTestYear("America/Moncton", [
		["2181-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2181-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2181-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2181-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2182" : helpers.makeTestYear("America/Moncton", [
		["2182-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2182-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2182-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2182-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2183" : helpers.makeTestYear("America/Moncton", [
		["2183-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2183-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2183-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2183-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2184" : helpers.makeTestYear("America/Moncton", [
		["2184-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2184-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2184-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2184-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2185" : helpers.makeTestYear("America/Moncton", [
		["2185-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2185-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2185-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2185-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2186" : helpers.makeTestYear("America/Moncton", [
		["2186-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2186-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2186-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2186-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2187" : helpers.makeTestYear("America/Moncton", [
		["2187-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2187-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2187-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2187-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2188" : helpers.makeTestYear("America/Moncton", [
		["2188-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2188-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2188-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2188-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2189" : helpers.makeTestYear("America/Moncton", [
		["2189-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2189-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2189-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2189-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2190" : helpers.makeTestYear("America/Moncton", [
		["2190-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2190-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2190-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2190-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2191" : helpers.makeTestYear("America/Moncton", [
		["2191-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2191-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2191-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2191-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2192" : helpers.makeTestYear("America/Moncton", [
		["2192-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2192-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2192-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2192-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2193" : helpers.makeTestYear("America/Moncton", [
		["2193-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2193-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2193-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2193-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2194" : helpers.makeTestYear("America/Moncton", [
		["2194-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2194-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2194-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2194-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2195" : helpers.makeTestYear("America/Moncton", [
		["2195-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2195-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2195-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2195-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2196" : helpers.makeTestYear("America/Moncton", [
		["2196-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2196-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2196-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2196-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2197" : helpers.makeTestYear("America/Moncton", [
		["2197-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2197-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2197-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2197-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2198" : helpers.makeTestYear("America/Moncton", [
		["2198-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2198-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2198-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2198-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2199" : helpers.makeTestYear("America/Moncton", [
		["2199-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2199-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2199-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2199-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2200" : helpers.makeTestYear("America/Moncton", [
		["2200-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2200-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2200-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2200-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2201" : helpers.makeTestYear("America/Moncton", [
		["2201-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2201-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2201-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2201-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2202" : helpers.makeTestYear("America/Moncton", [
		["2202-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2202-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2202-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2202-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2203" : helpers.makeTestYear("America/Moncton", [
		["2203-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2203-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2203-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2203-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2204" : helpers.makeTestYear("America/Moncton", [
		["2204-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2204-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2204-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2204-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2205" : helpers.makeTestYear("America/Moncton", [
		["2205-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2205-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2205-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2205-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2206" : helpers.makeTestYear("America/Moncton", [
		["2206-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2206-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2206-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2206-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2207" : helpers.makeTestYear("America/Moncton", [
		["2207-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2207-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2207-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2207-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2208" : helpers.makeTestYear("America/Moncton", [
		["2208-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2208-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2208-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2208-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2209" : helpers.makeTestYear("America/Moncton", [
		["2209-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2209-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2209-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2209-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2210" : helpers.makeTestYear("America/Moncton", [
		["2210-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2210-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2210-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2210-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2211" : helpers.makeTestYear("America/Moncton", [
		["2211-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2211-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2211-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2211-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2212" : helpers.makeTestYear("America/Moncton", [
		["2212-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2212-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2212-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2212-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2213" : helpers.makeTestYear("America/Moncton", [
		["2213-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2213-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2213-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2213-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2214" : helpers.makeTestYear("America/Moncton", [
		["2214-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2214-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2214-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2214-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2215" : helpers.makeTestYear("America/Moncton", [
		["2215-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2215-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2215-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2215-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2216" : helpers.makeTestYear("America/Moncton", [
		["2216-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2216-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2216-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2216-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2217" : helpers.makeTestYear("America/Moncton", [
		["2217-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2217-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2217-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2217-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2218" : helpers.makeTestYear("America/Moncton", [
		["2218-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2218-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2218-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2218-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2219" : helpers.makeTestYear("America/Moncton", [
		["2219-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2219-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2219-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2219-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2220" : helpers.makeTestYear("America/Moncton", [
		["2220-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2220-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2220-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2220-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2221" : helpers.makeTestYear("America/Moncton", [
		["2221-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2221-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2221-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2221-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2222" : helpers.makeTestYear("America/Moncton", [
		["2222-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2222-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2222-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2222-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2223" : helpers.makeTestYear("America/Moncton", [
		["2223-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2223-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2223-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2223-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2224" : helpers.makeTestYear("America/Moncton", [
		["2224-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2224-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2224-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2224-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2225" : helpers.makeTestYear("America/Moncton", [
		["2225-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2225-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2225-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2225-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2226" : helpers.makeTestYear("America/Moncton", [
		["2226-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2226-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2226-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2226-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2227" : helpers.makeTestYear("America/Moncton", [
		["2227-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2227-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2227-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2227-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2228" : helpers.makeTestYear("America/Moncton", [
		["2228-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2228-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2228-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2228-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2229" : helpers.makeTestYear("America/Moncton", [
		["2229-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2229-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2229-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2229-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2230" : helpers.makeTestYear("America/Moncton", [
		["2230-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2230-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2230-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2230-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2231" : helpers.makeTestYear("America/Moncton", [
		["2231-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2231-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2231-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2231-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2232" : helpers.makeTestYear("America/Moncton", [
		["2232-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2232-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2232-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2232-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2233" : helpers.makeTestYear("America/Moncton", [
		["2233-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2233-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2233-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2233-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2234" : helpers.makeTestYear("America/Moncton", [
		["2234-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2234-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2234-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2234-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2235" : helpers.makeTestYear("America/Moncton", [
		["2235-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2235-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2235-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2235-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2236" : helpers.makeTestYear("America/Moncton", [
		["2236-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2236-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2236-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2236-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2237" : helpers.makeTestYear("America/Moncton", [
		["2237-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2237-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2237-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2237-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2238" : helpers.makeTestYear("America/Moncton", [
		["2238-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2238-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2238-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2238-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2239" : helpers.makeTestYear("America/Moncton", [
		["2239-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2239-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2239-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2239-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2240" : helpers.makeTestYear("America/Moncton", [
		["2240-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2240-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2240-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2240-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2241" : helpers.makeTestYear("America/Moncton", [
		["2241-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2241-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2241-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2241-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2242" : helpers.makeTestYear("America/Moncton", [
		["2242-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2242-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2242-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2242-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2243" : helpers.makeTestYear("America/Moncton", [
		["2243-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2243-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2243-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2243-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2244" : helpers.makeTestYear("America/Moncton", [
		["2244-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2244-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2244-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2244-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2245" : helpers.makeTestYear("America/Moncton", [
		["2245-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2245-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2245-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2245-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2246" : helpers.makeTestYear("America/Moncton", [
		["2246-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2246-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2246-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2246-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2247" : helpers.makeTestYear("America/Moncton", [
		["2247-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2247-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2247-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2247-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2248" : helpers.makeTestYear("America/Moncton", [
		["2248-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2248-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2248-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2248-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2249" : helpers.makeTestYear("America/Moncton", [
		["2249-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2249-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2249-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2249-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2250" : helpers.makeTestYear("America/Moncton", [
		["2250-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2250-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2250-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2250-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2251" : helpers.makeTestYear("America/Moncton", [
		["2251-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2251-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2251-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2251-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2252" : helpers.makeTestYear("America/Moncton", [
		["2252-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2252-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2252-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2252-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2253" : helpers.makeTestYear("America/Moncton", [
		["2253-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2253-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2253-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2253-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2254" : helpers.makeTestYear("America/Moncton", [
		["2254-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2254-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2254-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2254-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2255" : helpers.makeTestYear("America/Moncton", [
		["2255-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2255-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2255-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2255-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2256" : helpers.makeTestYear("America/Moncton", [
		["2256-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2256-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2256-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2256-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2257" : helpers.makeTestYear("America/Moncton", [
		["2257-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2257-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2257-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2257-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2258" : helpers.makeTestYear("America/Moncton", [
		["2258-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2258-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2258-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2258-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2259" : helpers.makeTestYear("America/Moncton", [
		["2259-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2259-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2259-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2259-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2260" : helpers.makeTestYear("America/Moncton", [
		["2260-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2260-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2260-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2260-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2261" : helpers.makeTestYear("America/Moncton", [
		["2261-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2261-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2261-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2261-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2262" : helpers.makeTestYear("America/Moncton", [
		["2262-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2262-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2262-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2262-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2263" : helpers.makeTestYear("America/Moncton", [
		["2263-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2263-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2263-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2263-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2264" : helpers.makeTestYear("America/Moncton", [
		["2264-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2264-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2264-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2264-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2265" : helpers.makeTestYear("America/Moncton", [
		["2265-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2265-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2265-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2265-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2266" : helpers.makeTestYear("America/Moncton", [
		["2266-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2266-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2266-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2266-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2267" : helpers.makeTestYear("America/Moncton", [
		["2267-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2267-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2267-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2267-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2268" : helpers.makeTestYear("America/Moncton", [
		["2268-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2268-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2268-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2268-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2269" : helpers.makeTestYear("America/Moncton", [
		["2269-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2269-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2269-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2269-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2270" : helpers.makeTestYear("America/Moncton", [
		["2270-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2270-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2270-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2270-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2271" : helpers.makeTestYear("America/Moncton", [
		["2271-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2271-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2271-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2271-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2272" : helpers.makeTestYear("America/Moncton", [
		["2272-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2272-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2272-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2272-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2273" : helpers.makeTestYear("America/Moncton", [
		["2273-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2273-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2273-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2273-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2274" : helpers.makeTestYear("America/Moncton", [
		["2274-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2274-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2274-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2274-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2275" : helpers.makeTestYear("America/Moncton", [
		["2275-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2275-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2275-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2275-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2276" : helpers.makeTestYear("America/Moncton", [
		["2276-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2276-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2276-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2276-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2277" : helpers.makeTestYear("America/Moncton", [
		["2277-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2277-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2277-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2277-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2278" : helpers.makeTestYear("America/Moncton", [
		["2278-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2278-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2278-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2278-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2279" : helpers.makeTestYear("America/Moncton", [
		["2279-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2279-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2279-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2279-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2280" : helpers.makeTestYear("America/Moncton", [
		["2280-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2280-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2280-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2280-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2281" : helpers.makeTestYear("America/Moncton", [
		["2281-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2281-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2281-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2281-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2282" : helpers.makeTestYear("America/Moncton", [
		["2282-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2282-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2282-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2282-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2283" : helpers.makeTestYear("America/Moncton", [
		["2283-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2283-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2283-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2283-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2284" : helpers.makeTestYear("America/Moncton", [
		["2284-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2284-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2284-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2284-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2285" : helpers.makeTestYear("America/Moncton", [
		["2285-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2285-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2285-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2285-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2286" : helpers.makeTestYear("America/Moncton", [
		["2286-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2286-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2286-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2286-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2287" : helpers.makeTestYear("America/Moncton", [
		["2287-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2287-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2287-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2287-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2288" : helpers.makeTestYear("America/Moncton", [
		["2288-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2288-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2288-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2288-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2289" : helpers.makeTestYear("America/Moncton", [
		["2289-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2289-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2289-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2289-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2290" : helpers.makeTestYear("America/Moncton", [
		["2290-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2290-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2290-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2290-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2291" : helpers.makeTestYear("America/Moncton", [
		["2291-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2291-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2291-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2291-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2292" : helpers.makeTestYear("America/Moncton", [
		["2292-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2292-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2292-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2292-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2293" : helpers.makeTestYear("America/Moncton", [
		["2293-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2293-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2293-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2293-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2294" : helpers.makeTestYear("America/Moncton", [
		["2294-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2294-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2294-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2294-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2295" : helpers.makeTestYear("America/Moncton", [
		["2295-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2295-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2295-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2295-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2296" : helpers.makeTestYear("America/Moncton", [
		["2296-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2296-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2296-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2296-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2297" : helpers.makeTestYear("America/Moncton", [
		["2297-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2297-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2297-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2297-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2298" : helpers.makeTestYear("America/Moncton", [
		["2298-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2298-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2298-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2298-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2299" : helpers.makeTestYear("America/Moncton", [
		["2299-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2299-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2299-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2299-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2300" : helpers.makeTestYear("America/Moncton", [
		["2300-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2300-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2300-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2300-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2301" : helpers.makeTestYear("America/Moncton", [
		["2301-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2301-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2301-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2301-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2302" : helpers.makeTestYear("America/Moncton", [
		["2302-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2302-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2302-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2302-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2303" : helpers.makeTestYear("America/Moncton", [
		["2303-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2303-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2303-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2303-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2304" : helpers.makeTestYear("America/Moncton", [
		["2304-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2304-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2304-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2304-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2305" : helpers.makeTestYear("America/Moncton", [
		["2305-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2305-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2305-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2305-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2306" : helpers.makeTestYear("America/Moncton", [
		["2306-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2306-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2306-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2306-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2307" : helpers.makeTestYear("America/Moncton", [
		["2307-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2307-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2307-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2307-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2308" : helpers.makeTestYear("America/Moncton", [
		["2308-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2308-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2308-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2308-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2309" : helpers.makeTestYear("America/Moncton", [
		["2309-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2309-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2309-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2309-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2310" : helpers.makeTestYear("America/Moncton", [
		["2310-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2310-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2310-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2310-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2311" : helpers.makeTestYear("America/Moncton", [
		["2311-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2311-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2311-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2311-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2312" : helpers.makeTestYear("America/Moncton", [
		["2312-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2312-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2312-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2312-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2313" : helpers.makeTestYear("America/Moncton", [
		["2313-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2313-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2313-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2313-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2314" : helpers.makeTestYear("America/Moncton", [
		["2314-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2314-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2314-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2314-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2315" : helpers.makeTestYear("America/Moncton", [
		["2315-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2315-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2315-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2315-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2316" : helpers.makeTestYear("America/Moncton", [
		["2316-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2316-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2316-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2316-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2317" : helpers.makeTestYear("America/Moncton", [
		["2317-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2317-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2317-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2317-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2318" : helpers.makeTestYear("America/Moncton", [
		["2318-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2318-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2318-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2318-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2319" : helpers.makeTestYear("America/Moncton", [
		["2319-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2319-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2319-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2319-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2320" : helpers.makeTestYear("America/Moncton", [
		["2320-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2320-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2320-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2320-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2321" : helpers.makeTestYear("America/Moncton", [
		["2321-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2321-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2321-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2321-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2322" : helpers.makeTestYear("America/Moncton", [
		["2322-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2322-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2322-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2322-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2323" : helpers.makeTestYear("America/Moncton", [
		["2323-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2323-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2323-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2323-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2324" : helpers.makeTestYear("America/Moncton", [
		["2324-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2324-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2324-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2324-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2325" : helpers.makeTestYear("America/Moncton", [
		["2325-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2325-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2325-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2325-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2326" : helpers.makeTestYear("America/Moncton", [
		["2326-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2326-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2326-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2326-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2327" : helpers.makeTestYear("America/Moncton", [
		["2327-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2327-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2327-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2327-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2328" : helpers.makeTestYear("America/Moncton", [
		["2328-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2328-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2328-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2328-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2329" : helpers.makeTestYear("America/Moncton", [
		["2329-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2329-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2329-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2329-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2330" : helpers.makeTestYear("America/Moncton", [
		["2330-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2330-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2330-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2330-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2331" : helpers.makeTestYear("America/Moncton", [
		["2331-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2331-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2331-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2331-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2332" : helpers.makeTestYear("America/Moncton", [
		["2332-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2332-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2332-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2332-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2333" : helpers.makeTestYear("America/Moncton", [
		["2333-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2333-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2333-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2333-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2334" : helpers.makeTestYear("America/Moncton", [
		["2334-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2334-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2334-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2334-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2335" : helpers.makeTestYear("America/Moncton", [
		["2335-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2335-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2335-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2335-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2336" : helpers.makeTestYear("America/Moncton", [
		["2336-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2336-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2336-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2336-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2337" : helpers.makeTestYear("America/Moncton", [
		["2337-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2337-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2337-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2337-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2338" : helpers.makeTestYear("America/Moncton", [
		["2338-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2338-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2338-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2338-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2339" : helpers.makeTestYear("America/Moncton", [
		["2339-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2339-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2339-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2339-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2340" : helpers.makeTestYear("America/Moncton", [
		["2340-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2340-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2340-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2340-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2341" : helpers.makeTestYear("America/Moncton", [
		["2341-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2341-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2341-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2341-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2342" : helpers.makeTestYear("America/Moncton", [
		["2342-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2342-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2342-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2342-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2343" : helpers.makeTestYear("America/Moncton", [
		["2343-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2343-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2343-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2343-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2344" : helpers.makeTestYear("America/Moncton", [
		["2344-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2344-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2344-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2344-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2345" : helpers.makeTestYear("America/Moncton", [
		["2345-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2345-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2345-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2345-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2346" : helpers.makeTestYear("America/Moncton", [
		["2346-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2346-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2346-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2346-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2347" : helpers.makeTestYear("America/Moncton", [
		["2347-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2347-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2347-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2347-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2348" : helpers.makeTestYear("America/Moncton", [
		["2348-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2348-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2348-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2348-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2349" : helpers.makeTestYear("America/Moncton", [
		["2349-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2349-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2349-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2349-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2350" : helpers.makeTestYear("America/Moncton", [
		["2350-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2350-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2350-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2350-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2351" : helpers.makeTestYear("America/Moncton", [
		["2351-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2351-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2351-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2351-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2352" : helpers.makeTestYear("America/Moncton", [
		["2352-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2352-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2352-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2352-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2353" : helpers.makeTestYear("America/Moncton", [
		["2353-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2353-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2353-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2353-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2354" : helpers.makeTestYear("America/Moncton", [
		["2354-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2354-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2354-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2354-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2355" : helpers.makeTestYear("America/Moncton", [
		["2355-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2355-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2355-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2355-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2356" : helpers.makeTestYear("America/Moncton", [
		["2356-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2356-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2356-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2356-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2357" : helpers.makeTestYear("America/Moncton", [
		["2357-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2357-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2357-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2357-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2358" : helpers.makeTestYear("America/Moncton", [
		["2358-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2358-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2358-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2358-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2359" : helpers.makeTestYear("America/Moncton", [
		["2359-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2359-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2359-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2359-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2360" : helpers.makeTestYear("America/Moncton", [
		["2360-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2360-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2360-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2360-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2361" : helpers.makeTestYear("America/Moncton", [
		["2361-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2361-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2361-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2361-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2362" : helpers.makeTestYear("America/Moncton", [
		["2362-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2362-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2362-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2362-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2363" : helpers.makeTestYear("America/Moncton", [
		["2363-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2363-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2363-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2363-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2364" : helpers.makeTestYear("America/Moncton", [
		["2364-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2364-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2364-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2364-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2365" : helpers.makeTestYear("America/Moncton", [
		["2365-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2365-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2365-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2365-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2366" : helpers.makeTestYear("America/Moncton", [
		["2366-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2366-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2366-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2366-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2367" : helpers.makeTestYear("America/Moncton", [
		["2367-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2367-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2367-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2367-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2368" : helpers.makeTestYear("America/Moncton", [
		["2368-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2368-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2368-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2368-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2369" : helpers.makeTestYear("America/Moncton", [
		["2369-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2369-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2369-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2369-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2370" : helpers.makeTestYear("America/Moncton", [
		["2370-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2370-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2370-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2370-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2371" : helpers.makeTestYear("America/Moncton", [
		["2371-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2371-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2371-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2371-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2372" : helpers.makeTestYear("America/Moncton", [
		["2372-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2372-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2372-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2372-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2373" : helpers.makeTestYear("America/Moncton", [
		["2373-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2373-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2373-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2373-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2374" : helpers.makeTestYear("America/Moncton", [
		["2374-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2374-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2374-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2374-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2375" : helpers.makeTestYear("America/Moncton", [
		["2375-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2375-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2375-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2375-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2376" : helpers.makeTestYear("America/Moncton", [
		["2376-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2376-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2376-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2376-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2377" : helpers.makeTestYear("America/Moncton", [
		["2377-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2377-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2377-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2377-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2378" : helpers.makeTestYear("America/Moncton", [
		["2378-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2378-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2378-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2378-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2379" : helpers.makeTestYear("America/Moncton", [
		["2379-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2379-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2379-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2379-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2380" : helpers.makeTestYear("America/Moncton", [
		["2380-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2380-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2380-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2380-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2381" : helpers.makeTestYear("America/Moncton", [
		["2381-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2381-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2381-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2381-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2382" : helpers.makeTestYear("America/Moncton", [
		["2382-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2382-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2382-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2382-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2383" : helpers.makeTestYear("America/Moncton", [
		["2383-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2383-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2383-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2383-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2384" : helpers.makeTestYear("America/Moncton", [
		["2384-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2384-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2384-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2384-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2385" : helpers.makeTestYear("America/Moncton", [
		["2385-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2385-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2385-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2385-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2386" : helpers.makeTestYear("America/Moncton", [
		["2386-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2386-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2386-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2386-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2387" : helpers.makeTestYear("America/Moncton", [
		["2387-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2387-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2387-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2387-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2388" : helpers.makeTestYear("America/Moncton", [
		["2388-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2388-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2388-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2388-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2389" : helpers.makeTestYear("America/Moncton", [
		["2389-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2389-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2389-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2389-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2390" : helpers.makeTestYear("America/Moncton", [
		["2390-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2390-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2390-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2390-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2391" : helpers.makeTestYear("America/Moncton", [
		["2391-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2391-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2391-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2391-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2392" : helpers.makeTestYear("America/Moncton", [
		["2392-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2392-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2392-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2392-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2393" : helpers.makeTestYear("America/Moncton", [
		["2393-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2393-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2393-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2393-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2394" : helpers.makeTestYear("America/Moncton", [
		["2394-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2394-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2394-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2394-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2395" : helpers.makeTestYear("America/Moncton", [
		["2395-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2395-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2395-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2395-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2396" : helpers.makeTestYear("America/Moncton", [
		["2396-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2396-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2396-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2396-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2397" : helpers.makeTestYear("America/Moncton", [
		["2397-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2397-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2397-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2397-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2398" : helpers.makeTestYear("America/Moncton", [
		["2398-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2398-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2398-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2398-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2399" : helpers.makeTestYear("America/Moncton", [
		["2399-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2399-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2399-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2399-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2400" : helpers.makeTestYear("America/Moncton", [
		["2400-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2400-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2400-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2400-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2401" : helpers.makeTestYear("America/Moncton", [
		["2401-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2401-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2401-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2401-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2402" : helpers.makeTestYear("America/Moncton", [
		["2402-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2402-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2402-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2402-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2403" : helpers.makeTestYear("America/Moncton", [
		["2403-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2403-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2403-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2403-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2404" : helpers.makeTestYear("America/Moncton", [
		["2404-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2404-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2404-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2404-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2405" : helpers.makeTestYear("America/Moncton", [
		["2405-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2405-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2405-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2405-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2406" : helpers.makeTestYear("America/Moncton", [
		["2406-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2406-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2406-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2406-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2407" : helpers.makeTestYear("America/Moncton", [
		["2407-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2407-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2407-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2407-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2408" : helpers.makeTestYear("America/Moncton", [
		["2408-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2408-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2408-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2408-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2409" : helpers.makeTestYear("America/Moncton", [
		["2409-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2409-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2409-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2409-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2410" : helpers.makeTestYear("America/Moncton", [
		["2410-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2410-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2410-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2410-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2411" : helpers.makeTestYear("America/Moncton", [
		["2411-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2411-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2411-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2411-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2412" : helpers.makeTestYear("America/Moncton", [
		["2412-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2412-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2412-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2412-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2413" : helpers.makeTestYear("America/Moncton", [
		["2413-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2413-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2413-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2413-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2414" : helpers.makeTestYear("America/Moncton", [
		["2414-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2414-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2414-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2414-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2415" : helpers.makeTestYear("America/Moncton", [
		["2415-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2415-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2415-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2415-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2416" : helpers.makeTestYear("America/Moncton", [
		["2416-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2416-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2416-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2416-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2417" : helpers.makeTestYear("America/Moncton", [
		["2417-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2417-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2417-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2417-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2418" : helpers.makeTestYear("America/Moncton", [
		["2418-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2418-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2418-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2418-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2419" : helpers.makeTestYear("America/Moncton", [
		["2419-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2419-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2419-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2419-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2420" : helpers.makeTestYear("America/Moncton", [
		["2420-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2420-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2420-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2420-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2421" : helpers.makeTestYear("America/Moncton", [
		["2421-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2421-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2421-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2421-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2422" : helpers.makeTestYear("America/Moncton", [
		["2422-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2422-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2422-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2422-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2423" : helpers.makeTestYear("America/Moncton", [
		["2423-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2423-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2423-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2423-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2424" : helpers.makeTestYear("America/Moncton", [
		["2424-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2424-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2424-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2424-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2425" : helpers.makeTestYear("America/Moncton", [
		["2425-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2425-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2425-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2425-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2426" : helpers.makeTestYear("America/Moncton", [
		["2426-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2426-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2426-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2426-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2427" : helpers.makeTestYear("America/Moncton", [
		["2427-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2427-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2427-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2427-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2428" : helpers.makeTestYear("America/Moncton", [
		["2428-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2428-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2428-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2428-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2429" : helpers.makeTestYear("America/Moncton", [
		["2429-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2429-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2429-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2429-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2430" : helpers.makeTestYear("America/Moncton", [
		["2430-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2430-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2430-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2430-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2431" : helpers.makeTestYear("America/Moncton", [
		["2431-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2431-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2431-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2431-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2432" : helpers.makeTestYear("America/Moncton", [
		["2432-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2432-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2432-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2432-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2433" : helpers.makeTestYear("America/Moncton", [
		["2433-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2433-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2433-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2433-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2434" : helpers.makeTestYear("America/Moncton", [
		["2434-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2434-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2434-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2434-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2435" : helpers.makeTestYear("America/Moncton", [
		["2435-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2435-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2435-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2435-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2436" : helpers.makeTestYear("America/Moncton", [
		["2436-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2436-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2436-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2436-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2437" : helpers.makeTestYear("America/Moncton", [
		["2437-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2437-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2437-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2437-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2438" : helpers.makeTestYear("America/Moncton", [
		["2438-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2438-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2438-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2438-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2439" : helpers.makeTestYear("America/Moncton", [
		["2439-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2439-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2439-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2439-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2440" : helpers.makeTestYear("America/Moncton", [
		["2440-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2440-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2440-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2440-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2441" : helpers.makeTestYear("America/Moncton", [
		["2441-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2441-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2441-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2441-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2442" : helpers.makeTestYear("America/Moncton", [
		["2442-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2442-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2442-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2442-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2443" : helpers.makeTestYear("America/Moncton", [
		["2443-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2443-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2443-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2443-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2444" : helpers.makeTestYear("America/Moncton", [
		["2444-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2444-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2444-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2444-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2445" : helpers.makeTestYear("America/Moncton", [
		["2445-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2445-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2445-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2445-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2446" : helpers.makeTestYear("America/Moncton", [
		["2446-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2446-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2446-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2446-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2447" : helpers.makeTestYear("America/Moncton", [
		["2447-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2447-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2447-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2447-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2448" : helpers.makeTestYear("America/Moncton", [
		["2448-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2448-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2448-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2448-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2449" : helpers.makeTestYear("America/Moncton", [
		["2449-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2449-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2449-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2449-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2450" : helpers.makeTestYear("America/Moncton", [
		["2450-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2450-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2450-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2450-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2451" : helpers.makeTestYear("America/Moncton", [
		["2451-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2451-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2451-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2451-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2452" : helpers.makeTestYear("America/Moncton", [
		["2452-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2452-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2452-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2452-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2453" : helpers.makeTestYear("America/Moncton", [
		["2453-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2453-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2453-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2453-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2454" : helpers.makeTestYear("America/Moncton", [
		["2454-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2454-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2454-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2454-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2455" : helpers.makeTestYear("America/Moncton", [
		["2455-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2455-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2455-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2455-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2456" : helpers.makeTestYear("America/Moncton", [
		["2456-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2456-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2456-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2456-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2457" : helpers.makeTestYear("America/Moncton", [
		["2457-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2457-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2457-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2457-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2458" : helpers.makeTestYear("America/Moncton", [
		["2458-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2458-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2458-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2458-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2459" : helpers.makeTestYear("America/Moncton", [
		["2459-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2459-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2459-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2459-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2460" : helpers.makeTestYear("America/Moncton", [
		["2460-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2460-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2460-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2460-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2461" : helpers.makeTestYear("America/Moncton", [
		["2461-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2461-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2461-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2461-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2462" : helpers.makeTestYear("America/Moncton", [
		["2462-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2462-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2462-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2462-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2463" : helpers.makeTestYear("America/Moncton", [
		["2463-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2463-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2463-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2463-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2464" : helpers.makeTestYear("America/Moncton", [
		["2464-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2464-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2464-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2464-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2465" : helpers.makeTestYear("America/Moncton", [
		["2465-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2465-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2465-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2465-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2466" : helpers.makeTestYear("America/Moncton", [
		["2466-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2466-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2466-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2466-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2467" : helpers.makeTestYear("America/Moncton", [
		["2467-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2467-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2467-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2467-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2468" : helpers.makeTestYear("America/Moncton", [
		["2468-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2468-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2468-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2468-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2469" : helpers.makeTestYear("America/Moncton", [
		["2469-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2469-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2469-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2469-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2470" : helpers.makeTestYear("America/Moncton", [
		["2470-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2470-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2470-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2470-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2471" : helpers.makeTestYear("America/Moncton", [
		["2471-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2471-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2471-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2471-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2472" : helpers.makeTestYear("America/Moncton", [
		["2472-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2472-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2472-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2472-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2473" : helpers.makeTestYear("America/Moncton", [
		["2473-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2473-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2473-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2473-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2474" : helpers.makeTestYear("America/Moncton", [
		["2474-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2474-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2474-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2474-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2475" : helpers.makeTestYear("America/Moncton", [
		["2475-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2475-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2475-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2475-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2476" : helpers.makeTestYear("America/Moncton", [
		["2476-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2476-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2476-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2476-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2477" : helpers.makeTestYear("America/Moncton", [
		["2477-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2477-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2477-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2477-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2478" : helpers.makeTestYear("America/Moncton", [
		["2478-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2478-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2478-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2478-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2479" : helpers.makeTestYear("America/Moncton", [
		["2479-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2479-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2479-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2479-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2480" : helpers.makeTestYear("America/Moncton", [
		["2480-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2480-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2480-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2480-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2481" : helpers.makeTestYear("America/Moncton", [
		["2481-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2481-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2481-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2481-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2482" : helpers.makeTestYear("America/Moncton", [
		["2482-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2482-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2482-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2482-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2483" : helpers.makeTestYear("America/Moncton", [
		["2483-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2483-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2483-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2483-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2484" : helpers.makeTestYear("America/Moncton", [
		["2484-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2484-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2484-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2484-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2485" : helpers.makeTestYear("America/Moncton", [
		["2485-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2485-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2485-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2485-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2486" : helpers.makeTestYear("America/Moncton", [
		["2486-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2486-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2486-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2486-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2487" : helpers.makeTestYear("America/Moncton", [
		["2487-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2487-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2487-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2487-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2488" : helpers.makeTestYear("America/Moncton", [
		["2488-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2488-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2488-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2488-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2489" : helpers.makeTestYear("America/Moncton", [
		["2489-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2489-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2489-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2489-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2490" : helpers.makeTestYear("America/Moncton", [
		["2490-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2490-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2490-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2490-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2491" : helpers.makeTestYear("America/Moncton", [
		["2491-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2491-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2491-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2491-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2492" : helpers.makeTestYear("America/Moncton", [
		["2492-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2492-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2492-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2492-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2493" : helpers.makeTestYear("America/Moncton", [
		["2493-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2493-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2493-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2493-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2494" : helpers.makeTestYear("America/Moncton", [
		["2494-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2494-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2494-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2494-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2495" : helpers.makeTestYear("America/Moncton", [
		["2495-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2495-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2495-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2495-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2496" : helpers.makeTestYear("America/Moncton", [
		["2496-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2496-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2496-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2496-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2497" : helpers.makeTestYear("America/Moncton", [
		["2497-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2497-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2497-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2497-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2498" : helpers.makeTestYear("America/Moncton", [
		["2498-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2498-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2498-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2498-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2499" : helpers.makeTestYear("America/Moncton", [
		["2499-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2499-03-08T06:00:00+00:00", "03:00:00", "ADT", 180]
	])
};