/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.swing.ImageIcon;
import javax.swing.UIManager;

import monajat.util.PropertyManager;
import monajat.util.Language_util.Language;
import monajat.util.Language_util.LanguageResource;

public class MonajatMain {
	
	private static MonajatTimer aMonajatTimer;
	
	private static SystemTray tray;
	
	private static TrayIcon icon;
	
	public static void main(String[] args) throws Exception {
//		UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		InitMonajah();
		aMonajatTimer = new MonajatTimer();
		aMonajatTimer.start();
	}
	
	public static void restartMonajat() throws AWTException {
		aMonajatTimer.stop();
		aMonajatTimer = null;
		PropertyManager.sPropertyManager = null;
		LanguageResource.sLanguageResource = null;
 		tray.remove(icon);
		InitMonajah();
		aMonajatTimer = new MonajatTimer();
		aMonajatTimer.start();
	}
	
	public static void InitMonajah() throws AWTException {
		Map<String, Locale> aLanguageMap = new HashMap<String, Locale>();
		aLanguageMap.put("arabic", new Locale("ar"));
		aLanguageMap.put("english", new Locale("en"));
		aLanguageMap.put("french", new Locale("fr"));
		aLanguageMap.put("pashto", new Locale("ps"));
		
		Locale default_language = new Locale("ar");
		String aUserLanguage = PropertyManager.getProperty("language");
		if (aUserLanguage != null && aLanguageMap.containsKey(aUserLanguage.toLowerCase())) {
			Language.setCurrentLocale(aLanguageMap.get(PropertyManager.getProperty("language").toLowerCase()));
		} else {
			Language.setCurrentLocale(default_language);
		}
		UIManager.put("OptionPane.cancelButtonText", LanguageResource.getString("Cancel"));
		UIManager.put("OptionPane.noButtonText", LanguageResource.getString("No"));
		UIManager.put("OptionPane.okButtonText", LanguageResource.getString("Ok"));
		UIManager.put("OptionPane.yesButtonText", LanguageResource.getString("Yes"));
		tray = SystemTray.getSystemTray();
		Image image = new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa.png").getImage();
		icon = new TrayIcon(image, LanguageResource.getString("Monajat"), new MonajatPopupMenu());
		icon.setImageAutoSize(true);
		tray.add(icon);
	}
	
}
