/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import monajat.gui.reusables.FontSetter;
import monajat.gui.reusables.LabeldCheckBoxes;
import monajat.util.LoacationSetter;
import monajat.util.PropertyManager;
import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;

public class MonajatPreferences extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;
	
	private LookPanel mLookPanel;
	
	private DestinationPanel mDestinationPanel;

	public MonajatPreferences() {
		this.setLayout(new BorderLayout());
		this.setIconImage(new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa.png").getImage());
		this.setTitle(LanguageResource.getString("Preferences"));
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setResizable(false);
		this.setForeground(Color.GRAY);
		JPanel aButtonsPanel = new JPanel();
	    aButtonsPanel.setLayout(new FlowLayout());
	    JButton aOpenButton = new JButton(LanguageResource.getString("Save"));
	    JButton aCancelButton = new JButton(LanguageResource.getString("Cancel"));
	    aOpenButton.setActionCommand("Open");
	    aOpenButton.addActionListener(this);
	    aCancelButton.setActionCommand("Cancel");
	    aCancelButton.addActionListener(this);
	    aButtonsPanel.add(OreintationHelper.setJComponentOreintation(aOpenButton));
	    aButtonsPanel.add(OreintationHelper.setJComponentOreintation(aCancelButton));
	    
	    JPanel aMiscPanel = new JPanel();
	    aMiscPanel.setLayout(new FlowLayout());
	    LabeldCheckBoxes aCheckBoxes = new LabeldCheckBoxes("Misc.", "run at startup.");
	    aMiscPanel.add(OreintationHelper.setJComponentOreintation(aCheckBoxes));
	  
	    
	    Panel aPanel = new Panel();
	    mLookPanel = new LookPanel();
	    mDestinationPanel = new DestinationPanel();
	    aPanel.add(OreintationHelper.setJComponentOreintation(mLookPanel), BorderLayout.LINE_START);
	    aPanel.add(OreintationHelper.setJComponentOreintation(mDestinationPanel), BorderLayout.LINE_END);
	    
	    this.setSize(420, 250);
		this.setLocation(LoacationSetter.calculateMiddleLocationOnScreen(getWidth(), getHeight()));
//		this.add(OreintationHelper.setJComponentOreintation(aMiscPanel), BorderLayout.CENTER);
		this.add(aPanel, BorderLayout.PAGE_START);
		
		this.add(aButtonsPanel, BorderLayout.PAGE_END);
		FontSetter.adjustFont(this);
	}

	
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand() == "Cancel") {
			this.dispose();
		} else {
			Properties aUserProperties = new Properties();
			aUserProperties.put("on_screen", mDestinationPanel.getDestination() +"");
			aUserProperties.put("language", mLookPanel.getLangauge());
			aUserProperties.put("show_every", mLookPanel.getShowEvery());
			aUserProperties.put("show_for", mLookPanel.getshowFor());
			try {
				aUserProperties.storeToXML(new FileOutputStream(new File(System.getProperty("user.home"), "monajat_properties.xml")), "this file contains the user properties for the application");
				PropertyManager.reloadUserProperties();
				MonajatTray.restartMonajat();
//				MonajatMain.restartMonajat();
				this.dispose();
			} catch (Exception e1) {
				e1.printStackTrace();
				JOptionPane.showMessageDialog(null, LanguageResource.getString("error saving user preferences!"), "", JOptionPane.OK_OPTION);
			}
		}
		
	}

}
