/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import javax.swing.Timer;

import monajat.doa.Doa;
import monajat.doa.DoaLoader;
import monajat.doa.DoaReader;
import monajat.gui.reusables.MonajatWindow;
import monajat.util.PropertyManager;

public class MonajatTimer {
	
	private Timer mTimer;
	
	public static List<File> sDoaList;
	
	private static int mDoaCount;
	
	private static DoaReader mDoaReader;

	public MonajatTimer() {
		mDoaCount = 0;
		mDoaReader = new DoaReader();
		sDoaList = new ArrayList<File>();
		sDoaList = DoaLoader.loadDoa();
		Collections.shuffle(sDoaList, new Random());
	}
	
	void start() {
		int showEvery = 5;
		try {
			showEvery = Integer.parseInt(PropertyManager.getProperty("show_every"));
		} catch (NumberFormatException e) {
			showEvery = 5;
		}
		mTimer = new Timer(showEvery * 60 * 1000, new timerActionListener());
		mTimer.start();
	}
	
	public class timerActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			showDoa();
		}
	}
	
	public static void showDoa() {
		if (mDoaCount == MonajatTimer.getDoaList().size()) {
			mDoaCount = 0;
			Collections.shuffle(sDoaList, new Random());
		}
		Doa aDoa = mDoaReader.getDoa(sDoaList.get(mDoaCount++));
		if (aDoa != null) {
			new MonajatWindow(aDoa);
		} else {
			while(aDoa == null) {
				if (mDoaCount == MonajatTimer.getDoaList().size()) {
					mDoaCount = 0;
					Collections.shuffle(sDoaList, new Random());
				}
				aDoa = mDoaReader.getDoa(sDoaList.get(mDoaCount++));
			}
			new MonajatWindow(aDoa);
		}
	}
	
	public static void main(String[] args) {
		new MonajatTimer().start();
	}

	public static List<File> getDoaList() {
		return sDoaList;
	}

	public static void setDoaList(List<File> pDoaList) {
		sDoaList = pDoaList;
	}

	public void stop() {
		mTimer.stop();
	}

}
