/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;


import java.awt.BorderLayout;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class LabeldComboBox extends JPanel {

	private static final long serialVersionUID = 1L;

	private JComboBox mNamedComboBox = new JComboBox();
	
	public LabeldComboBox(String pName,Object defaul ,String... pElements) {
		super();
		this.setLayout(new VerticalBagLayout());
		JPanel aNamePanel = new JPanel();
		aNamePanel.setLayout(new BorderLayout());
		JLabel aNameLabel = new JLabel(LanguageResource.getString(pName));
//		FontSetter.setFont(aNameLabel, 13);
		aNameLabel.setLabelFor(this.mNamedComboBox);
		aNamePanel.add(OreintationHelper.setJComponentOreintation(aNameLabel), BorderLayout.PAGE_START);
		aNamePanel.add(OreintationHelper.setJComponentOreintation(this.mNamedComboBox), BorderLayout.CENTER);
		for (String aString : pElements) {
			this.mNamedComboBox.addItem(aString);
		}
		this.mNamedComboBox.setSelectedItem(defaul);
		aNamePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		this.add(aNamePanel);
	}

	public JComboBox getNamedComboBox() {
		return this.mNamedComboBox;
	}

	public void setNamedComboBox(JComboBox pNamedComboBox) {
		this.mNamedComboBox = pNamedComboBox;
	}

}
