/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;


import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.border.EmptyBorder;

import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class LabeldSpinner extends JPanel {

	private static final long serialVersionUID = 1L;

	private JSpinner mNamedJSpinner;
	
	public LabeldSpinner(String pName,Object defaul ,String... pElements) {
		super();
		SpinnerModel model = new SpinnerListModel(pElements);
		mNamedJSpinner = new JSpinner(model);
		this.setLayout(new VerticalBagLayout());
		JPanel aNamePanel = new JPanel();
		aNamePanel.setLayout(new BorderLayout());
		JLabel aNameLabel = new JLabel(LanguageResource.getString(pName));
//		FontSetter.setFont(aNameLabel, 13);
		aNameLabel.setLabelFor(this.mNamedJSpinner);
		aNamePanel.add(OreintationHelper.setJComponentOreintation(aNameLabel), BorderLayout.PAGE_START);
		aNamePanel.add(OreintationHelper.setJComponentOreintation(this.mNamedJSpinner), BorderLayout.CENTER);
		mNamedJSpinner.setValue(defaul + "");
		aNamePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		this.add(aNamePanel);
	}

	public JSpinner getNamedJSpinner() {
		return this.mNamedJSpinner;
	}

	public void setNamedJSpinner(JSpinner pNamedComboBox) {
		this.mNamedJSpinner = pNamedComboBox;
	}

}
