/* libmondo-filelist.c

- for subroutines which manipulate the filelist

06/06
- fixed silly bug in load_filelist() which stopped
  funny German filenames from being handled properly

26/04/2003
- max_sane_size_for_a_file = maxsetsizeK *2
- maximum is also now 32MB

10/01 - 10/31/2002
- don't make large .bz2 or .tbz files into biggiefiles
- max_sane_size_for_a_file = maxsetsizeK*8, or 64MB
  ...whichever is smaller

08/01 - 08/31
- if last filelist is <=2 bytes long then delete it
- max_sane_size_for_a_file = maxsetsizeK
  (was SLICESIZE*4 or something)
- cleaned up some log_it() calls

07/26
- started
*/

#include "my-stuff.h"
#include "mondostructures.h"
#include "lib-common-externs.h"
#include "libmondo-filelist.h"
#include "libmondo-string-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-tools-EXT.h"


long g_original_noof_lines_in_filelist = 0;	/*purpose */






long g_noof_sets=0;
extern bool g_text_mode;
extern newtComponent g_progressForm;
extern int g_currentY;



/*************************************************************************
 * call_filelist_chopper() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:   Call the subroutine which chops up the filelist into sets  *
 * Called by: main()                                                     *
 * Params:    bkpinfo           configuration structure                  *
 * Returns:   void                                                       *
 *************************************************************************/
void
call_filelist_chopper (struct s_bkpinfo *bkpinfo)
{
	/** buffers ************************/
  char dev[MAX_STR_LEN];
  char filelist[MAX_STR_LEN];
  char tempfile[MAX_STR_LEN];
  char cksumlist[MAX_STR_LEN];
  long noof_sets;

	/** pointers ***********************/
  char *ptr;
  FILE *fout;

	/** int ****************************/
  int i;

  mvaddstr_and_log_it (g_currentY, 0, "Dividing filelist into sets");

  log_to_screen ("Dividing filelist into sets. Please wait.");

  sprintf (filelist, "%s/archives/filelist.full", bkpinfo->scratchdir);
  sprintf (cksumlist, "%s/cklist.full", bkpinfo->tmpdir);

  noof_sets = chop_filelist (filelist, bkpinfo->tmpdir, bkpinfo->optimal_set_size);
//  estimate_noof_media_required (bkpinfo, noof_sets);

  sprintf (tempfile, "%s/biggielist.txt", bkpinfo->tmpdir);
  if (!(fout = fopen (tempfile, "a")))
    {
      fatal_error ("Cannot append to biggielist.txt");
    }
  log_it (bkpinfo->image_devs);

  ptr = bkpinfo->image_devs;

  while (ptr && *ptr)
    {
      strcpy (dev, ptr);
      log_it ("Examining imagedev %s", dev);
      for (i = 0; i < strlen (dev) && dev[i] != ' '; i++);
      dev[i] = '\0';
      if (!strlen (dev))
	{
	  continue;
	}
      fprintf (fout, "%s\n", dev);
      log_it ("Adding '%s' to biggielist", dev);
      if ((ptr = strchr (ptr, ' ')))
	{
	  ptr++;
	}
    }
  fclose (fout);
  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
}



/*************************************************************************
 * chop_filelist() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:   Chop up the filelist into filesets (each set being a list  *
 *            of files whose total size <=X MB before compression) and   *
 *            a biggielist (list of files >X MB in size, to be archived  *
 *            separately from the regular filesets).                     *
 * Called by: call_filelist_chopper()                                    *
 * Params:    filelist          text file containing list of all files   *
 *            outdir            directory to which the filesets and the  *
 *                              biggielist will be written               *
 *            maxsetsizeK       maximum size of a fileset (uncompressed) *
 * Returns:   0=failure; nonzero=number of filesets                      *
 *************************************************************************/
int
chop_filelist (char *filelist, char *outdir, long maxsetsizeK)
{
/** long ****************************************/
  long lino = 0;
  long max_sane_size_for_a_file;
  long curr_set_size;
  long noof_lines;
  long siz;

	/** int *****************************************/
  int i;
  long curr_set_no;

	/** buffers **************************************/
  char outfname[1000];
  char biggie_fname[1000];
  char incoming[1000];
  char tmp[1000];

	/** pointers ************************************/
  FILE *fin;
  FILE *fout;
  FILE *fbig;

	/** structures **********************************/
  struct stat buf;
  long noof_filesets;

  max_sane_size_for_a_file = maxsetsizeK*2;
  if (max_sane_size_for_a_file > 32*1024)
    { max_sane_size_for_a_file = 32*1024; }
  log_it("filelist=%s;", filelist);
  open_evalcall_form ("Dividing filelist into sets");
  noof_lines = count_lines_in_file (filelist);
  fin = fopen (filelist, "r");
  curr_set_no = 0;
  curr_set_size = 0;
  sprintf (outfname, "%s/filelist.%ld", outdir, curr_set_no);
  sprintf (biggie_fname, "%s/biggielist.txt", outdir);
  if (!(fbig = fopen (biggie_fname, "w")))
    {
      sprintf (tmp, "unable to open %s\n", biggie_fname);
      fatal_error (tmp);
    }
  if (!(fout = fopen (outfname, "w")))
    {
      sprintf (tmp, "unable to open %s\n", outfname);
      fatal_error (tmp);
    }

  fgets (incoming, 999, fin);
  while (!feof (fin))
    {
      lino++;
      i = strlen (incoming) - 1;
      if (i < 0)
	{
	  i = 0;
	}
      if (incoming[i] < 32)
	{
	  incoming[i] = '\0';
	}
      if (!strncmp (incoming, "/dev/", 5))
	{
	  siz = 1;
	}
      else if (lstat (incoming, &buf) != 0)
	{
	  siz = 0;
	}
      else
	{
	  siz = buf.st_size >> 10;
	}
      if (siz > max_sane_size_for_a_file)
// && strcmp(incoming+strlen(incoming)-4, ".bz2") && strcmp(incoming+strlen(incoming)-4, ".tbz"))
	{
	  fprintf (fbig, "%s\n", incoming);
	}
      else
	{
	  curr_set_size += siz;
	  fprintf (fout, "%s\n", incoming);
	  if (curr_set_size > maxsetsizeK)
	    {
	      fclose (fout);
	      curr_set_no++;
	      curr_set_size = 0;
	      sprintf (outfname, "%s/filelist.%ld", outdir, curr_set_no);
	      fout = fopen (outfname, "w");
	      sprintf (tmp, "Fileset #%ld chopped ", curr_set_no - 1);
	      update_evalcall_form ((int) (lino * 100 / noof_lines));
	      /*              if (!g_text_mode) {newtDrawRootText(0,22,tmp);newtRefresh();} else {log_it(tmp);} */
	    }
	}
      fgets (incoming, 999, fin);
    }
  fclose (fin);
  fclose (fout);
  fclose (fbig);
  if (length_of_file(outfname) <= 2)
    {
      unlink(outfname);
      g_noof_sets --;
    }
  g_noof_sets = curr_set_no;
  sprintf (tmp, "echo %ld > %s/LAST-FILELIST-NUMBER", curr_set_no, outdir);
  system (tmp);
  if (curr_set_no == 0)
    {
      sprintf (tmp, "Only one fileset. Fine.");
    }
  else
    {
      sprintf (tmp, "Filelist divided into %ld sets", curr_set_no + 1);
    }
  log_to_screen (tmp);
  close_evalcall_form ();
  /* This is to work around an obscure bug in Newt; open a form, close it,
     carry on... I don't know why it works but it works. If you don't do this
     then update_progress_form() won't show the "time taken / time remaining"
     line. The bug only crops up AFTER the call to chop_filelist(). Weird. */
#ifndef _XWIN
  if (!g_text_mode)
    {
      open_progress_form ("", "", "", "", 100);
      newtPopHelpLine ();
      newtFormDestroy (g_progressForm);
      newtPopWindow ();
    }
#endif
  return (noof_filesets);
}


/*************************************************************************
 * free_filelist() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
free_filelist (struct s_node *filelist)
{
	/** int's ********************************************************/
  static int depth = 0;
  int percentage;

	/** long's *******************************************************/
  static long i = 0;

	/** end vars *****************************************************/

  if (depth == 0)
    {
      open_evalcall_form ("Freeing memory");
      log_to_screen ("Freeing memory formerly occupied by filelist");
    }
  depth++;

  if (filelist->ch == '\0')
    {
      if (!(i++ % 1111))
	{
	  percentage = (int) (i * 100 / g_original_noof_lines_in_filelist);
	  update_evalcall_form (percentage);

	}
    }

  if (filelist->right)
    {
      free_filelist (filelist->right);
      filelist->right = NULL;
    }
  if (filelist->down)
    {
/*      if (!(i++ %39999)) { update_evalcall_form(0); } */
      free_filelist (filelist->down);
      filelist->down = NULL;
    }
  filelist->ch = '\0';
  free (filelist);
  depth--;
  if (depth == 0)
    {
      close_evalcall_form ();
      log_it ("Finished freeing memory");
    }
}




/*************************************************************************
 * get_last_filelist_number() -- Hugo Rabson                             *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
get_last_filelist_number (struct s_bkpinfo *bkpinfo)
{
	/** buffers ******************************************************/
  char val_sz[MAX_STR_LEN];
  char cfg_fname[MAX_STR_LEN];
/*  char tmp[MAX_STR_LEN]; remove stan benoit apr 2002 */

	/** long *********************************************************/
  long val_i;

	/** end vars *****************************************************/

  sprintf (cfg_fname, "%s/mondo-restore.cfg", bkpinfo->tmpdir);
  read_cfg_var (cfg_fname, "last-filelist-number", val_sz);
  val_i = atoi (val_sz);
  if (val_i <= 0)
    {
      val_i = 500;
    }
  return (val_i);

/*
  FILE*fin;
  char fname[MAX_STR_LEN],incoming[MAX_STR_LEN+1];
  int res=-1,i;
  sprintf(fname, "%s/LAST-FILELIST-NUMBER",bkpinfo->tmpdir);
  fin=fopen(fname,"r");
  if (fin)
    {
      fgets(incoming,MAX_STR_LEN,fin);
      fclose(fin);
      for(i=strlen(incoming); incoming[i-1]<32; i--);
      incoming[i]='\0';
      res=atoi(incoming);
    }
  else
    {
      log_it("WARNING - unable to find LAST-FILELIST-NUMBER");
    }
  return(res);
*/
}



/*************************************************************************
 * add_string_at_node() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
add_string_at_node (struct s_node *startnode, char *string_to_add)
{
	/** int *********************************************************/
  int noof_chars;
  int i;

	/** sturctures **************************************************/
  struct s_node *node, *newnode;

	/** char  *******************************************************/
  char char_to_add;

	/** bools *******************************************************/
  const bool sosodef = FALSE;


  noof_chars = strlen (string_to_add) + 1;	/* we include the '\0' */

/* walk across tree */
  node = startnode;
  char_to_add = string_to_add[0];
  for (node = startnode; node->right != NULL && node->ch < char_to_add;
       node = node->right);

/* walk down tree if appropriate */
  if (node->ch == char_to_add)
    {
      if (noof_chars == 1 && char_to_add == '\0')
	{
	  log_it ("Already present. ");
	  return (1);
	}
      if (!node->down)
	{
	  log_it ("Partially listed but it carries on and I don't");
	  return (1);
	}
      return (add_string_at_node (node->down, string_to_add + 1));
    }

/* else, add node(s) here */
  if (!(newnode = (struct s_node*)malloc (sizeof (struct s_node))))
    {
      log_to_screen ("failed to malloc");
      return (1);
    }

  memcpy (newnode, node, sizeof (struct s_node));
  node->right = newnode;
  node->ch = char_to_add;
  node->down = NULL;
  node->expanded = node->selected = FALSE;

  if (char_to_add == '\0')
    {
      node->selected = sosodef;
      return (0);
    }
  for (i = 1; i < noof_chars; i++)
    {
      if (!(node->down = (struct s_node*)malloc (sizeof (struct s_node))))
	{
	  log_to_screen ("failed to malloc");
	  return (1);
	}
      node = node->down;
      char_to_add = string_to_add[i];
      node->ch = char_to_add;
      node->right = node->down = NULL;
      node->expanded = node->selected = FALSE;
    }
  if (char_to_add == '\0')
    {
      node->selected = sosodef;
      return (0);
    }
  return (0);
}





/*************************************************************************
 * load_filelist() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
struct s_node *
load_filelist (char *filelist_fname)
{

	/** structures **************************************************/
  struct s_node *filelist;

	/** pointers ****************************************************/
  FILE *fin;

	/** buffers *****************************************************/
  char fname[MAX_STR_LEN];

	/** int *********************************************************/
  int percentage;

	/** long ********************************************************/
  long lines_in_filelist;
  long lino = 0;
	/** end vars ****************************************************/

  log_to_screen ("Loading filelist");
  lines_in_filelist = count_lines_in_file (filelist_fname);
  g_original_noof_lines_in_filelist = lines_in_filelist;
  if (!(filelist = (struct s_node*)malloc (sizeof (struct s_node))))
    {
      return (NULL);
    }
  filelist->ch = '\0';
  filelist->right = filelist->down = NULL;
  filelist->expanded = filelist->selected = FALSE;
  if (!(fin = fopen (filelist_fname, "r")))
    {
      return (NULL);
    }
  open_evalcall_form ("Loading filelist from disk");
  for (fgets (fname, MAX_STR_LEN, fin); !feof (fin);
       fgets (fname, MAX_STR_LEN, fin))
    {
      if ((fname[strlen(fname)-1]==13 || fname[strlen(fname)-1]==10) && strlen(fname)>0)
        { fname[strlen(fname)-1] = '\0'; }
//      strip_spaces (fname);
      if (!strlen (fname))
	{
	  continue;
	}
      if (add_string_at_node (filelist, fname))
	{
	  log_it ("Did not load '%s' into filelist", fname);
	}
      if (!(++lino % 1111))
	{
	  percentage = (int) (lino * 100 / lines_in_filelist);
	  update_evalcall_form (percentage);
	}
    }
  fclose (fin);
  close_evalcall_form ();
  log_it ("Finished loading filelist");
  return (filelist);
}







/*************************************************************************
 * reload_filelist() -- Hugo Rabson                                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
reload_filelist (struct s_node *filelist)
{
  toggle_node_selection (filelist, FALSE);
  toggle_path_expandability (filelist, "/", FALSE);
  toggle_all_root_dirs_on (filelist);
}




/*************************************************************************
 * save_filelist() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
save_filelist (struct s_node *filelist, char *outfname)
{
	/** int **********************************************************/
  static int len = 0;
  static int percentage;
  static int depth = 0;

	/** buffers ******************************************************/
  static char str[MAX_STR_LEN];

	/** structures ***************************************************/
  struct s_node *node;

	/** pointers *****************************************************/
  static FILE *fout = NULL;

	/** long *********************************************************/
  static long lines_in_filelist = 0;
  static long lino = 0;

	/** end vars ****************************************************/

  if (depth == 0)
    {
      log_to_screen ("Saving filelist");
      fout = fopen (outfname, "w");
      lines_in_filelist = g_original_noof_lines_in_filelist;	/* set by load_filelist() */
      open_evalcall_form ("Saving selection to disk");
    }
  depth++;
  for (node = filelist; node != NULL; node = node->right)
    {
      str[len] = node->ch;
      if (!node->ch)
	{
	  if (node->selected)
	    {
	      fprintf (fout, "%s\n", str);
	    }
	  if (!(++lino % 1111))
	    {
	      percentage = (int) (lino * 100 / lines_in_filelist);
	      update_evalcall_form (percentage);
	    }
	}
      if (node->down)
	{
	  len++;
	  save_filelist (node->down, "");
	  len--;
	}
    }
  depth--;
  if (depth == 0)
    {
      fclose (fout);
      fout = NULL;
      close_evalcall_form ();
      log_it ("Finished saving filelist");
    }
}




/*************************************************************************
 * toggle_all_root_dirs_on() -- Hugo Rabson                              *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
toggle_all_root_dirs_on (struct s_node *filelist)
{
	/** structures ***************************************************/
  struct s_node *node;

	/** int **********************************************************/
  static int depth = 0;
  static int root_dirs_expanded;

	/** buffers ******************************************************/
  static char filename[MAX_STR_LEN];

	/** end vars ****************************************************/
  if (depth == 0)
    {
      log_it ("Toggling all root dirs ON");
      root_dirs_expanded = 0;
    }
  for (node = filelist; node != NULL; node = node->right)
    {
      filename[depth] = node->ch;
      if (node->ch == '\0' && strlen (filename) > 1
	  && (!strchr (filename + 1, '/')))
	{
	  node->selected = FALSE;
	  node->expanded = TRUE;
//	  log_it (filename);
	  root_dirs_expanded++;
	}
      if (node->down)
	{
	  depth++;
	  toggle_all_root_dirs_on (node->down);
	  depth--;
	}
    }
  if (depth == 0)
    {
      log_it ("Finished toggling all root dirs ON");
    }
}



/*************************************************************************
 * toggle_path_expandability() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
toggle_path_expandability (struct s_node *filelist, char *pathname,
			   bool on_or_off)
{

	/** int *********************************************************/
  static int depth = 0;
  static int total_expanded;
  static int root_depth;
  int j;
	/** structures **************************************************/
  struct s_node *node;

	/** buffers *****************************************************/
  static char current_filename[MAX_STR_LEN];

/*  char tmp[MAX_STR_LEN+2]; */

	/** end vars ****************************************************/
  if (depth == 0)
    {
      total_expanded = 0;
//      log_it ("Toggling path's expandability");
      for (root_depth = strlen (pathname);
	   root_depth > 0 && pathname[root_depth - 1] != '/'; root_depth--);
      if (root_depth < 2)
	{
	  root_depth = strlen (pathname);
	}
    }
  for (node = filelist; node != NULL; node = node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down)
	{
	  depth++;
	  toggle_path_expandability (node->down, pathname, on_or_off);
	  depth--;
	}
      if (node->ch == '\0')
	{
	  if (!strncmp (pathname, current_filename, strlen (pathname)))
	    {
	      for (j = root_depth;
		   current_filename[j] != '/' && current_filename[j] != '\0';
		   j++);
	      if (current_filename[j] != '\0')
		{
		  for (j++;
		       current_filename[j] != '/'
		       && current_filename[j] != '\0'; j++);
		}
	      if (current_filename[j] == '\0')
		{
/*                  sprintf(tmp,"j=%d; root_depth=%d; stem(path)=%s; stem(curr)=%s",j,root_depth,pathname+j, current_filename+j);
                  log_it(tmp); */
		  node->expanded =
		    (!strcmp (pathname, current_filename) ? TRUE : on_or_off);
		}
	    }
	}
      if (node->expanded)
	{
	  if (total_expanded < ARBITRARY_MAXIMUM - 32
	      || !strrchr (current_filename + strlen (pathname), '/'))
	    {
	      total_expanded++;
	    }
	  else
	    {
	      node->expanded = FALSE;
	    }
	}
    }
  if (depth == 0)
    {
//      log_it ("Finished toggling expandability");
    }
}


/*************************************************************************
 * toggle_path_selection() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
toggle_path_selection (struct s_node *filelist, char *pathname,
		       bool on_or_off)
{
	/** int **********************************************************/
  static int depth = 0;
  int j;

	/** structures ***************************************************/
  struct s_node *node;

	/** buffers ******************************************************/
  static char current_filename[MAX_STR_LEN];
  char tmp[MAX_STR_LEN + 2];

	/** end vars ****************************************************/
  if (depth == 0)
    {
      log_it ("Toggling path's selection");
    }
  for (node = filelist; node != NULL; node = node->right)
    {
      current_filename[depth] = node->ch;
      if (node->down)
	{
	  depth++;
	  toggle_path_selection (node->down, pathname, on_or_off);
	  depth--;
	}
      if (node->ch == '\0')
	{
	  if (!strncmp (pathname, current_filename, strlen (pathname)))
	    {
	      for (j = 0;
		   pathname[j] != '\0' && pathname[j] == current_filename[j];
		   j++);
	      if (current_filename[j] == '/' || current_filename[j] == '\0')
		{
		  node->selected = on_or_off;
		  sprintf (tmp, "%s is now %s\n", current_filename,
			   (on_or_off ? "ON" : "OFF"));
		}
	    }
	}
    }
  if (depth == 0)
    {
      log_it ("Finished toggling selection");
    }
}



/*************************************************************************
 * toggle_node_selection() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
toggle_node_selection (struct s_node *filelist, bool on_or_off)
{
	/** structure ***************************************************/
  struct s_node *node;

	/** end vars ****************************************************/
  for (node = filelist; node != NULL; node = node->right)
    {
      if (node->ch == '/')
	{
	  continue;
	}			/* don't go deep */
      if (node->ch == '\0')
	{
	  node->selected = on_or_off;
	}
      if (node->down)
	{
	  toggle_node_selection (node->down, on_or_off);
	}
    }
}













/*************************************************************************
 * prepare_filelist() -- Hugo Rabson                                     *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
prepare_filelist (struct s_bkpinfo *bkpinfo)
{

	/** int *****************************************************/
  int res = 0;

	/** buffers *************************************************/
  char command[MAX_STR_LEN*2];

	/** i don't have any idea ***********************************/
  pid_t pid;

  log_it ("tmpdir=%s; scratchdir=%s", bkpinfo->tmpdir,
	   bkpinfo->scratchdir);
  sprintf (command, "mondo-makefilelist \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"",
	   MONDO_LOGFILE, bkpinfo->tmpdir, bkpinfo->scratchdir,
	   bkpinfo->include_paths, bkpinfo->exclude_paths);
  log_it( "command = %s", command);
  if (system ("which mondo-makefilelist > /dev/null 2> /dev/null"))
    {
      fatal_error ("Cannot find mondo-makefilelist");
    }
  mvaddstr_and_log_it (g_currentY, 0,
		       "Making catalog of files to be backed up");
  if (bkpinfo->differential)
    {
      strcat (command, " yes");
    }
  else
    {
      strcat (command, " \"\"");
    }
  log_it (command);
#ifdef _XWIN
      open_evalcall_form ("Making catalog of filesystem");
      system (command);
      close_evalcall_form ();
#else
  pid = fork ();
  switch (pid)
    {
    case -1:
      fatal_error ("Forking error");
    case 0:
      system (command);
      exit (0);
    default:
      open_evalcall_form ("Making catalog of filesystem");
      while (!waitpid (pid, (int *) 0, WNOHANG))
	{
	  sleep (1);
	  update_evalcall_form (0);
	}
      close_evalcall_form ();
      mvaddstr_and_log_it (g_currentY++, 74, "Done.");
    }
#endif

  return (res);
}



















