/* my-stuff.h


05/06
- added lots of #define's from 1.7x

04/24/2003
- added assert.h

11/22/2002
- added INTERNAL_TAPE_BLK_SIZE

10/10
- use #define to create XMondo-friendly log file name if appropriate

08/30
- changed ARBITRARY_MAXIMUM to 512

08/26
- set MAX_STR_LEN at 512 but halved it within many _structures_
- changed ARBITRARY_MAXIMUM to 128

08/08
- added '#include <signal.h>'
- added WELCOME_STRING

06/19
- changed tape block size from 8192 to 65536

04/08
- added manual_cd_tray flag to bkpinfo

03/31
- added restore_path to struct s_bkpinfo

03/21
- updated version# to 1.42

02/20
- added bkpinfo->using_cdstream

02/06
- added MONDO_VERSION

02/02
- added MONDO_CFG_FILE
- added SLICE_SIZE

01/31
- removed MINDI_HOME: it is unnecessary
- replaced MONDO_HOME with variable g_mondo_home

01/25
- added MONDO_HOME, MINDI_HOME

01/21
- added s_node{} structure

01/17
- added sys/shm.h, types.h, ipc.h

01/02/2002
- added that groovy bkpinfo{} stuff

11/29/2001
- added raidlist{} struct

08/27
- stuff
*/

#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <getopt.h>
#include <assert.h>
#include <errno.h>
#include <stddef.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>
#include <curses.h>
#include <newt.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <pthread.h>


#ifdef DEBUG
int count;
char trace_log[255];		/*buffer for logging */
char *trace_log_ptr;
#endif /* DEBUG */





/*#define MONDO_VERSION "1.43"*/

/** added for debugging Stan Benoit 21 apr 2002 **/
#define MONDO_TRACEFILE	"/var/log/mondo-tracefile.log"
/** DEBUG add ****/


#define CRC_M16	0xA001		/* crc-16 mask */
#define	CRC_MTT	0x1021		/* crc-ccitt mask */

#define FALSE 0
#define TRUE 1

#define SCREEN_LENGTH 25
#define NOOF_ERR_LINES 6
#define ARBITRARY_MAXIMUM 512	/* max items in mountlist, filelist editor window */
#define MAX_STR_LEN 512
#define MAXIMUM_RAID_DEVS 32
#define MAXIMUM_ADDITIONAL_RAID_VARS 32
#define MAXIMUM_DISKS_PER_RAID_DEV 32

#define RAIDTAB_FNAME "/etc/raidtab"

#define BLK_START_OF_BACKUP     1
#define BLK_START_OF_TAPE       2
#define BLK_START_AFIOBALLS	10
#define BLK_STOP_AFIOBALLS	19
#define BLK_START_AN_AFIO_OR_SLICE    	20
#define BLK_STOP_AN_AFIO_OR_SLICE	29
#define BLK_START_BIGGIEFILES	30
#define BLK_STOP_BIGGIEFILES	39
#define BLK_START_A_BIGGIE	40
#define BLK_STOP_A_BIGGIE	59
#define BLK_START_FILE          80
#define BLK_STOP_FILE           89
#define BLK_END_OF_TAPE         100
#define BLK_END_OF_BACKUP       101
#define BLK_ABORTED_BACKUP      102
#define TAPE_BLOCK_SIZE 131072L	/* was 8192; 06/2002-->65536; 11/2002-->131072 */
#define INTERNAL_TAPE_BLK_SIZE 32768L /* 11/2002 */

//#define TAPE_BUF_SIZE           1*1024
//#define NOOF_TAPE_BUFS          4



#define SLICE_SIZE 8192







#define IS_THIS_A_STREAMING_BACKUP(x) (x == tape || x == udev || x == cdstream)


#define MONDO_MKISOFS_NONBOOT	"mkisofs -r -p MondoRescue -P www.mondorescue.com -A Mondo_Rescue_GPL_Version -V _CD#_"
#define MONDO_MKISOFS_REGULAR_SYSLINUX	"mkisofs -b isolinux.bin -no-emul-boot -boot-info-table -c boot.cat -boot-load-size 4 -r -p MondoRescue -P www.mondorescue.com -A Mondo_Rescue_GPL_Version -V _CD#_"
#define MONDO_MKISOFS_REGULAR_LILO      "mkisofs -b images/mindi-boot.2880.img -c boot.cat -J -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL -V _CD#_"
#define MONDO_TMPISOS "/temporary.iso"


#define WELCOME_STRING "W E L C O M E   T O   M O N D O   R E S C U E"


//#define strcpy(y,x) strncpy(y, x, sizeof(y)-1)


#define malloc_global_string(x) { x = malloc(MAX_STR_LEN); if (!x) { fatal_error("Unable to malloc"); } }




#ifdef _XWIN
  #define MONDO_LOGFILE         "g_xmondo_logfile"
#else
  #define MONDO_LOGFILE           "/var/log/mondo-archive.log"
#endif


#define MALLOC_CHECK_ 1



#define assert_string_is_neither_NULL_nor_zerolength(x) {assert(x!=NULL);assert(x[0]!='\0');}
#define log_OS_error(x) {log_it("%s, line %ld: %s (%s)", __FILE__, __LINE__, x, strerror(errno));}
#define assert_pointer_is_not_NULL(x) {assert(x!=NULL);}
#define paranoid_fclose(x) {if(fclose(x)) {log_OS_error("fclose err");} x=NULL; }
#define paranoid_pclose(x) {if(pclose(x)) {log_OS_error("pclose err");} x=NULL; }
#define paranoid_system(x) {if(system(x)) log_OS_error(x); }
#define paranoid_free(x) {free(x); x=NULL;}
#define paranoid_finish(x) {free_global_filenames (); paranoid_free ( g_bkpinfo_DONTUSETHIS ); finish(x); }
#define iamhere(x) {log_it("%s, %s, %d: %s", __FILE__, __FUNCTION__, __LINE__, x);}
