/***************************************************************************
mondo-cli.c  
-------------------
begin                : Fri Apr 19 16:40:35 EDT 2002
copyright						 : (C) 2002 Mondo  Hugo Rabson
email								 : Hugo Rabson <hugo@firstlinux.net>
edited by            : by Stan Benoit 4/2002
email                : troff@nakedsoul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
UPDATE LOG


07/23
- cleaned up -E

07/14
- fatal error if -E too short

05/14
- if 'n' and user doesn't have rights to write to output dir
  then error out

04/21
- line 550 or so --- resolve boot device ('-f') if softlink

04/08
- changed a bunch of fprintf(stderr,...)'s to log_it()'s
- fixed final / removal in retrieve_switches_from_command_line()

03/15
- reject relative paths if -d flag (Alessandro Polverini)


02/10/2003
- added -e [do not eject while restoring]

12/13/2002
- various strcpy() calls replaced with strncpy() calls

12/10
- added g_loglevel

11/25
- line 614 --- if commmand-line param ends in '/' then drop that '/'

11/19
- rewrote finish() to kill processes more softly
- if user calls with '-l RAW' then 

09/01 - 09/30
- added -N to let user exclude all NFS-related mounts and devices
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_

08/01 - 08/31
- if no device specified when backing up to tape streamer then assume /dev/st0
- abort if tape user specifies tape size (just for testing porpoises)
- tape users no longer need to specify tape size
- added some comments
- added bkpinfo->backup_media_type
- renamed from mondo-archive.c to mondo-cli.c

07/01 - 07/31
- better check for mkfs.vfat
- more sanity-checking for -d flag
- if isodir does not exist then abort
- removed "the rest are..." comment from log
- do not permit '-H' and '-t' in the same command line
- if not '-o' then insist on vfat-friendly kernel

06/01 - 06/30
- added signal-trapping
- added '-W' (won't make bootable CD or floppies) flag
- added missing 'j++' to -s switch's code
- expanded -s switch
- added -u switch
- if dvdrecord exists and cdrecord doesn't then use
  dvdrecord instead of cdrecord

04/01 - 04/30
- if CD-ROM is supermounted then unmount, run, and remount
- replace MONDO_VERSION #define with VERSION from ../config.h
- if CD-ROM is mounted at start then abort
- improved homedir-locating code
- improved "backup will occupy N CD's" calculation a bit
- added -m (manual CD tray) flag


*******************************************************************/
#include <pthread.h>
#include "../common/config.h"
#include "../common/my-stuff.h"
#include "../common/mondostructures.h"
#include "mondo-cli-EXT.h"
#include "../common/libmondo.h"


extern int g_loglevel;
extern bool g_text_mode, g_skip_floppies;
extern char g_startdir[MAX_STR_LEN];
extern char g_erase_tmpdir_and_scratchdir[MAX_STR_LEN];
extern char g_tmpfs_mountpt[MAX_STR_LEN];

extern char *resolve_softlinks_to_get_to_actual_device_file(char*);

/** file pointer **************************************************/
extern FILE *g_tape_stream;

/** long long *****************************************************/
extern long long g_tape_posK;

/** long **********************************************************/
extern long g_noof_sets;

/** bool******** **************************************************/
bool g_debugging = FALSE;
bool g_running_live = FALSE;
extern bool g_cd_recovery;
bool g_ISO_restore_mode = FALSE;

/*int current_backup_media;*/

/** newt ***********************************************************/


extern int g_current_media_number;



extern pid_t g_main_pid;


/** dummies functions **********************************************/






/*************************************************************************
 * handle_incoming_parameters() -- Hugo Rabson                           *
 *                                                                       *
 * Purpose:   Process mondoarchive's command line.  Populate bkpinfo.    *
 * Called by: main()                                                     *
 * Params:    argc, argv[]           command line                        *
 *            bkpinfo                backup info record to be populated  *
 * Returns:   0=success; nonzero=failure                                 *
 *************************************************************************/
int
handle_incoming_parameters (int argc, char *argv[], struct s_bkpinfo *bkpinfo)
{
	/** int ****/
  int res = 0;
  int retval = 0;
  int i = 0, j;

	/** buffers ****************/
  char tmp[MAX_STR_LEN];
//  char command[MAX_STR_LEN];
  char flag_val[128][MAX_STR_LEN];
  bool flag_set[128];

  assert(bkpinfo!=NULL);
  sensibly_set_tmpdir_and_scratchdir(bkpinfo);
  for (i = 0; i < 128; i++)
    {
      flag_val[i][0] = '\0';
      flag_set[i] = FALSE;
    }
  //  strcpy (bkpinfo->tmpdir, "/root/images/mondo");
  //  strcpy (bkpinfo->scratchdir, "/home");
  for(j=1; j<=MAX_NOOF_MEDIA; j++) {bkpinfo->media_size[j] = 650;}	/* default */
  res = retrieve_switches_from_command_line (argc, argv, flag_val, flag_set);
  retval += res;
  if (!retval)
    {
      res = process_switches (bkpinfo, flag_val, flag_set);
      retval += res;
    }
/*
  if (!retval)
    {
*/
      log_it ("Switches:-");
      for (i = 0; i < 128; i++)
	{
	  if (flag_set[i])
	    {
	      sprintf (tmp, "-%c %s", i, flag_val[i]);
	      log_it (tmp);
	    }
	}
//    }
  sprintf (tmp, "rm -Rf %s/tmp.mondo.*", bkpinfo->tmpdir);
  system (tmp);
  sprintf (tmp, "rm -Rf %s/mondo.scratch.*", bkpinfo->scratchdir);
  system (tmp);
  sprintf (bkpinfo->tmpdir + strlen (bkpinfo->tmpdir), "/tmp.mondo.%ld",
	   random () % 32767);
  sprintf (bkpinfo->scratchdir + strlen (bkpinfo->scratchdir),
	   "/mondo.scratch.%ld", random () % 32767);
  sprintf (tmp, "mkdir -p %s/tmpfs", bkpinfo->tmpdir);
  system (tmp);
  sprintf (tmp, "mkdir -p %s", bkpinfo->scratchdir);
  system (tmp);
  if (bkpinfo->nfs_mount[0] != '\0')
    {
      store_nfs_config (bkpinfo);
    }

  if (bkpinfo->please_dont_eject_when_restoring)
    {
      sprintf (tmp, "%s/PLEASE-DONT-EJECT", bkpinfo->tmpdir);
      write_one_liner_data_file (tmp, "pleasedont");
      log_it("OK, not ejecting when restoring");
    }
  return (retval);
}





/* Handle the '-s' (size) flag */
int process_the_s_switch(struct s_bkpinfo *bkpinfo, char *value)
{
      int j;
      char tmp[MAX_STR_LEN], *p, comment[MAX_STR_LEN];

      bkpinfo->media_size[0] = -1; /* dummy value */
      for(j=1, p=value; j<MAX_NOOF_MEDIA && strchr(p,','); j++, p=strchr(p,',')+1)
	{
	  strncpy(tmp, p, MAX_STR_LEN);
	  *(strchr(tmp,',')) = '\0';
	  bkpinfo->media_size[j] = friendly_sizestr_to_sizelong (tmp);
          sprintf(comment, "media_size[%d] = %ld", j, bkpinfo->media_size[j]);
          log_it(comment);
	}
      for(; j<=MAX_NOOF_MEDIA; j++)
	{
	  bkpinfo->media_size[j] = friendly_sizestr_to_sizelong (p);
	}
//      bkpinfo->media_size[0] = bkpinfo->media_size[MAX_NOOF_MEDIA];
      for(j=1; j<=MAX_NOOF_MEDIA; j++)
        {
          if (bkpinfo->media_size[j]<=0) { log_it( "You gave media #%d an invalid size\n", j); return(-1); }
        }
      return(0);
}




/*************************************************************************
 * process_switches() -- Hugo Rabson                                       *
 *                                                                       *
 * Purpose:   Process mondoarchive's command line switches.              *
 * Called by: handle_incoming_parameters()                               *
 * Params:    argc, argv[]           command line                        *
 *            bkpinfo                backup info record to be populated  *
 * Returns:   0=success; nonzero=failure                                 *
 *************************************************************************/
int
process_switches (struct s_bkpinfo *bkpinfo, char flag_val[128][MAX_STR_LEN],
		  bool flag_set[128])
{

	/** ints ****/
  int i = 0, res=0;
  int retval = 0;

	/** buffers ***/
  char tmp[MAX_STR_LEN],
    command[MAX_STR_LEN];

  bkpinfo->media_device[0]='\0';
/* compulsory */
  i =
    flag_set['c'] + flag_set['i'] + flag_set['n'] +
    flag_set['t'] + flag_set['u'] +
    flag_set['w'] + flag_set['C'];
  if (i == 0)
    {
      retval++;
      log_it ( "You must specify the media type\n");
    }
  if (i > 1)
    {
      retval++;
      log_it ( "Please specify only one media type\n");
    }
  if (flag_set['K'])
    {
      g_loglevel = atoi(flag_val['K']);
    }
  if (flag_set['L'] && flag_set['0'])
    {
      retval++;
      log_it ( "You cannot have 'no compression' _and_ LZOP.\n");
    }
  i = flag_set['O'] + flag_set['V'];
  if (i == 0)
    {
      retval++;
      log_it ("Specify backup (-O), verify (-V) or both (-OV).\n");
    }
  bkpinfo->backup_data = flag_set['O'];
  bkpinfo->verify_data = flag_set['V'];
  if (flag_set['I'] && !bkpinfo->backup_data)
    {
      log_to_screen ("-I switch is ignored if just verifying");
    }
  if (flag_set['E'] && !bkpinfo->backup_data)
    {
      log_to_screen ("-E switch is ignored if just verifying");
    }
  if (flag_set['W'])
    {
      bkpinfo->nonbootable_backup = TRUE;
      log_to_screen ("Warning - you have opted for non-bootable backup");
      if (flag_set['f'] || flag_set['l'])
        {
          log_to_screen ("You don't need to specify bootloader or bootdevice");
        }
    }
  if (flag_set['t'] && flag_set['H'])
    { fatal_error("Sorry, you may not nuke w/o warning from tape. Drop -H, please."); }
  if (flag_set['I'])
    {
      strncpy (bkpinfo->include_paths, flag_val['I'], MAX_STR_LEN);
      if (bkpinfo->include_paths[0] == '-'
	  || bkpinfo->include_paths[0] == '\0')
	{
	  retval++;
	  log_it ("Please supply a sensible value with '-I'\n");
	}
    }
  if (flag_set['c'] || flag_set['w'] || flag_set['C'])
    {
      if (strstr(flag_val['d'], "/dev/"))
        { fatal_error("Please don't give a /dev entry. Give a SCSI node for the parameter of the -d flag."); }
      if (system ("which cdrecord > /dev/null 2> /dev/null") && system("which dvdrecord > /dev/null 2> /dev/null"))
	{
	  fatal_error ("Please install dvdrecord/cdrecord and try again.");
	}
      if (flag_set['C'])
	{
	  bkpinfo->cdrw_speed = 2;
	  if (!flag_set['L'])
	    {
	      retval++;
	      log_it ( "Please use -L with -C. It is mandatory.\n");
	    }
	}
      else
	{
	  bkpinfo->cdrw_speed =
	    atoi ((flag_set['c']) ? flag_val['c'] : flag_val['w']);
	  if (bkpinfo->cdrw_speed < 2)
	    {
	      fatal_error ("You specified a silly speed for a CD-R[W] drive");
	    }
	}
    }
  if (flag_set['t'] && !flag_set['d'])
    {
      strncpy(flag_val['d'], "/dev/st0", MAX_STR_LEN/4);
      flag_set['d'] = TRUE;
      log_it("You didn't specify a tape streamer device. I'm assuming %s, OK?");
    }
  if (flag_set['t'] || flag_set['u'])
    {				/* tape size */
      if (strchr(flag_val['d'], ','))
        { fatal_error("Please don't give a SCSI node. Give a _device_, preferably a /dev entry, for the parameter of the -d flag."); }
      if (flag_set['O'])
	{
	  if (flag_set['s'])
	    {
              if (flag_set['t']) { fatal_error("For the moment, please don't specify a tape size. Mondo should handle end-of-tape gracefully anyway."); }
              if (process_the_s_switch(bkpinfo, flag_val['s'])) {fatal_error("Bad -s switch");}
            }
	  else if (flag_set['u'] || flag_set['t'])
    	    {
	      for(i=0; i<=MAX_NOOF_MEDIA; i++) { bkpinfo->media_size[i] = 0; }
	    }
	  else
	    {
	      retval++;
	      log_it ( "Tape size not specified.\n");
	    }
	}
    }
  else
    {				/* CD size */
      if (flag_set['s'])
	{
          if (process_the_s_switch(bkpinfo, flag_val['s'])) {fatal_error("Bad -s switch");}
	}
      if (flag_set['w'])
	{
	  bkpinfo->wipe_media_first = TRUE;
	}			/* CD-RW */
    }
  if (flag_set['e'])
    {
      bkpinfo->please_dont_eject_when_restoring = TRUE;
    }
  if (flag_set['n'])
    {
      strncpy (bkpinfo->nfs_mount, flag_val['n'], MAX_STR_LEN);
      if (!flag_set['d'])
	{
	  strncpy (bkpinfo->nfs_remote_dir, "/", MAX_STR_LEN);
	}
      sprintf (tmp, "mount | grep -x \"%s .*\" | cut -d' ' -f3",
	       bkpinfo->nfs_mount);
      strncpy (bkpinfo->isodir,
	      call_program_and_get_last_line_of_output (tmp), MAX_STR_LEN/4);
      if (strlen (bkpinfo->isodir) < 3)
	{
	  retval++;
	  log_it ( "NFS share is not mounted. Please mount it.\n");
	}
      sprintf (tmp, "mount = %s", bkpinfo->nfs_mount);
      //      log_it(tmp);
      sprintf (tmp, "isodir= %s", bkpinfo->isodir);
      //      log_it(tmp);
      sprintf (tmp, "echo hi > %s/%s/.dummy.txt", bkpinfo->isodir, bkpinfo->nfs_remote_dir);
      if (run_program_and_log_output (tmp, FALSE))
	{
	  retval++;
	  log_it (  "Are you sure directory '%s' exists in remote dir '%s'?\nIf so, do you have rights to write to it?\n",
		   bkpinfo->nfs_remote_dir, bkpinfo->nfs_mount);
	}
    }
  if (flag_set['c']) { bkpinfo->backup_media_type = cdr; }
  if (flag_set['C']) { bkpinfo->backup_media_type = cdstream; }
  if (flag_set['i']) { bkpinfo->backup_media_type = iso; }
  if (flag_set['n']) { bkpinfo->backup_media_type = nfs; }
  if (flag_set['t']) { bkpinfo->backup_media_type = tape; }
  if (flag_set['u']) { bkpinfo->backup_media_type = udev; }
  if (flag_set['w']) { bkpinfo->backup_media_type = cdrw; }

/* optional, popular */
  if (flag_set['g'])
    {
      g_text_mode = FALSE;
    }
  if (flag_set['E'])
    {
//      if (strlen(flag_val['E'])<2) { fatal_error("Please choose a different value for -E"); }
      strncpy (bkpinfo->exclude_paths, flag_val['E'], MAX_STR_LEN);
    }
  if (flag_set['N']) // exclude NFS mounts & devices
    {
      strncpy(tmp, list_of_NFS_devices_and_mounts(), MAX_STR_LEN);
      if (bkpinfo->exclude_paths[0]) { strcat(bkpinfo->exclude_paths, " "); }
      strcat(bkpinfo->exclude_paths, tmp);
      log_it("-N means we're now excluding %s", bkpinfo->exclude_paths);
    }
  if (flag_set['D'])
    {
      bkpinfo->differential = TRUE;
    }
  if (flag_set['x'])
    {
      strncpy (bkpinfo->image_devs, flag_val['x'], MAX_STR_LEN/4);
    }
  if (flag_set['m'])
    {
      bkpinfo->manual_cd_tray = TRUE;
    }
  if (flag_set['k'])
    {
      strncpy (bkpinfo->kernel_path, flag_val['k'], MAX_STR_LEN);
      if (!strcmp (bkpinfo->kernel_path, "failsafe"))
	{
	  strcpy (bkpinfo->kernel_path, "FAILSAFE");
	}
      if (strcmp (bkpinfo->kernel_path, "FAILSAFE")
	  && !does_file_exist (bkpinfo->kernel_path))
	{
	  retval++;
	  log_it (  "You specified kernel '%s', which does not exist\n",
		   bkpinfo->kernel_path);
	}
    }
  if (flag_set['d'])
    {				/* backup directory (if ISO/NFS) */
      if (flag_set['i'])
	{
	  strncpy (bkpinfo->isodir, flag_val['d'], MAX_STR_LEN/4);
          sprintf(tmp, "ls -l %s", bkpinfo->isodir);
          if (run_program_and_log_output(tmp, FALSE)) { fatal_error("output folder does not exist - please create it"); }
	}
      else if (flag_set['n'])
	{
	  strncpy (bkpinfo->nfs_remote_dir, flag_val['d'], MAX_STR_LEN);
	}
      else			/* backup device (if tape/CD-R/CD-RW) */
	{
	  strncpy (bkpinfo->media_device, flag_val['d'], MAX_STR_LEN/4);
	}
    }
  if (!flag_set['d'] && (flag_set['c'] || flag_set['w'] || flag_set['C']))
    {
      res = find_cdrw_device (tmp);
      if (res)
	{
	  retval++;
	  log_it (
		   "Tried and failed to find CD-R[W] drive automatically.\n");
	}
      else
	{
          strcpy(bkpinfo->media_device, tmp);
	  flag_set['d'] = TRUE;
	  strncpy (flag_val['d'], bkpinfo->media_device, MAX_STR_LEN/4);
	}
    }
  if (!flag_set['d'] && !flag_set['n'] && !flag_set['C'])
    {
      retval++;
      log_it ( "Please specify the backup device/directory.\n");
    }

/* optional, obscure */
  for (i = '0'; i <= '9'; i++)
    {
      if (flag_set[i])
	{
	  bkpinfo->compression_level = i - '0';
	}			/* not '\0' but '0' */
    }
  if (flag_set['S'])
    {
      sprintf (bkpinfo->scratchdir, "%s/mondo.scratch.%ld", flag_val['S'],
	       random () % 32768);
    }
  if (flag_set['T'])
    {
      sprintf (bkpinfo->tmpdir, "%s/tmp.mondo.%ld", flag_val['T'],
	       random () % 32768);
    }
  if (flag_set['A'])
    {
      strncpy (bkpinfo->call_after_iso, flag_val['A'], MAX_STR_LEN);
    }
  if (flag_set['B'])
    {
      strncpy (bkpinfo->call_before_iso, flag_val['B'], MAX_STR_LEN);
    }
  if (flag_set['F'])
    {
      g_skip_floppies = TRUE;
    }
  if (flag_set['H'])
    {
      g_cd_recovery = TRUE;
    }
  if (flag_set['l'])
    {
      if (!strchr("GLR", (bkpinfo->boot_loader = flag_val['l'][0])))
	{ 
	  log_it("%c? WTF is %c? I need G, L or R.", bkpinfo->boot_loader, bkpinfo->boot_loader);
	  fatal_error("Please specify GRUB, LILO or RAW with the -l switch"); 
	}
    }
  if (flag_set['f'])
    {
      strncpy (bkpinfo->boot_device, resolve_softlinks_to_get_to_actual_device_file(flag_val['f']), MAX_STR_LEN/4);
    }
  if (flag_set['P'])
    {
      strncpy (bkpinfo->postnuke_tarball, flag_val['P'], MAX_STR_LEN);
    }
  if (flag_set['Q'])
    {
      i = which_boot_loader(tmp);
      sprintf(command, "boot loader is %c and it resides on %s", i, tmp);
      printf("%s\n", command);
      log_it(command);
      finish(0);
    }
  if (flag_set['L'])
    {
      bkpinfo->use_lzo = TRUE;
      if (run_program_and_log_output ("which lzop", FALSE))
	{
	  retval++;
	  log_it (
		   "Please install LZOP. You can't use '-L' until you do.\n");
	}
    }
  if (flag_set['o'])
    {
      bkpinfo->make_cd_use_lilo = TRUE;
    }
  else
    {
      if (!is_this_a_valid_disk_format("vfat"))
        { fatal_error("Either call mondoarchive with '-o', or recompile your kernel to include VFAT support."); }
      if (run_program_and_log_output("which mkfs.vfat", FALSE))
        { fatal_error("Either call mondoarchive with '-o', or install dosfstools so that you have mkfs.vfat, please. If you are a SuSE user, contact SuSE to ask where they keep mkfs.vfat; it _should_ be in dosfstools but apparently they don't put it there for some reason."); }
    }

/* and finally... */
  
  return (retval);
}



/*************************************************************************
 * retrieve_switches() -- Hugo Rabson                                    *
 *                                                                       *
 * Purpose:    Take flags -a thru -z, -A thru -Z, -0 thru -9, and copy   *
 *             them (if found) to an array - flag_val[]; if it isn't set *
 *             then set flag_set[] to FALSE. Else, set it to TRUE.       *
 * Called by:  handle_incoming_parameters()                              *
 * Params:     argc, argv[]         command line                         *
 * Returns:    0=success; nonzero=failure                                *
 *************************************************************************/
int
retrieve_switches_from_command_line (int argc, char *argv[],
				     char flag_val[128][MAX_STR_LEN],
				     bool flag_set[128])
{
	/** ints ***/
  int opt = 0;
  int i = 0;
  int len;

	/** bools ****/
  bool bad_switches = FALSE;

  for (i = 0; i < 128; i++)
    {
      flag_val[i][0] = '\0';
      flag_set[i] = FALSE;
    }
  while ((opt =
	  getopt (argc, argv,
		  "0123456789A:B:CDE:FHI:K:LNOP:QS:T:VWXc:d:ef:gik:l:mn:os:tuw:x:")) !=
	 -1)
    {
      if (opt == '?')
	{
	  bad_switches = TRUE;
	  /*fprintf(stderr,"Invalid option: %c\n",optopt); */
	}
      else
	{
	  if (flag_set[optopt])
	    {
	      bad_switches = TRUE;
	      log_it ("Switch -%c previously defined as %s\n", opt,
		       flag_val[i]);
	    }
	  else
	    {
	      flag_set[opt] = TRUE;
	      if (optarg)
		{
                  len = strlen(optarg);
                  if (len > 1 && optarg[len-1] == '/')
                    {
                      optarg[--len] = '\0'; log_it( "Warning - param '%s' is too long!", optarg); 
                    }
		  strncpy (flag_val[opt], optarg, MAX_STR_LEN);
		  if (opt=='d')
		    {
		      if (strchr(flag_val[opt], '/') && flag_val[opt][0]!='/')
			{
			  log_it("-%c flag --- must be absolute path --- '%s' isn't absolute", opt, flag_val[opt]);
			  bad_switches = TRUE;
			}
		    }
		}
	    }
	}
    }
  for (i = optind; i < argc; i++)
    {
      bad_switches = TRUE;
      log_it ( "Invalid arg -- %s\n", argv[i]);
    }
  return (bad_switches);
}





void
help_screen ()
{
  log_it ( "Type 'man mondo-archive' for more information\n");
  exit (1);
}





void terminate_daemon(int sig)
{
  char tmp[64];
  char command[512];
  pid_t pid;

  switch(sig)
    {
	case SIGINT:
		sprintf(tmp, "SIGINT");
		break;
	case SIGKILL:
		sprintf(tmp, "SIGKILL");
		break;
	case SIGTERM:
		sprintf(tmp, "SIGTERM");
		break;
	case SIGHUP:
		sprintf(tmp, "SIGHUP");
		break;
	case SIGSEGV:
		sprintf(tmp, "SIGSEGV");
		break;
	case SIGPIPE:
		sprintf(tmp, "SIGPIPE");
		break;
	default:
		sprintf(tmp, "(Unknown)");
    }

  strcat(tmp, " signal received from OS");
  log_to_screen(tmp);
  log_to_screen("Mondoarchive is terminating in response to a signal from the OS");

  sprintf(tmp, "umount %s", g_tmpfs_mountpt);
  run_program_and_log_output(tmp, TRUE);
  run_program_and_log_output(g_erase_tmpdir_and_scratchdir, TRUE);

  if (getpid() == g_main_pid)
    {
      log_it("main PID is now calling finish()");
      pid = fork();
      if (pid==0)
        { 
	  sleep(2);
	  sprintf(command, "for j in \"\" \"-9\"; do for i in `ps ax | grep mondoarchive | grep \"[O|V]\" | cut -d' ' -f1 | grep -vx %d`; do kill $j $i ; done; umount %s; rm -Rf %c*.mondo.* ; sleep 1 ; done", (int)pid, g_tmpfs_mountpt, '/');
	  run_program_and_log_output(command, TRUE);
	}
      sleep(2);
      finish(254);
    }
  finish(254);
}





void set_signals(int on)
/*
Purpose:Turn on/off signal-trapping
Params:	on - turn on or off (true=on, false=off)
Return: None
*/
{
  int signals[]= { SIGPIPE, SIGTERM, SIGHUP, SIGTRAP, SIGABRT, SIGINT, SIGKILL, SIGSTOP, 0 };
  int i;
  for (i=0; signals[i]; i++)
    {
      if (on)
        { signal(signals[i], terminate_daemon); }
      else
        { signal(signals[i], termination_in_progress); }
    }
}





void termination_in_progress(int sig)
{
  log_it("Termination in progress");
  usleep(1000);
  pthread_exit(0);
}

























