// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Mike Krüger" email="mike@icsharpcode.net"/>
//     <version value="$version"/>
// </file>

using System;
using System.Collections;
using System.Diagnostics;
using System.ComponentModel;

namespace MonoDevelop.Core.AddIns
{
	[Description ("A class description.")]
	[CodonNameAttribute("Class")]
	public class ClassCodon : AbstractCodon
	{
		/// <summary>
		/// Creates an item with the specified sub items. And the current
		/// Condition status for this item.
		/// </summary>
		
		public Type Type {
			get { return AddIn.GetType (Class); }
		}
		
		public override object BuildItem(object owner, ArrayList subItems, ConditionCollection conditions)
		{
			Debug.Assert(Class != null && Class.Length > 0);
			return AddIn.CreateObject(Class);
		}
		
	}
}
