//
// MonoPlatformExecutionHandler.cs
//
// Author:
//   Lluis Sanchez Gual
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;

namespace MonoDevelop.Core.Execution
{
	public class MonoPlatformExecutionHandler: NativePlatformExecutionHandler
	{
		public override IProcessAsyncOperation Execute (string command, string arguments, string workingDirectory, IConsole console)
		{
			string args = string.Format ("--debug \"{0}\" {1}", command, arguments);
			return base.Execute ("mono", args, workingDirectory, console);

// Old method - workaround should no longer be necessary.
//			string args = string.Format (@"--debug {0} {1}", command.Replace (" ", "\\ "), arguments);
//			
//			if (console is ExternalConsole)
//				return base.Execute ("mono", args, workingDirectory, console);
//			else
//				// The use of 'sh' is a workaround. Looks like there is a bug
//				// in mono, Process can't start a "mono" process.
//				return base.Execute ("sh", string.Format ("-c \"mono {0}\"", args), workingDirectory, console);
		}
	}
}
