// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Mike Krüger" email="mike@icsharpcode.net"/>
//     <version value="$version"/>
// </file>

using System;

using MonoDevelop.Services;
using MonoDevelop.Core.AddIns.Codons;
using MonoDevelop.Core.Services;
using MonoDevelop.Gui;
using MonoDevelop.Gui.Dialogs;

namespace MonoDevelop.DefaultEditor.Commands
{
	public class ExportProjectToHtml : AbstractMenuCommand
	{
		public override void Run()
		{
			IProjectService projectService = (IProjectService) MonoDevelop.Core.Services.ServiceManager.GetService (typeof (IProjectService));
			if (projectService.CurrentSelectedProject != null) {
			
				using (ExportProjectToHtmlDialog ephd = new ExportProjectToHtmlDialog (projectService.CurrentSelectedProject)) {
					ephd.TransientFor = (Gtk.Window) WorkbenchSingleton.Workbench;
					ephd.Run ();
					ephd.Hide ();
				}
			}
		}
	}
}
