open Viz_types

type t

(** Any of these function can raise Viz_types.Error *)

val open_db    : ?busy_handler:(int -> [`FAIL | `RETRY]) -> string -> t
val close_db   : t -> unit

val with_progress : (unit -> unit) -> (t -> 'a) -> t -> 'a

val get_filename : t -> string

val fetch_branches : t -> string list
val fetch_ancestry_graph : t -> query -> agraph
val fetch_revision           : t -> string -> node_data
val fetch_certs_and_revision : t -> string -> node_data
val fetch_cert_signer : t -> string -> string -> string list
val fetch_cert_value  : t -> string -> string -> string list

val get_matching_tags  : t -> (string -> bool) -> (string * string) list
val get_matching_dates : t -> string -> (string * string) list
val get_matching_ids   : t -> string -> (string * string) list

val get_key_rowid : t -> string -> int

val run_monotone_diff : 
  t -> string ->
  <push : string -> unit; pop : unit -> unit; ..> ->
  ([>`SUB_PROC_ERROR of string | `OUTPUT of string] -> unit) ->
  string * string -> unit

val run_monotone_select : 
  t -> string ->
  <push : string -> unit; pop : unit -> unit; ..> ->
  ([>`SUB_PROC_ERROR of string | `IDS of string list] -> unit) ->
  string list -> Subprocess.t
