#!/bin/sh
# the next line restarts using the interpreter \
exec tclsh "$0" "$@"

if {[string equal [lindex $argv 0] -]} {                                                                     ;# tcl code output file
    set output stdout
} else {
    set output [open [lindex $argv 0] w]
}
set input [open [lindex $argv 1]]                                                                                 ;# html input file
set data [read $input]
close $input

# remove paragraph tags that follow a closing header tag since that generates in an extra ugly new line:
regsub -all {(</[hH]\d>\s*)<p>} $data {\1} data
set lines [split $data \n]

# first gather contents section
set index 0
foreach line $lines {
    incr index
    if {[string match {*<!-- beginning of contents -->*} $line]} break
}
puts $output {package provide moodsshelp 1.0}
puts $output "set htmlHelpContents \{"
puts $output <html><body>
foreach line [lrange $lines $index end] {
    incr index
    if {[string match {*<!-- end of contents -->*} $line]} break
    puts $output $line
}
puts $output "</body></html>}"

# then collect remaining data
puts $output "set htmlHelpData \{"
puts $output <body><html>
foreach line [lrange $lines $index end] {
    puts $output $line
}
puts $output \}
close $output
