# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: lifolbl.tcl,v 2.14 2004/01/01 11:39:06 jfontain Exp $


# last-in-first-out label generally used at the bottom of an application window for messages display

class lifoLabel {}

proc lifoLabel::lifoLabel {this parentPath args} composite {[new scrollingLabel $parentPath] $args} {
    set ($this,lifo) [new lifo]
    composite::complete $this
}

proc lifoLabel::~lifoLabel {this} {
    delete $($this,lifo)
}

proc lifoLabel::options {this} {                                                              ;# force initialization of all options
    return [list\
        [list -borderwidth $widget::option(button,borderwidth)]\
        [list -font {helvetica -12}]\
        [list -relief sunken]\
    ]
}

proc lifoLabel::set-relief {this value} {
    composite::configure $composite::($this,base) base -relief $value
}

proc lifoLabel::set-borderwidth {this value} {
    composite::configure $composite::($this,base) base -borderwidth $value
}

proc lifoLabel::set-font {this value} {
    composite::configure $composite::($this,base) -font $value
}

proc lifoLabel::push {this string} {                                                          ;# user procedure for pushing a string
    if {[string length [set current [composite::cget $composite::($this,base) -text]]]>0} {
        xifo::in $($this,lifo) $current                                                ;# store current string in stack if non empty
    }
    composite::configure $composite::($this,base) -text $string
}

proc lifoLabel::pop {this} {                                                                  ;# user procedure for popping a string
    set string {}
    catch {set string [lifo::out $($this,lifo)]}
    composite::configure $composite::($this,base) -text $string
    return $string
}

proc lifoLabel::flash {this string {seconds 1}} {                                            ;# user procedure for flashing a string
    after [expr {1000*$seconds}] lifoLabel::pop $this
    push $this $string
}
