#!/usr/bin/perl
use ExtUtils::MakeMaker;
use Config;

sub MY::postamble {q{
# Import variables from mooix.conf and makeinfo; these are used by
# filterperl.
include ../../makeinfo
include ../../mooix.conf
export MOOROOT
export PERL_STDOUT_FLUSH_HACK
export sysconfdir

# No, I don't want you to hardcode my build path in CallStack.so just
# because I have to give a -L path to -lmoocallstack. Yeesh.
LD_RUN_PATH=
# This is a hack to make make test work even though libmoocallstack is not yet
# installed.
FULLPERLRUN=LD_LIBRARY_PATH=../../libmoocallstack $(FULLPERL)
}}

# Override default which does not exclude .svn directories.
sub MY::libscan {
	my($self,$path) = @_;
	return '' if $path =~ m:(\b(RCS|CVS|SCCS)|\.svn)\b: ;
	$path;
}

WriteMakefile(
	PM_FILTER	=> './filterperl',
	NAME		=> 'Mooix::CallStack',
	LIBS		=> ['-L../../libmoocallstack -lmoocallstack'],
	INC		=> '-I../../libmoocallstack',
);
