/*
 * embedding perl into mood speeds execution of perl methods
 *
 * Copyright 2002-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the GNU GPL.
 */

#include <EXTERN.h>
#include <perl.h>

extern char **real_argv; /* from mood.c */
extern char *perlpreload; /* from mood.c */

static PerlInterpreter *my_perl;

static void xs_init (pTHX);

EXTERN_C void boot_DynaLoader (pTHX_ CV* cv);

EXTERN_C void xs_init(pTHX) {
	char *file = __FILE__;
	/* DynaLoader is a special case */
	newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
}

void init_perl (void) {
	/* "On linux perl expects the args to "point to chunks of a
	 * contiguous array which it can write over" -- bod */
	char *e = "\0" "-e\0" "0\0";
	char *embedding[] =  { e, e+1, e+4 };
	my_perl = perl_alloc();
	perl_construct(my_perl);
        perl_parse(my_perl, xs_init, 3, embedding, NULL);
	if (perlpreload)
		eval_pv(perlpreload, TRUE);

#if (PERL_REVISION == 5) && (PERL_VERSION == 8) && (PERL_SUBVERSION == 1) && \
    (defined(USE_HASH_SEED) || defined(USE_HASH_SEED_EXPLICIT))
	/* Work around bug in 5.8.1, causing all forked procs to produce the
           same rand sequence. */
	/* XXX This can be removed in a while, once 5.8.1 is rare. */
	PL_srand_called = FALSE;
#endif
}

void run_perl (int my_argc, char **my_argv, const char *this,
               const char *moosock, const char *method,
	       const char *mooix_debug) {
	HV *pl_env = get_hv("ENV", TRUE);
	AV *pl_argv = get_av("ARGV", TRUE);
	SV *argv0 = get_sv("0", TRUE);
	SV *uid = get_sv("<", TRUE);
	SV *euid = get_sv(">", TRUE);
	SV *gid = get_sv("(", TRUE);
	SV *egid = get_sv(")", TRUE);
	SV *pid = get_sv("$", TRUE);
	SV *temp;

	/* Set $0 inside perl. */
	SvSetSV(argv0, newSVpv(my_argv[0], 0));

#ifdef __linux__
	/* Manually set the real argv[0] and thus the proctitle since on
	 * linux perl tries to do that by editing the argv passed into
	 * perl_parse, which is not the real one. */
	/* XXX This is not quite right, it can lead to this:
	 * 17458 ?        S      0:00  \_ ../../../../mood/mood
	 * 17460 ?        S      0:00      \_ ./echo2 /../mood/mood
	 * Apparently the NULL does not have effect, and I'd need to
	 * get the length of the real_argv[0] buffer and manually zero it
	 * or something. */
	strcpy(real_argv[0], my_argv[0]);
#endif
	
	/* It's unlikely that there will be an @ARGV, but set it if so. */
	av_clear(pl_argv);
	if (my_argc >= 2) {
		int i;
		for (i = 2; i < my_argc; i++)
			av_push(pl_argv, newSVpv(my_argv[i], 0));
	}
	
	/* Set environment stuff that is used by Mooix::Thing, etc. */
	/* Note that I do *not* set METHOD; $0 is already set up correctly
	 * above and so the METHOD hack is unnecessary. The calls to mg_set
	 * are needed as %ENV is tied. */
	temp = newSVpv(this, 0);
	hv_store(pl_env, "THIS", strlen("THIS"), temp, 0);
	mg_set(temp);
	temp = newSVpv(moosock, 0);
	hv_store(pl_env, "MOOSOCK", strlen("MOOSOCK"), temp, 0);
	mg_set(temp);
	if (mooix_debug) {
		temp = newSVpv(mooix_debug, 0);
		hv_store(pl_env, "MOOIX_DEBUG", strlen("MOOIX_DEBUG"), temp, 0);
		mg_set(temp);
	}

	/* Let perl know about the uid and gid change and update these
	 * magic variables. Order is significant. */
	mg_set(egid);
	mg_set(euid);
	mg_set(gid);
	mg_set(uid);

	/* Also the pid has changed. */
	SvSetSV(pid, newSViv(getpid()));
#if (PERL_REVISION == 5) && (PERL_VERSION == 8)
	/* As of perl 5.8.1 and onward, gettpid is not updated for embedded
	 * code, so must be updated manually. */
	PL_ppid = (IV)getppid();
#endif
	
	eval_pv("do $0; die $@ if $@", TRUE);
	perl_run(my_perl);
}

void end_perl (void) {
	perl_destruct(my_perl);
	perl_free(my_perl);
}
