﻿// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License (Ms-PL).
// Please see http://go.microsoft.com/fwlink/?LinkID=131993 for details.
// All other rights reserved.

namespace Microsoft.Silverlight.Testing.Html
{
    /// <summary>
    /// String definitions for the test framework.
    /// </summary>
    public static class Color
    {
        /// <summary>
        /// Very light gray representing #eee color.
        /// </summary>
        public const string VeryLightGray = "#eee";

        /// <summary>
        /// Another grey color, #ddd.
        /// </summary>
        public const string AnotherLightGray = "#ddd";

        /// <summary>
        /// Light gray representing #999 color.
        /// </summary>
        public const string LightGray = "#999";

        /// <summary>
        /// Dark gray representing #333 color.
        /// </summary>
        public const string DarkGray = "#333";

        /// <summary>
        /// Blue color #00f.
        /// </summary>
        public const string Blue = "#00f";

        /// <summary>
        /// Manila folder color color.
        /// </summary>
        public const string Manila = "#fff9d8";

        /// <summary>
        /// Border that pairs well with the "Manila" color color.
        /// </summary>
        public const string ManilaBorder = "#ffe8cd";

        /// <summary>
        /// Tan color color.
        /// </summary>
        public const string Tan = "#d2b48c";

        /// <summary>
        /// White color.
        /// </summary>
        public const string White = "#fff";

        /// <summary>
        /// Black color.
        /// </summary>
        public const string Black = "#000";

        /// <summary>
        /// Pure Red color.
        /// </summary>
        public const string Red = "#f00";

        /// <summary>
        /// Yellow color.
        /// </summary>
        public const string Yellow = "#ff0";
    }
}