# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.actions import Action, LinkAction

from elisa.plugins.flickr.utils import get_flickr_provider


_ = install_translation('flickr')


class LoginAction(LinkAction):
    """ L{LinkAction} leading to the Flickr login form.
    """

    title = _('Login to Flickr')
    path = '/poblesec/flickr/login'


class LogoutAction(Action):
    """ Action used to clear the Flickr resource_provider
    authentication token and go back to the previous menu. This action
    is called from the 'My Account' menu.
    """

    title = _('Logout From Flickr')

    def run(self):
        get_flickr_provider().logout()

        frontend = self.controller.frontend
        browser = frontend.retrieve_controllers('/poblesec/browser')[0]
        return browser.history.go_back()


class MyAccountAction(LinkAction):
    """ Action leading to the 'My Account' menu.
    """
    title = _('My Flickr Account')
    path = '/poblesec/flickr/account'
