/* SettingsDialog.c generated by valac 0.13.3.34-3eeb2-dirty, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	GtkBuilder* _builder;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBox* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* deviceModel;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;

GType moserial_settings_dialog_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_BUILDER
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self);
static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void moserial_settings_dialog_finalize (GObject* obj);
static void _vala_moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* SETTINGS_BaudRateItems[16];
extern const gchar* SETTINGS_DataBitItems[4];
extern const gchar* SETTINGS_StopBitItems[2];
extern const gchar* SETTINGS_ParityModeStrings[5];
extern const gchar* SETTINGS_AccessModeStrings[3];

moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder) {
	moserialSettingsDialog * self = NULL;
	GtkBuilder* _tmp0_;
	g_return_val_if_fail (builder != NULL, NULL);
	_tmp0_ = builder;
	self = (moserialSettingsDialog*) g_object_new (object_type, "builder", _tmp0_, NULL);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, builder);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	_tmp0_ = g_strdup ("/dev/ttyS");
	deviceTypes = g_list_append (deviceTypes, _tmp0_);
	_tmp1_ = g_strdup ("/dev/ttyUSB");
	deviceTypes = g_list_append (deviceTypes, _tmp1_);
	_tmp2_ = g_strdup ("/dev/rfcomm");
	deviceTypes = g_list_append (deviceTypes, _tmp2_);
	_tmp3_ = self->priv->deviceModel;
	gtk_list_store_clear (_tmp3_);
	_tmp4_ = deviceTypes;
	{
		GList* devType_collection = NULL;
		GList* devType_it = NULL;
		devType_collection = _tmp4_;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			gchar* _tmp5_;
			gchar* devType = NULL;
			_tmp5_ = g_strdup ((const gchar*) devType_it->data);
			devType = _tmp5_;
			{
				{
					gint i;
					i = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							const gchar* _tmp10_;
							gint _tmp11_;
							gchar* _tmp12_ = NULL;
							gchar* dev;
							const gchar* _tmp13_;
							gboolean _tmp14_ = FALSE;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = i;
							if (!(_tmp9_ < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							_tmp10_ = devType;
							_tmp11_ = i;
							_tmp12_ = g_strdup_printf ("%s%d", _tmp10_, _tmp11_);
							dev = _tmp12_;
							_tmp13_ = dev;
							_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_EXISTS);
							if (_tmp14_) {
								GtkListStore* _tmp15_;
								GtkTreeIter _tmp16_ = {0};
								GtkListStore* _tmp17_;
								GtkTreeIter _tmp18_;
								const gchar* _tmp19_;
								_tmp15_ = self->priv->deviceModel;
								gtk_list_store_append (_tmp15_, &_tmp16_);
								iter = _tmp16_;
								_tmp17_ = self->priv->deviceModel;
								_tmp18_ = iter;
								_tmp19_ = dev;
								gtk_list_store_set (_tmp17_, &_tmp18_, 0, _tmp19_, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	__g_list_free__g_free0_0 (deviceTypes);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp0_;
	Settings* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp1_;
	moserial_settings_dialog_loadSettings (self);
	_tmp2_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
}


void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t = NULL;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkComboBox* _tmp18_;
	GtkTreeModel* _tmp19_ = NULL;
	GtkTreeModel* _tmp20_;
	GtkTreeModel* _tmp21_;
	GtkTreeIter _tmp22_ = {0};
	gboolean _tmp23_ = FALSE;
	GtkComboBox* _tmp39_;
	GtkTreeModel* _tmp40_ = NULL;
	GtkTreeModel* _tmp41_;
	GtkTreeModel* _tmp42_;
	GtkTreeIter _tmp43_ = {0};
	gboolean _tmp44_ = FALSE;
	GtkComboBox* _tmp60_;
	GtkTreeModel* _tmp61_ = NULL;
	GtkTreeModel* _tmp62_;
	GtkTreeModel* _tmp63_;
	GtkTreeIter _tmp64_ = {0};
	gboolean _tmp65_ = FALSE;
	GtkComboBox* _tmp81_;
	Settings* _tmp82_;
	SettingsParity _tmp83_;
	SettingsParity _tmp84_;
	GtkComboBox* _tmp85_;
	Settings* _tmp86_;
	SettingsAccessMode _tmp87_;
	SettingsAccessMode _tmp88_;
	GtkCheckButton* _tmp89_;
	GtkCheckButton* _tmp90_;
	gboolean _tmp91_ = FALSE;
	Settings* _tmp92_;
	SettingsHandshake _tmp93_;
	SettingsHandshake _tmp94_;
	gboolean _tmp98_;
	gboolean _tmp100_ = FALSE;
	Settings* _tmp101_;
	SettingsHandshake _tmp102_;
	SettingsHandshake _tmp103_;
	gboolean _tmp107_;
	Settings* _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp111_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	ti = _tmp4_;
	success = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_;
		GValue str_data = {0};
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GValue _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
		Settings* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GtkTreeModel* _tmp16_;
		gboolean _tmp17_ = FALSE;
		_tmp6_ = success;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = t;
		_tmp8_ = ti;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = self->priv->currentSettings;
		_tmp12_ = settings_get_device (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
			GtkComboBox* _tmp14_;
			GtkTreeIter _tmp15_;
			_tmp14_ = self->priv->deviceCombo;
			_tmp15_ = ti;
			gtk_combo_box_set_active_iter (_tmp14_, &_tmp15_);
		}
		_tmp16_ = t;
		_tmp17_ = gtk_tree_model_iter_next (_tmp16_, &ti);
		success = _tmp17_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp18_ = self->priv->baudRateCombo;
	_tmp19_ = gtk_combo_box_get_model (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (t);
	t = _tmp20_;
	_tmp21_ = t;
	_tmp23_ = gtk_tree_model_get_iter_first (_tmp21_, &_tmp22_);
	ti = _tmp22_;
	success = _tmp23_;
	while (TRUE) {
		gboolean _tmp24_;
		GValue str_data = {0};
		GtkTreeModel* _tmp25_;
		GtkTreeIter _tmp26_;
		GValue _tmp27_ = {0};
		const gchar* _tmp28_ = NULL;
		Settings* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gboolean _tmp34_;
		GtkTreeModel* _tmp37_;
		gboolean _tmp38_ = FALSE;
		_tmp24_ = success;
		if (!_tmp24_) {
			break;
		}
		_tmp25_ = t;
		_tmp26_ = ti;
		gtk_tree_model_get_value (_tmp25_, &_tmp26_, 0, &_tmp27_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp27_;
		_tmp28_ = g_value_get_string (&str_data);
		_tmp29_ = self->priv->currentSettings;
		_tmp30_ = settings_get_baudRate (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strcmp0 (_tmp28_, _tmp33_) == 0;
		_g_free0 (_tmp33_);
		if (_tmp34_) {
			GtkComboBox* _tmp35_;
			GtkTreeIter _tmp36_;
			_tmp35_ = self->priv->baudRateCombo;
			_tmp36_ = ti;
			gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
		}
		_tmp37_ = t;
		_tmp38_ = gtk_tree_model_iter_next (_tmp37_, &ti);
		success = _tmp38_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp39_ = self->priv->dataBitsCombo;
	_tmp40_ = gtk_combo_box_get_model (_tmp39_);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (t);
	t = _tmp41_;
	_tmp42_ = t;
	_tmp44_ = gtk_tree_model_get_iter_first (_tmp42_, &_tmp43_);
	ti = _tmp43_;
	success = _tmp44_;
	while (TRUE) {
		gboolean _tmp45_;
		GValue str_data = {0};
		GtkTreeModel* _tmp46_;
		GtkTreeIter _tmp47_;
		GValue _tmp48_ = {0};
		const gchar* _tmp49_ = NULL;
		Settings* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_;
		gboolean _tmp55_;
		GtkTreeModel* _tmp58_;
		gboolean _tmp59_ = FALSE;
		_tmp45_ = success;
		if (!_tmp45_) {
			break;
		}
		_tmp46_ = t;
		_tmp47_ = ti;
		gtk_tree_model_get_value (_tmp46_, &_tmp47_, 0, &_tmp48_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp48_;
		_tmp49_ = g_value_get_string (&str_data);
		_tmp50_ = self->priv->currentSettings;
		_tmp51_ = settings_get_dataBits (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf ("%i", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strcmp0 (_tmp49_, _tmp54_) == 0;
		_g_free0 (_tmp54_);
		if (_tmp55_) {
			GtkComboBox* _tmp56_;
			GtkTreeIter _tmp57_;
			_tmp56_ = self->priv->dataBitsCombo;
			_tmp57_ = ti;
			gtk_combo_box_set_active_iter (_tmp56_, &_tmp57_);
		}
		_tmp58_ = t;
		_tmp59_ = gtk_tree_model_iter_next (_tmp58_, &ti);
		success = _tmp59_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp60_ = self->priv->stopBitsCombo;
	_tmp61_ = gtk_combo_box_get_model (_tmp60_);
	_tmp62_ = _g_object_ref0 (_tmp61_);
	_g_object_unref0 (t);
	t = _tmp62_;
	_tmp63_ = t;
	_tmp65_ = gtk_tree_model_get_iter_first (_tmp63_, &_tmp64_);
	ti = _tmp64_;
	success = _tmp65_;
	while (TRUE) {
		gboolean _tmp66_;
		GValue str_data = {0};
		GtkTreeModel* _tmp67_;
		GtkTreeIter _tmp68_;
		GValue _tmp69_ = {0};
		const gchar* _tmp70_ = NULL;
		Settings* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		gboolean _tmp76_;
		GtkTreeModel* _tmp79_;
		gboolean _tmp80_ = FALSE;
		_tmp66_ = success;
		if (!_tmp66_) {
			break;
		}
		_tmp67_ = t;
		_tmp68_ = ti;
		gtk_tree_model_get_value (_tmp67_, &_tmp68_, 0, &_tmp69_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp69_;
		_tmp70_ = g_value_get_string (&str_data);
		_tmp71_ = self->priv->currentSettings;
		_tmp72_ = settings_get_stopBits (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf ("%i", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strcmp0 (_tmp70_, _tmp75_) == 0;
		_g_free0 (_tmp75_);
		if (_tmp76_) {
			GtkComboBox* _tmp77_;
			GtkTreeIter _tmp78_;
			_tmp77_ = self->priv->stopBitsCombo;
			_tmp78_ = ti;
			gtk_combo_box_set_active_iter (_tmp77_, &_tmp78_);
		}
		_tmp79_ = t;
		_tmp80_ = gtk_tree_model_iter_next (_tmp79_, &ti);
		success = _tmp80_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp81_ = self->priv->parityCombo;
	_tmp82_ = self->priv->currentSettings;
	_tmp83_ = settings_get_parity (_tmp82_);
	_tmp84_ = _tmp83_;
	gtk_combo_box_set_active (_tmp81_, (gint) _tmp84_);
	_tmp85_ = self->priv->accessModeCombo;
	_tmp86_ = self->priv->currentSettings;
	_tmp87_ = settings_get_accessMode (_tmp86_);
	_tmp88_ = _tmp87_;
	gtk_combo_box_set_active (_tmp85_, (gint) _tmp88_);
	_tmp89_ = self->priv->hardwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp89_, FALSE);
	_tmp90_ = self->priv->softwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp90_, FALSE);
	_tmp92_ = self->priv->currentSettings;
	_tmp93_ = settings_get_handshake (_tmp92_);
	_tmp94_ = _tmp93_;
	if (_tmp94_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp91_ = TRUE;
	} else {
		Settings* _tmp95_;
		SettingsHandshake _tmp96_;
		SettingsHandshake _tmp97_;
		_tmp95_ = self->priv->currentSettings;
		_tmp96_ = settings_get_handshake (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ == SETTINGS_HANDSHAKE_HARDWARE;
	}
	_tmp98_ = _tmp91_;
	if (_tmp98_) {
		GtkCheckButton* _tmp99_;
		_tmp99_ = self->priv->hardwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp99_, TRUE);
	}
	_tmp101_ = self->priv->currentSettings;
	_tmp102_ = settings_get_handshake (_tmp101_);
	_tmp103_ = _tmp102_;
	if (_tmp103_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp100_ = TRUE;
	} else {
		Settings* _tmp104_;
		SettingsHandshake _tmp105_;
		SettingsHandshake _tmp106_;
		_tmp104_ = self->priv->currentSettings;
		_tmp105_ = settings_get_handshake (_tmp104_);
		_tmp106_ = _tmp105_;
		_tmp100_ = _tmp106_ == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	_tmp107_ = _tmp100_;
	if (_tmp107_) {
		GtkCheckButton* _tmp108_;
		_tmp108_ = self->priv->softwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp108_, TRUE);
	}
	_tmp109_ = self->priv->currentSettings;
	_tmp110_ = settings_get_localEcho (_tmp109_);
	_tmp111_ = _tmp110_;
	if (_tmp111_) {
		GtkCheckButton* _tmp112_;
		_tmp112_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp112_, TRUE);
	} else {
		GtkCheckButton* _tmp113_;
		_tmp113_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp113_, FALSE);
	}
	_g_object_unref0 (t);
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = NULL;
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	gchar* device = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	GtkTreeModel* t = NULL;
	GtkTreeIter iter = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GtkComboBox* _tmp14_;
	gint _tmp15_ = 0;
	const gchar* _tmp16_;
	gint _tmp17_ = 0;
	GtkComboBox* _tmp18_;
	gint _tmp19_ = 0;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	GtkComboBox* _tmp22_;
	gint _tmp23_ = 0;
	const gchar* _tmp24_;
	gint _tmp25_ = 0;
	GtkComboBox* _tmp26_;
	gint _tmp27_ = 0;
	GtkComboBox* _tmp28_;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	GtkCheckButton* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp35_;
	GtkCheckButton* _tmp40_;
	gboolean _tmp41_ = FALSE;
	const gchar* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	SettingsParity _tmp46_;
	SettingsHandshake _tmp47_;
	SettingsAccessMode _tmp48_;
	Settings* _tmp49_;
	Settings* _tmp50_;
	Settings* _tmp51_;
	Settings* _tmp52_;
	GtkDialog* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = self->priv->deviceCombo;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	success = _tmp5_;
	_tmp6_ = success;
	if (_tmp6_) {
		GValue str_data = {0};
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GValue _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp7_ = t;
		_tmp8_ = iter;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (device);
		device = _tmp11_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = settings_DEFAULT_DEVICEFILE;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (device);
		device = _tmp13_;
	}
	_tmp14_ = self->priv->baudRateCombo;
	_tmp15_ = gtk_combo_box_get_active (_tmp14_);
	_tmp16_ = SETTINGS_BaudRateItems[_tmp15_];
	_tmp17_ = atoi (_tmp16_);
	baudRate = _tmp17_;
	_tmp18_ = self->priv->dataBitsCombo;
	_tmp19_ = gtk_combo_box_get_active (_tmp18_);
	_tmp20_ = SETTINGS_DataBitItems[_tmp19_];
	_tmp21_ = atoi (_tmp20_);
	dataBits = _tmp21_;
	_tmp22_ = self->priv->stopBitsCombo;
	_tmp23_ = gtk_combo_box_get_active (_tmp22_);
	_tmp24_ = SETTINGS_StopBitItems[_tmp23_];
	_tmp25_ = atoi (_tmp24_);
	stopBits = _tmp25_;
	_tmp26_ = self->priv->parityCombo;
	_tmp27_ = gtk_combo_box_get_active (_tmp26_);
	parity = (SettingsParity) _tmp27_;
	_tmp28_ = self->priv->accessModeCombo;
	_tmp29_ = gtk_combo_box_get_active (_tmp28_);
	accessMode = (SettingsAccessMode) _tmp29_;
	_tmp31_ = self->priv->hardwareHandshake;
	_tmp32_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_);
	if (_tmp32_) {
		GtkCheckButton* _tmp33_;
		gboolean _tmp34_ = FALSE;
		_tmp33_ = self->priv->softwareHandshake;
		_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
		_tmp30_ = _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	_tmp35_ = _tmp30_;
	if (_tmp35_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		GtkCheckButton* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp36_ = self->priv->hardwareHandshake;
		_tmp37_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp36_);
		if (_tmp37_) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			GtkCheckButton* _tmp38_;
			gboolean _tmp39_ = FALSE;
			_tmp38_ = self->priv->softwareHandshake;
			_tmp39_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp38_);
			if (_tmp39_) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	_tmp40_ = self->priv->localEcho;
	_tmp41_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp40_);
	pLocalEcho = _tmp41_;
	_tmp42_ = device;
	_tmp43_ = baudRate;
	_tmp44_ = dataBits;
	_tmp45_ = stopBits;
	_tmp46_ = parity;
	_tmp47_ = handshake;
	_tmp48_ = accessMode;
	_tmp49_ = settings_new (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_, pLocalEcho);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp49_;
	_tmp50_ = self->priv->settings;
	_tmp51_ = _g_object_ref0 (_tmp50_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp51_;
	_tmp52_ = self->priv->currentSettings;
	g_signal_emit_by_name (self, "update-settings", _tmp52_);
	_tmp53_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp53_);
	_g_object_unref0 (t);
	_g_free0 (device);
}


GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self) {
	GtkBuilder* result;
	GtkBuilder* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_builder;
	result = _tmp0_;
	return result;
}


static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp0_;
	GtkBuilder* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_builder);
	self->priv->_builder = _tmp1_;
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = moserial_settings_dialog_hide (self);
	return result;
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel (self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok (self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkDialog* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkButton* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkComboBox* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkBuilder* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkComboBox* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkComboBox* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkCheckButton* _tmp27_;
	GtkCheckButton* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkCheckButton* _tmp32_;
	GtkCheckButton* _tmp33_;
	const gchar* _tmp34_ = NULL;
	GtkBuilder* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkComboBox* _tmp37_;
	GtkComboBox* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkCheckButton* _tmp41_;
	GtkCheckButton* _tmp42_;
	const gchar* _tmp43_ = NULL;
	GtkDialog* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkBuilder* _tmp47_;
	GObject* _tmp48_ = NULL;
	GtkComboBox* _tmp49_;
	GtkListStore* _tmp50_;
	GtkComboBox* _tmp51_;
	GtkListStore* _tmp52_;
	GtkCellRendererText* _tmp53_;
	GtkCellRenderer* _tmp54_;
	GtkCellRenderer* deviceCell;
	GtkComboBox* _tmp55_;
	GtkCellRenderer* _tmp56_;
	GtkComboBox* _tmp57_;
	GtkCellRenderer* _tmp58_;
	parent_class = G_OBJECT_CLASS (moserial_settings_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "settings_dialog");
	_tmp2_ = _g_object_ref0 (GTK_DIALOG (_tmp1_));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp2_;
	_tmp3_ = self->priv->_builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "settings_cancel_button");
	_tmp5_ = _g_object_ref0 (GTK_BUTTON (_tmp4_));
	_g_object_unref0 (self->priv->cancelButton);
	self->priv->cancelButton = _tmp5_;
	_tmp6_ = self->priv->_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "settings_ok_button");
	_tmp8_ = _g_object_ref0 (GTK_BUTTON (_tmp7_));
	_g_object_unref0 (self->priv->okButton);
	self->priv->okButton = _tmp8_;
	_tmp9_ = self->priv->_builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "settings_baud_rate");
	_tmp11_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp10_));
	_g_object_unref0 (self->priv->baudRateCombo);
	self->priv->baudRateCombo = _tmp11_;
	_tmp12_ = self->priv->baudRateCombo;
	mo_utils_populateComboBox (_tmp12_, SETTINGS_BaudRateItems, G_N_ELEMENTS (SETTINGS_BaudRateItems));
	_tmp13_ = self->priv->_builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "settings_data_bits");
	_tmp15_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp14_));
	_g_object_unref0 (self->priv->dataBitsCombo);
	self->priv->dataBitsCombo = _tmp15_;
	_tmp16_ = self->priv->dataBitsCombo;
	mo_utils_populateComboBox (_tmp16_, SETTINGS_DataBitItems, G_N_ELEMENTS (SETTINGS_DataBitItems));
	_tmp17_ = self->priv->_builder;
	_tmp18_ = gtk_builder_get_object (_tmp17_, "settings_stop_bits");
	_tmp19_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp18_));
	_g_object_unref0 (self->priv->stopBitsCombo);
	self->priv->stopBitsCombo = _tmp19_;
	_tmp20_ = self->priv->stopBitsCombo;
	mo_utils_populateComboBox (_tmp20_, SETTINGS_StopBitItems, G_N_ELEMENTS (SETTINGS_StopBitItems));
	_tmp21_ = self->priv->_builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "settings_parity");
	_tmp23_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp22_));
	_g_object_unref0 (self->priv->parityCombo);
	self->priv->parityCombo = _tmp23_;
	_tmp24_ = self->priv->parityCombo;
	mo_utils_populateComboBox (_tmp24_, SETTINGS_ParityModeStrings, G_N_ELEMENTS (SETTINGS_ParityModeStrings));
	_tmp25_ = self->priv->_builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "settings_hardware_handshake");
	_tmp27_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp26_));
	_g_object_unref0 (self->priv->hardwareHandshake);
	self->priv->hardwareHandshake = _tmp27_;
	_tmp28_ = self->priv->hardwareHandshake;
	_tmp29_ = _ ("Also known as RTS/CTS handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp29_);
	_tmp30_ = self->priv->_builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "settings_software_handshake");
	_tmp32_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp31_));
	_g_object_unref0 (self->priv->softwareHandshake);
	self->priv->softwareHandshake = _tmp32_;
	_tmp33_ = self->priv->softwareHandshake;
	_tmp34_ = _ ("Also known as XON/XOFF handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp33_, _tmp34_);
	_tmp35_ = self->priv->_builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "settings_open_for");
	_tmp37_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp36_));
	_g_object_unref0 (self->priv->accessModeCombo);
	self->priv->accessModeCombo = _tmp37_;
	_tmp38_ = self->priv->accessModeCombo;
	mo_utils_populateComboBox (_tmp38_, SETTINGS_AccessModeStrings, G_N_ELEMENTS (SETTINGS_AccessModeStrings));
	_tmp39_ = self->priv->_builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "settings_local_echo");
	_tmp41_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp40_));
	_g_object_unref0 (self->priv->localEcho);
	self->priv->localEcho = _tmp41_;
	_tmp42_ = self->priv->localEcho;
	_tmp43_ = _ ("Normally disabled");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp42_, _tmp43_);
	_tmp44_ = self->priv->dialog;
	g_signal_connect_object ((GtkWidget*) _tmp44_, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
	_tmp45_ = self->priv->cancelButton;
	g_signal_connect_object (_tmp45_, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
	_tmp46_ = self->priv->okButton;
	g_signal_connect_object (_tmp46_, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
	_tmp47_ = self->priv->_builder;
	_tmp48_ = gtk_builder_get_object (_tmp47_, "settings_device");
	_tmp49_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp48_));
	_g_object_unref0 (self->priv->deviceCombo);
	self->priv->deviceCombo = _tmp49_;
	_tmp50_ = gtk_list_store_new (1, G_TYPE_STRING);
	_g_object_unref0 (self->priv->deviceModel);
	self->priv->deviceModel = _tmp50_;
	_tmp51_ = self->priv->deviceCombo;
	_tmp52_ = self->priv->deviceModel;
	gtk_combo_box_set_model (_tmp51_, (GtkTreeModel*) _tmp52_);
	_tmp53_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp54_ = (GtkCellRenderer*) g_object_ref_sink (_tmp53_);
	deviceCell = _tmp54_;
	_tmp55_ = self->priv->deviceCombo;
	_tmp56_ = deviceCell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp55_, _tmp56_, FALSE);
	_tmp57_ = self->priv->deviceCombo;
	_tmp58_ = deviceCell;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp57_, _tmp58_, "text", 0, NULL);
	_g_object_unref0 (deviceCell);
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SETTINGS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->deviceModel);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}


static void _vala_moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_settings_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		moserial_settings_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



